
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_recv_bexid.psl.c
   ----- CREATED   : by ttakagi@icot22, on Thu Mar 19 12:57:39 1992
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 17:47:04 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
%request_BEXID_WEX$B$N<u?.=hM}(B

       written by nakase@icot22      on Mon Aug 20 17:57:09 1990

$B%Q%1%C%H7A<0(B

      39       31                              0
       +---------------------------------------+
    1  | DNTC   !  _NW_REQUEST_BEXID_WEX       |
       +---------------------------------------+
    2  | DNTC   !  BEXID$B$rMW5a$9$k30It;2>H#I#D(B |
       +---------------------------------------+
    3  | DNTC   !  BEXID$B$NJV?.@h(B               |
       +---------------------------------------+
    4  |           $B#E#O#M(B                      |
       +---------------------------------------+


<Arguments>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkReq_BEXID_Data XXX

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Request_BEXID_WEX_Sub(A_PacketPtr)
{
  $USE(D_WorkReq_BEXID_Data);
  $USE(D_WorkReturnExRefID);
  $USE(D_WorkSafeFlag);

  f_Get_Req_BEXID_WEX_Data_fromLogicalPacket(A_PacketPtr, D_WorkReq_BEXID_Data,
					 D_WorkSafeFlag);
  f_Get_ReturnExRefID_fromLogicalPacket(A_PacketPtr, D_WorkReturnExRefID);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  $CALL (f_Send_IntClMsg_Supply_BEXID_Sub
	 (D_WorkReq_BEXID_Data, D_WorkReturnExRefID, D_WorkSafeFlag, D_ALL1) );
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkSafeFlag);
  $RELEASE(D_WorkReturnExRefID);
  $RELEASE(D_WorkReq_BEXID_Data);

  $RETURN();
}

/******************************************************************** PSL **
%request_BEXID_BEX$B$N<u?.=hM}(B

       written by nakase@icot22      on Wed Aug 29 13:48:00 1990

$B%Q%1%C%H7A<0(B

      39       31                              0
       +---------------------------------------+
    1  | DNTC   !  _NW_REQUEST_BEXID_BEX       |
       +---------------------------------------+
    2  | DNTC   !  BEXID$B$rMW5a$9$k30It;2>H#I#D(B |
       +---------------------------------------+
    3  | DNTC   !  WEC                         |
       +---------------------------------------+
    4  | DNTC   !  BEXID$B$NJV?.@h(B               |
       +---------------------------------------+
    5  |           $B#E#O#M(B                      |
       +---------------------------------------+

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkSafeFlag XXX

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Request_BEXID_BEX_Sub(A_PacketPtr)
{
  $USE(D_WorkReq_BEXID_Data);
  $USE(D_WorkReturnExRefID);
  $USE(D_WorkSafeFlag);
  $USE(D_WorkStructID);

  f_Get_Req_BEXID_BEX_Data_fromLogicalPacket
         (A_PacketPtr, D_WorkReq_BEXID_Data, D_WorkSafeFlag, D_WorkStructID);
  f_Get_ReturnExRefID_fromLogicalPacket(A_PacketPtr, D_WorkReturnExRefID);

  s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
  $CALL( f_Send_IntClMsg_Supply_BEXID_Sub
	                 (D_WorkReq_BEXID_Data, D_WorkReturnExRefID,
			  D_WorkSafeFlag, D_WorkStructID) );
  s_RecordMsgDecodeStart(); /*** for Processor Profile ***/

  $RELEASE(D_WorkStructID);
  $RELEASE(D_WorkSafeFlag);
  $RELEASE(D_WorkReturnExRefID);
  $RELEASE(D_WorkReq_BEXID_Data);

  $RETURN();
}

/******************************************************************** PSL **
Supply_BEXID$B%a%C%;!<%8$N<u?.(B

       written by nakase@icot22      on Wed Aug 29 16:06:34 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkSupplyBEXID_Data XXX

#SUBARG_define A_PacketPtr MODIFY

#SUBROUTINE f_Recv_IntClMsg_Supply_BEXID_Sub(A_PacketPtr)
{
  $USE(D_WorkExCellPtr);
  f_Get_Answer_Return_Data_fromLogicalPacket(A_PacketPtr, D_WorkExCellPtr);

  $USE(D_WorkSupplyBEXID_Data);
  $CALL( f_Get_Data_Level0_SupplyBEXID_fromLogicalPacket_Sub
	                  (A_PacketPtr,D_WorkSupplyBEXID_Data ) );
				/* $BJV?.%G!<%?$rFI$_9~$`(B */
  $USE(D_WorkExCell);
 ExCellLockRetry:
  p_Read(D_WorkExCellPtr,D_WorkExCell);
  s_IfEXLOCK(D_WorkExCell){
    goto ExCellLockRetry;
  }
  s_IfFailSoftLockExCell(D_WorkExCellPtr, D_WorkExCell) {
    /* ExCell$B$rC)$j$=$N@h$r2rJ|$9$k$?$a!"(BExCell$B$K%m%C%/$r3]$1$k(B
       $B@.8y$9$k$^$G7+$jJV$9(B                                     */
    goto ExCellLockRetry;
  }

  TypeSwitch(D_WorkExCell){
    case RDHOK:
      s_MRBonReg(D_WorkSupplyBEXID_Data);
      p_Write(D_WorkSupplyBEXID_Data, D_WorkExCellPtr);

      @DEBUG{
	$USE(D_WorkBImpRec);
	s_GetPtrToImpRecRdhokRec(D_WorkExCell, D_WorkBImpRec);
	b_IfNotEOL(D_WorkBImpRec) { 
	  b_IfNotFLC(D_WorkBImpRec) {
	    /* ReadHook$B%;%k$N@h$K!"M"F~%l%3!<%I$,$D$J$,$C$F$$$?;~(B */
	    VPIM_ERROR("f_Recv_IntClMsg_Supply_BEXID_Sub","Invalid Rdhok");
	  }
	}
	$RELEASE(D_WorkBImpRec);
      };

      $USE(D_WorkSuspendGoal);
      s_GetGoalsRdhokRec(D_WorkExCell, D_WorkSuspendGoal);
      s_ReclaimEntryOfRdhokRec(D_WorkExCell);
      b_IfNotEOL(D_WorkSuspendGoal) {
	s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
	$CALL( f_WakeUpProcess_Sub(D_WorkSuspendGoal) );
	s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
	/* RDHOK$B%l%3!<%I$K7R$,$l$F$$$?%4!<%k$r5/$3$9(B */
      } /* else ( alternatively $B$K$h$k(B %read $BAw=P$N>l9g!"(B
		 $B%4!<%k$,$D$J$,$C$F$$$J$$2DG=@-$,$"$k(B) */
      $RELEASE(D_WorkSuspendGoal);

      break;
    case REF:
    case ConstantGroup():
    case StructureGroup():
    case MOD:
    case COD:
      /* %Supply_BEXID$B$h$j@h$K!"(B%Answer_Value$BEy$G(BRDHOK$B%;%k$,6qBN2=$5$l$F(B
	 $B$$$?;~$O!"2?$b$7$J$$!#(B
	 $BM"F~$5$l$?%G!<%?$O!"0l3g#G#C$G<+A3$K(BRelease$B$5$l$k!#(B
	 $B<+J,$+$i(BReleases$B$r=P$7$F$bNI$$(B */  
      @DEBUG {
	WARNING("f_Recv_IntClMsg_Supply_BEXID_Sub",
		"Not necessary to supply BEXID");
      };
      s_SoftUnlockExCell(D_WorkExCellPtr, D_WorkExCell);
      break;
    default:
      @DEBUG {
	VPIM_ERROR("f_Recv_IntClMsg_Supply_BEXID_Sub","invalid ex_cell");
      };
      break;
  }

  $RELEASE(D_WorkExCell);
  $RELEASE(D_WorkSupplyBEXID_Data);
  $RELEASE(D_WorkExCellPtr);

$RETURN();
}
