
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_recv_answer_value.psl.c
   ----- CREATED   : by nakase@icot22, on Wed Jun 20 15:59:39 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 12 17:45:21 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : %Answer_value$B%a%C%;!<%8$N<u?.=hM}(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
  
  %Answer_Value$B%a%C%;!<%8$N<u?.=hM}(B

       written by nakase@icot22      on Wed Jun 20 16:01:56 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define 	D_WorkSuspendGoal 	 XXX
#DATA_define 	D_WorkReplyData 	 XXX
#DATA_define 	D_WorkExCellPtr    	 XXX
#DATA_define	D_WorkBImpRec		 XXX
#DATA_define    D_WorkPtrToLogicalPacket XXX
#DATA_define    D_WorkWexrefID           XXX
#DATA_define    D_WorkStructFlag         XXX

#ADDR_define _PACKET_EXREF_ID_OFST 2

#SUBARG_define A_PacketPtr     MODIFY
#SUBARG_define A_RealPacketPtr SRC
#SUBARG_define A_FlagReg       DST

#SUBROUTINE f_Recv_IntClMsg_Answer_Value_Sub
                   (A_PacketPtr, A_RealPacketPtr, A_FlagReg)
{
  $USE(D_WorkPtrToLogicalPacket);
  p_MoveWord(A_PacketPtr, D_WorkPtrToLogicalPacket);
  /* $BESCf$G(BGC$B$,5/$-$F!"%a%C%;!<%8$NE83+$r%5%9%Z%s%I$9$k;~$N$?$a$K(B
     A_PacketPtr $B$O!"J]B8$7$F$*$/(B */
  $USE(D_WorkExCellPtr);
  f_Get_Answer_Return_Data_fromLogicalPacket
                          (D_WorkPtrToLogicalPacket, D_WorkExCellPtr);

  $USE(D_WorkExCell);
 ExCellLockRetry:
  p_Read(D_WorkExCellPtr, D_WorkExCell);
  s_IfEXLOCK(D_WorkExCell) {
    goto ExCellLockRetry;
  }
  s_IfFailSoftLockExCell(D_WorkExCellPtr, D_WorkExCell){
    /* ExCell$B$rC)$j$=$N@h$r2rJ|$9$k$?$a!"(BExCell$B$K%m%C%/$r3]$1$k(B
       $B@.8y$9$k$^$G7+$jJV$9(B                                     */
    goto ExCellLockRetry;
  }
  
  $USE(D_WorkReplyData);
  $USE(D_WorkStructFlag);
  $CALL( f_Get_Data_Level1_fromLogicalPacket_Sub
           (D_WorkPtrToLogicalPacket, D_WorkReplyData, D_WorkStructFlag) );
				/* $BJV?.%G!<%?$rFI$_9~$`(B */

  @DEBUG{
    b_IfEqual(D_WorkReplyData, D_WorkExCellPtr){
      VPIM_ERROR("f_Recv_IntClMsg_Answer_Value_Sub","invalid reply data");} };

  b_IfIllegalPointer(D_WorkReplyData) {
    @DEBUG{ WARNING("f_Recv_IntClMsg_Answer_Value_Sub","data get suspend"); };
    s_SoftUnlockExCell(D_WorkExCellPtr, D_WorkExCell);
    $USE(D_WorkWexrefID);
    s_AllocReadReturnWhiteExpEntry(D_WorkExCellPtr, D_WorkWexrefID);
    p_WriteWithOffset(D_WorkWexrefID, A_RealPacketPtr, _PACKET_EXREF_ID_OFST);
    $RELEASE(D_WorkWexrefID);
    $USE(D_WorkPtrToMsgSuspRec);
    s_AllocMsgSuspRec(D_WorkPtrToMsgSuspRec);
    s_PutSuspMsgID_MsgSuspRec(_MSG_SUSP_RECV_PACKET, D_WorkPtrToMsgSuspRec);
    s_PutMsgInfo1_MsgSuspRec(A_RealPacketPtr, D_WorkPtrToMsgSuspRec);
    s_PutMsgInfo2_MsgSuspRec(D_NULL, D_WorkPtrToMsgSuspRec); /* $BG0$N$?$a(B */
    s_PushMsgSuspRec(D_WorkPtrToMsgSuspRec);
    $RELEASE(D_WorkPtrToMsgSuspRec);
    p_MoveWord(D_ONE, A_FlagReg);
  } else {
    s_IfMOD(D_WorkReplyData){
      b_IfRegFlagOn(D_WorkStructFlag){
	/* $B%3!<%I%b%8%e!<%k0J30$N%G!<%?$b9=B$BN4IM}$9$k;~$O!"B>$N>r7o$bI,MW(B */
	s_RehashStrAddrHash(D_WorkExCellPtr, D_WorkReplyData);
	/* $B9=B$BN$N%"%I%l%9$,JQ2=$7$?$?$a!"%j%O%C%7%e$9$k!#(B */
      } else {
	;
      }
    }
    f_ReceiveAnswerValue_Body(D_WorkExCellPtr, D_WorkExCell, D_WorkReplyData);
  }

  $RELEASE(D_WorkPtrToLogicalPacket);
  $RELEASE(D_WorkReplyData);
  $RELEASE(D_WorkExCell);
  $RELEASE(D_WorkExCellPtr);
  $RELEASE(D_WorkStructFlag);
  $RETURN();
}

#PSL_define f_ReceiveAnswerValue_Body(ptr_to_excell, excell, rcvd_data)
{
  @DEBUG{
    s_IfKL1TypeErr(rcvd_data){
      VPIM_ERROR("f_ReceiveAnswerValue_Body","invalid answered data");
    }
  };
  TypeSwitch(excell) {
    case HOOK:  /* $B3+J|M"=P$5$l$?$b$N!"C10l;2>H$G$"$k(B */
    case RHOOK:
      /* f_W_SendWEX_SingleWait $B$GAw=P$5$l$?(B %read $B$KBP$9$k1~Ez$N>l9g(B */
      /* $BB>$K$3$N(BHOOK$B%;%k$K=q$-9~$`2DG=@-$N$"$k%Q%9$,$J$$$N$G!"(B
       * $BGSB>@)8f$J$7$G=q$-9~$`$3$H$,=PMh$k(B
       */
      @DEBUG{
	s_IfMRBon(rcvd_data) { 
	  WARNING("f_ReceiveAnswerValue_Body","MRBon data at HOOK");
	}
      };  /* DEBUG by ttakagi */
      p_Write(rcvd_data, ptr_to_excell);
                /* $BJV?.CM$r30It;2>H%;%k$K=q$-9~$`$HF1;~$K!"(B
		   $B30It;2>H%;%k$N%=%U%H%m%C%/$r30$9!#(B */
      s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
      $CALL( f_WakeUpProcess_Sub(excell) );
      s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
      break;
    case RDHOK: /* $B3+J|M"=P$G$-$J$+$C$?;~(B */
      s_MRBonReg(rcvd_data);
      p_Write(rcvd_data, ptr_to_excell);
                /* $BJV?.CM$r30It;2>H%;%k$K=q$-9~$`$HF1;~$K!"(B
		   $B30It;2>H%;%k$N%=%U%H%m%C%/$r30$9!#(B */
      $USE(D_WorkBImpRec);
      s_GetPtrToImpRecRdhokRec(excell, D_WorkBImpRec);

      @DEBUG{
	b_IfFLC(D_WorkBImpRec) {
	  VPIM_ERROR("f_ReceiveAnswerValue_Body","Invalid Rdhok Rec");
	}
      };

      b_IfNotIllegalPointer(D_WorkBImpRec) { 
	/* ReadHook$B%;%k$N@h$K!"M"F~%l%3!<%I$,$D$J$,$C$F$$$?;~(B */
	s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
	$CALL( f_Send_IntClMsg_Release_Sub(D_WorkBImpRec) );
	s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
      }

      $RELEASE(D_WorkBImpRec);

      $USE(D_WorkSuspendGoal);
      s_GetGoalsRdhokRec(excell, D_WorkSuspendGoal);
      s_ReclaimEntryOfRdhokRec(excell);
      b_IfNotEOL(D_WorkSuspendGoal) {
	s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
	$CALL( f_WakeUpProcess_Sub(D_WorkSuspendGoal) );
	s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
      } /* else ( alternatively $B$K$h$k(B %read $BAw=P$N>l9g!"(B
		 $B%4!<%k$,$D$J$,$C$F$$$J$$2DG=@-$,$"$k(B) */
      $RELEASE(D_WorkSuspendGoal);

      break;
    case REF:
      @DEBUG {
	WARNING("f_ReceiveAnswerValue_Body",
		"Supply_BEXID is received before Answer_Value");
      };
      /* %Supply_BEXID$B$,(B%Answer_Value$B$h$j$b@h$KE~Ce$7$?>l9g!#(B
	 $B2?$b$7$J$$$G=*N;$9$k!#(B%Answer_Value$B$GM"F~$7$?%G!<%?$O!"0l3g(BGC$B$G(B
	   $B=hM}$5$l$k!#(B */  
      s_SoftUnlockExCell(ptr_to_excell, excell);
      break;
    case EXLOCK:
    case ExvalGrp():
    case ExrefGrp():
    case ConstantGroup():
    case StructureGroup():
    case ControlGroup():
      @DEBUG {
	VPIM_ERROR("f_ReceiveAnswerValue_Body",
		   "EX-Cell is unified without %AnswerValue");
      };
      break;
    default:
      @DEBUG{ VPIM_ERROR("f_ReceiveAnswerValue_Body","undefined type"); };
      break;
  }
}
