
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_get_logical_packet_data.psl.c
   ----- CREATED   : by ttakagi@icot22, on Tue May 29 17:46:29 1990
   ----- LAST SAVED: by ttakagi@icot22, on Wed Jun 17 12:56:05 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : $BO@M}%Q%1%C%H$KF~$l$k%G!<%?$rF@$k(B

1. $B9=B$%G!<%?M"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B
2. $B%b%8%e!<%kM"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B
3. $B%3!<%IM"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B
4. $BJQ?tM"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B

5. $B30It;2>H%;%k$+$iAw?.@h%/%i%9%?HV9f$rF@$k(B
6. $BN$?F$+$i#W#T#C$HAq1`#I#D$rF@$k!#(B

7. %read, %unify$B$N0z?t#1$N@h$N9u30It;2>H(BID$B!&(BWEC$B$rF@$k(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B9=B$%G!<%?M"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B

$BGr%Q%9$N>l9g(B
f_GetLogicalPacketData_W_StructureGroup
$B9u%Q%9$N>l9g(B
f_GetLogicalPacketData_B_StructureGroup

       written by ttakagi@icot22      on Fri Jun  8 11:48:26 1990

<Arguments>
+ ptr_to_data:  $BM"=P$9$k9=B$%G!<%?$X$N%]%$%s%?(B
- exref_id_reg: $BM"=P$9$k9=B$%G!<%?$N9=B$BN#I#D(B
- wec_reg:      $B9=B$BN%G!<%?M"=P;~$K$D$1$k#W#E#C(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_GetLogicalPacketData_W_StructureGroup(ptr_to_data, exref_id_reg)
{
  s_AllocWhiteExpEntry(ptr_to_data, exref_id_reg);
  s_SetClusterNum(exref_id_reg, D_CL_Number);
  b_SetImmTypeMRBoff(WEXVAL, exref_id_reg);
}

#PSL_define f_GetLogicalPacketData_B_StructureGroup
				(ptr_to_data, exref_id_reg, wec_reg)
{
  @PROBE{ p_MoveWord(D_NULL, D_REFIND_BEXP_MOD_OR_NOT_FLAG); };
  $CALL( s_AllocBlackExpEntry_Sub(ptr_to_data, exref_id_reg) );
  s_SetClusterNum(exref_id_reg, D_CL_Number);
  b_SetImmTypeMRBoff(BEXVAL, exref_id_reg);
  b_MoveWithImmTypeMRBoff(D_EXPORT_WEC_UNIT, DNTC, wec_reg);
}

/******************************************************************** PSL **
2. $B%b%8%e!<%kM"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B

f_GetLogicalPacketData_Module

       written by ttakagi@icot22      on Fri Jun  8 12:06:03 1990

<Arguments>
+ ptr_to_module: $B%b%8%e!<%k$X$N%]%$%s%?(B
- struct_id_reg: $BM"=P$9$k%b%8%e!<%k$N9=B$BN#I!J(BType MODx$B!K(B
- exref_id_reg:  $BM"=P$9$k%b%8%e!<%k$N30It;2>H#I#D(B
- wec_reg:       $B%b%8%e!<%kM"=P;~$K$D$1$k#W#E#C(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_GetLogicalPacketData_Module(ptr_to_module, struct_id_reg, 
					  exref_id_reg, wec_reg)
{
  $CALL( s_GetStructIdStrRec_Sub(ptr_to_module, struct_id_reg) );
  b_SetImmTypeMRBon(MOD, struct_id_reg);
  @PROBE{ p_MoveWord(D_ONE, D_REFIND_BEXP_MOD_OR_NOT_FLAG); };
  $CALL( s_AllocBlackExpEntry_Sub(ptr_to_module, exref_id_reg) );  
  b_BitwiseOrWithDNTC
        (D_BEXVAL_SAFE_STRUCTon_UNIFYoff_CLnum, exref_id_reg, exref_id_reg);
  b_SetImmTypeMRBoff(BEXVAL, exref_id_reg);
  b_MoveWithImmTypeMRBoff(D_EXPORT_WEC_UNIT, DNTC, wec_reg);
}  

/******************************************************************** PSL **
3. $B%3!<%IM"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B

f_GetLogicalPacketData_Code

       written by ttakagi@icot22      on Fri Jun  8 12:14:53 1990

<Arguments>
+ ptr_to_goal:     $BM"=P$9$k%3!<%I$r;}$C$?!"%4!<%k$X$N%]%$%s%?(B
- struct_id_reg:   $BM"=P$9$k%3!<%I$N9=B$BN#I#D!J(BType CODx$B!K(B
- exref_id_reg:    $BM"=P$9$k%3!<%I$N30It;2>H#I#D(B
- wec_reg:         $B%3!<%IM"=P;~$K$D$1$k#W#E#C(B
- code_offset_reg: $B%3!<%I$N%b%8%e!<%kFb%*%U%;%C%H(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkModuleTop		XXX

#PSL_define f_GetLogicalPacketData_Code
	(ptr_to_code, struct_id_reg, exref_id_reg, wec_reg, code_offset_reg)
{
  $USE(D_WorkModuleTop);
  s_GetModuleTopFromCode(ptr_to_code,D_WorkModuleTop);
  s_GetPredOffset(ptr_to_code,D_WorkModuleTop,code_offset_reg);
  b_SetImmTypeMRBoff(DNTC, code_offset_reg);
  $CALL( s_GetStructIdStrRec_Sub(D_WorkModuleTop, struct_id_reg) );

  b_SetImmTypeMRBon(COD, struct_id_reg);
  @PROBE{ p_MoveWord(D_ONE, D_REFIND_BEXP_MOD_OR_NOT_FLAG); };
  $CALL( s_AllocBlackExpEntry_Sub(D_WorkModuleTop, exref_id_reg) );
  $RELEASE(D_WorkModuleTop);
  b_BitwiseOrWithDNTC
        (D_BEXVAL_SAFE_STRUCTon_UNIFYoff_CLnum, exref_id_reg, exref_id_reg);
  b_SetImmTypeMRBoff(BEXVAL, exref_id_reg);

  b_MoveWithImmTypeMRBoff(D_EXPORT_WEC_UNIT, DNTC, wec_reg);
}

/******************************************************************** PSL **
4. $BJQ?tM"=P;~$NO@M}%Q%1%C%H%G!<%?$rF@$k(B

f_GetLogicalPacketData_W_UnboundGroup
f_GetLogicalPacketData_B_UnboundGroup

       written by ttakagi@icot22      on Tue Jul 10 14:40:36 1990

<Arguments>
[$BGrJQ?t$N;~(B]
+  ptr_to_data  $BM"=P$5$l$kJQ?t$X$N%]%$%s%?(B
-  exref_id_reg $B30It;2>H(BID
+  rcv_cl_num   $BAw?.@h%/%i%9%?HV9f(B

[$B9uJQ?t$N;~(B]
+  ptr_to_data  $BM"=P$5$l$kJQ?t$X$N%]%$%s%?(B
-  exref_id_reg $B30It;2>H(BID
-  wec_reg      $B3d$jEv$F$i$l$?(BWEC
+  rcv_cl_num   $BAw?.@h%/%i%9%?HV9f(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_GetLogicalPacketData_W_UnboundGroup
                        (ptr_to_data, exref_id_reg, rcv_cl_num)
{
  s_AllocWhiteExpEntry(ptr_to_data, exref_id_reg);
  b_BitwiseOrWithTag
         (D_WEXREF_SAFE_STRUCToff_UNIFYoff_CLnum, exref_id_reg, exref_id_reg);
}

#PSL_define f_GetLogicalPacketData_B_UnboundGroup
			(ptr_to_data, exref_id_reg, wec_reg, rcv_cl_num)
{
  @PROBE{ p_MoveWord(D_NULL, D_REFIND_BEXP_MOD_OR_NOT_FLAG); };
  $CALL( s_AllocBlackExpEntry_Sub(ptr_to_data, exref_id_reg) );
  b_BitwiseOrWithTag
         (D_BEXREF_SAFE_STRUCToff_UNIFYoff_CLnum, exref_id_reg, exref_id_reg);
  b_MoveWithImmTypeMRBoff(D_EXPORT_WEC_UNIT, DNTC, wec_reg);
}

/******************************************************************** PSL **
5. $B30It;2>H%;%k$+$iAw?.@h%/%i%9%?HV9f$rF@$k(B

f_Get_CLNum_fromExCell

       written by ttakagi@icot22      on Fri Jun 29 16:16:02 1990

<Arguments>
  excell: %read$B$r=P$7$?MW0x$G$"$k30It;2>H%;%k(B
  cl_num:        $BAw?.@h%/%i%9%?HV9f(B($B%l%8%9%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
$B!&Aw?.@h%/%i%9%?HV9f$O%a%C%;!<%8FbMF$rO@M}%Q%1%C%H$K=q$/;~$K$bF@$i$l$k$N$G!"(B
  $B$=$3$GF@$?%/%i%9%?HV9f$r0z?t$+2?$+$GEO$;$P!"$3$N%^%/%m$OI,MW$J$$!#(B
$B!&%3!<%G%#%s%0>e!"$3$N%^%/%m$r;H$&J}$,J,$+$j$d$9$$$,!"8zN($OMn$A$k!#(B
********************************************************************* PSL **/

#DATA_define D_WorkExrefID XXX

#PSL_define f_Get_CLNum_fromExCell(excell, cl_num)
{
  $USE(D_WorkPtrToImpRec);
  s_IfRDHOK(excell) {
    s_GetPtrToImpRecRdhokRec(excell, D_WorkPtrToImpRec);
  } else {
    p_MoveWord(excell, D_WorkPtrToImpRec);
  }
  f_Get_CLNum_fromImpRecPtr(D_WorkPtrToImpRec, cl_num);
  $RELEASE(D_WorkPtrToImpRec);
}

#PSL_define f_Get_CLNum_fromImpRecPtr(ptr_to_imprec, cl_num)
{
  $USE(D_WorkExrefID);
  s_IfWEXT(ptr_to_imprec) {
    s_GetExrefIdWImpRec(ptr_to_imprec, D_WorkExrefID);
  } else {
    s_GetExrefIdBImpRec(ptr_to_imprec, D_WorkExrefID);
  }
  s_GetClusterNum(D_WorkExrefID, cl_num);
  $RELEASE(D_WorkExrefID);
}  

/******************************************************************** PSL **
6. $BN$?F$+$i#W#T#C$HAq1`#I#D$rF@$k!#(B

f_Get_WTCandShoenID_fromFP

       written by ttakagi@icot22      on Tue Jul  3 11:49:30 1990

<Arguments>
  ptr_to_fp:   $BN$?F$X$N%]%$%s%?(B
  request_wtc: $BN$?F$KMW5a$9$k#W#T#C(B
  assign_wtc:  $B<B:]$K6!5k$5$l$k#W#T#C(B
  left_wtc:    $BN$?F$K;D$k#W#T#C(B
  shoen_id:    $BN$?F$,=jB0$9$kAq1`$N#I#D(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B$3$N%^%/%m$OK\Mh(B f_fp_*.psl.c $B$K$"$k$Y$-(B
********************************************************************* PSL **/

#DATA_define D_WorkPtrToBImpRec XXX

#PSL_define f_Get_WTCandShoenID_fromFP
                      (ptr_to_fp, request_wtc, assign_wtc, left_wtc, shoen_id)
{
  $USE(D_WorkPtrToBImpRec);
  s_GetFPImportTableEntry(ptr_to_fp, D_WorkPtrToBImpRec);
  $CALL( s_GetExrefIdAndWtcBImpRecWithoutLock_Sub(D_WorkPtrToBImpRec, 
						  request_wtc, 
						  shoen_id, 
						  assign_wtc, 
						  left_wtc) );
  $RELEASE(D_WorkPtrToBImpRec);
}

/******************************************************************** PSL **
6.1 $BN$?F$K#W#T#C$rJV5Q$9$k(B

f_Return_WTC_toFP

       written by ttakagi@icot22      on Wed Mar  6 16:26:56 1991

<Arguments>
 ptr_to_fp: $BN$?F$X$N%]%$%s%?(B
 wtc_reg:   $BJV5Q$9$k#W#T#C(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_Return_WTC_toFP(ptr_to_fp, wtc_reg)
{
  $USE(D_WorkPtrToBImpRec);
  s_GetFPImportTableEntry(ptr_to_fp, D_WorkPtrToBImpRec);
  $CALL( s_ReturnWtcBImpRec_Sub(D_WorkPtrToBImpRec, wtc_reg) );
  $RELEASE(D_WorkPtrToBImpRec);
}

/******************************************************************** PSL **
6.2 $BN$?F$+$i;q8;$rF@$k(B

f_Get_Resource_fromFP

       written by nakase@icot22      on Sat Jun 23 17:29:47 1990

<Arguments>
  fp_ptr:       $BN$?F$X$N%]%$%s%?(B
  request_imm:  $BN$?F$KBP$7$FMW5a$9$k;q8;$NNL(B($BB(CM(B)
  resource_reg: $B3d$jIU$1$k;q8;(B($B%l%8%9%?=PNO(B)

<Temporally Used Variables>
<Level>
<PreCondition>
  D_Current_FP_Ptr $B$,;X$9N$?F$O%m%C%/:Q$_(B.

<Function>
$B!&:G=i$K%-%c%C%7%e$7$F$"$k;q8;(B'D_ResourceCache'$B$,(B'request_imm'$B$h$j$b(B
  $BBg$-$1$l$P!"(B'request_imm'$B$NNL$N;q8;$r(Bresource_reg$B$KF@$k!#(B
$B!&:G=i$K%-%c%C%7%e$7$F$"$k;q8;(B'D_ResourceCache'$B$,(B'request_imm'$B$h$j$b(B
  $B>.$5$1$l$PN$?F$K;q8;$r$b$i$$$K9T$/!#(B
    $B!&N$?F$N;}$D;q8;$,(B'request_imm'$B$h$jBg$-$1$l$P!"(B
      'request_imm'$B$NNL$N;q8;$r(Bresource_reg$B$KJV$9!#(B
    $B!&N$?F$N;}$D;q8;$,(B'request_imm'$B$h$j>.$5$1$l$P!"(B
      D_NULL$B$r(Bresource_reg$B$KJV$9!#(B

<Examples>
<Test>
<Explanation>
<ETC>
[[ 1989/11/09 Imai ]]
	resource_reg $B$N%?%0$O!"(BDNTC$B$H$9$k(B
  $B$3$N%^%/%m$OK\Mh(B f_fp_*.psl.c $B$K$"$k$Y$-(B
********************************************************************* PSL **/

#DATA_define D_WorkResourceDrawResult XXX

#PSL_define f_Get_Resource_fromFP(fp_ptr, request_imm, resource_reg)
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_ptr, D_WorkFPOrgLockTagReg); 

  b_SetImmValueDNTC(request_imm, resource_reg);

  $USE(D_WorkResourceDrawResult);
  s_DrawResourceFromFP(fp_ptr, D_NULL, resource_reg, D_WorkResourceDrawResult);

  b_IfEqualImm(D_WorkResourceDrawResult, _RESULT_FAIL)
    { /* $BN$?F$K(Brequest_imm$B$N;q8;$,L5$$>l9g$O!"(Bresource_reg$B$r(BD_NULL$B$H$9$k!#(B*/
      p_MoveWord(D_NULL, resource_reg);
    }
  $RELEASE(D_WorkResourceDrawResult);

  s_UnlockFPRecord(fp_ptr, D_WorkFPOrgLockTagReg); 
  $RELEASE(D_WorkFPOrgLockTagReg);
}

/******************************************************************** PSL **
6.3 $BN$?F$K;q8;$rJV5Q$9$k(B

f_Return_Resource_toFP

       written by ttakagi@icot22      on Wed Mar  6 17:40:52 1991

<Arguments>
 ptr_to_fp:    $BN$?F$X$N%]%$%s%?(B
 resource_reg: $BJV5Q$9$k;q8;(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_Return_Resource_toFP(ptr_to_fp, resource_reg)
{
 ; /* $BL$%3!<%G%#%s%0(B */
}

/******************************************************************** PSL **
7. %read, %unify$B$N0z?t#1$N@h$N9u30It;2>H(BID$B!&(BWEC$B$rF@$k(B

       written by nakase@icot22      on Tue Dec 11 20:25:51 1990

<Arguments>
  ptr_to_excell  : $B30It;2>H%;%k$X$N%]%$%s%?(B
  ptr_to_bimp_rec: $B9uM"F~%l%3!<%I$X$N%]%$%s%?(B
  exref_id       : $B30It;2>H(BID$B!J=PNO!K(B
  wec_reg        : $B30It;2>H(BID$B$KIU$/(BWEC$B!J=PNO!K(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_GetExrefIdAndWec_forRead_BEX
                           (ptr_to_excell, ptr_to_bimp_rec, exref_id, wec_reg)
{
  @DEBUG{
    b_IfEOL(ptr_to_bimp_rec){
      VPIM_ERROR("f_GetExrefIdAndWec_forReadOrUnify1_BEX",
		 "Illegal pointer to BImp record");
    }
  };
  s_IfMRBoff(ptr_to_excell) {
    /* $BGr%Q%9(B -> BEX $B$N;~(B */
    $CALL( s_GetExrefIdAllWecAndReclaimBImpRec_Sub
                        (ptr_to_bimp_rec, exref_id, wec_reg) );
    b_IfNotIllegalPointer(ptr_to_bimp_rec) {
      /* $B!{%Q%9(B -> BEX import_flag on$B$N;~(B */
      $CALL( s_GetExrefIdAndWecBImpRec_Sub
                        (ptr_to_bimp_rec, exref_id, wec_reg) );
    }
    /* $B!{%Q%9(B -> BEX import_flag off$B$N;~(B */ 
    /* $BA4(BWEC$B$r<h$j!"9uM"F~%l%3!<%I$,2rJ|$5$l$F$$$k$O$:(B */
  } else {
    /* $B9u%Q%9(B -> BEX $B$N;~(B */
    $CALL( s_GetExrefIdAndWecBImpRec_Sub
                        (ptr_to_bimp_rec, exref_id, wec_reg) );
  }
}

#PSL_define f_GetExrefIdAndWec_forUnify1_BEX
                    (ptr_to_excell, excell, ptr_to_bimp_rec, exref_id, wec_reg)
{
  @DEBUG{
    b_IfEOL(ptr_to_bimp_rec){
      VPIM_ERROR("f_GetExrefIdAndWec_forReadOrUnify1_BEX",
		 "Illegal pointer to BImp record");
    }
  };
  s_IfMRBoff(ptr_to_excell) {
    s_IfRDHOK(excell) {
      /* $BGr%Q%9(B -> RDHOK -> BEX $B$N;~(B */
      /* $BM"F~I=$N2s<}$O(B answer_value $B$KG$$;$k(B */
      $CALL( s_GetExrefIdAndWecBImpRec_Sub
	                       (ptr_to_bimp_rec, exref_id, wec_reg) );
    } else {
      /* $BGr%Q%9(B -> BEX $B$N;~(B */
      $CALL( s_GetExrefIdAllWecAndReclaimBImpRec_Sub
                               (ptr_to_bimp_rec, exref_id, wec_reg) );
      b_IfNotIllegalPointer(ptr_to_bimp_rec) {
	/* $B!{%Q%9(B -> BEX import_flag on$B$N;~(B */
	$CALL( s_GetExrefIdAndWecBImpRec_Sub
                                 (ptr_to_bimp_rec, exref_id, wec_reg) );
      }
      /* $B!{%Q%9(B -> BEX import_flag off$B$N;~(B */ 
      /* $BA4(BWEC$B$r<h$j!"9uM"F~%l%3!<%I$,2rJ|$5$l$F$$$k$O$:(B */
    }
  } else {
    /* $B9u%Q%9(B -> BEX $B$N;~(B */
    $CALL( s_GetExrefIdAndWecBImpRec_Sub
                        (ptr_to_bimp_rec, exref_id, wec_reg) );
  }
}
