
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_int_cl_get_data_from_logical_packet.psl.c
   ----- CREATED   : by nakase@icot22, on Thu Jun 21 19:16:46 1990
   ----- LAST SAVED: by ttakagi(f-takei)@icot22, on Fri Jul 24 19:39:31 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : Functions
   ----- ABSTRACT  : $BO@M}%Q%1%C%H$+$i$N%G!<%?$N<h$j=P$7(B

  $B%M%C%H%o!<%/%a%C%;!<%8<u?.B&$G$N!"O@M}%Q%1%C%H$+$i$N%G!<%?$N<h$j=P$7(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $BO@M}%Q%1%C%H$+$i%l%Y%k#0M"F~$5$l$?%G!<%?$r<h$j=P$9(B
1.1 $B$"$k%G!<%?(B($B%l%Y%k#0M"F~(B)$B$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_Data_Level0_fromLogicalPacket_Sub

       written by nakase@icot22      on Thu Jun 21 21:42:29 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$N8=:_$NFI$_=P$70LCV(B
  A_ImpData:   $B<h$j=P$7$?%G!<%?$b$7$/$O%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B!&%3!<%I$N>l9g$O!"9=B$BN#I#D$rJV$9!#(B
  $B$3$N;~!"30It;2>H#I#D!"#W#E#C!"%b%8%e!<%kFb%*%U%;%C%H$OL$$@FI$s$G$$$J$$!#(B

<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_Data_Level0_fromLogicalPacket_Sub(A_PacketPtr, A_ImpData)
{
  $USE(D_WorkExrefId);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkExrefId);
  TypeSwitch(D_WorkExrefId) {
  case EOL: /* LIST $B$N:G8e$K8=$l$k(B */
  case VECT0:
  case AtomicGrp():
    f_Get_ConstantGroup_fromLogicalPacket(D_WorkExrefId, A_ImpData);
    break;
  case FloatingGrp():
    $CALL( f_Get_FloatingGrp_Level1_fromLogicalPacket_Sub
	                            (A_PacketPtr, A_ImpData) );
    break;
  case WEXREF:
  case WEXVAL:
    $CALL( f_Get_WExRef_fromLogicalPacket_Sub(D_WorkExrefId, A_ImpData) );
    break;
  case BEXREF:
  case BEXVAL:
    $CALL( f_Get_BExRef_fromLogicalPacket_Sub
	                  (A_PacketPtr, D_WorkExrefId, A_ImpData) );
    break;
  case MOD:
    @DEBUG{ /* MOD $B$OI,$:(B MRBon $B$N$O$:(B */
      s_IfMRBoff(D_WorkExrefId) {
	VPIM_ERROR("f_Get_Data_Level0_fromLogicalPacket_Sub",
		   "invalid MRB in level0 MOD import");
      }
    };
    $CALL( f_Get_Mod_Level0_fromLogicalPacket_Sub
	                    (A_PacketPtr, D_WorkExrefId, A_ImpData) );
    break;
  case COD:
    $CALL( f_Get_Cod_Level0_fromLogicalPacket_Sub
	                      (A_PacketPtr, D_WorkExrefId, A_ImpData) );
    break;
  default:
    @DEBUG{
      VPIM_ERROR("f_Get_Data_Level0_fromLogicalPacket_Sub",
		 "Invalid msg tag");
    };
    break;
  }
  $RELEASE(D_WorkExrefId);
  $RETURN();
}

#DATA_define D_WorkOldExcellPtr XXX

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_Data_Level0_SupplyBEXID_fromLogicalPacket_Sub
                                                     (A_PacketPtr, A_ImpData)
{
  $USE(D_WorkExrefId);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkExrefId);
  TypeSwitch(D_WorkExrefId) {
  case BEXREF:
  case BEXVAL:
    $CALL( f_Get_BExRef_fromLogicalPacket_Sub
	                  (A_PacketPtr, D_WorkExrefId, A_ImpData) );
    break;
  case MOD:
    @DEBUG{ /* MOD $B$OI,$:(B MRBon $B$N$O$:(B */
      s_IfMRBoff(D_WorkExrefId) {
	VPIM_ERROR("f_Get_Data_Level0_fromLogicalPacket_Sub",
		   "invalid MRB in level0 MOD import");
      }
    };
    $CALL( f_Get_Mod_Level0_SupplyBEXID_fromLogicalPacket_Sub
                                  (A_PacketPtr, D_WorkExrefId, A_ImpData) );
    break;
  case COD:
    $CALL( f_Get_Cod_Level0_fromLogicalPacket_Sub
	                      (A_PacketPtr, D_WorkExrefId, A_ImpData) );
    break;
  default:
    @DEBUG{
      VPIM_ERROR("f_Get_Data_Level0_SupplyBEXID_fromLogicalPacket_Sub",
		 "Invalid msg tag");
    };
    break;
  }
  $RELEASE(D_WorkExrefId);
  $RETURN();
}

/******************************************************************** PSL **
1.2 $BDj?t%G!<%?$rO@M}%Q%1%C%H$+$iFI$_=P$9(B

f_Get_ConstantGroup_fromLogicalPacket

       written by nakase@icot22      on Fri Jun 22 12:23:07 1990

<Arguments>
  rcvd_data: $BO@M}%Q%1%C%H$+$iFI$_=P$7$?@8%G!<%?(B
  const_reg: $B<h$j=P$7$?%G!<%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_Get_ConstantGroup_fromLogicalPacket(rcvd_data, const_reg)
{
  p_MoveWord(rcvd_data, const_reg);
}

/******************************************************************** PSL **
1.3 $B%l%Y%k#0M"=P$5$l$?%b%8%e!<%k$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_Mod_Level0_fromLogicalPacket_Sub

       written by nakase@icot22      on Fri Jun 22 15:23:14 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$N8=:_$NFI$_=P$70LCV(B
  A_StructID:  $B9=B$BN#I#D(B
  A_MODPtr:    $B<h$j=P$7$?%b%8%e!<%k$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkModExrefId	XXX

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_StructID  SRC
#SUBARG_define A_MODPtr    DST

#SUBROUTINE f_Get_Mod_Level0_fromLogicalPacket_Sub
                             (A_PacketPtr, A_StructID, A_MODPtr) 
{
  $USE(D_WorkModExrefId);
  $USE(D_WorkWEC);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkModExrefId);    
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkWEC);    
  b_SetImmTypeMRBoff(INT, D_WorkWEC);

  $USE(D_WorkFlagReg);               
  $CALL( s_GetStructPtrStrRec_Sub
	            (A_StructID, D_WorkModExrefId, D_WorkWEC, A_MODPtr,
		     D_WorkFlagReg) );
  
  b_IfRegFlagOn(D_WorkFlagReg) {
    s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    $CALL( f_Send_IntClMsg_Release_ExistingStruct_Sub
	                                       (D_WorkModExrefId, D_WorkWEC) );
    s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  }
  $RELEASE(D_WorkFlagReg);
  $RELEASE(D_WorkWEC);
  $RELEASE(D_WorkModExrefId);

  $RETURN();
}

#SUBARG_define A_PacketPtr    MODIFY
#SUBARG_define A_StructID     SRC
#SUBARG_define A_ModulePtr    DST

#SUBROUTINE f_Get_Mod_Level0_SupplyBEXID_fromLogicalPacket_Sub
                                         (A_PacketPtr, A_StructID, A_ModulePtr)
{
  $USE(D_WorkModExrefId);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkModExrefId);    

  $USE(D_WorkExCellPtr);
  $CALL( f_Get_BExRef_ReqBEXID_fromLogicalPacket_Sub
                         (A_PacketPtr, D_WorkModExrefId, D_WorkExCellPtr) );
  $RELEASE(D_WorkModExrefId);
  
  $CALL( s_GetOldStructPtrStrRec_SupplyBEXID_Sub
                              (A_StructID, D_WorkExCellPtr, A_ModulePtr) );

  b_IfNotIllegalPointer(A_ModulePtr) {
    s_RehashStrAddrHash(A_ModulePtr, D_WorkExCellPtr);
  } /*  else { */
    p_MoveWord(D_WorkExCellPtr, A_ModulePtr);
/*  } */  /* Shoen$B%F%9%H%W%m$NFf$N2rL@(B!! */
  $RELEASE(D_WorkExCellPtr);

  $RETURN();
}

/******************************************************************** PSL **
1.4 $B%l%Y%k#0M"=P$5$l$?%3!<%I$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_Cod_Level0_fromLogicalPacket_Sub

       written by nakase@icot22      on Fri Jun 22 16:26:52 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$N8=:_$NFI$_=P$70LCV(B
  A_StructID:  $B9=B$BN#I#D(B
  A_CODPtr:    $B<h$j=P$7$?%3!<%I$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkDummyFP      XXX
#DATA_define D_WorkDcodeGoalPtr XXX

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_StructID  SRC
#SUBARG_define A_PtrToCode DST

#SUBROUTINE f_Get_Cod_Level0_fromLogicalPacket_Sub
                             (A_PacketPtr, A_StructID, A_PtrToCode)
{
  $USE(D_WorkModExrefId);
  $USE(D_WorkWEC);

  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkModExrefId);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkWEC);
  b_SetImmTypeMRBoff(INT, D_WorkWEC);

  $USE(D_WorkModuleOffset);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkModuleOffset);
  b_SetImmTypeMRBoff(INT, D_WorkModuleOffset);
                                 /* $B%b%8%e!<%kFb(Boffset$B$N<h$j$@$7(B */

  $USE(D_WorkModulePtr);
  $USE(D_WorkFlagReg);
  $CALL( s_GetStructPtrStrRec_Sub
                (A_StructID, D_WorkModExrefId, D_WorkWEC, D_WorkModulePtr,
		 D_WorkFlagReg) );
  /* D_WorkModulePtr $B$K$O!"(BMODx $B$+(B REFx $B$,JV$k!#(B
          $B%b%8%e!<%k$,8+$D$+$C$?>l9g(B         MODx
          $B%b%8%e!<%k$,8+$D$+$i$J$+$C$?>l9g(B   REFx ---> BEXVALx    */
  /* $B%b%8%e!<%k$,<+%/%i%9%?Fb$K8+$D$+$C$?$i!"$9$G$KM"F~:Q$H$$$&$3$H$J$N$G!"(B
     %release $B$r=P$7$F$*$/(B */
  s_IfMOD(D_WorkModulePtr) {
    $RELEASE(D_WorkFlagReg);
    s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    $CALL( f_Send_IntClMsg_Release_ExistingStruct_Sub
	                                       (D_WorkModExrefId, D_WorkWEC) );
    s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
    s_GetPredAddressOnOffset(D_WorkModulePtr,D_WorkModuleOffset,A_PtrToCode);
    $RELEASE(D_WorkModExrefId);$RELEASE(D_WorkWEC);
    $RELEASE(D_WorkModuleOffset);$RELEASE(D_WorkModulePtr);
    goto ENDLABEL;
  } else {
    @DEBUG {
      $USE(D_WorkExrefID);
      p_Read(D_WorkModulePtr, D_WorkExrefID);
      TypeSwitch(D_WorkExrefID) {
      case BEXREF:
      case BEXVAL:
      case RDHOK:
      case EXLOCK:
	break;
      default:
        VPIM_ERROR("f_Get_Cod_Level0_fromLogicalPacket_Sub","Illegal module");
      }
      $RELEASE(D_WorkExrefID);
    };
  }
  b_IfRegFlagOn(D_WorkFlagReg){
    s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
    $CALL( f_Send_IntClMsg_Release_ExistingStruct_Sub
	                                       (D_WorkModExrefId, D_WorkWEC) );
    s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
  /* $B%b%8%e!<%k<+?H$O<+%/%i%9%?Fb$K$J$$$,9=B$BNI=$K$"$k;~$O!"(B
     %release $B$r=P$7$F$*$/(B */
  }
  $RELEASE(D_WorkFlagReg);
  $RELEASE(D_WorkWEC);
  $RELEASE(D_WorkModExrefId);

  s_AllocVariable(A_PtrToCode);

  $USE(D_WorkDummyFP);
  $USE(D_WorkMaxPrio);
  b_SetImmTypeValueMRBon(FPREC, _DUMMY_FOSTER_PARENT_AREA_BASE, D_WorkDummyFP);
  s_GetFPMaxPriority(D_WorkDummyFP, D_WorkMaxPrio);
                          /* $B%3!<%I$X$N%]%$%s%?$rF@$k(BD-Code$B%4!<%k$N(B
			     $BN$?F$O(BDummy$BN$?F$H$9$k!#(B
 			     Unification_Failue$B$N=hM}$r9M$($k$3$H!*!*(B*/
  $USE(D_WorkFPOrgReg);
  s_LockFPRecord(D_WorkDummyFP, D_WorkFPOrgReg);
  s_AddFPChildCount(D_WorkDummyFP, D_ONE);
  s_UnlockFPRecord(D_WorkDummyFP, D_WorkFPOrgReg);
  $RELEASE(D_WorkFPOrgReg);

  $USE(D_WorkDcodeGoalPtr);
  s_AllocShortGoalRecord(D_WorkDcodeGoalPtr);

  s_PutFosterparentGoalRecord(D_WorkDcodeGoalPtr, D_WorkDummyFP);

  $USE(D_WorkEnvRecPtr);
  s_AllocNonDebugEnvRecord(D_WorkEnvRecPtr);
  b_SetImmTypeMRBon(INT, D_WorkMaxPrio);
  s_PutPriorityEnvRecord(D_WorkEnvRecPtr,D_WorkMaxPrio);
  s_PutEmigrantClusterEnvRecord(D_WorkEnvRecPtr);
  s_PutEnvRecGoalRecord(D_WorkDcodeGoalPtr,D_WorkEnvRecPtr);
  $RELEASE(D_WorkEnvRecPtr);

  s_PutProcessorIdGoalRecord(D_WorkDcodeGoalPtr, D_PE_Number);

  /* $B#D%3!<%I!"(B
   * dcode_read_module(Mod,Offset,Code):-true|
   *	                    module_offset_to_code(Mod,Offset,Code).
   *	$B$X$N%]%$%s%?$,%4!<%k%l%3!<%I$N%3!<%I%(%j%"$KF~$l$i$l$k!#(B */
  f_PutDcodeAddress(D_WorkDcodeGoalPtr, DCODE_READ_MODULE);

  /* $B3F0z?t$,$,%4!<%k%l%3!<%I$N%3!<%I%(%j%"$KF~$l$i$l$k!#(B */
  s_PutArgImmPosGoalRecord(D_WorkDcodeGoalPtr, _ARG0_OFST_GR, D_WorkModulePtr);
  s_PutArgImmPosGoalRecord(D_WorkDcodeGoalPtr, _ARG1_OFST_GR, D_WorkModuleOffset);
  s_PutArgImmPosGoalRecord(D_WorkDcodeGoalPtr, _ARG2_OFST_GR, A_PtrToCode);

  s_PutImmArityGoalRecord(D_WorkDcodeGoalPtr, _THREE);
  $CALL( f_PushGoalToStackWithPriority_Sub(D_WorkDcodeGoalPtr,D_WorkMaxPrio) );
  $RELEASE(D_WorkDcodeGoalPtr);
  $RELEASE(D_WorkMaxPrio);
  $RELEASE(D_WorkDummyFP);
  $RELEASE(D_WorkModulePtr);
  $RELEASE(D_WorkModuleOffset);
 ENDLABEL:
  $RETURN();
}

/******************************************************************** PSL **
1.5 $BGrM"=P$5$l$?%G!<%?!JGr30It;2>H#I#D$G<($5$l$k!K$rO@M}%Q%1%C%H$+$iFI$_=P$9(B

f_Get_WExRef_fromLogicalPacket_Sub

       written by nakase@icot22      on Fri Jun 22 12:26:39 1990

<Arguments>
  A_WExRefID: $BGrM"=P$5$l$?%G!<%?$N30It;2>H#I#D(B
  A_ImpData:  $B%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_WExRefID SRC
#SUBARG_define A_ImpData  DST

#SUBROUTINE  f_Get_WExRef_fromLogicalPacket_Sub(A_WExRefID, A_ImpData)
{
  $USE(D_WorkCLNum);
  s_GetClusterNum(A_WExRefID, D_WorkCLNum);

  b_IfEqual(D_WorkCLNum, D_CL_Number){
    /* $B<+J,$,M"=P$7$?%G!<%?$@$C$?$i!"<BBN$X$N%]%$%s%?$r;}$C$F$/$k!#(B
     * $BM"=PI=$N2rJ|$b2DG=$J$i9T$&!#(B */
    s_GetWExpDataAndReclaimIfNotUnifyFlag(A_WExRefID, A_ImpData);
  } else {
    /* $B<+J,0J30$,M"=P$7$?%G!<%?$@$C$?$i!"M"F~I=$H30It;2>H%;%k$r3d$jIU$1$k(B */
    s_AllocWhiteImpRecAndExCell(A_WExRefID, A_ImpData);
    @PROBE{ b_IncrementReg(D_ALLOC_WIMP_COUNT); };
  }
  $RELEASE(D_WorkCLNum);

  $RETURN();
}

/******************************************************************** PSL **
1.6 $B9uM"=P$5$l$?%G!<%?!J9u30It;2>H#I#D!\#W#E#C$G<($5$l$k!K(B
    $B$rO@M}%Q%1%C%H$+$iFI$_=P$9(B

f_Get_BExRef_fromLogicalPacket_Sub

       written by nakase@icot22      on Fri Jun 22 14:18:39 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
               $B9uM"=P$5$l$?%G!<%?$KIU$1$i$l$?#W#E#C$r;X$7$F$$$k(B
  A_BExRefID:  $B9uM"=P$5$l$?%G!<%?$N30It;2>H#I#D(B
  A_ImpData:   $B%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkWEC_inPacket XXX
#DATA_define D_WorkReturnWEC    XXX

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_BExRefID  SRC
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_BExRef_fromLogicalPacket_Sub
                         (A_PacketPtr, A_BExRefID, A_ImpData)
{

  $USE(D_WorkWEC_inPacket);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkWEC_inPacket);
  b_SetImmTypeMRBoff(INT, D_WorkWEC_inPacket);

  s_IfStructFlagOn(A_BExRefID) {
    $USE(D_WorkStrID);
    $USE(D_WorkFlagReg);
    s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkStrID);
    $CALL( s_GetStructPtrStrRec_Sub
                (D_WorkStrID, A_BExRefID, D_WorkWEC_inPacket, A_ImpData, 
		 D_WorkFlagReg) );
    $RELEASE(D_WorkStrID);
    b_IfRegFlagOff(D_WorkFlagReg){
      $RELEASE(D_WorkFlagReg);
      goto END; }
    $RELEASE(D_WorkFlagReg);
  }
  $USE(D_WorkCLNum);
  s_GetClusterNum(A_BExRefID, D_WorkCLNum);
  b_IfEqual(D_WorkCLNum, D_CL_Number){
    $RELEASE(D_WorkCLNum);
    /* $B85!9!"<+J,$,M"=P$7$?%G!<%?$@$C$?$i!"<BBN$X$N%]%$%s%?$r;}$C$F$/$k!#(B
     * $BM"=PI=$N2rJ|$b2DG=$J$i9T$&!#(B */
    $USE(D_WorkVOIDFlag);
    $CALL( s_GetBExpDataAndAddWecWithReclaimExpEntry_Sub
	     (A_BExRefID, D_WorkWEC_inPacket, A_ImpData, D_WorkVOIDFlag) );
    $RELEASE(D_WorkVOIDFlag);
  } else {
    $RELEASE(D_WorkCLNum);
    $USE(D_WorkReturnWEC);
    $CALL( s_GetPtrToExCellAllocBImpRecWithWec_Sub
	     (A_BExRefID, D_WorkWEC_inPacket, A_ImpData, D_WorkReturnWEC) );
    b_IfNotEqual(D_NULL, D_WorkReturnWEC){
      s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
      $CALL( f_Send_IntClMsg_Release_ExistingStruct_Sub
	                                    (A_BExRefID, D_WorkReturnWEC) );
      s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
             /* $B$3$N%^%/%m$OK\Mh!"9=B$BN(BID$B!\30It;2>H(BID$B!\(BWEC$B$r$b$i$C$F$-$?;~!"(B
                WEC$B$rJV$9$?$a$N%^%/%m$G$"$k$,!"(BWEC$B$,%*!<%P!<%U%m!<$7$?;~$K$b(B
                $B;H$($k!#(B*/
    }
    $RELEASE(D_WorkReturnWEC);
  }

 END:
  $RELEASE(D_WorkWEC_inPacket);
  $RETURN();
}

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_BExRefID  SRC
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_BExRef_ReqBEXID_fromLogicalPacket_Sub
                         (A_PacketPtr, A_BExRefID, A_ImpData)
{
  $USE(D_WorkWEC_inPacket);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkWEC_inPacket);
  b_SetImmTypeMRBoff(INT, D_WorkWEC_inPacket);

  $USE(D_WorkCLNum);
  s_GetClusterNum(A_BExRefID, D_WorkCLNum);
  b_IfEqual(D_WorkCLNum, D_CL_Number){
    $RELEASE(D_WorkCLNum);
    /* $B85!9!"<+J,$,M"=P$7$?%G!<%?$@$C$?$i!"<BBN$X$N%]%$%s%?$r;}$C$F$/$k!#(B
     * $BM"=PI=$N2rJ|$b2DG=$J$i9T$&!#(B */
    $USE(D_WorkVOIDFlag);
    $CALL( s_GetBExpDataAndAddWecWithReclaimExpEntry_Sub
	     (A_BExRefID, D_WorkWEC_inPacket, A_ImpData, D_WorkVOIDFlag) );
    $RELEASE(D_WorkVOIDFlag);
  } else {
    $RELEASE(D_WorkCLNum);
    $USE(D_WorkReturnWEC);
    $CALL( s_GetPtrToExCellAllocBImpRecWithWec_Sub
	     (A_BExRefID, D_WorkWEC_inPacket, A_ImpData, D_WorkReturnWEC) );
    b_IfNotEqual(D_NULL, D_WorkReturnWEC){
      s_RecordMsgDecodeStop(); /*** for Processor Profile ***/
      $CALL( f_Send_IntClMsg_Release_ExistingStruct_Sub
	                                    (A_BExRefID, D_WorkReturnWEC) );
      s_RecordMsgDecodeStart(); /*** for Processor Profile ***/
             /* $B$3$N%^%/%m$OK\Mh!"9=B$BN(BID$B!\30It;2>H(BID$B!\(BWEC$B$r$b$i$C$F$-$?;~!"(B
                WEC$B$rJV$9$?$a$N%^%/%m$G$"$k$,!"(BWEC$B$,%*!<%P!<%U%m!<$7$?;~$K$b(B
                $B;H$($k!#(B*/
    }
    $RELEASE(D_WorkReturnWEC);
  }

  $RELEASE(D_WorkWEC_inPacket);
  $RETURN();
}

/******************************************************************** PSL **
1.7 %read$B$K$h$C$F9uM"=P$5$l$?%G!<%?!J9u30It;2>H#I#D!\#W#E#C$G<($5$l$k!K(B
    $B$rO@M}%Q%1%C%H$+$iFI$_=P$9(B

f_Get_BExRef_Read_fromLogicalPacket_Sub

       written by ttakagi@icot22      on Thu Nov 15 11:45:21 1990

<Arguments>
 A_PacketPtr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
              $B<B:]$K$O8=:_$NFI$_=P$70LCV(B
 A_BExRefID:  $B%G!<%?$r;X$9M"=PI=$N30It;2>H#I#D(B
 A_ImpData:   $B%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_BExRefID  SRC
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_BExRef_Read_fromLogicalPacket_Sub
                              (A_PacketPtr, A_BExRefID, A_ImpData)
{
  $USE(D_WorkWEC_inPacket);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkWEC_inPacket);
  b_SetImmTypeMRBoff(INT, D_WorkWEC_inPacket);

  $USE(D_WorkCLNum);
  s_GetClusterNum(A_BExRefID, D_WorkCLNum);
  b_IfEqual(D_WorkCLNum, D_CL_Number){
    $RELEASE(D_WorkCLNum);
    /* $B85!9!"<+J,$,M"=P$7$?%G!<%?$@$C$?$i!"<BBN$X$N%]%$%s%?$r;}$C$F$/$k!#(B
     * $BM"=PI=$N2rJ|$b2DG=$J$i9T$&!#(B */
    $USE(D_WorkVOIDFlag);
    $CALL( s_GetBExpDataAndAddWecWithReclaimExpEntry_Sub
	     (A_BExRefID, D_WorkWEC_inPacket, A_ImpData, D_WorkVOIDFlag) );
    $RELEASE(D_WorkVOIDFlag);
  } else {
    @DEBUG{
      VPIM_ERROR("f_Get_BExRef_Read_fromLogicalPacket_Sub",
		 "Invalid CL num in ExrefId");
    };
  }
  $RELEASE(D_WorkWEC_inPacket);
  $RETURN();
}

/******************************************************************** PSL **
2. $BO@M}%Q%1%C%H$+$i%l%Y%k#1M"F~$5$l$?%G!<%?$r<h$j=P$9(B
2.1 $B$"$k%G!<%?(B($B%l%Y%k#1M"F~(B)$B$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_Data_Level1_fromLogicalPacket_Sub

       written by nakase@icot22      on Thu Jun 21 22:32:08 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$N8=:_$NFI$_=P$70LCV(B
  A_ImpData:   $B<h$j=P$7$?%G!<%?$b$7$/$O%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkDataLevel1 XXX

#SUBARG_define A_PacketPtr  MODIFY
#SUBARG_define A_ImpData    DST
#SUBARG_define A_StructFlag DST
/* A_StructFlag $B$O(B MOD $B$N;~$N$_;HMQ$5$l$k!#$=$NB>$N;~$O2?$b%;%C%H$5$l$J$$!#(B*/

#SUBROUTINE f_Get_Data_Level1_fromLogicalPacket_Sub(A_PacketPtr, A_ImpData, A_StructFlag)
{
  $USE(D_WorkDataLevel1);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkDataLevel1);
  TypeSwitch(D_WorkDataLevel1) {
    case VECT0:
    case AtomicGrp():
      f_Get_ConstantGroup_fromLogicalPacket(D_WorkDataLevel1, A_ImpData);
      $RELEASE(D_WorkDataLevel1);
      break;
    case FloatingGrp():
      $CALL( f_Get_FloatingGrp_Level1_fromLogicalPacket_Sub
	                            (A_PacketPtr, A_ImpData) );
      $RELEASE(D_WorkDataLevel1);
      break;
    case ListGrp():
      $RELEASE(D_WorkDataLevel1);
      $CALL( f_Get_List_Level1_fromLogicalPackt_Sub(A_PacketPtr, A_ImpData) );
      break;
    case ShortVectorGrp():
      $CALL( f_Get_ShortVect_Level1_fromLogicalPacket_Sub
	                          (A_PacketPtr, D_WorkDataLevel1, A_ImpData) );
      $RELEASE(D_WorkDataLevel1);
      break;
    case LongVectorGrp():
      $CALL( f_Get_LongVect_Level1_fromLogicalPacket_Sub
                                  (A_PacketPtr, D_WorkDataLevel1, A_ImpData) );
      $RELEASE(D_WorkDataLevel1);
      break;
    case StringGrp():
      $RELEASE(D_WorkDataLevel1);
      $CALL( f_Get_StringGrp_Level1_fromLogicalPacket_Sub
	                                       (A_PacketPtr, A_ImpData) );
      break;
    case MOD: /* $B%b%8%e!<%k$N<BBN$rM"F~$7$?;~(B */
      s_IfMRBoff(D_WorkDataLevel1){
	$CALL(f_Get_ModuleLevel1_fromLogicalPacket_Sub(A_PacketPtr,A_ImpData));
          /* Struct_flag$B$,(Bon$B$N30It;2>H(BID$B$N@h$r(BRead$B$7$F!"%l%Y%k#1M"=P$5$l$?(B
	     $B%b%8%e!<%k$N<BBN$r<u$1$H$C$?;~!#(B*/
	b_SetRegFlagOn(A_StructFlag);
	@DEBUG{ WARNING("f_Get_Data_Level1_fromLogicalPacket_Sub",
			"receive module entity");};
      } else {
	$CALL( f_Get_Mod_Level0_fromLogicalPacket_Sub(A_PacketPtr,
					      D_WorkDataLevel1,A_ImpData) );
	  /* Struct_flag$B$,(Boff$B$N30It;2>H(BID$B$N@h$r(BRead$B$7$F!"%l%Y%k#0M"=P$5$l$?(B
             $B%b%8%e!<%k$N9=B$BN(BID$B$H30It;2>H(BID$B$r<u$1$H$C$?;~(B */
	b_SetRegFlagOff(A_StructFlag);
	@DEBUG{ WARNING("f_Get_Data_Level1_fromLogicalPacket_Sub",
			"receive module struct_id");};
      }
      $RELEASE(D_WorkDataLevel1);
      break;
    case COD: /* COD$B$O%l%Y%k#1M"F~$G$b%l%Y%k#0$H$7$F07$&(B */
      $CALL( f_Get_Cod_Level0_fromLogicalPacket_Sub
	                      (A_PacketPtr, D_WorkDataLevel1, A_ImpData) );  
      $RELEASE(D_WorkDataLevel1);
      break;
    case WEXREF:
    case WEXVAL:
              /* %Unify$B$N0z?t#2$N;~$"$jF@$k(B */
      $CALL( f_Get_WExRef_fromLogicalPacket_Sub(D_WorkDataLevel1, A_ImpData) );
      $RELEASE(D_WorkDataLevel1);
      break;
    case BEXREF:
    case BEXVAL:
              /* %Unify$B$N0z?t#2$N;~$"$jF@$k(B */
      $CALL( f_Get_BExRef_fromLogicalPacket_Sub
	                  (A_PacketPtr, D_WorkDataLevel1, A_ImpData) );
      $RELEASE(D_WorkDataLevel1);
      break;
    default:
     @DEBUG{ VPIM_ERROR("f_Get_Data_Level1_fromLogicalPacket_Sub",
			"Invalid msg tag");};
      break;
    }
  $RETURN();
}

/******************************************************************** PSL **
2.2 $B%l%Y%k#1M"=P$5$l$?%j%9%H$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_List_Level1_fromLogicalPackt_Sub

       written by nakase@icot22      on Fri Jun 22 16:53:47 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$NFI$_$@$70LCV$r<($9%]%$%s%?(B
  A_ImpData:   $BFI$_$H$C$?%G!<%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkCar		XXX
#DATA_define	D_WorkCdr		XXX

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_List_Level1_fromLogicalPackt_Sub(A_PacketPtr, A_ImpData) 
{
  s_AllocList(A_ImpData);
  $USE(D_WorkCar);
  $CALL( f_Get_Data_Level0_fromLogicalPacket_Sub(A_PacketPtr, D_WorkCar) );
  s_PutCarList(A_ImpData, D_WorkCar);
  $RELEASE(D_WorkCar);
  $USE(D_WorkCdr);
  $CALL( f_Get_Data_Level0_fromLogicalPacket_Sub(A_PacketPtr, D_WorkCdr) );
  s_PutCdrList(A_ImpData, D_WorkCdr);
  $RELEASE(D_WorkCdr);
  $RETURN();
}

/******************************************************************** PSL **
2.2.5

       written by ttakagi@icot22      on Thu Aug  8 20:49:05 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_FloatingGrp_Level1_fromLogicalPacket_Sub
                                             (A_PacketPtr, A_ImpData) 
{
  s_AllocFLT(A_ImpData);
  $USE(D_WorkFloatingUpper);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr,D_WorkFloatingUpper);
  @DEBUG{
    s_IfNotINT(D_WorkFloatingUpper) {
      VPIM_ERROR("f_Get_FloatingGrp_Level1_fromLogicalPacket_Sub","illegal float upper");
    }
  };
  b_WriteFLTMSWord(D_WorkFloatingUpper, A_ImpData);
  $RELEASE(D_WorkFloatingUpper);
  $USE(D_WorkFloatingLower);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkFloatingLower);
  @DEBUG{
    s_IfNotINT(D_WorkFloatingLower) {
      VPIM_ERROR("f_Get_FloatingGrp_Level1_fromLogicalPacket_Sub","illegal float lower");
    }
  };
  b_WriteFLTLSWord(D_WorkFloatingLower, A_ImpData);
  $RELEASE(D_WorkFloatingLower);
  $RETURN();
}

/******************************************************************** PSL **
2.3 $B%l%Y%k#1M"=P$5$l$?(Bshort$B%Y%/%?$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_ShortVect_Level1_fromLogicalPacket_Sub

       written by nakase@icot22      on Fri Jun 22 18:08:27 1990

<Arguments>
  A_PacketPtr:    $BO@M}%Q%1%C%H$NFI$_$@$70LCV$r<($9%]%$%s%?(B
  A_VECT_TAG_Reg: $BM"=P85$G$N%G!<%?$X$N%]%$%s%?$G!"%?%0$N$_$rMxMQ$9$k(B
  A_ImpData:      $B<h$j=P$7$?%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define A_PacketPtr    MODIFY
#SUBARG_define A_VECT_TAG_Reg SRC
#SUBARG_define A_ImpData      DST

#SUBROUTINE f_Get_ShortVect_Level1_fromLogicalPacket_Sub
	                            (A_PacketPtr, A_VECT_TAG_Reg, A_ImpData)
{
  $USE(D_WorkVectSize);
  s_GetSizeShortVect(A_VECT_TAG_Reg, D_WorkVectSize);
  ValueSwitch(D_WorkVectSize) {
   case 1: s_AllocVect1(A_ImpData); break;
   case 2: s_AllocVect2(A_ImpData); break;
   case 3: s_AllocVect3(A_ImpData); break;
   case 4: s_AllocVect4(A_ImpData); break;
   case 5: s_AllocVect5(A_ImpData); break;
   case 6: s_AllocVect6(A_ImpData); break;
   case 7: s_AllocVect7(A_ImpData); break;
   case 8: s_AllocVect8(A_ImpData); break;
   default: break;
  }
  $USE(D_WorkElemPos);
  b_SetImmValueDNTC(_ZERO, D_WorkElemPos);
  LOOP() {
    $USE(D_WorkVectElem);
    $CALL( f_Get_Data_Level0_fromLogicalPacket_Sub
	                                   (A_PacketPtr, D_WorkVectElem) );
    s_PutVectElementPosReg(A_ImpData, D_WorkElemPos, D_WorkVectElem);
    $RELEASE(D_WorkVectElem);
    b_DecrementReg(D_WorkVectSize);
    b_IncrementReg(D_WorkElemPos);
    b_IfZero(D_WorkVectSize){
      $RELEASE(D_WorkVectSize);
      break;
    }
  }
  $RELEASE(D_WorkElemPos);
  $RETURN();
}

/******************************************************************** PSL **
2.4 $B%l%Y%k#1M"=P$5$l$?(Blong$B%Y%/%?$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_LongVect_Level1_fromLogicalPacket_Sub

       written by nakase@icot22      on Fri Jun 22 19:28:32 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$N8=:_$NFI$_=P$70LCV(B
  A_ImpData:   $B<h$j=P$7$?%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
 A_VECT_TAG_Reg$B$N(B value$BIt$K$O%Y%/%?$N%5%$%:$,F~$C$F$$$k!#(B
********************************************************************* PSL **/

#DATA_define	D_WorkVectCount		XXX

#SUBARG_define A_PacketPtr    MODIFY
#SUBARG_define A_VECT_TAG_Reg SRC
#SUBARG_define A_ImpData      DST

#SUBROUTINE f_Get_LongVect_Level1_fromLogicalPacket_Sub
                                  (A_PacketPtr, A_VECT_TAG_Reg, A_ImpData)
{
  $CALL( s_AllocLongVect_Sub(A_VECT_TAG_Reg, A_ImpData) );
  b_IfNotIllegalPointer(A_ImpData) { /* $B%"%m%1!<%H@.8y(B */
    $USE(D_WorkVectCount);
    p_MoveWord(D_NULL, D_WorkVectCount);
    LOOP() {
      b_IfGreaterEq(D_WorkVectCount, A_VECT_TAG_Reg) { break; }
      $USE(D_WorkVectElem);
      $CALL( f_Get_Data_Level0_fromLogicalPacket_Sub
	                                   (A_PacketPtr,D_WorkVectElem) );
      s_PutVectElementPosReg(A_ImpData, D_WorkVectCount, D_WorkVectElem);
      $RELEASE(D_WorkVectElem);
      b_IncrementReg(D_WorkVectCount);
    }
    $RELEASE(D_WorkVectCount);   
  } else {
    @DEBUG{
      WARNING("f_Get_LongVect_Level1_fromLogicalPacket_Sub",
	      "Fail allocate long vector");
    };
    /* $B$=$N$^$^(B D_NULL $B$rJV$9!#(B */
  }
  $RETURN();
}

/******************************************************************** PSL **
2.5 $B%l%Y%k#1M"=P$5$l$?%9%H%j%s%0$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

f_Get_StringGrp_Level1_fromLogicalPacket_Sub

       written by nakase@icot22      on Fri Jun 22 19:39:39 1990

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$N8=:_$NFI$_=P$70LCV(B
  A_ImpData:   $B<h$j=P$7$?%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkCnt XXX

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_StringGrp_Level1_fromLogicalPacket_Sub(A_PacketPtr,A_ImpData)
{
  $USE(D_WorkDesc);
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkDesc);    
  @DEBUG{
    s_IfNotCDESC(D_WorkDesc) {
      VPIM_ERROR("f_ReceiveStringGrpLevel1","Illegal string descriptor");
    }
  };
  $CALL( s_AllocStrgMRBoffWithDesc_Sub(A_ImpData, D_WorkDesc) );
	 
  b_IfNotIllegalPointer(A_ImpData) {
    /* $B%9%H%j%s%0$N%"%m%1!<%H$K@.8y$7$?;~(B */
    $USE(D_WorkStrgSize);
    s_GetStringSizeWithDesc(D_WorkDesc, D_WorkStrgSize);
    $USE(D_WorkCnt);
    p_MoveWord(D_NULL, D_WorkCnt);
    LOOP() {                           /* for(i=0; i<size; i++) */
      b_IfGreaterEq(D_WorkCnt, D_WorkStrgSize) { break; }
      $USE(D_WorkStringWord);
      s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkStringWord);
      s_PutStringWordPosReg(A_ImpData, D_WorkCnt, D_WorkStringWord);
      $RELEASE(D_WorkStringWord);
      b_IncrementReg(D_WorkCnt);
    }
    $RELEASE(D_WorkCnt);
    $RELEASE(D_WorkStrgSize);
  } else {
    @DEBUG{
      WARNING("f_Get_StringGrp_Level1_fromLogicalPacket_Sub",
	      "Fail allocate string");
    };
  }
  $RELEASE(D_WorkDesc);
  $RETURN();
}

/******************************************************************** PSL **
2.6 $B%l%Y%k#1M"=P$5$l$?%b%8%e!<%k$N<BBN$rO@M}%Q%1%C%H$+$i<h$j=P$9(B

       written by nakase@icot22      on Fri Jun 22 19:47:24 1990

<Message Format in VPIM>
  
  /                                        /
  +----------------------------------------+
  | MOD   !  don't care                    |
  +----------------------------------------+
  | INT   !  $B%b%8%e!<%k%5%$%:(B              |
  +----------------------------------------+
  |                                        |
  /          $B%b%8%e!<%k$N3F%G!<%?(B          /
  |                                        |
  +----------------------------------------+
  | CDESC !  $B%3!<%I%5%$%:(B                  |
  +----------------------------------------+
  |                                        |
  /          $B%3!<%I$N3F%G!<%?(B              /
  |                                        |
  +----------------------------------------+
  /                                        /

<Arguments>
  A_PacketPtr: $BO@M}%Q%1%C%H$N8=:_$NFI$_=P$70LCV(B
  A_ImpData:   $B<h$j=P$7$?%G!<%?$X$N%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B!&%^%k%A%Q%1%C%H$K$J$C$F!"DI$$1[$7$,M-$k;~$N$3$H$O9M$($F$$$J$$!#(B
$B!&%b%8%e!<%k$N7A<0$rMxMQ$7(B, $BL?Na%3!<%IK\BN$O%9%H%j%s%0$H$7$F<u?.$9$k!#(B

<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkModElem	 XXX
#DATA_define	D_WorkModLength	 XXX
#DATA_define    D_WorkPtrToMOD   XXX
#DATA_define    D_WorkModAddr    XXX
#DATA_define    D_WorkBreakFlag  XXX
#DATA_define    D_WorkGCAreaData XXX

#SUBARG_define A_PacketPtr MODIFY
#SUBARG_define A_ImpData   DST

#SUBROUTINE f_Get_ModuleLevel1_fromLogicalPacket_Sub(A_PacketPtr, A_ImpData)
{
  $USE(D_WorkModLength);
  $USE(D_WorkModAddr);

  /* $B%b%8%e!<%k$N%5%$%:$rFI$_<h$k(B */
  s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkModLength);

  b_AllocMultipleHeapPage(D_WorkModLength, D_WorkModAddr);
  b_IfIllegalPointer(D_WorkModAddr) {
    @DEBUG{
      WARNING("f_Get_ModuleLevel1_fromLogicalPacket_Sub",
	      "Fail allocate module");
    };
    $RELEASE(D_WorkModLength);
    p_MoveWord(D_NULL, A_ImpData);
  } else {
    p_MoveWord(D_WorkModAddr, A_ImpData);
    b_SetImmTypeMRBon(MOD, A_ImpData);

    p_Write(D_WorkModLength, D_WorkModAddr);
    $RELEASE(D_WorkModLength);
    b_IncrementAddrReg(D_WorkModAddr);

    /* $B#G#CNN0h$rFI$_<h$k(B */
    $USE(D_WorkModElem);
    $USE(D_WorkBreakFlag); /* $B%k!<%W$+$iC&=P$9$k$?$a$N%U%i%0(B */
    p_MoveWord(D_NULL, D_WorkBreakFlag);
    LOOP() {
      s_Get_1_Data_fromLogicalPacket(A_PacketPtr, D_WorkModElem);    
      TypeSwitch(D_WorkModElem) {
      case BEXTGrp():
	$USE(D_WorkGCAreaData);
	$CALL( f_Get_BExRef_fromLogicalPacket_Sub
	                    (A_PacketPtr, D_WorkModElem, D_WorkGCAreaData) );
	s_MRBonReg(D_WorkGCAreaData);
	p_Write(D_WorkGCAreaData, D_WorkModAddr);
	$RELEASE(D_WorkGCAreaData);
	break;
      case MOD:
	$USE(D_WorkPtrToMOD);
	$CALL( f_Get_Mod_Level0_fromLogicalPacket_Sub
	                      (A_PacketPtr, D_WorkModElem, D_WorkPtrToMOD) );
	s_MRBonReg(D_WorkPtrToMOD);
	p_Write(D_WorkPtrToMOD, D_WorkModAddr);
	$RELEASE(D_WorkPtrToMOD);
	break;
      case VECT0:
      case EOL: /* $B%3!<%I$N%-%c%C%7%eNN0h(B */
      case INT: /* $B%3!<%I$N%b%8%e!<%kFb%*%U%;%C%H$NCM(B */
      case ATOM:
	p_Write(D_WorkModElem, D_WorkModAddr);
	break;
      case CDESC:
	/* $B$3$NCf$G!"%3!<%IK\BN$rFI$_<h$k(B */
	f_ReceiveModuleCode(A_PacketPtr, D_WorkModElem, D_WorkModAddr);
	p_MoveWord(D_ONE, D_WorkBreakFlag);
	break;
      default:
	@DEBUG{ VPIM_ERROR("f_Get_ModuleLevel1_fromLogicalPacket_Sub",
			   "Illegal type in GC area"); };
	break;
      }
      b_IfEqual(D_WorkBreakFlag, D_ONE) { break; } /* $B%k!<%W$+$i$NC&=P(B */
      b_IncrementAddrReg(D_WorkModAddr);
    }
    $RELEASE(D_WorkBreakFlag);
    $RELEASE(D_WorkModElem);
  }
  
  $RELEASE(D_WorkModAddr);
  $RETURN();
}

#DATA_define	D_WorkCodeSize 		XXX
#DATA_define	D_WorkCodeElemCount	XXX

#PSL_define f_ReceiveModuleCode(packet_ptr, cdesc_reg, code_addr)
{
  $USE(D_WorkCodeSize);
  s_GetStringSizeWithDesc(cdesc_reg, D_WorkCodeSize);
  p_Write(cdesc_reg, code_addr);
  $USE(D_WorkCodeElemCount);
  b_SetImmValueDNTC(_ONE, D_WorkCodeElemCount);
  LOOP() {
    b_IfGreater(D_WorkCodeElemCount, D_WorkCodeSize) { break; }
    $USE(D_WorkStringWord);
    s_Get_1_Data_fromLogicalPacket(packet_ptr, D_WorkStringWord);    
    s_PutCodeElemPosReg(code_addr, D_WorkCodeElemCount, D_WorkStringWord);
    $RELEASE(D_WorkStringWord);
    b_IncrementReg(D_WorkCodeElemCount);
  }
  $RELEASE(D_WorkCodeElemCount);
  $RELEASE(D_WorkCodeSize);
}

/******************************************************************** PSL **
3. $BO@M}%Q%1%C%H$+$i!"3F<o$N@)8f%G!<%?$rFI$_=P$9(B

f_Get_ShoenID_fromLogicalPacket
f_Get_CL_Num_fromLogicalPacket
f_Get_WTC_fromLogicalPacket
f_Get_LowestPrio_fromLogicalPacket
f_Get_HighestPrio_fromLogicalPacket
f_Get_Resource_fromLogicalPacket
f_Get_Prio_fromLogicalPacket
f_Get_Arity_fromLogicalPacket
f_Get_CodeInfo_fromLogicalPacket
f_Get_ProfileType_fromLogicalPacket
f_Get_ProfileAnsCount_fromLogicalPacket
f_Get_ProfileNestLevel_fromLogicalPacket
f_Get_ProfileCLNum_fromLogicalPacket
f_Get_ProfileData_fromLogicalPacket

       written by nakase@icot22      on Thu Jun 21 19:59:47 1990

<Arguments>
  current_packet_ptr: $B8=:_FI$_9~$^$l$F$$$k%Q%1%C%H$N%G!<%?0LCV$r<($9%]%$%s%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BO@M}%Q%1%C%H$+$i!"3F<o$N@)8f%G!<%?$rFI$_=P$9!#(B
  $B#V#P#I#M$N%=!<%9%W%m%0%i%`$rFI$_0W$/$9$k$?$a$K!"L>A0$rFI$_BX$($F$$$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_Get_ShoenID_fromLogicalPacket(current_packet_ptr, shoen_id_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, shoen_id_reg);
}

#PSL_define f_Get_CL_Num_fromLogicalPacket(current_packet_ptr, cl_num_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, cl_num_reg);
}

#PSL_define f_Get_WTC_fromLogicalPacket(current_packet_ptr, wtc_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, wtc_reg);
  b_SetImmTypeMRBoff(INT, wtc_reg);
}

#PSL_define f_Get_LowestPrio_fromLogicalPacket
                             (current_packet_ptr, lowest_prio_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, lowest_prio_reg);
}

#PSL_define f_Get_HighestPrio_fromLogicalPacket
                              (current_packet_ptr, highest_prio_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, highest_prio_reg);
}

#PSL_define f_Get_Resource_fromLogicalPacket(current_packet_ptr, resource_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, resource_reg);
}

#PSL_define f_Get_ProfilingFlag_fromLogicalPacket(current_packet_ptr, flag_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, flag_reg);
}

#PSL_define f_Get_PartitionInfo_fromLogicalPacket
                                (current_packet_ptr, node_num, node_cnt)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, node_num);
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, node_cnt);
}

#PSL_define f_Get_Prio_fromLogicalPacket(current_packet_ptr, prio_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, prio_reg);
  b_SetImmTypeMRBoff(INT, prio_reg);
}

#PSL_define f_Get_Arity_fromLogicalPacket(current_packet_ptr, arity_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, arity_reg);
}

#PSL_define f_Get_SenderClusterNum_fromLogicalPacket
                                   (current_packet_ptr, cl_num)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, cl_num);
}

#PSL_define f_Get_ReturnExRefID_fromLogicalPacket(current_packet_ptr, exref_id)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, exref_id);
}

#PSL_define f_Get_ResourceLeft_fromLogicalPacket
                               (current_packet_ptr, res_upper, res_lower)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_upper);
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_lower);
}

#PSL_define f_Get_ResourceConsumed_fromLogicalPacket
                               (current_packet_ptr, res_upper, res_lower)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_upper);
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_lower);
}

#PSL_define f_Get_ReturnResource_fromLogicalPacket
                               (current_packet_ptr, res_upper, res_lower)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_upper);
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_lower);
}

#PSL_define f_Get_StatResource_fromLogicalPacket
                               (current_packet_ptr, res_upper, res_lower)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_upper);
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, res_lower);
}

#PSL_define f_Get_WEC_fromLogicalPacket(current_packet_ptr, wec_reg)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, wec_reg);
}

#PSL_define f_Get_ProfileType_fromLogicalPacket(current_packet_ptr, prof_type)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, prof_type);
}

#PSL_define f_Get_ProfileAnsCount_fromLogicalPacket(current_packet_ptr,
						                    ans_count)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, ans_count);
}

#PSL_define f_Get_ProfileNestLevel_fromLogicalPacket(current_packet_ptr,
						                   nest_level)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, nest_level);
}

#PSL_define f_Get_ProfileCLNum_fromLogicalPacket(current_packet_ptr, cl_num)
{
  s_Get_1_Data_fromLogicalPacket(current_packet_ptr, cl_num);
}

#PSL_define f_Get_ProfileData_fromLogicalPacket(current_packet_ptr, prof_data)
{
  $CALL( f_Get_Data_Level0_fromLogicalPacket_Sub(current_packet_ptr,
						                 prof_data) );
}

/******************************************************************** PSL **
4. $BO@M}%Q%1%C%H$+$i(B%unify$B%a%C%;!<%8$N0z?t#1$r<h$j=P$9(B
                   %read$B%a%C%;!<%8$NFI$_=P$9BP>]$X$N%]%$%s%?$r<h$j=P$9(B

       written by nakase@icot22      on Wed Jun 27 14:55:22 1990

<Arguments>
  packet_ptr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
  arg1_ptr:   %unify$B%a%C%;!<%8$N0z?t#1$X$N%]%$%s%?(B
 (read_data:  %read$B%a%C%;!<%8$NFI$_=P$9BP>]$X$N%]%$%s%?(B)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkClNum XXX

#PSL_define f_Get_UnifyArg1_fromLogicalPacket(packet_ptr, arg1_ptr)
{
  $USE(D_WorkExrefId);
  s_Get_1_Data_fromLogicalPacket(packet_ptr, D_WorkExrefId);  

  @DEBUG{
    $USE(D_WorkClNum);
    s_GetClusterNum(D_WorkExrefId, D_WorkClNum);
    b_IfNotEqual(D_WorkClNum, D_CL_Number){
      VPIM_ERROR("f_Get_ExportedData_fromLogicalPacket",
		 "Illegal CLNum %unify Arg1");
      /* %Unify$B$N0z?t#1$N30It;2>H#I#D$,<+J,$N=P$7$?%G!<%?$G$J$$>l9g$O!"(B
	 $B%(%i!<$H$9$k!#(B*/
    }
    $RELEASE(D_WorkClNum);
  };
  
  TypeSwitch(D_WorkExrefId){
    case WEXTGrp():
      $CALL( f_Get_WExRef_fromLogicalPacket_Sub(D_WorkExrefId, arg1_ptr) );
      break;
    case BEXTGrp():
      $CALL( f_Get_BExRef_Read_fromLogicalPacket_Sub
	                         (packet_ptr, D_WorkExrefId, arg1_ptr) );
      break;
    default:
      @DEBUG{
	VPIM_ERROR("f_Get_UnifyArg1_fromLogicalPacket",
		   "Illegal Type %Unify Arg1");
      };
    }
  $RELEASE(D_WorkExrefId);
}

#PSL_define f_Get_ReadData_fromLogicalPacket(packet_ptr, read_data, struct_flag)
{
  $USE(D_WorkExrefId);
  s_Get_1_Data_fromLogicalPacket(packet_ptr, D_WorkExrefId);  

  s_IfStructFlagOn(D_WorkExrefId) {
    p_MoveWord(D_ONE, struct_flag);
  } else {
    p_MoveWord(D_NULL, struct_flag);
  }

  @DEBUG{
    $USE(D_WorkClNum);
    s_GetClusterNum(D_WorkExrefId, D_WorkClNum);
    b_IfNotEqual(D_WorkClNum, D_CL_Number){
      VPIM_ERROR("f_Get_ExportedData_fromLogicalPacket",
		 "Illegal CLNum %unify Arg1");
    }
    $RELEASE(D_WorkClNum);
  };
  
  TypeSwitch(D_WorkExrefId){
    case WEXTGrp():
      $CALL( f_Get_WExRef_fromLogicalPacket_Sub(D_WorkExrefId, read_data) );
      break;
    case BEXTGrp():
      $CALL( f_Get_BExRef_Read_fromLogicalPacket_Sub
	                           (packet_ptr, D_WorkExrefId, read_data) );
      break;
    default:
      @DEBUG {
	VPIM_ERROR("f_Get_ReadData_fromLogicalPacket",
		   "Illegal Type %Unify Arg1");
      };
    }
  $RELEASE(D_WorkExrefId);
}

#PSL_define f_Get_Req_BEXID_WEX_Data_fromLogicalPacket
                                 (packet_ptr, read_data, safe_flag)
{
  $USE(D_WorkExrefId);
  s_Get_1_Data_fromLogicalPacket(packet_ptr, D_WorkExrefId);  

  s_IfUnsafe(D_WorkExrefId){
    p_MoveWord(D_ONE, safe_flag);
  } else {
    p_MoveWord(D_NULL, safe_flag);    
  }

  @DEBUG{
    $USE(D_WorkClNum);
    s_GetClusterNum(D_WorkExrefId, D_WorkClNum);
    b_IfNotEqual(D_WorkClNum, D_CL_Number){
      VPIM_ERROR("f_Get_ExportedData_fromLogicalPacket",
		 "Illegal CLNum %unify Arg1");
      /* %Unify$B$N0z?t#1$N30It;2>H#I#D$,<+J,$N=P$7$?%G!<%?$G$J$$>l9g$O!"(B
	 $B%(%i!<$H$9$k!#(B*/
    }
    $RELEASE(D_WorkClNum);
  };

  $CALL( f_Get_WExRef_fromLogicalPacket_Sub(D_WorkExrefId, read_data) );
  
/**********
  @DEBUG{
    WARNING("f_Get_ExportedData_fromLogicalPacket_SupplyBEXID",
	    "Receive Request BEXID ");
    preg(D_WorkExrefId);
  };
********** $BL$$@>C$5$J$$$G(B */
  $RELEASE(D_WorkExrefId);
}

#PSL_define f_Get_Req_BEXID_BEX_Data_fromLogicalPacket
                               (packet_ptr, read_data, safe_flag, struct_id)
{
  $USE(D_WorkExrefId);
  s_Get_1_Data_fromLogicalPacket(packet_ptr, D_WorkExrefId);  

  s_IfUnsafe(D_WorkExrefId){
    p_MoveWord(D_ONE, safe_flag);
  } else {
    p_MoveWord(D_NULL, safe_flag);    
  }

  @DEBUG{
    $USE(D_WorkClNum);
    s_GetClusterNum(D_WorkExrefId, D_WorkClNum);
    b_IfNotEqual(D_WorkClNum, D_CL_Number){
      VPIM_ERROR("f_Get_ExportedData_fromLogicalPacket",
		 "Illegal CLNum %unify Arg1");
      /* %Unify$B$N0z?t#1$N30It;2>H#I#D$,<+J,$N=P$7$?%G!<%?$G$J$$>l9g$O!"(B
	 $B%(%i!<$H$9$k!#(B*/
    }
    $RELEASE(D_WorkClNum);
  };
  
  $CALL( f_Get_BExRef_ReqBEXID_fromLogicalPacket_Sub
	              (packet_ptr, D_WorkExrefId, read_data) );

  s_IfStructFlagOn(D_WorkExrefId) {
    $USE(D_WorkModPtr);
 Retry_Label:
    f_ActiveDeref(read_data, D_WorkModPtr);
    TypeSwitch(read_data) {
    case EX_Grp():
      /* $B%b%8%e!<%k$rM"F~$7$F!"9=B$BNI=$r%j%O%C%7%e$7$h$&$H$9$k!J$7$F$$$k!K(B
	 PE $B$,$$$k$+$bCN$l$J$$$N$G!"%m%C%/$r$+$1$F$+$i9=B$BN(BID$B$rF@$k(B */
      s_IfSuccessSoftLockExCell(D_WorkModPtr, read_data) {
	$CALL( s_GetStructIdStrRec_Sub(D_WorkModPtr, struct_id) );
      } else {
	p_MoveWord(D_WorkModPtr, read_data);
	goto Retry_Label;
      }
      s_SoftUnlockExCell(D_WorkModPtr, read_data);
      p_MoveWord(D_WorkModPtr, read_data);
      break;
    case EXLOCK:
      p_MoveWord(D_WorkModPtr, read_data);
      goto Retry_Label;
      break;
    case MOD:
      $CALL( s_GetStructIdStrRec_Sub(read_data, struct_id) );
      break;
    default:
      @DEBUG{
	VPIM_ERROR("f_Get_Req_BEXID_BEX_Data_fromLogicalPacket",
		   "Invalid type of ptr_to_module");
      };
    }
    $RELEASE(D_WorkModPtr);
  } else {
    p_MoveWord(D_ALL1, struct_id);
  }

/**********
  @DEBUG{
    WARNING("f_Get_ExportedData_fromLogicalPacket_SupplyBEXID",
	    "Receive Request BEXID ");
    preg(D_WorkExrefId);
  };
********** $BL$$@>C$5$J$$$G(B */
  $RELEASE(D_WorkExrefId);
}

#PSL_define f_Get_ReleasedExRefID_fromLogicalPacket(packet_ptr, rel_exref_id)
{
  s_Get_1_Data_fromLogicalPacket(packet_ptr, rel_exref_id);  
}

/******************************************************************** PSL **
5. $BO@M}%Q%1%C%H$+$i(B%answer_value$B%a%C%;!<%8$NJV?.@h$X$N%]%$%s%?$r<h$j=P$9(B

f_Get_Answer_Return_Data_fromLogicalPacket

       written by nakase@icot22      on Wed Jun 27 22:43:21 1990

<Arguments>
  packet_ptr: $BO@M}%Q%1%C%H$X$N%]%$%s%?(B
  ptr_to_excell: %Answer_Value$B%a%C%;!<%8$NJV?.@h!J30It;2>H%;%k$X$N%]%$%s%?!K(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_Get_Answer_Return_Data_fromLogicalPacket
                                     (packet_ptr, ptr_to_excell)
{
  $USE(D_WorkExrefId);
  s_Get_1_Data_fromLogicalPacket(packet_ptr, D_WorkExrefId);  
  s_GetWExpDataAndReclaimExpEntry(D_WorkExrefId, ptr_to_excell);
  $RELEASE(D_WorkExrefId);
}
