
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_gc_inter_cluster.psl.c
   ----- CREATED   : by imai@icot22, on Thu Mar 22 14:30:11 1990
   ----- LAST SAVED: by imai@icot22, on Thu Jul 16 20:16:12 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#SUBROUTINE	f_ScanWImpRecAfterGC_Sub()
{
  @DEBUG{WARNING("f_ScanWImpRecAfterGC","Scanning White Import Table");};
  $USE(D_WorkAddr);  $USE(D_WorkEntrySize); $USE(D_WorkElement);
  b_SetImmTypeValueMRBoff(WEXREF,_WIMP_REC_BASE,D_WorkAddr);
  b_SetImmValueDNTC(_WIMP_REC_ENTRY_NUM,D_WorkEntrySize);
  LOOP(){
    p_Read(D_WorkAddr,D_WorkElement);
    TypeSwitch(D_WorkElement) {
    case EOL:
    case FLC:		/* $B2?$b$7$J$$$G$h$$(B */
      break;
    case MARKED:	/* $B$^$@@8$-$F$$$k$N$G!"(BINT $B$KLa$9(B */
      b_SetImmTypeMRBoff(INT,D_WorkElement);
      p_Write(D_WorkElement,D_WorkAddr);
      break;
    case INT:		/* $B#G#C$K$h$C$FITMW$K$J$C$?$3$H$,H=L@$7$?(B */
      $CALL( f_Send_IntClMsg_Release_Sub(D_WorkAddr) );
      b_SetImmTypeMRBoff(WEXREF,D_WorkAddr);
      /* s_ReclaimWImpRec(D_WorkAddr); $B$K$h$k2s<}$O>e5-%5%V%k!<%A%s$NCf(B */
      break;
    default:
      @DEBUG{VPIM_ERROR("f_ScanWImpRecAfterGC","Illegal Type:D_WorkElement");};
    }
    b_IncrementAddrReg(D_WorkAddr);
    b_DecrementReg(D_WorkEntrySize);
    p_IfEQ() { break; }
  }
  $RELEASE(D_WorkElement); $RELEASE(D_WorkEntrySize);  $RELEASE(D_WorkAddr);
  $RETURN();
}


/******************************************************************** PSL **
f_ScanBImpRecAfterGC()
       written by imai@icot22      on Tue Mar 13 18:43:24 1990
<Arguments>
  $B$J$7(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B#1#P#E$,8F$V(B
<Function>
  $B9uM"F~I=%O%C%7%e%F!<%V%k$+$iA4$F$N9uM"F~I=%(%s%H%j$r$?$I$k(B
  1. $B4{$K;2>H$,$J$/$J$C$F$$$?>l9g$O!"(B%release $B$rAw=P$9$k(B
<Examples>
<Test>
<Explanation>
  $BM"F~I=$O#I#D$G%O%C%7%e$7$F$$$k$N$G!"%O%C%7%eCM$,#G#C$GJQ2=$9$k$3$H$O$J$$(B
<ETC>

<< $B%9%-%c%sA0(B >>
($B8GDjNN0h(B)
BImpHashTBL
|	|
|	|
|-------|	+-------+	+-------+	+-------+	+-------+
|      -------->|MARKED---+  +->|INT! ID|   +-->|MARKED---+  +->|INT! ID|
|-------|	|-------| |  |	|-------|   |	|-------| |  |	|-------|
|	|	|       | |  |	|       |   |	|       | |  |	|       |
	($B5lNN0h(B)|       | |  |	|       |   |	|       | |  |	|       |
		|-------| |  |	|-------|   |	|-------| |  |	|-------|
		|HLINK ---|--+	|HLINK -----+	|HLINK ---|--+	|EOL $B!&(B |
		+-------+ |  |	+-------+	+-------+ |  |	+-------+
			  |  |				  |  |
			  |  |				  |  |
		+-------+ |  |			+-------+ |  |
		|INT! ID|<+  |			|INT! ID|<+  |
		|-------|    |			|-------|    |
	($B?7NN0h(B)|       |    |			|       |    |
		|       |    |			|       |    |
		|-------|    |			|-------|    |
		|HLINK ------+			|HLINK ------+
		+-------+			+-------+

<< $B%9%-%c%s8e(B >>
($B8GDjNN0h(B)
BImpHashTBL
|	|
|	|			%release-->			%release-->
|-------|	+-------+	+-------+	+-------+	+-------+
|      ----+    |MARKED---+  +->|INT! ID|   +-->|MARKED---+  +->|INT! ID|
|-------|  |	|-------| |  |	|-------|   |	|-------| |  |	|-------|
|	|  |	|       | |  |	|       |   |	|       | |  |	|       |
	($B5lNN0h(B)|       | |  |	|       |   |	|       | |  |	|       |
	   |	|-------| |  |	|-------|   |	|-------| |  |	|-------|
	   |	|HLINK ---|--+	|HLINK -----+	|HLINK ---|--+	|EOL $B!&(B |
	   |	+-------+ |	+-------+	+-------+ |	+-------+
	   |		  |				  |
	   |		  |				  |
	   |	+-------+ |			+-------+ |
	   +--->|INT! ID|<+	    +---------->|INT! ID|<+
		|-------|	    |		|-------|
	($B?7NN0h(B)|       |	    |		|       |
		|       |	    |		|       |
		|-------|	    |		|-------|
		|HLINK -------------+		|EOL $B!&(B |
		+-------+			+-------+

********************************************************************* PSL **/

#DATA_define D_WorkEntrySize    XXX
#DATA_define D_WorkNewLink	XXX

#SUBARG_define	A_ReleaseBImpRecLink	DST
#SUBARG_define	A_DeadLockGoalFlagReg	DST

#SUBROUTINE	f_ScanBImpRecAfterGC_Sub
	(A_ReleaseBImpRecLink,A_DeadLockGoalFlagReg)
{
  @DEBUG{WARNING("f_ScanBImpRecAfterGC","Scanning Black Import Table");};
  $USE(D_WorkAddr); $USE(D_WorkEntrySize);
  $USE(D_WorkLink); $USE(D_WorkNewLink);
  $USE(D_WorkElement);
  b_SetImmTypeValueMRBoff(BEXREF,_BIMP_HASH_TBL_BASE,D_WorkAddr);
  b_SetImmValueDNTC(_BIMP_HASH_TBL_SIZE,D_WorkEntrySize);
  b_SetZero(A_DeadLockGoalFlagReg);
  b_SetEOL(A_ReleaseBImpRecLink);

  LOOP() {
    /*--- $B%O%C%7%e%F!<%V%k%(%s%H%j$r#1$D$:$D=g$KD4$Y$k(B LOOP() ---*/
    p_MoveWord(D_WorkAddr,D_WorkNewLink);
    p_Read(D_WorkNewLink,D_WorkLink);
    LOOP() {
      /*--- $BF1$8%O%C%7%e4X?tCM$r;}$D%l%3!<%I$N%j%s%/$r$?$I$k(B LOOP() ---*/
      @DEBUG{
	b_IfNotEOL(D_WorkLink) {
	  s_IfNewArea(D_WorkLink) {
	    VPIM_ERROR("f_ScanBImpRecAfterGC","Illegal D_WorkLink");
	  }}};
      b_IfEOL(D_WorkLink) {
	p_Write(D_EOL,D_WorkNewLink);
	break;
      }
      $USE(D_WorkEXCell);
      s_GetExcellBImpRec(D_WorkLink,D_WorkEXCell);
      /* $BN$?F$N>l9g$O!"%A%c%$%k%I%+%&%s%H$N%A%'%C%/$r9T$J$&(B */
      s_IfFPREC(D_WorkEXCell) {
	@DEBUG{
	  s_IfAbortedTerminateFP(D_WorkEXCell) {
		/* AbortedTerminated $B$N>l9g$O!"M"F~I=$+$i8+$D$+$k$O$:$,$J$$(B */
	    VPIM_ERROR("f_ScanBImpRecAfterGC_Sub",
		       "Why AbortedTerminated FP is linked to BImpTable");
	  }
	};
	s_IfAbortedFP(D_WorkEXCell) {
	  /* Nothing To Do!! */
	} else {
	  s_CheckChildCount(D_WorkEXCell,A_DeadLockGoalFlagReg);
	}
      }
      $RELEASE(D_WorkEXCell);
      p_Read(D_WorkLink,D_WorkElement);	/* $B#G#C;~$K%^!<%/$,IU$1$i$l$k>l=j(B */
      s_IfMarked(D_WorkElement) {
	/*=========================================== $B#G#C8e$bM-8z$J%(%s%H%j(B */
	b_SetImmTypeMRBoff(HLINK,D_WorkElement);
	p_Write(D_WorkElement,D_WorkNewLink);
	b_AddImmediateWithDNTC(D_WorkElement,_BIMP_CHAIN_OFST,D_WorkNewLink);
	@DEBUG{
	  s_IfNotNewArea(D_WorkNewLink) {
	    VPIM_ERROR("f_ScanBImpRecAfterGC","Illegal D_WorkNewLink");
	  }};
	s_GetChainBImpRec(D_WorkLink,D_WorkLink);
      } else {
	/*======================= $B#G#C$K$h$C$FITMW$G$"$k$HH=Dj$5$l$?%(%s%H%j(B */
	b_SetImmTypeMRBoff(BEXREF,D_WorkLink);
	/* modified on 1992.07.16 by imai not to send message here */
        /* $CALL(f_Send_IntClMsg_Release_BEX_AfterGC_Sub(D_WorkLink)); */
	$USE(D_WorkBImpRecord);
	p_MoveWord( D_WorkLink, D_WorkBImpRecord);
	s_GetChainBImpRec(D_WorkLink,D_WorkLink);
	b_PushLink( D_WorkBImpRecord, A_ReleaseBImpRecLink, _BIMP_CHAIN_OFST );
	$RELEASE(D_WorkBImpRecord);
      }
    }
    b_IncrementAddrReg(D_WorkAddr);
    b_DecrementAddrReg(D_WorkEntrySize);
    p_IfEQ() { break; }
  }
  $RELEASE(D_WorkAddr);  $RELEASE(D_WorkLink);
  $RELEASE(D_WorkNewLink);  $RELEASE(D_WorkElement);
  $RELEASE(D_WorkEntrySize);
  $RETURN();
}

#SUBARG_define A_BImpLinkTop	MODIFY

#SUBROUTINE	f_SendBImpReleaseMsgAfterGC_Sub( A_BImpLinkTop )
{
  $USE(D_WorkAddr);
  b_IfEOL(A_BImpLinkTop) { goto End; }
  LOOP() {
    b_PopLink(D_WorkAddr, A_BImpLinkTop, _BIMP_CHAIN_OFST );
    $CALL( f_Send_IntClMsg_Release_BEX_AfterGC_Sub(D_WorkAddr) );
    b_IfEOL(A_BImpLinkTop) { break; }
  }
 End:
  $RELEASE(D_WorkAddr); $RETURN();
}

/******************************************************************** PSL **
f_RehashBExpRecAfterGC()
     $B%3%T!<8e9uM"=PI=$N%a%s%F%J%s%9$r9T$J$&(B
       written by imai@icot22      on Thu Aug  2 10:21:30 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B9uM"=PI=$OM"=P$5$l$?%G!<%?$N%"%I%l%9$K$h$C$F%O%C%7%e$7$F$$$k$?$a(B
  $B#G#C$G%"%I%l%9$,JQ2=$9$k$N$G%j%O%C%7%e$r9T$J$&(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBROUTINE f_RehashBExpRecAfterGC_Sub()
{
  @DEBUG{WARNING("f_RehashBExpRecAfterGC","Rehashing Black Export Table");};
  s_RehashBlackExportHashTableAfterGC();
  $RETURN();
}


/******************************************************************** PSL **
f_MaintainStructTable
       written by imai@icot22      on Mon Apr  2 15:17:00 1990
<Arguments>
  $B$J$7(B
<Temporally Used Variables>
<Level>
<PreCondition>
  $B#G#C=*N;8e!"%U%j!<%j%9%H$r:n@.$7$F$+$i8F$V(B
<Function>
<Examples>
<Test>
<Explanation>
  $B9=B$BN#I#D$O!"#G#C$K$h$C$FJQ2=$7$J$$!#(B
  $B$@$@$7!"#G#C$K$h$C$F%3%T!<$5$l$J$+$C$?9=B$BN%l%3!<%I$O!"(B
  $B:o=|$9$kI,MW$,$"$k!#(B

  $B9=B$BN%l%3!<%I<+BN$b%R!<%W$K$H$i$l$k$N$G!"%3%T!<$,I,MW$G$"$k(B
<ETC>
********************************************************************* PSL **/

#SUBROUTINE f_MaintainStructTable_Sub()
{
  $USE(D_WorkChainTop);
  @DEBUG{
    WARNING("f_MaintainStructTable","Maintaining Structure Table");
  };
  /* $B#I#D%O%C%7%eI=$r%*!<%k%/%j%"$9$k$H$H$b$K!"%l%3!<%I$r0lK\2=$9$k(B */
  s_ClearIDHashAndConnectStructTable(D_WorkChainTop);
  /* $B%"%I%l%9%O%C%7%eI=$r%*!<%k%/%j%"$9$k(B */
  s_ClearAddressHashStructTable();
  /* $B0lK\2=$5$l$?%A%'%$%s$r$?$I$j!"$7$+$k$Y$-%O%C%7%eCM$N$H$3$m$X(B
   * $B%W%C%7%e$7$F$f$/(B
   */
  s_PushStrTableRecordIntoHashLink(D_WorkChainTop);
  $RELEASE(D_WorkChainTop);
  $RETURN();
}

