
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_fp_recv_message.psl.c
   ----- CREATED   : by yamamoto@icot22, on Fri May 25 11:01:36 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Jul 13 16:32:44 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : $BAq1`$+$iN$?F$X$KAw$i$l$?%a%C%;!<%8$r=hM}$9$k!#(B

(0) $B35MW(B
    $B<g$K!"N$?F$,(B($B%M%C%H%o!<%/$J$I$rDL$7$F(B)$B%a%C%;!<%8$r<u$1<h$C$?:]$N=hM}$r9T$J(B
$B$&%^%/%m72$G$"$k!#%9%j%C%H%A%'%C%/$N%?%$%_%s%0$G!"%a%C%;!<%8%O%s%I%i(B
$B$+$i8F$S=P$5$l$k!#(B

1. $BN$?F$N@)8f(B
   $BN$?F$O%4!<%k$NB8:_$9$k%/%i%9%?$K$"$k%4!<%k4IM}$N$?$a$N%G!<%?9=B$$G$"$k!#N$?F(B
$B$O!"?FAq1`$+$iAw$i$l$F$/$k%a%C%;!<%8$K$h$jI,MW$K1~$8$F$=$N>uBV$rJQ2=$5$;$k!#(B
   $B$^$?!"N$?F$O$=$l$>$l<+J,$,>CHq$7$F$bNI$$;q8;NL$N%j%_%C%H$r;}$C$F$*$j!"%4!<%k(B
$B$r<B9T$9$k>l9g$K$O$=$N%4!<%k$,B0$9$kN$?F$N>uBV5Z$S;q8;NL$,%A%'%C%/$5$l$k!#(B

 1.1 $B%M%C%H%o!<%/$rDL$8$F<u$1<h$C$?%a%C%;!<%8$N=hM}(B
     $BN$?F$N?FAq1`$KBP$7$FAH$_9~$_=R8l$,<B9T$5$l$?>l9g$J$I!"Aq1`$N>uBV$,JQ2=$9$k(B
$B$3$H$,$"$k!#$3$N$h$&$J;~!"Aq1`$N>uBV$NJQ2=$O!"%M%C%H%o!<%/$J$I$rDL$8$F%a%C%;!<(B
$B%8$N7A$GN$?F$KDLCN$5$l$k!#<B:]$KAw$i$l$F$/$k%a%C%;!<%8$K$O0J2<$N$h$&$J$b$N$,$"(B
$B$k!#(B
    start : $BAq1`$,%9%?!<%H$7$?(B
    stop : $BAq1`$,%9%H%C%W$7$?(B
    abort : $BAq1`$,%"%\!<%H$5$l$?(B
    supply_resource : $B;q8;$,DI2C$5$l$?(B
    supply_WTC : WTC$B$,DI2C$5$l$?(B
    ask_statistics : $B>CHq;q8;NL$NLd$$9g$o$;(B
     $B$3$l$i$N%a%C%;!<%8$O%M%C%H%o!<%/%O%s%I%i$+$i%/%i%9%?$KAw$i$l!"%9%j%C%H%A%'(B
$B%C%/;~$K$3$l$i$N=hM}%k!<%A%s$,8F$S=P$5$l$k!#(B
 1.2 $BN$?F<+?H$N>uBV$NJQ2=$KH<$&=hM}(B
     $BN$?F$N2<$G%4!<%k$,<B9T$5$l$k$H!"$=$N<B9T$KH<$C$F$5$^$6$^$J;v>]$,5/$3$k!#$3(B
$B$l$i$N;v>]$KBP=h$9$k$?$a$K!";v>]$r8!=P$7$?;~E@$G$=$l$>$l$N=hM}%k!<%A%s$,8F$S=P(B
$B$5$l$k!#<g$J;v>]$H$7$F$O!"0J2<$N$h$&$J$b$N$,5s$2$i$l$k!#(B
  fp_terminate : $BN$?F$N2<$K%4!<%k(B($B$*$h$SAq1`(B)$B$,L5$/$J$C$?(B
  resource_supplied : $B;q8;$,6!5k$5$l$?(B
  request_resource : $B;q8;$,ITB-$7$?(B
  answer_statistics : $B>CHq;q8;NL$NLd$$9g$o$;$KEz$($k(B
     $B$3$l$i$N;v>]$r=hM}$9$k%k!<%A%s$O!"(Bexecute$B$d(Bproceed$B$J$I$N%?%$%_%s%0$G;v>]$r(B
$B8!=P$7$?$H$-$K8F$S=P$5$l$k!#(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

  f_DecrementChildCountAndTerminateFPIfNoChild(fp_ptr_reg)

  $BN$?F$,%a%C%;!<%8$r<u$1$H$C$?:]$K!"2>$KA}$d$7$?(Bchild_count$B$r#18:$i$9!#(B

$B!cCm0U!d(B
  $B%;%k%U%$%s%?%i%W%H$G%a%C%;!<%8<u?.=hM}$r@hAw$j$9$k>l9g!"(B
  childe_count$B$r#1A}$d$7!"(B(SyncroDecacheXxxxx$B$H$$$&#3<o$N%^%/%m$NCf(B)
  $B%;%k%U%$%s%?%i%W%H<u?.=hM}$N:G8e$G$3$N%^%/%m$r8F$V!#(B
  $B!J6qBNE*$K$O!"(Bf_RetryGatherFPResource $B$G8F$V!K(B

       written by yamamoto@icot22      on Fri May 25 11:01:40 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_DecrementChildCountAndTerminateFPIfNoChild(fp_ptr_reg)
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_ptr_reg,D_WorkFPOrgLockTagReg);
  s_DecrementFPChildCount(fp_ptr_reg);
  s_DecrementFPStatGatherEventCount(fp_ptr_reg);
  s_IfNoChild(fp_ptr_reg){
    $CALL(f_FPTerminateWithUnlockFP_Sub(fp_ptr_reg,D_WorkFPOrgLockTagReg));
    $RELEASE(D_WorkFPOrgLockTagReg);
  }else{
/* ABORTED $B$G!"(BChildCount NON-ZERO $B$G(B $B$=$l$,%4!<%k$@$1$N;~!"(B*/
/*   $B$9$J$o$A!";RAq1`$,L5$/(B $B$+$D(B StatGatherEventCount ZERO  */
/* $B"M!"$3$3$G%?!<%_%M%$%H%a%C%;!<%8$r>e$2$F$*$+$J$$$H5!2q$r0o$9$k>l9gM-$j(B */
/* $B"M!"$3$3$G>e$2$F$7$^$&(B */
/* $BCm0U!'(B StatGatherEventCount $B$K$O@hAw$j=hM}$N$[$+$K=hM}Cf%a%C%;!<%8$b(B   */
/* $B%+%&%s%H$5$l$F$$$k(B */
    s_IfAbortedFP(fp_ptr_reg){
      s_IfNoStatGatherEvent(fp_ptr_reg){
	$USE(D_Work_FP_Child_Link_Reg);
	s_GetFPRightChildShoenLink(fp_ptr_reg,D_Work_FP_Child_Link_Reg);
	b_IfEqual(fp_ptr_reg,D_Work_FP_Child_Link_Reg){
	  $RELEASE(D_Work_FP_Child_Link_Reg);
	  $CALL( f_FPTerminateWithUnlockFPWithoutReclaimFP_Sub(fp_ptr_reg,
						      D_WorkFPOrgLockTagReg));
          /* ReclaimFP $BL5$7$N(B abort $B;~@lMQ$N%^%/%m$r8F$V(B */
          /* $BN$?F$N%"%s%m%C%/$b$3$NCf$G$d$k(B */
	  $RELEASE(D_WorkFPOrgLockTagReg);
	}else{
	  $RELEASE(D_Work_FP_Child_Link_Reg);
	  s_UnlockFPRecord(fp_ptr_reg,D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	}
      }else{
	s_UnlockFPRecord(fp_ptr_reg,D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
      }
    }else{
      s_UnlockFPRecord(fp_ptr_reg,D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
    }
  }
}


/******************************************************************** PSL **

  f_FPReceiveStart(fp_record)

       written by kawai@icot21      on Thu Jun  1 16:34:32 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Status_Reg : $BN$?F$NO@M}%9%F!<%?%9$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  function
<PreCondition>
<Function>
  $B%M%C%H%o!<%/7PM3$GN$?F08$F$KAw$i$l$F$-$?(Bstart$B%a%C%;!<%8$r=hM}$9$k!#(B
  $B6qBNE*$K$O!"(B
    $B!&N$?F$N>uBV$r(B stopped $B"*(B started $B$H$9$k!#(B
    $B!&N$?F$,(Bstopped$B$@$C$?$?$a$K<B9T$G$-$J$+$C$?%4!<%k$r%l%G%#!<%-%e!<$KF~$l$k!#(B
    $B!&;RAq1`$r$9$Y$F(B start_by_parent $B$H$9$k!#(B
  $B%a%C%;!<%8$NAw?.85$N%/%i%9%?$,N$?F$N$"$k%/%i%9%?$HF10l$+H]$+$O6hJL$7$J$$!#(B
  $B$3$N%^%/%m$O%M%C%H%o!<%/%a%C%;!<%8<u?.%O%s%I%i$+$i8F$S=P$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define   f_FPReceiveStart(fp_record)
{
  @DEBUG{
    _PrintFPInfo(fp_record);
    WARNING("f_FPReceiveStart","FP Received Start message");
  };

  $USE(D_Work_FP_Status_Reg);
  $USE(D_WorkFPOrgLockTagReg);
  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);

  /* $BN$?F$N;RAq1`$r@8@.$9$k>l9g!"N$?F$N>uBV(B(start/stop)$B$O;RAq1`$N=i4|CM$K(B
     $BH?1G$5$l$k!#$3$N$?$a!"N$?F$N>uBV$rJQ$($k%^%/%m$NCf$G$O!";RAq1`%j%s%/(B
     $B$bF1;~$K%m%C%/$7$F$*$/I,MW$,$"$k!#(B
  */
  s_LockFPChildShoenLink(fp_record,D_WorkFPChildShoenLinkOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

  s_GetFPTransitStatus(fp_record, D_Work_FP_Status_Reg);
  ValueSwitch(D_Work_FP_Status_Reg)
    {
    case _FP_STOPPED :
      $USE(D_WorkFPSSC);
      s_IncrementFPStartStopCount(fp_record,D_WorkFPSSC);
      b_IfZero(D_WorkFPSSC){
	/* stop -> start , this is main path */
	s_PutFPTransitStatusImm(fp_record, _FP_STARTED);
	
	@DEBUG{
	  WARNING("f_FPReceiveStart","All Stopped Goals will be resumed");
	};

	$USE(D_Work_FP_Stopped_Goals);
	s_GetFPStoppedGoals(fp_record, D_Work_FP_Stopped_Goals);	
	s_PutFPStoppedGoals(fp_record, D_EOL);
	
	s_IfExhaustedFPResource(fp_record){
	  $CALL( f_FPRequestResourceWithoutLock_Sub(fp_record) );
	  /*
	   * $BAq1`@8@.;~$K:n$i$l$kN$?F$G$O!"=i$a$F(Bstart$B$H$$$o$l$?;~$K(B
	   * $B%j%=!<%9$,L5$$$N$G!"%j%/%(%9%H%j%=!<%9$r=P$9I,MW$,$"$k!#(B
	   * $BCm0U!'>e5-%5%V%k!<%A%s$O<B:]$O%A%'%C%/$@$1$r9T$J$&!#(B
	   * $B%a%C%;!<%8$N%;%s%I$ON$?F$r%"%s%m%C%/$7$F$+$i9T$J$&!#(B
	   *				    91-11-21 yamamoto
	   */
	  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);

	  b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
	    $CALL(f_Send_IntClMsg_Request_Resource_Sub(fp_record));
	    p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
	  }
	}else{
	  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	}

	$CALL( f_ResumeAllStoppedGoals_Sub(D_Work_FP_Stopped_Goals) );
	$RELEASE(D_Work_FP_Stopped_Goals);	

	f_StartAllChildShoen(fp_record);
      }else{
	/* stop -> stop */
	@DEBUG{
	  WARNING("f_FPReceiveStart", "still stop -> stop ...");
	};
	s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
      }
      $RELEASE(D_WorkFPSSC);
      break;

    case _FP_STARTED :
      /* start -> start */
      s_IncrementFPStartStopCount(fp_record,D_VOID);
      @DEBUG{
	WARNING("f_FPReceiveStart", "oh! start -> start !!");
      };
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      break;
      
    case _FP_ABORTED :
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      @DEBUG{
	WARNING("f_FPReceiveStart", "start message to Aborted FP");
      };
      break;
    default :
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      @DEBUG{
	VPIM_ERROR("f_FPReceiveStart", "Receive _STARTED to Illegal state FP");
      };
      break;
    }
  s_UnlockFPChildShoenLink(fp_record,
				 D_WorkFPChildShoenLinkOrgLockTagReg);

  $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);
  $RELEASE(D_Work_FP_Status_Reg);
}

/******************************************************************** PSL **

  f_FPReceiveStop(fp_record)

       written by kawai@icot21      on Thu Jun  1 16:35:34 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Status_Reg : $BN$?F$NO@M}%9%F!<%?%9$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  function
<PreCondition>
<Function>
  $B%M%C%H%o!<%/7PM3$GN$?F08$F$KAw$i$l$F$-$?(Bstop$B%a%C%;!<%8$r=hM}$9$k!#(B
  $B%a%C%;!<%8$NAw?.85$N%/%i%9%?$,N$?F$N$"$k%/%i%9%?$HF10l$+H]$+$O6hJL$7$J$$!#(B
  $B$3$N%^%/%m$O%M%C%H%o!<%/%a%C%;!<%8<u?.%O%s%I%i$+$i8F$S=P$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define     f_FPReceiveStop(fp_record)
{
  @DEBUG{
    _PrintFPInfo(fp_record);
    WARNING("f_FPReceiveStop","FP Received Stop message");
  };

  $USE(D_Work_FP_Status_Reg);
  $USE(D_WorkFPOrgLockTagReg);
  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);

  /* $BN$?F$N;RAq1`$r@8@.$9$k>l9g!"N$?F$N>uBV(B(start/stop)$B$O;RAq1`$N=i4|CM$K(B
     $BH?1G$5$l$k!#$3$N$?$a!"N$?F$N>uBV$rJQ$($k%^%/%m$NCf$G$O!";RAq1`%j%s%/(B
     $B$bF1;~$K%m%C%/$7$F$*$/I,MW$,$"$k!#(B
  */
  s_LockFPChildShoenLink(fp_record,D_WorkFPChildShoenLinkOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

  s_GetFPTransitStatus(fp_record, D_Work_FP_Status_Reg);
  ValueSwitch(D_Work_FP_Status_Reg){
  case _FP_STARTED :
      $USE(D_WorkFPSSC);
      s_DecrementFPStartStopCount(fp_record,D_WorkFPSSC);
      b_IfEqual(D_WorkFPSSC,D_ALL1){
	/* start -> stop, this is the main path */

	s_PutFPTransitStatusImm(fp_record, _FP_STOPPED);
	
	/*  $B%9%j%C%H%A%'%C%/$r;H$C$FN$?F$N>uBVJQ2=(B(started -> stopped)$B$rA4(BPE$B$K(B
	  $BDLCN$9$k!#(B
	    */
	@DEBUG{
	  WARNING("f_FPReceiveStop","BC Signal will be Sent");
	};
	
	b_SendBCSignal(_FP_STATUS_CHECK_EVENT);
	
	b_IfEqual(fp_record, D_Current_FP_Ptr)
	  { /* $BD>A0$K<B9T$7$?%4!<%k$NN$?F$,;_$a$i$l$?$i!"%-%c%C%7%e;q8;$r(B
	      $B0lC6(B0$B$K$7!"(BCGP$B$r6u$K$9$k$3$H$K$h$C$F!"<!%4!<%k$N%9%1%8%e!<%k;~$K(B
		$BN$?F$N>uBV$r%A%'%C%/$9$k$h$&$K$9$k!#(B
		  */

	    f_DecacheFPResourceCount(D_Current_FP_Ptr); 

           /* $B$3$3$KMh$kA0$K(B CGP$B$,4{$K6u$K$J$C$F$$$k$3$H$,$"$k$?$a!"(B
              ($BNc$($P!"(Bproceed$B$d(Bexecute$B7O$N%^%/%m$G$O!"@h$K(B f_MakeEmptyCGP$B$r(B
               $B$d$C$F$+$i(B f_SlitCheck_Sub$B$r8F$s$G$*$j!"$3$N%^%/%m$O$=$NCf$G(B
               $B8F$P$l$F$$$k(B)
               CGP$B$NFbMF$$$+$s$K$h$i$:%-%c%C%7%e;q8;$r%G%-%c%C%7%e$9$k$?$a$K!"(B
               f_DecacheFPResourceCount$B$r(B f_IfNotEmptyCGP$B$NH=DjItJ,$+$i=P$7$?!#(B
               91.1.23 $B@n9g(B */

	    f_IfNotEmptyCGP(D_ArgReg0)
	      { 
		f_HookFPStoppedGoalWithoutLock(D_Current_FP_Ptr, D_ArgReg0);
		f_MakeEmptyCGP(D_ArgReg0);
	      }
	  }
	s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	f_StopAllChildShoen(fp_record);
      }else{
	/* start -> start */
	s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	@DEBUG{
	  WARNING("f_FPReceiveStop", "still start -> start ...");
	};
      }
      $RELEASE(D_WorkFPSSC);
      break;
      
    case _FP_STOPPED :
      /* stop -> stop */
      s_DecrementFPStartStopCount(fp_record,D_VOID);
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      @DEBUG{
	WARNING("f_FPReceiveStop", "oh! stop -> stop !!");
      };
	break;
      
    case _FP_ABORTED :
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      @DEBUG{
	WARNING("f_FPReceiveStop", "stop message to Aborted FP");
      };
      break;
    default :
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      @DEBUG{
	VPIM_ERROR("f_FPReceiveStop", "Receive _STOPPED to Illegal state FP");
      };
      break;
    }
  s_UnlockFPChildShoenLink(fp_record, D_WorkFPChildShoenLinkOrgLockTagReg);

  $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);
  $RELEASE(D_Work_FP_Status_Reg);
}

/******************************************************************** PSL **

  f_FPReceiveAbort(fp_record)

       written by kawai@icot21      on Thu Jun  1 16:36:15 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Status_Reg : $BN$?F$NO@M}%9%F!<%?%9$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  function
<PreCondition>
<Function>
  $B%M%C%H%o!<%/7PM3$GN$?F08$F$KAw$i$l$F$-$?(Babort$B%a%C%;!<%8$r=hM}$9$k!#(B
  $B%a%C%;!<%8$NAw?.85$N%/%i%9%?$,N$?F$N$"$k%/%i%9%?$HF10l$+H]$+$O6hJL$7$J$$!#(B
  $B$3$N%^%/%m$O%M%C%H%o!<%/%a%C%;!<%8<u?.%O%s%I%i$+$i8F$S=P$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_FPReceiveAbort(fp_record)
{
  @DEBUG{
    _PrintFPInfo(fp_record);
    WARNING("f_FPReceiveAbort","FP Received Abort message");
  };

  $USE(D_Work_FP_Status_Reg);
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

  s_GetFPTransitStatus(fp_record, D_Work_FP_Status_Reg);
  ValueSwitch(D_Work_FP_Status_Reg){
  case _FP_STARTED :
  case _FP_STOPPED :

    /*
        $BN$?F$NO@M}%9%F!<%?%9$,(B _STOPPED$B$N;~$O!"CfCGCf$N%4!<%k$,N$?F%l%3!<%I$K$D(B
        $B$J$,$l$F$$$k2DG=@-$,$"$k$N$G!"$3$N%4!<%k$r2rJ|$9$k!#(B
	  $B!J%4!<%k$X$N%]%$%s%?$r(BNULL$B$K$9$l$PNI$$!K(B
    */
    f_FreeFPStoppedGoals(fp_record);

    /*
        $B$^$?!"N$?F$,(BWTC$BITB-$N;~$O!"Aw?.$G$-$J$$%a%C%;!<%8$,N$?F%l%3!<%I$K$D$J$,(B
	$B$l$F$$$k2DG=@-$,$"$k$,!"$3$N$H$-$O!"(BsupplyWTC$B%a%C%;!<%8$,Mh$k$O$:(B
        $B$J$N$G$=$N$^$^$*$$$F$*$/!#(B
    */

    /*  $B%"%\!<%H=hM}(B  */
    s_PutFPTransitStatusImm(fp_record, _FP_ABORTED);
    s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);  /* $B3F(BPE$B$,N$?F%l%3!<%I$r%m%C%/$7$F(B */
                                      /* $B%-%c%C%7%e;q8;$NJV4T$,$G$-$k$h$&$K(B */
                                      /* $BN$?F$r%"%s%m%C%/$9$k!#(B    */

    b_IfEqual(fp_record, D_Current_FP_Ptr)
      { /* $BD>A0$K<B9T$7$?%4!<%k$NN$?F$,;_$a$i$l$?$i!"(BCGP$B$r6u$K$9$k$3$H$K$h$C$F(B
           $B<!%4!<%k$N%9%1%8%e!<%k;~$KN$?F$N>uBV$r%A%'%C%/$9$k$h$&$K$9$k!#(B
           $B$J$*!"$3$N$?$a$K$OF1;~$K(B D_ResourceCache$B$K$"$k;q8;$r%G%-%c%C%7%e(B
           $B$7$F$*$/I,MW$,$"$k$,!"$3$l$O(B
             f_SyncroDecacheResourceForAbort_Sub
           $B$NCf$G9T$o$l$k!#(B
        */
	f_IfNotEmptyCGP(D_ArgReg0) {
	  f_PushGoalToStack(D_ArgReg0);
	  f_MakeEmptyCGP(D_ArgReg0);
	}
      }

    $CALL(f_SyncroDecacheResourceForAbort_Sub(fp_record));
    break;
  case _FP_ABORTED :
    s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
    @DEBUG{
      WARNING("f_FPReceiveAbort", "abort message to Aborted FP");
    };
    break;
  default :
    @DEBUG{
      VPIM_ERROR("f_FPReceiveAbort", "Receive _ABORTED to Illegal state FP");
    };
    s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
    break;
  }
  $RELEASE(D_Work_FP_Status_Reg);
}

/******************************************************************** PSL **

  f_FPReceiveSupplyResource(fp_record, resource_reg)

       written by kawai@icot21      on Thu Jun  1 16:38:20 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
  resource_reg : $B6!5k$5$l$?;q8;$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  function
<PreCondition>
<Function>
  $BN$?F$K6!5k$5$l$?;q8;$rN$?F<+?H5Z$S;RAq1`$H$N4V$GJ,G[$9$k!#(B
  $B$3$N%^%/%m$O!"N$?F$N$"$k%/%i%9%?$K(B SupplyResource$B%a%C%;!<%8$,E~Ce$7$?;~$K!"(B
$B%M%C%H%o!<%/%O%s%I%i$+$i8F$S=P$5$l$k!#(B
  $B$J$*!"$3$N%^%/%m$NCf$GN$?F%l%3!<%I$O%m%C%/(B/$B%"%s%m%C%/$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkSuspendedMsgPtr XXX

#PSL_define  f_FPReceiveSupplyResource(fp_record, resource_reg)
{ /* recource_reg $B$K$O(B _RSC_SUPPLY_UNIT $B$,F~$C$F$$$k$O$:(B */

  @DEBUG{
    _PrintFPInfo(fp_record);
    WARNING("f_FPReceiveSupplyResource","FP Receive Supply Resource message");
  };

  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

  s_IfAbortedFP(fp_record){

    s_EnsureFPExistance(fp_record, D_ONE);
    s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
    $CALL(f_Send_IntClMsg_Return_Resource_Sub(fp_record, D_NULL,
							  resource_reg));
  }else{
    b_IfGreater(resource_reg, D_NULL){

      /* $B6!5k$5$l$?;q8;$,(B $B@5(B $B$J$i$P(B */
      
      s_ResetFPStatusFlag(fp_record, _FP_RSC_REQ_FLAG);

      $USE(D_WorkFPSurplusU);
      $USE(D_WorkFPSurplusL);
      $CALL( f_SupplyFPResource_Sub(fp_record,
      				    resource_reg,
				    D_WorkFPSurplusU,
				    D_WorkFPSurplusL) );

      $USE(D_Work_FP_Stopped_Goals);
      s_IfRunnableFP(fp_record){  /* $BN$?F$,<B9T2DG=>uBV$G$"$l$P(B */
	s_GetFPStoppedGoals(fp_record, D_Work_FP_Stopped_Goals);
	s_PutFPStoppedGoals(fp_record, D_EOL);
      }else{
	b_SetEOL(D_Work_FP_Stopped_Goals);
      }
      /* $B%j%8%e!<%`=hM}$ON$?F%l%3!<%I$r(B Unlock $B$7$F$+$i(B */

      b_IfNotZeroDoubleWord(D_WorkFPSurplusU,D_WorkFPSurplusL) {
	s_EnsureFPExistance(fp_record, D_ONE);
	s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
	$CALL(f_Send_IntClMsg_Return_Resource_Sub(fp_record,
					      D_WorkFPSurplusU,
					      D_WorkFPSurplusL));
      }else{
	s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
      }
      $RELEASE(D_WorkFPSurplusU);
      $RELEASE(D_WorkFPSurplusL);

      b_IfNotEOL(D_Work_FP_Stopped_Goals){
	/* $B;q8;ITB-$G%9%H%C%W$7$?%4!<%k$,7R$,$C$F$$$l$P%j%8%e!<%`$9$k(B */
	$CALL( f_ResumeAllStoppedGoals_Sub(D_Work_FP_Stopped_Goals) );
      }
      $RELEASE(D_Work_FP_Stopped_Goals);


      b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
	$CALL(f_Send_IntClMsg_Request_Resource_Sub(fp_record));
	p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
      }
      $CALL( f_DistributeFPResource_Sub(fp_record) );
      
    }else{ /* $B6!5k$5$l$?;q8;$,(B $B@5(B $B$G$J$1$l$P(B */
      
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      
      @DEBUG
	{ WARNING("f_FPReceiveSupplyResource","FP Supplied Resource =< 0");};
    }
  }
}

/******************************************************************** PSL **

  f_FPReceiveSupplyWTC(fp_record, wtc_reg)

       written by kawai@icot21      on Fri Dec  1 17:44:57 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%H$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  wtc_reg : $BJd5k$5$l$?(BWTC$B$NCM$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  functions
<PreCondition>
<Function>
  $BAq1`$+$i(BWTC$B$,6!5k$5$l$?;~$N=hM}$r9T$J$&!#(B
    $B!&N$?F$NEPO?$5$l$F$$$k9uM"F~I=%(%s%H%j$X$N(BWTC$B$N2C;;$O:Q$s$G$$$k!#(B
    $B!&(BWTC$BITB-$GAw=P$G$-$:$K;_$^$C$F$$$k%a%C%;!<%8$N:FAw=P!#(B
  $B$3$N%^%/%m$ON$?F$N$$$k%/%i%9%?$K(B Supply_WTC$B%a%C%;!<%8$,E~Ce$7$?;~$K!"(B
$B%M%C%H%o!<%/%O%s%I%i$+$i8F$S=P$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_FPReceiveSupplyWTC(fp_record)
{
  @DEBUG{
    _PrintFPInfo(fp_record);
    WARNING("f_FPReceiveSupplyWTC","FP Receive Supply WTC message");
  };

  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  s_ResetFPStatusFlag(fp_record, _FP_WTC_REQ_FLAG);
  
  $USE(D_WorkSuspendedMsgPtr);
  
  s_GetFPSuspendedMessage(fp_record, D_WorkSuspendedMsgPtr);
  s_PutFPSuspendedMessage(fp_record, D_EOL);

  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);

  f_FPResumeSuspendedMessages(fp_record, D_WorkSuspendedMsgPtr);
      /* $B%5%9%Z%s%I$7$F$$$k%a%C%;!<%8$r%j%8%e!<%`$9$k!#(B      90.3.22 $BCg@%(B 
	 $BCf$G!"N$?F%l%3!<%I$r%m%C%/$9$k%k!<%A%s$r8F$V$N$G!"N$?F%l%3!<%I(B
	 $B%"%s%m%C%/8e$K9T$J$&$N$,K>$^$7$$!#(B  */
  $RELEASE(D_WorkSuspendedMsgPtr);

}
  /*  [$B8!F$;v9`(B]
       $B!&N$?F$N>uBV$r8+$J$/$FNI$$$+(B?
           stopped$B$N;~(B : $B%a%C%;!<%8:FAw?.=hM}$r(BD$B%3!<%I$G<B8=$9$k$H$9$k$H!"(B
                         $B;_$^$C$F$$$kH&$NN$?F$G%j%@%/%7%g%s$,A}2C$7$F$7$^$&$N$,(B
                         $B$$$d$i$7$$!#(B
                           $B$7$+$7!"(Bstart$B$5$l$?;~$K(BWTC$BITB-$G;_$^$C$F$$$k%a%C%;!<(B
                         $B%8$r:FAw?.$9$k$N$bJQ$@$7!"(Bstart$B$9$k;~$K(BWTC$B$J$I5$$K$7$?(B
                         $B$/$J$$!#(B
                           D$B%3!<%I$K$7$J$$$N$J$i$P!"Aw?.$O(BWTC$B$5$($"$l$P(Bstart$B>u(B
                         $BBV$N;~$K9T$J$o$l$kH&$@$C$?$N$G!":FAw?.$7$F$7$^$C$F$bNI(B
                         $B$5$=$&!#(B

           aborted$B$N;~(B : $BN$?F$O(Babort$B$5$l$F$b!"%5%9%Z%s%ICf$N%a%C%;!<%8$,(B
                         $BM-$k$H%A%c%$%k%I%+%&%s%H$r>e$2$F(BsupplyWTC$B$rBT$D!#(B
                         $B0x$C$F!"(Baborted$B$G$b%j%8%e!<%`$9$k!#(B
                          retrurn_resource,answer_statistics$B$J$I!"(B
                         $BJV$5$J$$$HAq1`$,@5$7$$H=CG$r2<$;$J$/$J$k$+$i!#(B
  */

/******************************************************************** PSL **

  f_FPReceiveAskStatistics(fp_record)

       written by kawai@icot21      on Thu Jun  1 16:39:06 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Child_Link_Reg : $BN$?F$N;RAq1`%j%s%/$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkFPResourceConsumed : $BN$?F$N>CHq;q8;NL$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkClusterNum : $B?FAq1`$N$"$k%/%i%9%?HV9f$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkExpRecAddr : $BN$?F$NEPO?$5$l$F$$$k9uM"F~I=%(%s%H%j$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenID : $B?FN$?F$NAq1`(BID$B$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
<Function>
  $BN$?F<+?H5Z$SN$?F$N;RAq1`$NE}7WNL$N=87W=hM}$r9T$J$&!#(B
  $B$3$N%^%/%m$ON$?F$N$$$k%/%i%9%?$K(B AskStatistics$B%a%C%;!<%8$,E~Ce$7$?;~$K!"(B
$B%M%C%H%o!<%/%O%s%I%i$+$i8F$S=P$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  90.3.12 $BN$?F$KBP$9$k%=%U%H%&%'%"%m%C%/(B/$B%"%s%m%C%/$r:o=|(B
********************************************************************* PSL **/

#PSL_define  f_FPReceiveAskStatistics(fp_record)
{
  @DEBUG{
    _PrintFPInfo(fp_record);
    WARNING("f_FPReceiveAskStatistics","FP Received Ask Stat message");
  };

  $CALL(f_SyncroDecacheResourceForAskStat_Sub(fp_record));
}

/******************************************************************** PSL **

f_FPReceiveAskProfile(fp_record)

       written by yamamoto@icot22      on Fri May 17 16:13:42 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_FPReceiveAskProfile(fp_rec){

  @DEBUG{
    _PrintFPInfo(fp_rec);
    WARNING("f_FPReceiveAskProfile","TOM");
  };

  $USE(D_Work_FP_Child_Link_Reg);
  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);
  s_LockFPChildShoenLink(fp_rec,D_WorkFPChildShoenLinkOrgLockTagReg);
  s_GetFPRightChildShoenLink(fp_rec, D_Work_FP_Child_Link_Reg);
  b_IfEqual(D_Work_FP_Child_Link_Reg, fp_rec){
    /*  $B;RAq1`$,$J$+$C$?$i(B  */
    $RELEASE(D_Work_FP_Child_Link_Reg);
    
    s_UnlockFPChildShoenLink(fp_rec, D_WorkFPChildShoenLinkOrgLockTagReg);
    $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);

    f_FPExportProfilingDataForAnswerWithNoChildShoen(fp_rec);

  }else{ /* $B;RAq1`$,$"$C$?$i(B */
    $RELEASE(D_Work_FP_Child_Link_Reg);
    
    f_AskProfileAllChildShoenWithUnlockChildShoenLink(fp_rec,
				   D_WorkFPChildShoenLinkOrgLockTagReg);
    /* $B$3$NCf$G;RAq1`%j%s%/$N%"%s%m%C%/$r9T$J$&(B */

    $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);
  }
}

/******************************************************************** PSL **

  f_FPRequestResourceWithoutLock_Sub(A_PtrToFPRecord)

       written by kawai@icot21      on Wed Aug 30 11:36:39 1989
<Arguments>
  A_PtrToFPRecord
<Temporally Used Variables>
  D_WorkClusterNum : $B?FAq1`$N$"$k%/%i%9%?HV9f$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkExpRecAddr : $BN$?F$NEPO?$5$l$F$$$k9uM"F~I=%(%s%H%j$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenID : $B?FN$?F$NAq1`(BID$B$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
<Function>
  $BN$?F$+$i?FAq1`$K;q8;MW5a$r=P$9!#(B($BN$?F%l%3!<%I$N%m%C%/(B/$B%"%s%m%C%/$O(B
				   $B8F=PB&$G9T$J$&$3$H!K(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_PtrToFPRecord	SRC /* $BMW3NG'(B */

#DATA_define  D_NeedRequestResourceMsgFlag   XXX

#SUBROUTINE     f_FPRequestResourceWithoutLock_Sub(A_PtrToFPRecord)
{
  /* RequestUnanswered($B4{$K;q8;MW5a$r=P$7$F$"$k(B)$B$J$i$P$J$K$b$7$J$$!#(B*/

  s_IfNotFPResourceRequest(A_PtrToFPRecord)
    {
      s_SetFPStatusFlag(A_PtrToFPRecord,_FP_RSC_REQ_FLAG);
      /*  $B?FAq1`$N$$$k%/%i%9%?$K;q8;MW5a%a%C%;!<%8$rAw$k!#(B */
      s_EnsureFPExistance(A_PtrToFPRecord,D_ONE );
/*
      $CALL(f_Send_IntClMsg_Request_Resource_Sub(A_PtrToFPRecord));
      $BN$?F%m%C%/Cf$K%a%C%;!<%8$O=P$;$J$$!JM"F~I=%m%C%/$G%G%C%I%m%C%/!K(B
      D_NeedRequestResourceMsgFlag$B$NCM$G8e$+$iD4$Y$k$3$H(B
*/
      p_MoveWord(D_ONE,D_NeedRequestResourceMsgFlag);
    }else{
      p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
    }
  $RETURN();
}

/******************************************************************** PSL **

  f_FPResourceSupplied(fp_record, resource_reg)

       written by kawai@icot21      on Wed Aug 30 11:37:47 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  resource_reg : $B6!5k$5$l$?;q8;NL$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  functions
<PreCondition>
  $BN$?F$K%m%C%/$,3]$+$C$F$$$J$$>uBV$G8F$P$l$k!#(B
<Function>
  $BN$?F$K(B resource_reg$BJ,$@$1;q8;$r6!5k$9$k!#(B
  $B$3$N%^%/%m$O!"N$?F$N$$$k%/%i%9%?$K(B SupplyResource$B%a%C%;!<%8$,E~Ce$7$?;~$K!"(B
$B%M%C%H%o!<%/%O%s%I%i$+$i8F$S=P$5$l$k!#(B($BN$?F%l%3!<%I$N%m%C%/(B/$B%"%s%m%C%/IU$-(B)

$B%4!<%k$r%l%7!<%V$7$?;~$K!"$D$$$F$-$?%j%=!<%9$rB-$79~$`$N$K$7$+;H$o$l$F$$$J$$!#(B
$B:GBgCM$O(B _RSC_THROW_GOAL_UNIT  ( << _RSC_SUPPLY_UNIT ) $B$J$N$G!"(B
$B;RAq1`$X$N%G%#%9%H%j%S%e!<%H$N@Z$C3]$1$K$O$7$J$$!#(B (REKI 91.09.17)

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkFPSurplusU XXX
#DATA_define D_WorkFPSurplusL XXX

#PSL_define  f_FPResourceSupplied(fp_record, resource_reg)
{
  /*-----------------------------------------------------------
  @DEBUG{
    WARNING("f_FPResourceSupplied","FP Supplied Resource");
  };
  -----------------------------------------------------------*/

  b_IfGreater(resource_reg, D_NULL)
    { /* $B6!5k$5$l$?;q8;$,(B $B@5(B $B$J$i$P(B */
      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      $USE(D_WorkFPSurplusU);
      $USE(D_WorkFPSurplusL);
      $CALL( f_SupplyFPResource_Sub(fp_record, 
				    resource_reg,
				    D_WorkFPSurplusU,
				    D_WorkFPSurplusL) );

      $USE(D_Work_FP_Stopped_Goals);
      s_IfRunnableFP(fp_record)	{  /* $BN$?F$,<B9T2DG=>uBV$G$"$l$P(B */
	s_GetFPStoppedGoals(fp_record, D_Work_FP_Stopped_Goals);
	s_PutFPStoppedGoals(fp_record, D_EOL);
      }else{
	b_SetEOL(D_Work_FP_Stopped_Goals);
      }

      b_IfNotZeroDoubleWord(D_WorkFPSurplusU,D_WorkFPSurplusL) {
	s_EnsureFPExistance(fp_record, D_ONE);
	s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
	$CALL(f_Send_IntClMsg_Return_Resource_Sub(fp_record,
					      D_WorkFPSurplusU,
					      D_WorkFPSurplusL));
      }else{
	s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
      }
      $RELEASE(D_WorkFPSurplusU);
      $RELEASE(D_WorkFPSurplusL);

      b_IfNotEOL(D_Work_FP_Stopped_Goals){
	/* $B;q8;ITB-$G%9%H%C%W$7$?%4!<%k$,7R$,$C$F$$$l$P%j%8%e!<%`$9$k(B */
	$CALL( f_ResumeAllStoppedGoals_Sub(D_Work_FP_Stopped_Goals) );
      } 
      $RELEASE(D_Work_FP_Stopped_Goals);    

      b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
	$CALL(f_Send_IntClMsg_Request_Resource_Sub(fp_record));
	p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
      }
/*
      $CALL( f_DistributeFPResource_Sub(fp_record) );
*/
    }
  else
    { /* $B6!5k$5$l$?;q8;$,(B $B@5(B $B$G$J$1$l$P(B */
      @DEBUG
	{ WARNING("f_FPResourceSupplied","Supplied Resource =< 0"); };
    }
}

/******************************************************************** PSL **

  f_SupplyFPResource_Sub(A_PtrToFPRecord, A_RscReg)

       written by kawai@icot21      on Wed Aug 30 11:40:10 1989
<Arguments>
  A_PtrToFPRecord : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  A_RscReg : $B6!5k$5$l$?;q8;NL$rJ];}$9$k%l%8%9%?(B

$B0J2<$N#2<o$N%a%C%;!<%8$N<u?.=hM}$+$i$N$_8F$P$l$k!#(B
$B6!5k;q8;$O$I$A$i$b#1%o!<%I$K<}$^$k!#(B
  SupplyResource $B%a%C%;!<%8$N<u?.(B
  ThrowGoal $B%a%C%;!<%8$N<u?.(B

<Temporally Used Variables>
  D_Work_Supply_Resource_Unit_Reg : _SUPPLY_RESOURCE_UNIT$B$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $B8F$S=P$785$GN$?F%l%3!<%I$K%m%C%/$7$F$$$k$3$H!#(B
<Function>
  $BN$?F$K;q8;$r6!5k$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $B6!5k$5$l$?%j%=!<%9$,%<%m$G$J$$;~$N$_8F$S=P$9$h$&$KJQ99(B (1990.02.03. Goto)
  $B6!5k$5$l$?%j%=!<%9$,%<%m$G$"$C$F$b8F$S$@$7$F2D(B($BAq1`=*7k;~$KAq1`$N;q8;;DNL$,(B
  0 $B$@$C$?;~$J$I(B)$B!#C"$7!"$=$N>l9g$G$b$3$N%k!<%A%s$N8F$S$@$785(B(f_FPResourceSuppl
  ied)$B$GH=Dj$7!"<B:]$K$O$3$N%k!<%A%s$O8F$P$l$J$$!#(B(1990.03.16)
********************************************************************* PSL **/

#DATA_define	D_Work_Supply_Resource_Unit_Reg		XXX

#SUBARG_define	A_PtrToFPRecord	SRC	/* $BMW3NG'(B */
#SUBARG_define	A_RscReg	SRC	/* $BMW3NG'(B */
#SUBARG_define  A_RscSurplusU   DST
#SUBARG_define  A_RscSurplusL   DST

#SUBROUTINE  f_SupplyFPResource_Sub(A_PtrToFPRecord, 
				    A_RscReg,
				    A_RscSurplusU,
				    A_RscSurplusL)
{
  
  $USE(D_WorkFPCurrentRscU);
  $USE(D_WorkFPCurrentRscL);

  s_GetFPLastResourceLeft(A_PtrToFPRecord,
			  D_WorkFPCurrentRscU,
			  D_WorkFPCurrentRscL);

  $USE(D_WorkFPAddendRscU);
  $USE(D_WorkFPAddendRscL);
  $USE(D_WorkFPSurplusRscU);
  $USE(D_WorkFPSurplusRscL);

  b_CheckResourceSurplus(D_WorkFPCurrentRscU,
			   D_WorkFPCurrentRscL,
			   D_NULL,
			   A_RscReg,
			   D_WorkFPAddendRscU,
			   D_WorkFPAddendRscL,
			   D_WorkFPSurplusRscU,
			   D_WorkFPSurplusRscL);

  $RELEASE(D_WorkFPCurrentRscU);
  $RELEASE(D_WorkFPCurrentRscL);

  b_IfNotZeroDoubleWord(D_WorkFPAddendRscU,D_WorkFPAddendRscL){
    f_UpdateFPResourceLeft(A_PtrToFPRecord,
			   D_WorkFPAddendRscU,
			   D_WorkFPAddendRscL);
    f_UpdateFPLastResourceLeft(A_PtrToFPRecord,
			       D_WorkFPAddendRscU,
			       D_WorkFPAddendRscL);
  }
  $RELEASE(D_WorkFPAddendRscU);
  $RELEASE(D_WorkFPAddendRscL);

  p_MoveWord(D_WorkFPSurplusRscU,A_RscSurplusU);
  p_MoveWord(D_WorkFPSurplusRscL,A_RscSurplusL);
  $RELEASE(D_WorkFPSurplusRscU);
  $RELEASE(D_WorkFPSurplusRscL);

  s_ResetFPStatusFlag(A_PtrToFPRecord,_FP_RSC_EXHAUSTED_FLAG);

  $USE(D_Work_Supply_Resource_Unit_Reg);
  p_SetImmediateValue(_RSC_ENOUGH_TO_CACHE_UNIT, 
		      D_Work_Supply_Resource_Unit_Reg);
  s_IfNotEnoughFPResourceLeft(A_PtrToFPRecord,D_Work_Supply_Resource_Unit_Reg)
    { /* $BN$?F$K(B _RSC_ENOUGH_TO_CACHE_UNIT $BJ,$N;q8;$,;D$C$F$$$J$1$l$P(B */
      $CALL( f_FPRequestResourceWithoutLock_Sub(A_PtrToFPRecord) );
    }
  $RELEASE(D_Work_Supply_Resource_Unit_Reg);
  $RETURN();
}

/******************************************************************** PSL **

  f_FPAnswerStatistics(fp_record)

       written by kawai@icot21      on Thu Nov 16 21:55:34 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkFPTotalResourceConsumed : $BN$?F<+?H5Z$S;RAq1`$N>CHq;q8;NL$NAm7W$rJ];}$9(B
                                  $B$k%l%8%9%?(B
  D_Work_Brother_Shoen : $BN$?F$N;RAq1`$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenResourceConsumed : $B;RAq1`$N>CHq;q8;NL$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkCLNum : $B?FAq1`$N$"$k%/%i%9%?HV9f$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkExpRecAddr : $BN$?F$NEPO?$5$l$F$$$k9uM"F~I=%(%s%H%j$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenID : $B?FN$?F$NAq1`(BID$B$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $BN$?F%l%3!<%I$O%m%C%/$5$l$F$$$k$3$H!#(B
<Function>
  $BN$?F<+?H5Z$S$=$N;RAq1`$N>CHq;q8;NL$N9g7W$r?FAq1`$KCN$i$;$k!#(B
  $B$3$N%^%/%m$O!"(BAskStatistics$B%a%C%;!<%8$K$h$C$F3+;O$5$l$?>CHq;q8;NL$N=87W$,=*N;(B
  $B$7$?;~E@$G8F$S=P$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_FPAnswerStatistics(fp_record)
{
  @DEBUG{
    WARNING("f_FPAnswerStatistics","FP Ans Stat to Shoen");
  };

  $CALL(f_SyncroDecacheResourceForAnswerStat_Sub(fp_record));
}

/******************************************************************** PSL **

  f_DistributeFPResource(fp_record)

       written by kawai@icot21      on Wed Aug 30 12:26:46 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Resource_Reg : 
  D_Work_FP_Child_Link_Reg : 
<Level>
  functions
<PreCondition>
  $B8F$S=P$785$G!"(B
    $B!&N$?F%l%3!<%IK\BN(B
    $B!&N$?F$N;RAq1`%j%s%/(B
  $B$H$b%m%C%/$,3]$+$C$F$$$J$$$3$H(B
<Function>
  $BN$?F$K;q8;$,Jd5k$5$l$?;~(B(SupplyResource$B%a%C%;!<%8E~Ce;~$d;RAq1`$N=*N;;~(B)$B$K(B
$B;RAq1`$K;q8;$rJ,G[$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $B;RAq1`$NCf$K;q8;MW5a$r=P$7$F$$$k$b$N$,$"$k;~$N$_8F$S=P$9$h$&$KJQ99(B
  (1990.02.03. By Goto)
  $B$3$N%k!<%A%s$O?FN$?F$K;q8;$,M?$($i$l$?;~$K$$$D$b8F$S=P$5$l$k$?$a!"FC$K;RAq1`(B
$BCf$K;q8;MW5a$r=P$7$F$$$kAq1`$,$J$/$F$bNI$$!#(B($B$=$N>l9g$O(B NOP $B$H$J$k(B)
  (1990.03.16  by $B@n9g(B)
********************************************************************* PSL **/

#DATA_define  D_Work_FP_Child_Link_Reg   XXX

#SUBARG_define	A_PtrToFPRecord	SRC	/* $BMW3NG'(B */

#SUBROUTINE  f_DistributeFPResource_Sub(A_PtrToFPRecord)
{

  $USE(D_Work_FP_Child_Link_Reg);

  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
  s_IfFPChiledResourceRequest(A_PtrToFPRecord)
    { /* $B;RAq1`Cf$K;q8;MW5a$r=P$7$F$$$k$b$N$,$"$l$P(B */
      @DEBUG{
	WARNING("f_DistributeFPResource_Sub","FP Resource will be distributed");
      };
      $USE(D_WorkFPResourceReg);
      p_SetImmediateValue(_RSC_SUPPLY_UNIT, D_WorkFPResourceReg);
      s_IfEnoughFPResourceLeft(A_PtrToFPRecord, D_WorkFPResourceReg)
	{ /* $BN$?F$K=<J,;q8;$,$"$l$P(B */
	  s_ResetFPStatusFlag(A_PtrToFPRecord, _FP_CHILD_RSC_REQ_FLAG);
	  /* !! Bug fixed: _FP_RSC_REQ_FLAG -> _FP_CHILD_RSC_REQ_FLAG */

	  s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);

	  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);
	  s_LockFPChildShoenLink(A_PtrToFPRecord,
					D_WorkFPChildShoenLinkOrgLockTagReg);
	  s_GetFPRightChildShoenLink(A_PtrToFPRecord,
				                  D_Work_FP_Child_Link_Reg);
	  LOOP()
	    { /* $B;RAq1`%j%s%/$r0l<~$9$k$^$G%k!<%W$9$k(B */
	      b_IfEqual(D_Work_FP_Child_Link_Reg, A_PtrToFPRecord) {break;}
	      s_IfSHREC(D_Work_FP_Child_Link_Reg)
		{ /* $B%j%s%/$K$D$J$,$C$F$$$k$N$,Aq1`%l%3!<%I$J$i$P(B */
		  s_IfNotShoenUnhookReserved(D_Work_FP_Child_Link_Reg)
		    { /* $BAq1`$,2rJ|M=Dj$G$J$1$l$P(B */
		      f_DistributeShoenResource(D_Work_FP_Child_Link_Reg);
		      s_IfNotEnoughFPResourceLeft(A_PtrToFPRecord,
					              D_WorkFPResourceReg)
			{ /* $B$b$&N$?F$K=<J,;q8;$,$J$1$l$P(B */
			  s_SetFPStatusFlag(A_PtrToFPRecord,
					          _FP_CHILD_RSC_REQ_FLAG);
			  /* Bug Fixed !! */
			  break;
			  /*  [$BCm0U(B]
                           $BN$?F$K=<J,$J;q8;$,$J$/$J$C$?;~$O!"$=$l$+$i@h$N%j%s%/(B
			   $B$K$D$J$,$C$F$$$kAq1`$KBP$7$F$O(B f_DistributeShoenReso
                           urce $B$r<B9T$;$:!"<!2sN$?F$K;q8;$,6!5k$5$l$?;~$K9T$o(B
                           $B$l$k!#(B
			  */
			}
		    }
		  s_GetRightBrotherShoenLink(D_Work_FP_Child_Link_Reg,
						 D_Work_FP_Child_Link_Reg);
		}
	      else
		{ /* $BAq1`%l%3!<%I$G$bN$?F%l%3!<%I(B($B<+J,<+?H(B)$B$G$b$J$+$C$?$i(B */
		  @DEBUG{
		    VPIM_ERROR("f_DistributeFPResource_Sub",
			       "Illegal ChildShoenLink");
		  };
		  break;
		}
	    }
	  s_UnlockFPChildShoenLink(A_PtrToFPRecord,
					D_WorkFPChildShoenLinkOrgLockTagReg);
	  $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);
	  $USE(D_WorkFPOrgLockTagReg);
	  s_LockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	  s_IfNotEnoughFPResourceLeft(A_PtrToFPRecord, D_WorkFPResourceReg)
	    { /* $BN$?F$N;q8;$,;D$j>/$J$/$J$C$F$$$?$i(B */
	      $CALL( f_FPRequestResourceWithoutLock_Sub(A_PtrToFPRecord) );
	      s_IfExhaustedFPResource(A_PtrToFPRecord)
		{ /* $BN$?F$N;q8;$,$J$/$J$C$F$$$?$i(B */
		  s_SetFPStatusFlag(A_PtrToFPRecord,_FP_RSC_EXHAUSTED_FLAG);
		}
	    }
	  s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	  b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
	    $CALL(f_Send_IntClMsg_Request_Resource_Sub(A_PtrToFPRecord));
	    p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
	  }
	}
      else
	{ /* $BN$?F$K=<J,$J;q8;$,$J$1$l$P(B */
	  $CALL( f_FPRequestResourceWithoutLock_Sub(A_PtrToFPRecord) );
	  s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	  b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
	    $CALL(f_Send_IntClMsg_Request_Resource_Sub(A_PtrToFPRecord));
	    p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
	  }
	}
      $RELEASE(D_WorkFPResourceReg);
    }
   else
     { /* $B;RAq1`Cf$K;q8;MW5a$7$F$$$k$b$N$,$J$1$l$P(B */
       s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
       $RELEASE(D_WorkFPOrgLockTagReg);
     }
  $RELEASE(D_Work_FP_Child_Link_Reg);

  $RETURN();
}

/******************************************************************** PSL **

  f_FreeFPStoppedGoals(fp_record)

       written by kawai@icot21      on Fri May 26 23:07:05 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  functions
<PreCondition>
  $BN$?F%l%3!<%I$O8F$S=P$7B&$G%m%C%/$9$k!#(B
<Function>
  $BN$?FDd;_;~$KN$?F$,%"%\!<%H$5$l$?>l9g$J$I$K!"N$?F%l%3!<%I$K7R$,$l$F$$$kCfCGCf(B
$B$N%4!<%k$r2rJ|$9$k!#(B
  reclaim$B$O$7$J$$!"$?$@N$?F$+$i$N%j%s%/$r@Z$k$@$1!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_FreeFPStoppedGoals(fp_record)
{
s_PutFPStoppedGoals(fp_record,D_EOL);
}


/******************************************************************** PSL **

  f_FreeFPSuspendedMessages(fp_record)

     $BGQ;_(B(91-01-31 Yamamoto)

  $B%"%\!<%H;~$K%U%j!<$7$F$O$$$1$J$$!#(BsupplyWTC$B$rBT$D$3$H!#(B

********************************************************************* PSL **/

/* $B!v!v!vGQ;_!v!v!v(B
#DATA_define D_WorkFPSuspendedMsgID XXX

#PSL_define  f_FreeFPSuspendedMessages(fp_record)
{
  $USE(D_WorkFPSuspendedMessage);
  s_GetFPSuspendedMessage(fp_record,D_WorkFPSuspendedMessage);
  s_PutFPSuspendedMessage(fp_record,D_EOL);
  LOOP(){
    b_IfEOL(D_WorkFPSuspendedMessage){break;}
    $USE(D_WorkFPSuspendedMsgID);
    s_GetMsgIdMsgSusRec(D_WorkFPSuspendedMessage,D_WorkFPSuspendedMsgID);
    ValueSwitch(D_WorkFPSuspendedMsgID){
    case _NW_ANSWER_STATISTICS:
      <* $BN$?F%l%3!<%I$N>CHq>pJs$rJV$9!#(B *>
      break;
    case _NW_RETURN_RESOURCE:
      <* $BN$?F%l%3!<%I$K%j%=!<%9$rJV$9!#(B *>       
      break;
    default:
      break;
    }
    $RELEASE(D_WorkFPSuspendedMsgID);
    s_GetChainMsgSusRec(D_WorkFPSuspendedMessage,D_WorkFPSuspendedMessage);
  }
  $RELEASE(D_WorkFPSuspendedMessage);
}
*/

/******************************************************************** PSL **
1.8 $B%5%9%Z%s%I$7$?%a%C%;!<%8$r%j%8%e!<%`$9$k(B

       written by nakase@icot22      on Thu Mar 22 15:27:29 1990
<Arguments>
 fp_ptr:    $BN$?F$X$N%]%$%s%?(B

 msg_ptr:  $BN$?F$+$i<h$j=P$7$?%5%9%Z%s%I%a%C%;!<%8%-%e!<(B
  $B!J8F$S=P$7B&$G<h$j=P$7$F$7$^$C$F$"$k$N$G!"N$?F$K$O$9$G$K$D$J$,$C$F$$$J$$!#!K(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>

  msg_ptr$B$N;X$7<($9%5%9%Z%s%I%a%C%;!<%8%-%e!<$+$i(B
$B%5%9%Z%s%I%a%C%;!<%8$r<h$j=P$7$F$O:FAw?.$r;n$_$k!#(B
$BC"$7(BUnify$B%a%C%;!<%8$O(BUnify$B%j%H%i%$$N(BD$B%3!<%I$r:n@.$9$k!#(B

  $B:FAw?.$K$*$$$F!":F$S(BWTC$B$,ITB-$7$?>l9g$N=hM}$O$=$l$>$l$NAw?.%^%/%m$NCf$G(B
$B9T$J$&$N$G!"K\%^%/%m$G$O$9$Y$F$N%5%9%Z%s%I%a%C%;!<%8$N:FAw?.$r;n$_$k!#(B

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/*
   $B$h$=$GDj5A$5$l$F$$$k%o!<%/%l%8%9%?$r$?$/$5$s;H$C$F$$$k$N$G5$;}$A0-$$$M(B
*/

#DATA_define D_WorkArg1 XXX
#DATA_define D_WorkArg2 XXX
#DATA_define D_WorkFPOrgReg XXX

#DATA_define D_WorkCLNum_Or_UnifyArg1 XXX
#DATA_define D_WorkCLNumOfSuspMsg     XXX

#DATA_define D_WorkRSMNewArgv            XXX  
#DATA_define D_WorkRSMNewCode            XXX
#DATA_define D_WorkRSMExceptionInfoVect  XXX
#DATA_define D_WorkRSMExceptionTag       XXX     /* !! $BDI2C(B */
#DATA_define D_WorkRSMExceptionNum       XXX
#DATA_define D_WorkRSMSuspMsgId          XXX
/* RSM for Resume Suspended Message */

#DATA_define D_WorkRAPType    XXX
#DATA_define D_WorkRAPCount   XXX
#DATA_define D_WorkRAPLevel   XXX
#DATA_define D_WorkRAPCluster XXX
#DATA_define D_WorkRAPData    XXX
/* RAP for Resume Answer Profile */

#PSL_define f_FPResumeSuspendedMessages(fp_ptr, msg_ptr)
{

  LOOP(){
    b_IfEOL(msg_ptr){break;}

    $USE(D_WorkRSMSuspMsgId);
    
    s_GetMsgIdMsgSusRec(msg_ptr, D_WorkRSMSuspMsgId);
    
    ValueSwitch(D_WorkRSMSuspMsgId){
      case _NW_THROW_GOAL:
      case _NW_THROW_UNBOUND:
        $USE(D_WorkGoalPtr);
	$USE(D_WorkCLNumOfSuspMsg);

        s_GetSuspendGoalOfMsgSusRec_Throw(msg_ptr, D_WorkGoalPtr);
	s_GetClNumOfMsgSusRec_Throw(msg_ptr, D_WorkCLNumOfSuspMsg);

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "ThrowGoalMsg will be resumed by receiving WTC");
	};

	s_IfNodeOutOfBounds(fp_ptr, D_WorkCLNumOfSuspMsg) {
	  @DEBUG{
	    WARNING("f_FPResumeSuspendedMessages","node is out of bounds");
	  };
	} else {
	  b_IfEqualImm(D_WorkRSMSuspMsgId, _NW_THROW_GOAL) {
	    $CALL( f_Send_IntClMsg_ThrowGoal_Sub
                           (D_WorkCLNumOfSuspMsg, D_WorkGoalPtr, fp_ptr) );
	  } else {
	    $CALL( f_Send_IntClMsg_ThrowUnbound_Sub
                           (D_WorkCLNumOfSuspMsg, D_WorkGoalPtr, fp_ptr) );
	  }
	}
	$RELEASE(D_WorkCLNumOfSuspMsg);
	$RELEASE(D_WorkGoalPtr);

	/* $B=>Mh!"$3$3$K$O(B fp_ptr $B$N(B childcount$B$r%G%/%j%a%s%H$9$k=hM}$,(B 
           $B$"$C$?$,!"%a%C%;!<%8%5%9%Z%s%I;~$K%$%s%/%j%a%s%H$9$k=hM}$r(B
           $B30$7$?$N$G!"F1;~$K:o=|$5$l$?!#$J$*!"N$?F$KAw?.J]N1%a%C%;!<%8(B
           $B$,$"$k4V$ON$?F$,=*7k$5$l$J$$$?$a!"(Bchildcount$BA`:n$OK\MhITMW$G(B
           $B$"$C$?!#(Bon '92.4.14 by kawai */

	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_Throw(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);
	break;

      case _NW_UNIFY:      

	$USE(D_WorkArg1);$USE(D_WorkArg2);
	$USE(D_WorkPriority);

	s_GetArg1OfMsgSusRec_Unify(msg_ptr, D_WorkArg1);
	s_GetArg2OfMsgSusRec_Unify(msg_ptr, D_WorkArg2);
	s_GetPrioOfMsgSusRec_Unify(msg_ptr, D_WorkPriority);

	$USE(D_WorkFPOrgReg);
	s_LockFPRecord(fp_ptr, D_WorkFPOrgReg);
	s_IncrementFPChildCount(fp_ptr);
	s_UnlockFPRecord(fp_ptr, D_WorkFPOrgReg);
	$RELEASE(D_WorkFPOrgReg);
	                           /* D-Code$B%4!<%kMQ$N(BChild-count$B$r(B
				      $B#1%$%s%/%j%a%s%H$9$k(B */
	

	$USE(D_WorkNewGR);
	$USE(D_WorkDcodeaddr);
	f_GetDcodeAddress(DCODE_UNIFY_RETRY,D_WorkDcodeaddr);
	s_AllocAndInitNoDebugShortGoalRecord(D_WorkNewGR,
					     _TWO,
					     D_WorkDcodeaddr,
					     D_WorkPriority,
					     _EMIGRANT_CLUSTER,
					     fp_ptr);
	$RELEASE(D_WorkDcodeaddr);

	f_Put2ArgsGoalRecord(D_WorkNewGR, D_WorkArg1, D_WorkArg2);

	$RELEASE(D_WorkArg2);	$RELEASE(D_WorkArg1);

	$CALL( f_PushGoalToStackWithPriority_Sub(D_WorkNewGR, D_WorkPriority));
        /* $B<B:]$N%f%K%U%#%1!<%7%g%s$O%f%K%U%!%$$N#D%3!<%I$,9T$&(B */

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "unification resumed receiving WTC");
	};

	$RELEASE(D_WorkNewGR);
	$RELEASE(D_WorkPriority);

	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_Unify(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);

	break;

      case _NW_READY:

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "ReadyMsg will be resumed by receiving WTC");
	};

	$CALL( f_Send_IntClMsg_Ready_Sub(fp_ptr) );

	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_Ready(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);

	break;

      case _NW_REQUEST_RESOURCE:

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "ReguestResourceMsg will be resumed by receiving WTC");
	};

	$CALL( f_Send_IntClMsg_Request_Resource_Sub(fp_ptr) );

	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_Req_Res(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);

	break;

      case _NW_ANSWER_STATISTICS:

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "AnswerStatMsg will be resumed by receiving WTC");
	};

	$USE(D_WorkArg1);
	$USE(D_WorkArg2);
	s_GetAnsData1OfMsgSusRec_Ans_Stat(msg_ptr,D_WorkArg1);
	s_GetAnsData2OfMsgSusRec_Ans_Stat(msg_ptr,D_WorkArg2);
	$CALL( f_Send_IntClMsg_Answer_Statistics_Sub(fp_ptr,
						     D_WorkArg1,
						     D_WorkArg2) );
	$RELEASE(D_WorkArg2);
	$RELEASE(D_WorkArg1);
	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_Ans_Stat(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);

	break;
      case _NW_RETURN_RESOURCE:

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "ReturnResourceMsg will be resumed by receiving WTC");
	};

	$USE(D_WorkArg1);
	$USE(D_WorkArg2);
	s_GetResourceUpperOfMsgSusRec_Rtn_Rsc(msg_ptr,D_WorkArg1);
	s_GetResourceLowerOfMsgSusRec_Rtn_Rsc(msg_ptr,D_WorkArg2);
	$CALL( f_Send_IntClMsg_Return_Resource_Sub(fp_ptr,
						     D_WorkArg1,
						     D_WorkArg2) );
	$RELEASE(D_WorkArg2);
	$RELEASE(D_WorkArg1);
	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_Rtn_Rsc(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);

	break;

      case _NW_SHOEN_PROFILE:

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "AnswerProfilMsg will be resumed by receiving WTC");
	};

	$USE(D_WorkRAPType);
	$USE(D_WorkRAPCount);
	$USE(D_WorkRAPLevel);
	$USE(D_WorkRAPCluster);
	$USE(D_WorkRAPData);
	s_Get_Type_MsgSusRec_AnsProf(msg_ptr,D_WorkRAPType);
	s_Get_Count_MsgSusRec_AnsProf(msg_ptr,D_WorkRAPCount);
	s_Get_Level_MsgSusRec_AnsProf(msg_ptr,D_WorkRAPLevel);
	s_Get_Cluster_MsgSusRec_AnsProf(msg_ptr,D_WorkRAPCluster);
	s_Get_Data_MsgSusRec_AnsProf(msg_ptr,D_WorkRAPData);

	$CALL( f_Send_IntClMsg_Shoen_Profile_Sub(fp_ptr,
						  D_WorkRAPType,
						  D_WorkRAPCount,
						  D_WorkRAPLevel,
						  D_WorkRAPCluster,
						  D_WorkRAPData));
	$RELEASE(D_WorkRAPType);
	$RELEASE(D_WorkRAPCount);
	$RELEASE(D_WorkRAPLevel);
	$RELEASE(D_WorkRAPCluster);
	$RELEASE(D_WorkRAPData);
	
	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_AnswerProfile(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);

	break;

      case _NW_EXCEPTION:

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  WARNING("f_FPResumeSuspendedMessages",
		  "ExceptionMsg will be resumed by receiving WTC");
	};

	$USE(D_WorkRSMExceptionTag);  /* !! $BDI2C(B */
	$USE(D_WorkRSMExceptionNum);
	$USE(D_WorkRSMExceptionInfoVect);
	$USE(D_WorkRSMNewCode);
	$USE(D_WorkRSMNewArgv);

	s_GetExceptionTagOfSusRec_Exception(msg_ptr, 
					    D_WorkRSMExceptionTag);
	s_GetExceptionNumOfSusRec_Exception(msg_ptr, 
					    D_WorkRSMExceptionNum);
	s_GetExceptionInfoOfSusRec_Exception(msg_ptr, 
					     D_WorkRSMExceptionInfoVect);
	s_GetNewCodeOfSusRec_Exception(msg_ptr, D_WorkRSMNewCode);
	s_GetNewArgvOfSusRec_Exception(msg_ptr, D_WorkRSMNewArgv);

	f_Send_IntClMsg_Exception_Body(D_WorkRSMExceptionTag, /* !! $BDI2C(B */
				       D_WorkRSMExceptionNum, 
					     D_WorkRSMExceptionInfoVect,
					     D_WorkRSMNewCode, 
					     D_WorkRSMNewArgv,
					     fp_ptr);
	$RELEASE(D_WorkRSMNewArgv);
	$RELEASE(D_WorkRSMNewCode);
	$RELEASE(D_WorkRSMExceptionInfoVect);
	$RELEASE(D_WorkRSMExceptionNum);
	$RELEASE(D_WorkRSMExceptionTag);  /* !! $BDI2C(B */

	$USE(D_WorkReclaimRec);
	p_MoveWord(msg_ptr, D_WorkReclaimRec);
	s_GetChainMsgSusRec(msg_ptr, msg_ptr);

	s_ReclaimEntryOfMsgSusRec_Exception(D_WorkReclaimRec);
	$RELEASE(D_WorkReclaimRec);

	break;

      default:

	@DEBUG{
	  _PrintFPInfo(fp_ptr);
	  VPIM_ERROR("f_FPResumeSuspendedMessages","illegal message type");
	};
	break;
      }
    $RELEASE(D_WorkRSMSuspMsgId);
  }

}
