
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_fp_profiling_shoen.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon May 13 11:38:56 1991
   ----- LAST SAVED: by yamamoto@icot22, on Thu May 21 22:01:27 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : $B%W%m%U%!%$%j%s%0Aq1`$N$?$a$N4pK\5!G=(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by yamamoto@icot22      on Mon May 13 11:39:10 1991

$B%W%m%U%!%$%j%s%0Aq1`$N$?$a$N4pK\5!G=(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

/******************************************************************** PSL **

f_FPIncrementDequeueCountProfilingEntry(arg1,arg2,arg3)
f_FPIncrementSuspendCountProfilingEntry(arg1,arg2,arg3)

       written by yamamoto@icot22      on Mon May 13 10:58:37 1991
<Arguments>
cod $B%3!<%I%"%I%l%9(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>

$B!cGSB>@)8f$K4X$7$F!d(B
$B%W%m%U%!%$%j%s%0BP>]$H$J$k%4!<%k$N<B9TCf$K8F$P$l$k$N$G!"(B
$BN$?F$NB8:_$O%A%c%$%k%I%+%&%s%H$K$h$jJ]>Z$5$l$F$$$k!#(B
$BN$?F%l%3!<%IK\BN$N99?7$O9T$J$o$J$$$N$G!"(B
$B%W%m%U%!%$%j%s%0%G!<%?$N$_$r%m%C%/$9$k!#(B

********************************************************************* PSL **/

#DATA_define D_WorkFPProfileHashVal XXX
#DATA_define D_WorkFPProfileHashEntry XXX
#DATA_define D_WorkFPProfileNewEntry XXX
#DATA_define D_WorkFPProfileCode XXX
#DATA_define D_WorkFPProfileResult XXX
#DATA_define D_WorkFPProfileNext XXX
#DATA_define D_WorkFPProfilePredecessor XXX

#DATA_define D_WorkFPProfileSend_Type XXX
#DATA_define D_WorkFPProfileSend_Count XXX
#DATA_define D_WorkFPProfileSend_Level XXX
#DATA_define D_WorkFPProfileSend_Cluster XXX
#DATA_define D_WorkFPProfileSend_Data XXX

#DATA_define D_WorkFPProfileCountKind XXX

#CONST_define _FP_PROFILING_COUNT_MAX 0x7fffffff

#SUBARG_define A_cod SRC
#SUBARG_define A_env SRC

#SUBROUTINE f_FPIncrementDequeueCountProfilingEntry_Sub(A_cod,A_env){
  $USE(D_WorkFPProfileCountKind);
  p_SetImmediateValue(_FP_PROFILE_COUNT_KIND_DEQUEUE,
		      D_WorkFPProfileCountKind);
  $CALL(f_FPIncrementCountProfilingEntry_Sub(D_WorkFPProfileCountKind,
					     A_cod,A_env));
  $RELEASE(D_WorkFPProfileCountKind);
  $RETURN();
}

#SUBARG_define A_cod SRC
#SUBARG_define A_env SRC

#SUBROUTINE f_FPIncrementSuspendCountProfilingEntry_Sub(A_cod,A_env){
  $USE(D_WorkFPProfileCountKind);
  p_SetImmediateValue(_FP_PROFILE_COUNT_KIND_SUSPEND,
		      D_WorkFPProfileCountKind);
  $CALL(f_FPIncrementCountProfilingEntry_Sub(D_WorkFPProfileCountKind,
					     A_cod,A_env));
  $RELEASE(D_WorkFPProfileCountKind);
  $RETURN();
}

#DATA_define D_WorkFPProfilingDataOrgLockDataReg XXX

#SUBARG_define A_kind SRC
#SUBARG_define A_cod  SRC
#SUBARG_define A_env  SRC

#SUBROUTINE f_FPIncrementCountProfilingEntry_Sub(A_kind,A_cod,A_env){

  $USE(D_WorkFPProfileHashVal);
  s_FPProfilingHashValue(A_cod,D_WorkFPProfileHashVal);
/* $B%O%C%7%eCM$O%"%I%l%9%*%U%;%C%H$KJQ49$5$l$F$$$k(B */

  $USE(D_WorkFPProfileHashEntry);
  s_GetFPProfilingData(D_Current_FP_Ptr,D_WorkFPProfileHashEntry);
  b_AddWithDNTC(D_WorkFPProfileHashEntry,D_WorkFPProfileHashVal,
	    D_WorkFPProfileHashEntry);
  $RELEASE(D_WorkFPProfileHashVal);

  $USE(D_WorkFPProfilingDataOrgLockDataReg);
  s_LockFPProfilingHashEntry(D_WorkFPProfileHashEntry,
			    D_WorkFPProfilingDataOrgLockDataReg);

  $USE(D_WorkFPProfileNext);
  p_MoveWord(D_WorkFPProfilingDataOrgLockDataReg,D_WorkFPProfileNext);

  s_IfATOM(D_WorkFPProfileNext){

    $RELEASE(D_WorkFPProfileNext);
    $USE(D_WorkFPProfileNewEntry);
    s_FPAllocAndInitProfilingEntry(A_cod,A_env,D_WorkFPProfileNewEntry);
    s_FPIncrementCountProfilingEntry(A_kind,D_WorkFPProfileNewEntry,D_VOID);
    p_MoveWord(D_WorkFPProfileNewEntry,D_WorkFPProfilingDataOrgLockDataReg);
    $RELEASE(D_WorkFPProfileNewEntry);

    s_UnlockFPProfilingHashEntry(D_WorkFPProfileHashEntry,
			      D_WorkFPProfilingDataOrgLockDataReg);
    $RELEASE(D_WorkFPProfilingDataOrgLockDataReg);
    $RELEASE(D_WorkFPProfileHashEntry);

  }else{

    $USE(D_WorkFPProfileCode);
    $USE(D_WorkFPProfilePredecessor);

    LOOP(){

      s_IfSameCountingTarget(D_WorkFPProfileNext,
			     A_cod,A_env) goto L_increment;

      p_MoveWord(D_WorkFPProfileNext,
		 D_WorkFPProfilePredecessor);
      p_ReadWithOffset(D_WorkFPProfileNext,_FP_PROFILE_ENTRY_NEXT_OFST,
	     D_WorkFPProfileNext);
      
      s_IfATOM(D_WorkFPProfileNext) break;
    }

    s_FPAllocAndInitProfilingEntry(A_cod,A_env,D_WorkFPProfileNext);
    s_FPPushProfilingEntryAtTail(D_WorkFPProfileNext,
				 D_WorkFPProfilePredecessor);
  L_increment:

    $RELEASE(D_WorkFPProfilePredecessor);
    $RELEASE(D_WorkFPProfileCode);

    $USE(D_WorkFPProfileResult);
    s_FPIncrementCountProfilingEntry(A_kind,D_WorkFPProfileNext,
				     D_WorkFPProfileResult);
    $RELEASE(D_WorkFPProfileNext);
    b_IfEqualImm(D_WorkFPProfileResult,_FP_PROFILING_COUNT_MAX){
      $RELEASE(D_WorkFPProfileResult);
      $USE(D_WorkFPProfileSend_Data);

/*  $B$3$3$G0lC6%O%C%7%e%(%s%H%j$r(B Unlock $B$9$k$H!"(B
    $B%$%s%/%j%a%s%H$9$k#P#E$,$$$k$+$b!#(B
      $B"*(B $B$3$3$G$OA4%G!<%?$rJV$9$N$G$O$J$/!"(B
	 $B3:Ev%O%C%7%e%A%'%$%s$@$1$rJV$9$K$H$I$a$l$PNI$$!#(B
*/
      f_GetFPProfilingDataOfOneHashChain(D_WorkFPProfileHashEntry,
					 D_WorkFPProfileSend_Data,
					 D_WorkFPProfilingDataOrgLockDataReg);

      s_UnlockFPProfilingHashEntry(D_WorkFPProfileHashEntry,
				  D_WorkFPProfilingDataOrgLockDataReg);
      $RELEASE(D_WorkFPProfilingDataOrgLockDataReg);
      $RELEASE(D_WorkFPProfileHashEntry);

      $USE(D_WorkFPProfileSend_Type);
      $USE(D_WorkFPProfileSend_Count);
      $USE(D_WorkFPProfileSend_Level);
      $USE(D_WorkFPProfileSend_Cluster);

      b_SetImmTypeValueMRBoff(INT,_FP_PROFILETYPE_COUNTLIMIT,
			      D_WorkFPProfileSend_Type);
      b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkFPProfileSend_Count);
      b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkFPProfileSend_Level);
      b_ShiftLeftImmediateWithDNTC(D_CL_Number, _HALF_WORD_OFFSET, 
				   D_WorkFPProfileSend_Cluster);
      b_SetImmTypeMRBoff(INT,D_WorkFPProfileSend_Cluster);

      $CALL(f_Send_IntClMsg_Shoen_Profile_Sub(D_Current_FP_Ptr,
					       D_WorkFPProfileSend_Type,
					       D_WorkFPProfileSend_Count,
					       D_WorkFPProfileSend_Level,
					       D_WorkFPProfileSend_Cluster,
					       D_WorkFPProfileSend_Data));
      $RELEASE(D_WorkFPProfileSend_Type);
      $RELEASE(D_WorkFPProfileSend_Count);
      $RELEASE(D_WorkFPProfileSend_Level);
      $RELEASE(D_WorkFPProfileSend_Cluster);
      $RELEASE(D_WorkFPProfileSend_Data);
      
    }else{
      $RELEASE(D_WorkFPProfileResult);
      s_UnlockFPProfilingHashEntry(D_WorkFPProfileHashEntry,
				  D_WorkFPProfilingDataOrgLockDataReg);
      $RELEASE(D_WorkFPProfilingDataOrgLockDataReg);
      $RELEASE(D_WorkFPProfileHashEntry);
    }
    
  }
  $RETURN();
}


/******************************************************************** PSL **

f_FPExportProfilingDataForAnswer(fp_rec)
f_FPExportProfilingDataForAnswerWithNoChildShoen(fp_rec){

       written by yamamoto@icot22      on Thu May 16 10:54:18 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

$BAq1`$+$i$N%j%/%(%9%H$KEz$($F!"N$?F$,<+J,<+?H$N;}$C$F$$$?(B
$B%W%m%U%!%$%j%s%0%G!<%?$rM"=P$9$k!#(B
$B;RAq1`$,$"$k>l9g$O!"$=$l$i$N%"%s%5$,0lDL$jB7$C$F$+$i8F$P$l$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define f_FPExportProfilingDataForAnswer(fp_rec){

  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_rec, D_WorkFPOrgLockTagReg);
  $USE(D_WorkFPProfileSend_Count);
  s_GetFPProfilingTotalAnswerCount(fp_rec,D_WorkFPProfileSend_Count);
  s_UnlockFPRecord(fp_rec, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);
  b_IncrementReg(D_WorkFPProfileSend_Count);
/*
  $USE(D_WorkFPProfilingDataOrgLockTagReg);
  s_LockFPProfilingData(fp_rec,D_WorkFPProfilingDataOrgLockTagReg);
*/
  $USE(D_WorkFPProfileSend_Data);
  f_GetFPProfilingDataWithoutHashTab(fp_rec,D_WorkFPProfileSend_Data);
/*
  s_UnlockFPProfilingData(fp_rec,D_WorkFPProfilingDataOrgLockTagReg);
  $RELEASE(D_WorkFPProfilingDataOrgLockTagReg);
*/
  $USE(D_WorkFPProfileSend_Type);
  $USE(D_WorkFPProfileSend_Level);
  $USE(D_WorkFPProfileSend_Cluster);

  b_SetImmTypeValueMRBoff(INT,_FP_PROFILETYPE_ANSWER,
			  D_WorkFPProfileSend_Type);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkFPProfileSend_Level);
  b_ShiftLeftImmediateWithDNTC(D_CL_Number, _HALF_WORD_OFFSET, 
			       D_WorkFPProfileSend_Cluster);
  b_SetImmTypeMRBoff(INT,D_WorkFPProfileSend_Cluster);
  
  $CALL(f_Send_IntClMsg_Shoen_Profile_Sub(fp_rec,
					   D_WorkFPProfileSend_Type,
					   D_WorkFPProfileSend_Count,
					   D_WorkFPProfileSend_Level,
					   D_WorkFPProfileSend_Cluster,
					   D_WorkFPProfileSend_Data));
  $RELEASE(D_WorkFPProfileSend_Type);
  $RELEASE(D_WorkFPProfileSend_Count);
  $RELEASE(D_WorkFPProfileSend_Level);
  $RELEASE(D_WorkFPProfileSend_Cluster);
  $RELEASE(D_WorkFPProfileSend_Data);
  
}

#PSL_define f_FPExportProfilingDataForAnswerWithNoChildShoen(fp_rec){
/*
  $USE(D_WorkFPProfilingDataOrgLockTagReg);
  s_LockFPProfilingData(fp_rec,D_WorkFPProfilingDataOrgLockTagReg);
*/
  $USE(D_WorkFPProfileSend_Data);
  f_GetFPProfilingDataWithoutHashTab(fp_rec,D_WorkFPProfileSend_Data);
/*
  s_UnlockFPProfilingData(fp_rec,D_WorkFPProfilingDataOrgLockTagReg);
  $RELEASE(D_WorkFPProfilingDataOrgLockTagReg);
*/
  $USE(D_WorkFPProfileSend_Type);
  $USE(D_WorkFPProfileSend_Count);
  $USE(D_WorkFPProfileSend_Level);
  $USE(D_WorkFPProfileSend_Cluster);

  b_SetImmTypeValueMRBoff(INT,_FP_PROFILETYPE_ANSWER,
			  D_WorkFPProfileSend_Type);
  b_SetImmTypeValueMRBoff(INT,_ONE,D_WorkFPProfileSend_Count);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkFPProfileSend_Level);
  b_ShiftLeftImmediateWithDNTC(D_CL_Number, _HALF_WORD_OFFSET, 
			       D_WorkFPProfileSend_Cluster);
  b_SetImmTypeMRBoff(INT,D_WorkFPProfileSend_Cluster);
  
  $CALL(f_Send_IntClMsg_Shoen_Profile_Sub(fp_rec,
					   D_WorkFPProfileSend_Type,
					   D_WorkFPProfileSend_Count,
					   D_WorkFPProfileSend_Level,
					   D_WorkFPProfileSend_Cluster,
					   D_WorkFPProfileSend_Data));
  $RELEASE(D_WorkFPProfileSend_Type);
  $RELEASE(D_WorkFPProfileSend_Count);
  $RELEASE(D_WorkFPProfileSend_Level);
  $RELEASE(D_WorkFPProfileSend_Cluster);
  $RELEASE(D_WorkFPProfileSend_Data);
  
}

/******************************************************************** PSL **

f_FPExportProfilingDataFPTerminate(fp_rec)


       written by yamamoto@icot22      on Thu May 16 11:33:10 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

$BN$?F$N=*N;;~$N%W%m%U%!%$%j%s%0%G!<%?$NM"=P(B

<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkTFPProfileSend_Type     XXX
#DATA_define D_WorkTFPProfileSend_Count    XXX
#DATA_define D_WorkTFPProfileSend_Level    XXX
#DATA_define D_WorkTFPProfileSend_Cluster  XXX
#DATA_define D_WorkTFPProfileSend_Data     XXX

#PSL_define f_FPExportProfilingDataFPTerminate(fp_rec){
/*
  $USE(D_WorkFPProfilingDataOrgLockTagReg);
  s_LockFPProfilingData(fp_rec,D_WorkFPProfilingDataOrgLockTagReg);
*/
  $USE(D_WorkTFPProfileSend_Data);
  f_GetFPProfilingDataWithoutHashTab(fp_rec,D_WorkTFPProfileSend_Data);
/*
  s_UnlockFPProfilingData(fp_rec,D_WorkFPProfilingDataOrgLockTagReg);
  $RELEASE(D_WorkFPProfilingDataOrgLockTagReg);
*/
  $USE(D_WorkTFPProfileSend_Type);
  $USE(D_WorkTFPProfileSend_Count);
  $USE(D_WorkTFPProfileSend_Level);
  $USE(D_WorkTFPProfileSend_Cluster);
  
  b_SetImmTypeValueMRBoff(INT,_FP_PROFILETYPE_FPTERMINATE,
			  D_WorkTFPProfileSend_Type);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkTFPProfileSend_Count);
  b_SetImmTypeValueMRBoff(INT,_ZERO,D_WorkTFPProfileSend_Level);
  b_ShiftLeftImmediateWithDNTC(D_CL_Number, _HALF_WORD_OFFSET, 
			       D_WorkTFPProfileSend_Cluster);
  b_SetImmTypeMRBoff(INT,D_WorkTFPProfileSend_Cluster);
  
  $CALL(f_Send_IntClMsg_Shoen_Profile_FPTerminate_Sub(fp_rec,
					   D_WorkTFPProfileSend_Type,
					   D_WorkTFPProfileSend_Count,
					   D_WorkTFPProfileSend_Level,
					   D_WorkTFPProfileSend_Cluster,
					   D_WorkTFPProfileSend_Data));
  $RELEASE(D_WorkTFPProfileSend_Type);
  $RELEASE(D_WorkTFPProfileSend_Count);
  $RELEASE(D_WorkTFPProfileSend_Level);
  $RELEASE(D_WorkTFPProfileSend_Cluster);
  $RELEASE(D_WorkTFPProfileSend_Data);

}

/******************************************************************** PSL **

f_FPExportProfilingDataOfChild(fp_ptr,type,count,level,cluster,data)

       written by yamamoto@icot22      on Thu May 16 11:06:35 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>

$B;RAq1`$+$i>e$,$C$F$-$?%W%m%U%!%$%j%s%0%G!<%?$rM"=P$9$k!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define f_FPExportProfilingDataOfChild(fp_ptr,
					   type,count,level,cluster,data){
  $CALL(f_Send_IntClMsg_Shoen_Profile_Sub(fp_ptr,
					   type,count,level,cluster,data));
}

/******************************************************************** PSL **

      f_GetFPProfilingDataWithoutHashTab(fp_ptr,data)
	$B$3$N%^%/%m$NCf$G%O%C%7%e%(%s%H%jKh$K%m%C%/$7$^$9!#(B

      f_GetFPProfilingDataOfOneHashChain(hash_entry,send_data)
	$B$3$N%^%/%m$N30$G%m%C%/$7$F$M!#(B

       written by yamamoto@icot22      on Tue May 21 13:18:54 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkFPProfileLoopCounter XXX
#DATA_define D_WorkFPProfileTailOfChain XXX
#DATA_define D_WorkFPProfileDataChain  XXX

#PSL_define f_GetFPProfilingDataWithoutHashTab(fp_ptr,data){

  $USE(D_WorkFPProfileLoopCounter);
  b_SetImmValueDNTC(_SIZE_OF_FP_PROFILING_HASH_TAB,
		    D_WorkFPProfileLoopCounter);
  $USE(D_WorkFPProfileHashEntry);
  s_GetFPProfilingData(fp_ptr,D_WorkFPProfileHashEntry);
  $USE(D_WorkFPProfileTailOfChain);
  b_SetImmTypeValueMRBoff(ATOM,_ZERO,D_WorkFPProfileTailOfChain);
  b_SetImmTypeValueMRBoff(ATOM,_ZERO,data);
  $USE(D_WorkFPProfileNext);
  LOOP(){

    $USE(D_WorkFPProfilingDataOrgLockDataReg);
    s_LockFPProfilingHashEntry(D_WorkFPProfileHashEntry,
			      D_WorkFPProfilingDataOrgLockDataReg);

    p_MoveWord(D_WorkFPProfilingDataOrgLockDataReg,D_WorkFPProfileNext);

    s_IfATOM(D_WorkFPProfileNext)goto L_next;

    s_IfATOM(D_WorkFPProfileTailOfChain){
      s_FPPopAllProfilingEntries(D_WorkFPProfileHashEntry,
				 data,
				 D_WorkFPProfilingDataOrgLockDataReg);
    }else{
      $USE(D_WorkFPProfileDataChain);
      s_FPPopAllProfilingEntries(D_WorkFPProfileHashEntry,
				 D_WorkFPProfileDataChain,
				 D_WorkFPProfilingDataOrgLockDataReg);
      p_WriteWithOffset(D_WorkFPProfileDataChain,
			D_WorkFPProfileTailOfChain,
			_FP_PROFILE_ENTRY_NEXT_OFST);
      $RELEASE(D_WorkFPProfileDataChain);
    }

    LOOP(){
      p_MoveWord(D_WorkFPProfileNext,D_WorkFPProfileTailOfChain);
      p_ReadWithOffset(D_WorkFPProfileNext,_FP_PROFILE_ENTRY_NEXT_OFST,
		       D_WorkFPProfileNext);
      s_IfATOM(D_WorkFPProfileNext)goto L_next;
    }
  L_next:

    s_UnlockFPProfilingHashEntry(D_WorkFPProfileHashEntry,
			      D_WorkFPProfilingDataOrgLockDataReg);
    $RELEASE(D_WorkFPProfilingDataOrgLockDataReg);

    b_IncrementAddrReg(D_WorkFPProfileHashEntry);
    b_DecrementReg(D_WorkFPProfileLoopCounter);
    b_IfEqual(D_WorkFPProfileLoopCounter,D_NULL)goto L_end;
  }
 L_end:
  $RELEASE(D_WorkFPProfileTailOfChain);
  $RELEASE(D_WorkFPProfileNext);
  $RELEASE(D_WorkFPProfileHashEntry);
  $RELEASE(D_WorkFPProfileLoopCounter);

}

#PSL_define f_GetFPProfilingDataOfOneHashChain(hash_entry,
					       send_data,
					       org_data_reg){
      s_FPPopAllProfilingEntries(hash_entry,send_data,org_data_reg);
}

/**********************************

$B%+%l%s%HN$?F$NAq1`%W%m%U%!%$%j%s%0%9%F!<%?%9$N%-%c%C%7%e@)8f(B

***********************************/

#DATA_define D_CurrentSHProfMode XXX

#PSL_define f_SetSHProfMode(){
  p_MoveWord(D_ONE,D_CurrentSHProfMode );
}

#PSL_define f_ResetSHProfMode(){
  p_MoveWord(D_NULL,D_CurrentSHProfMode );
}

#CTRL_define f_IfSHProfModeOn(){
  b_IfNotEqual(D_NULL,D_CurrentSHProfMode )
}

