
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_fp_main.psl.c
   ----- CREATED   : by yamamoto@icot22, on Fri May 25 10:59:03 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Jul 13 17:56:04 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : fuctions	(middle and low)
   ----- ABSTRACT  : $BN$?F$rCf?4$H$7$?=hM}$N9|3J$*$h$SItIJ!#(B
(0) $B35MW(B
    $B<g$K(B f_fp_recv_message $B$+$i8F$S=P$5$l!"(B
    str_fp_record, str_fp_rec_ope$B$J$I$rMQ$$$FN$?FA`:n$r<B8=$9$k!#(B

1. $BN$?F%l%3!<%I$N@8@.(B
   $BN$?F$r@8@.$9$k:]$KN$?F%l%3!<%IMQ$N%a%b%j$r%U%j!<%j%9%H$+$i3d$jEv$F!"$5$i$KN$(B
$B?F%l%3!<%I$N3F%9%m%C%H$r=i4|2=$9$k!#(B

2. $BCfCG%4!<%k$N(BHook/Unhook
   $B%4!<%k<B9T;~$K$=$N%4!<%k$NN$?F$N>uBV$r%A%'%C%/$7$?;~!"$=$NN$?F$N>uBV$,<B9T2D(B
$BG=>uBV$G$J$1$l$P!"$=$N%4!<%k$ON$?F$NCfCG%4!<%k%j%s%/$K$D$J$,$l$k!#$^$?!"N$?F$,(B
$B<B9TIT2DG=>uBV$+$i<B9T2DG=>uBV$KJQ$o$C$?;~$K$O!"$=$NN$?F$NCfCG%4!<%k%j%s%/$K$D(B
$B$J$,$l$F$$$k%4!<%k$O:F$S%4!<%k%9%?%C%/$KF~$l$i$l$k!#(B
   $B$3$l$i$NA`:n$O!"F10l%/%i%9%?Fb$NJ#?t%W%m%;%C%5$,F1;~$K9T$J$&2DG=@-$,$"$k$?$a(B
$B!"GSB>@)8fIU$-$G9T$J$o$l$k!#(B

3. $B%a%C%;!<%8<u?.=hM}(B
   $BAq1`$+$i%a%C%;!<%8$,Aw$i$l$F$-$?;~$O!"%M%C%H%o!<%/%O%s%I%i$+$i(B
f_fp_recv_message$B$N%a%C%;!<%8=hM}%^%/%m$,8F$P$l!"$5$i$K$=$NCf$+$i$3$N%a%C%;!<%8(B
$B<u?.=hM}%^%/%m$,8F$S=P$5$l$k!#(B

   
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

$BAq1`$N=i4|2=$G!"F1$8%/%i%9%?Fb$K:n$kN$?F$N3d$jEv$F$*$h$S=i4|2=$N$_$K;H$o$l$k!#(B

  f_AllocAndInitFP(shoen_record, min_prio_reg, max_prio_reg,
			            shoen_id_reg, init_wtc_reg, fp_record)

       written by kawai@icot21      Fri Jan  6 19:40:08 1989
       revised by kawai@icot21      on Fri Mar  3 18:16:09 1989
       revised by pim@icot22      on Tue Apr 25 19:16:44 1989

<Arguments>
  shoen_record : $B?FAq1`%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  max_prio_reg : $B?FAq1`Fb$N:GBgM%@hEY$rJ];}$9$k%l%8%9%?(B
  min_prio_reg : $B?FAq1`Fb$N:G>.M%@hEY$rJ];}$9$k%l%8%9%?(B
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJV$9%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Resource_Reg : $BN$?F@8@.;~$K!"N$?F$N;q8;$N=i4|CM$r3d$jEv$F$k$?$a$N(B
                           $B%l%8%9%?!#K\Mh$O(B0$B$G$"$kH&$G$"$k$,!"EvLL$O4v$i$+3d$j(B
                           $BEv$F$F$*$/!#(B
<Level>
  functions
<PreCondition>
<Function>
  $BN$?F%l%3!<%I$r3d$jEv$F!"F1;~$K=i4|2=$9$k!#(B
<Examples>
<Test>
<Explanation>
  $BN$?F%l%3!<%I$N3F%9%m%C%H$N=i4|CM$O0J2<$NDL$j!#(B

        $B%9%m%C%H(B                           $B=i4|CM(B
  ---------------------------------------------------------------------------
        import_table_entry                 D_NULL <- ???
        foster_parent_status               started,not rsc_exhausted $B2>(B
  					   <* stoped,rsc_exhausted *>$BK\HV(B
        stopped_goals                      D_EOL
        children_count                     D_ONE
        right_child_shoen_link             $B<+J,<+?H(B($BN$?F%l%3!<%I(B)$B$X$N%]%$%s%?(B
        left_child_shoen_link              $B<+J,<+?H(B($BN$?F%l%3!<%I(B)$B$X$N%]%$%s%?(B
        resource_left_lower                _INIT_FP_RESOURCE
        resource_left_upper                D_NULL
        last_resource_left_lower           _INIT_FP_RESOURCE
        last_resource_left_upper           D_NULL
        child_shoen_statistics_count       D_NULL
        max_priority                       $B0z?t$NDL$j(B
        min_priority                       $B0z?t$NDL$j(B
        suspended_message                  D_EOL
        child_shoen_link_lock_flag         D_NULL  ($BL>>NJQ99(B)
	foster_parent_lock_flag		   D_NULL
	stat_stop_count                    D_NULL
	cdesk_word                         CDESK!12

<ETC>
<Revised Memo on "Mar  3">
  $BN$?F$N=i4|>uBV$r@_Dj$9$kA0$K!"N$?F$N(BStatus$B%9%m%C%H$r(BD_NULL$B$G=i4|2=$9$k$h$&$K(B
$B$7$?!#(B
<Revised Memo on "Apr 25">
  Bug fixed in f_ExecMessageForFP.
********************************************************************* PSL **/

#CONST_define  _INIT_FP_RESOURCE     0x00000000

#CONST_define  _FP_INIT_NO_PROFILING  0
#CONST_define  _FP_INIT_PROFILING     1

#PSL_define  f_AllocAndInitFP( min_prio_reg, max_prio_reg,
			       min_node_reg, node_cnt_reg,
			            shoen_id_reg, init_wtc_reg, fp_record)
{
  $USE(D_WorkVOIDFlag);
  $CALL( s_GetFPRecPtrAndAllocBImpRecWithWTC_Sub( shoen_id_reg,
			init_wtc_reg, D_ONE, fp_record, D_WorkVOIDFlag ) );
  $RELEASE(D_WorkVOIDFlag);
/** $B3F%9%m%C%H$N=i4|2=(B **/
/* $B%A%c%$%k%I%+%&%s%H!"M"F~I=%(%s%H%j$X$N%]%$%s%?!"N$?F5Z$S;RAq1`%j%s%/$N(B
   $B%m%C%/$N$?$a$N%o!<%I$N=i4|2=$O>e$N(B s_GetFPRecPtrAndAllocBImpRecWithWTC_Sub
   $B$G$d$C$F$k(B
*/
/* $B<!$N(B f_InitFPSlots $B$OK\Mh%m%C%/$7$F$+$i8F$V$b$N$@$,!"$3$3$K8B$C$F$O(B
   $B30$+$i8F$V?M$,$$$J$$$O$:(B 
*/
  f_InitFPSlots(fp_record,_FP_INIT_NO_PROFILING,
		_FP_STOPPED, _FP_RSC_EXHAUSTED_FLAG,
		D_ONE, min_prio_reg, max_prio_reg,
		min_node_reg, node_cnt_reg);
}


#PSL_define  f_AllocAndInitProfilingFP( min_prio_reg, max_prio_reg,
				        min_node_reg, node_cnt_reg,
				       shoen_id_reg, init_wtc_reg, fp_record)
{
  $USE(D_WorkVOIDFlag);
  $CALL( s_GetFPRecPtrAndAllocBImpRecWithWTC_Sub( shoen_id_reg,
			init_wtc_reg, D_ONE, fp_record, D_WorkVOIDFlag ) );
  $RELEASE(D_WorkVOIDFlag);
/** $B3F%9%m%C%H$N=i4|2=(B **/
/* $B%A%c%$%k%I%+%&%s%H!"M"F~I=%(%s%H%j$X$N%]%$%s%?!"N$?F5Z$S;RAq1`%j%s%/$N(B
   $B%m%C%/$N$?$a$N%o!<%I$N=i4|2=$O>e$N(B s_GetFPRecPtrAndAllocBImpRecWithWTC_Sub
   $B$G$d$C$F$k(B
*/
/* $B<!$N(B f_InitFPSlots $B$OK\Mh%m%C%/$7$F$+$i8F$V$b$N$@$,!"$3$3$K8B$C$F$O(B
   $B30$+$i8F$V?M$,$$$J$$$O$:(B 
*/
  f_InitFPSlots(fp_record,_FP_INIT_PROFILING,
		_FP_STOPPED, _FP_RSC_EXHAUSTED_FLAG,
		D_ONE, min_prio_reg, max_prio_reg,
		min_node_reg, node_cnt_reg);
}

/******************************************************************** PSL **

 f_InitFPSlots(fp_record,  imm_prof_or_not,
	       imm_log_status, imm_phy_status,
	       child_cnt_reg, min_prio_reg, max_prio_reg,
	       min_node_reg, node_cnt_reg);

       written by kawai@icot22      on Wed Feb 21 20:09:28 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BN$?F%l%3!<%I$N3F%9%m%C%H$r=i4|2=$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>

%ready $B$NH/9T$O30$G$d$k!#$H8@$&$N$b!"Aq1`$r%/%j%(%$$H$9$k;~$K0l=o$K:n$kN$?F$O(B
%ready $B$9$kI,MW$,$J$$$+$i!#(B


********************************************************************* PSL **/

#DATA_define D_WorkFPResourceReg XXX 
/* $B#1%o!<%I$KG<$^$k$3$H$,J,$+$C$F$$$k>l9g$K;H$&%o!<%/%l%8%9%?(B           */
/* ex.$B#P#E$N%-%c%C%7%e!"N$?F$N=i4|CM!"%9%m!<%4!<%k$d%5%W%i%$%j%=!<%9$K(B
					                 $B:\$C$F$/$kJ,!"(B */

#DATA_define D_WorkFPSSC XXX /* work for Start Stop Count */
/* $B%j%=!<%9$N=i4|CM$O0z?t$K$9$k$Y$-!)(B */
			/* recv_throw_goal $B$G$O8e$+$i2~$a$F@_Dj$7$F$$$k(B */

#DATA_define D_WorkFPProfOrNot XXX

#PSL_define f_InitFPSlots(fp_record, imm_prof_or_not,
			  imm_transit_status, imm_status_flags, 
			  child_cnt_reg, min_prio_reg, max_prio_reg,
			  min_node_reg, node_cnt_reg)
{

  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);
  b_MoveWithImmTypeMRBoff(D_NULL, INT, D_WorkFPChildShoenLinkOrgLockTagReg);
  /* INT: unlocked, SLOCK: locked */
  s_PutFPChildShoenLinkLockFlag(fp_record, 
					D_WorkFPChildShoenLinkOrgLockTagReg);
  $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);

  s_PutFPStatus(fp_record, D_NULL);
  s_PutFPTransitStatusImm(fp_record, imm_transit_status);
  s_PutFPStatusFlag(fp_record, imm_status_flags);
  s_PutFPStoppedGoals(fp_record, D_EOL);
  s_PutFPSuspendedMessage(fp_record, D_EOL);
  s_PutFPChildCount(fp_record, child_cnt_reg);
  s_PutFPChildCountInGC(fp_record, D_NULL);
  s_PutFPStatGatherEventCount(fp_record, D_NULL);
  s_PutFPRightChildShoenLink(fp_record, fp_record);
  s_PutFPLeftChildShoenLink(fp_record, fp_record);
  s_PutFPAnswerResource(fp_record,D_NULL,D_NULL);


  $USE(D_WorkFPProfilingDataOrgLockTagReg);
  b_MoveWithImmTypeMRBoff(D_NULL, INT, D_WorkFPProfilingDataOrgLockTagReg);
  /* INT: unlocked, SLOCK: locked */
  s_PutFPProfilingLockFlag(fp_record, D_WorkFPProfilingDataOrgLockTagReg);

  $USE(D_WorkFPProfOrNot);
  p_SetImmediateValue(imm_prof_or_not,D_WorkFPProfOrNot);
  b_IfEqualImm(D_WorkFPProfOrNot,_FP_INIT_NO_PROFILING){
    s_PutFPProfilingData(fp_record,D_WorkFPProfilingDataOrgLockTagReg);
  }else{
    s_SetFPStatusFlag(fp_record,_FP_PROFILING_FLAG);
    s_FPAllocProfilingHashTab(fp_record);
  }
  $RELEASE(D_WorkFPProfOrNot);
  $RELEASE(D_WorkFPProfilingDataOrgLockTagReg);

  s_PutFPMinNode(fp_record, min_node_reg);
  s_PutFPNodeCount(fp_record, node_cnt_reg);

  s_PutFPProfilingTotalAnswerCount(fp_record,D_NULL);
  s_PutFPProfilingChildShoenCount(fp_record,D_NULL);

  $USE(D_WorkFPResourceReg);
  b_SetImmTypeValueMRBoff(INT, _INIT_FP_RESOURCE, D_WorkFPResourceReg);
  s_PutFPResourceLeft(fp_record, D_NULL, D_WorkFPResourceReg);
  s_PutFPLastResourceLeft(fp_record, D_NULL, D_WorkFPResourceReg);
  $RELEASE(D_WorkFPResourceReg);

  b_SetImmTypeMRBoff(INT, max_prio_reg);
  s_PutFPMaxPriority(fp_record, max_prio_reg);
  b_SetImmTypeMRBoff(INT, min_prio_reg);
  s_PutFPMinPriority(fp_record, min_prio_reg);

  $USE(D_WorkFPSSC);
  b_SetImmValueDNTC(imm_transit_status,D_WorkFPSSC);
  ValueSwitch(D_WorkFPSSC){

    /* $BAq1`$H0l=o$K:n$i$l$kN$?F$O$3$3$+$i;O$^$k(B */
  case _FP_STOPPED:
    s_PutFPStartStopCount(fp_record, D_ALL1);/* D_ALL1 as -1 */
    break;

    /* $B%4!<%k$r<u$1$H$C$F:n$kN$?F$O$3$3$+$i;O$^$k(B */
    /* $B0lHV>e$N%@%_!<N$?F$b$3$3$+$i$G$7$g$&$M(B */
  case _FP_STARTED:
    s_PutFPStartStopCount(fp_record, D_NULL);
    break;

  default:
    @DEBUG{ VPIM_ERROR("f_InitFPSlots","illegal imm_transit_status"); };
    break;
  }
  $RELEASE(D_WorkFPSSC);

  s_PutFPChildShoenStatisticsCount(fp_record, D_NULL);
  s_SetFPCdescWord(fp_record);


}

/******************************************************************** PSL **

  f_FPTerminateWithUnlockFP_Sub(A_PtrToFPRecord,A_FPOrgLockTagReg)

       written by kawai@icot21      on Thu Apr  6 23:16:44 1989
<Arguments>
  A_PtrToFPRecord : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkResource : $BAq1`$KJV$9;q8;NL$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkImpRecAddr : $B9uM"F~I=%(%s%H%j$N%"%I%l%9$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkHashEntryPtr : $B9uM"F~I=$N%O%C%7%e%"%I%l%9$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkResourceConsumed : $BN$?F$N>CHq;q8;NL$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkShoenID : $BAq1`(BID$B$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkWTC : $BAq1`$KJV$9(BWTC$B$r0l;~J];}$9$k%l%8%9%?(B
  D_WorkCLNum : $B?FAq1`$NB8:_$9$k%/%i%9%?HV9f$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
<Function>
  $BN$?F$r=*7k$9$k!#(B
  $BN$?F$N;RAq1`%+%&%s%?$,(B0$B$K$J$C$?;~E@$G8F$P$l$k!#(B(execute/proceed$B$N%?%$%_%s%0(B)
<Examples>
<Test>
<Explanation>
$B?7$7$$%3%a%s%H(B 90-11-22 -- Reki
  $B%A%c%$%k%I%+%&%s%H$N%a%$%s%F%J%s%9$H!"%A%c%$%k%I%+%&%s%H%<%m$K$h$k(B
  $B%?!<%_%M%$$H$NH=CG$O!"8F=PB&$G9T$J$&!#(B
  $B8F=PB&$GN$?F%l%3!<%I$r%m%C%/$7$F$$$k$3$H!#(B
  $B%"%s%m%C%/$OK\%^%/%m$G9T$J$&!#(B

*****$B@N$N%3%a%s%H!)(B******
  $B$3$N%^%/%m$,8F$P$l$k;~$K$O9uM"F~%O%C%7%eI=$r%=%U%H%&%'%"%m%C%/$7!"K\Ev$K%j%j(B
$B!<%9$9$kA0$K$b$&0lEYN$?F%l%3!<%I$N(BChildCount$B$,(B0$B$G$"$k$3$H$r3NG'$9$k!#(B
  $B$^$?!"%/%i%9%?$K%4!<%k$,Ej$2$i$l$F$-$?;~$K$O!"9uM"F~%O%C%7%eI=$r%=%U%H%&%'%"(B
$B%m%C%/$7$F$+$iN$?F%l%3!<%I$N(BChildCount$B$r%$%s%/%j%a%s%H$9$k!#(B
  $B$3$N$?$a!"N$?F%l%3!<%I$N(BChildCount$B$K%"%/%;%9$9$k:]$KN$?F%l%3!<%I$r%=%U%H%&%'(B
$B%"%m%C%/$7$F$7$^$&$H!"9uM"F~%O%C%7%eI=$N%=%U%H%&%'%"%m%C%/$HN$?F%l%3!<%I$N%=%U(B
$B%H%&%'%"%m%C%/$H$N4V$G%G%C%I%m%C%/$,@8$8$k2DG=@-$,$"$k!#(B
  $B$^$?!"$3$l$i$N=hM}$K$O$I$A$i$b9uM"F~%O%C%7%eI=$N%m%C%/$rH<$&$?$a!"N$?F%l%3!<(B
$B%IA4BN$N%m%C%/$OI,MW$J$/$J$k!#(B($B$?$@$7!"(BChildCount$B%9%m%C%H$N99?7=hM}$K$O%O!<%I%&(B
$B%'%"%m%C%/$,I,MW$G$"$k!#(B)
  $B=>$C$F!"$3$N%^%/%mCf$d%4!<%k$N<u?.=hM}$NCf$G$ON$?F%l%3!<%I$r%=%U%H%&%'%"%m%C(B
$B%/$7$F$O$J$i$J$$!#(B
*****$B@N$N%3%a%s%H!)(B(owari)******
<ETC>

<<$BCm0U(B>>
90-11-14
terminate,abort$B=hM}<~$j$G!"(BWTC$BITB-$G%5%9%Z%s%I$7$?%a%C%;!<%8$,M-$C$?>l9g$N9M;!$,3N$+$G$J$$!D(B
-- Reki

********************************************************************* PSL **/

#DATA_define  D_WorkFPTerminateLockTag   XXX
#DATA_define  D_WorkImpRecAddr XXX

#DATA_define D_WorkFPTerminateSubStatusReg XXX

#DATA_define D_WorkFPResourceLower XXX
#DATA_define D_WorkFPResourceUpper XXX
#DATA_define D_WorkFPResourceConsumeLower XXX
#DATA_define D_WorkFPResourceConsumeUpper XXX
#DATA_define D_WorkFPSuspendedMessage XXX

#SUBARG_define	A_PtrToFPRecord		MODIFY /* $BMW3NG'(B */
#SUBARG_define  A_FPOrgLockTagReg       SRC

/* $B5lL>(B
  f_FPTerminate_Sub(A_PtrToFPRecord)
*/
#SUBROUTINE  f_FPTerminateWithUnlockFP_Sub(A_PtrToFPRecord,
					   A_FPOrgLockTagReg){
  @DEBUG{
    _PrintFPInfo(A_PtrToFPRecord);
    WARNING("f_FPTerminateWithUnlockFP_Sub","FP will be terminated");
  };

  $USE(D_WorkFPResourceLower);
  $USE(D_WorkFPResourceUpper);
  $USE(D_WorkFPResourceConsumeLower);
  $USE(D_WorkFPResourceConsumeUpper);
  $USE(D_WorkFPSuspendedMessage);

  /* $BN$?F%l%3!<%I$N%m%C%/(B */

  s_IfNoChild(A_PtrToFPRecord)
    { /*  $B$b$7N$?F$N(BChildCount$B$,(B0$B$@$C$?$i(B  */
      /* $B$3$N%A%'%C%/$OMW$i$J$/$J$C$?$O$:(B 90-11-22 -- Reki */

      s_GetFPSuspendedMessage(A_PtrToFPRecord,D_WorkFPSuspendedMessage);
      b_IfNotEOL(D_WorkFPSuspendedMessage){
	s_IfAbortedFP(A_PtrToFPRecord){
	  ;
	}else{
	  s_IfAbortedTerminateFP(A_PtrToFPRecord){
	    ;
	  }else{
	    s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);
	    @DEBUG{
	      WARNING("f_FPTerminateWithUnlockFP_Sub",
		      "No children but suspendedmessage(s).");
	    };
	    goto End;
	    /* $B$3$N;~$O!"$J$s$+%a%C%;!<%8$,Mh$k$O$:$J$N$G!"(B */
	    /* $B2?$b$;$:$K$[$C$F$*$/(B */
	  }
	}
      }

      $USE(D_WorkFPTerminateSubStatusReg);
      s_GetFPTransitStatus(A_PtrToFPRecord, D_WorkFPTerminateSubStatusReg);
      ValueSwitch( D_WorkFPTerminateSubStatusReg){
      case _FP_STARTED:
      case _FP_STOPPED:
	s_GetFPResourceLeft(A_PtrToFPRecord, 
			    D_WorkFPResourceUpper,D_WorkFPResourceLower);
	/* $BJV5Q$9$k;q8;$rF@$k(B */
	s_GetFPResourceConsumedWithUpdate(A_PtrToFPRecord, 
					  D_WorkFPResourceConsumeUpper,
					  D_WorkFPResourceConsumeLower);
	/* $B>CHq$7$?;q8;NL$rF@$k(B */
	s_PutFPTransitStatusImm(A_PtrToFPRecord,_FP_TERMINATE);
	s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);

	s_IfProfilingFP(A_PtrToFPRecord){
	  f_FPExportProfilingDataFPTerminate(A_PtrToFPRecord);
	  s_FPReclaimProfilingHashTab(A_PtrToFPRecord);
	}

	$CALL(f_Send_IntClMsg_Terminated_Sub
	      (A_PtrToFPRecord, D_WorkFPResourceUpper, 
	       D_WorkFPResourceLower, D_WorkFPResourceConsumeUpper,
	       D_WorkFPResourceConsumeLower));
	s_ReclaimFPRecord(A_PtrToFPRecord);
	break;
      case _FP_ABORTED:
	s_GetFPResourceLeft(A_PtrToFPRecord, 
			    D_WorkFPResourceUpper,D_WorkFPResourceLower);
	/* $BJV5Q$9$k;q8;$rF@$k(B */
	s_GetFPResourceConsumedWithUpdate(A_PtrToFPRecord, 
					  D_WorkFPResourceConsumeUpper,
					  D_WorkFPResourceConsumeLower);
	/* $B>CHq$7$?;q8;NL$rF@$k(B */
	s_PutFPTransitStatusImm(A_PtrToFPRecord,_FP_ABORTED_TERMINATE);
	s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);

	s_IfProfilingFP(A_PtrToFPRecord){
	  f_FPExportProfilingDataFPTerminate(A_PtrToFPRecord);
	  s_FPReclaimProfilingHashTab(A_PtrToFPRecord);
	}

	$CALL(f_Send_IntClMsg_Terminated_Sub
	      (A_PtrToFPRecord, D_WorkFPResourceUpper, 
	       D_WorkFPResourceLower, D_WorkFPResourceConsumeUpper,
	       D_WorkFPResourceConsumeLower));
	s_ReclaimFPRecord(A_PtrToFPRecord);
	break;
      case _FP_ABORTED_TERMINATE:
	s_UnlockFPRecord(A_PtrToFPRecord,A_FPOrgLockTagReg);

	s_ReclaimFPRecord(A_PtrToFPRecord);
	break;
      case _FP_RESERVED:
	s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);

	@DEBUG{
	  VPIM_ERROR("f_FPTerminateWithUnlockFP_Sub",
		     "illegal status:_FP_RESERVED");
	};
	break;
      case _FP_TERMINATE:
	s_UnlockFPRecord(A_PtrToFPRecord,  A_FPOrgLockTagReg);

	@DEBUG{
	  VPIM_ERROR("f_FPTerminateWithUnlockFP_Sub",
		     "illegal status:_FP_TERMINATE");
	};
	break;
      default:
	s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);

	@DEBUG{
	  VPIM_ERROR("f_FPTerminateWithUnlockFP_Sub",
		     "illegal status:??unknown??");
	};
	break;
      }
      $RELEASE(D_WorkFPTerminateSubStatusReg);
    }
  else
    {

      @DEBUG{
	VPIM_ERROR("f_FPTerminateWithUnlockFP_Sub",
		   "called with non zero child count");
      };
/* 90-11-22 $B0J2<A4It%3%a%s%H2=(B -- Reki */
/* 
	<* $BG0$N$?$a$3$3$N%3!<%G%#%s%0$,I,MW$K$J$k$+$bCN$l$J$$$N$G(B
	  $BIU$12C$($F$*$/$H!"0J2<$G!"%m%C%/$N=gHV$,(BFP->Link$B$H$J$C$F$$$k(B
	    $B$N$G4V0c$$$G$"$k!#(B 90-11-22 -- Reki *>

      <*  $B$b$7N$?F$N(BChildCount$B$,(B0$B$G$J$+$C$?$i(B  *>			
      <* $B$3$3$i$X$s$O$3$l$G$$$$$N$+$b$&0lEY9M$($F8+$?$$$M(B *>
      s_IfAbortedFP(A_PtrToFPRecord)
	{ <*  $B$b$7N$?F$N>uBV$,(B_ABORTED$B$@$C$?$i(B  *>
	  $USE(D_Work_FP_Child_Link_Reg);
	  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);
	  s_LockFPChildShoenLink(A_PtrToFPRecord,
					D_WorkFPChildShoenLinkOrgLockTagReg);
	  s_GetFPRightChildShoenLink(A_PtrToFPRecord,
				                 D_Work_FP_Child_Link_Reg);
	  s_UnlockFPChildShoenLink(A_PtrToFPRecord,
					D_WorkFPChildShoenLinkOrgLockTagReg);
	  $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);


	  b_IfEqual(A_PtrToFPRecord, D_Work_FP_Child_Link_Reg)
	    { <* $B$b$7;RAq1`$,$$$J$1$l$P(B *>
	      <* $B$3$N>l9g!"(B
		$B!VN$?F$N;RAq1`%j%s%/$+$i$N:o=|M=Dj$N;RAq1`$b$$$J$+$C$?$i!W(B
		  $B$H8@$&0UL#$G$"$k!#(B
		  $B:o=|M=Dj$N;RAq1`$,$$$?>l9g!"$=$N;RAq1`$N>CHq;q8;Ey$,$^$@N$?F(B
		  $B$KH?1G$5$l$F$$$J$$2DG=@-$,$"$k$?$a!"N$?F$O=*7k$7$F$O$$$1$J$$(B
                  $B!#(B
	      *>

	      s_GetFPResourceLeft(A_PtrToFPRecord, 
				  D_WorkFPResourceUpper,D_WorkFPResourceLower);
	      <* $BJV5Q$9$k;q8;$rF@$k(B *>
	      s_GetFPResourceConsumedWithUpdate(A_PtrToFPRecord, 
						D_WorkFPResourceConsumeUpper,
						D_WorkFPResourceConsumeLower);
	      <* $B>CHq$7$?;q8;NL$rF@$k(B *>
	      s_PutFPTransitStatusImm(A_PtrToFPRecord,_FP_ABORTED_TERMINATE);
	      s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);
	      $CALL(f_Send_IntClMsg_Terminated_Sub
	              (A_PtrToFPRecord,D_WorkFPResourceUpper, 
		       D_WorkFPResourceLower, D_WorkFPResourceConsumeUpper,
		       D_WorkFPResourceConsumeLower));
	      <*  ABORTED$B>uBV$NN$?F%l%3!<%I$O$3$N;~E@$G$O2s<}$7$J$$!#(B *>
	    }
          else
	    { <*  $B$b$7;RAq1`$,$$$l$P(B  *>
	      <*
		$BN$?F$,(B_ABORTED$B>uBV$G$O$"$k$,!"$^$@;RAq1`$,$$$k$N$KK\%^%/%m$,(B
		$B8F$P$l$F$7$^$C$?>l9g!#(B
	      *>
	      s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);
	      @DEBUG{	
		WARNING("f_FPTerminateWihtUnlockFP_Sub",
			"called when Child Shoen still linked to Aborted FP.");
	      };
	    }
	  $RELEASE(D_Work_FP_Child_Link_Reg);
	}
      else
	{ <*  $B$b$7N$?F$N>uBV$,(B_ABORTED$B$G$J$+$C$?$i(B  *>
	  
	  s_IfAbortedTerminateFP(A_PtrToFPRecord){
	    s_UnlockFPRecord(A_PtrToFPRecord,A_FPOrgLockTagReg);
	    @DEBUG{
	      VPIM_ERROR("f_FPTerminateWithUnlockFP_Sub",
			 "child count != 0 & status AbortedTerminate");
	    };
	    
	  }else{
	    
	    <*
	      ChildCount = 0 $B$N>uBV$G(Bf_FPTerminate$B$,8F$P$l$?$,!"9uM"F~I=$+$i(B
		$BN$?F%l%3!<%I$r:o=|$9$kA0$K%4!<%k$r<u$1<h$C$?>l9g$,9M$($i$l$k!#(B
		  *>
	    s_UnlockFPRecord(A_PtrToFPRecord, A_FPOrgLockTagReg);
	    @DEBUG{
	      WARNING("f_FPTerminateWithUnlockFP_Sub",
		      "called when ChildCount!=0 & FP status is NOT ABORTED.");
	    };
	  }
	}
 $B%A%c%$%k%I%+%&%s%H%N%s%<%m$N;~$N%3!<%I(B */
    }
 End:
  $RELEASE(D_WorkFPSuspendedMessage);

  $RELEASE(D_WorkFPResourceConsumeUpper);
  $RELEASE(D_WorkFPResourceConsumeLower);
  $RELEASE(D_WorkFPResourceUpper);
  $RELEASE(D_WorkFPResourceLower);
  
  $RETURN();
}

#SUBARG_define	A_PtrToFPRecord		MODIFY /* $BMW3NG'(B */
#SUBARG_define  A_FPOrgLockTagReg       SRC

/************<<  only for aborted status  >>***************/ 

/* $BN$?F%l%3!<%I$N%m%C%/$O8F$S$@$7B&$G9T$J$&(B */
/* $B%"%s%m%C%/$OK\%^%/%mCf$G9T$J$&(B */

#SUBROUTINE  f_FPTerminateWithUnlockFPWithoutReclaimFP_Sub(A_PtrToFPRecord,
					       A_FPOrgLockTagReg){

  $USE(D_WorkFPResourceLower);
  $USE(D_WorkFPResourceUpper);

  s_GetFPResourceLeft(A_PtrToFPRecord, 
		      D_WorkFPResourceUpper,D_WorkFPResourceLower);
  /* $BJV5Q$9$k;q8;$rF@$k(B */
  $USE(D_WorkFPResourceConsumeLower);
  $USE(D_WorkFPResourceConsumeUpper);
  s_GetFPResourceConsumedWithUpdate(A_PtrToFPRecord,
				    D_WorkFPResourceConsumeUpper,
				    D_WorkFPResourceConsumeLower);
  /* $B>CHq$7$?;q8;NL$rF@$k(B */
  
  
  s_PutFPTransitStatusImm(A_PtrToFPRecord, _FP_ABORTED_TERMINATE);
  s_UnlockFPRecord(A_PtrToFPRecord,A_FPOrgLockTagReg);

  /* $B9uM"F~I=%(%s%H%j$N%m%C%/A`:n(B */
  /* $B$H$N6%9g$rHr$1$k$?$a!"N$?F(B */
  /* $B%l%3!<%I$N%m%C%/$r30$9!#(B */

  s_IfProfilingFP(A_PtrToFPRecord){
    f_FPExportProfilingDataFPTerminate(A_PtrToFPRecord);
    s_FPReclaimProfilingHashTab(A_PtrToFPRecord);
  }
  
  $CALL(f_Send_IntClMsg_Terminated_Sub(
				       A_PtrToFPRecord,
				       D_WorkFPResourceUpper, 
				       D_WorkFPResourceLower, 
				       D_WorkFPResourceConsumeUpper, 
				       D_WorkFPResourceConsumeLower
				       ));

					                   
  /*  $B0lHL$K!"(BAbort$B;~$K$ON$?F$O%4!<%k$r;}$C$F$$$k$N$G!"N$?F%l%3!<%I$N2s<}(B
    $B$O$3$3$G$O9T$J$o$J$$!#(B
        */

  $RELEASE(D_WorkFPResourceLower);
  $RELEASE(D_WorkFPResourceUpper);
  $RELEASE(D_WorkFPResourceConsumeLower);
  $RELEASE(D_WorkFPResourceConsumeUpper);

  $RETURN();
}

/******************************************************************** PSL **

SelfIntHandler_Sub$B$+$i8F$P$l$k(B (f_event_handler.psl.c)

  f_RetryGatherFPResource()

       written by pim@icot21      on Tue Feb  6 21:07:37 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B$H$j$"$($:#V#0#2$N$^$^(B */
#DATA_define  D_WorkFPInnerEventReg     XXX
#DATA_define  D_WorkFPRecFromInnerEvent XXX

#PSL_define  f_RetryGatherFPResource()
{
  $USE(D_WorkFPInnerEventReg);
  $USE(D_WorkFPRecFromInnerEvent);

  b_PopInnerEventStack(D_WorkFPInnerEventReg);
  b_MoveWithImmTypeMRBoff(D_WorkFPInnerEventReg,
			  FPREC,
			  D_WorkFPRecFromInnerEvent);

  @DEBUG{
    _PrintFPInfo(D_WorkFPRecFromInnerEvent);
    WARNING("f_RetryGatherFPResource","Retry Resource Decache Again");
  };

  b_IfEmptyInnerEventStack()
    { /* Self-Int$B%9%?%C%/$,6u$J$i$P(B                   */
      /* $B!J$5$C$-<h$j=P$7$?%$%Y%s%H$,:G8e$N%$%Y%s%H!K(B */
      b_ResetEventFlag(_FP_STAT_GATHER_EVENT, D_PE_Number);
    }


  TypeSwitch(D_WorkFPInnerEventReg)
    { /* $B%"%\!<%H$@$C$?$i(B */
      case _FP_IN_EVT_ABORTED :
	$CALL(f_SyncroDecacheResourceForAbort_Sub(D_WorkFPRecFromInnerEvent));
	break;
      /* _ASK_STATISTICS$B$@$C$?$i(B */
      case _FP_IN_EVT_ASK_STAT :
	$CALL(f_SyncroDecacheResourceForAskStat_Sub(
						  D_WorkFPRecFromInnerEvent));
	break;
      /* _ANSWER_STATISTICS$B$@$C$?$i(B */
      case _FP_IN_EVT_ANS_STAT :
	$CALL(f_SyncroDecacheResourceForAnswerStat_Sub(
						  D_WorkFPRecFromInnerEvent));
	break;
      /* $B>e5-0J30$@$C$?$i(B */
      default :
	@DEBUG{
	  VPIM_ERROR("f_RetryGatherFPResource",
		                      "Illegal Self-Int Information Type");
	};
      }

  f_DecrementChildCountAndTerminateFPIfNoChild(D_WorkFPRecFromInnerEvent);
/* Syncro $B$K<:GT$7$F!"(BSelf-Int $B$H$7$F=hM}$r@hAw$j$K$7$?;~(B */
/* child_count $B$,#1A}$d$7$F$"$k(B */
/* $B;2>H%+%&%s%H$N0UL#$G!":G8e$K8:$i$9(B */
/* StatGatherEventCount $B$N%G%/%j%a%s%H$b$3$NCf$G9T$J$C$F$$$k(B */

  $RELEASE(D_WorkFPRecFromInnerEvent);
  $RELEASE(D_WorkFPInnerEventReg);
}

/******************************************************************** PSL **

  f_SyncroDecacheResourceForAbort_Sub(A_PtrToFPRecord)

       written by pim@icot21      on Tue Feb  6 20:31:24 1990
<Arguments>
  A_PtrToFPRecord : 
<Temporally Used Variables>
  D_WorkBCMsgReg : 
  D_WorkBCStatusReg :
  D_Work_FP_Child_Link_Reg : 
  D_WorkImpRecAddr : 
  D_WorkShoenID :
  D_WorkHashEntryPtr :
  D_WorkHashEntry : 
  D_WorkResource : 
  D_WorkResourceConsumed : 
  D_WorkWTC : 
  D_WorkCLNum : 
<Level>
  functions
<PreCondition>
  $B8F$S$@$785$G$O!"(B
    $B!&N$?F%l%3!<%IK\BN(B
    $B!&N$?F$N;RAq1`%j%s%/(B
  $B$N$I$A$i$K$b%m%C%/$r3]$1$J$$$3$H!#(B
<Function>
  $B%"%\!<%H;~$K%/%i%9%?Fb$N3F(BPE$B$K%-%c%C%7%e$5$l$F$$$k;q8;$rN$?F%l%3!<%I$K=q$-La(B
$B$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define  D_WorkBCMsgReg       XXX
#DATA_define  D_WorkBCStatusReg    XXX

#SUBARG_define	A_PtrToFPRecord		MODIFY /* $BMW3NG'(B */

#SUBROUTINE  f_SyncroDecacheResourceForAbort_Sub(A_PtrToFPRecord)
{
  @DEBUG{
    _PrintFPInfo(A_PtrToFPRecord);
    WARNING("f_SyncroDecacheResourceForAbort_Sub","Decache when Abort");
  };

  $USE(D_WorkBCMsgReg);
  $USE(D_WorkBCStatusReg);
  b_MoveWithImmTypeMRBoff(A_PtrToFPRecord, _FP_IN_EVT_ABORTED, D_WorkBCMsgReg);
  b_SignalOthersAndSetMsgCommArea(D_WorkBCMsgReg, D_WorkBCStatusReg);
  b_IfWordEq(D_WorkBCStatusReg,D_NULL)
    { /* $BB>$N(BPE$B$KDLCN$G$-$?$i(B */
      /* $BB>$N(BPE$B$,%-%c%C%7%e$7$F$$$k;q8;$r=q$-La$7$FLc$&$N$rBT$D(B */
      b_BusyWaitUntilOthersNoticeBarrier();
      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
      b_IfEqual(A_PtrToFPRecord, D_Current_FP_Ptr)
	{ /* $B<+(BPE$B$G$b%+%l%s%HN$?F$,%"%\!<%HBP>]N$?F$@$C$?$i(B */
	  f_DecacheFPResourceCount(A_PtrToFPRecord);   /* $B<+J,$b=q$-La$9(B */

	  /* ResourceCache $B$r%/%j%"$7$?$N$G%j%9%1%8%e!<%kMW5a$r=P$7$F$*$/(B */
	  /* $B"*N$?F%m%C%/4|4V$N30$K=P$7$?(B */
	}
      b_ClearMsgAndResetBarrier();
      b_IncrementSyncroCountX();

      $USE(D_Work_FP_Child_Link_Reg);
      s_GetFPRightChildShoenLink(A_PtrToFPRecord, D_Work_FP_Child_Link_Reg);
      b_IfEqual(A_PtrToFPRecord, D_Work_FP_Child_Link_Reg)
	{  /*  $B$b$7;RAq1`$,$$$J$1$l$P(B  */
	  $RELEASE(D_Work_FP_Child_Link_Reg);

/* $B!v!v!vCm0U!v!v!v(B
   $B$3$3(B(f_SyncroDecacheResourceForAbort_Sub)$B$G$O!"<+J,<+?H$N=hM}$N$?$a$K(B
   $B%$%Y%s%H%+%&%s%H$,#1%W%i%9$5$l$F$$$k$N$G!"(Bs_IfJustOneStatGatherEvent$B$r(B
   $B;H$C$F$$$k!#(Bf_CheckFPTermination$B$G$O!"$=$N$h$&$K$J$C$F$$$J$$$N$G!"(B
   s_IfNoStatGatherEvent $B$r;H$C$F$$$k(B
 */
/* $BF1MM$K!"%A%c%$%k%I%+%&%s%H$b%<%m$G$J$$$3$H$,J]>Z$5$l$F$$$k(B */
	  s_IfJustOneStatGatherEvent(A_PtrToFPRecord){
	    $CALL( f_FPTerminateWithUnlockFPWithoutReclaimFP_Sub(
	       A_PtrToFPRecord,D_WorkFPOrgLockTagReg));
	    /* ReclaimFP $BL5$7$N(B abort $B;~@lMQ$N%^%/%m$r8F$V(B */
	    /* $BN$?F$N%"%s%m%C%/$b$3$NCf$G$d$k(B */
	    $RELEASE(D_WorkFPOrgLockTagReg);
	  }else{
	    /* $BB>$N@hAw$j=hM}!?<B9TCf=hM}$,$"$k;~$O%?!<%_%M%$%H$7$J$$(B */
	    s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	    $RELEASE(D_WorkFPOrgLockTagReg);
	  }
	}
      else
	{  /*  $B$b$7;RAq1`$,$$$l$P(B  */
	  $RELEASE(D_Work_FP_Child_Link_Reg);
	  s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);
	  s_LockFPChildShoenLink(A_PtrToFPRecord,
		        D_WorkFPChildShoenLinkOrgLockTagReg);
	  f_AbortAllChildShoen(A_PtrToFPRecord);
	  s_UnlockFPChildShoenLink(A_PtrToFPRecord,
			D_WorkFPChildShoenLinkOrgLockTagReg);
	  $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);
	}

      b_IfZero(D_ResourceCache){/* $BN$?F%m%C%/4|4V$N30$K=P$7$?!#(B*/
	f_IfNotEmptyCGP(D_ArgReg0) { 
	  f_PushGoalToStack(D_ArgReg0);
	  f_MakeEmptyCGP(D_ArgReg0); /* force re-schedule */
	}
      }
    }
  else
    { /* $BB>$N(BPE$B$KDLCN$G$-$J$+$C$?$i(B */
      /* Self-Int$B$K$7$F!"<!$N%9%j%C%H%A%'%C%/$N;~$K:F<B9T$9$k(B */
      b_PushInnerEventStack(D_WorkBCMsgReg);
      b_SetEventFlag(_FP_STAT_GATHER_EVENT, D_PE_Number);

      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord(A_PtrToFPRecord,D_WorkFPOrgLockTagReg);
      s_IncrementFPStatGatherEventCount(A_PtrToFPRecord);
      s_IncrementFPChildCount(A_PtrToFPRecord);
      s_UnlockFPRecord(A_PtrToFPRecord,D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      /* Self-Int$B<u?.=hM}$^$GN$?F$,L5$/$J$i$J$$MM$K%+%&%s%H$rA}$d$7$FCV$/(B */
    }
  $RELEASE(D_WorkBCStatusReg);
  $RELEASE(D_WorkBCMsgReg);

  $RETURN();
}

/******************************************************************** PSL **

  f_SyncroDecacheResourceForAskStat_Sub(A_PtrToFPRecord)

       written by kawai@icot21      on Wed Feb  7 12:01:03 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  $B8F$S=P$785$G$O!"(B
    $B!&N$?F%l%3!<%IK\BN(B
    $B!&N$?F$N;RAq1`%j%s%/(B
  $B$N$I$A$i$K$b%m%C%/$r3]$1$J$$$3$H!#(B
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkFPResourceConsumeLowerAskStat XXX
#DATA_define D_WorkFPResourceConsumeUpperAskStat XXX

#SUBARG_define	A_PtrToFPRecord		MODIFY /* $BMW3NG'(B */

#SUBROUTINE  f_SyncroDecacheResourceForAskStat_Sub(A_PtrToFPRecord)
{
  @DEBUG{
    _PrintFPInfo(A_PtrToFPRecord);
    WARNING("f_SyncroDecacheResourceForAskStat_Sub","Decache when AskStat");
  };

  $USE(D_Work_FP_Child_Link_Reg);
  $USE(D_WorkFPChildShoenLinkOrgLockTagReg);
  s_LockFPChildShoenLink(A_PtrToFPRecord,D_WorkFPChildShoenLinkOrgLockTagReg);
  s_GetFPRightChildShoenLink(A_PtrToFPRecord, D_Work_FP_Child_Link_Reg);
  b_IfEqual(D_Work_FP_Child_Link_Reg, A_PtrToFPRecord)
    {  /*  $B;RAq1`$,$J$+$C$?$i(B  */
      $RELEASE(D_Work_FP_Child_Link_Reg);
      s_UnlockFPChildShoenLink(A_PtrToFPRecord,
				D_WorkFPChildShoenLinkOrgLockTagReg);
      $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);
      $USE(D_WorkBCMsgReg);
      $USE(D_WorkBCStatusReg);
      b_MoveWithImmTypeMRBoff(A_PtrToFPRecord,
			      _FP_IN_EVT_ASK_STAT,
			      D_WorkBCMsgReg);
      b_SignalOthersAndSetMsgCommArea(D_WorkBCMsgReg, D_WorkBCStatusReg);
      b_IfWordEq(D_WorkBCStatusReg,D_NULL)
	{ /* $BF14|8"$rF@$?$i(B */

	  /* $BB>$N(BPE$B$KDLCN$7(B */
	  /* $BB>$N(BPE$B$,%-%c%C%7%e$7$F$$$k;q8;$r=q$-La$7$FLc$&$N$rBT$D(B */
	  b_BusyWaitUntilOthersNoticeBarrier();
	  $USE(D_WorkFPOrgLockTagReg);
	  s_LockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	  b_IfEqual(A_PtrToFPRecord, D_Current_FP_Ptr)
	    { /* $B<+(BPE$B$G$b%+%l%s%HN$?F$,7WB,BP>]N$?F$@$C$?$i(B */
	      f_DecacheFPResourceCount(A_PtrToFPRecord);   /* $B<+J,$b=q$-La$9(B */

	      /* ResourceCache$B$r%/%j%"$7$?$N$G%j%9%1%8%e!<%kMW5a$r=P$7$F$*$/(B */
	      /* $B"*N$?F%m%C%/4|4V$N30$K=P$7$?(B */
	    }
	  $USE(D_WorkFPResourceConsumeUpperAskStat);
	  $USE(D_WorkFPResourceConsumeLowerAskStat);
	  s_GetFPResourceConsumedWithUpdate(A_PtrToFPRecord,
				    D_WorkFPResourceConsumeUpperAskStat,
				    D_WorkFPResourceConsumeLowerAskStat);


	  s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);

	  /* $BB>$N(BPE$B$O%G%-%c%C%7%e$,=*$C$?$i%S%8!<%&%'%$%H$7$FBT$C$F$k$N$G(B */
	  /* $B$3$l$r5/$3$9(B */
	  /* $BF14|8"$N2rJ|(B */
	  b_ClearMsgAndResetBarrier();
	  b_IncrementSyncroCountX();

	  b_IfZero(D_ResourceCache){/* $BN$?F%m%C%/4|4V$N30$K=P$7$?!#(B*/
	    f_IfNotEmptyCGP(D_ArgReg0) { 
	      f_PushGoalToStack(D_ArgReg0);
	      f_MakeEmptyCGP(D_ArgReg0); /* force re-schedule */
	    }
	  }

	  /*  AnswerStatistics $B$r?FAq1`$KJV$9(B  */

	  $CALL(f_Send_IntClMsg_Answer_Statistics_Sub(A_PtrToFPRecord,
				       D_WorkFPResourceConsumeUpperAskStat,
				       D_WorkFPResourceConsumeLowerAskStat
					       ));
	  $RELEASE(D_WorkFPResourceConsumeUpperAskStat);
	  $RELEASE(D_WorkFPResourceConsumeLowerAskStat);
	}
      else
	{ /* $BF14|8"$,F@$i$l$J$+$C$?$i(B */

	  /* Self-Int$B$K$7$F!"<!$N%9%j%C%H%A%'%C%/$N;~$K:F<B9T$9$k(B */
	  b_PushInnerEventStack(D_WorkBCMsgReg);
	  b_SetEventFlag(_FP_STAT_GATHER_EVENT, D_PE_Number);

	  $USE(D_WorkFPOrgLockTagReg);
	  s_LockFPRecord(A_PtrToFPRecord,D_WorkFPOrgLockTagReg);
	  s_IncrementFPStatGatherEventCount(A_PtrToFPRecord);
	  s_IncrementFPChildCount(A_PtrToFPRecord);
	  s_UnlockFPRecord(A_PtrToFPRecord,D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
      /* Self-Int$B<u?.=hM}$^$GN$?F$,L5$/$J$i$J$$MM$K%+%&%s%H$rA}$d$7$FCV$/(B */
	}
      $RELEASE(D_WorkBCStatusReg);
      $RELEASE(D_WorkBCMsgReg);
    }
  else
    { /* $B;RAq1`$,$"$C$?$i(B */
      $RELEASE(D_Work_FP_Child_Link_Reg);
      f_AskStatisticsAllChildShoenWithUnlockChildShoenLink(A_PtrToFPRecord,
				D_WorkFPChildShoenLinkOrgLockTagReg);
      /* $B$3$NCf$G;RAq1`%j%s%/$N%"%s%m%C%/$r9T$J$&(B */
      $RELEASE(D_WorkFPChildShoenLinkOrgLockTagReg);
    }


  $RETURN();
}

/******************************************************************** PSL **

  f_SyncroDecacheResourceForAnswerStat_Sub(A_PtrToFPRecord)

       written by pim@icot21      on Tue Feb  6 21:29:21 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkFPResourceConsumeLowerAnsStat XXX
#DATA_define D_WorkFPResourceConsumeUpperAnsStat XXX

#DATA_define  D_WorkFPTotalResourceConsumeLower   XXX
#DATA_define  D_WorkFPTotalResourceConsumeUpper   XXX

#SUBARG_define	A_PtrToFPRecord		MODIFY /* $BMW3NG'(B */

#SUBROUTINE  f_SyncroDecacheResourceForAnswerStat_Sub(A_PtrToFPRecord)
{
  @DEBUG{
    _PrintFPInfo(A_PtrToFPRecord);
    WARNING("f_SyncroDecacheResourceForAnswerStat_Sub","Decache when AnsStat");
  };

  $USE(D_WorkBCMsgReg);
  $USE(D_WorkBCStatusReg);
  b_MoveWithImmTypeMRBoff(A_PtrToFPRecord, 
					_FP_IN_EVT_ANS_STAT, D_WorkBCMsgReg);
  b_SignalOthersAndSetMsgCommArea(D_WorkBCMsgReg, D_WorkBCStatusReg);
  b_IfWordEq(D_WorkBCStatusReg,D_NULL)
    { /* $BB>$N(BPE$B$KDLCN$G$-$?$i(B */
      /* $BB>$N(BPE$B$,%-%c%C%7%e$7$F$$$k;q8;$r=q$-La$7$FLc$&$N$rBT$D(B */
      b_BusyWaitUntilOthersNoticeBarrier();
      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
      b_IfEqual(A_PtrToFPRecord, D_Current_FP_Ptr)
	{ /* $B<+(BPE$B$G$b%+%l%s%HN$?F$,;q8;>CHqJs9pBP>]N$?F$@$C$?$i(B */
	  f_DecacheFPResourceCount(A_PtrToFPRecord);   /* $B<+J,$b=q$-La$9(B */

	  /* ResourceCache $B$r%/%j%"$7$?$N$G%j%9%1%8%e!<%kMW5a$r=P$7$F$*$/(B */
	  /* $B"*N$?F%m%C%/4|4V$N30$K=P$7$?(B */
	}

      $USE(D_WorkFPTotalResourceConsumeLower);
      $USE(D_WorkFPTotalResourceConsumeUpper);
      s_GetFPAnswerResource(A_PtrToFPRecord,
			    D_WorkFPTotalResourceConsumeUpper,
			    D_WorkFPTotalResourceConsumeLower);
      s_PutFPAnswerResource(A_PtrToFPRecord,D_NULL,D_NULL);

      $USE(D_WorkFPResourceConsumeLowerAnsStat);
      $USE(D_WorkFPResourceConsumeUpperAnsStat);
      s_GetFPResourceConsumedWithUpdate(A_PtrToFPRecord,
					D_WorkFPResourceConsumeUpperAnsStat,
					D_WorkFPResourceConsumeLowerAnsStat);


      s_UnlockFPRecord(A_PtrToFPRecord, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);

      b_ClearMsgAndResetBarrier();
      b_IncrementSyncroCountX();

      b_AddDoubleWord(
       D_WorkFPTotalResourceConsumeUpper,D_WorkFPTotalResourceConsumeLower, 
       D_WorkFPResourceConsumeUpperAnsStat,D_WorkFPResourceConsumeLowerAnsStat,
       D_WorkFPTotalResourceConsumeUpper,D_WorkFPTotalResourceConsumeLower);
	    /* $BMW%*!<%P!<%U%m!<BP:v(B ? */
      $RELEASE(D_WorkFPResourceConsumeLowerAnsStat);
      $RELEASE(D_WorkFPResourceConsumeUpperAnsStat);

      b_IfZero(D_ResourceCache){/* $BN$?F%m%C%/4|4V$N30$K=P$7$?!#(B*/
	f_IfNotEmptyCGP(D_ArgReg0) { 
	  f_PushGoalToStack(D_ArgReg0);
	  f_MakeEmptyCGP(D_ArgReg0); /* force re-schedule */
	}
      }

      /*  AnswerStatistics $B$r?FAq1`$KJV$9(B  */

      $CALL(f_Send_IntClMsg_Answer_Statistics_Sub(A_PtrToFPRecord,
					   D_WorkFPTotalResourceConsumeUpper,
					   D_WorkFPTotalResourceConsumeLower
					   ));
      $RELEASE(D_WorkFPTotalResourceConsumeLower);
      $RELEASE(D_WorkFPTotalResourceConsumeUpper);
    }
  else
    { /* $BB>$N(BPE$B$KDLCN$G$-$J$+$C$?$i(B */
      /* Self-Int$B$K$7$F!"<!$N%9%j%C%H%A%'%C%/$N;~$K:F<B9T$9$k(B */
      b_PushInnerEventStack(D_WorkBCMsgReg);
      b_SetEventFlag(_FP_STAT_GATHER_EVENT, D_PE_Number);

      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord(A_PtrToFPRecord,D_WorkFPOrgLockTagReg);
      s_IncrementFPStatGatherEventCount(A_PtrToFPRecord);
      s_IncrementFPChildCount(A_PtrToFPRecord);
      s_UnlockFPRecord(A_PtrToFPRecord,D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      /* Self-Int$B<u?.=hM}$^$GN$?F$,L5$/$J$i$J$$MM$K%+%&%s%H$rA}$d$7$FCV$/(B */
    }
  $RELEASE(D_WorkBCStatusReg);
  $RELEASE(D_WorkBCMsgReg);

  $RETURN();
}

/******************************************************************** PSL **

  f_FPStatusCheckHandler_Sub()

       written by kawai@icot22      on Thu Mar  1 22:02:05 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $BN$?F$N>uBVJQ2=$N%9%j%C%H%A%'%C%/%U%i%0$,>e$,$C$?;~$K!"%+%l%s%H$NN$?F$N>uBV$r(B
$B%A%'%C%/$9$k!#%+%l%s%HN$?F$,<B9TIT2DG=$K$J$C$?$N$J$i%j%9%1%8%e!<%k$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBROUTINE  f_FPStatusCheckHandler_Sub()
{
  @DEBUG{
    WARNING("f_FPStatusCheckHandler_Sub","FP Status Changed");
  };

  b_ResetEventFlag(_FP_STATUS_CHECK_EVENT, D_PE_Number);
  f_IfNotEmptyCGP(D_ArgReg0)
    { /* $B<B9T$7$F$$$?%4!<%k$,%"%$%I%k%4!<%k$G$J$+$C$?$i(B */
      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
      s_IfNotRunnableFP(D_Current_FP_Ptr)
	{ /* $B%+%l%s%HN$?F$,<B9TIT2DG=>uBV$K$J$C$F$$$?$i(B */
	  @DEBUG{
	    _PrintFPInfo(D_Current_FP_Ptr);
	    WARNING("f_FPStatusCheckHandler_Sub","Current FP Not Runnable");
	  };
	  f_DecacheFPResourceCount(D_Current_FP_Ptr);
	  s_UnlockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	  f_IfNotEmptyCGP(D_ArgReg0) { 
	    f_PushGoalToStack(D_ArgReg0);
	    f_MakeEmptyCGP(D_ArgReg0); /* force re-schedule */
	  }
	}
      else
	{ /* $B%+%l%s%HN$?F$,<B9TIT2DG=>uBV$G$J$+$C$?$i(B */
	  s_UnlockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	}

    }
  $RETURN();
}

/******************************************************************** PSL **

  f_DecacheFPResourceHandler_Sub()

       written by pim@icot21      on Tue Feb  6 21:40:23 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B$H$j$"$($:#V#0#2$N$^$^(B */
#DATA_define  D_WorkTargetFPReg        XXX
#DATA_define  D_WorkFPRecFromCommArea  XXX

#SUBROUTINE  f_DecacheFPResourceHandler_Sub()
{
  $USE(D_WorkTargetFPReg);
  b_ReadCommArea(_ONE_TO_ALL_MSG_OFST, D_WorkTargetFPReg);

  @DEBUG{
    $USE(D_WorkFPRecFromCommArea);
    b_MoveWithImmTypeMRBoff(D_WorkTargetFPReg,
			    FPREC,
			    D_WorkFPRecFromCommArea);
    _PrintFPInfo(D_WorkFPRecFromCommArea);
    WARNING("f_DecacheFPResourceHandler_Sub",
	    "Other PE request Decache Resource");
    $RELEASE(D_WorkFPRecFromCommArea);
  };

  b_IfEqual(D_WorkTargetFPReg, D_Current_FP_Ptr)  /* $B%P%j%e!<It$N$_$NHf3S(B */
    { /* $B%+%l%s%H$NN$?F$,;q8;=87WBP>]$NN$?F$J$i$P(B */

/*    @DEBUG{WARNING("f_DecacheFPResourceHandler_Sub","Decache Current FP");};
 */
      $USE(D_WorkFPOrgLockTagReg);
      s_LockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
      f_DecacheFPResourceCount(D_Current_FP_Ptr);
      s_UnlockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);

      /* Decache $B$7$?$N$G(B */
      /* CGP$B$r6u$K$7$F!"<!%4!<%k$N%9%1%8%e!<%k;~$K(B cache $B$7$?$j!"(B
	$BN$?F$N>uBV$r%A%'%C%/(B
	$B$9$k$h$&$K$9$k!#(B   
      */
      f_IfNotEmptyCGP(D_ArgReg0) { 
	f_PushGoalToStack(D_ArgReg0);
	f_MakeEmptyCGP(D_ArgReg0); /* force re-schedule */
      }

      $USE(D_WorkOldCounter);
      b_ReadCommArea(_ONE_TO_ALL_COUNTER_OFST, D_WorkOldCounter);
      b_DecrementBarrierCountX();
      TypeSwitch(D_WorkTargetFPReg)
	{ /* _ABORTED$B$@$C$?$i(B */
	  case _FP_IN_EVT_ABORTED :
	    break;
          /* _ASK_STATISTICS$B$"$k$$$O(B_ANSWER_STATISTICS$B$@$C$?$i(B */
	  case _FP_IN_EVT_ASK_STAT :
	  case _FP_IN_EVT_ANS_STAT :

	    b_WaitSyncroCount(D_WorkOldCounter);

	    break;
	  /* $B$=$l0J30$@$C$?$i(B */
	  default :
	    @DEBUG{
	      VPIM_ERROR("f_DecacheFPResourceHandler_Sub",
		    	           "Illegal Information for DecacheHandler");
	    };
	  }
      $RELEASE(D_WorkOldCounter);
    }
  else
    { /* $B%+%l%s%H$NN$?F$,;q8;=87WBP>]$NN$?F$G$J$1$l$P(B */
      $USE(D_WorkOldCounter);
      b_ReadCommArea(_ONE_TO_ALL_COUNTER_OFST, D_WorkOldCounter);
      b_DecrementBarrierCountX();

      TypeSwitch(D_WorkTargetFPReg)
	{ /* _ABORTED$B$@$C$?$i(B */
	  case _FP_IN_EVT_ABORTED :
            /* Abort$B$N>l9g$O!"B>$N(BPE$B$G%j%@%/%7%g%s$r9T$C$F$b(BAbort$B$5$l$?(B
               $BN$?F$N>CHq;q8;NL$K1F6A$rM?$($J$$$?$a!"%S%8!<%&%'%$%H$7$F(B
               $BBT$DI,MW$O$J$$!#(B
                 $B"*(B $B$?$@$7!"%3!<%INL:o8:$N4QE@$+$i$O!"(BAbort$B$H>CHq;q8;Ld$$(B
                    $B9g$o$;$rF1$8$K07$C$?J}$,NI$$$+$bCN$l$J$$!#(B
                                                         '90.10.23 by $B@n9g(B
            */
	    break;
          /* _ASK_STATISTICS$B$"$k$$$O(B_ANSWER_STATISTICS$B$@$C$?$i(B */
	  case _FP_IN_EVT_ASK_STAT :
	  case _FP_IN_EVT_ANS_STAT :

	      b_WaitSyncroCount(D_WorkOldCounter);

	    /* $B%+%l%s%H$NN$?F$,;q8;=87WBP>]$NN$?F$G$"$k$+H]$+$K$+$+$o$i$:!"(B
	       $B%S%8!<%&%'%$%H$7$F;q8;=87WBP>]$NN$?F$N>CHq;q8;NL$,3NDj$9$k$N(B
               $B$rBT$D!#(B
		 $B"+(B $B%/%i%9%?Fb$NB>$N(BPE$B$G%j%@%/%7%g%s$,$G$-$F$7$^$&$H!";q8;(B
                    $B=87WBP>]$NN$?F$N>CHq;q8;NL$,3NDj$9$kA0$K!"$=$NN$?F$+$i(B
		    $B;q8;$r%-%c%C%7%e$7$F$7$^$&2DG=@-$,$"$k$?$a!#(B
  	              $BN$?F$N>uBV$H$7$F!"!V>CHq;q8;NLD4::Cf!W$H$$$&>uBV$r@_(B
                    $B$1$F!"$3$N>uBV$r(B not_runnable $B$H$9$k<j$b$"$k$,!"N$?F$N(B
                    $BGSB>@)8f%3%9%H$r9M$($k$H!"$"$^$jM-Mx$H$b8@$($J$$!#(B
                                                         '90.10.23 by $B@n9g(B
 	    */
	    break;
	  /* $B$=$l0J30$@$C$?$i(B */
	  default :
	    @DEBUG{
	      VPIM_ERROR("f_DecacheFPResourceHandler_Sub",
		    	           "Illegal Information for DecacheHandler");
	    };
	  }
      $RELEASE(D_WorkOldCounter);
    }
  $RELEASE(D_WorkTargetFPReg);

  $RETURN();
}

/******************************************************************** PSL **

  f_HookFPStoppedGoalWithoutLock(fp_record, goal_record)

       written by kawai@icot21      on Mon Oct 30 21:03:52 1989

<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  goal_record : $B%4!<%k%l%3!<%I$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  functions
<PreCondition>
  $BN$?F%l%3!<%I$O8F$S$@$785$G%m%C%/$7$F$*$/$3$H!#(B
<Function>
  ($BN$?F$,<B9T2DG=>uBV$G$J$$;~$J$I$K(B)$B%4!<%k%l%3!<%I$rN$?F%l%3!<%I$K$D$J$0!#(B
  ($BN$?F%l%3!<%I$N%=%U%H%m%C%/$J$7(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_HookFPStoppedGoalWithoutLock(fp_record, goal_record)
{
  b_PushLinkWithOffsetX(goal_record, fp_record, 
                          _FP_STOPPED_GOALS_OFFSET,  _NEXT_PTR_OFST_GR);
}


/******************************************************************** PSL **

  f_UnhookFPStoppedGoal(fp_record, goal_record)

       written by kawai@icot21      on Thu Feb  9 21:57:31 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
  goal_record : $B$O$:$5$l$?%4!<%k%l%3!<%I$rJV$9%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Stopped_Goals : $BN$?F%l%3!<%I$+$i(BStopped$B%4!<%k%l%3!<%I$X$N%]%$%s%?$r(B
                            $B0l;~J];}$9$k%l%8%9%?!#(B
<Level>
  functions
<PreCondition>
  $BN$?F%l%3!<%I$O8F$S$@$785$G%=%U%H%m%C%/$7$F$$$k$3$H!#(B
<Function>
  $BN$?F%l%3!<%I$N(BStoppedGoals$B$+$i!"%4!<%k%l%3!<%I$r0l$D$O$:$9!#(B($BGSB>@)8f$J$7(B)
  StoppedGoals$B$,6u$N$H$-$K$O(BEOL$B$,JV$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define   D_Work_FP_Stopped_Goals         XXX

#PSL_define  f_UnhookFPStoppedGoal(fp_record, goal_record)
{
  @DEBUG{
    WARNING("f_UnhookFPStoppedGoal","Stopped Goal will be unhooked from FP");
  };

  $USE(D_Work_FP_Stopped_Goals);
  s_GetFPStoppedGoals(fp_record, D_Work_FP_Stopped_Goals);
  b_IfEOL(D_Work_FP_Stopped_Goals){
    p_MoveWord(D_Work_FP_Stopped_Goals, goal_record);
  }else{ 
    b_PopLinkWithOffsetX(goal_record, fp_record,
                         _FP_STOPPED_GOALS_OFFSET, _NEXT_PTR_OFST_GR);
  }
  $RELEASE(D_Work_FP_Stopped_Goals);
}

/******************************************************************** PSL **
$B%5%9%Z%s%I$9$k%a%C%;!<%8$rN$?F$K(B push $B$9$k(B

f_PushSuspendedMsgToFP

       written by ttakagi@icot22      on Mon Mar  4 12:33:14 1991

<Arguments>
 fp_ptr:      $BN$?F$X$N%]%$%s%?(B
 sus_msg_rec: $B%a%C%;!<%8%5%9%Z%s%I%l%3!<%I$X$N%]%$%s%?(B

<PreCondition>
  $BN$?F$K$O%m%C%/$,$+$+$C$F$$$k$3$H(B

<ETC>
  $BN$?F<+BN$K%m%C%/$,$+$+$C$F$$$k$?$a!"%m%C%/$NI,MW$OL5$$(B.

********************************************************************* PSL **/

#DATA_define D_WorkSuspendedMsg XXX

#PSL_define f_PushSuspendedMsgToFP(fp_ptr, sus_msg_rec)
{
  $USE(D_WorkSuspendedMsg);
  s_GetFPSuspendedMessage(fp_ptr, D_WorkSuspendedMsg);
  s_PutChainMsgSusRec(sus_msg_rec, D_WorkSuspendedMsg);
  $RELEASE(D_WorkSuspendedMsg);
  s_PutFPSuspendedMessage(fp_ptr, sus_msg_rec);
}  

/******************************************************************** PSL **

  f_ResumeAllStoppedGoals_Sub(A_ResumeGoal)

       written by kawai@icot21      on Mon May 22 20:35:50 1989
<Arguments>
  A_Resume_Goal: Resume$B$9$k%4!<%k%l%3!<%I$r0l;~J];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_Resume_Goal_Priority : Resume$B$9$k%4!<%k$N%W%i%$%*%j%F%#$r0l;~J];}$9$k(B
                                $B%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $BN$?F%l%3!<%I$O8F$S$@$785$G%=%U%H%m%C%/$7$F$$$k$3$H!#(B
<Function>
  $BN$?F$,(BStopped$B>uBV$G$"$C$?$?$a$K<B9T$G$-$:$K$$$?A4$F$N%4!<%k$r!"%4!<%k%9%?%C%/(B
$B$K%W%C%7%e$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  Stop $B$7$F$$$?%4!<%k$,$"$k;~$N$_8F$S=P$9$h$&$KJQ99(B (1990.02.03 By Goto)

$BN$?F%l%3!<%I$X$N%]%$%s%?$rEO$9JQ$o$j$K!"(B
$BN$?F%l%3!<%I$+$i<h$j=P$7$?%9%H%C%W%I%4!<%kNs$rEO$9$3$H$K$7$?!#(B92-07-13 reki

********************************************************************* PSL **/

#DATA_define   D_WorkResumeGoal    XXX
#DATA_define   D_WorkResumeProcID  XXX

#SUBARG_define	A_Resume_Goal 	MODIFY

#SUBROUTINE  f_ResumeAllStoppedGoals_Sub(A_Resume_Goal)
{
  @DEBUG{
    WARNING("f_ResumeAllStoppedGoals_Sub","All Stopped Goals will be resumed");
  };

  $USE(D_WorkResumeGoal);
  $USE(D_WorkResumeProcID);
  LOOP(){
    b_IfEOL(A_Resume_Goal) {break;}
    p_MoveWord(A_Resume_Goal, D_WorkResumeGoal);
    s_GetNextGoalRecord(A_Resume_Goal, A_Resume_Goal);
    s_GetProcessorIdGoalRecord(D_WorkResumeGoal, D_WorkResumeProcID);
       	 /* $B<+J,$N%4!<%k$N>l9g(B */
    b_IfEqual(D_WorkResumeProcID, D_PE_Number)
      {
	f_SendGoalToMyself(D_WorkResumeGoal);
      }
    else
      {	/* $BB>?M$N%4!<%k$N>l9g(B */
	f_SendGoalToPE_in_cluster(D_WorkResumeGoal, D_WorkResumeProcID);
      }
	}
  $RELEASE(D_WorkResumeGoal);
  $RELEASE(D_WorkResumeProcID);
  $RETURN();
}


/******************************************************************** PSL **

  f_StartAllChildShoen(fp_record)

       written by kawai@icot21      on Mon May 22 20:18:42 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_Brother_Shoen : $BN$?F$N;RAq1`$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $BN$?F$N;RAq1`%j%s%/$KBP$7$F$O!"$3$N%^%/%m$N8F$S$@$785$G%m%C%/$,3]$+$C$F$$$k(B
$B$3$H!#(B
<Function>
  $BN$?F$NA4$F$N;RAq1`$KBP$7$F(Bstart_by_parent$B$r<B9T$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B$H$j$"$($:#V#0#2$N$^$^(B */
#DATA_define   D_Work_Brother_Shoen         XXX

#PSL_define  f_StartAllChildShoen(fp_record)
{
  @DEBUG{
    WARNING("f_StartAllChildShoen","All Child Shoen will be Started");
  };

  $USE(D_Work_Brother_Shoen);
  s_GetFPRightChildShoenLink(fp_record, D_Work_Brother_Shoen);
  LOOP(){
    b_IfEqual(D_Work_Brother_Shoen, fp_record) {break;}
    s_IfSHREC(D_Work_Brother_Shoen){
      s_IfNotShoenUnhookReserved(D_Work_Brother_Shoen)
	{ /* $BAq1`$,:o=|M=Dj$G$J$1$l$P(B */
	  $CALL(f_StartByParent_Sub(D_Work_Brother_Shoen));
	}
      s_GetRightBrotherShoenLink(D_Work_Brother_Shoen, D_Work_Brother_Shoen);
    }
    else
    { /* $BAq1`%l%3!<%I$G$bN$?F%l%3!<%I(B($B<+J,<+?H(B)$B$G$b$J$1$l$P(B */
      @DEBUG{ VPIM_ERROR("StartAllChildShoen", "Illegal FPChildLink"); };
      break;
    }
  }
  $RELEASE(D_Work_Brother_Shoen);
}

/******************************************************************** PSL **

  f_StopAllChildShoen(fp_record)

       written by kawai@icot21      on Mon May 22 20:18:42 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_Brother_Shoen : $BN$?F$N;RAq1`$r0l;~J];}$9$k%l%8%9%?(B
  D_Work_Resume_Goal : $BN$?F$N;RAq1`$r(Bstop$B>uBV$K$9$k$?$a$N(BD$B%3!<%I%4!<%k$r0l;~(B
                       $BJ];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $BN$?F$N;RAq1`%j%s%/$KBP$7$F$O!"$3$N%^%/%m$N8F$S$@$785$G%m%C%/$,3]$+$C$F$$$k(B
$B$3$H!#(B
<Function>
  $BN$?F$NA4$F$N;RAq1`$KBP$7$F(Bstop_by_parent$B$r<B9T$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B$H$j$"$($:#V#0#2$N$^$^(B */
#PSL_define  f_StopAllChildShoen(fp_record)
{
  @DEBUG{
    WARNING("f_StopAllChildShoen","All Child Shoen will be Stopped");
  };

  $USE(D_Work_Brother_Shoen);
  s_GetFPRightChildShoenLink(fp_record, D_Work_Brother_Shoen);
  LOOP(){
    b_IfEqual(D_Work_Brother_Shoen, fp_record) {break;}
    s_IfSHREC(D_Work_Brother_Shoen){
      s_IfNotShoenUnhookReserved(D_Work_Brother_Shoen)
	{ /* $BAq1`$,:o=|M=Dj$G$J$1$l$P(B */
	  $CALL(f_StopByParent_Sub(D_Work_Brother_Shoen));
	}
      s_GetRightBrotherShoenLink(D_Work_Brother_Shoen, D_Work_Brother_Shoen);
    }
    else
    { /* $BAq1`%l%3!<%I$G$bN$?F%l%3!<%I(B($B<+J,<+?H(B)$B$G$b$J$1$l$P(B */
      @DEBUG{ VPIM_ERROR("StopAllChildShoen", "Illegal FPChildLink"); };
      break;
    }
  }
  $RELEASE(D_Work_Brother_Shoen);
}

/******************************************************************** PSL **

  f_AbortAllChildShoen(fp_record)

       written by kawai@icot21      on Mon May 22 20:18:42 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_Brother_Shoen : $BN$?F$N;RAq1`$r0l;~J];}$9$k%l%8%9%?(B
  D_Work_Resume_Goal : $BN$?F$N;RAq1`$r(Babort$B>uBV$K$9$k$?$a$N(BD$B%3!<%I%4!<%k$r0l;~(B
                       $BJ];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $BN$?F$N;RAq1`%j%s%/$KBP$7$F$O!"$3$N%^%/%m$N8F$S$@$785$G%m%C%/$,3]$+$C$F$$$k(B
$B$3$H!#(B
<Function>
  $BN$?F$NA4$F$N;RAq1`$KBP$7$F(Babort_by_parent$B$r<B9T$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B$H$j$"$($:#V#0#2$N$^$^(B */
#PSL_define  f_AbortAllChildShoen(fp_record)
{
  @DEBUG{
    WARNING("f_AbortAllChildShoen","All Child Shoen will be Aborted");
  };

  $USE(D_Work_Brother_Shoen);
  s_GetFPRightChildShoenLink(fp_record, D_Work_Brother_Shoen);
  LOOP(){
    b_IfEqual(D_Work_Brother_Shoen, fp_record) {break;}
    s_IfSHREC(D_Work_Brother_Shoen){
      s_IfNotShoenUnhookReserved(D_Work_Brother_Shoen)
	{ /* $BAq1`$,2rJ|M=Dj$G$J$1$l$P(B */
	  $CALL(f_AbortByParent_Sub(D_Work_Brother_Shoen));
	}
      s_GetRightBrotherShoenLink(D_Work_Brother_Shoen, D_Work_Brother_Shoen);
    }
    else
    { /* $BAq1`%l%3!<%I$G$bN$?F%l%3!<%I(B($B<+J,<+?H(B)$B$G$b$J$1$l$P(B */
      @DEBUG{ VPIM_ERROR("AbortAllChildShoen", "Illegal FPChildLink"); };
      break;
    }
  }
  $RELEASE(D_Work_Brother_Shoen);
}

/******************************************************************** PSL **

  f_AskStatisticsAllChildShoen(fp_record)

       written by kawai@icot21      on Thu Nov 23 22:48:25 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_Brother_Shoen : $B;RAq1`%j%s%/$K$D$J$,$l$?Aq1`$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $B;RAq1`%j%s%/$KBP$7$F!"$3$N%^%/%m$N8F$S$@$785$G%m%C%/$,3]$+$C$F$$$k$3$H!#(B
<Function>
  $BN$?F$NA4$F$N;RAq1`$K;q8;NLD4::$r0MMj$9$k!#(B
  $BK\%^%/%m=hM}$N1dD9$G(B f_SyncroDecacheResourceForAnswerStat_Sub 
  $B$r8F$S=P$92DG=@-$,$"$k$?$a!"(B
  $B;RAq1`%j%s%/$N%"%s%m%C%/$OK\%^%/%mCf$G9T$J$&!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_AskStatisticsAllChildShoenWithUnlockChildShoenLink(fp_record,
                          fp_child_shoen_link_org_lock_tag_reg)
{
  @DEBUG{
    WARNING("f_AskStatisticsAllChildShoenWithUnlockChildShoenLink",
	    "Ask Stat to All Child Shoen");
  };

  $USE(D_Work_Brother_Shoen);
  s_GetFPRightChildShoenLink(fp_record, D_Work_Brother_Shoen);
  b_IfEqual(D_Work_Brother_Shoen, fp_record){/* $B;RAq1`L5$7!J8F$P$l$J$$$O$:!K(B */
    s_UnlockFPChildShoenLink(fp_record,fp_child_shoen_link_org_lock_tag_reg);
    $RELEASE(D_Work_Brother_Shoen);
  }else{  
    $USE(D_WorkFPOrgLockTagReg);
    s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

    s_PutFPAnswerResource(fp_record,D_NULL,D_NULL);
    s_IncrementFPChildShoenStatisticsCount(fp_record);

    s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
	
    LOOP(){
      s_IfSHREC(D_Work_Brother_Shoen)
	{  /*  $BAq1`%l%3!<%I$@$C$?$i(B  */
	  $USE(D_WorkShoenOrgLockTagReg);
	  s_LockShoenRecord(D_Work_Brother_Shoen, D_WorkShoenOrgLockTagReg);

	  s_IfNotShoenUnhookReserved(D_Work_Brother_Shoen)
	    { /* $BAq1`$,2rJ|M=Ls$G$J$+$C$?$i(B */
	      s_IfFPExist(D_Work_Brother_Shoen)
		{ /* $BAq1`$KN$?F$,$"$C$?$i(B */
		  $USE(D_WorkFPOrgLockTagReg);
		  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
		  s_IncrementFPChildShoenStatisticsCount(fp_record);
		  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
		  $RELEASE(D_WorkFPOrgLockTagReg);

		  f_AskShoenStatFromFP(D_Work_Brother_Shoen); 
		  /* $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
		  s_UnlockShoenRecord(D_Work_Brother_Shoen,
				                  D_WorkShoenOrgLockTagReg);
		  $RELEASE(D_WorkShoenOrgLockTagReg);
		}
	      else
		{ /* $BAq1`$KN$?F$,$J$+$C$?$i(B */
		  /* $BAq1`$N>CHq;q8;NL$r?FN$?F$KH?1G$5$;$F$*$/(B */
		  $USE(D_WorkShoenResourceConsumeUpper);
		  $USE(D_WorkShoenResourceConsumeLower);
		  s_GetShoenResourceConsumedWithUpdate(D_Work_Brother_Shoen,
					   D_WorkShoenResourceConsumeUpper,
				           D_WorkShoenResourceConsumeLower);

		  /* $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
		  s_UnlockShoenRecord(D_Work_Brother_Shoen,
				                  D_WorkShoenOrgLockTagReg);
		  $RELEASE(D_WorkShoenOrgLockTagReg);

		  /* $B$3$N%^%/%m$NCf$G!"?FN$?F$,%m%C%/(B/$B%"%s%m%C%/$5$l$k!#(B*/
		  /* $B%/%i%9%?Fb(BPE$B$K%-%c%C%7%e$5$l$F$$$k;q8;$N%G%-%c%C%7%e$b(B
                     $B9T$o$l$k(B */
		  f_FPAddAnswerResourceOnly(fp_record, 
					D_WorkShoenResourceConsumeUpper,
				           D_WorkShoenResourceConsumeLower);
		  $RELEASE(D_WorkShoenResourceConsumeUpper);
		  $RELEASE(D_WorkShoenResourceConsumeLower);
		}
	    }
	  else
	    { /* $BAq1`$,2rJ|M=Ls$@$C$?$i(B */
	      /* $BAq1`$N>CHq;q8;NL$r?FN$?F$KH?1G$5$;$F$*$/(B */
	      $USE(D_WorkShoenResourceConsumeUpper);
	      $USE(D_WorkShoenResourceConsumeLower);
	      s_GetShoenResourceConsumedWithUpdate(D_Work_Brother_Shoen, 
					   D_WorkShoenResourceConsumeUpper,
				           D_WorkShoenResourceConsumeLower);

	      /* $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
	      s_UnlockShoenRecord(D_Work_Brother_Shoen,
				                  D_WorkShoenOrgLockTagReg);
	      $RELEASE(D_WorkShoenOrgLockTagReg);

	      /* $B$3$N%^%/%m$NCf$G!"?FN$?F$,%m%C%/(B/$B%"%s%m%C%/$5$l$k!#(B*/
	      /* $B%/%i%9%?Fb(BPE$B$K%-%c%C%7%e$5$l$F$$$k;q8;$N%G%-%c%C%7%e$b(B
		 $B9T$o$l$k(B */
	      f_FPAddAnswerResourceOnly(fp_record, 
				     D_WorkShoenResourceConsumeUpper,
				           D_WorkShoenResourceConsumeLower);
	      $RELEASE(D_WorkShoenResourceConsumeUpper);
	      $RELEASE(D_WorkShoenResourceConsumeLower);
	    }
	  s_GetRightBrotherShoenLink(D_Work_Brother_Shoen,
				                      D_Work_Brother_Shoen);
	  b_IfEqual(D_Work_Brother_Shoen, fp_record) {
	    break;/* goto out of LOOP */
	  }
	}else{  /*  $BAq1`%l%3!<%I$G$bN$?F%l%3!<%I(B($B<+J,<+?H(B)$B$G$b$J$+$C$?$i(B  */
	  @DEBUG{
	    VPIM_ERROR("f_AskStatisticsAllChildShoenWithUnlockChildShoenLink", 
		       "Illegal FPChildLink");
	  };
	  break;
	}
    }/* end of LOOP */
    s_UnlockFPChildShoenLink(fp_record,fp_child_shoen_link_org_lock_tag_reg);
    f_DecrementFPChildShoenStatisticsCountAndAnswerAboveIfZero(fp_record);
    /* cf. $BN$?F$N%m%C%/$O$3$N%^%/%m$NCf$G$d$k(B */

    $RELEASE(D_Work_Brother_Shoen);
  }
}



#DATA_define D_WorkFPStatCount XXX

/* $B$3$N%^%/%m$NCf$GN$?F%l%3!<%I$r%m%C%/$7$^$9(B */
/* $B$3$N%^%/%m$NCf$G>e$NAq1`$K%a%C%;!<%8$r=P$9>l9g$,$"$j$^$9(B */
#PSL_define f_DecrementFPChildShoenStatisticsCountAndAnswerAboveIfZero
                                                              (fp_record)
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

  s_DecrementFPChildShoenStatisticsCount(fp_record);

  $USE(D_WorkFPStatCount);
  s_GetFPChildShoenStatisticsCount(fp_record,D_WorkFPStatCount);
  
  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);

  b_IfEqual(D_WorkFPStatCount,D_NULL){
    f_FPAnswerAbove(fp_record);
  }

  $RELEASE(D_WorkFPStatCount);
}

#PSL_define f_FPAnswerAbove(fp_record)
{
  $CALL(f_SyncroDecacheResourceForAnswerStat_Sub(fp_record));
}

#PSL_define f_FPAddAnswerResource(fp_record,resource_upper,resource_lower)
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  s_AddFPAnswerResource(fp_record,resource_upper,resource_lower);
  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);

  f_DecrementFPChildShoenStatisticsCountAndAnswerAboveIfZero(fp_record);
}

#PSL_define f_FPAddAnswerResourceOnly(fp_record,resource_upper,resource_lower)
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  s_AddFPAnswerResource(fp_record,resource_upper,resource_lower);
  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);

}

/******************************************************************** PSL **

  f_AskProfileAllChildShoenWithUnlockChildShoenLink(fp_record,link_lock_reg)

       written by kawai@icot21      on Thu Nov 23 22:48:25 1989
<Arguments>
  fp_record : $BN$?F$X$N%]%$%s%?$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_Brother_Shoen : $B;RAq1`%j%s%/$K$D$J$,$l$?Aq1`$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $B;RAq1`%j%s%/$KBP$7$F!"$3$N%^%/%m$N8F$S$@$785$G%m%C%/$,3]$+$C$F$$$k$3$H!#(B
<Function>
  $BN$?F$NA4$F$N;RAq1`$K%W%m%U%!%$%j%s%0D4::$r0MMj$9$k!#(B
  $BK\%^%/%m=hM}$N1dD9$G(B     f_FPExportProfilingDataForAnswer(fp_record);
  $B$r8F$S=P$92DG=@-$,$"$k$?$a!"(B
  $B;RAq1`%j%s%/$N%"%s%m%C%/$OK\%^%/%mCf$G9T$J$&!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_AskProfileAllChildShoenWithUnlockChildShoenLink(fp_record,
                          fp_child_shoen_link_org_lock_tag_reg)
{
  @DEBUG{
    WARNING("f_AskProfileAllChildShoenWithUnlockChildShoenLink",
	    "Ask Profile to All Child Shoen");
  };

  $USE(D_Work_Brother_Shoen);
  s_GetFPRightChildShoenLink(fp_record, D_Work_Brother_Shoen);
  b_IfEqual(D_Work_Brother_Shoen, fp_record){/* $B;RAq1`L5$7!J8F$P$l$J$$$O$:!K(B */
    s_UnlockFPChildShoenLink(fp_record,fp_child_shoen_link_org_lock_tag_reg);
    $RELEASE(D_Work_Brother_Shoen);
  }else{  
    $USE(D_WorkFPOrgLockTagReg);
    s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

    s_PutFPProfilingTotalAnswerCount(fp_record,D_NULL);
    s_IncrementFPProfilingChildShoenCount(fp_record);

    s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);

    LOOP(){
      s_IfSHREC(D_Work_Brother_Shoen)
	{  /*  $BAq1`%l%3!<%I$@$C$?$i(B  */
	  $USE(D_WorkShoenOrgLockTagReg);
	  s_LockShoenRecord(D_Work_Brother_Shoen, D_WorkShoenOrgLockTagReg);

	  s_IfNotShoenUnhookReserved(D_Work_Brother_Shoen)
	    { /* $BAq1`$,2rJ|M=Ls$G$J$+$C$?$i(B */
	      s_IfFPExist(D_Work_Brother_Shoen)
		{ /* $BAq1`$KN$?F$,$"$C$?$i(B */
		  $USE(D_WorkFPOrgLockTagReg);
		  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
		  s_IncrementFPProfilingChildShoenCount(fp_record);
		  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
		  $RELEASE(D_WorkFPOrgLockTagReg);

		  f_AskShoenProfileFromFP(D_Work_Brother_Shoen); 
		  /* $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
		  s_UnlockShoenRecord(D_Work_Brother_Shoen,
				                  D_WorkShoenOrgLockTagReg);
		  $RELEASE(D_WorkShoenOrgLockTagReg);
		}
	      else
		{ /* $BAq1`$KN$?F$,$J$+$C$?$i(B */
		  /* $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
		  s_UnlockShoenRecord(D_Work_Brother_Shoen,
				                  D_WorkShoenOrgLockTagReg);
		  $RELEASE(D_WorkShoenOrgLockTagReg);
		}
	    }
	  else
	    { /* $BAq1`$,2rJ|M=Ls$@$C$?$i(B */
	      /* $BAq1`%l%3!<%I$r%"%s%m%C%/$9$k(B */
	      s_UnlockShoenRecord(D_Work_Brother_Shoen,
				                  D_WorkShoenOrgLockTagReg);
	      $RELEASE(D_WorkShoenOrgLockTagReg);
	    }
	  s_GetRightBrotherShoenLink(D_Work_Brother_Shoen,
				                      D_Work_Brother_Shoen);
	  b_IfEqual(D_Work_Brother_Shoen, fp_record) {
	    break;/* goto out of LOOP */
	  }
	}else{  /*  $BAq1`%l%3!<%I$G$bN$?F%l%3!<%I(B($B<+J,<+?H(B)$B$G$b$J$+$C$?$i(B  */
	  @DEBUG{
	    VPIM_ERROR("f_AskProfileAllChildShoenWithUnlockChildShoenLink", 
		       "Illegal FPChildLink");
	  };
	  break;
	}
    }/* end of LOOP */
    s_UnlockFPChildShoenLink(fp_record,fp_child_shoen_link_org_lock_tag_reg);
    f_DecrementFPProfilingChildShoenCountAndAnswerAboveIfZero(fp_record);
    /* cf. $BN$?F$N%m%C%/$O$3$N%^%/%m$NCf$G$d$k(B */

    $RELEASE(D_Work_Brother_Shoen);
  }
}

#DATA_define D_WorkFPProflingCount XXX

/* $B$3$N%^%/%m$NCf$GN$?F%l%3!<%I$r%m%C%/$7$^$9(B */
/* $B$3$N%^%/%m$NCf$G>e$NAq1`$K%a%C%;!<%8$r=P$9>l9g$,$"$j$^$9(B */
#PSL_define f_DecrementFPProfilingChildShoenCountAndAnswerAboveIfZero
                                                              (fp_record)
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record, D_WorkFPOrgLockTagReg);

  s_DecrementFPProfilingChildShoenCount(fp_record);

  $USE(D_WorkFPStatCount);
  s_GetFPProfilingChildShoenCount(fp_record,D_WorkFPStatCount);
  
  s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);

  b_IfEqual(D_WorkFPStatCount,D_NULL){
    f_FPExportProfilingDataForAnswer(fp_record);
  }

  $RELEASE(D_WorkFPStatCount);
}


/******************************************************************** PSL **

f_PassProfileToParentFP(fp_rec, type_reg, total_ans_reg,
			depth_reg, cl_num_reg, prpfile_result);


       written by yamamoto@icot22      on Fri May 17 17:52:22 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>

type $B$,(B _FP_PROFILETYPE_NO_FP $B0J30$N;~!"%W%m%U%!%$%j%s%0%G!<%?$r>e$K$"$2$k!#(B
$B$3$N$H$-!">e$K$"$2$k(B total_ans $B$O%<%m$K$9$k!#(B

type $B$,(B _FP_PROFILETYPE_NO_FP $B$N;~!"0?$O!"(Btotal_ans $B$,HsNm$N;~!"(B
$BN$?F%l%3!<%ICf$N!"(BProfilingTotalAnswerCount$B!"(BProfilingChildShoenCount $B$r(B
$B%a%s%F$9$k!#(B

ProfilingChildShoenCount $B$,%<%m$K$J$C$?;~$K$O!"N$?F<+?H$N%W%m%U%!%$%j%s%0(B
$B%G!<%?$r!">e$+$i$N(B ask $B$KBP1~$9$k(B answer $B$H$7$F$"$2$k!#(B
$B$3$N;~$O$9$G$K=87W$7$?(B ProfilingTotalAnswerCount $B$K<+J,$NJ,$r2C$($F!"(B
$B>e$K$"$2$k(B total_ans $B$H$9$k!#(B

********************************************************************* PSL **/

#DATA_define D_WorkFPProfileChildCount XXX

#PSL_define f_PassProfileToParentFP(fp_rec, type_reg, total_ans_reg,
				    depth_reg, cl_num_reg, profile_result){

  b_IfNotEqualImm(type_reg,_FP_PROFILETYPE_NO_FP){
    f_FPExportProfilingDataOfChild(fp_rec,type_reg,D_NULL,
				   depth_reg, cl_num_reg,profile_result);
    b_IfEqual(total_ans_reg,D_NULL){
      goto L_END;
    }
  }

  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_rec, D_WorkFPOrgLockTagReg);
  s_AddFPProfilingTotalAnswerCount(fp_rec,total_ans_reg);
  s_DecrementFPProfilingChildShoenCount(fp_rec);
  
  $USE(D_WorkFPProfileChildCount);
  s_GetFPProfilingChildShoenCount(fp_rec,D_WorkFPProfileChildCount);
  s_UnlockFPRecord(fp_rec, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);
  
  b_IfZero(D_WorkFPProfileChildCount){
    f_FPExportProfilingDataForAnswer(fp_rec);
  }
  $RELEASE(D_WorkFPProfileChildCount);
 L_END:;

}


/******************************************************************** PSL **

$B3F<o%j%=!<%9=hM}C10L$NDj5A(B

       written by yamamoto@icot22      on Mon Oct  1 16:28:04 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>

_RSC_SUPPLY_UNIT >> _RSC_THROW_GOAL_UNIT > _RSC_ENOUGH_TO_CACHE_UNIT
							> _RSC_CACHE_UNIT

$B>e$N$h$&$JBg>.4X78$+$J$!$H;W$C$F$$$k!J;3K\!"@n9g!"Cg@%!K(B

********************************************************************* PSL **/
/* $B;q8;$N6!5kC10L(B */
#CONST_define  _RSC_SUPPLY_UNIT                     0x01000000
#CONST_define  _RSC_CACHE_UNIT                      0x00002000
#CONST_define  _RSC_THROW_GOAL_UNIT                 0x00010000
#CONST_define  _RSC_ENOUGH_TO_CACHE_UNIT            0x00008000

/******************************************************************** PSL **

  f_CacheFPResource(fp_record)

       written by kawai@icot21      on Thu Mar 16 15:44:24 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
  D_WorkCacheResourceUnitReg : $B%-%c%C%7%e%f%K%C%H$r0l;~J];}$9$k%l%8%9%?!#(B
  D_WorkFPResourceLeftReg : $BN$?F$N;q8;;DNL$r0l;~J];}$9$k%l%8%9%?!#(B
<Level>
  functions
<PreCondition>
  $B$3$N%^%/%m$N8F$S=P$785$GN$?F$K%=%U%H%m%C%/$7$F$$$k$3$H!#(B
<Function>
  $BN$?F$N%j%=!<%9;DNL$+$i0lDjNL$N%j%=!<%9$r%-%c%C%7%e(B(D_ResourceCache)$B$KJ,$1$k!#(B
  $BN$?F$N%j%=!<%9;DNL$,=<J,$KL5$$;~$K$ON$?F$O?FAq1`$+$i%j%=!<%9$rLc$$$K$$$/!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B$H$j$"$($:BgN,$O#V#0#2$N$^$^(B */

#DATA_define  	D_WorkCacheResourceUnitReg     	XXX
		/* $B%j%=!<%9$N%-%c%C%7%e$O#1%o!<%I$KG<$^$kHO0O$H$9$k(B */
#DATA_define	D_WorkFPResourceLeftUpperReg	XXX
#DATA_define	D_WorkFPResourceLeftLowerReg	XXX

#PSL_define  f_CacheFPResource(fp_record)
{
  /*  D_ResourceCache$B$K%j%=!<%9$r3d$jEv$F$k!#(B */
  $USE(D_WorkCacheResourceUnitReg);
  p_SetImmediateValue(_RSC_CACHE_UNIT, D_WorkCacheResourceUnitReg);
  $USE(D_WorkFPResourceLeftUpperReg);
  $USE(D_WorkFPResourceLeftLowerReg);
  s_GetFPResourceLeft(fp_record, 
		D_WorkFPResourceLeftUpperReg, D_WorkFPResourceLeftLowerReg);

  b_IfEqual(D_WorkFPResourceLeftUpperReg,D_NULL){
    b_IfLessEqU(D_WorkFPResourceLeftLowerReg, D_WorkCacheResourceUnitReg)
    { /* $BN$?F$N;q8;$,%-%c%C%7%eJ,0J>e;D$C$F$$$J$1$l$P(B */

      $RELEASE(D_WorkCacheResourceUnitReg);
      b_IfGreaterU(D_WorkFPResourceLeftLowerReg, D_NULL){
	/* $BN$?F$N;q8;$,>/$7$G$b;D$C$F$$$l$P(B */
	s_SubtractFPResourceLeft(fp_record,
				 D_WorkFPResourceLeftUpperReg, 
				 D_WorkFPResourceLeftLowerReg);
	/* reset resource left $B$r:n$k$+!)(B */
	p_MoveWord(D_WorkFPResourceLeftLowerReg, D_ResourceCache);
      }else{
	p_MoveWord(D_NULL, D_ResourceCache);
      }
      $RELEASE(D_WorkFPResourceLeftUpperReg);
      $RELEASE(D_WorkFPResourceLeftLowerReg);
      s_SetFPStatusFlag(fp_record, _FP_RSC_EXHAUSTED_FLAG);
      $CALL( f_FPRequestResourceWithoutLock_Sub(fp_record) );
      goto L_END;
    }
  }
    { /* $BN$?F$N;q8;$,%-%c%C%7%eJ,0J>e;D$C$F$$$l$P(B */
      $RELEASE(D_WorkFPResourceLeftUpperReg);
      $RELEASE(D_WorkFPResourceLeftLowerReg);
      s_SubtractFPResourceLeft(fp_record, D_NULL, D_WorkCacheResourceUnitReg);
      p_MoveWord(D_WorkCacheResourceUnitReg, D_ResourceCache);
      p_SetImmediateValue(_RSC_ENOUGH_TO_CACHE_UNIT, 
			  D_WorkCacheResourceUnitReg);
      s_IfNotEnoughFPResourceLeft(fp_record,D_WorkCacheResourceUnitReg)
	{ /*  $BN$?F$K$b$&0l2sJ,G[$9$k$@$1$N%j%=!<%9$,$J$1$l$P(B  */
	  $CALL( f_FPRequestResourceWithoutLock_Sub(fp_record) );
	}
      $RELEASE(D_WorkCacheResourceUnitReg);
    }
L_END:;
}

/******************************************************************** PSL **

  f_DecrementFPResource(fp_record)

       written by kawai@icot22      on Thu Jan 18 22:12:15 1990
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
  D_WorkCacheResourceUnitReg : $B%-%c%C%7%e%f%K%C%H$r0l;~J];}$9$k%l%8%9%?!#(B
  D_WorkFPResourceLeftReg : $BN$?F$N;q8;;DNL$r0l;~J];}$9$k%l%8%9%?!#(B
<Level>
  functions
<PreCondition>
  $B$3$N%^%/%m$N8F$S=P$785$GN$?F$K%=%U%H%m%C%/$7$F$$$k$3$H!#(B
<Function>
  $BN$?F$N%j%=!<%9;DNL$+$i%G%/%j%a%s%H$9$k!#(B
  $BN$?F$N%j%=!<%9;DNL$,=<J,$KL5$$;~$K$ON$?F$O?FAq1`$+$i%j%=!<%9$rLc$$$K$$$/!#(B
<Examples>
<Test>
<Explanation>
<ETC> see. f_merger_unify.psl.c 
  $B%^!<%8%c$N=jB0$9$kN$?F$H!"%f%K%U%!%$$r9T$&%4!<%k$NN$?F$,0[$J$k>l9g$K8F$P$l$k(B
********************************************************************* PSL **/
/* $B$H$j$"$($:BgN,#V#0#2$N$^$^(B */
#PSL_define  f_DecrementFPResource(fp_record)
{
  $USE(D_WorkFPResourceLeftUpperReg);
  $USE(D_WorkFPResourceLeftLowerReg);
  s_GetFPResourceLeft(fp_record, 
		D_WorkFPResourceLeftUpperReg, D_WorkFPResourceLeftLowerReg);
  b_IfEqual(D_WorkFPResourceLeftUpperReg,D_NULL){
    b_IfLessEqU(D_WorkFPResourceLeftLowerReg, D_ONE){
	 /* $BN$?F$N;q8;(B $B!e(B 1 $B$J$i$P(B */
      $RELEASE(D_WorkFPResourceLeftUpperReg);
      b_IfEqual(D_WorkFPResourceLeftLowerReg, D_ONE){
		/* $BN$?F$N;q8;(B = 1 $B$J$i$P(B */
	s_SubtractFPResourceLeft(fp_record, D_NULL, D_ONE);
			/* reset resource left $B$r:n$k$+!)(B */
      }else{ 
		/* $BN$?F$N;q8;(B = 0 $B$J$i$P(B */
	@DEBUG{
	  VPIM_ERROR("f_DecrementFPResource", 
		     "Called when Resource Exhausted");
	};
      }
      $RELEASE(D_WorkFPResourceLeftLowerReg);
      s_SetFPStatusFlag(fp_record, _FP_RSC_EXHAUSTED_FLAG);
      $CALL( f_FPRequestResourceWithoutLock_Sub(fp_record) );
      goto L_END;
    }
  }
    { /* $BN$?F$N;q8;(B > 1 $B$J$i$P(B($B$D$^$j(B $B!f(B 2 $B$J$i$P(B) */
      $RELEASE(D_WorkFPResourceLeftUpperReg);
      $RELEASE(D_WorkFPResourceLeftLowerReg);
      s_SubtractFPResourceLeft(fp_record, D_NULL, D_ONE);
      $USE(D_WorkCacheResourceUnitReg);
      p_SetImmediateValue(_RSC_ENOUGH_TO_CACHE_UNIT, 
			  D_WorkCacheResourceUnitReg);
      s_IfNotEnoughFPResourceLeft(fp_record,D_WorkCacheResourceUnitReg)
	{ /*  $BN$?F$K%-%c%C%7%e%f%K%C%HJ,$N%j%=!<%9$,$J$1$l$P(B  */
	  $CALL( f_FPRequestResourceWithoutLock_Sub(fp_record) );
	}
      $RELEASE(D_WorkCacheResourceUnitReg);
    }
  L_END:;
}

/******************************************************************** PSL **

  f_UpdateFPResourceCount(fp_record)

       written by kawai@icot21      on Thu Mar 16 15:47:32 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
  D_Work_FP_Resource_Reg : $BN$?F$N%j%=!<%9;DNL$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $B$3$N%^%/%m$N8F$S$@$785$GN$?F$r%=%U%H%m%C%/$9$k$3$H!#(B
<Function>
  $B%-%c%C%7%e$7$F$$$?%j%=!<%9;DNL$rN$?F%l%3!<%I$K=q$-La$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $BCm0U!'(B
$BK\%^%/%m$G%G%-%c%C%7%e$7$?8e!":F%-%c%C%7%e$9$k$?$a$NMW5a!J%j%9%1%8%e!<%kMW5a!K(B
$B$O!"$3$N%^%/%m$G$O9T$J$o$J$$!#30B&$GI,MW$K1~$8$F$d$k$3$H!#(B
********************************************************************* PSL **/
/* $B$H$j$"$($:BgN,#V#0#2$N$^$^(B */
#PSL_define  f_UpdateFPResourceCount(fp_record)
{
  $USE(D_WorkFPResourceLeftUpperReg);
  $USE(D_WorkFPResourceLeftLowerReg);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
                                                D_WorkFPResourceLeftLowerReg);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
                                                D_WorkFPResourceLeftUpperReg);

  b_AddDoubleWord(D_WorkFPResourceLeftUpperReg, D_WorkFPResourceLeftLowerReg,
	D_NULL, D_ResourceCache,
	D_WorkFPResourceLeftUpperReg, D_WorkFPResourceLeftLowerReg);

  p_WriteWithOffset(D_WorkFPResourceLeftLowerReg, fp_record,
                                           _FP_RESOURCE_LEFT_LOWER_OFFSET);
  p_WriteWithOffset(D_WorkFPResourceLeftUpperReg, fp_record,
                                           _FP_RESOURCE_LEFT_UPPER_OFFSET);
  p_MoveValue(D_NULL, D_ResourceCache);  /* D_ResourceCache$B$N%<%m%/%j%"(B */


  /* $BMW8!F$(B
     $B;q8;$N%"%C%W%G!<%H$K$h$j!";q8;;DNL$,0lDjCM(B($B%-%c%C%7%e%f%K%C%HDxEY(B?)$B$h$j(B
     $BB?$/$J$C$?;~$K!"N$?F$N>uBV$r(B _RESOURCE_NONEXHAUSTED $B$KLa$9$+H]$+(B
       $B!{(B $B$-$a$N:Y$+$$@)8f(B
       $B!_(B $BN$?F$N>uBVH=Dj$,I,MW$G!"7k9==E$$=hM}(B
  */
  $RELEASE(D_WorkFPResourceLeftUpperReg);
  $RELEASE(D_WorkFPResourceLeftLowerReg);
}

/******************************************************************** PSL **

  f_DecacheFPResourceCount(fp_record)

       written by pim@icot21      on Tue Feb  6 17:31:32 1990
<Arguments>
  fp_record : $BN$?F%l%3!<%I$X$N%]%$%s%?(B
<Temporally Used Variables>
  D_Work_FP_Resource_Reg : $BN$?F$N%j%=!<%9;DNL$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  functions
<PreCondition>
  $B$3$N%^%/%m$N8F$S$@$785$GN$?F$r%=%U%H%m%C%/$9$k$3$H!#(B
<Function>
  $B%-%c%C%7%e$7$F$$$?%j%=!<%9;DNL$rN$?F%l%3!<%I$K=q$-La$9!#(B
  $B8=:_$O(B f_UpdateFPResourceCount $B$HF10l$G$"$k$,!">-Mh(Bf_UpdateFPResourceCount
$B$GJV5Q;q8;$N:FJ,G[$J$I$N$h$j:Y$+$J;q8;4IM}$r9T$J$&;~$K$O!"JLJ*(B($B8=:_$N(Bf_UpdateFP
ResourceCount$B$N5!G=$N$_(B)$B$H$9$k!#(B
  $B$3$N%^%/%m$O%/%i%9%?Fb3F(BPE$B$G%-%c%C%7%e;q8;$rN$?F$K=q$-La$9;~$K8F$S=P$5$l$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
  $BCm0U!'(B
$BK\%^%/%m$G%G%-%c%C%7%e$7$?8e!":F%-%c%C%7%e$9$k$?$a$NMW5a!J%j%9%1%8%e!<%kMW5a!K(B
$B$O!"$3$N%^%/%m$G$O9T$J$o$J$$!#30B&$GI,MW$K1~$8$F$d$k$3$H!#(B
********************************************************************* PSL **/
/* $B$H$j$"$($:#V#0#2$N$^$^(B */
#PSL_define  f_DecacheFPResourceCount(fp_record)
{
  f_UpdateFPResourceCount(fp_record);
}

/******************************************************************** PSL **

  f_UpdateFPResourceLeft(fp_record, resource_upper_reg, resource_lower_reg)

       written by kawai@icot22      on Wed Jun 14 17:06:15 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
  resource_upper_reg : $B%j%=!<%9NL$rJ];}$9$k%l%8%9%?(B
  resource_lower_reg : $B%j%=!<%9NL$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
  functions
<PreCondition>
<Function>
  $BN$?F%l%3!<%I$N%j%=!<%9;DNL$r99?7$9$k!#(B($B%=%U%H%m%C%/$J$7(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B0z?t$N%j%=!<%9$,%<%m$N;~$OB(%j%?%s$9$k$+!)(B
   $B$^$?$O$3$N%^%/%m$r8F$P$J$$$3$H$K$9$k$Y$-$+!)(B */

#PSL_define  f_UpdateFPResourceLeft(fp_record, 
				resource_upper_reg, resource_lower_reg)
{
  $USE(D_WorkFPResourceLeftLowerReg);
  $USE(D_WorkFPResourceLeftUpperReg);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_UPPER_OFFSET,
                                            D_WorkFPResourceLeftUpperReg);
  p_ReadWithOffset(fp_record, _FP_RESOURCE_LEFT_LOWER_OFFSET,
                                            D_WorkFPResourceLeftLowerReg);
  b_AddDoubleWord(
		D_WorkFPResourceLeftUpperReg,D_WorkFPResourceLeftLowerReg,
		resource_upper_reg, resource_lower_reg,
		D_WorkFPResourceLeftUpperReg,D_WorkFPResourceLeftLowerReg);
    /*  $B%*!<%P!<%U%m!<;~$NBP=h$,I,MW(B?       */

  p_WriteWithOffset(D_WorkFPResourceLeftUpperReg, fp_record,
                                            _FP_RESOURCE_LEFT_UPPER_OFFSET);
  p_WriteWithOffset(D_WorkFPResourceLeftLowerReg, fp_record,
                                            _FP_RESOURCE_LEFT_LOWER_OFFSET);
  b_IfEqual(D_WorkFPResourceLeftUpperReg, D_NULL)
    {
      b_IfEqual(D_WorkFPResourceLeftLowerReg, D_NULL)
	{
	  goto L_END;
	}
    }
  /* $B%-%c%C%7%e;q8;$,N$?F$KLa$5$l$F!";q8;;DNL$,(B 0 $B0J>e$K$J$C$?$i(B */
  s_ResetFPStatusFlag(fp_record, _FP_RSC_EXHAUSTED_FLAG);
L_END:;  
  $RELEASE(D_WorkFPResourceLeftLowerReg);
  $RELEASE(D_WorkFPResourceLeftUpperReg);
}

/******************************************************************** PSL **

  f_UpdateFPLastResourceLeft(fp_record, resource_reg)

$B%j%=!<%9$,%5%W%i%$$5$l$?;~!"(Bf_UpdateFPResourceLeft $B$H%Z%"$G;H$&!#(B

       written by kawai@icot22      on Wed Jun 14 17:06:15 1989
<Arguments>
  fp_record : $BN$?F%l%3!<%I$rJ];}$9$k%l%8%9%?(B
  resource_reg : $B%j%=!<%9NL$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_Work_FP_Resource_Reg : $BN$?F%l%3!<%I$N:G?7(B(last)$B%j%=!<%9;DNL$r0l;~J];}$9$k(B
                           $B%l%8%9%?(B
<Level>
  functions
<PreCondition>
<Function>
  $BN$?F%l%3!<%I$NN$?F$N:G?7(B(last)$B%j%=!<%9;DNL$K(Bresource_reg$B$NCMJ,$r2C$($k!#(B
  ($B%=%U%H%m%C%/$J$7(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define  f_UpdateFPLastResourceLeft(fp_record, 
				resource_upper_reg, resource_lower_reg)
{
  s_AddFPLastResourceLeft(fp_record, 
				resource_upper_reg, resource_lower_reg);
}

/******************************************************************** PSL **

i_DequeueNewGoal  $B$+$i8F$P$l$k!#(B

$BN$?F$N<B9T>uBV$N%A%'%C%/!"%j%=!<%9%-%c%C%7%e$N%a%$%s%F%J%s%9$N0lIt$r=hM}!#(B

       written by yamamoto@icot22      on Fri May 25 10:59:50 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#SUBARG_define     A_FPOrgLockTag      SRC
#SUBARG_define     A_OldFPPtr          SRC

#SUBROUTINE  f_FPNotRunnableWithUnlock_Sub(A_FPOrgLockTag,A_OldFPPtr)
{
  @DEBUG{
    s_IfTerminateFP(D_Current_FP_Ptr){
      VPIM_ERROR("f_FPNotRunnableWithUnlock_Sub","Why? TerminateFP ???");
    }
  };
  s_IfAbortedFP(D_Current_FP_Ptr)
    { /* $BN$?F$,(BAborted$B>uBV$@$C$?$i(B */
      s_ReclaimGoalRecord (D_ArgReg0);
      b_IfNotEqual( D_Current_FP_Ptr, A_OldFPPtr )
	{   /*  $BN$?F$,0c$C$?$i(B  */
	  s_DecrementFPChildCount(D_Current_FP_Ptr);
	  s_IfNoChild(D_Current_FP_Ptr)
	    { /* $BN$?F$N(BChildCount$B$,(B0$B$@$C$?$i(B */
	      
	      /* $BN$?F%l%3!<%I$N2s<}A`:n(B */

	      $CALL(f_FPTerminateWithUnlockFP_Sub(D_Current_FP_Ptr, 
						  A_FPOrgLockTag));
	      /* f_Send_IntClMsg_Terminated_Sub $B$H(B
	       * s_ReclaimFPRecord $B$,8F$P$l$k$O$:(B
	       */
	    }else{
	      s_UnlockFPRecord( D_Current_FP_Ptr, A_FPOrgLockTag );  
	    }
	}else{
	  s_DecrementForkCounter ();
	  s_UnlockFPRecord( D_Current_FP_Ptr, A_FPOrgLockTag );  
	}
    }
    else
    {
      s_IfAbortedTerminateFP(D_Current_FP_Ptr)
	{ /* $BN$?F$,(BAbortedTerminate$B>uBV$@$C$?$i(B */
	  s_ReclaimGoalRecord (D_ArgReg0);
	  b_IfNotEqual( D_Current_FP_Ptr, A_OldFPPtr )
	    {   /*  $BN$?F$,0c$C$?$i(B  */
	      s_DecrementFPChildCount(D_Current_FP_Ptr);
	      s_IfNoChild(D_Current_FP_Ptr)
		{ /* $BN$?F$N(BChildCount$B$,(B0$B$@$C$?$i(B */
		  
		  /* $BN$?F%l%3!<%I$N2s<}A`:n(B */

		  $CALL(f_FPTerminateWithUnlockFP_Sub(D_Current_FP_Ptr, 
					  A_FPOrgLockTag));
		  /* s_ReclaimFPRecord $B$,8F$P$l$k$O$:(B */

		}else{
		  s_UnlockFPRecord( D_Current_FP_Ptr, A_FPOrgLockTag );  
		}
	    }else{
	      s_DecrementForkCounter ();
	      s_UnlockFPRecord( D_Current_FP_Ptr, A_FPOrgLockTag );  
	    }
	}
        else
        { /* $BN$?F$,(BAborted$B>uBV$G$J$+$C$?$i(B */
	  /* $B%4!<%k$rCfCG%4!<%k$H$7$F!"N$?F$K$D$J$0(B */
	  f_HookFPStoppedGoalWithoutLock(D_Current_FP_Ptr, D_ArgReg0);
	  s_UnlockFPRecord( D_Current_FP_Ptr, A_FPOrgLockTag );  
	}
    }
  $RETURN();
}


#DATA_define  D_WorkOldFPLockTag   XXX

#SUBARG_define     A_OldFPPtr           MODIFY
#SUBARG_define     A_OldResourceCache   MODIFY
#SUBARG_define     A_OldForkCount       MODIFY


#SUBROUTINE  f_MaintainOldFP_Sub(A_OldFPPtr, 
					A_OldResourceCache, A_OldForkCount)
{
  $USE(D_WorkOldFPLockTag);
  @DEBUG{
    b_IfEqual(A_OldFPPtr,D_Current_FP_Ptr) {
      VPIM_ERROR("f_MaintainOldFP_Sub","A_OldFPPtr is not OLD!");
    }
  };
  s_LockFPRecord(A_OldFPPtr, D_WorkOldFPLockTag);
  f_UpdateFPResourceLeft(A_OldFPPtr, D_NULL, A_OldResourceCache);
  s_AddFPChildCount(A_OldFPPtr, A_OldForkCount);

  /* D_current_FP_Ptr $B$NJ,(B f_CheckGoalExecutable $B$G(B */
  /* s_EnsureFPExsitance $B$7$F$"$C$?$N$rLa$9(B */
  s_DecrementFPChildCount(A_OldFPPtr);
  s_DecrementFPStatGatherEventCount(A_OldFPPtr);

  s_IfNoChild(A_OldFPPtr)
    { /* $BN$?F$N(BChildCount$B$,(B0$B$@$C$?$i(B */
      s_IfNoSuspendedMsg(A_OldFPPtr)
	{ /* $B%5%9%Z%s%I$7$F$$$k%a%C%;!<%8$,L5$+$C$?$i(B */

	  $CALL( f_FPTerminateWithUnlockFP_Sub(A_OldFPPtr, 
					       D_WorkOldFPLockTag) );
	  $RELEASE(D_WorkOldFPLockTag);	
	}
      else
	{
	  s_UnlockFPRecord(A_OldFPPtr, D_WorkOldFPLockTag);
	  $RELEASE(D_WorkOldFPLockTag);
	}
    }
  else
    { /* $BN$?F$N(BChildCount$B$,(B0$B$G$J$+$C$?$i(B */
      s_UnlockFPRecord(A_OldFPPtr, D_WorkOldFPLockTag);
      $RELEASE(D_WorkOldFPLockTag);
    }      
  p_MoveValue(D_NULL, A_OldResourceCache);
  p_MoveValue(D_NULL, A_OldForkCount);
  $RETURN();
}

/******************************************************************** PSL **

$B;RAq1`$,=*N;$7$?;~$K!"?FN$?F$N%A%c%$%k%I%+%&%s%H$r#18:>/$5$;!"(B

$B$5$i$K!"?FN$?F$r=*N;$5$;$kI,MW$,$"$k$+D4$YI,MW$J$i=*N;$5$;$k!#(B

$B;RAq1`$N=*N;=hM}$N1dD9$G!"(B
$B=*N;$7$?;RAq1`$,$9$G$K;RAq1`%j%s%/$+$i30$5$l$?>uBV$G!"$3$N%^%/%m$,8F$P$l$k!#(B


       written by yamamoto@icot22      on Wed Jul  4 17:05:02 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkFPMainChildCount XXX
#DATA_define D_WorkFPMainChildLink XXX

#PSL_define f_CheckFPTermination(fp_record){

  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record,D_WorkFPOrgLockTagReg);

/* f_UnhookShoenFromFPChildLink 
         $B$G%j%s%/$+$i30$7$?Aq1`$NJ,$r%+%&%s%H%@%&%s$9$k(B  90-10-30 reki */
/* See f_ShoenTerminate_Sub(f_shoen_with_fp.psl.c)$B$r;2>H$N$3$H(B */
  s_DecrementFPChildCount(fp_record);

  $USE(D_WorkFPMainChildCount);
  s_GetFPChildCount(fp_record,D_WorkFPMainChildCount);

  b_IfEqual(D_WorkFPMainChildCount,D_NULL){
    /* $BN$?F$N2<$K$O!";RAq1`$b!"%4!<%k$b$$$J$$(B */
    /*               $B=hM}Cf%a%C%;!<%8$b$J$$(B   */
    /*               $B=hM}BT$A%a%C%;!<%8$O!)(B   */
    $RELEASE(D_WorkFPMainChildCount);

    $CALL( f_FPTerminateWithUnlockFP_Sub(fp_record,D_WorkFPOrgLockTagReg) );
    /* ReclaimFP $B$NM-$kHFMQ%^%/%m$NJ}$r8F$V(B */
    $RELEASE(D_WorkFPOrgLockTagReg);
  }else{
    /* $BN$?F$N2<$K$O!";RAq1`$+%4!<%k$,$$$k(B */
    $RELEASE(D_WorkFPMainChildCount);
    s_IfAbortedFP(fp_record){
      $USE(D_WorkFPMainChildLink);
      s_GetFPRightChildShoenLink(fp_record,D_WorkFPMainChildLink);
      b_IfEqual(D_WorkFPMainChildLink,fp_record){
	/* $B;RAq1`%j%s%/$,6u$@$C$?!#B($A2<$K$$$?$N$O%4!<%k$@$1(B */
	/* $B$3$N;~$ON$?F$rJD$8$^$9(B */
	$RELEASE(D_WorkFPMainChildLink);

/* $B!v!v!vCm0U!v!v!v(B
   f_SyncroDecacheResourceForAbort_Sub $B$G$O!"<+J,<+?H$N=hM}$N$?$a$K(B
   $B%$%Y%s%H%+%&%s%H$,#1%W%i%9$5$l$F$$$k$N$G!"(Bs_IfJustOneStatGatherEvent$B$r(B
   $B;H$C$F$$$k!#$3$3(B(f_CheckFPTermination)$B$G$O!"$=$N$h$&$K$J$C$F$$$J$$$N$G!"(B
   s_IfNoStatGatherEvent $B$r;H$C$F$$$k!#"-(B
 */
/* $B%A%c%$%k%I%+%&%s%H$,%<%m$N>l9g$O>e$G=|$1$F$$$k(B */
	s_IfNoStatGatherEvent(fp_record){
	  $CALL( f_FPTerminateWithUnlockFPWithoutReclaimFP_Sub(fp_record,
						   D_WorkFPOrgLockTagReg));
	  /* ReclaimFP $BL5$7$N(B abort $B;~@lMQ$N%^%/%m$r8F$V(B */
	  /* $BN$?F$N%"%s%m%C%/$b$3$NCf$G$d$k(B */
	  $RELEASE(D_WorkFPOrgLockTagReg);
	}else{
	  /* $BB>$N@hAw$j=hM}!?<B9TCf=hM}$,$"$k;~$O%?!<%_%M%$%H$7$J$$(B */
	  s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg);
	  $RELEASE(D_WorkFPOrgLockTagReg);
	}
      }else{
	/* $B$^$@;RAq1`$,B>$K$b$$$^$7$?(B */
	/* $B2?$b$7$J$$(B */
      s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPMainChildLink);
      }

    }else{
      /* $BN$?F$N2<$K$O2?$+$$$F$+$D!"%"%\!<%H>uBV$G$b$J$$(B */
      /* $B2?$b$7$J$$(B */
    s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
    }
  }
}

/******************************************************************** PSL **

$B;RAq1`$,=*N;$7$?;~$K!";D$j;q8;$*$h$SL$Js9p$N>CHq;q8;$rN$?F$KB-$79~$`(B
$BB>$N;RAq1`$X$N%j%=!<%9$N:FG[J,$b9T$J$&(B

$B;RAq1`$N=*N;=hM}$N1dD9$G!"$3$N%^%/%m$,8F$P$l$k!#(B

       written by yamamoto@icot22      on Wed Jul  4 23:27:05 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_FPResourceSuppliedByShoenTermination(fp_record,
					   returned_rsc_left_upper,
					   returned_rsc_left_lower,
					   consumed_upper,
					   consumed_lower){
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(fp_record,D_WorkFPOrgLockTagReg);

  s_IfNotDummyFP(fp_record){

    /* $B;RAq1`$G>CHq$7$?$j%=!<%9$NFbL$Js9pJ,$r!"N$?F$NL$Js9pJ,$K2C$($k(B */
    /* fp-last-resource-left += consumed */
    $USE(D_WorkFPCurrentRscU);
    $USE(D_WorkFPCurrentRscL);
    s_GetFPLastResourceLeft(fp_record,D_WorkFPCurrentRscU,D_WorkFPCurrentRscL);
    b_IfGreaterImm(D_WorkFPCurrentRscU, _RESOURCE_BIG_ENOUGH){
      s_SubtractFPResourceLeft(fp_record,
			       consumed_upper,
			       consumed_lower);
      s_EnsureFPExistance(fp_record, D_ONE);
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
      $CALL(f_Send_IntClMsg_Return_Resource_Sub(fp_record,
						consumed_upper,
						consumed_lower));
    }else{
      s_AddFPLastResourceLeft(fp_record,				
			      consumed_upper,
			      consumed_lower);
      s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
    }
    /* $B#c#f!%N$?F$K1w$1$kL$Js9pJ,!'(Blast_rsc_left - rsc_left */
    $RELEASE(D_WorkFPCurrentRscU);
    $RELEASE(D_WorkFPCurrentRscL);
        
    /* $B;RAq1`$K;D$C$F$$$?$j%=!<%9$rJV$9(B */
    /* $BB>$N;RAq1`$KJ,G[$9$k(B */
    /* $B%5%V%k!<%A%s$NCf$G:FEYN$?F$K%m%C%/$r3]$1$k(B */
    $CALL(f_FPResourceSuppliedByShoen_Sub(fp_record,
					  returned_rsc_left_upper,
					  returned_rsc_left_lower));
  }else{ /* just store total reductions under the initial shoen */
    s_AddFPLastResourceLeft(fp_record,				
			    consumed_upper,
			    consumed_lower);
    s_UnlockFPRecord(fp_record, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
  }
}

/******************************************************************** PSL **

$B;RAq1`$G%j%=!<%9$N0n$l$,@8$8$?;~$K!"$3$l$rN$?F$N%j%=!<%9%l%U%H$KLa$9!#(B
$BB>$N;RAq1`$X$N%j%=!<%9$N:FG[J,$b9T$J$&(B

$B;RAq1`$N=hM}$N1dD9$G!"$3$N%^%/%m$,8F$P$l$k!#(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define f_FPResourceSuppliedByShoenResourceOverflow(fp_record,
					   returned_rsc_left_upper,
					   returned_rsc_left_lower){
  $CALL(f_FPResourceSuppliedByShoen_Sub(fp_record,
					returned_rsc_left_upper,
					returned_rsc_left_lower));
}

#DATA_define D_WorkFPCurrentRscU XXX
#DATA_define D_WorkFPCurrentRscL XXX
#DATA_define D_WorkFPAddendRscU  XXX
#DATA_define D_WorkFPAddendRscL  XXX
#DATA_define D_WorkFPSurplusRscU XXX
#DATA_define D_WorkFPSurplusRscL XXX

#SUBARG_define A_FPRec SRC
#SUBARG_define A_RSC_U SRC
#SUBARG_define A_RSC_L SRC

#SUBROUTINE f_FPResourceSuppliedByShoen_Sub(A_FPRec,A_RSC_U,A_RSC_L){
					    
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(A_FPRec,D_WorkFPOrgLockTagReg);

  s_IfNotDummyFP(A_FPRec){

    /* $B;RAq1`$K;D$C$F$$$?$j%=!<%9$rJV$9(B */
    /* fp-resource-left += returned-rsc-left */
    /* fp-last-resource-left += returned-rsc-left */
    $USE(D_WorkFPCurrentRscU);
    $USE(D_WorkFPCurrentRscL);
    s_GetFPLastResourceLeft(A_FPRec,D_WorkFPCurrentRscU,D_WorkFPCurrentRscL);
    
    $USE(D_WorkFPAddendRscU);
    $USE(D_WorkFPAddendRscL);
    $USE(D_WorkFPSurplusRscU);
    $USE(D_WorkFPSurplusRscL);
    b_CheckResourceSurplus(D_WorkFPCurrentRscU,
			   D_WorkFPCurrentRscL,
			   A_RSC_U,
			   A_RSC_L,
			   D_WorkFPAddendRscU,
			   D_WorkFPAddendRscL,
			   D_WorkFPSurplusRscU,
			   D_WorkFPSurplusRscL);

    $RELEASE(D_WorkFPCurrentRscU);
    $RELEASE(D_WorkFPCurrentRscL);

    b_IfNotZeroDoubleWord(D_WorkFPAddendRscU,D_WorkFPAddendRscL){
      f_UpdateFPResourceLeft(A_FPRec,
			     D_WorkFPAddendRscU,
			     D_WorkFPAddendRscL);
      f_UpdateFPLastResourceLeft(A_FPRec,				
				 D_WorkFPAddendRscU,
				 D_WorkFPAddendRscL);
    }
    /* $B#c#f!%N$?F$K1w$1$kL$Js9pJ,!'(Blast_rsc_left - rsc_left */
    $RELEASE(D_WorkFPAddendRscU);
    $RELEASE(D_WorkFPAddendRscL);
    
    b_IfNotZeroDoubleWord(D_WorkFPSurplusRscU,D_WorkFPSurplusRscL){
      s_EnsureFPExistance(A_FPRec, D_ONE);
      /* main prcessing is after unlock fprec */
    }

    s_IfAbortedFP(A_FPRec){
      s_UnlockFPRecord(A_FPRec,D_WorkFPOrgLockTagReg);
      $RELEASE(D_WorkFPOrgLockTagReg);
    }else{
      s_IfAbortedTerminateFP(A_FPRec){
	s_UnlockFPRecord(A_FPRec,D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
      }else{
	s_UnlockFPRecord(A_FPRec,D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
	/* $BB>$N;RAq1`$KJ,G[$9$k(B */
	/*$B!JJ,G[MW5a$NM-L5$O%5%V%k!<%A%s$NCf$G%A%'%C%/$5$l$k!K(B */
	$CALL( f_DistributeFPResource_Sub(A_FPRec));
      }
    }

    b_IfNotZeroDoubleWord(D_WorkFPSurplusRscU,D_WorkFPSurplusRscL){
      /* before unlock fprec ,fp existance ensured */
      $CALL(f_Send_IntClMsg_Return_Resource_Sub(A_FPRec,
						D_WorkFPSurplusRscU,
						D_WorkFPSurplusRscL));
    }
    $RELEASE(D_WorkFPSurplusRscU);
    $RELEASE(D_WorkFPSurplusRscL);

  }else{ /* do nothing for dymmy fp */
    s_UnlockFPRecord(A_FPRec, D_WorkFPOrgLockTagReg);
    $RELEASE(D_WorkFPOrgLockTagReg);
  }

  $RETURN();
}

/******************************************************************** PSL **

$BN$?F$N;}$C$F$$$k%j%=!<%9$,!"0z?t$G;XDj$7$?NL$h$j$b>/$J$$;~!"(B
$BAq1`$K%j%=!<%9%j%/%(%9%H%a%C%;!<%8H/9T$9$k(B

$B$?$@$7!"$9$G$K%j%/%(%9%HCf$J$i$P2?$b$7$J$$(B

$BAq1`=hM}$N1dD9$+$i8F$P$l$k!#(B

       written by yamamoto@icot22      on Wed Jul  4 23:50:15 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkFPOrgLockTagReg1 XXX

#PSL_define f_CheckFPResourceLeftMargin(fp_record,margin_reg){
  $USE(D_WorkFPOrgLockTagReg1);
  s_LockFPRecord(fp_record,D_WorkFPOrgLockTagReg1);
  s_IfNotDummyFP(fp_record){
    s_IfAbortedOrAbortedTerminateFP(fp_record)
      { /* $B#0(B. $BN$?F$,4{$K(B Abort$B$5$l$F$$$k(B */
	@DEBUG{
	  _PrintFPInfo(fp_record);
	  WARNING("f_CheckFPResourceLeftMargin", 
		  "FP already Aborted : noop"); };
	s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg1);
	$RELEASE(D_WorkFPOrgLockTagReg1);
      }else{
	s_IfNotFPResourceRequest(fp_record){
	  /* $B#1!%8=:_$O%j%/%(%9%H%j%=!<%9$r=P$7$F$$$J$$(B */
	  s_IfEnoughFPResourceLeft(fp_record,margin_reg){
	    /* $B#1!%#1(B $B%j%=!<%9$O==J,$KM-$k(B */
	    s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg1);
	    $RELEASE(D_WorkFPOrgLockTagReg1);
	  }else{
	    /* $B#1!%#2(B $B%j%=!<%9$OIT==J,(B */
	    /* $B$3$N;~%j%/%(%9%H%j%=!<%9$r=P$9(B */
	    s_EnsureFPExistance(fp_record, D_ONE);
	    s_SetFPStatusFlag(fp_record,_FP_RSC_REQ_FLAG);
	    s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg1);
	    $RELEASE(D_WorkFPOrgLockTagReg1);
	    $CALL( f_Send_IntClMsg_Request_Resource_Sub(fp_record) );
	  }
	}else{
	  /* $B#2!%4{$K%j%/%(%9%H%j%=!<%9$r=P$7$F$$$k(B */
	  s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg1);
	  $RELEASE(D_WorkFPOrgLockTagReg1);
	}
      }
  }else{ /* do nothing for dummy fp */
    s_UnlockFPRecord(fp_record,D_WorkFPOrgLockTagReg1);
    $RELEASE(D_WorkFPOrgLockTagReg1);
  }
}

#DATA_define D_WorkFPSupplyToChildRscUpper XXX
#DATA_define D_WorkFPSupplyToChildRscLower XXX
  
#PSL_define f_FPSupplyResourceToChildShoen(fp_rec,rsc_u,rsc_l){
  /* do nothing for dummy fp */
  s_IfNotDummyFP(fp_rec){
    s_SubtractFPResourceLeft(fp_rec,rsc_u,rsc_l);
    $USE(D_WorkFPSupplyToChildRscUpper);
    $USE(D_WorkFPSupplyToChildRscLower);
    s_GetFPResourceLeft(fp_rec,
			D_WorkFPSupplyToChildRscUpper,
			D_WorkFPSupplyToChildRscLower);
    b_IfZeroDoubleWord(D_WorkFPSupplyToChildRscUpper,
		       D_WorkFPSupplyToChildRscLower){
      s_SetFPStatusFlag(fp_rec,_FP_RSC_EXHAUSTED_FLAG);
    }
    $RELEASE(D_WorkFPSupplyToChildRscUpper);
    $RELEASE(D_WorkFPSupplyToChildRscLower);
    s_SubtractFPLastResourceLeft(fp_rec,rsc_u,rsc_l);
  }
}
