
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_event_throw_goal_in_cluster.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue May 29 11:21:14 1990
   ----- LAST SAVED: by nakase@icot22, on Thu Apr 30 15:46:36 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : function
   ----- ABSTRACT  : $B%/%i%9%?Fb$K$*$1$k%4!<%k$NAw<u?.=hM}(B

1. $B%4!<%kJ,;6$NMW5a$r<u$1$?Aw=P$9$k%4!<%k$rA*$VA`:n(B
2. $BIi2YJ,;6$N$?$a$KE>Aw$9$k%4!<%k$r%4!<%k%9%?%C%/$+$i<h$j=P$9(B ($B%]%C%W(B)
3. $B%/%i%9%?Fb$NB>$N%W%m%;%C%5$X$N%4!<%k$NAw=P(B
4. $B%/%i%9%?Fb$G$N%4!<%k$N<u?.=hM}(B

$B!&%/%i%9%?Fb$K$*$1$k%4!<%k%l%3!<%I$NAw<u?.(B (1 to 1 $BDL?.(B)
$B!&%4!<%k$rAw?.$9$k>l9g(B:
  1) resume$B$7$?%W%m%;%C%5$+$i(Bsuspend$B$7$?%W%m%;%C%5$X(B(f_SendGoalToPE_in_Cluster)
  2) idle$B%W%m%;%C%5$X$N<+F0Ii2YJ,;6(B        (f_SelectGoalAndSendToPE_Sub)
  3) low-priority-goal$B<B9TCf$N%W%m%;%C%5$X(B (f_SelectGoalAndSendToPE_Sub)
 
 
GoalRequest	or Resume	or HighPriorityGoalRequest	or  PragmaedEnq

    Goal_Request_Action

    kblt_idle() $B$^$?$O(B $B%?%$%^!<3d$j9~$_(B
	|
    f_GoalRequest() / f_HighPriorityGoalProcess()
	|
	+---------------------------------------+
						|
  					f_PrioReqHandler_Sub()
						|
---------------------------------------------------------------------------
Throw_Goal_Action			f_SelectGoalAndSendToPE_Sub()
     						|
       					f_SendGoalToPE_in_cluster()
						|
	+---------------------------------------+
	|
	f_ThrowGoalHandler_Sub()

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%4!<%kJ,;6$NMW5a$r<u$1$?Aw=P$9$k%4!<%k$rA*$VA`:n(B

#SUBROUTINE f_SelectGoalAndSendToPE_Sub (A_PeNum)

       written by f-doumae@icot22      on Tue May 29 11:49:05 1990
<Arguments>
  A_PeNum : $B%4!<%k$rAw=P$9$k@h$N%W%m%;%C%5HV9f(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%4!<%kJ,;6$NMW5a$r<u$1$?Aw=P$9$k%4!<%k$r%4!<%k%9%?%C%/$+$iA*$V(B
<Examples>
<Test>
<Explanation>
  $B!&A*Br$7$?%4!<%k$,=jB0$9$kN$?F$,(B, $B$3$l$^$G<B9T$7$F$$$?%4!<%k$NN$?F$HEy$7$/(B,
    $B$5$i$K(B, D_Fork_Ctr $B$,@5$J$i$P(B, D_Fork_Ctr $B$K%-%c%C%7%s%0$7$F$$$?(B $B%4!<%k?t$N(B
    $B%+%&%s%H$rN$?FFb$N%4!<%k%+%&%s%?$N%9%m%C%H$K=q$-La$9I,MW$,$"$k(B.
<ETC>
  $B!&(B
********************************************************************* PSL **/
#DATA_define D_WorkSendGoalPtr  XXX

#SUBARG_define	A_PeNum		SRC
  
#SUBROUTINE f_SelectGoalAndSendToPE_Sub (A_PeNum)
{
  $USE(D_WorkSendGoalPtr);
  f_PopThrowableGoal(D_WorkSendGoalPtr);	/* ------ 1) */
  b_IfNotEOL(D_WorkSendGoalPtr){		/* ------ 2) */
    s_IfCurrentFPEqualToFPof (D_WorkSendGoalPtr) {
      s_IfForkCounterGTZero () {
	$USE(D_WorkFPOrgLockTagReg);
                                              /* $BDI2C(B  by  $B@n9g(B */
        s_LockFPRecord (D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
	s_UpdateFPChildCount (D_Current_FP_Ptr);
	@DEBUG{ /*-------------------------------------------------*/
	  p_IfLT() {
	    VPIM_ERROR("f_SelectGoalAndSend_Sub","ForkCout_UnderFlow");
	  }
	  p_IfEQ() {
	    VPIM_ERROR("f_SelectGoalAndSend_Sub","ForkCout_ZERO!!");
	  }
	}; /*-------------------------------------------------------*/
                                              /* $BDI2C(B  by  $B@n9g(B */
	s_UnlockFPRecord (D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
	$RELEASE(D_WorkFPOrgLockTagReg);
        s_SetZeroForkCounter ();
      }   
    }
    /* ------- add by imai "Solves ZEBRA no nazo" ---- */
    /* $B$H$C$F$-$?$P$+$j$N%4!<%k$,%5%9%Z%s%I$7!"$=$l$,:F3+$7$F!"(B
       $BAw?.85$KLa$5$l$k$H!"%+%&%s%H$,$*$+$7$/$J$k$?$a!"(B
       $B$H$C$F$-$?%4!<%k$O!"<+J,$K=jB0$9$k$b$N$H$9$k(B */
    b_SetImmTypeMRBoff(INT, A_PeNum);
    s_PutProcessorIdGoalRecord(D_WorkSendGoalPtr,A_PeNum); 
    /*------- add by imai "Solves ZEBRA no nazo" ----*/
    f_SendGoalToPE_in_cluster(D_WorkSendGoalPtr,A_PeNum);
  }                               	/* ------- 3) */
  $RELEASE(D_WorkSendGoalPtr);
$RETURN();
}


/******************************************************************** PSL **
2. $BIi2YJ,;6$N$?$a$KE>Aw$9$k%4!<%k$r%4!<%k%9%?%C%/$+$i<h$j=P$9(B ($B%]%C%W(B)

       written by f-doumae@icot22      on Tue May 29 11:52:09 1990
<Arguments>
  ptr_to_gr : $BIi2YJ,;6MQ$K<h$j=P$7$?%4!<%k$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&Ii2YJ,;6MQ$N%4!<%k$r(B ptr_to_gr $B$K<h$j=P$9(B. 
    $B7k2L$,(B D_EOL $B$KEy$7$1$l$P(B, $BJ,;6$9$Y$-%4!<%k$,$J$+$C$?$3$H$r<($9!#(B
<Examples>
<Test>
<Explanation>
  $B!&%4!<%k$NJ,;6$NMW5a$r<u$1$?%W%m%;%C%5$,$I$N%4!<%k$rA*$s$GJ,;6$9$k$+$O(B,
    $B=EMW$JA*Br$G$"$k(B. $B8=:_$O(B, $B0J2<$r%9%-%C%W$9$k$N$_$G$"$k!#(B
	a) $BB0@-$,(B processor resident $B$N%4!<%k!#(B
	b) execute $B7OL?Na$+$i8F$P$l$?;~(B, execute$B$7$h$&$H$7$F$$$?%4!<%k(B.
<ETC>
  $B!&%4!<%k$N%]%C%WA`:n$r%A%'%C%/8e$K$9$k$h$&$KJQ99$7$?!#(B
********************************************************************* PSL **/
#DATA_define  D_WorkLastLinkPos    XXX

#PSL_define f_PopThrowableGoal(ptr_to_gr)
{
  @DEBUG{/*---------------------- $B8F$S=P$7>r7o(B ------------------------*/
    s_IfNotEnoughGoal() {
      VPIM_ERROR("f_PopThrowableGoal","Not-enough goals");
    }
  };
  /* -----------------------------------------------------------------------
    D_Max_Priority $B$,(B VALID $B$N;~(B:
    	HighPriorityGoal$B%$%Y%s%H(B(see f_self_int.psl.c)$B$N=hM}$r$9$k(B.
    	D_ArgReg0$B$K%4!<%k$,$"$C$?>l9g(B, $B%9%?%C%/$KLa$7(B, D_CurrentGoalStackPtr $B$K(B
   	$B%-%c%C%7%e$7$F$$$?%4!<%k$N%j%s%/$r%(%s%H%j(B(D_CurrentStackEntryPtr) $B$K(B
    	$B=q$-La$9(B.
    	HigherPriorityGoal$B$NFbIt%$%Y%s%H$O%j%;%C%H(B.
   
    D_Max_Priority $B$,(B INVALID $B$N;~(B:
   	D_CurrentGoalStackPtr $B$K%-%c%C%7%e$7$F$$$?%4!<%k$N%j%s%/$r%(%s%H%j(B
   	(D_CurrentStackEntryPtr) $B$K=q$-La$9(B.
    	$B$3$N>l9g$O(B, D_ArgReg0 $B$K(B execute $B$7$h$&$H$7$?%4!<%k$,$"$k$+$b$7$l$J$$(B.
   --------------------------------------------------------------------------*/

  s_IfValidMaxPriority() {
    f_HigherPriorityGoal();	/* $B$3$NCf$G(B D_CurrentEnvRecPtr $B$O=q$-JQ$o$k(B */
  } else {
    s_PutGoalPtrStackEntry (D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);
  }
  /* $B$3$N;~E@$G(B:
   * 	D_CurrentEnvRecPtr $B$O99?7$5$l$F$$$k(B
   *  	D_CurrentStackEntryPtr = D_Max$B$,;X$7$F$$$?(B
   *  	D_CurrentGoalStackPtr = *(D_CurrentStackEntryPtr)
   *------------------------------------------------------------------------*/

  $USE(D_WorkEntryPos);
  p_MoveWord(D_CurrentStackEntryPtr, D_WorkEntryPos);


  /* --------------------------
   * $B%(%s%H%j$K%j%s%/$7$F$$$k=i$a$N%4!<%k$r0l$D8+$k!#(B
   */
  $USE(D_WorkGoalLink);
  s_GetGoalPtrStackEntry (D_WorkEntryPos, D_WorkGoalLink);

 RETRY_OTHER_PRIORITY:
  b_IfEOL(D_WorkGoalLink) {
      /* $B%4!<%k%9%?%C%/Cf$N<!$N6u$G$J$$%(%s%H%j$rA\$9!#(B*/
    s_GetLowerNonEmptyStackEntry (D_WorkEntryPos, D_WorkEntryPos);
    s_GetGoalPtrStackEntry(D_WorkEntryPos, D_WorkGoalLink);
  }
  /* --------------------------
   * $B%4!<%k%9%?%C%/Cf$N%(%s%H%j$N%W%i%$%*%j%F%#$,(B _IDLE_GOAL_PRI $B$J$i$P(B,
   * NULL $B$r7k2L$H$7$FJV$7(B, RE_CACHE $B$X(B
   */
  $USE(D_WorkPriority);
  s_GetPriorityStackEntry(D_WorkEntryPos, D_WorkPriority);
  b_IfEqualImm(D_WorkPriority, _IDLE_GOAL_PRIO) {
    /* D_WorkPriority $B$,(B _IDLE_GOAL_PRIO $B$N>l9g$O(B
     * ptr_to_gr $B$K$O(B NULL $B$rJV$9!#(B
     */
    p_MoveWord (D_NULL, ptr_to_gr);
    $RELEASE(D_WorkPriority);
    $RELEASE(D_WorkGoalLink);
    $RELEASE(D_WorkEntryPos);
    goto RE_CACHE;
  }
  $RELEASE(D_WorkPriority);

     /* $B%]%$%s%?=q$-La$7%"%I%l%9$NB`Hr(B */
  $USE(D_WorkLastLinkPos);
  b_AddImmediateWithDNTC(D_WorkEntryPos, _GR_PTR_OFST_STE, D_WorkLastLinkPos);


 RETRY_OTHER_GOAL:
  /* $B$=$N%4!<%k$,(B, "$BEj$2=P$9$Y$-(B" $B%4!<%k$G$J$+$C$?$i(B, $B<!$N%4!<%k$r8+$k!#(B
   * $BEj$2=P$7$F$bNI$$>l9g$O(B, $B$=$N%4!<%k$r%]%C%W$7$F(B, $B%4!<%k%l%3!<%I$N(B
   * $B<!%4!<%k$X$N%j%s%/$r(BEOL$B$H$7$F(B, RE_CACHE $B$X(B
   */

  $USE(D_WorkEnvRecPtr);
  s_GetEnvRecGoalRecord(D_WorkGoalLink,D_WorkEnvRecPtr);
  s_IfResidentPEAttrEnvRecord(D_WorkEnvRecPtr){
    $RELEASE(D_WorkEnvRecPtr);
     /* $B%]%$%s%?=q$-La$7%"%I%l%9$NB`Hr(B */
    b_AddImmediateWithDNTC
      (D_WorkGoalLink, _NEXT_PTR_OFST_GR, D_WorkLastLinkPos);
    s_GetNextGoalRecord(D_WorkGoalLink,D_WorkGoalLink);
    b_IfEOL(D_WorkGoalLink) {
       $RELEASE(D_WorkLastLinkPos);
       goto RETRY_OTHER_PRIORITY;
    } else {
       goto RETRY_OTHER_GOAL;
    }
  }
  $RELEASE(D_WorkEnvRecPtr);
  $RELEASE(D_WorkEntryPos);
  s_PopGoalRecord(ptr_to_gr, D_WorkGoalLink);
  b_DecrementReg(D_GoalCntInStack);
  p_Write(D_WorkGoalLink,D_WorkLastLinkPos); /* $B%]%$%s%?$N=q$-La$7(B */
  s_PutNextEOLGoalRecord(ptr_to_gr);
  $RELEASE(D_WorkGoalLink);
  $RELEASE(D_WorkLastLinkPos);

 RE_CACHE:
  s_GetGoalPtrStackEntry(D_CurrentStackEntryPtr, D_CurrentGoalStackPtr);

  @DEBUG {/*-------------------------------------------------------------*/
    b_IfNotEOL(ptr_to_gr){
      s_IfNotHOOK (ptr_to_gr) {
	VPIM_ERROR ("f_PopThrowableGoal", "Illegal_goal_record_type");
      }
    }
  }; /*------------------------------------------------------------------*/
}

/******************************************************************** PSL **
3. $B%/%i%9%?Fb$NB>$N%W%m%;%C%5$X$N%4!<%k$NAw=P(B

    f_SendGoalToPE_in_cluster(ptr_to_gr,pe_num)
    
       written by f-doumae@icot22      on Tue May 29 13:58:20 1990
<Arguments>
  ptr_to_gr : $B%4!<%k%l%3!<%I$X$N%]%$%s%?(B
  pe_num : $BAw=P@h%W%m%;%C%5HV9f(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define f_SendGoalToPE_in_cluster(ptr_to_gr,pe_num)
{
  b_SendMsgToPE_in_cluster
		(ptr_to_gr,_NEXT_PTR_OFST_GR,pe_num,_THROW_GOAL_EVENT);
  @MONITOR{ _PrintSendGoal(ptr_to_gr,pe_num); };
}

/******************************************************************** PSL **
4. $B%/%i%9%?Fb$G$N%4!<%k$N<u?.=hM}(B

#SUBROUTINE	f_ThrowGoalHandler_Sub()

       written by f-doumae@icot22      on Tue May 29 14:00:44 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B!&%/%i%9%?Fb$N(BPE$B4VDL?.$K$h$C$F%4!<%k$r<u?.$7$?;~(B, $B<u?.$7$?%4!<%k(B($BJ#?t$N2DG=@-(B
    $B$"$j(B)$B$r<+J,$N%4!<%k%9%?%C%/$KF~$l$k!#(B
<Examples>
<Test>
<Explanation>
   f_SignalPEIntHandler_Sub$B$+$i8F$P$l$k%$%Y%s%H=hM}!#(B
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkQueue 	XXX

#SUBROUTINE	f_ThrowGoalHandler_Sub()
{
  $USE(D_WorkQueue); 
  b_ReceiveMsgFromPE_in_cluster (_THROW_GOAL_EVENT, D_WorkQueue);
	/* $BEj$2$i$l$?%4!<%k%-%e!<$N=hM}(B */
  @DEBUG{
    b_IfEOL(D_WorkQueue){ VPIM_ERROR("f_ThrowGoalHandler_Sub","no-goal");}
  };
  LOOP(){
    b_IfEOL(D_WorkQueue){ break; }
    $USE(D_WorkGoalPtr); 
    s_PopGoalRecord(D_WorkGoalPtr,D_WorkQueue);
    @MONITOR{ _PrintReceiveGoal(D_WorkGoalPtr); };
    $USE(D_WorkPriority);
    s_GetPriorityEnvGoalRecord(D_WorkGoalPtr,D_WorkPriority);
    $CALL(f_PushGoalToStackWithPriority_Sub(D_WorkGoalPtr,D_WorkPriority));
    $RELEASE(D_WorkPriority);
    $RELEASE(D_WorkGoalPtr); 
  }
  $RELEASE(D_WorkQueue); 
  $RETURN();
}

