
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_event_serial_execution.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue May 29 15:42:49 1990
   ----- LAST SAVED: by imai@icot22, on Thu Mar 26 18:03:04 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : functions
   ----- ABSTRACT  : $B%7%e!<%I%Q%i%l%k%b!<%I$K$h$k<B9T(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by f-doumae@icot22      on Tue May 29 15:43:56 1990
<Arguments>
<Temporally Used Variables>
  D_WorkDest : $BNY$N(BPE$BHV9f(B(zero_origin)
<Level>
<PreCondition>
	SystemConfigulationArea$B$N%/%i%9%?Fb(BPE$BBf?t$r;HMQ$9$k(B(C$B4D6-$,@_Dj(B)$B!#(B
	System$B%$%K%7%c%i%$%6$,$3$N3d$j9~$_$r%;%C%H$9$k$3$H$K$h$j!"(B
	$B$3$N%b!<%I$N$_$GF0$/!#(B
<Function>
  $BB>$N(BPE$B$K$3$NMW0x$G3d$j9~$^$l$k$^$G(Bbusy_wait$B$7!"(B
  $B3d$j9~$^$l$?$i(B1$B%j%@%/%7%g%s<B9T$7$FNY$N(BPE$B$K3d$j9~$`!#(B
<Examples>
<Test>
<Explanation>
  $B:F8=@-$r3NJ]$9$k%G%P%C%0%b!<%I$G$"$k!#(B
  $B$3$l$O!"J#?t(BPE$B$N0l@Z$N%*!<%P%i%C%W<B9T$,L5$$$N$G(BC$B8@8l4D6-$NF14|%b!<%I$h$j(B
  $B6/$$@)8B$G$"$k!#(B

	<pe0>				<pe1> ........................<pen>
<init>	D_Status==D_NULL		D_Status==D_ONE
	SCR[_SCR_SERIALIZER]==ON	SCR[_SCR_SERIALIZER]==ON
	|				|
	NwMessageHandler		NwMessagehandler
	GCHandler			GCHandler
	SerialHandler(with D_NULL)	SerialHandler(with D_ONE)
	GoalReqHandler			(busy-wait)
	.
	.
	(reduction)
	NwMessageHandler
	GCHandler
	SerialHandler(with D_ONE)
	(passing control)-----------------+
	(busy-wait)			GoalReqHandler
					.
					.
<ETC>
********************************************************************* PSL **/
#DATA_define D_SerialExecutionStatus 	XXX
#DATA_define D_WorkNextPeNum  	XXX

#SUBROUTINE f_SerialHandler_Sub()
{
       /* Status : when 0 == master in initialization */
		/* when 1 == inactive in initialization */
  $USE(D_WorkPeNum); 
  $USE(D_WorkNextPeNum);

  b_IfZero(D_SerialExecutionStatus) {
    b_AddWithDNTC(D_PE_Number,D_ONE,D_WorkNextPeNum);/* get neighboring pe_num */
    b_ReadPENumInCluster(D_WorkPeNum);
    b_ModuloWithDNTC(D_WorkNextPeNum,D_WorkPeNum,D_WorkNextPeNum);
    b_SetEventFlag(_SERIAL_EXEC_EVENT, D_WorkNextPeNum);   /* $BNY$N8*$rC!$/(B */
    b_ResetEventFlag(_SERIAL_EXEC_EVENT, D_PE_Number); /* $B<+=M$9$k(B */
    b_BusyWaitSCROn(_SERIAL_EXEC_EVENT);/* $BB>$N3d$j9~$_$b<u$1IU$1$J$$(B */
  }else{
    /* $B0J2<$,I,$:(Bmaster$B$N8*C!$-$NA0$G$"$kJ]>Z$OL5$$(B!!$B=IBj(B*/
    b_ResetEventFlag(_SERIAL_EXEC_EVENT, D_PE_Number); /* $B<+=M$9$k(B */
    b_BusyWaitSCROn(_SERIAL_EXEC_EVENT);/* $BB>$N3d$j9~$_$b<u$1IU$1$J$$(B */
    p_MoveWord(D_NULL,D_SerialExecutionStatus);		/* set active */
  }
  $RELEASE(D_WorkNextPeNum); 
  $RELEASE(D_WorkPeNum);
  $RETURN ();
}

#PSL_define f_InitSerializer() /* $B%7%e!<%I%Q%i%l%k;XDj$K$h$j8F$P$l$k(B */
{
  p_MoveWord(D_PE_Number,D_SerialExecutionStatus);
  b_SetEventFlag(_SERIAL_EXEC_EVENT,D_PE_Number);
}


