/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_event_handler_main.psl.c
   ----- CREATED   : by f-doumae@icot22, on Mon May 28 14:58:38 1990
   ----- LAST SAVED: by yamamoto@icot22, on Fri Mar 27 21:17:29 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : function 
   ----- ABSTRACT  : $B%$%Y%s%H8!=P$H=hM}$K4X$9$kM%@hEY$rDj(B5A

1. $B%$%Y%s%H$N8!=P!"3d$j9~$_72$NH=Dj(B
  f_IfEventHappen()

  f_IfExternalInterrupt()
  f_IfSignalPEInterrupt()
  f_IfSelfInterrupt()

2. $B3d$j9~$_72Kh$N%$%Y%s%H%O%s%I%i$N8F$S$@(B$7
  f_SlitCheck_Sub()

3. $B%$%Y%s%H=hM}(B
  f_ExternalIntHandler()
  f_SignalPEIntHandler()
  f_SelfIntHandler()

4. $B%4!<%k%j%@%/%7%g%s(BKh $B$N%j%=!<%9>CHq$N%+%&%s%H(B
  f_Consume()

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
1. $B%$%Y%s%H$N8!=P!"3d$j9~$_72$NH=Dj(B
    
       written by f-doumae@icot22      on Mon May 28 15:02:28 1990

<Explanation>
    slit_check
        |
        +-- External interrupt
        |       |
        |       +-- Message packet arrival
        |       +-- timer
        |       +-- timer alarm
        |       +-- SCSI
        |        
        +-- PE signal
        |       |
        |       +-- All Synchronize Event 
        |       |      |
        |       |      +-- GC request (1 to all)
        |       |      +-- FP status check (1 to all)
        |       |
        |       +-- FP statistics check (1 to all)
        |       +-- Goal request (1 to any)
        |       +-- Goal arrival (1 to 1)
        |       +-- Serial execution (1 to 1)
        |
        +-- Self interrupt
                |
                +-- Heap shotage
                +-- High priority goal
                +-- FP statistics 
                +-- resource cache exhausted
                +-- network buffet full
                +-- scsi deferred exec
                +-- heap alert
         
<ETC>
********************************************************************* PSL **/
#CTRL_define f_IfEventHappen() /* $B%$%Y%s%H$N8!=P(B */
{
  b_IfEventFlagOn()
}

#CTRL_define f_IfExternalInterrupt()
{
  s_IfExternalIntFlagOn()
}

#CTRL_define f_IfSignalPEInterrupt()
{
  s_IfSignalPEIntFlagOn ()
}

#CTRL_define f_IfSelfInterrupt()
{
  s_IfSelfIntFlagOn()
}

/******************************************************************** PSL **
2. $B3d$j9~$_72Kh$N%$%Y%s%H%O%s%I%i$N8F$S$@(B$7
 
(SUBROUTINE) f_SlitCheck_Sub()

       written by f-doumae@icot22      on Mon May 28 15:18:15 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
    $B%$%Y%s%HH/@8;~$K8F$P$l$k(B!#
<Function>
    $B3d$j9~$_74Kh$N%$%Y%s%H%O%s%I%i$r8F$S=P$9!#(B
<Examples>
    f_IfEventHappen(){
	$CALL( f_SlitCheck_Sub());
    }
    ...
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#SUBROUTINE f_SlitCheck_Sub()
{
  @MONITOR{ _slitcheck_start(); };
  @PROBE{ b_IncrementReg(D_SLITCHECK_COUNT); };

  f_IfExternalInterrupt(){ /* $B30It5!4o$+$i$N3d$j9~$_(B */
    f_ExternalIntHandler();
  }
  f_IfSignalPEInterrupt(){ /* $B%/%i%9%?Fb$NB>(BPE$B$+$i$N3d$j9~$_(B */
    f_SignalPEIntHandler();
  }
  f_IfSelfInterrupt(){     /* $B<+(BPE$B$+$i$N3d$j=P$7(B */
    f_SelfIntHandler();
  }

  @MONITOR{ _slitcheck_end(); };
  $RETURN();
}

/******************************************************************** PSL **
3.1   $B30It3d$j9~$_=hM}(B

f_ExternalIntHandler()

       written by f-doumae@icot22      on Mon May 28 19:23:17 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B30It3d$j9~$_$O%?%$%^3d$j9~$_!"(BNIU$B$+$i$N%Q%1%C%HE~Ce3d$j9~$_!"(B
    SPC(Scsi Protocol Controller)$B$+$i$N3d$j9~$_$,$"$k!#(B
    $B$=$l$>$l$N%$%Y%s%H$KBP1~$9$k%O%s%I%i$r8F$S=P$9!#(B
<Examples>
<Test>
<Explanation>
<ETC>
    $B%$%Y%s%H=hM}$K$*$$$F!"%/%i%9%?Fb%a%C%;!<%8%Q%1%C%H=hM}$H(BSPC$B3d$j9~$_$N(B
    $B$I$A$i$,M%@hEY$,9b$$$+$O$h$/J,$+$i$J$$(B!#
********************************************************************* PSL **/
#PSL_define f_ExternalIntHandler()
{
  s_IfMessagePacketArrival(){
    $CALL( f_NwMessageHandler_Sub() );
  }
  s_IfSPCInt(){
    $CALL( f_SPCIntHandler_Sub() );
  }
  s_IfTimerInt(){
    $CALL( f_TimerIntHandler_Sub() );
  }
  s_IfTimerAlarm(){
    $CALL( f_TimerAlarmHandler_Sub() );
  }
}

/******************************************************************** PSL **
3.2 PE$B4V%7%0%J%kDL?.$K$h$k3d$j9~$_=hM}(B

f_SignalPEIntHandler()

       written by f-doumae@icot22      on Mon May 28 19:29:02 1990

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    Sigp$B3d$j9~$_$N=hM}!#MW0xKh$K%$%Y%s%H%O%s%I%i$r8F$S=P$9!#(B
<Examples>
<Test>
<Explanation>
    Sigp$B3d$j9~$_MW0x$O<!$NDL$j!#(B
    $B!&(BGC Request
    $B!&(BFP Status Check
    $B!&(BFP Statistics Check
    $B!&(BGoal Request
    $B!&(BThrow Goal(Goal Arrival)
    $B!&(BSerial Execution
<ETC>
********************************************************************* PSL **/
#PSL_define f_SignalPEIntHandler()
{
  s_IfAllSynchronize() {
    b_ResetEventFlag(_ALL_SYNCHRONIZE_EVENT, D_PE_Number);
    $USE(D_WorkBCMsgReg);
    b_ReadCommArea(_ONE_TO_ALL_MSG_OFST,D_WorkBCMsgReg);
    TypeSwitch(D_WorkBCMsgReg) {
    case _FP_IN_EVT_ABORTED:
    case _FP_IN_EVT_ASK_STAT:
    case _FP_IN_EVT_ANS_STAT:
      $RELEASE(D_WorkBCMsgReg);
      $CALL( f_DecacheFPResourceHandler_Sub() );
      break;
    case _GC_REQUEST:
      $RELEASE(D_WorkBCMsgReg); 
      f_IfNotEmptyCGP(D_ArgReg0) {
	f_PushGoalToStack(D_ArgReg0);
	f_MakeEmptyCGP(D_ArgReg0);
      }
      $CALL( f_GCHandler_Sub() );		/* see f_gc_in_cluster.psl.c */
      break;
    default:
      @DEBUG{VPIM_ERROR("f_SignalPEIntHandler","Illegal (Undefined) Message");};
    }
  }
  s_IfFPStatusCheck(){
    $CALL( f_FPStatusCheckHandler_Sub() );
  }
  /* $B$3$N=hM}$O(BSelf-Int$B=hM}$h$j$b@h$K9T$J$&$Y$-$G$"$k(B!# */
  /* [$BNc(B]
     (1) $BB>(BPE$B$,(BDecache$BMW5a$r=P$9!#(B
     (2) $B<+(BPE$B$,B>(BPE$B$+$i$N(BDecache$BMW5a$K5$IU$/A0$K!"(BDecache$BMW5a$r=P$=$&$H$9$k!#(B
     (3) $B<+(BPE$B$N(BDecache$BMW5a$O<:GT$7!"(BSelf-Int$B%U%i%0$r>e$2$F!"<!$N%9%j%C%H%A%'%C(B
         $B%/$G(BDecache$BMW5a$r:F<B9T$7$h$&$H$9$k!#(B
     (4) $B$3$N$H$-!"(BSelf-Int$B$,@h$K=hM}$5$l$k$H!"(BB>PE$B$+$i$N(BDecache$BMW5a$,<+(BPE$B$G(B
         $B=hM}$5$l$J$$$?$a!"<!0J9_$N%9%j%C%H%A%'%C%/$^$G=hM}$,CY$l$k!#(B
  */
  s_IfGoalRequest(){
    $CALL( f_PrioReqHandler_Sub() );
  }
  s_IfThrowGoal(){
    $CALL( f_ThrowGoalHandler_Sub() );
  }
  s_IfSerialExecution(){
    $CALL( f_SerialHandler_Sub() );
  }
  s_IfProcessorProfileChange() {
    $CALL( f_ProcessorProfileChangeHandler_Sub() );
  }
}

/******************************************************************** PSL **
3.3 $B%=%U%H%&%'%"3d$j9~$_$N=hM}(B

  f_SelfIntHandler()

       written by f-doumae@icot22      on Mon May 28 20:11:12 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%=%U%H%&%'%"3d$j9~$_$K$h$k(BPE$BFb%$%Y%s%H$N=hM}!#(B

<Examples>
<Test>
<Explanation>
    $B%=%U%H%&%'%"3d$j9~$_MW0x$O<!$NDL$j!#(B
    $B!&(BHigh Priority Goal
      $BA0$N%j%@%/%7%g%s$G!"9b%W%i%$%*%j%F%#%4!<%k$,H/@8$7$?!#(B
    $B!&(BPage Alloc Fail
      $BA0$N%j%@%/%7%g%s$G!"%R!<%W%a%b%jITB-$r8!=P$7$?!#(B
    $B!&(BFP Statistics Gather
      $BA0$N%j%@%/%7%g%s$G!"Aq1`Fb$N>CHq;q8;$NLd$$9g$o$;$,$"$C$?$,!"4{$K(B
      $BB>(BPE$B$,Ld$$9g$o$;$r$7$F$$$?!#(B
<ETC>
********************************************************************* PSL **/
#PSL_define f_SelfIntHandler()
{
  s_IfHighPriorityGoal(){
    f_HigherPriorityGoal();
  }
  s_IfPageAllocFail(){
    f_RequestLocalGC();
  }
  s_IfFPStatGather(){
    f_RetryGatherFPResource();
  }
  s_IfResourceCacheExhaust(){
    f_ForceReschedule();
  }
  s_IfNetworkBufferFull(){
    f_RetrySendPacket();
  }
  s_IfHeapAlert(){
    f_CheckHeapAlert();
  }
  s_IfScsiDeferredExec(){
    $CALL( f_ScsiDeferredExecution_Sub());
  }
}

/******************************************************************** PSL **
4. $B%4!<%k%j%@%/%7%g%s(BKh $B$N%j%=!<%9>CHq$N%+%&%s%H(B

       written by f-doumae@icot22      on Mon Jun  4 15:06:25 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_REDUCTION_COUNT XXX
#DATA_define D_SLITCHECK_COUNT XXX

#PSL_define	f_Consume()
{
  b_IntervalTimer(); /* $B<B5!$G$O>JN,$G$-$k!#(B*/
  b_DecrementReg(D_ResourceCache);
  p_IfEQ() {
    $CALL ( f_ResourceCacheZero_Sub() );
  }
  @DEBUG{	/* $BDj?t%l%8%9%?$NFbMF$N3NG'(B */
    b_IfNotEOL(D_NULL){
      VPIM_ERROR("f_Consume","Illegal_D_NULL");
    }
    b_IfNotEqualImm (D_NULL, _ZERO) {
      VPIM_ERROR("f_Consume","Illegal_D_NULL");
    }
    b_IfNotEqualImm (D_ONE, _ONE) {
      VPIM_ERROR("f_Consume","Illegal_D_ONE");
    }
    b_IfNotEqualImm (D_ALL1, _ALL1) {
      VPIM_ERROR("f_Consume","Illegal_D_ALL1");
    }
    s_IfNotHOOK(D_CurrentGoalStackPtr) {
      b_IfNotEOL(D_CurrentGoalStackPtr) {
	VPIM_ERROR("f_Consume","Illegal D_CurrentGoalStackPtr");
      }
    }
  };
  @PROBE {
    _increment_cl_reduction_count();
    b_IncrementReg (D_REDUCTION_COUNT);
  };
}

#SUBROUTINE f_ResourceCacheZero_Sub ()		/* By Goto, 1989.07.25 */
{
  $USE(D_WorkFPOrgLockTagReg);
  s_LockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
  f_CacheFPResource(D_Current_FP_Ptr);
  s_UnlockFPRecord(D_Current_FP_Ptr, D_WorkFPOrgLockTagReg);
  $RELEASE(D_WorkFPOrgLockTagReg);
  b_IfEqual(D_NeedRequestResourceMsgFlag,D_ONE){
    $CALL(f_Send_IntClMsg_Request_Resource_Sub(D_Current_FP_Ptr));
    p_MoveWord(D_NULL,D_NeedRequestResourceMsgFlag);
  }

  /* $B%-%c%C%7%e$G$-$J$+$C$?;~$O!"(Bf_CacheFPResource$B$NCf$G(BD_Current_FP_Ptr$B$NN$?F(B
     $B$N>uBV$r(B _RESOURCE_EXHAUSTED $B$H$9$k!#(B   By $B@n(B9g on 1989.12.25
  */

  b_IfZero(D_ResourceCache){
    b_SetEventFlag(_RESOURCE_CACHE_EXHAUST_EVENT,D_PE_Number);
  }
  /* $B=hM}8zN($r9M$($l$P!"%j%=!<%9%-%c%C%7%e%_%9$O%$%Y%s%H$H$7$F3d$j=P$7$r(B
     $B$;$:$K!"$3$3$G(BCGP$B$K%4!<%k$,$"$l$P%l%G%#%4!<%k%9%?%C%/$K%(%s%-%e!<$7$?(B
     $B$[$&$,$h$$!#(B==> $B%$%Y%s%H$K$7$F3d$j=P$9K\<AE*$JM}M3$C$F2?(B?
  */

  $RETURN ();
}

#PSL_define f_ForceReschedule()
{
    f_IfNotEmptyCGP(D_ArgReg0) {
      f_PushGoalToStack(D_ArgReg0);
      f_MakeEmptyCGP(D_ArgReg0);
    }
    b_SignalOffSCR(_RESOURCE_CACHE_EXHAUST_EVENT,D_PE_Number);
}

#PSL_define f_CheckHeapAlert(){
  b_SignalOffSCR(_HEAP_ALERT_EVENT,D_PE_Number);
  $CALL(f_CheckHeapAlert_Sub());
}
