 
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/functions/f_event_external_int.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue May 29 16:16:11 1990
   ----- LAST SAVED: by f-takei@icot22, on Mon Mar  9 11:46:06 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B30It3d$j9~$_$N%7%_%e%l!<%H(B

$B30It3d$j9~$_$K$O(B
    NIU$B$+$i$N%Q%1%C%HE~Ce3d$j9~$_(B
    SPC(Scsi Protocol Controller)$B$+$i$N3d$j9~$_(B
    $B%?%$%^3d9~$_(B
$B$,$"$k!#(B

#SUBROUTINE f_TimerIntHandler_Sub
#SUBROUTINE f_SPCIntHandler_Sub
(f_NwMessageHandler_Sub ==> see f_int_cl_recv_dispatch.psl.c)
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
/******************************************************************** PSL **
$B%?%$%^3d$j9~$_(B ($B%$%Y%s%H=hM}(B)

       written by f-doumae@icot22      on Tue May 29 16:24:19 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  10msec(2000reduction)order$B$GH/@8$9$k%?%$%^3d$j9~$_$N=hM}(B
<Examples>
<Test>
<Explanation>
  $B%?%$%^3d$j9~$_5!G=$O(B, $BKh%j%@%/%7%g%s$N=*$o$j$K8F$S=P$5$l$k(B f_Consume 
  raised by timer-int in f_Consume
<ETC>
********************************************************************* PSL **/
#SUBROUTINE     f_TimerIntHandler_Sub()
{
  b_ResetEventFlag(_TIMER_INT_EVENT, D_PE_Number);	/*$BMW0x$N%j%;%C%H(B*/

  f_PriorityPressureUpdate();
  $RETURN ();
}

/******************************************************************** PSL **
$B%"%i!<%`%?%$%^3d$j9~$_(B ($B%$%Y%s%H=hM}(B)

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%"%i!<%`%?%$%^3d$j9~$_5!G=$O(B,$B%/%m%C%/$,;XDj;~9o$X$NE~C#!"$^$?$O!"(B
  $B;XDj;~4V$N7P2a$K0x$j3d$j9~$s$G$/$k$b$N!#(B
<ETC>
********************************************************************* PSL **/
#SUBROUTINE     f_TimerAlarmHandler_Sub()
{
  b_ResetEventFlag(_TIMER_ALARM_EVENT, D_PE_Number);	/*$BMW0x$N%j%;%C%H(B*/

  f_WakeupGoalByAlarmClock();
  $RETURN ();
}

/******************************************************************** PSL **
SPC$B$+$i$N3d$j9~$_(B ($B%$%Y%s%H=hM}(B)
       written by f-doumae@icot22      on Wed Jan 16 14:05:57 1991
       revised by f-takei@icot22      on Thu Jul 11 17:15:10 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $B%9%j%C%H%A%'%C%/$G8!=P$5$l$k(BSPC$B$+$i$N3d$j9~$_$K$O<!$N(B4$B$D$N;v>]$,$"$k!#(B

$B!&(BSelected$B3d$j9~$_(B
    PIM$B$,%?!<%2%C%H$H$7$F%;%l%/%H$5$l$?!#(B
$B!&(BReselected$B3d$j9~$_(B
    PIM$B$,%$%K%7%(!<%?$H$7$F%j%;%l%/%H$5$l$?!#(B
$B!&(BDisconnected(Bus Free)$B3d$j9~$_(B
    $B%P%9$,2rJ|$5$l$?!#(B
$B!&(BReset Condition$B3d$j9~$_(B
    $B%j%;%C%H%3%s%G%#%7%g%s$,8!=P$5$l$?!#(B
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Jul 11">
     $B>e5-0J30$N3d$j9~$_$K$D$$$F(B SPC $B$N0[>o$J3d$j9~$_8!=P$H$7$F!"%9%j%C%H(B
     $B%A%'%C%/$NBP>]$H$9$k!#(B
********************************************************************* PSL **/
#DATA_define D_WorkInt   XXX

#SUBROUTINE f_SPCIntHandler_Sub()
{
    b_ResetEventFlag(_SPC_INT_EVENT, D_PE_Number);    /* $BMW0x$N%j%;%C%H(B */
    b_SetScsiBusFreeInterruptOff();

    $USE(D_WorkInt);
    b_GetScsiInterrupt(D_WorkInt);
    b_IfScsiInterruptResetCondition(D_WorkInt){ /* Reset Condition$B3d$j9~$_(B */
	$CALL( f_ScsiResetConditionHandling_Sub(D_NULL));
	goto END;
    }
    b_IfScsiInterruptDisconnected(D_WorkInt){ /* Disconnected$B3d$j9~$_(B */
	f_IfNotEmptyBusFreeWaiting(){
	    b_ResetScsiInterruptDisconnected();
	    /* SPC.INTS$B%l%8%9%?$NMW0x$N%j%;%C%H(B */
	}else{
	    b_IfScsiInterruptReselected(D_WorkInt){
		b_ResetScsiInterruptReselectedAndDisconnected();
		goto END;
	    }else{
		@DEBUG{
		    VPIM_ERROR("f_SPCIntHandler_Sub",
			       "Bus Free Waiting is empty!");
		};
		b_ResetScsiInterruptDisconnected();
		/* SPC.INTS$B%l%8%9%?$NMW0x$N%j%;%C%H(B */
		goto Fatal_Error_End;
	    }
	}

	i_SCSIDeviceDriver();
	goto END;
    }
    b_IfScsiInterruptSelected(D_WorkInt){ /* Selected$B3d$j9~$_(B */
	$CALL( f_ScsiSelected_Sub());
	goto END;
    }
    b_IfScsiInterruptReselected(D_WorkInt){/* Reselected$B3d$j9~$_(B */
	$CALL( f_ScsiReselected_Sub());
	goto END;
    }

  Fatal_Error_End:
    /* SPC $B$N0[>o$J3d$j9~$_8!=P(B */
    $CALL(f_ScsiFatalErrorEnd_Sub(D_WorkInt, D_NULL));

  END:
    $RELEASE(D_WorkInt);
    $RETURN();
}

/************ alarm timer *******************/

#PSL_define f_WakeupGoalByAlarmClock(){

  @DEBGU{
    WARNING("f_WakeupGoalByAlarmClock","Top of the Macro");
  };
  $USE(D_Work_AlarmTimerVar);
  s_ReadAlarmTimerVar(D_Work_AlarmTimerVar);
  s_IfREF(D_Work_AlarmTimerVar){
    /* $B6qBN2=BT$A$NJQ?t$"$j!#(B*/

    $USE(D_Work_CurrentTime);
    b_GetCurrentTime(D_Work_CurrentTime);
    b_SetImmTypeMRBoff(INT,D_Work_CurrentTime);

/*    i_KlbUnifyBound(D_Work_AlarmTimerVar,D_Work_CurrentTime); */
/*    $B$3$s$J$N8F$s$G$k$+$i(B f-$B%l%Y%k$KMn$;$J$$!D(B         */
/*                  $B"*(B $BD>@\Cf?H$r8F$s$G$7$^$&!#(B         */

    $USE(D_WorkPtrToDerefCell);
    f_ActiveDeref(D_Work_AlarmTimerVar, D_WorkPtrToDerefCell);
    f_IfSuccessActUnifyWithPtrMRBX (D_WorkPtrToDerefCell,
				    D_Work_AlarmTimerVar,
				    D_Work_CurrentTime){
      $CALL( f_WakeUpProcess_Sub( D_Work_AlarmTimerVar) );
    } else {
      @DEBGU{
	VPIM_ERROR("f_WakeupGoalByAlarmClock",
		   "fail f_IfSuccessActUnifyWithPtrMRBX");
      };
    }
    $RELEASE(D_WorkPtrToDerefCell);
    $RELEASE(D_Work_CurrentTime);
    s_ResetAlarmTimerVar();
  }else{
    @DEBUG{
      s_IfATOM(D_Work_AlarmTimerVar){
	VPIM_ERROR("f_WakeupGoalByAlarmClock",
		   "Why no variable? Where did she go?");
      }else{
	VPIM_ERROR("f_WakeupGoalByAlarmClock",
		   "AlarmTimerVar: illegal type");
      }
    };
  }
  $RELEASE(D_Work_AlarmTimerVar);

/* PIM/p ???
  _stop_timer();
  _reset_interrupt_flag();
  _instantiate_for_hooked_request();
*/

}
