
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_spc_reg_ope.psl.c
   ----- CREATED   : by f-doumae@icot22, on Fri Sep 14 15:43:43 1990
   ----- LAST SAVED: by f-takei@icot22, on Wed Jul 22 11:15:21 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

1. SPC$B%l%8%9%?$NFI$_=P$7!"=q$-9~$_A`:n(B($B4pK\A`:n(B)   

2  SCSI$B%$%s%?%i%W%H(B                             ==> INTS$B%l%8%9%?(B
    2.1 $B%F%9%H(B
    2.2 $B%$%s%?%i%W%H%U%i%0$N%j%;%C%H(B
    2.3 $B%$%s%?%i%W%H$NBT$A9g$o$;(B(BusyWait)
3. SCSI$B%9%F!<%?%9$N%F%9%H(B                       ==> SSTS$B%l%8%9%?(B

4. SCSI$B%U%'!<%:$N%F%9%H(B                         ==> PSNS$B%l%8%9%?(B

5. $B$=$NB>(B
    $B!&%Q%j%F%#%(%i!<%A%'%C%/(B                    ==> SERR$B%l%8%9%?(B
    $B!&(BSPC$B%j%;%C%H(B                               ==> SCTL$B%l%8%9%?(B
    $B!&%3%^%s%I$NH/9T(B                            ==> SCMD$B%l%8%9%?(B
    $B!&%U%'!<%:$N@_Dj(B                            ==> PCTL$B%l%8%9%?(B

    $B!&<+(BPE$B$,(BSCSI$B$K@\B3$5$l$F$$$k$+$N%F%9%H(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */
#DATA_define D_WorkSPCReg  XXX
#CONST_define _SPC_BDID_REG_ADDR    0
#CONST_define _SPC_SCTL_REG_ADDR    1
#CONST_define _SPC_SCMD_REG_ADDR    2
#CONST_define _SPC_TMOD_REG_ADDR    3
#CONST_define _SPC_INTS_REG_ADDR    4
#CONST_define _SPC_PSNS_REG_ADDR    5
#CONST_define _SPC_SDGC_REG_ADDR    _SPC_PSNS_REG_ADDR
#CONST_define _SPC_SSTS_REG_ADDR    6
#CONST_define _SPC_SERR_REG_ADDR    7
#CONST_define _SPC_PCTL_REG_ADDR    8
#CONST_define _SPC_MBC_REG_ADDR     9
#CONST_define _SPC_DREG_REG_ADDR   10
#CONST_define _SPC_TEMP_REG_ADDR   11
#CONST_define _SPC_TCH_REG_ADDR    12
#CONST_define _SPC_TCM_REG_ADDR    13
#CONST_define _SPC_TCL_REG_ADDR    14
#CONST_define _SPC_EXBF_REG_ADDR   15

/******************************************************************** PSL **
1. SPC$B%l%8%9%?$NFI$_=P$7!"=q$-9~$_A`:n(B

       written by f-doumae@icot22      on Mon Sep 17 10:46:40 1990
       revised by f-takei@icot22      on Wed Jul 22 10:52:35 1992
<Arguments>
    src_reg
    dst_reg
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    b_GetScsiXXX: SPC$B%l%8%9%?$NFI$_=P$7(B
    b_SetScsiXXX: SPC$B%l%8%9%?$N=q$-9~$_(B
    
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Jul 22">
  b_GetScsiPhase(dst_reg) $B$G$N%P%9%U%j!<!&%U%'!<%:$N8!=P$r!"(BPSNS $B%l%8%9%?(B
  $B%S%C%H#3(B:BSY $B$rMQ$$$k$h$&$KJQ99$7$?!#(B
********************************************************************* PSL **/
/*------------ $BFI$_=P$7A`:n(B --------------*/
#PSL_define b_GetScsiBusDeviceID(dst_reg)
{
  p_ReadSPCReg(_SPC_BDID_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiSPCCtrl(dst_reg)
{
  p_ReadSPCReg(_SPC_SCTL_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiCommand(dst_reg)
{
  p_ReadSPCReg(_SPC_SCMD_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiTransMode(dst_reg)
{
  p_ReadSPCReg(_SPC_TMOD_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiInterrupt(dst_reg)
{
  p_ReadSPCReg(_SPC_INTS_REG_ADDR, dst_reg);
}
/*
#CONST_define _SPC_PHASE_MASK  0x07 * 0000 0111 *
*/
#CONST_define _SPC_PHASE_MASK  0x0f /* 0000 1111 */

/*  $BJQ99(B 92.7.22 by f-takei
#PSL_define b_GetScsiPhase(dst_reg)
{
=*  $B%?!<%2%C%H$,%U%'!<%:$r@_Dj$9$k$N$rBT$D!#(B*=
  LOOP(){
    p_ReadSPCReg(_SPC_PSNS_REG_ADDR, dst_reg);
    b_BitwiseAndImmediateWithDNTC(dst_reg, _SPC_PSNS_REQ_ON, D_VOID);
    p_IfNE(){
	break;
    }else{   =* $B%P%9%U%j!<%U%'!<%:$N>l9g(B *=
	$USE(D_WorkReg);
	b_GetScsiInterrupt(D_WorkReg);
	b_IfScsiInterruptDisconnected(D_WorkReg){
	    $RELEASE(D_WorkReg);
	    break;
	}
	$RELEASE(D_WorkReg);
    }
  }
  b_BitwiseAndImmediateWithDNTC(dst_reg, _SPC_PHASE_MASK, dst_reg);
}
*/

#PSL_define b_GetScsiPhase(dst_reg)         /* modified by f-takei 92.7.22 */
{
/*  $B%?!<%2%C%H$,%U%'!<%:$r@_Dj$9$k$N$rBT$D!#(B*/
  LOOP(){
    p_ReadSPCReg(_SPC_PSNS_REG_ADDR, dst_reg);
    b_BitwiseAndImmediateWithDNTC(dst_reg, _SPC_PSNS_REQ_ON, D_VOID);
    p_IfNE(){
	break;
    }else{
	b_BitwiseAndImmediateWithDNTC(dst_reg, _SPC_PSNS_BSY_ON, D_VOID);
	p_IfEQ(){   /* $B%P%9%U%j!<%U%'!<%:$N>l9g(B */
	    p_MoveWord(D_NULL, dst_reg);
/*	    b_SetImmValueDNTC(_BUS_FREE_PHASE, dst_reg); */
	    break;
	}
    }
  }
  b_BitwiseAndImmediateWithDNTC(dst_reg, _SPC_PHASE_MASK, dst_reg);
}

#PSL_define b_GetScsiStatus(dst_reg)
{
  p_ReadSPCReg(_SPC_SSTS_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiErr(dst_reg)
{
  p_ReadSPCReg(_SPC_SERR_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiPhaseCtrl(dst_reg)
{
  p_ReadSPCReg(_SPC_PCTL_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiByteCounter(dst_reg)
{
  p_ReadSPCReg(_SPC_MBC_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiDataReg(dst_reg)
{
  p_ReadSPCReg(_SPC_DREG_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiTempReg(dst_reg)
{
  p_ReadSPCReg(_SPC_TEMP_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiTransCtrHigh(dst_reg)
{
  p_ReadSPCReg(_SPC_TCH_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiTransCtrMid(dst_reg)
{
  p_ReadSPCReg(_SPC_TCM_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiTransCtrLow(dst_reg)
{
  p_ReadSPCReg(_SPC_TCL_REG_ADDR, dst_reg);
}

#PSL_define b_GetScsiExtBuffer(dst_reg)
{
  p_ReadSPCReg(_SPC_EXBF_REG_ADDR, dst_reg);
}

/*------------- $B=q$-9~$_A`:n(B ---------------*/
#PSL_define b_SetScsiBusDeviceID(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_BDID_REG_ADDR);
}

#PSL_define b_SetScsiSPCCtrl(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_SCTL_REG_ADDR);
}

#PSL_define b_SetScsiCommand(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_SCMD_REG_ADDR);
}

#PSL_define b_SetScsiTransMode(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_TMOD_REG_ADDR);
}

#PSL_define b_SetScsiInterrupt(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_INTS_REG_ADDR);
}

#PSL_define b_SetScsiPhase(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_PSNS_REG_ADDR);
}

#PSL_define b_SetScsiPhaseCtrl(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_PCTL_REG_ADDR);
}

#PSL_define b_SetScsiByteCounter(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_MBC_REG_ADDR);
}

#PSL_define b_SetScsiDataReg(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_DREG_REG_ADDR);
}

#PSL_define b_SetScsiTempReg(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_TEMP_REG_ADDR);
}

#PSL_define b_SetScsiTransCtrHigh(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_TCH_REG_ADDR);
}

#PSL_define b_SetScsiTransCtrMid(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_TCM_REG_ADDR);
}

#PSL_define b_SetScsiTransCtrLow(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_TCL_REG_ADDR);
}

#PSL_define b_SetScsiExtBuffer(src_reg)
{
  p_WriteSPCReg(src_reg, _SPC_EXBF_REG_ADDR);
}

/******************************************************************** PSL **
2.1 SCSI$B%$%s%?%i%W%H$N%F%9%H(B

       written by f-doumae@icot22      on Mon Sep 17 15:33:18 1990
<Arguments>
    src_reg : SPC$B$N(BINTS$B%l%8%9%?$NCM$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#CTRL_define b_IfScsiAnyInterrupt()
{
  $USE(D_WorkSPCReg);
  b_GetScsiInterrupt(D_WorkSPCReg);
  p_Compare(D_WorkSPCReg, D_NULL);
  $RELEASE(D_WorkSPCReg);
  p_IfNE()
}

#CONST_define _SPC_INTS_RESET_CONDITION     0x01   /* 0000 0001 */
#CONST_define _SPC_INTS_SPC_HARDWARE_ERROR  0x02   /* 0000 0010 */
#CONST_define _SPC_INTS_TIME_OUT            0x04   /* 0000 0100 */
#CONST_define _SPC_INTS_SERVICE_REQUIRED    0x08   /* 0000 1000 */
#CONST_define _SPC_INTS_COMMAND_COMPLETE    0x10   /* 0001 0000 */
#CONST_define _SPC_INTS_DISCONNECTED        0x20   /* 0010 0000 */
#CONST_define _SPC_INTS_RESELECTED          0x40   /* 0100 0000 */
#CONST_define _SPC_INTS_SELECTED            0x80   /* 1000 0000 */
#CONST_define _SPC_INTS_SPC_HARDWARE_ERROR_XMASK   0xfd   /* 1111 1101 */

#CTRL_define b_IfScsiAnyInterruptExceptSPCHardwareError()
{
  $USE(D_WorkSPCReg);
  b_GetScsiInterrupt(D_WorkSPCReg);
  b_BitwiseAndImmediateWithDNTC
      (D_WorkSPCReg, _SPC_INTS_SPC_HARDWARE_ERROR_XMASK, D_VOID);
  $RELEASE(D_WorkSPCReg);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptCommandComplete(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_COMMAND_COMPLETE, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptSelected(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_SELECTED, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptReselected(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_RESELECTED, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptDisconnected(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_DISCONNECTED, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptServiceRequired(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_SERVICE_REQUIRED, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptTimeOut(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_TIME_OUT, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptSPCHardwareError(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_SPC_HARDWARE_ERROR, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiInterruptResetCondition(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_INTS_RESET_CONDITION, D_VOID);
  p_IfNE()
}

/******************************************************************** PSL **
2.2 SCSI$B%$%s%?%i%W%H$N%j%;%C%H(B

       written by f-doumae@icot22      on Mon Sep 17 17:08:36 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define D_WorkResetBit XXX

#PSL_define b_ResetScsiInterruptSelected()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_SELECTED, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#PSL_define b_ResetScsiInterruptReselected()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_RESELECTED, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#PSL_define b_ResetScsiInterruptDisconnected()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_DISCONNECTED, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#PSL_define b_ResetScsiInterruptCommandComplete()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_COMMAND_COMPLETE, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#CONST_define _SPC_INTERCEPT_TRANSFER_ON 0x08

#PSL_define b_ResetScsiInterruptServiceRequired()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTERCEPT_TRANSFER_ON, D_WorkResetBit);
  b_SetScsiCommand(D_WorkResetBit);
    /* Intercept Transfer = 1; Bus Release Command(No Operation) */
  p_SetImmediateValue(_SPC_INTS_SERVICE_REQUIRED, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#PSL_define b_ResetScsiInterruptTimeOut()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_TIME_OUT, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#PSL_define b_ResetScsiInterruptSPCHardwareError()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_SPC_HARDWARE_ERROR, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#PSL_define b_ResetScsiInterruptResetCondition()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_RESET_CONDITION, D_WorkResetBit);
  LOOP(){   /* RST In ? */
      b_IfScsiStatusRstIn(){
	  ;
      }else{
	  break;
      }
  }
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

#PSL_define b_ResetScsiInterruptReselectedAndDisconnected()
{
  $USE(D_WorkResetBit);
  p_SetImmediateValue(_SPC_INTS_RESELECTED, D_WorkResetBit);
  b_BitwiseOrImmediateWithDNTC
      (D_WorkResetBit, _SPC_INTS_DISCONNECTED, D_WorkResetBit);
  b_SetScsiInterrupt(D_WorkResetBit);
  $RELEASE(D_WorkResetBit);
}

/******************************************************************** PSL **
2.3 SCSI$B%$%s%?%i%W%H$NBT$A9g$o$;(B

       written by f-doumae@icot22      on Tue Sep 18 11:15:54 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define b_BusyWaitScsiInterrupt() 
{
  LOOP(){
      b_IfScsiAnyInterrupt(){
	  break;
      }
  }
}

#PSL_define b_BusyWaitScsiIntExcpHardErrWithWatchingTimer()
{
  /*  $B%?%$%`%"%&%H8!=P=hM}$,I,MW$H$J$k!#$?$@$7!"(BVPIM$B$G$3$l$r<B8=$9$k$3$H$K$O(B
      $B0UL#$,$J$$$N$G!">JN,$9$k!#(B($B<B5!0MB8(B)  */
    LOOP(){
	b_IfScsiAnyInterruptExceptSPCHardwareError(){ break; }
    }
}


/******************************************************************** PSL **
3. SCSI$B%9%F!<%?%9$N%F%9%H(B

       written by f-doumae@icot22      on Mon Sep 17 15:37:36 1990
<Arguments>
    src_reg : SPC$B$N(BSSTS$B%l%8%9%?$NCM$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#CONST_define  _SPC_SSTS_CONNECTED_AS_INITIATOR  0x80  /* 1000 0000 */
#CONST_define  _SPC_SSTS_CONNECTED_AS_TARGET     0x40  /* 0100 0000 */
#CONST_define  _SPC_SSTS_NOT_CONNECTED           0xc0  /* 0000 0000 */
#CONST_define  _SPC_SSTS_SPC_BUSY                0x20  /* 0010 0000 */
#CONST_define  _SPC_SSTS_DATA_BUFFER_EMPTY       0x01  /* 0000 0001 */
#CONST_define  _SPC_SSTS_DATA_BUFFER_FULL        0x02  /* 0000 0010 */
#CONST_define  _SPC_SSTS_RST_IN                  0x08  /* 0000 1000 */

#CTRL_define b_IfScsiStatusConnectedAsInitiator(src_reg)
{
  b_BitwiseAndImmediateWithDNTC
      (src_reg, _SPC_SSTS_CONNECTED_AS_INITIATOR, D_VOID);
  p_IfNE()
}

#CTRL_define b_IfScsiStatusConnectedAsTarget(src_reg)
{
  b_BitwiseAndImmediateWithDNTC
      (src_reg, _SPC_SSTS_CONNECTED_AS_TARGET, D_VOID); 
  p_IfNE()
}

#CTRL_define b_IfScsiStatusNotConnected(src_reg)
{
  b_BitwiseAndImmediateWithDNTC(src_reg, _SPC_SSTS_NOT_CONNECTED, D_VOID);
  p_IfEQ()
}

#CTRL_define b_IfSPCBusy()
{
  $USE(D_WorkStatus);
  b_GetScsiStatus(D_WorkStatus);
  b_BitwiseAndImmediateWithDNTC(D_WorkStatus, _SPC_SSTS_SPC_BUSY, D_VOID);
  $RELEASE(D_WorkStatus);
  p_IfNE()
}

#CTRL_define b_IfSPCNotBusy()
{
  $USE(D_WorkStatus);
  b_GetScsiStatus(D_WorkStatus);
  b_BitwiseAndImmediateWithDNTC(D_WorkStatus, _SPC_SSTS_SPC_BUSY, D_VOID);
  $RELEASE(D_WorkStatus);
  p_IfEQ()
}

#CTRL_define b_IfSPCDataBufferEmpty()
{
  $USE(D_WorkStatus);
  b_GetScsiStatus(D_WorkStatus);
  b_BitwiseAndImmediateWithDNTC
      (D_WorkStatus, _SPC_SSTS_DATA_BUFFER_EMPTY, D_VOID);
  $RELEASE(D_WorkStatus);
  p_IfNE()
}

#CTRL_define b_IfSPCDataBufferNotEmpty()
{
  $USE(D_WorkStatus);
  b_GetScsiStatus(D_WorkStatus);
  b_BitwiseAndImmediateWithDNTC
      (D_WorkStatus, _SPC_SSTS_DATA_BUFFER_EMPTY, D_VOID);
  $RELEASE(D_WorkStatus);
  p_IfEQ()
}

#CTRL_define b_IfSPCDataBufferNotFull()
{
  $USE(D_WorkStatus);
  b_GetScsiStatus(D_WorkStatus);
  b_BitwiseAndImmediateWithDNTC
      (D_WorkStatus, _SPC_SSTS_DATA_BUFFER_FULL, D_VOID);
  $RELEASE(D_WorkStatus);
  p_IfEQ()
}

#CTRL_define b_IfScsiStatusRstIn()
{
    $USE(D_WorkStatus);
    b_GetScsiStatus(D_WorkStatus);
    b_BitwiseAndImmediateWithDNTC(D_WorkStatus, _SPC_SSTS_RST_IN, D_VOID);
    $RELEASE(D_WorkStatus);
    p_IfNE()
}

#CTRL_define b_IfScsiStatusRstOff()
{
    $USE(D_WorkStatus);
    b_GetScsiStatus(D_WorkStatus);
    b_BitwiseAndImmediateWithDNTC(D_WorkStatus, _SPC_SSTS_RST_IN, D_VOID);
    $RELEASE(D_WorkStatus);
    p_IfEQ()
}


/******************************************************************** PSL **
4. SCSI$B%U%'!<%:$N%F%9%H(B

       written by f-doumae@icot22      on Mon Sep 17 15:47:28 1990
<Arguments>
    src_reg : SPC$B$N(BPSNS$B%l%8%9%?$NCM$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/*----- not used (Mar. 25, 1991) --------------
* SCSI$B%U%'!<%:(B SPC.PSNS$B%l%8%9%?(B:bit2-0 *
#CONST_define	_DATA_OUT_PHASE		0
#CONST_define	_DATA_IN_PHASE		1
#CONST_define	_COMMAND_PHASE		2
#CONST_define	_STATUS_PHASE		3
#CONST_define	_MESSAGE_OUT_PHASE	6
#CONST_define	_MESSAGE_IN_PHASE	7
-----------------------------------------------*/
#CONST_define	_DATA_OUT_PHASE		0x08
#CONST_define	_DATA_IN_PHASE		0x09
#CONST_define	_COMMAND_PHASE		0x0a
#CONST_define	_STATUS_PHASE		0x0b
#CONST_define	_MESSAGE_OUT_PHASE	0x0e
#CONST_define	_MESSAGE_IN_PHASE	0x0f
#CONST_define	_BUS_FREE_PHASE		0x00

#CONST_define _SPC_PSNS_REQ_ON   0x80  /* 1000 0000 */
#CONST_define _SPC_PSNS_ACK_ON   0x40  /* 0100 0000 */
#CONST_define _SPC_PSNS_ATN      0x20  /* 0010 0000 */
#CONST_define _SPC_PSNS_BSY_ON   0x08  /* 0000 1000 */
 
#CTRL_define b_IfScsiReqOn()
{
  $USE(D_WorkSPCReg);
  p_ReadSPCReg(_SPC_PSNS_REG_ADDR, D_WorkSPCReg);
  b_BitwiseAndImmediateWithDNTC(D_WorkSPCReg, _SPC_PSNS_REQ_ON, D_VOID);
  $RELEASE(D_WorkSPCReg);
  p_IfNE()
}

#CTRL_define b_IfScsiReqOff()
{
  $USE(D_WorkSPCReg);
  p_ReadSPCReg(_SPC_PSNS_REG_ADDR, D_WorkSPCReg);
  b_BitwiseAndImmediateWithDNTC(D_WorkSPCReg, _SPC_PSNS_REQ_ON, D_VOID);
  $RELEASE(D_WorkSPCReg);
  p_IfEQ()
}

#CTRL_define b_IfScsiAckOn()
{
  $USE(D_WorkSPCReg);
  p_ReadSPCReg(_SPC_PSNS_REG_ADDR, D_WorkSPCReg);
  b_BitwiseAndImmediateWithDNTC(D_WorkSPCReg, _SPC_PSNS_ACK_ON, D_VOID);
  $RELEASE(D_WorkSPCReg);
  p_IfNE()
}

#CTRL_define b_IfScsiAckOff()
{
  $USE(D_WorkSPCReg);
  p_ReadSPCReg(_SPC_PSNS_REG_ADDR, D_WorkSPCReg);
  b_BitwiseAndImmediateWithDNTC(D_WorkSPCReg, _SPC_PSNS_ACK_ON, D_VOID);
  $RELEASE(D_WorkSPCReg);
  p_IfEQ()
}

#CTRL_define b_IfScsiAttentionCondition()
{
  $USE(D_WorkSPCReg);
  p_ReadSPCReg(_SPC_PSNS_REG_ADDR, D_WorkSPCReg);
  b_BitwiseAndImmediateWithDNTC(D_WorkSPCReg, _SPC_PSNS_ATN, D_VOID);
  $RELEASE(D_WorkSPCReg);
  p_IfNE()
}

/******************************************************************** PSL **
5. $B$=$NB>(B
    $B!&%Q%j%F%#%(%i!<%A%'%C%/(B                   
    $B!&(BSPC$B%j%;%C%H(B                              
    $B!&%3%^%s%I$NH/9T(B                            
    $B!&%U%'!<%:$N@_Dj(B                            

       written by f-doumae@icot22      on Wed Sep 19 14:16:53 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* SERR$B%l%8%9%?$N(BData Error$B%S%C%H$N%A%'%C%/(B */
#CONST_define _SPC_SERR_DATA_ERROR  0xc0  /* 1100 0000 */

#CTRL_define b_IfScsiParityError() 
{
  $USE(D_WorkSPCReg);
  b_GetScsiErr(D_WorkSPCReg);
  b_BitwiseAndImmediateWithDNTC(D_WorkSPCReg, _SPC_SERR_DATA_ERROR, D_VOID);
  $RELEASE(D_WorkSPCReg);
  p_IfNE()
}

/* SERR$B%l%8%9%?$N%j%;%C%H(B */
#PSL_define b_ResetScsiErrorReg()
{
    b_ResetScsiInterruptSPCHardwareError();
}

/*     SPC$B$N%j%;%C%H(B     */
#CONST_define _SPC_SCTL_RESET_AND_DISABLE  0x80 /* 1000 0000 */
#CONST_define _SPC_SCTL_CONTROL_RESET	   0x40 /* 0010 0000 */

#PSL_define b_ScsiSPCControlReset()
{
  $USE(D_WorkSPCReg);
  b_GetScsiSPCCtrl(D_WorkSPCReg);
  b_BitwiseOrImmediateWithDNTC
      (D_WorkSPCReg, _SPC_SCTL_CONTROL_RESET, D_WorkSPCReg);
  /* SCTL$B%l%8%9%?$N(BControl Reset$B%S%C%H$r(BON$B$K$9$k!#(B */
  b_SetScsiSPCCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_ScsiSPCResetAndDisable()
{
  $USE(D_WorkSPCReg);
  b_GetScsiSPCCtrl(D_WorkSPCReg);
  b_BitwiseOrImmediateWithDNTC
      (D_WorkSPCReg,_SPC_SCTL_RESET_AND_DISABLE, D_WorkSPCReg);
  /* SCTL$B%l%8%9%?$N(BReset & Disable$B%S%C%H$r(BON$B$K$9$k!#(B*/
  b_SetScsiSPCCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

/*------  SPC$B%3%^%s%I$NH/9T(B -------*/
#CONST_define _SPC_COMMAND_BUS_RELEASE 0x00 /* 0000 0000 */
#CONST_define _SPC_COMMAND_SELECT      0x20 /* 0010 0000 */
#CONST_define _SPC_COMMAND_RESET_ATN   0x40 /* 0100 0000 */
#CONST_define _SPC_COMMAND_SET_ATN     0x60 /* 0110 0000 */
#CONST_define _SPC_COMMAND_TRANSFER_I  0x84 /* 1000 0100 */
#CONST_define _SPC_COMMAND_TRANSFER_T  0x85 /* 1000 0101 */
#CONST_define _SPC_COMMAND_RESET_ACK   0xc0 /* 1100 0000 */
#CONST_define _SPC_COMMAND_RESET_REQ   _SPC_COMMAND_RESET_ACK   
#CONST_define _SPC_COMMAND_SET_ACK     0xe0 /* 1110 0000 */
#CONST_define _SPC_COMMAND_SET_REQ     _SPC_COMMAND_SET_ACK     
#CONST_define _SPC_COMMAND_TRANSFER_PAUSE 0xa0 /* 1010 0000 */

#PSL_define b_SPCCommandBusRelease()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_BUS_RELEASE, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandSelect()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_SELECT, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandResetATN()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_RESET_ATN, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandSetATN()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_SET_ATN, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandInitiatorTransfer()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_TRANSFER_I, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandTargetTransfer()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_TRANSFER_T, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandTransferPause()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_TRANSFER_PAUSE, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandSetAck()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_SET_ACK, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandSetReq()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_SET_REQ, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandResetAck()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_RESET_ACK, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SPCCommandResetReq()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_COMMAND_RESET_REQ, D_WorkSPCReg);
  b_SetScsiCommand(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

/*-- $B%U%'!<%:$N@_Dj(B --*/
#CONST_define _SPC_PCTL_SELECTION_PHASE     0x60 /* 0110 0000 */
#CONST_define _SPC_PCTL_RESELECTION_PHASE   0x61 /* 0110 0001 */
#CONST_define _SPC_PCTL_DATA_OUT_PHASE      0x60 /* 0110 0000 */
#CONST_define _SPC_PCTL_DATA_IN_PHASE       0x61 /* 0110 0001 */
#CONST_define _SPC_PCTL_COMMAND_PHASE       0x62 /* 0110 0010 */
#CONST_define _SPC_PCTL_STATUS_PHASE        0x63 /* 0110 0011 */
#CONST_define _SPC_PCTL_MSG_OUT_PHASE       0x66 /* 0110 0110 */
#CONST_define _SPC_PCTL_MSG_IN_PHASE        0x67 /* 0110 0111 */
/* Bus Free Interrupt Enable */
#CONST_define _SPC_PCTL_BUS_FREE_INTERRUPT_ON	0xe0
#CONST_define _SPC_PCTL_BUS_FREE_INTERRUPT_OFF	0x60

#PSL_define b_SetScsiPhaseSelection()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_SELECTION_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiPhaseReselection()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_RESELECTION_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiPhaseCommand()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_COMMAND_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiPhaseDataIn()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_DATA_IN_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiPhaseDataOut()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_DATA_OUT_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiPhaseMsgIn()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_MSG_IN_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiPhaseMsgOut()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_MSG_OUT_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiPhaseStatus()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_STATUS_PHASE, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

/* Bus Free Interrrupt Enable Mode On/Off */
#PSL_define b_SetScsiBusFreeInterruptOn()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_BUS_FREE_INTERRUPT_ON, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

#PSL_define b_SetScsiBusFreeInterruptOff()
{
  $USE(D_WorkSPCReg);
  b_SetImmValueDNTC(_SPC_PCTL_BUS_FREE_INTERRUPT_OFF, D_WorkSPCReg);
  b_SetScsiPhaseCtrl(D_WorkSPCReg);
  $RELEASE(D_WorkSPCReg);
}

/* Inhibit Interruption Mode */
#PSL_define b_SetScsiInterruptEnable()
{
    b_ScsiSPCResetAndDisable();
}

/*---------------------------------------------------------------------
   VPIM$BN)$A>e$2;~$K(B-S$B%*%W%7%g%s$G(B0$B0J30$NCM$K(B(Master PE$B$K$D$$$F$N$_(B)$B@_Dj$5$l$k!#(B
-----------------------------------------------------------------------*/
#DATA_define D_ScsiAvailable   XXX

#CTRL_define b_IfScsiAvailable()
{
    b_IfNotZero(D_ScsiAvailable)
}
