
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_spc_command.psl.c
   ----- CREATED   : by f-doumae@icot22, on Mon Nov 19 16:06:29 1990
   ----- LAST SAVED: by f-takei@icot22, on Thu May 14 22:09:53 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : SPC$B%3%^%s%I$NH/9T(B

  SPC$B%X$N%3%^%s%I$NH/9T5Z$S$=$l$KH<$&=hM}$r9T$&%^%/%m!#(B
  bsc_spc_reg_ope.psl.c$B$GDj5A$5$l$k%^%/%m$N>e0L%l%Y%k!#(B
  $B!&(Bb_ScsiSelection
  $B!&(Bb_ScsiReselection
    - $B0J>e$N(B2$B$D$O(BSelect$B%3%^%s%IH/9T$H=i4|@_Dj(B
  $B!&(Bb_ScsiSetATN
  $B!&(Bb_ScsiResetATN
    - Set/Reset ATN$B%3%^%s%I$NH/9T(B
  $B!&(Bb_InitiatorTransferCommandXXX
  $B!&(Bb_TargetTransferCommandXXX
    - $B%^%/%mL>$N0lIt(B(XXX)$B$KI=5-$5$l$k%U%'!<%:$G$N(BTransfer$B%3%^%s%I$NH/9T$H(B
      $B=i4|@_Dj(B
  $B!&(Bb_TransferPauseInput
  $B!&(Bb_TransferPauseOutput
    - Transfer Pause$B%3%^%s%I$NH/9T$H8e=hM}(B
  $B!&(Bb_ScsiSetAck/Req
  $B!&(Bb_ScsiResetAck/Req
    - Set Ack/Req, Reset Ack/Req$B%3%^%s%I$NH/9T(B
  $B!&(Bb_ScsiBusReleaseCommand
    - Bus Release$B%3%^%s%I$NH/9T(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/* Work Register */
#DATA_define  D_WorkTargetID   XXX
#DATA_define  D_WorkInitID     XXX
#DATA_define  D_WorkDataCtr    XXX
#DATA_define  D_WorkDataCtr1   XXX
#DATA_define  D_WorkDataCtr2   XXX
/* Constant */
#CONST_define  _TIMEOUT_DELAY              4
#CONST_define  _SELECT_COMMAND_WATING_TIME 4
#CONST_define  _TRANSFER_MODE              0x00
#CONST_define  _SHIFT_LEN_24               24
#CONST_define  _SHIFT_LEN_16               16
#CONST_define  _SHIFT_LEN_8                8
#CONST_define  _MASK_OF_SCSI_1BYTE_DATA    0xff
#CONST_define  _MASK_OF_LUN		   0x07
#CONST_define  _BYTE_CTR_REG_LOW_4BIT	   0x0f
#CONST_define  _MOD_BYTE_CTR_REG	   0x0f

#PSL_define b_ScsiSelection(unit_reg)
{
    b_SetScsiPhaseSelection();
    /* $B%;%l%/%7%g%s!&%U%'!<%:$N;XDj(B */
    $USE(D_WorkID);
    p_MoveWord(D_ONE, D_WorkID);
    $USE(D_WorkTargetID);
    b_ShiftLeftWithDNTC(D_WorkID, unit_reg, D_WorkTargetID);
    $USE(D_WorkInitID);
    b_GetScsiBusDeviceID(D_WorkInitID);
    b_BitwiseOrWithDNTC(D_WorkInitID, D_WorkTargetID, D_WorkID);
    b_SetScsiTempReg(D_WorkID);
    $RELEASE(D_WorkID);
    $RELEASE(D_WorkTargetID);
    $RELEASE(D_WorkInitID);
    /* $B%?%$%`%"%&%H8!=P;~4V$N@_Dj(B */
    b_SetScsiByteCounter(D_NULL);
    b_SetScsiTransCtrHigh(D_NULL);
    $USE(D_WorkDataCtr);
    b_SetImmValueDNTC(_TIMEOUT_DELAY, D_WorkDataCtr);
    b_SetScsiTransCtrMid(D_WorkDataCtr);
    /* TCL$B%l%8%9%?$N@_Dj(B */
    b_SetImmValueDNTC(_SELECT_COMMAND_WATING_TIME, D_WorkDataCtr);
    b_SetScsiTransCtrLow(D_WorkDataCtr);
    $RELEASE(D_WorkDataCtr);
    b_SPCCommandSelect();
}

#PSL_define b_ScsiReselection(unit_reg)
{
    b_SetScsiPhaseReselection();
    /* $B%j%;%l%/%7%g%s!&%U%'!<%:$N;XDj(B */
    $USE(D_WorkID);
    p_MoveWord(D_ONE, D_WorkID);
    $USE(D_WorkInitID);
    b_ShiftLeftWithDNTC(D_WorkID, unit_reg, D_WorkInitID);
    $USE(D_WorkTargetID);
    b_GetScsiBusDeviceID(D_WorkTargetID);
    b_BitwiseOrWithDNTC(D_WorkTargetID, D_WorkInitID, D_WorkID);
    b_SetScsiTempReg(D_WorkID);
    $RELEASE(D_WorkID);
    $RELEASE(D_WorkTargetID);
    $RELEASE(D_WorkInitID);
    /* $B%?%$%`%"%&%H8!=P;~4V$N@_Dj(B */
    b_SetScsiByteCounter(D_NULL);
    b_SetScsiTransCtrHigh(D_NULL);
    $USE(D_WorkDataCtr);
    b_SetImmValueDNTC(_TIMEOUT_DELAY, D_WorkDataCtr);
    b_SetScsiTransCtrMid(D_WorkDataCtr);
    /* TCL$B%l%8%9%?$N@_Dj(B */
    b_SetImmValueDNTC(_SELECT_COMMAND_WATING_TIME, D_WorkDataCtr);
    b_SetScsiTransCtrLow(D_WorkDataCtr);
    $RELEASE(D_WorkDataCtr);
    b_SPCCommandSelect();
}

#PSL_define b_ScsiSetATN()
{
    b_SPCCommandSetATN();
}

#PSL_define b_ScsiResetATN()
{
    b_SPCCommandResetATN();
}

#PSL_define b_SetConditionForTransferCommand(data_len_reg)
{
    /* $BE>Aw%b!<%I$J$I$N@_Dj(B : TMOD */
    $USE(D_WorkReg);
    b_SetImmValueDNTC(_TRANSFER_MODE, D_WorkReg);
    b_SetScsiTransMode(D_WorkReg);
    $RELEASE(D_WorkReg);
       /* $BF14|!&HsF14|E>Aw!"E>Aw%P%$%H%+%&%s%?D9$N;XDj(B */

    /* $BE>Aw%P%$%H?t$N;XDj(B : TCH, TCM, TCL */
    $USE(D_WorkDataCtr);
    /* Exteded Transfer Counter$B$N%;%C%H(B */
    b_SetScsiByteCounter(D_NULL); /* not use TCE */
    /* $B>e0L(B1byte$B$N%;%C%H(B */
    b_ShiftRightImmediateWithDNTC(data_len_reg, _SHIFT_LEN_16, D_WorkDataCtr);
    b_BitwiseAndImmediateWithDNTC(D_WorkDataCtr, _MASK_OF_SCSI_1BYTE_DATA,
			  D_WorkDataCtr);
    b_SetScsiTransCtrHigh(D_WorkDataCtr);
    /* $BCf0L(B1byte$B$N%;%C%H(B */
    b_ShiftRightImmediateWithDNTC(data_len_reg, _SHIFT_LEN_8, D_WorkDataCtr);
    b_BitwiseAndImmediateWithDNTC(D_WorkDataCtr, _MASK_OF_SCSI_1BYTE_DATA,
			  D_WorkDataCtr);
    b_SetScsiTransCtrMid(D_WorkDataCtr);
    /* $B2<0L(B1byte$B$N%;%C%H(B */
    b_BitwiseAndImmediateWithDNTC(data_len_reg, _MASK_OF_SCSI_1BYTE_DATA,
			  D_WorkDataCtr);
    b_SetScsiTransCtrLow(D_WorkDataCtr);
    $RELEASE(D_WorkDataCtr);
}

#PSL_define b_InitiatorTransferCommandCommand(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseCommand();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandInitiatorTransfer();
}

#PSL_define b_TargetTransferCommandCommand(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseCommand();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandTargetTransfer();
}

#PSL_define b_InitiatorTransferCommandDataIn(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseDataIn();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandInitiatorTransfer();
}

#PSL_define b_TargetTransferCommandDataIn(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseDataIn();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandTargetTransfer();
}

#PSL_define b_InitiatorTransferCommandDataOut(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseDataOut();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandInitiatorTransfer();
}

#PSL_define b_TargetTransferCommandDataOut(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseDataOut();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandTargetTransfer();
}

#PSL_define b_InitiatorTransferCommandMessageIn(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseMsgIn();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandInitiatorTransfer();
}

#PSL_define b_TargetTransferCommandMessageIn(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseMsgIn();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandTargetTransfer();
}

#PSL_define b_InitiatorTransferCommandMessageOut(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseMsgOut();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandInitiatorTransfer();
}

#PSL_define b_TargetTransferCommandMessageOut(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseMsgOut();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandTargetTransfer();
}

#PSL_define b_InitiatorTransferCommandStatus()
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseStatus();

    /* $BE>Aw%b!<%I$J$I$N@_Dj(B : TMOD */
    $USE(D_WorkReg);
    b_SetImmValueDNTC(_TRANSFER_MODE, D_WorkReg);
    b_SetScsiTransMode(D_WorkReg); 
    $RELEASE(D_WorkReg);
      /* $BF14|!&HsF14|E>Aw!"E>Aw%P%$%H%+%&%s%?D9$N;XDj(B */

    /* $BE>Aw%P%$%H?t$N;XDj(B : TCH, TCM, TCL */
    /* Exteded Transfer Counter$B$N%;%C%H(B */
    b_SetScsiByteCounter(D_NULL); /* not use TCE */
    /* $B>e0L(B1byte$B$N%;%C%H(B */
    b_SetScsiTransCtrHigh(D_NULL);
    /* $BCf0L(B1byte$B$N%;%C%H(B */
    b_SetScsiTransCtrMid(D_NULL);
    /* $B2<0L(B1byte$B$N%;%C%H(B */
    b_SetScsiTransCtrLow(D_ONE);

    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandInitiatorTransfer();
}
 
#PSL_define b_TargetTransferCommandStatus(data_len_reg)
{
    /* $B%U%'!<%:$N@_Dj(B : PCTL */
    b_SetScsiPhaseStatus();
    /* $B$=$NB>$N@_Dj(B */
    b_SetConditionForTransferCommand(data_len_reg);
    /* Transfer$B%3%^%s%I$NH/9T(B : SCMD */
    b_SPCCommandTargetTransfer();
}

#PSL_define b_ScsiTransferPauseInput()
{
    b_SPCCommandTransferPause();
    LOOP(){
	b_IfSPCDataBufferEmpty(){
	    break;
	}
	b_GetScsiDataReg(D_VOID);
	/* $B;DM>%G!<%?$OFI$_<N$F(B? */
    }
}

#PSL_define b_ScsiTransferPauseOutput()
{
    b_SPCCommandTransferPause();
    b_BusyWaitUntilSPCNotBusy();
}

#PSL_define b_ScsiSetAck()
{
    b_SPCCommandSetAck();
}

#PSL_define b_ScsiSetReq()
{
    b_SPCCommandSetReq();
}

#PSL_define b_ScsiResetAck()
{
    b_SPCCommandResetAck();
}

#PSL_define b_ScsiResetReq()
{
    b_SPCCommandResetReq();
}

#PSL_define b_ScsiBusReleaseCommand()
{
    b_SPCCommandBusRelease();
}

#PSL_define b_CountScsiLeftDataOnDataBuffer(data_len_reg)
{
    $USE(D_WorkDataCtr1);
    b_GetScsiTransCtrLow(D_WorkDataCtr1);
    b_BitwiseAndImmediateWithDNTC
	(D_WorkDataCtr1, _BYTE_CTR_REG_LOW_4BIT, D_WorkDataCtr1);
    $USE(D_WorkDataCtr2);
    b_GetScsiByteCounter(D_WorkDataCtr2);
    b_BitwiseAndImmediateWithDNTC
	(D_WorkDataCtr2, _MOD_BYTE_CTR_REG, D_WorkDataCtr2);
    $USE(D_WorkDataCtr);
    b_SubtractWithDNTC(D_WorkDataCtr1, D_WorkDataCtr2, D_WorkDataCtr);
    $RELEASE(D_WorkDataCtr2);
    $RELEASE(D_WorkDataCtr1);
    b_IfGreaterEq(D_WorkDataCtr, D_NULL){
	p_MoveWord(D_WorkDataCtr, data_len_reg);
    }else{
	b_AddImmediateWithDNTC(D_WorkDataCtr, _BYTE16, data_len_reg);
    }
    $RELEASE(D_WorkDataCtr);
}

#PSL_define b_GetScsiLUNFromIdentify(msg_reg)
{
    b_BitwiseAndImmediateWithDNTC(msg_reg, _MASK_OF_LUN, msg_reg);
}

#PSL_define b_GetScsiLUNFromExIdentify(msg_reg, ex_msg_reg)
{
    b_BitwiseAndImmediateWithDNTC(msg_reg, _MASK_OF_LUN, msg_reg);
    b_ShiftLeftImmediateWithDNTC(msg_reg, _SHIFT_LEN_8, msg_reg);
    b_BitwiseOrWithDNTC(msg_reg, ex_msg_reg, msg_reg);
}

#CTRL_define b_IfScsiIdentifyMsg(msg_reg)
{
    p_CompareImmediate(msg_reg, _MIN_IDENTIFY_MSG);
    p_IfGE() { 
	p_CompareImmediate(msg_reg, _MAX_IDENTIFY_MSG);
	p_IfLE() {
	    b_SetSuccess();
	} else { b_SetFail();}
    } else { b_SetFail();}
    b_IfSuccess()
}

#PSL_define b_BusyWaitUntilSPCNotBusy()
{
    LOOP(){
	b_IfSPCNotBusy(){
	    break;
	}
    }
}

#PSL_define b_BusyWaitUntilAckOn()
{
    LOOP(){
	b_IfScsiAckOn(){ break; }
    }
}

#PSL_define b_BusyWaitUntilReqOff()
{
    LOOP(){
	b_IfScsiReqOff(){ break; }
    }
}

#PSL_define b_BusyWaitScsiRSTOff()
{
  LOOP(){
      b_IfScsiStatusRstOff(){
	  break;
      }
  }
}
