
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_slit_check.psl.c
   ----- CREATED   : by f-doumae@icot22, on Tue May 29 20:53:04 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Oct 28 14:40:39 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : basics
   ----- ABSTRACT  : PIM/s$B$N%9%j%C%H%A%'%C%/%l%8%9%?$H%7%0%J%k(B

  $B!&(BPIM$B$N<B5!$K$*$$$F$O(B, 
	1. $B%9%j%C%H%A%'%C%/%l%8%9%?$O(B, KL1$B=hM}7O$K$*$1$k3d$j9~$_=hM}$N$?$a$K(B
	   $B@lMQ%l%8%9%?$H$7$FMQ0U$5$l$F$$$k(B.
    $B$H2>Dj$7(B, $B%9%j%C%H%A%'%C%/%l%8%9%?$N3F%S%C%H$K$O(B, 
 	2. $B%O!<%I%&%'%"$K$h$C$F%;%C%H$5$l$k$b$N(B,
	  (ex. $B%M%C%H%o!<%/$+$i$N3d$j9~$_(B see bsc_ext_int.psl.c)
	3. $B%W%m%;%C%5FbIt$G@8$8$?%=%U%H%&%'%"3d$j9~$_$KAjEv$9$k$b$N(B,
	4. $B%W%m%;%C%54VDL?.$N$?$a$N(B SIGNAL$BL?Na$G%;%C%H$9$k$b$N(B,
    $B$,$"$k$H$9$k(B.
  $B!&K\%b%8%e!<%k$G$O(B, $B>e5-$N$h$&$J%O!<%I%&%'%"5!9=$H$7$F$N%9%j%C%H%A%'%C%/%l%8(B
    $B%9%?$r(BVPIM$B$K$*$$$F%7%_%e%l!<%H$9$k$?$a$N%^%/%m$rDj5A$9$k(B.

1.  $B%9%j%C%H%A%'%C%/%l%8%9%?(B
2.  $B%9%j%C%H%A%'%C%/%l%8%9%?$KBP$9$kA`:n(B ($B%W%m%;%C%54V%7%0%J%kL?Na$NLN5<(B)
3.  $B%9%j%C%H%A%'%C%/H=Dj$H%9%j%C%H%A%'%C%/%l%8%9%?(B(SCR)$B$NFI$_$@$7(B
4.  $B%9%j%C%H%A%'%C%/%l%8%9%?$N=i4|2=(B
5.  $B3d$j9~$_MW0x$N%;%C%H!&%j%;%C%H(B
6.  $BMW0xJ,@O$N4pK\%^%/%m(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1.  $B%9%j%C%H%A%'%C%/%l%8%9%?(B

       written by f-doumae@icot22      on Wed May 30 10:44:38 1990

<Explanation>
  $B!&%9%j%C%H%A%'%C%/%l%8%9%?(B(SCR) $B$K$O(B, $B8DJL$K%;%C%H(B/$B%j%;%C%H$G$-$kMW0x%U%i%0$,(B
    $B%$%Y%s%H$N?t(B($B8=:_(B16$B8D(B)$B$@$1$"$k$b$N$H$9$k!#(B
  $B!&%9%j%C%H%A%'%C%/$N;v>]H/@8$O%9%j%C%H%A%'%C%/%U%i%0$K$h$jCN$k$3$H$,$G$-$k(B.
  $B!&MW0xJ,@O$OHFMQ%l%8%9%?(B(D_WorkSCR)$B$K%m!<%I$7$F$+$i9T$&!#(B
  $B!&%9%j%C%H%A%'%C%/%l%8%9%?$NMW0x%U%i%0$H%$%Y%s%H(BID$B$H$NBP1~$E$1$r9T$J$&!#(B
<ETC>
********************************************************************* PSL **/
#CONST_define _SCR_FLAG_0	    0 
#CONST_define _SCR_FLAG_1	    1 
#CONST_define _SCR_FLAG_2	    2 
#CONST_define _SCR_FLAG_3	    3 
#CONST_define _SCR_FLAG_4	    4 
#CONST_define _SCR_FLAG_5	    5 
#CONST_define _SCR_FLAG_6	    6 
#CONST_define _SCR_FLAG_7	    7 
#CONST_define _SCR_FLAG_8	    8 
#CONST_define _SCR_FLAG_9           9
#CONST_define _SCR_FLAG_10         10
#CONST_define _SCR_FLAG_11         11
#CONST_define _SCR_FLAG_12         12
#CONST_define _SCR_FLAG_13         13
#CONST_define _SCR_FLAG_14         14
#CONST_define _SCR_FLAG_15         15
#CONST_define _SCR_FLAG_16         16

                                              /*   scr bits    */
#CONST_define _EXT_INT_MASK        0x0000000f /* 0000 0000 0000 0000 1111 */
#CONST_define _SIGNAL_PE_MASK      0x000003f0 /* 0000 0000 0011 1111 0000 */
#CONST_define _SELF_INT_MASK       0x0001fc00 /* 0001 1111 1100 0000 0000 */

/*   external interrupt group   */
#CONST_define  _NW_MSG_PACKET_ARV_EVENT         _SCR_FLAG_0
#CONST_define  _TIMER_INT_EVENT                 _SCR_FLAG_1
#CONST_define  _SPC_INT_EVENT                   _SCR_FLAG_2
#CONST_define  _TIMER_ALARM_EVENT               _SCR_FLAG_3

/*   Signal PE interrupt group  */
#CONST_define  _ALL_SYNCHRONIZE_EVENT           _SCR_FLAG_4
#CONST_define  _FP_STATUS_CHECK_EVENT           _SCR_FLAG_5      
#CONST_define  _GOAL_REQ_EVENT                  _SCR_FLAG_6
#CONST_define  _THROW_GOAL_EVENT                _SCR_FLAG_7
#CONST_define  _SERIAL_EXEC_EVENT               _SCR_FLAG_8
#CONST_define  _PROCESSOR_PROFILE_CHANGE_EVENT	_SCR_FLAG_9

/*    self interrupt group     */
#CONST_define  _HIGH_PRIO_GOAL_EVENT            _SCR_FLAG_10
#CONST_define  _FP_STAT_GATHER_EVENT            _SCR_FLAG_11
#CONST_define  _PAGE_ALLOC_FAIL_EVENT           _SCR_FLAG_12
#CONST_define  _RESOURCE_CACHE_EXHAUST_EVENT    _SCR_FLAG_13
#CONST_define  _NETWORK_BUFFER_FULL_EVENT       _SCR_FLAG_14
#CONST_define  _SCSI_DEFERRED_EXEC_EVENT        _SCR_FLAG_15
#CONST_define  _HEAP_ALERT_EVENT                _SCR_FLAG_16

/******************************************************************** PSL **
2. $B%9%j%C%H%A%'%C%/%l%8%9%?$KBP$9$kA`:n(B ($B%W%m%;%C%54V%7%0%J%kL?Na$NLN5<(B)

       written by f-doumae@icot22      on Wed May 30 11:32:43 1990
<Arguments>
  imm_signal_pos : $B%7%0%J%k$N0UL#$KAjEv$9$k(BSCR$BFb$N%S%C%H0LCV(B (Bit 3 $B!A(B 7)
  dest_pe_num : $B%7%0%J%k$rAw?.$9$kAj<j$N(BPE$BHV9f(B($B%l%8%9%?(B?)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  b_SignalOnSCR	(imm_signal_pos,dest_pe_num) : 
  	$BAj<j(BPE (dest_pe_num) $B$r0l$D;XDj$7(B, "imm_signal_pos"$B$N%7%0%J%k(BON$B$rAw?.(B
  b_AllSignalOnSCR (imm_signal_pos) :
  	$B%/%i%9%?Fb$NA4(BPE$B$KBP$7$F(B, "imm_signal_pos"$B$N%7%0%J%k(BON$B$rAw?.$9$k(B
  b_SignalOffSCR (imm_signal_pos,dest_pe_num) : 
  	$BAj<j(BPE (dest_pe_num) $B$r0l$D;XDj$7(B, "imm_signal_pos"$B$N%7%0%J%k(BOFF$B$rAw?.(B
  b_AllSignalOffSCR (imm_signal_pos) :
  	$B%/%i%9%?Fb$NA4(BPE$B$KBP$7$F(B, "imm_signal_pos"$B$N%7%0%J%k(BOFF$B$rAw?.$9$k(B
  b_BusyWaitSCROn (imm_signal_pos) :
        
<Examples>
<Test>
<Explanation>
  $BK\%^%/%m$O(B, $B%/%i%9%?Fb$G$N%W%m%;%C%54V%7%0%J%kL?Na$rLN5<$9$k$b$N$G$"$k(B.
  $B!&%/%i%9%?FbA4(BPE$B$H$O(B, $BAw?.$9$k<+(BPE$B$r4^$`(B.
  $B!&(Bdest_pe_num $B$H$7$F<+(BPE$B$r;XDj$9$k$3$H$b$G$-$k(B.
<ETC>
********************************************************************* PSL **/
#PSL_define b_SignalOnSCR	(imm_signal_pos,dest_pe_num)
{
  p_SetSCRBitImmPosition	(imm_signal_pos,dest_pe_num);
}

#PSL_define b_AllSignalOnSCR	(imm_signal_pos)
{
  p_SetSCRBitImmPositionAll	(imm_signal_pos);
}

#PSL_define b_SignalOffSCR	(imm_signal_pos,dest_pe_num)
{
  p_ResetSCRBitImmPosition	(imm_signal_pos,dest_pe_num);
}

#PSL_define b_AllSignalOffSCR	(imm_signal_pos)
{
  p_ResetSCRBitImmPositionAll	(imm_signal_pos);
}

/******************************************************************** PSL **
3.  $B%9%j%C%H%A%'%C%/H=Dj$H%9%j%C%H%A%'%C%/%l%8%9%?(B(SCR)$B$NFI$_$@$7(B
 
      written by f-doumae@icot22      on Wed May 30 11:43:23 1990
<Arguments>
  imm_scr_pos : SCR$BFb$N%S%C%H0LCV(B ($BB(CM(B)
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  b_IfEventFlagOn () : $B;v>](B(event)$B$,@85/$7$?$+$I$&$+$NH=Dj(B
  b_GetSCR (dst_reg) : dst_reg $B$K%9%j%C%H%A%'%C%/%l%8%9%?$NCM$rFI$_=P$9(B.
<Examples>
<Test>
<Explanation>
  $B%9%j%C%H%A%'%C%/%l%8%9%?$N%S%C%HH=Dj$G$O(B,  $BKh2s(B, $B%9%j%C%H%A%'%C%/%l%8%9%?$N(B
  $BFbMF$r%o!<%/%l%8%9%?$KFI$_=P$9(B.
<ETC>
********************************************************************* PSL **/
#CTRL_define b_IfEventFlagOn	()
{
  p_IfSCFON()
}

#PSL_define b_GetSCR (dst_reg)
{
  p_GetSCR (dst_reg);
}

/******************************************************************** PSL **
4.  $B%9%j%C%H%A%'%C%/%l%8%9%?$N=i4|2=(B

       written by f-doumae@icot22      on Wed May 30 13:13:05 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  SCR $B$r=i4|2=$9$k(B
<Examples>
<Test>
<Explanation>
  i_InitVpimReg () $B$K$*$$$F8F$S=P$9(B
<ETC>
********************************************************************* PSL **/
#PSL_define b_InitSCR ()
{
  p_ResetSCRBitImmPosition (_SCR_FLAG_0, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_1, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_2, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_3, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_4, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_5, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_6, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_7, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_8, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_9, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_10, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_11, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_12, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_13, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_14, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_15, D_PE_Number);
  p_ResetSCRBitImmPosition (_SCR_FLAG_16, D_PE_Number);
}

/******************************************************************** PSL **
5. $B3d$j9~$_MW0x$N%;%C%H!&%j%;%C%H(B

       written by f-doumae@icot22      on Wed May 30 15:06:31 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#PSL_define b_SetEventFlag(imm_event_id, pe_num_reg)
{
  b_SignalOnSCR(imm_event_id, pe_num_reg);
}

#PSL_define b_ResetEventFlag(imm_event_id, pe_num_reg)
{
  b_SignalOffSCR(imm_event_id, pe_num_reg);
}

/******************************************************************** PSL **
6. $BMW0xJ,@O$N4pK\%^%/%m(B

       written by f-doumae@icot22      on Thu May 31 14:10:40 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
o<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#CTRL_define b_IfEventFlagOnWithImmMsk (imm_mask)
{
  $USE(D_WorkSCR);
  b_GetSCR(D_WorkSCR);
  b_BitwiseAndImmediateWithDNTC (D_WorkSCR, imm_mask, D_VOID);
  $RELEASE(D_WorkSCR);
  p_IfNE()
}

#CTRL_define b_IfEventFlagOnImmPos (imm_scr_pos)
{
  $USE(D_WorkFlagReg);
  p_SetImmediateValue (imm_scr_pos, D_WorkFlagReg);
  @DEBUG { 
    b_IfRangeErr (D_WorkFlagReg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_IfEventFlagOnImmPos", "Illegal flag position");}
  };
  b_ShiftLeftWithDNTC(D_ONE, D_WorkFlagReg, D_WorkFlagReg);
  $USE(D_WorkSCR);
  b_GetSCR(D_WorkSCR);
  b_BitwiseAndWithDNTC (D_WorkSCR, D_WorkFlagReg, D_VOID);
  $RELEASE(D_WorkSCR);
  $RELEASE(D_WorkFlagReg);
  p_IfNE ()
}
