  
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_scsi_transfer.psl.c
   ----- CREATED   : by f-takei@icot22, on Mon Sep 10 19:48:47 1990
   ----- LAST SAVED: by f-takei@icot22, on Thu Nov 14 10:54:59 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B>pJsE>Aw$KH<$&A`:n(B

1.$B%?!<%2%C%H;~$N>pJsE>Aw(B
2.$B%$%K%7%(!<%?;~$N>pJsE>Aw(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define D_WorkMsg1   XXX
#DATA_define D_WorkMsg2   XXX
#DATA_define  D_WorkGrpCode   XXX

#CONST_define	_MASK_OF_CDB_LEN			0xe0
#CONST_define	_CDB_GRP0				0
#CONST_define	_CDB_GRP1				0x20
#CONST_define	_CDB_GRP5				0xa0
#CONST_define	_CDB_6_BYTE				6
#CONST_define	_CDB_10_BYTE				10
#CONST_define	_CDB_12_BYTE				12

/******************************************************************** PSL **
1.$B%?!<%2%C%H;~$N>pJsE>Aw(B
       written by f-takei@icot22      on Tue Sep 25 19:15:17 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%?!<%2%C%H;~$N>pJsE>Aw$N$?$a$N%^%/%m!#(B
  $B!&(Bb_ScsiTargetSendIdentify
  $B!&(Bb_ScsiTargetSendExIdentify
      - $B%U%'!<%:$N@_Dj!"(BTransfer$B%3%^%s%I$NH/9T!"%G!<%?$NE>Aw(B
  $B!&(Bb_ScsiTargetSendMessageByManual
      - $B%U%'!<%:$N@_Dj!"%G!<%?$NE>Aw(B
  $B!&(Bb_ScsiTargetReceiveDataByManual
      - $B0J>e$N(B3$B$D$O%G!<%?E>Aw$N$_(B
  $B!&(Bb_ScsiTargetReceiveMessage
      - $B%U%'!<%:$N@_Dj!"%G!<%?$NE>Aw(B

  *-*-*-*-*-*-*-*-*-*-*
    moved to str_scsi_record.psl.c temporary
  $B!&(Bb_GetScsiCDBLength
      - CDB$B$NBh(B1$B%P%$%HL\$N%0%k!<%W%3!<%I$+$i(BCDB$BD9$r@8@.(B
  $B!&(Bb_GetScsiInitiatorID
      - SCSI$B%G!<%?%P%9>e$N>pJs(B(SPC.TEMP$B%l%8%9%?>e$NCM(B)$B$+$i%$%K%7%(!<%?$N(BID$B$r(B
        $B@0?tCM$H$7$F@8@.(B($B<BBN$O(Bb_GetScsiIDInfo)
  *-*-*-*-*-*-*-*-*-*-*

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_ScsiTargetSendIdentify(lun_reg)
{
    b_BitwiseOrImmediateWithDNTC(lun_reg, _IDENTIFY_T, lun_reg);
    b_TargetTransferCommandMessageIn(D_ONE);
    LOOP(){
	b_IfSPCBusy(){break;}
	b_IfScsiAnyInterrupt(){  goto INTR;}
    }
    b_IfSPCDataBufferNotFull(){
	b_SetScsiDataReg(lun_reg);
    }
  INTR:
    ;
}

#PSL_define b_ScsiTargetSendExIdentify(lun_reg)
{
    $USE(D_WorkMsg1);
    /*--- Identify$B%a%C%;!<%8(B ---*/
    b_ShiftRightImmediate(lun_reg, _SHIFT_LEN_8, D_WorkMsg1);
    b_BitwiseAndImmediateWithDNTC(D_WorkMsg1, _IDENTIFY_T, D_WorkMsg1);

    /*--- Extended Identify$B%a%C%;!<%8(B ---*/
    $USE(D_WorkMsg2);
    b_SetImmValueDNTC(_EXTENDED_IDENTIFY, D_WorkMsg2);
    b_BitwiseAndImmediateWithDNTC(lun_reg, _MASK_OF_SCSI_1BYTE_DATA, lun_reg);
    b_ShiftLeftImmediateWithDNTC(lun_reg, _SHIFT_LEN_24, lun_reg);
    b_BitwiseOrWithDNTC(D_WorkMsg2, lun_reg, D_WorkMsg2);

    $USE(D_WorkMsgLen);
    b_SetImmValueDNTC(_TOTAL_LEN_OF_EX_IDENTIFY_MSG, D_WorkMsgLen);
    b_AddWithDNTC(D_WorkMsgLen, D_ONE, D_WorkMsgLen);
    /* "Identify"$B%a%C%;!<%8J,$N(B1byte$B$r2C$($k!#(B*/
    b_TargetTransferCommandMessageIn(D_WorkMsgLen);

    LOOP(){
	b_IfSPCBusy(){ break; }
	b_IfScsiAnyInterrupt(){
	    $RELEASE(D_WorkMsg1);
	    $RELEASE(D_WorkMsg2);
	    $RELEASE(D_WorkMsgLen);
	    goto END;
	}
    }
    LOOP(){
	b_IfSPCDataBufferNotFull(){
	    b_SetScsiDataReg(D_WorkMsg1);
	    $RELEASE(D_WorkMsg1);
	    b_DecrementReg(D_WorkMsgLen);
	    break;
	}
	b_IfSPCNotBusy(){
	    $RELEASE(D_WorkMsg1);
	    $RELEASE(D_WorkMsg2);
	    $RELEASE(D_WorkMsgLen);
	    goto END;
	}
    }

    LOOP(){
	b_IfSPCDataBufferNotFull(){
	    $USE(D_WorkData);
	    b_BitwiseAndImmediateWithDNTC(D_WorkMsg2, _MASK_OF_SCSI_1BYTE_DATA,
				  D_WorkData);
	    b_SetScsiDataReg(D_WorkData);
	    $RELEASE(D_WorkData);
	    b_ShiftLeftImmediateWithDNTC(D_WorkMsg2, _SHIFT_LEN_8, D_WorkMsg2);
	    b_DecrementReg(D_WorkMsgLen);
	}
	b_IfScsiAnyInterrupt(){
	    $RELEASE(D_WorkMsgLen);
	    goto END;
	}
	b_IfZero(D_WorkMsgLen){
	    $RELEASE(D_WorkMsgLen);
	    $RELEASE(D_WorkMsg2);
	    goto END;
	}
    }

  END:
    b_BusyWaitUntilSPCNotBusy();
}

#PSL_define b_ScsiTargetSendMessageByManual(imm_msg)
{
    b_SetScsiPhaseMsgIn();
    $USE(D_WorkMessage);
    b_SetImmValueDNTC(imm_msg, D_WorkMessage);
    b_SetScsiTempReg(D_WorkMessage);
    $RELEASE(D_WorkMessage);
    b_ScsiSetReq();
    b_BusyWaitUntilAckOn();
    b_ScsiResetReq();
}
#PSL_define b_ScsiTargetReceiveDataByManual(data_reg)
{
    b_ScsiSetReq();
    b_BusyWaitUntilAckOn();
    b_ScsiResetReq();
    b_GetScsiTempReg(data_reg);
}

#PSL_define b_ScsiTargetReceiveMessage(data_reg)
{
    b_SetScsiPhaseMsgOut();
    b_ScsiTargetReceiveDataByManual(data_reg);
}
/*
#PSL_define b_GetScsiCDBLength(cdb_data_reg, cdb_len_reg) 
  moved to str_scsi_record.psl.c temporary
*/
/*
#PSL_define b_GetScsiInitiatorID(dst_reg)
  moved to str_scsi_record.psl.c temporary
*/

/******************************************************************** PSL **
2.$B%$%K%7%(!<%?;~$N>pJsE>Aw(B
       written by f-takei@icot22      on Thu Sep 20 20:01:32 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%$%K%7%(!<%?;~$N>pJsE>Aw$N$?$a$N%^%/%m!#(B
  $B!&(Bb_ScsiInitiatorSendIdentify
  $B!&(Bb_ScsiInitiatorSendExIdentify
      - $B%U%'!<%:$N@_Dj!"(BTransfer$B%3%^%s%I$NH/9T!"%G!<%?$NE>Aw(B
  $B!&(Bb_ScsiInitiatorSendDataByManual
  $B!&(Bb_ScsiInitiatorSendMessageByManual
  $B!&(Bb_ScsiInitiatorReceiveDataByManual
      - $B0J>e$N(B5$B$D$O%G!<%?E>Aw$N$_(B
  $B!&(Bb_ScsiSendNullData
      - f_ScsiTransferAbort$B$G$N$_;H$o$l$k!#(B
        $B<BBN$O(Bb_ScsiInitiatorSendDataByManual
  $B!&(Bb_ScsiIgnoreReceiveData
      - f_ScsiTransferAbort$B$G$N$_;H$o$l$k!#(B
        $B<BBN$O(Bb_ScsiInitiatorReceiveDataByManual
  $B!&(Bb_BusyWaitScsiDisconnected
      - $B%P%9%U%j!<%U%'!<%:(B(SPC.Disconnected$B3d$j9~$_(B)$B$rBT$A!"(B
        $B3d$j9~$_$r%j%;%C%H$9$k!#(B

  *-*-*-*-*-*-*-*-*-*-*
    moved to str_scsi_record.psl.c temporary
  $B!&(Bb_GetScsiTargetID
      - SCSI$B%G!<%?%P%9>e$N>pJs(B(SPC.TEMP$B%l%8%9%?>e$NCM(B)$B$+$i%?!<%2%C%H$N(BID$B$r(B
        $B@0?tCM$H$7$F@8@.(B($B<BBN$O(Bb_GetScsiIDInfo)
  *-*-*-*-*-*-*-*-*-*-*

<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_ScsiInitiatorSendIdentify(lun_reg)
{
    b_BitwiseOrImmediateWithDNTC(lun_reg, _IDENTIFY_I, lun_reg);
    b_InitiatorTransferCommandMessageOut(D_ONE);
    LOOP(){
	b_IfSPCBusy(){ break;}
	b_IfScsiAnyInterrupt(){	goto INTR;}
    }
    b_IfSPCDataBufferNotFull(){
	b_SetScsiDataReg(lun_reg);
    }
    b_BusyWaitUntilSPCNotBusy();

  INTR:
    ;
}

#PSL_define b_ScsiInitiatorSendExIdentify(lun_reg)
{
    $USE(D_WorkMsg1);
    /*-- Identify$B%a%C%;!<%8(B ---*/
    b_ShiftRightImmediateWithDNTC(lun_reg, _SHIFT_LEN_8, D_WorkMsg1);
    b_BitwiseOrImmediateWithDNTC(D_WorkMsg1, _IDENTIFY_I, D_WorkMsg1);

    /*--- Extended Identify$B%a%C%;!<%8(B ---*/
    $USE(D_WorkMsg2);
    b_SetImmValueDNTC(_EXTENDED_IDENTIFY, D_WorkMsg2);
    b_BitwiseAndImmediateWithDNTC(lun_reg, _MASK_OF_SCSI_1BYTE_DATA, lun_reg);
    b_ShiftLeftImmediateWithDNTC(lun_reg, _SHIFT_LEN_24, lun_reg);
    b_BitwiseOrWithDNTC(D_WorkMsg2, lun_reg, D_WorkMsg2);

    $USE(D_WorkMsgLen);
    b_SetImmValueDNTC(_TOTAL_LEN_OF_EX_IDENTIFY_MSG, D_WorkMsgLen);
    b_AddWithDNTC(D_WorkMsgLen, D_ONE, D_WorkMsgLen);
    /* "Identify"$B%a%C%;!<%8J,$N(B1byte$B$r2C$($k!#(B*/
    b_InitiatorTransferCommandMessageOut(D_WorkMsgLen);

    LOOP(){
	b_IfSPCBusy(){ break;}
	b_IfScsiAnyInterrupt(){
	    $RELEASE(D_WorkMsg1);
	    $RELEASE(D_WorkMsg2);
	    $RELEASE(D_WorkMsgLen);
	    goto END;
	}
    }
    LOOP(){
	b_IfSPCDataBufferNotFull(){
	    b_SetScsiDataReg(D_WorkMsg1);
	    b_DecrementReg(D_WorkMsgLen);
	    $RELEASE(D_WorkMsg1);
	    break;
	}
	b_IfSPCNotBusy(){
	    $RELEASE(D_WorkMsg1);
	    $RELEASE(D_WorkMsg2);
	    $RELEASE(D_WorkMsgLen);
	    goto END;
	}
    }

    LOOP(){
	$USE(D_WorkInterrupt);
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	    b_ScsiSetATN();
	}
	$RELEASE(D_WorkInterrupt);
	b_IfScsiParityError(){
	    b_ScsiSetATN();
	}
	b_IfSPCDataBufferNotFull(){
	    $USE(D_WorkData1);
	    b_BitwiseAndImmediateWithDNTC
		(D_WorkMsg2, _MASK_OF_SCSI_1BYTE_DATA, D_WorkData1);
	    b_SetScsiDataReg(D_WorkData1);
	    $RELEASE(D_WorkData1);
	    b_ShiftRightImmediateWithDNTC
		(D_WorkMsg2, _SHIFT_LEN_8, D_WorkMsg2);
	    b_DecrementReg(D_WorkMsgLen);
	}
	b_IfSPCNotBusy(){
	    $RELEASE(D_WorkMsg2);
	    $RELEASE(D_WorkMsgLen);
	    goto END;
	}
	b_IfZero(D_WorkMsgLen){
	    $RELEASE(D_WorkMsg2);
	    $RELEASE(D_WorkMsgLen);
	    goto END;
	}
    }

  END:
    ;
}

#PSL_define b_ScsiInitiatorSendDataByManual(data_reg)
{
    b_SetScsiTempReg(data_reg);
    b_ScsiSetAck();
    b_BusyWaitUntilReqOff();
    b_ScsiResetAck();
}

#PSL_define b_ScsiInitiatorSendMessageByManual(imm_msg)
{
    $USE(D_WorkMsg);
    b_SetImmValueDNTC(imm_msg, D_WorkMsg);
/*    b_ScsiInitiatorSendDataByManual(D_WorkMsg);  reviced on 20 Mar */
    b_SetScsiTempReg(D_WorkMsg);
    b_ScsiSetAck();
    b_BusyWaitUntilReqOff();
    b_ScsiResetATN();
    /* $B:G=*%P%$%H$N(BREQ:$B56$N8e$K(BATN$B$r56$H$9$k!#(B*/
    b_ScsiResetAck();
    $RELEASE(D_WorkMsg);
}

#PSL_define b_ScsiInitiatorReceiveStatus(data_reg)
{
    b_InitiatorTransferCommandStatus();
    LOOP(){
	b_IfSPCBusy(){ break;}
	b_IfScsiAnyInterrupt(){	goto END;}
    }

    $USE(D_WorkInterrupt);
    LOOP(){
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptSPCHardwareError(D_WorkInterrupt){
	    b_ScsiSetATN();
	    $RELEASE(D_WorkInterrupt);
	    goto Ignore_Data;
	}
	b_IfScsiParityError(){
	    b_ScsiSetATN();
	    $RELEASE(D_WorkInterrupt);
	    goto Ignore_Data;
	}
	b_IfSPCDataBufferNotEmpty(){
	    b_GetScsiDataReg(data_reg);
	}
	b_IfSPCNotBusy(){
	    $RELEASE(D_WorkInterrupt);
	    goto END;
	}
    }

  Ignore_Data:
    LOOP(){
	b_IfSPCDataBufferNotEmpty(){
	    b_GetScsiDataReg(D_VOID);
	}
	b_IfSPCNotBusy(){
	    break;
	}
    }

  END:
    ;
}

#PSL_define b_ScsiInitiatorReceiveDataByManual(data_reg)
{
    b_ScsiSetAck();
    b_BusyWaitUntilReqOff();
    b_GetScsiTempReg(data_reg);
    b_ScsiResetAck();
}

#PSL_define b_ScsiSendNullData()
{
    b_ScsiInitiatorSendDataByManual(D_NULL);
}

#PSL_define b_ScsiIgnoreReceiveData()
{
    b_ScsiInitiatorReceiveDataByManual(D_VOID);
}

#PSL_define b_BusyWaitScsiDisconnected()
{
    $USE(D_WorkInterrupt);
    LOOP(){
	b_GetScsiInterrupt(D_WorkInterrupt);
	b_IfScsiInterruptDisconnected(D_WorkInterrupt){
	    b_ResetScsiInterruptDisconnected();
	    break;
	}
    }
    $RELEASE(D_WorkInterrupt);
}
/*
#PSL_define b_GetScsiTargetID(dst_reg)
  moved to str_scsi_record.psl.c temporary
*/

/******************************************************************** PSL **

       written by f-takei@icot22      on Tue Sep 25 20:37:57 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
   $B!&(Bb_GetScsiIDInfo
      - SCSI$B%G!<%?%P%9>e$N>pJs(B(SPC.TEMP$B%l%8%9%?>e$NCM(B)$B$+$iAj<j$N(BID$B$r(B
        $B@0?tCM$H$7$F@8@.(B
<Examples>
<Test>
<Explanation>
<ETC>
    moved to str_scsi_record.psl.c temporary
********************************************************************* PSL **/
/*
#PSL_define b_GetScsiIDInfo(dst_reg)
*/

/******************************************************************** PSL **

       written by f-takei@icot22      on Thu Nov 14 10:38:02 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfScsiRangeErr(reg, imm_low, imm_hi)
{
  p_CompareImmediate(reg,imm_low);
  p_IfGE() { 
    p_CompareImmediate(reg,imm_hi);
    p_IfLE() {
      b_SetSuccess();
    } else { b_SetFail(); }
  } else { b_SetFail(); }
  b_IfFail()
}
