
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_reg_ope.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun 18 22:12:19 1990
   ----- LAST SAVED: by ttakagi@icot22, on Mon May 11 12:20:13 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : basics
   ----- ABSTRACT  : $B4pK\E*$J%l%8%9%?A`:n(B

1. $BHf3SA`:n(B
  1.1  $B%l%8%9%?$NCM$NHf3S(B
  1.2  $B%l%8%9%?$N%?%0(B($B%?%$%W(B, MRB, RB) $B$HCM$NHf3S(B
  1.3  $B%l%8%9%?$N%?%$%W$HCM$NHf3S(B
  1.4  $BL?NaCf$N%$%_%G%#%(!<%H%U%#!<%k%I$H%l%8%9%?$NHf3S(B
  1.5  $BL?NaCf$N%$%_%G%#%(!<%H%U%#!<%k%IF1;N$NHf3S(B
  1.6  KL1-b$BL?Na%*%Z%i%s%I$G;XDj$5$l$?%l%8%9%?HV9f$NHf3S(B
  1.7  $B%l%8%9%?$rA`:n$9$k%^%/%m$N2>0z?t$K;XDj$5$l$?%l%8%9%?HV9f$NHf3S(B

2. $B%?%0$rJ]B8$7$?1i;;A`:n(B
  2.1  $B;;=QO@M}1i;;(B
  2.2  $B%l%8%9%?$N%$%s%/%j%a%s%H(B/$B%G%/%j%a%s%H$H(BEOL$B$N@_Dj(B
  2.3  $B%l%8%9%?$N%7%U%HA`:n(B
  2.3  $B%l%8%9%?$N%S%C%HA`:n(B
  2.4  $B%l%8%9%?$N%S%C%H%U%#!<%k%IA`:n(B

3. $B$=$NB>(B
  3.1  $B%]%$%s%?%l%8%9%?$N99?7!&%o!<%I%9%?%C%/$NA`:n(B
  3.2  $BL?NaCf$N%$%_%G%#%(!<%H%U%#!<%k%I$r%l%8%9%?$K(BMove$B$9$kA`:n(B
  3.3  $BB(CM$G%7%U%HNL$r;XDj$9$k%7%U%HA`:n(B ($B%?%0$OITDj(B) 
  3.4  $BMWAG0LCV$r%"%I%l%9%*%U%;%C%H$KJQ49$9$kA`:n(B ($BDI2C(B 89.8.30)
  3.5  $B%?%$%W$HCM$N@_Dj(B

4. $B%a%b%j$X$N@_Dj$b>/$7$"$k!J(Bbsc_mem_ope.psl.c$B$r:n$k$Y$-$J$s$@$1$I!K(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

bsc_reg_ope.psl.c $B$GMQ$$$k%o!<%/%l%8%9%?(B

       written by yamamoto@icot22      on Mon Jun 18 22:13:39 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#DATA_define	D_WorkRegOpe1	XXX
#DATA_define	D_WorkRegOpe2	XXX

/******************************************************************** PSL **
1.1  $B%l%8%9%?$NCM$NHf3S(B

       written by goto@icot22      on $BJ?@.(B01$BG/(B01$B7n(B19$BF|(B($BLZMKF|(B) 17$B;~(B47$BJ,(B
<Arguments>
  reg1 : $BHf3SBP>]$H$J$k%l%8%9%?(B
  reg2 : $BHf3SBP>]$H$J$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%8%9%?$NCM$NHf3S(B ($B%?%0It$OHf3SBP>]$H$7$J$$(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfEqual(reg1, reg2)
{
  p_Compare(reg1,reg2);
  p_IfEQ()
}

#CTRL_define b_IfNotEqual(reg1, reg2)
{
  p_Compare(reg1,reg2);
  p_IfNE()
}

#CTRL_define b_IfLess(reg1, reg2)
{
  p_Compare(reg1,reg2);
  p_IfLT()
}

#CTRL_define b_IfLessEq (reg1, reg2)
{
  p_Compare(reg1, reg2);
  p_IfLE()
}

#CTRL_define b_IfGreaterEq (reg1, reg2)
{
  p_Compare(reg1, reg2);
  p_IfGE()
}

#CTRL_define b_IfGreater (reg1, reg2)
{
  p_Compare(reg1, reg2);
  p_IfGT()
}

#DATA_define D_WorkSignBit1 XXX
#DATA_define D_WorkSignBit2 XXX

#CONST_define _SignBitMask 0x80000000

#PSL_define b_CompareU(reg1, reg2)
{
  $USE(D_WorkSignBit1);
  $USE(D_WorkSignBit2);
  b_BitwiseEorImmediateWithDNTC(reg1,_SignBitMask,D_WorkSignBit1);
  b_BitwiseEorImmediateWithDNTC(reg2,_SignBitMask,D_WorkSignBit2);
  p_Compare(D_WorkSignBit1,D_WorkSignBit2);
  $RELEASE(D_WorkSignBit1);
  $RELEASE(D_WorkSignBit2);
}

#CTRL_define b_IfLessU(reg1, reg2)
{
  $USE(D_WorkSignBit1);
  $USE(D_WorkSignBit2);
  b_BitwiseEorImmediateWithDNTC(reg1,_SignBitMask,D_WorkSignBit1);
  b_BitwiseEorImmediateWithDNTC(reg2,_SignBitMask,D_WorkSignBit2);
  p_Compare(D_WorkSignBit1,D_WorkSignBit2);
  $RELEASE(D_WorkSignBit1);
  $RELEASE(D_WorkSignBit2);
  p_IfLT()
}

#CTRL_define b_IfLessEqU (reg1, reg2)
{
  $USE(D_WorkSignBit1);
  $USE(D_WorkSignBit2);
  b_BitwiseEorImmediateWithDNTC(reg1,_SignBitMask,D_WorkSignBit1);
  b_BitwiseEorImmediateWithDNTC(reg2,_SignBitMask,D_WorkSignBit2);
  p_Compare(D_WorkSignBit1,D_WorkSignBit2);
  $RELEASE(D_WorkSignBit1);
  $RELEASE(D_WorkSignBit2);
  p_IfLE()
}

#CTRL_define b_IfGreaterEqU (reg1, reg2)
{
  $USE(D_WorkSignBit1);
  $USE(D_WorkSignBit2);
  b_BitwiseEorImmediateWithDNTC(reg1,_SignBitMask,D_WorkSignBit1);
  b_BitwiseEorImmediateWithDNTC(reg2,_SignBitMask,D_WorkSignBit2);
  p_Compare(D_WorkSignBit1,D_WorkSignBit2);
  $RELEASE(D_WorkSignBit1);
  $RELEASE(D_WorkSignBit2);
  p_IfGE()
}

#CTRL_define b_IfGreaterU (reg1, reg2)
{
  $USE(D_WorkSignBit1);
  $USE(D_WorkSignBit2);
  b_BitwiseEorImmediateWithDNTC(reg1,_SignBitMask,D_WorkSignBit1);
  b_BitwiseEorImmediateWithDNTC(reg2,_SignBitMask,D_WorkSignBit2);
  p_Compare(D_WorkSignBit1,D_WorkSignBit2);
  $RELEASE(D_WorkSignBit1);
  $RELEASE(D_WorkSignBit2);
  p_IfGT()
}

#CTRL_define b_IfZero (reg)
{
  @REGOPE_OPT {
    /* Symmetry $B$G$O$3$NJ}$,B.$$(B */
    _CompareImmediate(reg,_ZERO);
  } else {
    p_Compare(reg, D_NULL);
  };
  p_IfEQ()
}

#CTRL_define b_IfNotZero (reg)
{
  @REGOPE_OPT {
    /* Symmetry $B$G$O$3$NJ}$,B.$$(B */
    _CompareImmediate(reg,_ZERO);
  } else {
    p_Compare(reg, D_NULL);
  };
  p_IfNE()
}
  
#CTRL_define b_IfEqualImm (reg, imm_value)
{
  p_CompareImmediate (reg, imm_value);
  p_IfEQ ()
}

#CTRL_define b_IfNotEqualImm (reg, imm_value)
{
  p_CompareImmediate (reg, imm_value);
  p_IfNE ()
}

#CTRL_define b_IfLessImm (reg, imm_value)
{
  p_CompareImmediate (reg, imm_value);
  p_IfLT ()
}

#CTRL_define b_IfLessEqImm (reg, imm_value)
{
  p_CompareImmediate (reg, imm_value);
  p_IfLE ()
}

#CTRL_define b_IfGreaterImm (reg, imm_value)
{
  p_CompareImmediate (reg, imm_value);
  p_IfGT ()
}

#CTRL_define b_IfGreaterEqImm (reg, imm_value)
{
  p_CompareImmediate (reg, imm_value);
  p_IfGE ()
}

#CTRL_define b_IfEven(reg)
{
  p_BitwiseAndImmediate(reg,_ONE,D_VOID);
  p_IfEQ ()
}

#CTRL_define b_IfOdd(reg)
{
  p_BitwiseAndImmediate(reg,_ONE,D_VOID);
  p_IfNE ()
}

/******************************************************************** PSL **
1.2  $B%l%8%9%?$N%?%0(B($B%?%$%W(B, MRB, RB) $B$HCM$NHf3S(B

       written by goto@icot22      on Mon Jan 23 18:52:14 1989
<Arguments>
  reg1 : $BHf3SBP>]$H$J$k%l%8%9%?(B
  reg2 : $BHf3SBP>]$H$J$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%o!<%IA4BN(B($B%?%0$HCM(B)$B$NHf3S(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfWordEq (reg1, reg2)
{
  p_CompareWord (reg1, reg2);
  p_IfWordEQ()
}

#CTRL_define b_IfWordNotEq(reg1, reg2)
{
  p_CompareWord (reg1, reg2);
  p_IfWordNE()
}

/******************************************************************** PSL **
1.3  $B%l%8%9%?$N%?%$%W$HCM$NHf3S(B

       written by goto@icot22      on Mon Jan 23 18:52:14 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%8%9%?$NCM$H%?%$%W$r9g$o$;$F0lCWHf3S$9$k(B.
<Examples>
  $B%f%K%U%#%1!<%7%g%s$K$*$1$k0lCWHf3S(B
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfTypeValueEq (reg1, reg2)
{
  p_CompareTypeAndValue (reg1, reg2);
  p_IfWordEQ()
}

#CTRL_define b_IfTypeValueNotEq(reg1, reg2)
{
  p_CompareTypeAndValue (reg1, reg2);
  p_IfWordNE()
}

#CTRL_define b_IfEOL (reg)
{
  p_IfTypeEQImmediate (reg, EOL) 
}

#CTRL_define b_IfNotEOL (reg)
{
  p_IfTypeNEImmediate (reg, EOL) 
}

#CTRL_define b_IfFLC (reg)
{
  p_IfTypeEQImmediate (reg, FLC) 
}

#CTRL_define b_IfNotFLC (reg)
{
  p_IfTypeNEImmediate (reg, FLC) 
}

#CTRL_define b_IfSLOCK (reg)
{
  p_IfTypeEQImmediate (reg, SLOCK) 
}

#CTRL_define b_IfNotSLOCK (reg)
{
  p_IfTypeNEImmediate (reg, SLOCK) 
}

#CTRL_define b_IfMARKED (reg)
{
  p_IfTypeEQImmediate (reg, MARKED) 
}

#CTRL_define b_IfNotMARKED (reg)
{
  p_IfTypeNEImmediate (reg, MARKED) 
}

/******************************************************************** PSL **
1.4  $BL?NaCf$N%$%_%G%#%(!<%H%U%#!<%k%I$H%l%8%9%?$NHf3S(B

       written by nishida@icot22      on Fri Jan 20 17:06:42 1989
<Arguments>
  reg : $BHf3SBP>]$H$J$k%l%8%9%?(B
  opr_field : KL1-B $B$NL?Na%*%Z%i%s%I$G;XDj$5$l$?B(CM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%8%9%?$NCM$H(BKL1-B$BL?Na%*%Z%i%s%I$NB(CM$NHf3S$r9T$&(B.
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfNotEqualOpr(reg, opr_field) 
{
  $USE(D_WorkRegOpe1);
  p_MoveImmediateValueFromImmediateField(opr_field, D_WorkRegOpe1);
  p_Compare(reg, D_WorkRegOpe1);
  $RELEASE(D_WorkRegOpe1);
  p_IfNE()
}

/******************************************************************** PSL **
1.5  $BL?NaCf$N%$%_%G%#%(!<%H%U%#!<%k%IF1;N$NHf3S(B

       written by nishida@icot22      on Fri Jan 20 17:06:42 1989
<Arguments>
  opr_field1 : KL1-B $B$NL?Na%*%Z%i%s%I$G;XDj$5$l$?B(CM(B
  opr_field2 : KL1-B $B$NL?Na%*%Z%i%s%I$G;XDj$5$l$?B(CM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%8%9%?$NCM$H(BKL1-B$BL?Na%*%Z%i%s%I$NB(CM$NHf3S$r9T$&(B.
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfEqualOprOpr(opr_field1, opr_field2) 
{
  @REGOPE_OPT {
    _IfEqualOprOprCheck(opr_field1, opr_field2);
  } else {
    $USE(D_WorkRegOpe1);
    $USE(D_WorkRegOpe2);
    p_MoveImmediateValueFromImmediateField(opr_field1, D_WorkRegOpe1);
    p_MoveImmediateValueFromImmediateField(opr_field2, D_WorkRegOpe2);
    p_Compare(D_WorkRegOpe1, D_WorkRegOpe2);
    $RELEASE(D_WorkRegOpe1);
    $RELEASE(D_WorkRegOpe2);
  };
  p_IfEQ()
}

/******************************************************************** PSL **
1.6  KL1-b$BL?Na%*%Z%i%s%I$G;XDj$5$l$?%l%8%9%?HV9f$NHf3S(B :: NOT USED
  --> $B>C5n(B
********************************************************************* PSL **/

/******************************************************************** PSL **
1.7  $B%l%8%9%?$rA`:n$9$k%^%/%m$N2>0z?t$K;XDj$5$l$?%l%8%9%?HV9f$NHf3S(B

       written by goto@icot22      on Tue Mar 14 15:20:27 1989
<Arguments>
  reg1 : $B%^%/%m$N2>0z?t$K;XDj$5$l$?%l%8%9%?HV9f(B
  reg2 : $B%^%/%m$N2>0z?t$K;XDj$5$l$?%l%8%9%?HV9f(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  reg1 $B$H(B reg2 $B$r(B"$B%l%8%9%?HV9f(B"$B$H$7$FHf3S$7(B, $B$b$7F10l$N%l%8%9%?$J$i$P%(%i!<(B
  $B%a%C%;!<%8$r=PNO$9$k(B.
<Examples>
<Test>
<Explanation>
  @DEBUG{ .. } $BFbIt$GMQ$$$k%G%P%0@lMQ$N%^%/%m$G$"$k(B.
  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
<ETC>
********************************************************************* PSL **/

#PSL_define b_ErrorIfSameRegNum (reg1, reg2)
{
  @REGOPE_OPT {
    _ErrorIfSameRegNum (reg1, reg2);
  } else {
    $USE(D_WorkRegOpe1);
    p_SetImmediateValue (reg1, D_WorkRegOpe1);
    p_CompareImmediate (D_WorkRegOpe1, reg2);
    p_IfEQ (){
      @DEBUG{VPIM_ERROR ("Macro_arguments", "Register_number_conflict_occur");};
    }
    $RELEASE(D_WorkRegOpe1);
  };
}

#PSL_define b_WarningIfSameRegNum (reg1, reg2)
{
  @REGOPE_OPT { 
    _WarningIfSameRegNum (reg1, reg2);
  } else {
    $USE(D_WorkRegOpe1);
    p_SetImmediateValue (reg1, D_WorkRegOpe1);
    p_CompareImmediate (D_WorkRegOpe1, reg2);
    p_IfEQ (){
      @DEBUG{WARNING ("PSL_macro_arguments", "Same_register_number_appears");};
    }
    $RELEASE(D_WorkRegOpe1);
  };
}

/******************************************************************** PSL **
2.1  $BBh(B1$B%*%Z%i%s%I$N%l%8%9%?$N%?%0$r7k2L%l%8%9%?$N%?%0$H$9$k;;=QO@M}1i;;(B
       written by goto@icot22      on Mon Jun 26 19:04:54 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BBh(B1$B%*%Z%i%s%I$N%l%8%9%?$N%?%0$r(BDst $B%l%8%9%?$N%?%0$H$9$k1i;;$G$"$k!#(B
  PIM/p $B$G$O(B, $B$3$l$,4pK\1i;;L?Na$KBP1~$9$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define b_AddWithTag (src1, src2, dst)
{
  @REGOPE_OPT {
    _AddWithTag (src1, src2, dst);
  } else {
    p_Add (src1, src2, dst);
    p_MoveTag(src1, dst);
  };
}

#PSL_define b_SubtractWithTag (src1, src2, dst)
{
  @REGOPE_OPT {
    _SubtractWithTag(src1, src2, dst);
  } else {
    p_Subtract (src1, src2, dst);
    p_MoveTag(src1, dst);
  };
}

#PSL_define b_AddImmediateWithTag (src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _AddImmediateWithTag (src1, imm_src2, dst);
  } else {
    p_AddImmediate (src1, imm_src2, dst);
    p_MoveTag(src1, dst);
  };
}

#PSL_define b_SubtractImmediateWithTag (src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _SubtractImmediateWithTag (src1, imm_src2, dst);
  } else {
    p_SubtractImmediate (src1, imm_src2, dst);
    p_MoveTag(src1, dst);
  };
}

#PSL_define b_MultiplyWithTag(src1, src2, dst)
{
  p_Multiply(src1, src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_MultiplyImmediateWithTag(src1, imm_src2, dst)
{
  p_MultiplyImmediate(src1, imm_src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_DivideWithTag(src1, src2, dst)
{
  p_Divide(src1, src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_DivideImmediateWithTag(src1, imm_src2, dst)
{
  p_DivideImmediate(src1, imm_src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_ModuloWithTag(src1, src2, dst)
{
  p_Modulo(src1, src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_ModuloImmediateWithTag(src1, imm_src2, dst)
{
  p_ModuloImmediate(src1, imm_src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_MinusWithTag(src, dst)
{
  p_Subtract(D_NULL, src, dst);
  p_MoveTag(src, dst);
}

#PSL_define b_BitwiseAndWithTag(src1, src2, dst)
{
  p_BitwiseAnd(src1, src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_BitwiseAndImmediateWithTag(src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _BitwiseAndImmediateWithTag(src1, imm_src2, dst);
  } else {
    p_BitwiseAndImmediate(src1, imm_src2, dst);
    p_MoveTag(src1, dst);
  };
}

#PSL_define b_BitwiseOrWithTag(src1, src2, dst)
{
  p_BitwiseOr(src1, src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_BitwiseOrImmediateWithTag(src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _BitwiseOrImmediateWithTag(src1, imm_src2, dst);
  } else {
    p_BitwiseOrImmediate(src1, imm_src2, dst);
    p_MoveTag(src1, dst);
  };
}

#PSL_define b_BitwiseEorWithTag(src1, src2, dst)
{
  p_BitwiseEor(src1, src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_BitwiseEorImmediateWithTag(src1, imm_src2, dst)
{
  p_BitwiseEorImmediate(src1, imm_src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_BitwiseComplementWithTag(src,dst)
{
  p_BitwiseNot(src,dst);
  p_MoveTag(src,dst);
}
/******************************************************************** PSL **
2.2  $B7k2L%l%8%9%?$N%?%0$O!V2?$G$b$$$$!W$H$9$k;;=QO@M}1i;;(B
       written by goto@icot22      on Mon Jun 26 19:04:54 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  Dst $B%l%8%9%?$N%?%0$r!V2?$G$b$$$$!W$H$9$k1i;;$G$"$k!#(B
      p_AddWithDNTC() $B$O!"(B
  $B<B5!Kh$K!"(B
      p_Add()		$B%?%0J]B8(B
      b_AddWithTag()	$BBh#1%*%Z%i%s%I$N%?%0$,(BDST
  $B$NET9g$N$$$$$h$&$KBX$($l$PNI$$!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define b_AddWithDNTC (src1, src2, dst)
{
  @REGOPE_OPT {
    _AddWithDNTC(src1, src2, dst);
  } else {
    p_Add (src1, src2, dst);
    @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
  };
}

#PSL_define b_SubtractWithDNTC (src1, src2, dst)
{
  @REGOPE_OPT {
    _SubtractWithDNTC(src1, src2, dst);
  } else {
    p_Subtract (src1, src2, dst);
    @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
  };
}

#PSL_define b_AddImmediateWithDNTC (src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _AddImmediateWithDNTC (src1, imm_src2, dst);
  } else {
    p_AddImmediate (src1, imm_src2, dst);
    @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
  };
}

#PSL_define b_SubtractImmediateWithDNTC (src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _SubtractImmediateWithDNTC (src1, imm_src2, dst);
  } else {
    p_SubtractImmediate (src1, imm_src2, dst);
    @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
  };
}

#PSL_define b_MultiplyWithDNTC(src1, src2, dst)
{
  p_Multiply(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_MultiplyImmediateWithDNTC(src1, imm_src2, dst)
{
  p_MultiplyImmediate(src1, imm_src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_DivideWithDNTC(src1, src2, dst)
{
  p_Divide(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_DivideImmediateWithDNTC(src1, imm_src2, dst)
{
  p_DivideImmediate(src1, imm_src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_ModuloWithDNTC(src1, src2, dst)
{
  p_Modulo(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_ModuloImmediateWithDNTC(src1, imm_src2, dst)
{
  p_ModuloImmediate(src1, imm_src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_MinusWithDNTC(src, dst)
{
  p_Subtract(D_NULL, src, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_BitwiseAndWithDNTC(src1, src2, dst)
{
  p_BitwiseAnd(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_BitwiseAndImmediateWithDNTC(src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _BitwiseAndImmediateWithDNTC(src1, imm_src2, dst);
  } else {
    p_BitwiseAndImmediate(src1, imm_src2, dst);
    @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
  };
}

#PSL_define b_BitwiseOrWithDNTC(src1, src2, dst)
{
  p_BitwiseOr(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_BitwiseOrImmediateWithDNTC(src1, imm_src2, dst)
{
  @REGOPE_OPT {
    _BitwiseOrImmediateWithDNTC(src1, imm_src2, dst);
  } else {
    p_BitwiseOrImmediate(src1, imm_src2, dst);
    @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
  };
}

#PSL_define b_BitwiseEorWithDNTC(src1, src2, dst)
{
  p_BitwiseEor(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_BitwiseEorImmediateWithDNTC(src1, imm_src2, dst)
{
  p_BitwiseEorImmediate(src1, imm_src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_BitwiseComplementWithDNTC(src,dst)
{
  p_BitwiseNot(src,dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

/******************************************************************** PSL **
2.3  $B%l%8%9%?$N%$%s%/%j%a%s%H(B/$B%G%/%j%a%s%H(B

       written by goto@icot22      Tue Dec 27 15:33:47 1988

<Arguments>
  reg : $BA`:n$5$l$k%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B%"%I%l%9$N%$%s%/%j%a%s%H(B/$B%G%/%j%a%s%H$KMQ$$$J$$$3$H(B.
********************************************************************* PSL **/

#PSL_define b_IncrementReg (reg)
{
  @REGOPE_OPT {
    _IncrementReg(reg);
  } else {
    b_AddImmediateWithTag(reg, _ONE, reg);
/* p_AddImmediate (reg, _ONE, reg);   for PIM/k ??? */
  };
}

#PSL_define b_DecrementReg (reg)
{
  @REGOPE_OPT {
    _DecrementReg(reg);
  } else {
    b_SubtractImmediateWithTag(reg, _ONE, reg);
/* p_SubtractImmediate (reg, _ONE, reg);   for PIM/k ??? */
  };
}

/******************************************************************** PSL **
2.4 $B%l%8%9%?$N%S%C%H%7%U%HA`:n(B
       written by nakase@icot22      Tue Dec  6 11:19:53 1988

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $BBh#1%*%Z%i%s%I$N%?%0$r(BDST$B$K@_Dj$9$k%7%U%H(B $B$*$h$S(B $B%?%0$O!V2?$G$b$$$$!W%7%U%H(B
		b_******WithTag				b_******WithDNTC
<ETC>
********************************************************************* PSL **/

#PSL_define b_ShiftLeftWithTag(src1, src2, dst)
{
  p_ShiftLeft(src1, src2, dst);
  p_MoveTag(src1, dst);
}

#PSL_define b_ShiftRightWithTag(src1, src2, dst)
{
  p_ShiftRight(src1, src2, dst);
  p_MoveTag(src1, dst);
}


#PSL_define b_ShiftLeftImmediateWithTag (src_reg, imm_shift, dst_reg)
{
  $USE(D_WorkRegOpe1);
  p_SetImmediateValue (imm_shift, D_WorkRegOpe1);
  p_ShiftLeft (src_reg, D_WorkRegOpe1, dst_reg);
  p_MoveTag(src_reg, dst_reg);
  $RELEASE(D_WorkRegOpe1);
}

#PSL_define b_ShiftRightImmediateWithTag (src_reg, imm_shift, dst_reg)
{
  $USE(D_WorkRegOpe1);
  p_SetImmediateValue (imm_shift, D_WorkRegOpe1);
  p_ShiftRight (src_reg, D_WorkRegOpe1, dst_reg);
  p_MoveTag(src_reg, dst_reg);
  $RELEASE(D_WorkRegOpe1);
}

#PSL_define b_ShiftLeftWithDNTC(src1, src2, dst)
{
  p_ShiftLeft(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_ShiftRightWithDNTC(src1, src2, dst)
{
  p_ShiftRight(src1, src2, dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}


#PSL_define b_ShiftLeftImmediateWithDNTC (src_reg, imm_shift, dst_reg)
{
  $USE(D_WorkRegOpe1);
  p_SetImmediateValue (imm_shift, D_WorkRegOpe1);
  p_ShiftLeft (src_reg, D_WorkRegOpe1, dst_reg);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst_reg); };
  $RELEASE(D_WorkRegOpe1);
}

#PSL_define b_ShiftRightImmediateWithDNTC (src_reg, imm_shift, dst_reg)
{
  $USE(D_WorkRegOpe1);
  p_SetImmediateValue (imm_shift, D_WorkRegOpe1);
  p_ShiftRight (src_reg, D_WorkRegOpe1, dst_reg);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst_reg); };
  $RELEASE(D_WorkRegOpe1);
}

/******************************************************************** PSL **
2.3  $B%l%8%9%?$N%S%C%HA`:n(B

       written by goto@icot22      on Wed Feb 22 09:13:22 1989

<Arguments>
  src_reg : $B%S%C%HA`:n$NBP>]$H$J$k%l%8%9%?(B
  dst_reg : $B%S%C%HA`:n$N7k2L$rJV$9%l%8%9%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%8%9%?$NCM$KBP$7$F%S%C%HA`:n$r9T$&(B
  $B!&(Bb_CountLeftMostZeros(src_reg, dst_reg) : 
	src_reg $B$NCMIt$N:8$+$i(B"0"$B$N%S%C%H$r%+%&%s%H$7(B, dst_reg$B$KJV$9(B
<Examples>
<Test>
<Explanation>
  dst_reg $B$N%?%0It$O(B src_reg $B$HF1$8(B
<ETC>
********************************************************************* PSL **/
#CONST_define _MAX_VALUE_BIT_NUMBER 32

#PSL_define b_CountLeftMostZeros(src_reg, dst_reg)
{
	/*   $B%9%H%j%s%0$N3d$jIU$1!"2s<}$G8F$P$l$F$$$k$N$G!"9bB.2=$,I,MW(B */
/*
  @REGOPE_OPT{
    _CountLeftMostZeros(src_reg, dst_reg);
  } else {
*/
    @DEBUG {  b_WarningIfSameRegNum (src_reg, dst_reg); };
    $USE(D_WorkRegOpe1); 
    p_MoveWord(src_reg, D_WorkRegOpe1);
    p_MoveWord(D_NULL, dst_reg);
    LOOP(){
      p_Compare(D_WorkRegOpe1, D_NULL);
      p_IfEQ() {
	b_AddImmediateWithDNTC(dst_reg, _MAX_VALUE_BIT_NUMBER, dst_reg);
	break;
      }
      p_IfLE() break;
      b_ShiftLeftWithDNTC(D_WorkRegOpe1, D_ONE, D_WorkRegOpe1); 
      b_IncrementReg(dst_reg);
    }
    p_MoveTag(src_reg, dst_reg);
    $RELEASE(D_WorkRegOpe1);
/*
  };
*/
}

#PSL_define b_CountRightMostZeros(src_reg, dst_reg)
{
  @DEBUG {  b_WarningIfSameRegNum (src_reg, dst_reg); };
  $USE(D_WorkRegOpe1); 
  p_MoveWord(src_reg, D_WorkRegOpe1);
  p_MoveWord(D_NULL, dst_reg);
  LOOP(){
    p_Compare(D_WorkRegOpe1, D_NULL);
    p_IfEQ() {
      b_AddImmediateWithDNTC(dst_reg, _MAX_VALUE_BIT_NUMBER, dst_reg);
      break;
    }
    b_IfEqual(D_ONE, D_WorkRegOpe1) break;
    b_ShiftRightWithDNTC(D_WorkRegOpe1, D_ONE, D_WorkRegOpe1); 
    b_IncrementReg(dst_reg);
  }
  p_MoveTag(src_reg, dst_reg);
  $RELEASE(D_WorkRegOpe1);
}

#CONST_define _MAX_VALUE_BIT_POS 31
#PSL_define b_PriorityEncoding	(src_reg, dst_reg)	/* s_BitmapToPenum */
{
  b_CountLeftMostZeros(src_reg, dst_reg);
  b_SubtractImmediateWithDNTC(dst_reg, _MAX_VALUE_BIT_POS, dst_reg);
  b_SubtractWithDNTC(D_NULL, dst_reg, dst_reg);
  p_MoveTag(src_reg, dst_reg);
}

#PSL_define b_SetBitReg (pos_reg, dst_reg)
{
  p_ShiftLeft(D_ONE, pos_reg, dst_reg);
}

/******************************************************************** PSL **
2.4 $B%l%8%9%?$N%S%C%H%U%#!<%k%IA`:n(B

       written by goto@icot22      on Wed Feb 22 09:13:22 1989

<Arguments>
  src_reg : $B%S%C%H%U%#!<%k%IA`:n$NBP>]$H$J$k%l%8%9%?(B
  dst_reg : $B%S%C%H%U%#!<%k%IA`:n$N7k2L$rJV$9%l%8%9%?(B
  imm_mask : $B%S%C%H%U%#!<%k%I$r;XDj$9$kB(CM%^%9%/(B
  imm_value : $B%S%C%H%U%#!<%k%I$KM?$($kB(CM(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%l%8%9%?$NCM$KBP$7$F%S%C%H%U%#!<%k%IA`:n$r9T$&(B

  $B!&(Bb_MoveWithNewBitField (src_reg, imm_mask, imm_value, dst_reg)
	src_reg $B$NCM$K(Bimm_mask $B$N%^%9%/$r3]$1(B, $B$=$l$H(Bimm_value $B$H$N(Bbit-wise-OR
  	$B$r(B dst_reg $B$KCV$/(B. 

  $B!&(Bb_ReplaceBitField (src_dst_reg, imm_mask, imm_value)
	src_dst_reg $B$NCM$K(Bimm_mask $B$N%^%9%/$r3]$1(B, $B$=$l$H(Bimm_value $B$H$N(B
  	bit-wise-OR$B$r(B src_dst_reg $B$KCV$/(B.

  $B!&(Bb_ExtractBitField (src_reg, imm_mask, dst_reg)
	src_reg $B$NCM$K(Bimm_mask $B$N%^%9%/$r3]$1$FFI$_=P$7$?CM$r(B dst_reg $B$KCV$/(B.

<Examples>
<Test>
<Explanation>
  dst_reg $B$N%?%0It$O(B src_reg $B$HF1$8(B
  imm_mask $B$O(B Bit1 $B$,%^%9%/$NBP>](B($BA`:nBP>]%U%#!<%k%I(B),Bit0$B$,CM$NJ]B8$r<($9(B.
  $B$?$@$7(B, imm_mask $B$H(B imm_value $B$N4V$N4X78$K$D$$$F$O%A%'%C%/$7$F$$$J$$(B.
***CAUTION*** imm_mask $B$N0UL#$,(BV02$B$H5U$K$J$C$?!#(B(Bit0 <-> Bit1)

<ETC>
********************************************************************* PSL **/


#PSL_define b_MoveWithNewBitField (src_reg, imm_mask, imm_value, dst_reg)
{
  $USE(D_WorkRegOpe1);
  b_BitwiseAndImmediateWithDNTC(src_reg, imm_mask, D_WorkRegOpe1);
  b_BitwiseOrImmediateWithDNTC(D_WorkRegOpe1, imm_value, dst_reg);
  p_MoveTag(src_reg, dst_reg);
  $RELEASE(D_WorkRegOpe1);   
}

#PSL_define b_ReplaceBitField (src_dst_reg, imm_mask, imm_value)
{
  $USE(D_WorkRegOpe1);
  p_SetImmediateValue(imm_mask, D_WorkRegOpe1);
  p_BitwiseNot(D_WorkRegOpe1, D_WorkRegOpe1);
  b_BitwiseAndWithTag(src_dst_reg, D_WorkRegOpe1, src_dst_reg);
  $RELEASE(D_WorkRegOpe1);
  b_BitwiseOrImmediateWithTag(src_dst_reg, imm_value, src_dst_reg);
}

#PSL_define b_ExtractBitField (src_reg, imm_mask, dst_reg)
{
  b_BitwiseAndImmediateWithTag(src_reg, imm_mask, dst_reg);
}



/******************************************************************** PSL **
3.1 $B%]%$%s%?%l%8%9%?$N99?7!&%o!<%I%9%?%C%/$NA`:n(B

       written by goto@icot22      Fri Nov 11 12:11:44 1988

<Arguments>
	stack_ptr_reg: stack pointer reg
	pop_dt_reg: popped data destination register
	push_dt_reg: pushed data source regsiter
<Temporally Used Variables> none
<Level>		basics
<PreCondition>
<Function>	$B%o!<%I%9%?%C%/$+$i%G!<%?(B($B%?%0IU$-%o!<%I(B)$B%]%C%W$^$?$O%W%C%7%e(B
<Examples>
<Test>
<Explanation>
  $B%?%0IU$-%o!<%I%"%I%l%9$NC10L$G%"%I%l%9%l%8%9%?(B(wd_addr_reg)$B$r%$%s%/%j%a%s%H(B/
  $B%G%/%j%a%s%H$9$k(B. ($B%"%I%l%9%l%8%9%?$N%?%0$OJ]B8(B)
  PIM/p, PIM/k $B$J$I$N%P%$%H%"%I%l%9%^%7%s$G$O(B, _WORD_ADDR_INCR/DECR_OFST $B$N(B
  $BCM$rJQ99$9$kI,MW$"$j!#(B
<ETC>
  b_PopWordStack $B$G$O(B, $B%Q%$%W%i%$%s%W%m%;%C%5$r2>Dj$7$F(B, read $B8e$K(B $B%9%?%C%/(B
  $B%]%$%s%?$r99?7$7$F$$$k$,(B, $B0UL#$H$7$F$O(B, "decrement and pop" $B$G$"$k$3$H$K(B
  $BCm0U(B.
********************************************************************* PSL **/

/* ADDR_define $B$J$N$G(B PIM/p, PIM/k $B$G$bCM$rJQ99$7$J$/$FNI$$(B */
#ADDR_define _WORD_OFFSET		1
#ADDR_define _WORD_ADDR_INCR_OFST	1
#ADDR_define _WORD_ADDR_DECR_OFST	-1

#PSL_define b_IncrementAddrReg (addr_reg)
{
  @REGOPE_OPT {
    _IncrementReg( addr_reg );
  } else {
    b_AddImmediateWithTag (addr_reg, _WORD_OFFSET, addr_reg);
/* p_AddImmediate (reg, _WORD_OFFSET, reg);   for PIM/k ??? */
  };
}

#PSL_define b_DecrementAddrReg (addr_reg)
{
  @REGOPE_OPT {
    _DecrementReg ( addr_reg );
  } else {
    b_SubtractImmediateWithTag (addr_reg, _WORD_OFFSET, addr_reg);
/* p_SubtractImmediate (reg, _WORD_OFFSET, reg);   for PIM/k ??? */
  };
}

#PSL_define b_PopWordStack(stack_ptr_reg, dst_dt_reg)
{
  p_ReadWithOffset (stack_ptr_reg, _WORD_ADDR_DECR_OFST, dst_dt_reg);
  b_DecrementAddrReg (stack_ptr_reg);
}

#PSL_define b_PushWordStack(stack_ptr_reg, src_dt_reg)
{
  p_Write(src_dt_reg, stack_ptr_reg);
  b_IncrementAddrReg (stack_ptr_reg);
}

/******************************************************************** PSL **
3.2  $BL?NaCf$N%$%_%G%#%(!<%H%U%#!<%k%I$r%l%8%9%?$K(BMove$B$9$kA`:n(B

       written by goto@icot22      on Wed Mar 22 10:36:28 1989

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_MoveImmOprWithMRBandType(opr_imm_value,imm_mrb,imm_type,dst_reg)
{
  p_MoveImmediateValueFromImmediateField (opr_imm_value, dst_reg);
  p_SetImmediateTag (imm_type, imm_mrb, dst_reg);
}

/******************************************************************** PSL **
3.3  $BB(CM$G%7%U%HNL$r;XDj$9$k%7%U%HA`:n(B ($B%?%0$OITDj(B) 
       written by goto@icot22      on Fri Jun 30 16:46:01 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B7k2L%l%8%9%?$N%?%0It$OITDj$K$J$k$3$H$KCm0U(B.
  -> p$B%l%Y%k$N0UL#$,JQ$o$C$?$N$G!"%G%9%F%#%M!<%7%g%s%?%0J]B8!#(B
********************************************************************* PSL **/

#PSL_define b_ShiftLeftImmediate (src_reg, imm_shift, dst_reg)
{
  $USE(D_WorkRegOpe1);
  p_SetImmediateValue (imm_shift, D_WorkRegOpe1);
  p_ShiftLeft (src_reg, D_WorkRegOpe1, dst_reg);
  $RELEASE(D_WorkRegOpe1);
}

#PSL_define b_ShiftRightImmediate (src_reg, imm_shift, dst_reg)
{
  $USE(D_WorkRegOpe1);
  p_SetImmediateValue (imm_shift, D_WorkRegOpe1);
  p_ShiftRight (src_reg, D_WorkRegOpe1, dst_reg);
  $RELEASE(D_WorkRegOpe1);
}


/******************************************************************** PSL **
3.4  $BMWAG0LCV$r%"%I%l%9%*%U%;%C%H$KJQ49$9$kA`:n(B 
     $B$*$h$S$=$N5U(B

       written by f-doumae@icot22      on Wed Aug 30 12:48:35 1989
<Arguments>
    elmpos_reg : $BMWAG0LCV(B
    ofst_reg   : $B%"%I%l%9%*%U%;%C%H(B(dest)

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
    $BMWAG0LCV$r%"%I%l%9%*%U%;%C%H$KJQ49$9$k!#(B
        ( elmpos_reg $B$N%?%0$O!"(Bofst_reg $B$N%?%0$H$7$FJ]B8$9$k!#(B)
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
#CONST_define _ELMPOS_OFST_SHIFT_VALUE	0
                                       /* in PIM/p,PIM/k    3 */

#PSL_define b_ExchangeElmposToOffset (elmpos_reg, ofst_reg)
{
  @REGOPE_OPT {
    _ExchangeElmposToOffset (elmpos_reg, ofst_reg);
  } else {
    b_ShiftLeftImmediateWithTag
               (elmpos_reg, _ELMPOS_OFST_SHIFT_VALUE, ofst_reg);
  };
}

#PSL_define b_ExchangeOffsetToElmpos (ofst_reg, elmpos_reg)
{ 
  @REGOPE_OPT {
    _ExchangeOffsetToElmpos (ofst_reg, elmpos_reg);
  } else {
    b_ShiftRightImmediateWithTag
                (ofst_reg, _ELMPOS_OFST_SHIFT_VALUE, elmpos_reg);
  };
}


/******************************************************************** PSL **
3.5  $B%?%$%W$HCM$N@_Dj(B
       written by goto@icot22      on Wed Sep  6 16:46:58 1989
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  VPIM $B$G$O(B, 
  $B!&<B5!%O!<%I%&%'%"$G$O(B, $B%?%0It$OO"B3$7$?(B8$B%S%C%H$+$i$J$k!#(B
  $B!&%?%0It$K(B MRB(1), RB(1), Type(6) $B$N3F%S%C%H$,3d$j?6$i$l$k!#(B
  $B!&%?%01i;;$O(B, 8$B%S%C%HA4BN$KBP$7$F9T$&!#(B
  $B$rA[Dj$9$k!#(B
  $B$3$N$?$a(B,
  	p_SetImmediateTag (imm_type, imm_mrb, dst_reg)
  	p_SetImmediateWord (imm_type, imm_mrb, imm_value, dst_reg)
  $B$K$*$$$F(B, $B%?%$%W(B, MRB $B$N3F%U%#!<%k%I$,FHN)$KM?$($i$l$k$H(B, $B8D!9$NA`:n$O(B
  $BHK;($K$J$k!#(B($B%S%C%HA`:n$,I,MW$H$J$k!#(B)
  $B0lJ}(B, VPIM $B%^%/%m$N5-=R$K$[$H$s$I$O(B, 
  	imm_mrb = _MRB_0 (_MRB_OFF)
  $B$H$7$FB(CM$r@_Dj$7$F$$$k!#$3$N$h$&$J>l9g$NA`:n$,4JC1$K<BAu$G$-$k$h$&$K(B
	b_SetImmTypeMRBoff (imm_type, dst_reg)
	b_SetImmTypeValueMRBoff (imm_type, imm_value, dst_reg)
  $B$rMQ0U$9$k!#$D$^$j(B, PSL$B%3%s%Q%$%i$K$*$$$F$O(B, $B>e5-$N(B2$B$D$N%^%/%m$rE83+$;$:(B,
  $B5!3#8l(B($B%^%$%/%mL?Na(B)$B$XD>@\JQ49$9$k!#(B

  $B$3$3$G(B, imm_type $B$H$7$FM?$($i$l$k(B $B%?%$%W$O(B str_var_type_table.psl.c $B$N$b$N$G(B
  $B$"$j(B, 6 bit $B$GI=8=$5$l$k$,(B, $B<B5!$X$N<BAu$G$O(B $B2<5-$NNc$K<($9$h$&$K(B, $B>e0L(B2bit
  $B$,(B"0" $B$H$J$C$F$$$k(B  8 bit $B$NCM$H$9$k!#(B

		ATOM = 0 --> ATOM, _MRB_OFF = "00 000000"b
		INT  = 1 --> INT,  _MRB_OFF = "00 000001"b
  		LIST = 2 --> LIST, _MRB_OFF = "00 000010"b
  		..................

********************************************************************* PSL **/

#PSL_define b_MoveWithImmTypeMRBoff (src_reg, imm_type, dst_reg)
{
  @REGOPE_OPT {
    _MoveWithImmTypeMRBoff (src_reg, imm_type, dst_reg);
  } else {
    p_MoveValue(src_reg, dst_reg);
    p_SetImmediateTag (imm_type, _MRB_0, dst_reg);
  };
}

#PSL_define b_MoveWithImmTypeMRBon (src_reg, imm_type, dst_reg)
{
  p_MoveValue(src_reg, dst_reg);
  p_SetImmediateTag (imm_type, _MRB_1, dst_reg);
}

#PSL_define b_MoveWithMRBoff (src_reg, dst_reg)
{
  p_MoveWord(src_reg, dst_reg);
  p_SetImmediateMRB (_MRB_0, dst_reg);
}

#PSL_define b_MoveWithMRBon (src_reg, dst_reg)
{
  p_MoveWord(src_reg, dst_reg);
  p_SetImmediateMRB (_MRB_1, dst_reg);
}

#PSL_define b_SetImmValueDNTC(imm_value, dst_reg)
{
  @REGOPE_OPT{
    _SetImmValueDNTC(imm_value, dst_reg);
  } else {
    p_SetImmediateWord(DNTC, _MRB_0, imm_value, dst_reg);
  };
}

#PSL_define b_SetImmTypeValueMRBoff (imm_type, imm_value, dst_reg)
{
  p_SetImmediateWord(imm_type, _MRB_0, imm_value, dst_reg);
}

#PSL_define b_SetImmTypeValueMRBon (imm_type, imm_value, dst_reg)
{
  p_SetImmediateWord(imm_type, _MRB_1, imm_value, dst_reg);
}

#PSL_define b_SetImmTypeMRBoff (imm_type, dst_reg)
{
  p_SetImmediateTag(imm_type, _MRB_0, dst_reg);
}

#PSL_define b_SetImmTypeMRBon (imm_type, dst_reg)
{
  p_SetImmediateTag(imm_type, _MRB_1, dst_reg);
}

/******************************************************************** PSL **
3.6 $BIT@5%]%$%s%?$N%;%C%H!?%A%'%C%/(B

b_SetIllegalPointer
b_IfIllegalPointer
b_IfNotIllegalPointer

       written by ttakagi@icot22      on Wed Feb 13 10:20:13 1991

<Arguments>
 reg: $B%]%$%s%?$,F~$C$F$$$k$H;W$o$l$k%l%8%9%?(B

<Temporally Used Variables>
<Level>
<PreCondition>
$B!&IT@5%]%$%s%?$r<($9$b$N$O(B D_NULL $B$G$"$k$3$H$,>r7o$K$J$k!#(B

<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B8=:_$O0BA4$N$?$a%o!<%IHf3S$r$7$F$$$k(B
  $B%j%;%C%H$O!"=hM}$,@5>oF0:n$7$?;~$K2?$i$+$N%]%$%s%?$,%;%C%H$5$l$k$N$G!"$J$$!#(B
********************************************************************* PSL **/

#PSL_define b_SetIllegalPointer(reg)
{
  p_MoveWord(D_NULL, reg);
}

#CTRL_define b_IfIllegalPointer(reg)
{
  b_IfWordEq(reg, D_NULL)
}

#CTRL_define b_IfNotIllegalPointer(reg)
{
  b_IfWordNotEq(reg, D_NULL)
}

/******************************************************************** PSL **
3.7 D_ONE$B$H(BD_NULL$B$GH=Dj$9$k%U%i%0$N@_Dj$H%F%9%H(B

b_SetRegFlagOn
b_SetRegFlagOff
b_IfRegFlagOn
b_IfRegFlagOff

       written by ttakagi@icot22      on Mon Mar  4 15:55:39 1991

<Arguments>
 flag_reg: $B%U%i%0(B($B%l%8%9%?(B)

<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B%U%i%0(B  ON  ---> D_ONE
         OFF  ---> D_NULL
<ETC>
  $B%^%/%m$NL>A0$,0-$$$+$bCN$l$J$$(B($BC/$+$$$$L>A0$r9M$($F(B)
  $B$b$C$H8zN($NNI$$J}K!$K$9$Y$-!)(B($B%o!<%IHf3S$O$b$C$?$$$J$$(B)
********************************************************************* PSL **/

#PSL_define b_SetRegFlagOn(flag_reg)
{
  p_MoveWord(D_ONE, flag_reg);
}

#PSL_define b_SetRegFlagOff(flag_reg)
{
  p_MoveWord(D_NULL, flag_reg);
}

#CTRL_define b_IfRegFlagOn(flag_reg)
{
  b_IfEqual(flag_reg, D_ONE)
}
/* D_ONE $B$N%?%0$O(B DNTC $B$G$"$j!"(B*/
/* PIM/p $B$G$O!"<B:];2>H$9$k$?$S$KCM$,0[$J$jF@$k$N$G!"(B */
/* b_IfWordEq $B$r(B b_IfEqual $B$KD>$7$?!#(B*/
/* 92.03.27 yamamoto */

#CTRL_define b_IfRegFlagOff(flag_reg)
{
  b_IfWordEq(flag_reg, D_NULL)
}

/*  4. $B%a%b%j$X$N@_Dj(B */
/* these macros should be defined in b_mem_ope.psl.c ... */

#PSL_define b_WriteImmTagWithOffset (imm_mrb, imm_type, src_reg, dst_reg, ofst)
{
  /* src_reg $B$N%?%0$rJ]B8$9$k;EMM$H$J$C$F$$$k(B */
  @DEBUG{
    b_IfLessImm(D_ONE,imm_mrb){VPIM_ERROR("b_WriteImmTagWithOffset","MRB??");}
  };
  @REGOPE_OPT{
    _WriteImmTagWithOffset(imm_mrb, imm_type, src_reg, dst_reg, ofst);
  } else {
    $USE(D_WorkRegOpe1);
    p_MoveWord (src_reg, D_WorkRegOpe1);
    p_SetImmediateTag(imm_type, imm_mrb, D_WorkRegOpe1);
    p_WriteWithOffset (D_WorkRegOpe1, dst_reg, ofst);
    $RELEASE(D_WorkRegOpe1);
  };
}


#PSL_define b_WriteDNTCWithOffset(src_reg,addr_reg,offset)
{
  @REGOPE_OPT{
    _WriteImmTagWithOffset(_MRB_0, DNTC, src_reg, addr_reg, offset);
  } else {
    $USE(D_WorkRegOpe1);
    p_MoveWord(src_reg,D_WorkRegOpe1);
    p_SetImmediateTag(DNTC,_MRB_0,D_WorkRegOpe1);
    p_WriteWithOffset(D_WorkRegOpe1,addr_reg,offset);
    $RELEASE(D_WorkRegOpe1);
  };
}
