
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_mem_local.psl.c
   ----- CREATED   : by imai@icot22, on Thu Jun 14 18:52:12 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Oct 28 11:39:46 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 

  $B%m!<%+%k%a%b%j$O!"(BVPIM$B$G$O2>Dj$7$J$$!#6&M-%a%b%j6u4V$N0lIt$r#8J,3d$7!"(B
  $B3F%W%m%;%C%5$K3d$jIU$1$k!#$?$@$7!"(BPIM/p $B$d(B PIM/i $B$N$h$&$K%m!<%+%k(B
  $B%a%b%j$r;}$C$F$$$k!J%"%I%l%96u4V$N0lIt$r%m!<%+%k%a%b%j$H$7$F$$$k!K(B
  $B%^%7%s$G$O!"$3$N%U%!%$%k$N%^%/%m$rE83+=*C<$H$9$l$P$h$$!#(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
0. $B%m!<%+%k%a%b%jFb$N%a%b%j%^%C%W(B

  $B%m!<%+%k%(%j%"Fb$N%"%I%l%9$O!"#V#P#I#M$G$O@dBP%"%I%l%9$G$O$J$/!"(B
  $B%W%m%;%C%5%m!<%+%k%(%j%"$N@hF,$+$i$NAjBP%"%I%l%9$G$"$k!#(B

       written by imai@icot22      on Fri Jun 15 11:01:39 1990
********************************************************************* PSL **/

/* --> definition is moved to bsc_mem_map.psl.c */

/******************************************************************** PSL **
$B#1(B $B%m!<%+%k%a%b%j$KBP$9$k(B Read/Write

  b_ReadWithOffsetLocalMemory(src_addr_reg,imm_ofst,dst_reg)
  b_WriteWithOffsetLocalMemory(src_reg,dst_addr_reg,imm_ofst)

       written by imai@icot22      on Fri Jun 15 10:56:01 1990
<Arguments>
  (src/dst)_addr_reg:
    $B3F#P#E$N%m!<%+%k%a%b%jNN0h$N@hF,$r#0HVCO$H$7$?;~$N%"%I%l%9(B
    $B%m!<%+%k%a%b%j$r;}$?$J$$(BVPIM$B$N$h$&$J%^%7%s$G$O!"6&M-%a%b%j$N(B
    $B%"%I%l%9$K$3$N%^%/%m$NCf$GJQ49$9$k!#(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/


#PSL_define b_ReadWithOffsetLocalMemory(src_addr_reg,imm_ofst,dst_reg)
{
  /* PIM/p $B$G$O(B p_ReadWithOffset $B$HEy2A(B */
  $USE(D_WorkAddr);
  b_ConvertLocalMemAddrToGlobalMemAddr(src_addr_reg,D_WorkAddr);
  p_ReadWithOffset(D_WorkAddr,imm_ofst,dst_reg);
  $RELEASE(D_WorkAddr);
}

#PSL_define b_WriteWithOffsetLocalMemory(src_reg,dst_addr_reg,imm_ofst)
{
  /* PIM/p $B$G$O(B p_WriteWithOffset $B$HEy2A(B */
  $USE(D_WorkAddr);
  b_ConvertLocalMemAddrToGlobalMemAddr(dst_addr_reg,D_WorkAddr);
  p_WriteWithOffset(src_reg,D_WorkAddr,imm_ofst);
  $RELEASE(D_WorkAddr);
}

#PSL_define b_ConvertLocalMemAddrToGlobalMemAddr
			(local_addr_reg,global_addr_reg)
{
  /* PIM/p $B$G$O!"(Bp_MoveWord(local_addr_reg,global_addr_reg) $B$@$1$G$h$$(B */
  @DEBUG{
    b_IfLess(local_addr_reg,D_NULL) {
      VPIM_ERROR("b_ConvertLocalMemAddrToGlobalMemAddr",
		 "Illegal local_addr_reg");
    }
/*  b_IfGreaterEqImm(local_addr_reg,_SIZE_OF_LOCAL_AREA) { */
    b_IfGreaterImm(local_addr_reg,_SIZE_OF_LOCAL_AREA) { 
      VPIM_ERROR("b_ConvertLocalMemAddrToGlobalMemAddr",
		 "Illegal local_addr_reg");
    }
  };
  $USE(D_WorkLocalAreaBase);
  b_GetPELocalAreaBase(D_WorkLocalAreaBase);
  b_AddWithTag(local_addr_reg,D_WorkLocalAreaBase,global_addr_reg);
  $RELEASE(D_WorkLocalAreaBase);

}

#PSL_define b_GetPELocalAreaBase (dst_base_reg) 
{
  b_MultiplyImmediateWithDNTC (D_PE_Number,_SIZE_OF_LOCAL_AREA, dst_base_reg);
        /* $B>e$N(B Multiply $BL?Na$O!"%7%U%HL?Na$GCV$-49$(2DG=$G$"$k(B $B!#(B
         * $B<B5!$K$h$C$F$O8!F$$9$Y$-!#(B         */
  b_AddImmediateWithDNTC (dst_base_reg, _LOCAL_AREA_BASE, dst_base_reg);
	/* but, currently _LocalAreaBase = 0 */

  /* PIM/p $B$G$O(B p_MoveWord(D_NULL,dst_base_reg) $B$@$1$G$h$$(B */
}

/******************************************************************** PSL **
$B%m!<%+%k%a%b%j%"%I%l%9$H!"B(CM$NHf3S(B
       written by imai@icot22      on Fri Jun 15 14:06:56 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  PIM/p $B$N$h$&$K!"%m!<%+%k%a%b%j$,#0HVCO$+$i3d$jIU$1$i$l$F$$$k%^%7%s$G$O!"(B

#CTRL_define b_IfGreaterLocalAreaAddress(addr_reg,imm_local_area_address)
{
  b_IfGreaterImm(addr_reg,imm_local_area_address)
}
  $B$G$h$$(B
********************************************************************* PSL **/

#CTRL_define b_IfGreaterEqualLocalAreaAddress(addr_reg,imm_local_area_address)
{
  $USE(D_WorkAddr);
  b_ConvertLocalMemAddrToGlobalMemAddr(addr_reg,D_WorkAddr);
  p_CompareImmediate(D_WorkAddr,imm_local_area_address);
  $RELEASE(D_WorkAddr);
  p_IfGE()
}

#CTRL_define b_IfLessLocalAreaAddress(addr_reg,imm_local_area_address)
{
  $USE(D_WorkAddr);
  b_ConvertLocalMemAddrToGlobalMemAddr(addr_reg,D_WorkAddr);
  p_CompareImmediate(D_WorkAddr,imm_local_area_address);
  $RELEASE(D_WorkAddr);
  p_IfLT()
}

#CTRL_define b_IfEqualLocalAreaAddress(addr_reg,imm_local_area_address)
{
  $USE(D_WorkAddr);
  b_ConvertLocalMemAddrToGlobalMemAddr(addr_reg,D_WorkAddr);
  p_CompareImmediate(D_WorkAddr,imm_local_area_address);
  $RELEASE(D_WorkAddr);
  p_IfEQ()
}

#CTRL_define b_IfNotEqualLocalAreaAddress(addr_reg,imm_local_area_address)
{
  $USE(D_WorkAddr);
  b_ConvertLocalMemAddrToGlobalMemAddr(addr_reg,D_WorkAddr);
  p_CompareImmediate(D_WorkAddr,imm_local_area_address);
  $RELEASE(D_WorkAddr);
  p_IfNE()
}



