
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_mem_global.psl.c
   ----- CREATED   : by imai@icot22, on Mon May 28 15:20:41 1990
   ----- LAST SAVED: by ttakagi@icot22, on Fri Jun 26 17:39:10 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%7%9%F%`6&M-%(%j%"$NA`:n(B

  $B%7%9%F%`6&M-%(%j%"$O(B, $B%/%i%9%?Fb$N%W%m%;%C%5$K$h$C$F6&M-$5$l$kNN0h$G$"$j(B,
  $B0J2<$N$h$&$J>pJs$,CV$+$l$k!#(B

 0000	+-------+ $B%W%m%;%C%5(B
	|	| $B6I=j%(%j%"(B			  <-- _GLOBAL_AREA_BASE
	+-------+ - - - - - - - +-------+ <-- _SYSTEM_CONFIG_AREA_BASE
	|	|		| 	|
	|	|		|	| _SIZE_OF_SYSTEM_CONFIG_AREA
	|	|		|	|	|
	|	| $B%7%9%F%`(B	+-------+ <-- _MEM_MANAGE_AREA_BASE
	|	|		|       |	|
	|	| $B6&M-%(%j%"(B	|	| _SIZE_OF_MEM_MANAGE_AREA
	|	|		|	|	|
	|	|		+-------+ <-- _COMM_AREA_BASE
	|	|		|	| 	|
	|	|		|	| _SIZE_OF_COMM_AREA
	+-------+		|	|	|
	|	|\  		+-------+ <-- _SYSTEM_CODE_AREA_BASE
	|	| \    		|       |	|
	|	|  \	      	|	| _SIZE_OF_SYSCODE_AREA
	|	|   \	 	|       |	|
	|	|    \	   	+-------+ <-- _DUMMY_FOSTER_PARENT_AREA_BASE
	| $B%R!<%W(B|     \	     	|	|	|
	|	|      \     	|	| _SIZE_OF_DUMMY_FOSTER_PARENT_AREA
	|	|	\     	|	|	|
	|	|	 \	+-------+ <-- _TRADE_AREA_BASE
	|	|	  \	|	|	|
	|	|	   \	|	| _SIZE_OF_TRADE_AREA
	|	|	    \	|	|	|
	|	|	     \	+-------+ ------------------
	|	|	      \	|	| (not used now)
	|	|	       \+-------+ <-- _HEAP_AREA_BASE
 XXXX	+-------+ _SIZE_OF_MEMORY

 $B!&(BSystemConfigArea	: $B%7%9%F%`$N9=@.$J$I$N>pJs$r3JG<$9$kNN0h(B
 $B!&(BMemManageArea	: $B%/%i%9%?FbA4BN$N%a%b%j4IM}$KMQ$$$k%Q%i%a!<%?Ey$NNN0h(B
 $B!&(BCommArea		: $B%/%i%9%?Fb$NDL?.$KMQ$$$k%Q%i%a!<%?Ey$NNN0h(B
 $B!&(BSystemCodeArea	: $B%7%9%F%`%3!<%I(B(D-Code$B$J$I(B)$B$rCV$/NN0h(B
 $B!&(BDummyFosterParentArea: $B%@%_!<N$?F$NNN0h(B
 $B!&(BTradeArea		: $B%/%i%9%?4VDL?.$N$?$a$NM"=PF~I=$NNN0h(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#DATA_define	D_WorkSharedAreaAddr	XXX
#DATA_define	D_WorkCurrentSlot	XXX
#DATA_define	D_WorkAddr		XXX
#DATA_define	D_WorkDebug		XXX /* for @DEBUG */

/******************************************************************** PSL **
1.1  $B%7%9%F%`6&M-%(%j%"$NA`:n(B

       written by goto@icot22      on Mon Feb 13 16:21:10 1989
<Arguments>
  imm_area : $B%7%9%F%`6&M-%(%j%"$N%Y!<%9(B ($BB(CM$N%"%I%l%9(B)
  imm_slot : $B%(%j%"Fb$N%9%m%C%HL>(B ($BB(CM$N%"%I%l%9%*%U%;%C%H(B)
  src_reg : $B%=!<%9%l%8%9%?(B
  dst_reg : $B%G%9%F%#%M!<%7%g%s%l%8%9%?(B
  org_reg : $B%3%s%Z%"%9%o%C%WMQ(B
  new_reg : $B%3%s%Z%"%9%o%C%WMQ(B
<Temporally Used Variables>
  D_WorkSharedAreaAddr : 
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_ReadSharedArea (imm_area, imm_slot, dst_reg)
{
  $USE(D_WorkSharedAreaAddr);
  b_SetImmValueDNTC (imm_area, D_WorkSharedAreaAddr);
  p_ReadWithOffset ( D_WorkSharedAreaAddr, imm_slot, dst_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define b_WriteSharedArea (src_reg, imm_area, imm_slot)
{
  $USE(D_WorkSharedAreaAddr);
  b_SetImmValueDNTC (imm_area, D_WorkSharedAreaAddr);
  p_WriteWithOffset ( src_reg, D_WorkSharedAreaAddr, imm_slot);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define b_ReadWithLockSharedArea (imm_area, imm_slot, dst_reg)
{
  $USE(D_WorkSharedAreaAddr);
  b_SetImmValueDNTC (imm_area, D_WorkSharedAreaAddr);
  p_ReadWithLockWithOffset ( D_WorkSharedAreaAddr, imm_slot, dst_reg);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define b_WriteAndUnlockSharedArea (src_reg, imm_area, imm_slot)
{
  $USE(D_WorkSharedAreaAddr);
  b_SetImmValueDNTC (imm_area, D_WorkSharedAreaAddr);
  p_WriteAndUnlockWithOffset (src_reg, D_WorkSharedAreaAddr, imm_slot);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define b_UnlockSharedArea (imm_area, imm_slot)
{
  $USE(D_WorkSharedAreaAddr);
  b_SetImmValueDNTC (imm_area, D_WorkSharedAreaAddr);
  p_UnlockWithOffset (D_WorkSharedAreaAddr, imm_slot);
  $RELEASE(D_WorkSharedAreaAddr);
}

#PSL_define b_CompareSwapSharedAreaX (imm_area, imm_slot, org_reg, new_reg)
{
  $USE(D_WorkCurrentSlot);
  b_ReadWithLockSharedArea (imm_area, imm_slot, D_WorkCurrentSlot);
  b_IfWordEq (org_reg, D_WorkCurrentSlot) {
    b_WriteAndUnlockSharedArea (new_reg, imm_area, imm_slot);
  } else { 
    b_UnlockSharedArea (imm_area, imm_slot); 
    p_MoveWord (D_WorkCurrentSlot, org_reg); /* org_reg $B$,99?7$5$l$k(B */
  }
  $RELEASE(D_WorkCurrentSlot); 
}

#PSL_define b_PushLinkSharedAreaX (dt_addr_reg,imm_area,imm_slot,imm_link_pos)
{
  $USE(D_WorkNewCS);
  b_ReadSharedArea(imm_area, imm_slot, D_WorkNewCS);
  @DEBUG{
    $USE(D_WorkDebug);
    p_Read(dt_addr_reg,D_WorkDebug);
    b_CheckFLC(D_WorkDebug);
    $RELEASE(D_WorkDebug);
  };
Retry:
  p_WriteWithOffset(D_WorkNewCS, dt_addr_reg, imm_link_pos);
  b_CompareSwapSharedAreaX(imm_area, imm_slot, D_WorkNewCS, dt_addr_reg);
  p_IfNE() { goto Retry; }
  $RELEASE(D_WorkNewCS);
}

/******** for Debug *******/
#PSL_define b_PushExpRecLinkX (dt_addr_reg,imm_area,imm_slot,imm_link_pos)
{
  $USE(D_WorkNewCS);
  b_ReadSharedArea(imm_area, imm_slot, D_WorkNewCS);
Retry:
  p_WriteWithOffset(D_WorkNewCS, dt_addr_reg, imm_link_pos);
  b_CompareSwapSharedAreaX(imm_area, imm_slot, D_WorkNewCS, dt_addr_reg);
  p_IfNE() { goto Retry; }
  $RELEASE(D_WorkNewCS);
}
/******** end of Debug *******/

#PSL_define b_PopLinkSharedAreaX  (dt_addr_reg,imm_area,imm_slot,imm_link_pos)
{
  $USE(D_WorkNewCS);
  b_ReadSharedArea(imm_area, imm_slot, dt_addr_reg);
  @DEBUG{
    b_IfEOL(dt_addr_reg) {VPIM_ERROR("b_PopLinkSharedAreaX", "Link-empty!");}
  };
Retry:
  p_ReadWithOffset(dt_addr_reg, imm_link_pos, D_WorkNewCS);
  b_CompareSwapSharedAreaX(imm_area, imm_slot, dt_addr_reg, D_WorkNewCS);
  p_IfNE() { goto Retry; }
  $RELEASE(D_WorkNewCS);
}

#PSL_define b_IncrementSharedAreaX (imm_area,imm_slot,dst_reg)
{
  b_ReadWithLockSharedArea (imm_area, imm_slot, dst_reg);
  b_IncrementReg (dst_reg);
  b_WriteAndUnlockSharedArea (dst_reg, imm_area, imm_slot);
}

#PSL_define b_ReadOldAndAddValueSharedAreaX
		(imm_area,imm_slot,old_reg,value_reg,new_reg)
{
  b_ReadWithLockSharedArea (imm_area, imm_slot, old_reg);
  b_AddWithTag (old_reg, value_reg, new_reg);
  b_WriteAndUnlockSharedArea (new_reg, imm_area, imm_slot);
}

#PSL_define b_SoftLockSharedAreaX (imm_area,imm_slot,dst_reg)
{
  LOOP() {
    b_ReadSharedArea(imm_area, imm_slot, dst_reg);
    b_IfNotSLOCK(dst_reg) {
      b_ReadWithLockSharedArea(imm_area, imm_slot, dst_reg);
      b_IfNotSLOCK(dst_reg) {
        $USE(D_WorkLock);
        b_MoveWithImmTypeMRBoff(dst_reg, SLOCK, D_WorkLock);
        b_WriteAndUnlockSharedArea(D_WorkLock, imm_area, imm_slot);
        $RELEASE(D_WorkLock);
        break ;
      } else {
        b_UnlockSharedArea(imm_area, imm_slot);
      }
    }
  }
}

#DATA_define D_WorkLockedReg	XXX

#PSL_define b_SoftUnlockSharedAreaX (src_reg,imm_area,imm_slot)
{
  $USE(D_WorkLockedReg);
  b_ReadWithLockSharedArea(imm_area, imm_slot, D_WorkLockedReg);
  @DEBUG{
    b_IfNotSLOCK(D_WorkLockedReg) {
      VPIM_ERROR("b_SoftUnlockSharedAreaX","Lock-Pattern Is Not SLOCK!!");
    }
  };
  $RELEASE(D_WorkLockedReg);
  b_WriteAndUnlockSharedArea(src_reg, imm_area, imm_slot);
}

#PSL_define b_SoftUnlockWithOrgTagSharedAreaX (src_reg,imm_area,imm_slot)
{
  $USE(D_WorkLockedReg);
  b_ReadWithLockSharedArea(imm_area, imm_slot, D_WorkLockedReg);
  @DEBUG{
    b_IfNotSLOCK(D_WorkLockedReg) {
      VPIM_ERROR("b_SoftUnlockWithOrgTagSharedAreaX",
		         "Lock-Pattern Is Not SLOCK!!");
    }
  };
  p_MoveTag(src_reg, D_WorkLockedReg);
  b_WriteAndUnlockSharedArea(D_WorkLockedReg, imm_area, imm_slot);
  $RELEASE(D_WorkLockedReg);
}

/******************************************************************** PSL **
2. $B%7%9%F%`%3%s%U%#%.%e%l!<%7%g%s%(%j%"(B

       written by imai@icot22      on Thu Mar 23 12:05:40 1989

	b_ReadPENumInCluster (dst_reg)	   $B%/%i%9%?Fb#P#EBf?t$NFI$_9~$_(B
	b_ReadClusterNumInSystem (dst_reg) $B%7%9%F%`Fb%/%i%9%?Bf?t$NFI$_9~$_(B
	b_ReadClusterHaltFlag (dst_reg)	   $B%/%i%9%?Dd;_%U%i%0$NFI$_9~$_(B
	b_WriteClusterHaltFlag (src_reg)   $B%/%i%9%?Dd;_%U%i%0$N=q$-9~$_(B

<Explanation>
  $B%7%9%F%`$N9=@.$J$I$N>pJs$r3JG<$9$kNN0h(B
	$B%/%i%9%?Fb$N(BPE$BBf?t(B, $B%7%9%F%`Fb$N%/%i%9%??t(B, etc.
        $B%/%i%9%?Dd;_%U%i%0(B

     _SYSTEM_CONFIG_AREA_BASE ->+----------------+  = _GLOBAL_AREA_BASE
				|$B%/%i%9%?Fb(BPE$BBf?t(B|
				|----------------|
				|$B%7%9%F%`Fb(BCL$BBf?t(B|
				|----------------|
				|$B%/%i%9%?Dd;_(BFlag|
				|----------------|
  				:                :
				|----------------| <--- _MEM_MANAGE_AREA_BASE

<ETC>

	_CLUSTER_HALT_FLAG_OFST
	  0 : RUN
  	  1 : HALT
	$B$G$"$j!"(BPIM/s$B$r@5>o=*N;$5$;$k$?$a$K!"%"%$%I%k%4!<%k$O(B
	$B>o$K$3$N%U%i%0$r4F;k$9$k!#(B
********************************************************************* PSL **/

#ADDR_define	_PE_NUM_IN_CL_OFST	0
#ADDR_define	_CL_NUM_IN_SYSTEM_OFST	1
#ADDR_define	_CL_HALT_FLAG_OFST	2

#PSL_define b_ReadPENumInCluster (dst_reg)
{
  b_ReadSharedArea (_SYSTEM_CONFIG_AREA_BASE, _PE_NUM_IN_CL_OFST, dst_reg);
}

#PSL_define b_ReadClusterNumInSystem (dst_reg)
{
  b_ReadSharedArea (_SYSTEM_CONFIG_AREA_BASE, _CL_NUM_IN_SYSTEM_OFST, dst_reg);
}

#PSL_define b_ReadClusterHaltFlag (dst_reg)
{
  b_ReadSharedArea (_SYSTEM_CONFIG_AREA_BASE, _CL_HALT_FLAG_OFST, dst_reg);
}

#PSL_define b_WriteClusterHaltFlag (src_reg)
{
  b_WriteSharedArea (src_reg, _SYSTEM_CONFIG_AREA_BASE, _CL_HALT_FLAG_OFST);
}

/******************************************************************** PSL **

       written by f-takei@icot22      on Wed Jul  3 21:50:09 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B0l;~E*$K$3$3$K$*$/!#(B
  $B%7%9%F%`9=@.>pJs$r%"%/%;%9$9$k$?$a$N%^%/%m!#(B
<ETC>
********************************************************************* PSL **/

/* $B%3%s%U%#%.%e%l!<%7%g%s(B */
#ADDR_define _SCSI_SYS_CONFIG_AREA_BASE		0x30
#ADDR_define _SCSI_SYS_CONFIG_CL_NUM_OFST	0
#ADDR_define _SCSI_SYS_CONFIG_PE_NUM_OFST	1
#ADDR_define _SCSI_SYS_CONFIG_DEV_NUM_OFST	2
#ADDR_define _SCSI_SYS_CONFIG_PORT_NUM_OFST	3
#ADDR_define _SIZE_OF_SCSI_SYS_CONFIG_AREA	4

#PSL_define b_ReadScsiConfigClusterNumInSystem(ptr_reg, dst_reg)
{
    p_ReadWithOffset(ptr_reg, _SCSI_SYS_CONFIG_CL_NUM_OFST, dst_reg);
}

#PSL_define b_ReadScsiConfigPENumInCluster(ptr_reg, dst_reg)
{
    p_ReadWithOffset(ptr_reg, _SCSI_SYS_CONFIG_PE_NUM_OFST, dst_reg);
}

#PSL_define b_ReadScsiConfigDeviceNumOnScsi(ptr_reg, dst_reg)
{
    p_ReadWithOffset(ptr_reg, _SCSI_SYS_CONFIG_DEV_NUM_OFST, dst_reg);
}

#PSL_define b_ReadScsiConfigScsiPortNum(ptr_reg, dst_reg)
{
    p_ReadWithOffset(ptr_reg, _SCSI_SYS_CONFIG_PORT_NUM_OFST, dst_reg);
}

/******************************************************************** PSL **
3. $B%a%b%j4IM}MQ%(%j%"(B

       written by goto@icot22      Mon Jan  9 13:30:48 1989
	
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  b_InitGlobalHeapTop () : $B6&M-%R!<%W%H%C%W$N=i4|2=(B
  b_ReadWithLockGlobalHeapTop (reg) : $B6&M-%R!<%W%H%C%W$NFI$_$@$7(B
  b_WriteAndUnlockGlobalHeapTop (reg) : $B6&M-%R!<%W%H%C%W$N=q$-9~$_(B
  b_ReadOldAddImmGlobalHeapTopX (dst_old_heap_top,imm_value,dst_new_heap_top) :
  	$B6&M-%R!<%W%H%C%W$NFI$_$@$7$H99?7(B($BB(CM(B)
  b_ReadOldAddGlobalHeapTopX (dst_old_heap_top,value_reg,dst_new_heap_top) :
  	$B6&M-%R!<%W%H%C%W$NFI$_$@$7$H99?7(B($B%l%8%9%?(B)

<Examples>
<Test>
<Explanation>
  $B%/%i%9%?FbA4BN$N%a%b%j4IM}$KMQ$$$k%Q%i%a!<%?Ey$NNN0h(B
	$B6&M-%R!<%W%H%C%W%]%$%s%?(B

				|		|
	_MEM_MANAGE_AREA_BASE ->+---------------+  = _MEM_MANAGE_AREA_BASE
	+ _GLOBAL_HEAP_TOP_OFST	| GlobalHeapTop	|
				|---------------|
				|		|
				|---------------|
  				:               :
				|---------------| <--- COM_AREA_BASE

  VPIM$B$N%l%8%9%?$J$I$,=i4|2=$5$l$kA0$KK\%^%/%m$,8F$S=P$5$l$H2>Dj$7$F$$$k(B.
<ETC>
********************************************************************* PSL **/

#ADDR_define	_GLOBAL_HEAP_TOP_OFST	0
#ADDR_define	_GLOBAL_HEAP_END_OFST	1

#ADDR_define	_STR_ID_COUNTER_OFST	4
#ADDR_define	_STR_TABLE_LOCK_FLAG_OFST	5

#ADDR_define	_EXP_TABLE_ENTRY_FREE_TOP_OFST	8
#ADDR_define	_WIMP_REC_FREE_TOP_OFST	12

#ADDR_define	_MULTI_PACKET_ID_OFST	       16
#ADDR_define	_MULTI_PACKET_TOP_OFST	       17

/******************************************** for PROBE by ttakagi ***/
/* PROBE$BMQ$K$A$g$C$H<Z$j$F$k$@$1$G$9!#L5;k$7$F2<$5$$!#(B */
#ADDR_define    _WEXP_ALLOC_COUNT_OFST         18
#ADDR_define    _WEXP_RECLAIM_COUNT_OFST       19
#ADDR_define    _BEXP_ALLOC_COUNT_OFST         20
#ADDR_define    _BEXP_RECLAIM_COUNT_OFST       21
#ADDR_define    _WIMP_ALLOC_COUNT_OFST         22
#ADDR_define    _WIMP_RECLAIM_COUNT_OFST       23
#ADDR_define    _BIMP_ALLOC_COUNT_OFST         24
#ADDR_define    _BIMP_RECLAIM_COUNT_OFST       25
#ADDR_define    _EX_EXPORT_COUNT_OFST          26
#ADDR_define    _RELEASE_EXPORT_COUNT_OFST     27
#ADDR_define    _DIVIDE_EXPORT_COUNT_OFST      28
#ADDR_define    _INDIRECT_EXPORT_COUNT_OFST    29

#DATA_define D_WorkProbeReg   XXX

#PSL_define b_IncrementSharedAreaProbeX(imm_ofst)
{
  $USE(D_WorkProbeReg);
  b_ReadWithLockSharedArea(_MEM_MANAGE_AREA_BASE, imm_ofst, D_WorkProbeReg);
  b_IncrementReg (D_WorkProbeReg);
  b_WriteAndUnlockSharedArea(D_WorkProbeReg, _MEM_MANAGE_AREA_BASE, imm_ofst);
  $RELEASE(D_WorkProbeReg);
}
/******************************************** for PROBE by ttakagi ***/

#ADDR_define    _NEW_ATOM_COUNTER_OFST  36

#ADDR_define    _FREE_PAGE_TOP_AREA_OFST 40 /* maybe not used */
#ADDR_define	_FREE_PAGE_TOP_AREA_BASE
	(_MEM_MANAGE_AREA_BASE+_FREE_PAGE_TOP_AREA_OFST)
#CONST_define	_MAX_PAGE_FREE_LIST_SIZE	0xf00
#ADDR_define	_FREE_PAGE_TOP_AREA_SIZE	16 /* 0--15 but 0 is not used*/
#ADDR_define	_FREE_PAGE_TOP_AREA_LIMIT
	(_FREE_PAGE_TOP_AREA_BASE+_FREE_PAGE_TOP_AREA_SIZE)

/* ---- PIM/s $B@lMQ(B : $B%3%s%=!<%kF~=PNOMQ$N(B Queue Head $B$H(B Queue Tail ------*/
#ADDR_define	_PIMS_CONSOLE_QUEUE_HEAD	0x100
#ADDR_define	_PIMS_CONSOLE_QUEUE_TAIL	0x101

/************** set_heap_alert $B$GMQ$$$k!"%m%C%/%U%i%0$HJQ?t(B *************/
#ADDR_define    _HEAP_ALERT_LOCK_FLAG_OFST      0x120
#ADDR_define    _HEAP_ALERT_VARIABLE_OFST       0x121
#ADDR_define    _HEAP_ALERT_SIZE_OFST           0x122

#ADDR_define    _HEAP_ALERT_LOCK_FLAG
        (_MEM_MANAGE_AREA_BASE+_HEAP_ALERT_LOCK_FLAG_OFST)
#ADDR_define    _HEAP_ALERT_VARIABLE
        (_MEM_MANAGE_AREA_BASE+_HEAP_ALERT_VARIABLE_OFST)
#ADDR_define    _HEAP_ALERT_SIZE
        (_MEM_MANAGE_AREA_BASE+_HEAP_ALERT_SIZE_OFST)

/*************** set_timer $B$GMQ$$$kJQ?t!J#P#EKh$K$"$k!K(B******************/
#ADDR_define    _ALARM_TIMER_VARIABLE_OFST      0x140  /* 0x140 - 0x147 */

#ADDR_define    _ALARM_TIMER_VARIABLE_BASE
        (_MEM_MANAGE_AREA_BASE+_ALARM_TIMER_VARIABLE_OFST)

/******************** GlobalHeapTop $B$NA`:n(B ****************************/
#PSL_define b_InitGlobalHeapTop ()	/* $B%/%i%9%?Kh$NA`:n(B */
{
  @DEBUG {
    $USE(D_WorkDebug);
    b_SetImmValueDNTC (_COMM_AREA_BASE, D_WorkDebug);
    p_AddImmediate (D_WorkDebug, _SIZE_OF_COMM_AREA, D_WorkDebug);
    b_IfGreaterImm (D_WorkDebug, _HEAP_AREA_BASE){
      VPIM_ERROR ("b_InitGlobalHeapTop", "Illegal _HEAP_AREA_BASE");
    }
    $RELEASE(D_WorkDebug);
  };
  $USE(D_WorkAddr);
  b_SetImmValueDNTC(_HEAP_AREA_BASE,D_WorkAddr);
  b_WriteGlobalHeapTop(D_WorkAddr); /* $BGSB>@)8fITMW(B */
  p_MoveValue(D_HeapHalfAddr,D_WorkAddr);
  b_DecrementAddrReg(D_WorkAddr);
  b_WriteGlobalHeapEnd(D_WorkAddr); /* $BGSB>@)8fITMW(B */
  $RELEASE(D_WorkAddr);
}

#PSL_define b_InitFreePageTop()
{
  $USE(D_WorkAddr);
  b_SetImmValueDNTC(_FREE_PAGE_TOP_AREA_BASE,D_WorkAddr);
  LOOP() {
    p_Write(D_EOL,D_WorkAddr);
    b_IncrementAddrReg(D_WorkAddr);
    b_IfGreaterImm(D_WorkAddr,_FREE_PAGE_TOP_AREA_LIMIT) { break; }
  }
  $RELEASE(D_WorkAddr);
}

#DATA_define D_WorkAddValue XXX

#PSL_define b_ReadOldAddImmGlobalHeapTopX
	(dst_old_heap_top, imm_value, dst_new_heap_top)
{
  $USE(D_WorkAddValue);
  b_SetImmValueDNTC (imm_value, D_WorkAddValue);
  b_ReadOldAndAddValueSharedAreaX
      (_MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_TOP_OFST,
       dst_old_heap_top, D_WorkAddValue, dst_new_heap_top);
  $RELEASE(D_WorkAddValue);
}

#PSL_define b_ReadOldAddGlobalHeapTopX
	(dst_old_heap_top, value_reg, dst_new_heap_top)
{
  b_ReadOldAndAddValueSharedAreaX
      (_MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_TOP_OFST,
       dst_old_heap_top, value_reg, dst_new_heap_top);
}

#PSL_define b_ReadWithLockGlobalHeapTop (dst_reg)
{
  b_ReadWithLockSharedArea
    (_MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_TOP_OFST, dst_reg);
}

#PSL_define b_WriteAndUnlockGlobalHeapTop (src_reg)
{
  b_WriteAndUnlockSharedArea
    (src_reg, _MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_TOP_OFST);
}

#PSL_define b_ReadGlobalHeapTop (dst_reg)
{
  b_ReadSharedArea (_MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_TOP_OFST, dst_reg);
}

#PSL_define b_WriteGlobalHeapTop (src_reg)
{
  b_WriteSharedArea (src_reg, _MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_TOP_OFST);
}

#PSL_define b_ReadGlobalHeapEnd (dst_reg)
{
  b_ReadSharedArea (_MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_END_OFST, dst_reg);
}

#PSL_define b_WriteGlobalHeapEnd (src_reg)
{
  b_WriteSharedArea (src_reg, _MEM_MANAGE_AREA_BASE, _GLOBAL_HEAP_END_OFST);
}

#PSL_define b_GetStructIDCounterX (dst_reg)
{
  b_IncrementSharedAreaX (_MEM_MANAGE_AREA_BASE,_STR_ID_COUNTER_OFST,dst_reg);
}

#PSL_define b_InitNewAtomCounter(src_reg)
{
  b_WriteSharedArea (src_reg, _MEM_MANAGE_AREA_BASE,  _NEW_ATOM_COUNTER_OFST);
}

#PSL_define b_GetNewAtomCounterX (dst_reg)
{
  b_IncrementSharedAreaX
	(_MEM_MANAGE_AREA_BASE, _NEW_ATOM_COUNTER_OFST, dst_reg);
}

#PSL_define b_ReadFreePageTop(src_ofst,dst_ptr)
{
  p_ReadWithOffset(src_ofst,_FREE_PAGE_TOP_AREA_BASE,dst_ptr);
}

#PSL_define b_CompareSwapFreePageTopX(src_ofst,old,new)
{
  $USE(D_WorkCS);
  p_ReadWithLockWithOffset(src_ofst,_FREE_PAGE_TOP_AREA_BASE,D_WorkCS);
  p_Compare(D_WorkCS,old);
  p_IfEQ() {
    p_WriteAndUnlockWithOffset(new,src_ofst,_FREE_PAGE_TOP_AREA_BASE);
  } else {
    p_UnlockWithOffset(src_ofst,_FREE_PAGE_TOP_AREA_BASE);
    p_MoveWord(D_WorkCS,old);
  }
  $RELEASE(D_WorkCS);
}

/******************************************************************** PSL **
4. $B%/%i%9%?FbDL?.MQ%(%j%"(B

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  b_ReadCommArea (imm_slot, dst_reg)
  b_WriteCommArea (src_reg, imm_slot)
  b_ReadWithLockCommArea (imm_slot, dst_reg)
  b_WriteAndUnlockCommArea (src_reg, imm_slot)
  b_UnlockCommArea (imm_slot)
  b_CompareSwapCommAreaX (imm_slot, org_reg, new_reg)
<Examples>
<Test>
<Explanation>

  $B%/%i%9%?Fb$NDL?.$KMQ$$$k%Q%i%a!<%?Ey$NNN0h(B
	$B%W%m%;%C%54V$G$N%7%0%J%kDL?.(B ($B%9%j%C%H%A%'%C%/$G8!=P(B) $B$K$*$$$F(B,
  	$BDL?.FbMF$rJdB-$9$k%U%i%0$d%a%$%k%]%9%HEy!#(B

				|		|
	_COMM_AREA_BASE ------->+---------------+
	+ offset		|		|
				|---------------|
				|		|
				|---------------|
  				:               :
				|---------------|

  imm_slot $B$NCM$,(B _SIZE_OF_COMM_AREA $B0J>e$N>l9g$O(BVPIM_ERROR.
<ETC>
********************************************************************* PSL **/

#PSL_define b_ReadCommArea (imm_slot, dst_reg)
{
  @DEBUG { 
    $USE(D_WorkDebug);
    b_SetImmValueDNTC (_SIZE_OF_COMM_AREA, D_WorkDebug);
    b_IfLessEqImm(D_WorkDebug, imm_slot){
      VPIM_ERROR("b_ReadCommArea", "Illegal slot offset");
    }
    $RELEASE(D_WorkDebug);
  };
  b_ReadSharedArea (_COMM_AREA_BASE, imm_slot, dst_reg);
}

#PSL_define b_WriteCommArea (src_reg, imm_slot)
{
  @DEBUG { 
    $USE(D_WorkDebug);
    b_SetImmValueDNTC (_SIZE_OF_COMM_AREA, D_WorkDebug);
    b_IfLessEqImm(D_WorkDebug, imm_slot){
      VPIM_ERROR("b_WriteCommArea", "Illegal slot offset");
    }
    $RELEASE(D_WorkDebug);
  };
  b_WriteSharedArea (src_reg, _COMM_AREA_BASE, imm_slot);
}

#PSL_define b_ReadWithLockCommArea (imm_slot, dst_reg)
{
  @DEBUG { 
    $USE(D_WorkDebug);
    b_SetImmValueDNTC (_SIZE_OF_COMM_AREA, D_WorkDebug);
    b_IfLessEqImm(D_WorkDebug, imm_slot){
      VPIM_ERROR("b_ReadWithLockCommArea", "Illegal slot offset");
    }
    $RELEASE(D_WorkDebug);
  };
  b_ReadWithLockSharedArea (_COMM_AREA_BASE, imm_slot, dst_reg);
}

#PSL_define b_WriteAndUnlockCommArea (src_reg, imm_slot)
{
  @DEBUG { 
    $USE(D_WorkDebug);
    b_SetImmValueDNTC (_SIZE_OF_COMM_AREA, D_WorkDebug);
    b_IfLessEqImm(D_WorkDebug, imm_slot){
      VPIM_ERROR("b_WriteAndUnlockCommArea", "Illegal slot offset");
    }
    $RELEASE(D_WorkDebug);
  };
  b_WriteAndUnlockSharedArea (src_reg, _COMM_AREA_BASE, imm_slot);
}

#PSL_define b_UnlockCommArea (imm_slot)
{
  @DEBUG { 
    $USE(D_WorkDebug);
    b_SetImmValueDNTC (_SIZE_OF_COMM_AREA, D_WorkDebug);
    b_IfLessEqImm(D_WorkDebug, imm_slot){
      VPIM_ERROR("b_UnlockCommArea", "Illegal slot offset");
    }
    $RELEASE(D_WorkDebug);
  };
  b_UnlockSharedArea (_COMM_AREA_BASE, imm_slot);
}


/******************************************************************** PSL **
5. $B%7%9%F%`%3!<%I%(%j%"(B
       written by goto@icot22      on Wed Mar  8 13:43:57 1989

<Explanation>
  $B%7%9%F%`%3!<%I$rCV$/NN0h$G$"$k(B.
	Dcode$B$GI=8=$5$l$?%k!<%A%s$N<B9T7A$r%7%9%F%`$N=i4|2=;~$K%m!<%I$9$k(B.

<ETC>
  $B!&(BVPIM 1.0 $B$K$*$1$k%7%9%F%`%3!<%I$NCV$-J}(B
  $B%7%9%F%`6&DLNN0hCf$N%7%9%F%`%3!<%INN0h@hF,%"%I%l%9(B(_SysCodeAreaBase) $B5Z$S(B
  $B%7%9%F%`%3!<%INN0h%5%$%:(B(_SIZE_OF_SYSCODE_AREA) $B$OK\%U%!%$%k$KDj5A$5$l$F$$$k(B.
  $B%j%s%+$O$"$i$+$8$a$3$N%"%I%l%9$r%*%W%7%g%s$K$h$jCN$C$?>e$G%7%9%F%`%3!<%I$N(B
  $B%*%V%8%'%/%H$r@8@.$9$k(B.
  $B%m!<%@$O%*%V%8%'%/%H$,@5$7$$@hF,%"%I%l%9(B, $B%3!<%I%5%$%:$r;}$C$F$$$k$+%A%'%C%/(B
  $B$N>e%m!<%G%#%s%0$9$k(B.
    $B$3$N%(%j%"$X$N%"%/%;%9$O!"(Bstr_code.psl.c $B;2>H!#(B
********************************************************************* PSL **/

/******************************************************************** PSL **
6. $BKG0W%(%j%"(B
       written by imai@icot22      on Wed May 30 17:23:28 1990

  $BGrM"=P%l%3!<%I!"GrM"F~%l%3!<%I!"9uM"=P%l%3!<%I!"9uM"=P%O%C%7%eI=(B
  $B9uM"F~%l%3!<%I!"9=B$BN%"%I%l%9%O%C%7%eI=!"9=B$BN#I#D%O%C%7%eI=(B
  $B$,CV$+$l$kNN0h$G$"$k!#(B

  $B>\:Y$O!"(Bstr_trade_init.psl.c $B$r;2>H$N$3$H(B
********************************************************************* PSL **/


/******************************************************************** PSL **
7.  $B%7%9%F%`6&M-%(%j%"$N=i4|2=(B

       written by goto@icot22      on Mon Feb 13 17:06:02 1989
<Arguments>
<Temporally Used Variables> D_WorkSharedAreaAddr
<Level>
<PreCondition>
<Function>
  $B%7%9%F%`6&M-%(%j%"(B(_GLOBAL_AREA_BASE $B$+$i(B _HEAP_AREA_BASE $B$N<jA0$^$G(B)$B$r(B D_NULL $B$N(B
  $BCM$r=i4|2=$9$k(B.
<Examples>
  $B%/%i%9%?Kh$K9T=i4|2=A`:n(B
<Test>
<Explanation>
  VPIM$B$N%l%8%9%?$J$I$,=i4|2=$5$l$kA0$KK\%^%/%m$,8F$S=P$5$l$H2>Dj$7$F$$$k(B.
<ETC>
********************************************************************* PSL **/

#PSL_define b_InitGlobalArea ()
{
  $USE(D_WorkAddr);
  b_ReadPENumInCluster(D_WorkAddr);
  b_MultiplyImmediateWithDNTC(D_WorkAddr, _SIZE_OF_LOCAL_AREA, D_WorkAddr);
  @DEBUG{
    b_IfGreaterImm(D_WorkAddr, _GLOBAL_AREA_BASE){
      VPIM_ERROR ("b_InitGlobalArea","Illegal _GLOBAL_AREA_BASE");
    }
  };
  $RELEASE(D_WorkAddr);

/****** $B#P#S#L$G=q$/$H$3$&$J$k$,!"M>$j$KCY$$$N$G(B
	$BD>@\!"#C$G=q$-2<$7$F$$$k!#(B
  $USE(D_WorkSharedAreaAddr);
  b_SetImmValueDNTC (_GLOBAL_AREA_BASE, D_WorkSharedAreaAddr);
  LOOP () {
    b_IfGreaterEqImm (D_WorkSharedAreaAddr, _HEAP_AREA_BASE) break;
    p_WriteImmediateWithOffset
	(_GC_0, _MRB_0, _TYPE_0, _ZERO, D_WorkSharedAreaAddr, _ZERO);
    b_IncrementAddrReg (D_WorkSharedAreaAddr);
  }
  $RELEASE(D_WorkSharedAreaAddr);
*******/
  /* $BDj5AK\BN$O!"(Bmain.c */
  Symmetry_InitGlobalArea(_GLOBAL_AREA_BASE, _HEAP_AREA_BASE);
}
