
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V10/basics/bsc_link_ope.psl.c
   ----- CREATED   : by imai@icot22, on Thu May 31 11:15:46 1990
   ----- LAST SAVED: by imai@icot22, on Tue Dec 25 12:15:23 1990
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B%j%s%/9=B$$KBP$9$k4pK\A`:n$G$"$k%W%C%7%e!?%]%C%W$NDj5A(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%j%s%/$N%W%C%7%eA`:n(B
       written by imai@icot22      on Thu May 31 11:43:09 1990

	1.1 $B%j%s%/%H%C%W$r%l%8%9%?$KJ];}$7$F$$$k>l9g(B
	1.2 $B%j%s%/%H%C%W$r6&M-%a%b%j$KJ];}$7$F$$$k>l9g(B
********************************************************************* PSL **/

/******************************************************************** PSL **
1.1 $B%j%s%/%H%C%W$r%l%8%9%?$KJ];}$7$F$$$k>l9g(B
    b_PushLink	(src_addr_reg, link_top_reg, imm_link_pos)

       written by goto@icot22      Fri Nov 11 13:26:04 1988

<Arguments>
 src_addr_reg :
	$BA^F~$5$l$k%l%3!<%I$X$N%"%I%l%9$rJ];}$7$F$$$k%l%8%9%?(B
 link_top_reg:
	$B%j%s%/$N%H%C%W$r%l%8%9%?$KJ];}$7$F$$$k>l9g$G!"$=$N%l%8%9%?(B
 imm_link_pos :
	$BA^F~$5$l$k%l%3!<%I$N$&$A!"<!$N%j%s%/$X$N%]%$%s%?$r3JG<$7$F$$$k(B
	$B%9%m%C%H0LCV$N(B src_addr_reg$B$+$i$N%*%U%;%C%H(B
<Temporally Used Variables>
<Level>		basics
<PreCondition>
  $B%U%j!<%H%C%W$N%?%0$O!"(Bsrc_addr_reg $B$N%?%0$,$=$N$^$^%3%T!<$5$l$k!#(B
  $B%?%$%W$r@_Dj$7$?$$>l9g!JNc$($P(BFLC$B%?%$%W$K$7$?$$;~!K$K$O!"(B
  $BM=$a(B src_addr_reg $B$N%?%$%W$r@_Dj$7$F$*$$$F$+$iK\%^%/%m$r8F$S=P$9$3$H(B
<Function>
  $B%U%j!<%j%9%H$d%4!<%k%-%e!<$N$h$&$J%j%s%/9=B$$KBP$7$F(B, $B%G!<%?$r%W%C%7%e$9$k(B.
<Examples>
<Test>
<Explanation>
	PIM/p$B$N%^%7%sL?Na$N(BPUSH/POP$B$r;2>H(B
<ETC>
********************************************************************* PSL **/

#PSL_define b_PushLink	(src_addr_reg, link_top_reg, imm_link_pos)
{
  @DEBUG { b_ErrorIfSameRegNum (src_addr_reg, link_top_reg); };
  p_WriteWithOffset (link_top_reg, src_addr_reg, imm_link_pos);
  p_MoveWord (src_addr_reg, link_top_reg);
}

/******************************************************************** PSL **
1.2 $B%j%s%/%H%C%W$r6&M-%a%b%jCf$KJ];}$7$F$$$k>l9g(B	

    b_PushLinkWithOffsetX
	(src_addr_reg,link_top_addr_reg,imm_link_top_addr_offset,imm_link_pos)

       written by imai@icot22      on Thu May 31 11:43:52 1990
<Arguments>
 src_addr_reg :
	$BA^F~$5$l$k%l%3!<%I$X$N%"%I%l%9$rJ];}$7$F$$$k%l%8%9%?(B
 link_top_addr_reg:
	$B%j%s%/$N%H%C%W$r6&M-%a%b%jCf$KJ];}$7$F$$$k>l9g$G!"$=$N%a%b%j%"%I%l%9$r(B
	$BJ];}$7$F$$$k%l%8%9%?(B
 imm_link_pos :
	$BA^F~$5$l$k%l%3!<%I$N$&$A!"<!$N%j%s%/$X$N%]%$%s%?$r3JG<$7$F$$$k(B
	$B%9%m%C%H0LCV$N(B src_addr_reg$B$+$i$N%*%U%;%C%H(B
 imm_link_top_ofst :
	$B%j%s%/$N%H%C%W$r6&M-%a%b%jCf$KJ];}$7$F$$$k>l9g$G!"(Blink_top_addr_reg
	$B$+$i$N(B $B%j%s%/%H%C%W$,=q$+$l$F$$$kHVCO$X$N%*%U%;%C%H(B
<Temporally Used Variables>
<Level>		basics
<PreCondition>
  $B%U%j!<%H%C%W$N%?%0$O!"(Bsrc_addr_reg $B$N%?%0$,$=$N$^$^%3%T!<$5$l$k!#(B
  $B%?%$%W$r@_Dj$7$?$$>l9g!JNc$($P(BFLC$B%?%$%W$K$7$?$$;~!K$K$O!"(B
  $BM=$a(B src_addr_reg $B$N%?%$%W$r@_Dj$7$F$*$$$F$+$iK\%^%/%m$r8F$S=P$9$3$H(B
<Function>
  $B%U%j!<%j%9%H$d%4!<%k%-%e!<$N$h$&$J%j%s%/9=B$$KBP$7$F(B, $B%G!<%?$r%W%C%7%e$9$k(B.
<Examples>
<Test>
<Explanation>
  $B%U%j!<%H%C%W$,6&M-%a%b%jCf$K$"$k$?$a!"F1;~$K(B Push/Pop $B$7$h$&$H$9$k(B
  $B%W%m%;%C%5$,$$$k2DG=@-$,$"$k!#$=$3$G!"GSB>@)8f$,I,MW$K$J$k!#(B

(Push $BA0(B)
src_addr_reg |		 (Push$B$7$?$$%l%3!<%I(B)
+-------+    |			+-------+
|	----------------------->|	|
+-------+    |			|-------|
	     |		   imm_link_pos	|
link_top_addr_reg		+-------+
+-------+    |	|-------|       +-------+       +-------+       +-------+
|      -------->|	|  +--->|       |  +--->|       |  +--->|       |
+-------+    |	|-------|  |    |-------|  |    |-------|  |    |-------|
	     |	|	|  |    |      ----+    |      ----+    |       |
		|	|  |    +-------+       +-------+       +-------+
		|	|  |
		|-------|  |
     imm_link_top_ofst ----+
		|-------|
(Push $B8e(B)
src_addr_reg |
+-------+    |			+-------+
|	-------------------+--->|	|
+-------+    |		   |	|-------|
	     |		   |	|      ---+
link_top_addr_reg	   |	+-------+ |
+-------+    |	|-------|  |    +-------+ |     +-------+       +-------+
|      -------->|	|  |    |       |<+  +->|       |  +--->|       |
+-------+    |	|-------|  |    |-------|    |  |-------|  |    |-------|
	     |	|	|  |    |      ------+  |      ----+    |       |
		|	|  |    +-------+       +-------+       +-------+
		|	|  |
		|-------|  |
     imm_link_top_ofst ----+
		|-------|
<ETC>
********************************************************************* PSL **/

#PSL_define b_PushLinkWithOffsetX
	(src_addr_reg,link_top_addr_reg,imm_link_top_addr_offset,imm_link_pos)
{
  @DEBUG { b_ErrorIfSameRegNum (src_addr_reg, link_top_addr_reg); };
  $USE(D_WorkNewCS);
  p_ReadWithOffset(link_top_addr_reg, imm_link_top_addr_offset, D_WorkNewCS);
Retry:
  p_WriteWithOffset(D_WorkNewCS, src_addr_reg, imm_link_pos);
  b_CompareSwapWithOffsetX
    (link_top_addr_reg, imm_link_top_addr_offset, D_WorkNewCS, src_addr_reg);
  p_IfNE() { goto Retry; }
  $RELEASE(D_WorkNewCS);
}

/******************************************************************** PSL **
2. $B%j%s%/$N%]%C%WA`:n(B

       written by goto@icot22      Fri Nov 11 13:29:50 1988

  2.1 $B%j%s%/%H%C%W$r%l%8%9%?>e$KJ];}$7$F$$$k>l9g(B
  2.2 $B%j%s%/%H%C%W$r6&M-%a%b%j>e$KJ];}$7$F$$$k>l9g(B
********************************************************************* PSL **/

/******************************************************************** PSL **
  2.1 $B%j%s%/%H%C%W$r%l%8%9%?>e$KJ];}$7$F$$$k>l9g(B

  b_PopLink	(dt_addr_reg, link_addr_reg, imm_link_pos)
  b_PopLinkWithTypeMRBoff
	(dt_addr_reg,link_addr_reg,imm_link_pos,imm_type)

       written by imai@icot22      on Thu May 31 13:37:54 1990

<Arguments>
 dt_addr_reg:	$B%]%C%W$5$l$?%l%3!<%I$r;X$9$h$&$K$J$k(B(destination)$B%l%8%9%?(B
 link_addr_reg: $B%j%s%/%H%C%W$rJ];}$7$F$$$k(B(source)$B%l%8%9%?(B
 imm_link_pos:	$B%j%s%/$K7R$,$C$?%l%3!<%ICf$N<!$N%j%s%/$rJ];}$7$F$$$k(B
		$B%9%m%C%H0LCV$N%*%U%;%C%H(B
 imm_type:	dt_addr_reg $B$K@_Dj$5$l$k%]%C%W8e$N%?%$%W(B

<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
	$B%U%j!<%j%9%H$d%4!<%k%-%e!<$N$h$&$J%j%s%/9=B$$+$i(B, $B%G!<%?$r%]%C%W$9$k(B
	$BF1;~$K(Blink_addr_reg$B$N(BMRB, Type$B$r?75,@_Dj$9$k(B.
<Examples>
<Test>
<Explanation>
$B!&$?$@C1$K%]%C%W$9$k>l9g$O(B b_PopLink $B$rMQ$$$k!#%]%C%W8e$N(B dt_addr_reg $B$N(B
  $B%?%$%W$O!"%U%j!<%H%C%W(B(link_addr_reg) $B$N%?%$%W$HF1$8$b$N$,@_Dj$5$l$k!#(B

$B!&%]%C%W8e$N%l%3!<%I$K%?%$%W@_Dj!J(BMRB$B$O!{!K$9$k>l9g$O(B  b_PopLinkWithType
  $B$rMQ$$$k!#$3$l$O!"Nc$($P#1%o!<%I$N%U%j!<%j%9%H$O(B FLC $B%?%$%W$G%j%s%/$K(B
  $B$J$C$F$$$k$,!"JQ?t%;%k$H$7$F;H$&$?$a$K%]%C%W$9$k;~$K$O(B UNDF $B$G=i4|2=(B
  $B$7$?$$$H$$$&$h$&$J>l9g$K;H$&!#(B
<ETC>
	PIM/p$B$N%^%7%sL?Na$N(BPUSH/POP$B$r;2>H(B
********************************************************************* PSL **/

#PSL_define b_PopLink	(dt_addr_reg, link_addr_reg, imm_link_pos)
{
  @DEBUG { b_ErrorIfSameRegNum (dt_addr_reg, link_addr_reg); };
  @DEBUG{
    b_IfEOL(link_addr_reg) {VPIM_ERROR("b_PopLink", "Link empty !");}
  };
  p_MoveWord (link_addr_reg, dt_addr_reg);
  p_ReadWithOffset (link_addr_reg, imm_link_pos, link_addr_reg);
}

#PSL_define b_PopLinkWithTypeMRBoff
		(dt_addr_reg,link_addr_reg,imm_link_pos,imm_type)
{
  @DEBUG { b_ErrorIfSameRegNum (dt_addr_reg, link_addr_reg); };
  @DEBUG{
    b_IfEOL(link_addr_reg){ VPIM_ERROR("b_PopLinkWithTypeMRBoff","Link empty!");}
  };
  b_MoveWithImmTypeMRBoff (link_addr_reg, imm_type, dt_addr_reg);
  p_ReadWithOffset (link_addr_reg, imm_link_pos, link_addr_reg);
}

#PSL_define b_PopLinkWithOffsetX  (dt_addr_reg, link_addr_reg,
                                           imm_link_addr_offset, imm_link_pos)
{
  @DEBUG { b_ErrorIfSameRegNum (dt_addr_reg, link_addr_reg); };
  p_ReadWithOffset(link_addr_reg, imm_link_addr_offset, dt_addr_reg);
  @DEBUG{
    b_IfEOL(dt_addr_reg){ VPIM_ERROR("b_PopLinkWithOffsetX", "Link-empty!");}
  };
  $USE(D_WorkNewCS);
Retry:
  p_ReadWithOffset (dt_addr_reg, imm_link_pos, D_WorkNewCS);
  b_CompareSwapWithOffsetX(link_addr_reg, imm_link_addr_offset, dt_addr_reg, 
                                                                 D_WorkNewCS);
  p_IfNE() goto Retry;
  $RELEASE(D_WorkNewCS);
}
