
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_heap_page.psl.c
   ----- CREATED   : by goto@icot22, on Thu Dec 22 09:43:24 1988
   ----- LAST SAVED: by imai@icot22, on Thu Mar 26 18:00:25 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : basics
   ----- ABSTRACT  : $B%R!<%W$N%Z!<%84IM}(B

a) $B#1%Z!<%8J,$N%R!<%W$N99?7(B
  klb_alloc_list $B$d!"(Bklb_alloc_goal $BEy$+$i8F$P$l$k$?$a!"%R!<%W%j%_%C%H$K(B
  $BC#$7$F$b%5%9%Z%s%I$G$-$J$$!#%j%_%C%HA0$K!VM=Hw%j%_%C%H!W$r@_$1!"$=$l$K(B
  $BE~C#$7$?;~$O!"#G#C5/F0$N$?$a$N%9%j%C%H%A%'%C%/MW0x$r%;%C%H$7!"%j%@%/%7(B
  $B%g%s$rB3$1$k!#(B

b) $B#1%Z!<%80J>e$N%R!<%W$N99?7(B
  new_vector $B$d(B new_string $BEy$NAH$_9~$_=R8l$+$i$N$_8F$P$l$k$?$a!"3NJ]$G$-(B
  $B$J$+$C$?>l9g$K$O$3$l$i$NAH$_9~$_=R8l$r%5%9%Z%s%I$9$k!#(B

c) 1$B%Z!<%80J>e$N%U%j!<%j%9%H4IM}(B
  $B#1%Z!<%80J2<$N9=B$$O!"%W%m%;%C%5Kh$K%U%j!<%j%9%H4IM}$r9T$J$C$F$$$k$,!"(B
  $B#1%Z!<%80J>e$N9=B$$O!"!J8=:_#1#5%Z!<%8$^$G!K%/%i%9%?$G0l$D$N%U%j!<%j%9%H(B
  $B4IM}$r9T$J$C$F$$$k!#(B
  $B#1#5%Z!<%80J>e$N2s<}$N>l9g$O!"#1%Z!<%8Kh$KJ,2r$7$F!"#1%Z!<%8$N%U%j!<%j%9(B
  $B%H$K2s<}$9$k!#(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#CONST_define _SIZE_OF_HEAP_PAGE	256	/* KL1 $B%o!<%I?t(B */
#ADDR_define  _NEXT_HEAP_PAGE_OFST	256	/* $B%"%I%l%9(B */
#CONST_define _MASK_FOR_PAGE_SIZE	0xffffff00

#ADDR_define	_HEAP_END_INSURANCE_OFST  4096	/* KL1 $B%o!<%I(B */
                /* HEAP_END $B$N%]%$%s%?$+$i0z$-;;$9$k$N$G%"%I%l%9$H$7$?(B */

#DATA_define	D_AllocPageTotalCtr	XXX
		/* $B3d$jEv$F$?%Z!<%8$NAm?t(B ==> for @PROBE */

#DATA_define D_WorkNewHeapTop		XXX

/******************************************************************** PSL **
1. $B#1%Z!<%8J,$N%R!<%W$N99?7(B
       written by imai@icot22      on Tue Jun 19 19:47:23 1990

<Arguments> alloc_page_ptr : $B3d$jIU$1$?%Z!<%8$X$N%]%$%s%?$rJV$9(B
<Temporally Used Variables>
  D_WorkNewHeap : $B%R!<%W$r?-$P$7$?8e$N%R!<%W%H%C%W%]%$%s%?$NCM(B
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_AllocOneHeapPage(alloc_page_ptr)
{
  $USE(D_WorkNewHeapTop);
  $USE(D_WorkSize);
  b_SetImmValueDNTC(_SIZE_OF_HEAP_PAGE,D_WorkSize);
  b_PopFreePageList(D_WorkSize,alloc_page_ptr);
  $RELEASE(D_WorkSize);
  b_IfNotEOL(alloc_page_ptr) {
    b_SetImmTypeMRBon(FLC, alloc_page_ptr); /* added by imai on Jan.16,92 */
    goto END;
  }
  b_ReadOldAddImmGlobalHeapTopX
    (alloc_page_ptr, _NEXT_HEAP_PAGE_OFST, D_WorkNewHeapTop);
	/* $B6&M-%R!<%W%H%C%W$r(B alloc_page_ptr $B$KFI$_$@$7(B, $B$=$l$K(B 
	 * _NEXT_HEAP_PAGE_OFST $B$r2C$($?$b$N$r(B, $B6&M-%R!<%W%H%C%W$K=q$-La$9$H(B
	 * $B$H$b$K(B, D_WorkNewHeapTop $B$KCV$/(B.
	 */
  b_IfHeapLimitOver (D_WorkNewHeapTop) {
    @DEBUG { VPIM_ERROR("b_AllocOneHeapPage","PANIC Heap Overflow!"); };
  } else {
    @DEBUG{
      b_IfRangeUnderImm(D_WorkNewHeapTop,_HEAP_AREA_BASE) {
	VPIM_ERROR("b_AllocOneHeapPage","Not HEAP!!");
      }
      b_ModuloImmediateWithDNTC(alloc_page_ptr,_SIZE_OF_HEAP_PAGE,D_VOID);
      p_IfNE() {
	VPIM_ERROR("b_AllocOneHeapPage","Not Point Pagetop (alloc_page_ptr)");
      }
    };
    @PROBE{ b_IncrementReg(D_AllocPageTotalCtr); };
    b_IfHeapLimitWarning(D_WorkNewHeapTop) {
      /* $B3NJ]$O$G$-$?$,!"M=Hw$NItJ,$KB-$rF'$_F~$l$F$7$^$C$?(B
		-> $B%9%j%C%H%A%'%C%/MW0x(B */
      b_SetEventFlag (_PAGE_ALLOC_FAIL_EVENT, D_PE_Number);
      @DEBUG { WARNING("b_AllocOneHeapPage", "Heap_Memory_Exausted"); };
    } else {
      /* $B@5>o$K%R!<%W$r?-$P$9$3$H$,$G$-$?(B  nothing to do */ ;
    }
  }

  b_SetImmTypeMRBoff(FLC, alloc_page_ptr);
      /* $B?7$7$/<h$C$F$-$?%Z!<%8$O%U%j!<%j%9%H$+$i<h$C$F$-$?$h$&$K07$&$?$a(B 
                                                 1990.7.18 f-hataza & nakase */
  b_CheckHeapAlert();

 END:;
  @MONITOR{ PrintHeapTop(D_WorkNewHeapTop); };
  $RELEASE(D_WorkNewHeapTop);
}

/******************************************************************** PSL **
1. $B#1%Z!<%80J>e$N%R!<%W$N99?7(B
       written by imai@icot22      on Tue Jun 19 19:47:23 1990

<Arguments>
  alloc_size	 : $B3d$jIU$1$?$$%Z!<%8$NBg$-$5(B 
		($BC10L(B:$B%o!<%I!"%Z!<%8%5%$%:$G4]$a$kA0$NCM$GNI$$(B)
  alloc_page_ptr : $B3d$jIU$1$?%Z!<%8$X$N%]%$%s%?$rJV$9(B
<Temporally Used Variables>
  D_WorkNewHeap : $B%R!<%W$r?-$P$7$?8e$N%R!<%W%H%C%W%]%$%s%?$NCM(B
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
  $B%R!<%W$r?-$P$9$3$H$,$G$-$J$+$C$?>l9g$O!"(Bdst_addr $B$K(B D_NULL $B$NCM$rJV$9(B
********************************************************************* PSL **/

#PSL_define b_AllocMultipleHeapPage(alloc_size, dst_addr)
{
  $USE(D_WorkSize);
  @DEBUG{
    b_IfGreater(alloc_size,D_SizeOfMemory) {
      VPIM_ERROR("b_AllocMultipleHeapPage","Too Big!! I cannot alloc such big area!!");
    }
  };
  b_GetRoundUpHeapPage(alloc_size,D_WorkSize);
  b_IfEqualImm(D_WorkSize,_SIZE_OF_HEAP_PAGE) {
    $RELEASE(D_WorkSize);
    b_AllocOneHeapPage(dst_addr);
  } else {
    b_PopFreePageList(D_WorkSize,dst_addr);
    b_IfEOL(dst_addr) {
      b_ExtendHeapTopForMultipleHeapPageX(D_WorkSize,dst_addr);
    }
    $RELEASE(D_WorkSize);
  }
}

#CONST_define _PG_SIZE_SHIFT 8
#DATA_define D_Work_Ofst XXX

/* $B6&M-%U%j!<%j%9%H$+$i%]%C%W$G$-$J$+$C$?;~$O(B EOL $B$,JV$5$l$k(B */
#PSL_define b_PopFreePageList(alloc_size,dst_page_ptr)
{
  @DEBUG{
    b_ModuloImmediateWithDNTC(alloc_size,_SIZE_OF_HEAP_PAGE,D_VOID);
    p_IfNE() {
      VPIM_ERROR("b_PopFreePageList","Illegal alloc_size");
    }
  };
  b_IfGreaterImm(alloc_size,_MAX_PAGE_FREE_LIST_SIZE) {
    b_SetEOL(dst_page_ptr);
  } else {
    $USE(D_Work_Ofst);
    $USE(D_WorkNewCS);
    b_ShiftRightImmediate(alloc_size,_PG_SIZE_SHIFT,D_Work_Ofst);
							 /* $B%Z!<%8%5%$%:(B */
    b_ExchangeElmposToOffset(D_Work_Ofst, D_Work_Ofst);
                      /* for byte-addressing machine, 90.08.10 f-hataza */
    b_ReadFreePageTop(D_Work_Ofst,dst_page_ptr);
  RetryPoint:
    b_IfNotEOL(dst_page_ptr) {
      p_Read(dst_page_ptr,D_WorkNewCS);
      b_CompareSwapFreePageTopX(D_Work_Ofst,dst_page_ptr,D_WorkNewCS);
      p_IfNE() {  goto RetryPoint; }
      @DEBUG {
	b_IfRangeUnderImm(dst_page_ptr,_HEAP_AREA_BASE) {
	  VPIM_ERROR("b_PopFreePageList","Why Not Heap???");
	}
      };
    }
    $RELEASE(D_Work_Ofst);
    $RELEASE(D_WorkNewCS);
  }
}

#DATA_define D_WorkHeapOffset   XXX

/* $B%R!<%W$r?-$P$9!"?-$P$;$J$+$C$?;~$O(B EOL $B$,JV$5$l$k(B */
#PSL_define b_ExtendHeapTopForMultipleHeapPageX(alloc_size,dst_addr)
{
  b_ReadGlobalHeapTop (dst_addr);
  $USE(D_WorkHeapOffset);
  b_ExchangeElmposToOffset(alloc_size, D_WorkHeapOffset);
  $USE(D_WorkNewHeapTop);
                      /* for byte-addressing machine, 90.11.07 f-hataza */
 Retry:
  b_AddWithTag (dst_addr, D_WorkHeapOffset, D_WorkNewHeapTop);
  b_IfHeapLimitOver (D_WorkNewHeapTop) {
    /* $B%R!<%W$r?-$P$9$3$H$,$G$-$=$&$K$J$$(B */
    b_SetEventFlag (_PAGE_ALLOC_FAIL_EVENT, D_PE_Number);
    /* D_NULL $B$rJV$9(B */
    p_MoveWord(D_NULL, dst_addr);
    @DEBUG { WARNING ("b_AllocMultipleHeapPage", "Heap_Memory_Exausted");};
  } else {
    /* $B%R!<%W$r?-$P$9$3$H$,$G$-$=$&(B */
    b_CompareSwapSharedAreaX
       (_MEM_MANAGE_AREA_BASE,_GLOBAL_HEAP_TOP_OFST,dst_addr,D_WorkNewHeapTop);
    p_IfNE() goto Retry;

    b_CheckHeapAlert();

    @PROBE{
      $USE(D_WorkDebug);
      b_ShiftRightImmediateWithTag(alloc_size,_PG_SIZE_SHIFT,D_WorkDebug);
      b_AddWithTag(D_AllocPageTotalCtr,D_WorkDebug,D_AllocPageTotalCtr);
      $RELEASE(D_WorkDebug);
    };
  }
  $RELEASE(D_WorkHeapOffset);
  @MONITOR{ PrintHeapTop(D_WorkNewHeapTop); };
  $RELEASE(D_WorkNewHeapTop);
}

#PSL_define b_GetRoundUpHeapPage (alloc_size, round_up_size)
{
  b_SubtractWithTag(alloc_size, D_ONE, round_up_size);
  b_BitwiseAndImmediateWithTag
    (round_up_size, _MASK_FOR_PAGE_SIZE, round_up_size);
  b_AddImmediateWithTag(round_up_size, _SIZE_OF_HEAP_PAGE, round_up_size );
}

/******************************************************************** PSL **
$B%Z!<%8%5%$%:0J>e$N2s<}(B
       written by imai@icot22      on Fri Aug  3 11:53:52 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
  reclaim_size $B$O#2#5#6$N@0?tG\$K$J$C$F$$$k(B
<Function>
<Examples>
<Test>
<Explanation>
  $B5pBg$J%Z!<%8$O!"#1%Z!<%8$KJ,3d$7$F2s<}$9$k(B
<ETC>
********************************************************************* PSL **/

#PSL_define b_ReclaimMultipleHeapPage(reclaim_size,src_page_ptr)
{
  @DEBUG{
    b_ModuloImmediateWithDNTC(reclaim_size,_SIZE_OF_HEAP_PAGE,D_VOID);
    p_IfNE() {
      VPIM_ERROR("b_ReclaimMultipleHeapPage","Illegal reclaim_size");
    }
    b_ModuloImmediateWithDNTC(src_page_ptr,_SIZE_OF_HEAP_PAGE,D_VOID);
    p_IfNE() {
      VPIM_ERROR("b_PushFreePageListX","Illegal src_page_ptr");
    }
    b_IfGreater(reclaim_size,D_SizeOfMemory) {
      VPIM_ERROR("b_ReclaimMultipleHeapPage","Too Big!! Oh My God!!");
    }
    b_IfRangeUnderImm(src_page_ptr,_HEAP_AREA_BASE) {
      VPIM_ERROR("b_ReclaimMultipleHeapPage",
		 "Why Not Heap Area are reclaimed??");
    }
  };
  @DEBUG{ b_CheckFLC(src_page_ptr); };

  b_IfGreaterImm(reclaim_size,_MAX_PAGE_FREE_LIST_SIZE) {
    /* $B5pBg$J%Z!<%8(B */
    $USE(D_WorkCurrentPageTop); $USE(D_WorkS1); $USE(D_WorkSize);
    p_MoveWord(reclaim_size,D_WorkSize);
    p_MoveWord(src_page_ptr,D_WorkCurrentPageTop);
    b_SetImmValueDNTC(_SIZE_OF_HEAP_PAGE,D_WorkS1);
    $USE(D_WorkHeapOffset);
    b_ExchangeElmposToOffset(D_WorkS1, D_WorkHeapOffset);
    LOOP() {
      b_PushFreePageList(D_WorkS1,D_WorkCurrentPageTop);
      b_AddWithTag(D_WorkCurrentPageTop,D_WorkHeapOffset,D_WorkCurrentPageTop);
      /* for byte-addressing, add page size in byte */
      b_SubtractWithTag(D_WorkSize,D_WorkS1,D_WorkSize);
      p_IfEQ() { break; }
      @DEBUG{ p_IfLT() {
	VPIM_ERROR("b_ReclaimMultipleHeapPage","Unbelievable");
      }};
    }
    $RELEASE(D_WorkSize); $RELEASE(D_WorkS1); $RELEASE(D_WorkCurrentPageTop);
    $RELEASE(D_WorkHeapOffset);
  } else {
    b_PushFreePageList(reclaim_size,src_page_ptr);
  }
 End:;
}

#PSL_define b_PushFreePageList(reclaim_size,src_page_ptr)
{
  $USE(D_WorkOffset);
  b_ShiftRightImmediateWithDNTC(reclaim_size,_PG_SIZE_SHIFT,D_WorkOffset);
							 /* $B%Z!<%8%5%$%:(B */
  b_ExchangeElmposToOffset(D_WorkOffset, D_WorkOffset);
                      /* for byte-addressing machine, 90.08.10 f-hataza */
  $USE(D_WorkOldCS);
  b_ReadFreePageTop(D_WorkOffset,D_WorkOldCS);
 RetryPoint:
  p_Write(D_WorkOldCS,src_page_ptr);
  b_CompareSwapFreePageTopX(D_WorkOffset,D_WorkOldCS,src_page_ptr);
  p_IfNE() { goto RetryPoint; }
  $RELEASE(D_WorkOldCS); $RELEASE(D_WorkOffset);
}

#DATA_define D_AvailableHeapSize	XXX
		/* $B;HMQ2DG=$J%R!<%W$N%o!<%I?t(B ($BJRLL(B) */

#DATA_define D_SizeOfMemory	XXX
		/* $B%a%b%j(B($B%R!<%W(B)$B$N:GBg%"%I%l%9(B (SVP  $B$+$iCM$r@_Dj(B) */
#DATA_define D_HeapHalfAddr	XXX

#DATA_define D_CurrentHeapEndPtr XXX
#DATA_define D_CurrentHeapEndWarningPtr XXX

#PSL_define b_InitAvailableHeapSize()
{
  /* $B%R!<%W$N%5%$%:(B in address $B$r5a$a$k(B */
  b_SubtractImmediateWithDNTC(D_SizeOfMemory,_HEAP_AREA_BASE,D_AvailableHeapSize);
  /* 2 $B$G3d$C$FJRLL$r5a$a$k(B */
  b_ShiftRightImmediateWithDNTC(D_AvailableHeapSize,_ONE,D_AvailableHeapSize);
  /* $B%o!<%I?t$KD>$9(B */
  b_ExchangeOffsetToElmpos(D_AvailableHeapSize,D_AvailableHeapSize);
}

#CTRL_define b_IfHeapLimitOver (addr_reg)
{
  b_IfRangeOver (addr_reg, D_CurrentHeapEndPtr)
}

#CTRL_define b_IfHeapLimitWarning(addr_reg)
{
  b_IfRangeOver (addr_reg, D_CurrentHeapEndWarningPtr)
}

#PSL_define b_InitCurrentHeapEndPtr()
{
  p_MoveValue(D_HeapHalfAddr, D_CurrentHeapEndPtr);
  b_DecrementAddrReg(D_CurrentHeapEndPtr);
  b_SetCurrentHeapEndWarningPtr();
}

#PSL_define b_SetCurrentHeapEndWarningPtr()
{
  b_SubtractImmediateWithDNTC
    (D_CurrentHeapEndPtr,_HEAP_END_INSURANCE_OFST,D_CurrentHeapEndWarningPtr);
}

/*************** heap alert $B4X78(B ***********************/
/* $B6qBN2=BT$AJQ?t$NGSB>@)8f(B */

#DATA_define D_Work_HeapAlertVarLockOrgTagReg XXX

#PSL_define b_LockHeapAlertVar(org_tag_reg){
  b_SoftLockWithOrgTag(D_NULL,_HEAP_ALERT_LOCK_FLAG,org_tag_reg);
}

#PSL_define b_UnlockHeapAlertVar(org_tag_reg){
  b_SoftUnlockWithOrgTag(D_NULL,_HEAP_ALERT_LOCK_FLAG,org_tag_reg);
}

/* $B6qBN2=BT$A$NJQ?t$NA`:n(B */

#DATA_define D_Work_HeapAlertVar XXX

#PSL_define b_GetHeapAlertVar(reg){
  p_ReadWithOffset(D_NULL,_HEAP_ALERT_VARIABLE,reg);
}

#PSL_define b_SetHeapAlertVar(reg){
  p_WriteWithOffset(reg,D_NULL,_HEAP_ALERT_VARIABLE);
}

/* HeapAlertSize $B5-21>l=j$NA`:n(B */

#DATA_define D_Work_HeapAlertSize XXX

#PSL_define b_GetHeapAlertSize(reg){
  p_ReadWithOffset(D_NULL,_HEAP_ALERT_SIZE,reg);
}

#PSL_define b_SetHeapAlertSize(reg){
  p_WriteWithOffset(reg,D_NULL,_HEAP_ALERT_SIZE);
}

/* $B%R!<%W%H%C%W99?7;~$N%A%'%C%/%^%/%m(B */
#DATA_define D_Work_CHACHA_HeapAlertVar XXX

#PSL_define b_CheckHeapAlert(){
  $USE(D_Work_CHACHA_HeapAlertVar);
  b_GetHeapAlertVar(D_Work_CHACHA_HeapAlertVar);
  b_IfNotEOL(D_Work_CHACHA_HeapAlertVar){ 
                             /* $B<h$j4:$($:%m%C%/$r3]$1$J$$$G%F%9%H(B */
    b_SignalOnSCR(_HEAP_ALERT_EVENT,D_PE_Number); /* $B%;%k%U%$%Y%s%H(B */
  }
  $RELEASE(D_Work_CHACHA_HeapAlertVar);
}
