/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_heap_freelist.psl.c
   ----- CREATED   : by goto@icot22, on Fri Dec  9 09:38:22 1988
   ----- LAST SAVED: by ttakagi@icot22, on Fri May  1 12:35:56 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : basics
   ----- ABSTRACT  : 

A. $B9`L\(B
  (1)  $B%U%j!<%j%9%H$N%P%1%C%H4IM}(B	---> $BGQ;_(B
  (2)  $B%U%j!<%j%9%H%l%8%9%?$K4X$9$k4pK\A`:n$H%o!<%/%l%8%9%?(B
  (3)  1$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B
  (4)  2$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B
  (5)  4$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B
  (6)  8$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B
  (7)  8$B%o!<%I$h$jBg$-$$%l%3!<%I$N3d$jEv$F(B
  (8)  $B%U%j!<%j%9%H$N3d$jEv$F$H2s<}(B
  (9)  $B%U%j!<%j%9%H$N%A%'%C%/(B

B. $B%U%j!<%j%9%H$N<oN`(B
  
  $B<B9T;~$N(BMRB-GC$B$GMxMQ$9$k(B1$B%Z!<%8$h$j>.$5$$%G!<%?NN0h$N%U%j!<%j%9%H4IM}$K$D$$$F(B
$B=R$Y$k!#(B $B$^$:!"%U%j!<%j%9%H$NMWAG$H$9$k%G!<%?$NOHAH$O!$4pK\E*$K!$(B1$B%o!<%I!$(B2$B%o!<(B
$B%I!$$*$h$S%-%c%C%7%e%V%m%C%/(B(4$B%o!<%I(B)$B$N@0?tG\$NBg$-$5$H$9$k!#(B
  $B$3$N$?$a!$@8@.$9$k%G!<%?9=B$$,%U%j!<%j%9%H$NMWAG$NBg$-$5$K9g$o$J$$$H$-$O!$Bg(B
$B$-$a$G0lHV6a$$$b$N$r;H$&!#Nc$($P!"(B3$B%o!<%I$N%G!<%?$r3d$jIU$1$k$H$-$O!$(B4$B%o!<%I$N(B
$B%U%j!<%j%9%H$r;H$&!#%U%j!<%j%9%H$N%H%C%W$O!$(BPE$BKh$N8GDjNN0h$KCV$-!$$=$NFb(B, $BFC$K(B
$B;HMQIQEY$,B?$$$b$N(B(1,2,4,16$B%o!<%I(B)$B$O(BCPU$B$N%l%8%9%?$KCV$/!#(B

  [$BI=(B] 1$B%Z!<%8$h$j>.$5$$MWAG$N%U%j!<%j%9%H$*$h$S%U%j!<%P%1%C%H$N<oN`$N0lMw(B
-----------------------------------------------------------------------------
 Record Size	| Allocated	| Bucket Length	|	Example of usage 
 (words)	| (records)	| (records)	|
-----------------------------------------------------------------------------
	1	|	256	|	2048	| Variable cells
		|		|		|
	2	|	128	|	1024	| List cells, Merger,
		|		|		| Suspend, 
	4	|	 64	|	 512	| Vectors (3--4)
		|		|		|
	8	|	 32	|	 256	| Vectors (5--8)
		|		|		|
	16	|	 16	|	 128	| Vectors (9--15)
		|		|		| Goalrecord
	32	|	  8	|	  64	| Vectors (16--31)
		|		|		|
	64	|	  4	|	  32	| Vectors (32--63)
		|		|		|
	128	|	  2	|	  16	| Vectors (64--127)
		|		|		|
-----------------------------------------------------------------------------

$B3F%U%j!<%j%9%H$N;EMM$O0J2<$NDL$j$G$"$k!#(B
 [$B=*C<(B:]  EOL Register $B$N%?%0$HCM!#(B
 [$B%j%s%/(B:] $B=*C<$H0[$J$k%?%0$HCM$G$"$l$PNI$$!#(B
 [$B=i4|2=(B:] $B3FMWAG$NL$;EMMItJ,$N=i4|2=$O9T$J$o$J$$!#(B
	$B$?$@$7(B, 1$B%o!<%I$N%U%j!<%j%9%H$K$D$$$F$O!"(B "UNDF"$B$K=i4|2=$9$k$H!"(B
	put_variable $BEy$NL?Na$,9bB.2=$G$-$k!#(B

C. $B2]Bj(B
  $B!&%/%i%9%?Fb$N(BMRB GC$B$G$O(B, $B%W%m%;%C%5Kh$K;}$D%U%j!<%j%9%HD9$KJR4s$j$,@8$8$k(B
    $B2DG=@-$,6/$$!#(B

  $B!&JR4s$j$,@8$8$?>l9g$NBP:v$H$7$F(B, $B%U%j!<%j%9%H$N%P%1%C%H4IM}$,Ds0F$5$l$F$$$k(B
    $B$,(B, $B%3%s%9%?%s%H%*!<%P!<%X%C%I$,Bg$-$$$H9M$($i$l$k$N$G<BAu$7$J$$!#(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

#CONST_define _SIZE_OF_FL1	1
#CONST_define _SIZE_OF_FL2	2
#CONST_define _SIZE_OF_FL4	4
#CONST_define _SIZE_OF_FL8	8
#CONST_define _SIZE_OF_FL16	16
#CONST_define _SIZE_OF_FL32	32
#CONST_define _SIZE_OF_FL64	64
#CONST_define _SIZE_OF_FL128	128

#ADDR_define _NEXT_CELL_OFST_FL1	 1
#ADDR_define _NEXT_CELL_OFST_FL2	 2
#ADDR_define _NEXT_CELL_OFST_FL4	 4
#ADDR_define _NEXT_CELL_OFST_FL8	 8
#ADDR_define _NEXT_CELL_OFST_FL16	16
#ADDR_define _NEXT_CELL_OFST_FL32	32
#ADDR_define _NEXT_CELL_OFST_FL64	64
#ADDR_define _NEXT_CELL_OFST_FL128     128

#DATA_define D_Free_1_PtrReg	XXX
#DATA_define D_Free_2_PtrReg	XXX
#DATA_define D_Free_4_PtrReg	XXX
#DATA_define D_Free_8_PtrReg	XXX	/* in memory */
#DATA_define D_Free_16_PtrReg	XXX
#DATA_define D_Free_Short_GR_PtrReg	D_Free_16_PtrReg
#DATA_define D_Free_Long_GR_PtrReg	D_Free_32_PtrReg
#DATA_define D_Free_32_PtrReg	XXX	/* in memory */
#DATA_define D_Free_64_PtrReg	XXX	/* in memory */
#DATA_define D_Free_128_PtrReg	XXX	/* in memory */

#ADDR_define _WORD_MINUS_1	(-1)
#ADDR_define _WORD_0	0
#ADDR_define _WORD_1	1
#ADDR_define _WORD_2	2
#ADDR_define _WORD_3	3
#ADDR_define _WORD_4	4
#ADDR_define _WORD_8	8

#CONST_define _ALLOC_NUM_1_WORD	256
#CONST_define _ALLOC_NUM_2_WORD	128
#CONST_define _ALLOC_NUM_4_WORD	 64
#CONST_define _ALLOC_NUM_8_WORD	 32
#CONST_define _ALLOC_NUM_16_WORD	 16
#CONST_define _ALLOC_NUM_32_WORD	  8
#CONST_define _ALLOC_NUM_64_WORD	  4
#CONST_define _ALLOC_NUM_128_WORD	  2

#PSL_define b_InitFreeListTop ()
{
  b_SetEOL (D_Free_1_PtrReg);
  b_SetEOL (D_Free_2_PtrReg);
  b_SetEOL (D_Free_4_PtrReg);
  b_SetEOL (D_Free_8_PtrReg);
  b_SetEOL (D_Free_16_PtrReg);
  b_SetEOL (D_Free_32_PtrReg);
  b_SetEOL (D_Free_64_PtrReg);
  b_SetEOL (D_Free_128_PtrReg);
/*   b_SetEOL (D_Free_GR_PtrReg); */
}

/******************************************************************** PSL **
(1) $B%U%j!<%j%9%H$N%P%1%C%H4IM}(B

       written by goto@icot22      Thu Dec 22 09:37:47 1988

<Explanation>
<ETC>
  $B9T$o$J$$!#(B
********************************************************************* PSL **/

/******************************************************************** PSL **
(2) $B%U%j!<%j%9%H%l%8%9%?$K4X$9$k4pK\A`:n$H%o!<%/%l%8%9%?(B

       written by goto@icot22      Tue Dec 13 21:31:18 1988

<Arguments>
  src_reg :
  src_imm :
  addr_reg :
  imm_ofst :
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  b_AddImmAndWritePtrWithOffset(src_reg, src_imm, addr_reg, imm_ofst)
    	(src_reg + src_imm) $B$r%a%b%j$N(B (addr_reg + imm_ofst) $BHVCO$K=q$/(B.
<Examples>
<Test>
<Explanation>
  $B=q$-9~$`CM$KIU$1$k%?%0$O(B _TYPE_FLC (= 37 = FLC) $B$H$9$k(B.
  see bsc_vpim_reg.psl.c, str_variable_type.psl.c
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkAddDst	XXX
#DATA_define D_WorkAllocCnt	XXX
#DATA_define D_WorkPagePtr	XXX
#DATA_define D_WorkAllocSize	XXX
/* #DATA_define D_WorkAllocBlock	XXX    
    D_WorkAllocBlock $B$O(B D_WorkAllocSize$B$rMxMQ$7$FE;$a$?!#(B(89.6.21 f-doumae) */

#DATA_define D_WorkSize		XXX

#PSL_define b_AddImmAndWritePtrWithOffset(src_reg, src_imm, addr_reg, imm_ofst)
{
/* addr_reg = D_WorkPagePtr $B$N(B $B%?%0$O(B _GC_0, _MRB_0, _TYPE_FLC */
  $USE(D_WorkAddDst);
  b_AddImmediateWithTag (src_reg, src_imm, D_WorkAddDst);
  p_WriteWithOffset (D_WorkAddDst, addr_reg, imm_ofst);
  $RELEASE(D_WorkAddDst);
}

			/* Checking for end of free list */
#CTRL_define b_IfEmptyFree	(free_ptr_reg)
{
  b_IfEOL (free_ptr_reg)
}

/******************************************************************** PSL **
(3)  1$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B

       written by goto@icot22      Fri Nov 11 15:58:31 1988

<Arguments>
  free_top_reg: $BDL>o(B D_Free_1_PtrReg
  page_ptr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B ($B%?%0$O(B _TYPE_FLC)
<Temporally Used Variables>
  D_WorkAllocCnt: $B%Z!<%8Fb$K3d$jEv$F$k%;%k?t$r%+%&%s%H$9$k(B
  D_WorkPagePtr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B
		 ($B%?%0$O(B _TYPE_FLC)
<Level> basics
<PreCondition>
<Function>
  b_Make1WordBlock (free_top_reg, page_ptr):
	$B%-%c%C%7%e%V%m%C%/$K(Bfree_top_reg $B$N@h$K(B1$B%o!<%I$N%;%k$r(B4$B8D(B 
	($B%-%c%C%7%e%V%m%C%/%5%$%:(B)$B$@$1:n$k!#$3$N;~(B, $B3F%;%k$N%?%$%W$O(B_TYPE_FLC
	$B$H$9$k!#(B)
  (SUBROUTINE) b_Make1Word_Sub (free_top_reg):
	1$B%Z!<%8J,$@$1(B, 1$B%o!<%I$N%U%j!<%j%9%H$r:n$k!#(B
<Examples>
<Test>
<Explanation>
  $B>e5-$N%U%j!<%j%9%H@8@.A`:n$G$O(B, $B%R!<%WNN0h$r%@%$%l%/%H%i%$%H$G3NJ]$9$k!#(B
  b_Make1WordBlock $B$G:n$i$l$k$b$N$O0J2<$N$h$&$J$b$N$G$"$k!#(B

  		  ^
		  |
  	+---------|-----+
  xxxx0	|FLC ! 	  *  	| << written directly ($B0l$DA0$N(B free_top_reg $B$NCM(B)
  	+---------------+
  xxxx1	|FLC !  xxxxx0	|
  	+---------------+
  xxxx2	|FLC !  xxxxx1	|
  	+---------------+
  xxxx3	|FLC !	xxxxx2	| <-------- free_top_reg ( xxxx3 )
  	+---------------+
  xxxx4	|		| <-------- D_WorkPagePtr
        :               :

<ETC>
  $B$3$N%^%/%m$G$O(B, p_WriteDirectly $BA`:n$,(B, $B%-%c%C%7%e$K%R%C%H$7$F$bNI$$$3$H$r(B
  $B2>Dj$7$F$$$k!#(B(machine-check $B$H$O$J$i$J$$(B)
	FLC = _TYPE_FLC
********************************************************************* PSL **/

#SUBARG_define	A_FreeTop	MODIFY

#SUBROUTINE b_Make1Word_Sub (A_FreeTop)  
{
  $USE(D_WorkPagePtr);
  $USE(D_WorkAllocCnt); 
  b_AllocOneHeapPage (D_WorkPagePtr);
  b_SetImmValueDNTC (_ALLOC_NUM_1_WORD, D_WorkAllocCnt);
  p_IfMRBEQImmediate(D_WorkPagePtr,_MRB_1) {
    b_SetImmTypeMRBoff(FLC, D_WorkPagePtr);
    b_Make1WordPageFromReusedPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  } else {
    b_Make1WordPageFromFreshPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  }
  $RELEASE(D_WorkPagePtr);
  $RELEASE(D_WorkAllocCnt);
  $RETURN();
}

#PSL_define b_Make1WordPageFromFreshPage(page_ptr,alloc_count,free_top)
{
  LOOP (){
	/* $B%Z!<%8$N@hF,$N%V%m%C%/$N>l9g(B, free_top_reg $B$O(B EOL $B$H$J$C$F$$$k$?$a(B,
	 * $B:G=i$N%o!<%I$K$O(B EOL $B$,=q$-9~$^$l$k!#(B
	 */
    b_Make1WordBlockFreshPage (free_top, page_ptr);
    b_SubtractImmediateWithTag (alloc_count, _FOUR, alloc_count);
	/* $B%V%m%C%/$K(B4$B8D$E$D$o$j$"$F$k$?$a(B */
    p_IfEQ () /* b_IfZero (alloc_count) */  break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_1_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make1Word", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make1WordPageFromReusedPage(page_ptr,alloc_count,free_top)
{
  LOOP (){
	/* $B%Z!<%8$N@hF,$N%V%m%C%/$N>l9g(B, free_top_reg $B$O(B EOL $B$H$J$C$F$$$k$?$a(B,
	 * $B:G=i$N%o!<%I$K$O(B EOL $B$,=q$-9~$^$l$k!#(B
	 */
    b_Make1WordBlockReusedPage (free_top, page_ptr);
    b_SubtractImmediateWithTag (alloc_count, _FOUR, alloc_count);
	/* $B%V%m%C%/$K(B4$B8D$E$D$o$j$"$F$k$?$a(B */
    p_IfEQ () /* b_IfZero (D_WorkAllocCnt) */  break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_1_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make1Word", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make1WordBlockFreshPage (free_top_reg, page_ptr)
{
  p_WriteDirectly (free_top_reg, page_ptr);
  p_WriteWithOffset (page_ptr, page_ptr, _WORD_1);
  b_AddImmAndWritePtrWithOffset(page_ptr, _WORD_1, page_ptr, _WORD_2);
  b_AddImmAndWritePtrWithOffset(page_ptr, _WORD_2, page_ptr, _WORD_3);
  b_AddImmediateWithTag (page_ptr, _WORD_3, free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_4, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make1WordBlock","Illegal_Tag");}
  };
}

#PSL_define b_Make1WordBlockReusedPage (free_top_reg, page_ptr)
{
  p_Write (free_top_reg, page_ptr);
  p_WriteWithOffset (page_ptr, page_ptr, _WORD_1);
  b_AddImmAndWritePtrWithOffset(page_ptr, _WORD_1, page_ptr, _WORD_2);
  b_AddImmAndWritePtrWithOffset(page_ptr, _WORD_2, page_ptr, _WORD_3);
  b_AddImmediateWithTag (page_ptr, _WORD_3, free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_4, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make1WordBlock","Illegal_Tag");}
  };
}

/******************************************************************** PSL **
(4)  2$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B

       written by goto@icot22      Mon Jan  9 16:59:52 1989

<Arguments>
  free_top_reg: $BDL>o(B D_Free_2_PtrReg
  page_ptr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B
<Temporally Used Variables>
  D_WorkAllocCnt: $B%Z!<%8Fb$K3d$jEv$F$k%;%k?t$r%+%&%s%H$9$k(B
  D_WorkPagePtr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B
<Level>
<PreCondition>
<Function>
  b_Make2WordBlock (free_top_reg):
	$B%-%c%C%7%e%V%m%C%/$K(Bfree_top_reg $B$N@h$K(B2$B%o!<%I$N%;%k$r(B2$B8D(B 
	($B%-%c%C%7%e%V%m%C%/%5%$%:(B)$B$@$1:n$k!#$3$N;~(B, $B3F%;%k$N%?%$%W$O(B_TYPE_FLC
	=REF $B$H$9$k!#(B)
  (SUBROUTINE) b_Make2Word_Sub ():
	1$B%Z!<%8J,$@$1(B, 1$B%o!<%I$N%U%j!<%j%9%H$r:n$k!#(B
<Examples>
<Test>
<Explanation> "(4)  1$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B" $B;2>H(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_FreeTop	MODIFY

#SUBROUTINE b_Make2Word_Sub (A_FreeTop)
{
  $USE(D_WorkPagePtr);
  $USE(D_WorkAllocCnt);
  b_AllocOneHeapPage (D_WorkPagePtr);
  b_SetImmValueDNTC (_ALLOC_NUM_2_WORD, D_WorkAllocCnt);
  p_IfMRBEQImmediate(D_WorkPagePtr,_MRB_1) {
    b_SetImmTypeMRBoff(FLC, D_WorkPagePtr);
    b_Make2WordPageFromReusedPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  } else {
    b_Make2WordPageFromFreshPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  }
  $RELEASE(D_WorkPagePtr);
  $RELEASE(D_WorkAllocCnt);
  $RETURN();
}

#PSL_define b_Make2WordPageFromFreshPage(page_ptr,alloc_count,free_top)
{
  LOOP (){
    b_Make2WordBlockFromFreshPage (free_top, page_ptr);
    b_SubtractImmediateWithDNTC (alloc_count, _TWO, alloc_count);
	/* $B%V%m%C%/$K(B2$B8D$E$D$o$j$"$F$k$?$a(B */
    p_IfEQ () /* b_IfZero (D_WorkAllocCnt) */  break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_2_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make2Word", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make2WordPageFromReusedPage(page_ptr,alloc_count,free_top)
{
  LOOP (){
    b_Make2WordBlockFromReusedPage (free_top, page_ptr);
    b_SubtractImmediateWithDNTC (alloc_count, _TWO, alloc_count);
	/* $B%V%m%C%/$K(B2$B8D$E$D$o$j$"$F$k$?$a(B */
    p_IfEQ () /* b_IfZero (D_WorkAllocCnt) */  break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_2_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make2Word", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make2WordBlockFromFreshPage (free_top_reg, page_ptr)
{
  p_WriteDirectly (free_top_reg, page_ptr);
  p_WriteWithOffset(page_ptr, page_ptr, _WORD_2);
  b_AddImmediateWithTag (page_ptr, _WORD_2, free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_4, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make2WordBlock","Illegal_Tag");}
  };
}

#PSL_define b_Make2WordBlockFromReusedPage (free_top_reg, page_ptr)
{
  p_Write (free_top_reg, page_ptr);
  p_WriteWithOffset(page_ptr, page_ptr, _WORD_2);
  b_AddImmediateWithTag (page_ptr, _WORD_2, free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_4, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make2WordBlock","Illegal_Tag");}
  };
}

/******************************************************************** PSL **
(5)  4$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B

       written by goto@icot22      Mon Jan  9 17:00:59 1989

<Arguments>
  free_top_reg: $BDL>o(B D_Free_4_PtrReg
  page_ptr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B
<Temporally Used Variables>
  D_WorkAllocCnt: $B%Z!<%8Fb$K3d$jEv$F$k%;%k?t$r%+%&%s%H$9$k(B
  D_WorkPagePtr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B
<Level>
<PreCondition>
<Function>
  b_Make4WordBlock (free_top_reg):
	$B%-%c%C%7%e%V%m%C%/$K(Bfree_top_reg $B$N@h$K(B4$B%o!<%I$N%;%k$r(B1$B8D(B 
	($B%-%c%C%7%e%V%m%C%/%5%$%:(B)$B$@$1:n$k!#(B
  (SUBROUTINE) b_Make4Word_Sub (free_top_reg):
	1$B%Z!<%8J,$@$1(B, 4$B%o!<%I$N%U%j!<%j%9%H$r:n$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_FreeTop	MODIFY

#SUBROUTINE  b_Make4Word_Sub (A_FreeTop)
{
  $USE(D_WorkPagePtr);
  $USE(D_WorkAllocCnt);
  b_AllocOneHeapPage (D_WorkPagePtr); /* D_WorkPagePtr $B$N%?%$%W$O(B _TYPE_FLC */
  b_SetImmValueDNTC (_ALLOC_NUM_4_WORD, D_WorkAllocCnt);
  p_IfMRBEQImmediate(D_WorkPagePtr,_MRB_1) {
    b_SetImmTypeMRBoff(FLC, D_WorkPagePtr);
    b_Make4WordPageFromReusedPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  } else {
    b_Make4WordPageFromFreshPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  }
  $RELEASE(D_WorkPagePtr);
  $RELEASE(D_WorkAllocCnt);
  $RETURN();
}

#PSL_define b_Make4WordPageFromFreshPage(page_ptr,alloc_count,free_top)
{
  LOOP (){
    b_Make4WordBlockFromFreshPage (free_top, page_ptr);
    b_DecrementReg(alloc_count);
    p_IfEQ() /* b_IfZero (alloc_count) */ break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_4_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make4Word", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make4WordPageFromReusedPage(page_ptr,alloc_count,free_top)
{
  LOOP (){
    b_Make4WordBlockFromReusedPage (free_top, page_ptr);
    b_DecrementReg(alloc_count);
    p_IfEQ() /* b_IfZero (alloc_count) */ break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_4_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make4Word", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make4WordBlockFromFreshPage (free_top_reg, page_ptr)
{
  p_WriteDirectly (free_top_reg, page_ptr);
  p_MoveWord(page_ptr,free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_4, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make4WordBlock","Illegal_Tag");}
  };
}

#PSL_define b_Make4WordBlockFromReusedPage (free_top_reg, page_ptr)
{
  p_Write (free_top_reg, page_ptr);
  p_MoveWord(page_ptr,free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_4, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make4WordBlock","Illegal_Tag");}
  };
}


/******************************************************************** PSL **
(6)  8$B%o!<%I$N%U%j!<%j%9%H$N@8@.(B

       written by goto@icot22      Mon Jan  9 17:02:22 1989
       revised by goto@icot22      on Mon Jun 26 10:17:08 1989
<Arguments>
  free_top_reg: $BDL>o(B D_Free_8_PtrReg
  page_ptr: D_WorkPagePtr
<Temporally Used Variables>
  D_WorkAllocCnt: $B%Z!<%8Fb$K3d$jEv$F$k%;%k?t$r%+%&%s%H$9$k(B
  D_WorkPagePtr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
  $B3F%l%3!<%I(B($B%;%k(B)$B$N$X$N%]%$%s%?$N%A%'%$%s$O(B Direct_Write $BA`:n$K$h$C$F=q$-9~$`(B.
  $B$5$i$K(B, $B3F%U%j!<%;%kA4BN$r%-%c%C%7%e%a%b%j$K>h$;$k$?$a$K(B, $B%;%k$NFbIt$K$*$$$F(B
  $B$b%-%c%C%7%e%P%&%s%@%jKh$K(B(4word$B6-3&(B)$B%@%_!<CM$r(BDirect_write$B$K$h$C$F=q$-9~$`(B.
  $B$?$@$7(B, $B%4!<%k%l%3!<%I$N$h$&$KMWAG$N=q$-9~$_$K(BDirect_write$B$rMQ$$$k$3$H$,(B
  $BL@$i$+$J>l9g$O(B, $B>e5-$N=q$-9~$_$,L5BL$K$J$k!#(B
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_FreeTop	MODIFY

#SUBROUTINE b_Make8Word_Sub (A_FreeTop) 
{
  $USE(D_WorkPagePtr);
  $USE(D_WorkAllocCnt);
  b_AllocOneHeapPage (D_WorkPagePtr);
  b_SetImmValueDNTC(_ALLOC_NUM_8_WORD, D_WorkAllocCnt);
  p_IfMRBEQImmediate(D_WorkPagePtr,_MRB_1) {
    b_SetImmTypeMRBoff(FLC, D_WorkPagePtr);
    b_Make8WordPageFromReusedPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  } else {
    b_Make8WordPageFromFreshPage(D_WorkPagePtr, D_WorkAllocCnt, A_FreeTop);
  }
  $RELEASE(D_WorkPagePtr);
  $RELEASE(D_WorkAllocCnt);
  $RETURN();
}

#PSL_define b_Make8WordPageFromFreshPage(page_ptr,alloc_count,free_top)
{
  LOOP() {
    b_Make8WordBlockFromFreshPage (free_top, page_ptr);
    b_DecrementReg(alloc_count);
    p_IfEQ() /* b_IfZero (D_WorkAllocCnt) */ break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_4_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make8Word_Sub", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make8WordPageFromReusedPage(page_ptr,alloc_count,free_top)
{
  LOOP() {
    b_Make8WordBlockFromReusedPage (free_top, page_ptr);
    b_DecrementReg(alloc_count);
    p_IfEQ() /* b_IfZero (D_WorkAllocCnt) */ break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_4_WORD) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_Make8Word_Sub", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_Make8WordBlockFromFreshPage (free_top_reg, page_ptr)
{
  p_WriteDirectly (free_top_reg, page_ptr);
  /* $B%@%_!<CM$r=q$-9~$`(B */
  p_WriteDirectlyWithOffset (D_NULL, page_ptr, _WORD_4);
  p_MoveWord (page_ptr, free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_8, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make8WordBlock","Illegal_Tag");}
  };
}

#PSL_define b_Make8WordBlockFromReusedPage (free_top_reg, page_ptr)
{
  p_Write (free_top_reg, page_ptr);
  /* $B%@%_!<CM$r=q$-9~$`=hM}$OL5BL$J$N$G$*$3$J$o$J$$(B */
  /* p_WritWithOffset (D_NULL, page_ptr, _WORD_4); */
  p_MoveWord (page_ptr, free_top_reg);
  b_AddImmediateWithTag (page_ptr, _WORD_8, page_ptr);
  @DEBUG {
    b_IfNotFLC (page_ptr) { VPIM_ERROR("b_Make8WordBlock","Illegal_Tag");}
  };
}

/******************************************************************** PSL **
(7)  8$B%o!<%I$h$jBg$-$$%l%3!<%I$N3d$jEv$F(B

       written by goto@icot22      Mon Jan  9 17:02:22 1989

<Arguments>
  A_FreeTop : $B%U%j!<%j%9%H%l%8%9%?(B 
  		(D_Free_16_PtrReg, D_Free_32_PtrReg, D_Free_64_PtrReg,
		 D_Free_128_PtrReg )
  A_AllocSize : $B%l%3!<%I$NBg$-$5$r;XDj$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkAllocCnt: $B%Z!<%8Fb$K3d$jEv$F$k%;%k?t$r%+%&%s%H$9$k(B
  D_WorkPagePtr: $B3d$jEv$F%Z!<%8Fb$N3d$jEv$F:Q$_NN0h$r;X$9%]%$%s%?(B
  D_WorkSize: $B%-%c%C%7%e%V%m%C%/6-3&$K%@%_!<=q$-9~$_$r$9$k;~$KMQ$$$k%l%8%9%?(B
<Level>
<PreCondition>
<Function>
  A_AllocSize $B$G;XDj$5$l$?%5%$%:$N%U%j!<%j%9%H$r(B A_FreeTop $B$K:n$k!#(B
<Examples>
<Test>
<Explanation>
  $B3F%l%3!<%I(B($B%;%k(B)$B$N$X$N%]%$%s%?$N%A%'%$%s$O(B Direct_Write $BA`:n$K$h$C$F=q$-9~$`(B.
  $B$5$i$K(B, $B3F%U%j!<%;%kA4BN$r%-%c%C%7%e%a%b%j$K>h$;$k$?$a$K(B, $B%;%k$NFbIt$K$*$$$F(B
  $B$b%-%c%C%7%e%P%&%s%@%jKh$K%@%_!<CM$r(BDirect_write$B$K$h$C$F=q$-9~$`(B.


  $B!&(B8 $B%o!<%I$r1[$($k%Y%/%?(B, $B%4!<%k%l%3!<%I$N$?$a$N%U%j!<%j%9%H(B
    (D_Free_16_PtrReg) $B$G$O(B, $B3F%l%3!<%I$N(B2$B%o!<%IL\$K%j%s%/$rCV$/!#(B
    $B$^$?(B, $B3F%j%s%/$b(B, $B%l%3!<%I$N(B2$B%o!<%IL\$r;X$9!#(B

		+-------+	+-------+
		|	|	|	|
		|-------|	|-------|
  FreeTop ---> 	|   *---------->|   *----------->
		|-------|	|-------|
		:	:	:	:
<ETC>
********************************************************************* PSL **/

#SUBARG_define	A_FreeTop	MODIFY
#SUBARG_define	A_AllocSize	SRC

#SUBROUTINE b_MakeNWord_Sub ( A_FreeTop, A_AllocSize ) 
{
  $USE(D_WorkAllocCnt);
  ValueSwitch (A_AllocSize) {
  case _SIZE_OF_FL16:
    b_SetImmValueDNTC(_ALLOC_NUM_16_WORD, D_WorkAllocCnt); break;
  case _SIZE_OF_FL32:
    b_SetImmValueDNTC(_ALLOC_NUM_32_WORD, D_WorkAllocCnt); break;
  case _SIZE_OF_FL64:
    b_SetImmValueDNTC(_ALLOC_NUM_64_WORD, D_WorkAllocCnt); break;
  case _SIZE_OF_FL128:
    b_SetImmValueDNTC(_ALLOC_NUM_128_WORD, D_WorkAllocCnt); break;
  default: 
    @DEBUG{OUT_OF_SPEC ("b_MakeNWord_Sub", "Illegal Size");};
  }
  $USE(D_WorkPagePtr);
  b_AllocOneHeapPage (D_WorkPagePtr);
  p_IfMRBEQImmediate(D_WorkPagePtr,_MRB_1) {
    b_SetImmTypeMRBoff(FLC, D_WorkPagePtr);
    b_MakeNWordPageFromReusedPage
      (D_WorkPagePtr, D_WorkAllocCnt, A_AllocSize, A_FreeTop);
  } else {
    b_MakeNWordPageFromFreshPage
      (D_WorkPagePtr, D_WorkAllocCnt, A_AllocSize, A_FreeTop);
  }
  $RELEASE(D_WorkPagePtr);
  $RELEASE(D_WorkAllocCnt);
  $RETURN();
}

#PSL_define b_MakeNWordPageFromFreshPage
	(page_ptr,alloc_count,alloc_size,free_top)
{
  LOOP() {
    b_MakeNWordBlockFromFreshPage (free_top, page_ptr, alloc_size);
    b_DecrementReg(alloc_count);
    p_IfEQ() /* b_IfZero (alloc_count) */ break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_?_Word) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_MakeNWord_Sub", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_MakeNWordPageFromReusedPage
	(page_ptr,alloc_count,alloc_size,free_top)
{
  LOOP() {
    b_MakeNWordBlockFromReusedPage (free_top, page_ptr, alloc_size);
    b_DecrementReg(alloc_count);
    p_IfEQ() /* b_IfZero (alloc_count) */ break;
	/* 1$B%Z!<%8$K3d$jEv$F$k?t(B (_ALLOC_NUM_?_Word) $B$KC#$7$?$i=*N;(B */
    @DEBUG {
      p_IfLT () { VPIM_ERROR ("b_MakeNWord_Sub", "Illegal count"); break; }
    };
  } /* end of LOOP */
}

#PSL_define b_MakeNWordBlockFromFreshPage (free_top_reg, page_ptr, alloc_size)
{
  p_WriteDirectlyWithOffset (free_top_reg, page_ptr, _WORD_1);
		/* $B%l%3!<%I$N(B2$B%o!<%IL\$K%j%s%/$rCV$/!#(B*/
  b_AddImmediateWithTag  (page_ptr, _WORD_1, free_top_reg);
  $USE(D_WorkSize);
  p_MoveWord(alloc_size, D_WorkSize);
  LOOP () {
    b_AddImmediateWithTag (page_ptr, _WORD_4, page_ptr);
    b_SubtractImmediateWithTag (D_WorkSize, _FOUR, D_WorkSize);
    p_IfEQ () break;
    p_WriteDirectlyWithOffset ( D_NULL, page_ptr, _WORD_0);
	/* 
	 * $B3F%-%c%C%7%e%V%m%C%/$N@hF,$K(B Direct Write$B$K$h$kL5BL=q$-$r$9$k(B
	 */
    @DEBUG {
      p_IfLT () { OUT_OF_SPEC ("b_MakeNWord", "Illegal count"); break; }
    };
  } /* end of LOOP */
  $RELEASE(D_WorkSize);
}

#PSL_define b_MakeNWordBlockFromReusedPage (free_top_reg, page_ptr, alloc_size)
{
  p_WriteWithOffset (free_top_reg, page_ptr, _WORD_1);
		/* $B%l%3!<%I$N(B2$B%o!<%IL\$K%j%s%/$rCV$/!#(B*/
  b_AddImmediateWithTag  (page_ptr, _WORD_1, free_top_reg);
  $USE(D_WorkSize);
  p_MoveWord(alloc_size, D_WorkSize);
	/* 
	 * $B3F%-%c%C%7%e%V%m%C%/$N@hF,$K(B Direct Write$B$K$h$k=q9~$_$O9T$J$o$J$$(B
	 */
  b_ExchangeElmposToOffset(D_WorkSize,D_WorkSize);
  b_AddWithTag(page_ptr,D_WorkSize,page_ptr);
  $RELEASE(D_WorkSize);
}


/******************************************************************** PSL **
(8)  $B%U%j!<%j%9%H$N3d$jEv$F$H2s<}(B

       written by goto@icot22      Tue Dec 13 16:58:22 1988

<Arguments>
  dst_reg : $B3d$jEv$F$k%l%8%9%?(B
  src_reg : $B2s<}$9$k%l%8%9%?(B
  imm_type : $B3d$jEv$F$?%;%k$N%]%$%s%?$K;XDj$9$k%?%$%WB(CM(B.
  imm_size : $B3d$jEv$F(B/$B2s<}$9$k%;%k$N%5%$%:(B
  freeN_ptr_reg : $B3d$jEv$F(B/$B2s<}$9$k%;%k$N%5%$%:$KBP1~$7$?%U%j!<%j%9%H%H%C%W(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  b_Alloc1(dst_reg, imm_type):
	$B%U%j!<%j%9%H$+$i(B ($B$J$1$l$P@8@.$7$F(B) 1$B%o!<%I%;%k$r3d$jEv$F$k!#(B
  b_Reclaim1(src_reg):
	$B%U%j!<%j%9%H$K(B1$B%o!<%I%;%k$r2s<}$9$k!#(B
  b_Alloc2(dst_reg, imm_type):
  b_Reclaim2(src_reg):
  b_Alloc4(dst_reg, imm_type):
  b_Reclaim4(src_reg):
  b_AllocN
	(dst_reg, freeN_ptr_reg, imm_size, imm_type):
  b_ReclaimN(src_reg, freeN_ptr_reg):

<Examples> s_AllocVariable(..), s_AllocList(..)
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_Alloc1	(dst_reg, imm_type)
{
  @PROBE{ b_IncrementReg(D_ALLOC_1_COUNT); };
  b_IfEmptyFree (D_Free_1_PtrReg) {
    $CALL (b_Make1Word_Sub (D_Free_1_PtrReg));
  }
  b_PopLinkWithTypeMRBoff (dst_reg, D_Free_1_PtrReg, _ZERO, imm_type);
}
 
#PSL_define b_Reclaim1	(src_reg)
{
  @DEBUG{_print_reclaimed(src_reg,_SIZE_OF_FL1);};
  @PROBE{ b_IncrementReg(D_RECLAIM_1_COUNT); };
  @DEBUG{
    b_CheckFLC(src_reg);
    b_IfRangeUnderImm(src_reg,_HEAP_AREA_BASE) {
      VPIM_ERROR("b_Reclaim1","Tried To Reclaim Not Heap Cell!");
    }
  };
  b_PushLink(src_reg, D_Free_1_PtrReg, _ZERO);
}

#PSL_define b_Alloc2	(dst_reg, imm_type)
{
  @PROBE{ b_IncrementReg(D_ALLOC_2_COUNT); };
  b_IfEmptyFree (D_Free_2_PtrReg) {
    $CALL (b_Make2Word_Sub (D_Free_2_PtrReg));
  }
  b_PopLinkWithTypeMRBoff (dst_reg, D_Free_2_PtrReg, _ZERO, imm_type);
  @DEBUG{
    b_BitwiseAndImmediateWithTag(dst_reg,_MASK_FOR_2WORD_RECLAIM_ADDR,D_VOID);
    p_IfNE() {  VPIM_ERROR("b_Alloc2","Illegal address dst_reg");  }
  };
}


#CONST_define _MASK_FOR_2WORD_RECLAIM_ADDR	0x00000001
#CONST_define _MASK_FOR_4WORD_RECLAIM_ADDR	0x00000003
#CONST_define _MASK_FOR_8WORD_RECLAIM_ADDR	0x00000007

#PSL_define b_Reclaim2	(src_reg)
{
  @DEBUG{_print_reclaimed(src_reg,_SIZE_OF_FL2);};
  @PROBE{ b_IncrementReg(D_RECLAIM_2_COUNT); };
  @DEBUG{
    b_BitwiseAndImmediateWithTag(src_reg,_MASK_FOR_2WORD_RECLAIM_ADDR,D_VOID );
    p_IfNE() {
      VPIM_ERROR("b_Reclaim2","Illegal address src_reg");
    }
    b_CheckFLC(src_reg);
    b_IfRangeUnderImm(src_reg,_HEAP_AREA_BASE) {
      VPIM_ERROR("b_Reclaim2","Tried To Reclaim Not Heap Cell!");
    }
  };
  b_PushLink (src_reg, D_Free_2_PtrReg, _ZERO);
  /* 
  @DEBUG{ $BG0$N$?$a(B $B;H$o$J$$%9%m%C%H$r%/%j%"$9$k(B
    b_CleanUpUnusedSlots(src_reg,_WORD_1,_WORD_2);
  };
  */
}

#PSL_define b_Alloc4	(dst_reg, imm_type)
{
  @PROBE{ b_IncrementReg(D_ALLOC_4_COUNT); };
  b_IfEmptyFree (D_Free_4_PtrReg) {
    $CALL (b_Make4Word_Sub (D_Free_4_PtrReg));
  }
  b_PopLinkWithTypeMRBoff(dst_reg, D_Free_4_PtrReg, _ZERO, imm_type);
  @DEBUG{
    b_BitwiseAndImmediateWithTag(dst_reg,_MASK_FOR_4WORD_RECLAIM_ADDR,D_VOID);
    p_IfNE() {  VPIM_ERROR("b_Alloc4","Illegal address dst_reg");  }
  };
}
 
#PSL_define b_Reclaim4 (src_reg)
{
  @DEBUG{_print_reclaimed(src_reg,_SIZE_OF_FL4);};
  @PROBE{ b_IncrementReg(D_RECLAIM_4_COUNT); };
  @DEBUG{
    b_BitwiseAndImmediateWithTag(src_reg,_MASK_FOR_4WORD_RECLAIM_ADDR,D_VOID );
    p_IfNE() {
      VPIM_ERROR("b_Reclaim4","Illegal address src_reg");
    }
    b_CheckFLC(src_reg);
    b_IfRangeUnderImm(src_reg,_HEAP_AREA_BASE) {
      VPIM_ERROR("b_Reclaim4","Tried To Reclaim Not Heap Cell!");
    }
  };
  b_PushLink (src_reg, D_Free_4_PtrReg, _ZERO);
  /* 
    @DEBUG{ $BG0$N$?$a(B $B;H$o$J$$%9%m%C%H$r%/%j%"$9$k(B
    b_CleanUpUnusedSlots(src_reg,_WORD_1,_WORD_4);
  };
  */
}

#PSL_define b_Alloc8	(dst_reg, imm_type)
{
  @PROBE{ b_IncrementReg(D_ALLOC_8_COUNT); };
  b_IfEmptyFree (D_Free_8_PtrReg) {
    $CALL (b_Make8Word_Sub (D_Free_8_PtrReg));
  }
  b_PopLinkWithTypeMRBoff (dst_reg, D_Free_8_PtrReg, _ZERO, imm_type);
  @DEBUG{
    b_BitwiseAndImmediateWithTag(dst_reg,_MASK_FOR_4WORD_RECLAIM_ADDR,D_VOID);
    p_IfNE() {  VPIM_ERROR("b_Alloc4","Illegal address dst_reg");  }
  };
}
 
#PSL_define b_Reclaim8 (src_reg)
{
  @DEBUG{_print_reclaimed(src_reg,_SIZE_OF_FL8);};
  @PROBE{ b_IncrementReg(D_RECLAIM_8_COUNT); };
  @DEBUG{
    b_BitwiseAndImmediateWithTag(src_reg,_MASK_FOR_8WORD_RECLAIM_ADDR,D_VOID);
    p_IfNE() {
      VPIM_ERROR("b_Reclaim8","Illegal address src_reg");
    }
    b_CheckFLC(src_reg);
    b_IfRangeUnderImm(src_reg,_HEAP_AREA_BASE) {
      VPIM_ERROR("b_Reclaim8","Tried To Reclaim Not Heap Cell!");
    }
  };
  b_PushLink (src_reg, D_Free_8_PtrReg, _ZERO);
  /* 
  @DEBUG{ $BG0$N$?$a(B $B;H$o$J$$%9%m%C%H$r%/%j%"$9$k(B
    b_CleanUpUnusedSlots(src_reg,_WORD_1,_WORD_8);
  };
  */
}

#PSL_define b_AllocN
     (dst_reg, freeN_ptr_reg, imm_size, imm_type)
{
  @PROBE{
    $USE(D_WorkAllocSize);
    b_SetImmValueDNTC (imm_size, D_WorkAllocSize);
    ValueSwitch (D_WorkAllocSize) {
    case  16 : b_IncrementReg(D_ALLOC_16_COUNT);  break;
    case  32 : b_IncrementReg(D_ALLOC_32_COUNT);  break;
    case  64 : b_IncrementReg(D_ALLOC_64_COUNT);  break;
    case 128 : b_IncrementReg(D_ALLOC_128_COUNT); break;
    default: OUT_OF_SPEC ("b_AllocN", "Illegal Size");
    }
    $RELEASE(D_WorkAllocSize);
  };
  
  b_IfEmptyFree (freeN_ptr_reg) {
    $USE(D_WorkAllocSize);
    b_SetImmValueDNTC(imm_size, D_WorkAllocSize);
    $CALL (b_MakeNWord_Sub (freeN_ptr_reg, D_WorkAllocSize ));
    $RELEASE(D_WorkAllocSize);
  }
  b_PopLinkWithTypeMRBoff (dst_reg, freeN_ptr_reg, _ZERO, imm_type);
}
 
#PSL_define b_ReclaimN (src_reg, freeN_ptr_reg, imm_size)
{
  @PROBE{
    $USE(D_WorkAllocSize);
    b_SetImmValueDNTC (imm_size, D_WorkAllocSize);
    ValueSwitch (D_WorkAllocSize) {
    case  16 : b_IncrementReg(D_RECLAIM_16_COUNT);  break;
    case  32 : b_IncrementReg(D_RECLAIM_32_COUNT);  break;
    case  64 : b_IncrementReg(D_RECLAIM_64_COUNT);  break;
    case 128 : b_IncrementReg(D_RECLAIM_128_COUNT); break;
    default: OUT_OF_SPEC ("b_ReclaimN", "Illegal Size");
    }
    $RELEASE(D_WorkAllocSize);
  };
  @DEBUG{ b_CheckFLC(src_reg);};
  /* 
    @DEBUG{ $BG0$N$?$a(B $B;H$o$J$$%9%m%C%H$r%/%j%"$9$k(B (Push$B$NA0$K$9$k(B)
    $USE(D_WorkLinkedGoal);
    p_AddImmediate(src_reg,_WORD_MINUS_1,D_WorkLinkedGoal);
    b_CleanUpUnusedSlots(D_WorkLinkedGoal,_WORD_0,imm_size);
    $RELEASE(D_WorkLinkedGoal);
  };
  */
  b_PushLink(src_reg, freeN_ptr_reg, _ZERO);
    /* $B%P%1%C%H4IM}(B (V01$B$G$O(B $B>JN,(B) */
}

/******************************************************************** PSL **
$B%U%j!<%j%9%HCf$N;H$o$l$F$$$J$$%9%m%C%H$N%/%j%"(B
       written by imai@icot22      on Thu Nov  8 17:49:11 1990
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_CleanUpUnusedSlots(src_reg,imm_start_ofst,imm_end_ofst)
{
  $USE(D_WorkMemAddr);
  $USE(D_WorkCnt);	/* $BL>A0$,NI$/$J$$!"(BD_WorkMemEndAddr $B$/$i$$$+!)(B */
  b_AddImmediateWithDNTC(src_reg,imm_start_ofst,D_WorkMemAddr);
  b_AddImmediateWithDNTC(src_reg,imm_end_ofst,D_WorkCnt);
  LOOP() {
    b_IfGreaterEq(D_WorkMemAddr,D_WorkCnt) { break; }
    p_Write(D_ALL1,D_WorkMemAddr); /* D_ALL1 $B$K%/%j%"$9$k(B */
    b_IncrementAddrReg(D_WorkMemAddr);
  }
  $RELEASE(D_WorkCnt);
  $RELEASE(D_WorkMemAddr);
}

/******************************************************************** PSL **
(9) $B%U%j!<%j%9%H$N%A%'%C%/(B

       written by nakagawa@icot22      on Tue Apr  4 19:17:44 1989
<Arguments>
  cell : $B2s<}$9$k%;%k$X$N%]%$%s%?(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  _TYPE_FLC ($B%U%j!<%j%9%H$N%?%0(B)$B$N%;%k$r2s<}$7$F$$$J$$$+$r%A%'%C%/$9$k(B.
  $BF1;~$K(B, $B2s<}$7$?%;%k$N%?%$%W$r(B _TYPE_FLC$B$H$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B%G%P%C%0MQ$N%^%/%m$G$"$k!#(B
<ETC>
********************************************************************* PSL **/

#PSL_define b_CheckFLC(cell)
{
  p_IfTypeEQImmediate (cell, _TYPE_FLC) {
    @DEBUG{
      VPIM_ERROR("b_CheckFLC","doubly-freed-cell");
    };
  } else {
      p_SetImmediateType(_TYPE_FLC, cell /*free_top*/); 
  }
}

/*-------------------------------------
#CTRL_define b_IfNotFLC(reg)
{
    p_IfTypeNEImmediate (reg, _TYPE_FLC) 
}
---------- defined in str_variable_type.psl.c -----*/
