
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_flag_ope.psl.c
   ----- CREATED   : by f-doumae@icot22, on Wed Jun 13 11:55:13 1990
   ----- LAST SAVED: by ttakagi@icot22, on Thu Jan  9 13:52:53 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : basics
   ----- ABSTRACT  : $B%l%8%9%?>e$N%U%i%0$N(BON/OFF$BA`:n$H%F%9%H(B

A. $B9`L\(B
  1. $B%l%8%9%?>e$N%U%i%0$N%*%s!&%*%U$H%F%9%H(B
  2. $B%l%8%9%?>e$N%U%i%0$N%F%9%H(B

B. $B%l%8%9%?>e$N%U%i%0$N(BON/OFF$BA`:n$H%F%9%HA`:n$rDj5A$9$k(B.

  $B!&%U%i%0$O(B, CPU$BFb$N%l%8%9%?(B($B$NE,Ev$J%S%C%H(B)$B$K3d$jEv$F$i$l$k$H2>Dj$9$k!#(B
    $B<B:]$N%l%8%9%?$H%S%C%H0LCV$O>e0L3,AX$K$*$$$F(B #DATA_define $B$5$l$k!#(B

  $B!&%l%8%9%?Fb$K$*$$$F(B, $B$I$3$K%U%i%0$rCV$/$+(B($B%?%0It(B/$B%G!<%?It(B)$B$O%^%7%s$K$h$C$F(B
    $B0[$J$k!#$^$?(B, $B%?%0It(B/$B%G!<%?It$KBP$9$kO@M}1i;;5!G=$b0[$J$k!#(B

  $B!&(BV05$B$G$O%U%i%0$O%l%8%9%?$N(BValue$BIt$KCV$/!#(B $B%U%i%0$r%?%0It$KCV$/>l9g$O(B
    $BDj5A$rJQ99$9$kI,MW$,$"$k!#(B

 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%l%8%9%?>e$N%U%i%0$N%*%s!&%*%U$H%F%9%H(B

       written by f-doumae@icot22      on Wed Jun 13 11:57:38 1990
<Arguments>
  flag_reg     : $B%U%i%0$rCV$/%l%8%9%?(B
  flag_pos_reg : "flag_reg" $B$K$*$1$k3:Ev%U%i%0$N%S%C%H0LCV(B ($B%l%8%9%?(B)
  imm_flag_pos : "flag_reg" $B$K$*$1$k3:Ev%U%i%0$N%S%C%H0LCV(B ($BB(CM(B [0..31])
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  flag_reg$B>e$N(B flag_pos_reg/imm_flag_pos$B$G;XDj$5$l$?%U%i%0$r(BON/OFF$B$9$k(B
  Toggle $BL?Na$OM=$a(BON/Off$B$,J,$+$C$F$$$k>l9g$N:GE,2=$G$"$k!#(B
<Examples>
<Test>
<Explanation>
  $B%U%i%0$O(B, CPU$BFb$N%l%8%9%?(B($B$NE,Ev$J%S%C%H(B)$B$K3d$jEv$F$i$l$k!#(B
  $B%S%C%H0LCV$O>e0L3,AX$K$*$$$F(B #CONST_define $B$5$l$k!#(B
  $B%l%8%9%?Fb$K$*$$$F(B, $B$I$3$K%U%i%0$rCV$/$+(B($B%?%0It(B/$B%G!<%?It(B)$B$O%^%7%s$K$h$C$F(B
  $B0[$J$k!#$^$?(B, $B%?%0It(B/$B%G!<%?It$KBP$9$kO@M}1i;;5!G=$b0[$J$k!#(B
<ETC>
  $B%U%i%0$O%l%8%9%?$N(BValue$BIt$KCV$/(B.

		31 ............................0
	+---------------------------------------+
	|  Tag	|	   Value		|
	+---------------------------------------+
********************************************************************* PSL **/
#CONST_define _HIGHEST_FLAG_POS  31
#CONST_define _LOWEST_FLAG_POS    0

#DATA_define D_WorkFlagReg	XXX
#DATA_define D_WorkFlagPos	XXX

#PSL_define b_FlagOffPosReg	(flag_reg, flag_pos_reg)
{
  @DEBUG { 
    b_IfRangeErr (flag_pos_reg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_FlagOffPosReg", "Illegal flag position");}
  };
  $USE(D_WorkFlagReg);
  b_ShiftLeftWithDNTC(D_ONE, flag_pos_reg, D_WorkFlagReg);
  b_BitwiseEorWithTag(D_WorkFlagReg, D_ALL1, D_WorkFlagReg);
  b_BitwiseAndWithTag(flag_reg, D_WorkFlagReg, flag_reg);
  $RELEASE(D_WorkFlagReg);
}

#PSL_define b_FlagOffImmPos	(flag_reg, imm_flag_pos)
{
  $USE(D_WorkFlagPos);
  b_SetImmValueDNTC (imm_flag_pos, D_WorkFlagPos);
  b_FlagOffPosReg(flag_reg, D_WorkFlagPos);
  $RELEASE(D_WorkFlagPos);
}

#PSL_define b_FlagOnPosReg	(flag_reg, flag_pos_reg)
{
  @DEBUG { 
    b_IfRangeErr (flag_pos_reg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_FlagOnPosReg", "Illegal flag position");}
  };
  $USE(D_WorkFlagReg);
  b_ShiftLeftWithDNTC(D_ONE, flag_pos_reg, D_WorkFlagReg);
  b_BitwiseOrWithTag(flag_reg, D_WorkFlagReg, flag_reg);
  $RELEASE(D_WorkFlagReg);
}

#PSL_define b_FlagOnImmPos	(flag_reg, imm_flag_pos)
{
  $USE(D_WorkFlagPos);
  b_SetImmValueDNTC (imm_flag_pos, D_WorkFlagPos);
  b_FlagOnPosReg(flag_reg,D_WorkFlagPos);
  $RELEASE(D_WorkFlagPos);
}

#PSL_define b_FlagTogglePosReg	(flag_reg, flag_pos_reg)
{
  @DEBUG { 
    b_IfRangeErr (flag_pos_reg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_FlagTogglePosReg", "Illegal flag position");}
  };
  $USE(D_WorkFlagReg);
  b_ShiftLeftWithDNTC(D_ONE, flag_pos_reg, D_WorkFlagReg);
  b_BitwiseEorWithTag(flag_reg, D_WorkFlagReg, flag_reg);
  $RELEASE(D_WorkFlagReg);
}

/******************************************************************** PSL **
2. $B%l%8%9%?>e$N%U%i%0$N%F%9%H(B

       written by f-doumae@icot22      on Wed Jun 13 12:11:54 1990
<Arguments>
  flag_reg     : $B%U%i%0$rCV$/%l%8%9%?(B
  flag_pos_reg : "flag_reg" $B$K$*$1$k3:Ev%U%i%0$N%S%C%H0LCV(B ($B%l%8%9%?(B)
  imm_flag_pos : "flag_reg" $B$K$*$1$k3:Ev%U%i%0$N%S%C%H0LCV(B ($BB(CM(B [0..31])
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  flag_reg$B>e$N(B flag_pos_reg/imm_flag_pos$B$G;XDj$5$l$?%U%i%0$N(BON/OFF$B$r(B
  $B%F%9%H$9$k!#(B
<Examples>
<Test>
<Explanation>
  $B%F%9%H$K$h$C$F(Bflag_reg,flag_pos_reg$B$NFbMF$OJQ$o$i$J$$!#(B
<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfFlagOnPosReg	(flag_reg, flag_pos_reg)
{
  @DEBUG { 
    b_IfRangeErr (flag_pos_reg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_IfFlagOn", "Illegal flag position");}
  };
  $USE(D_WorkFlagReg);
  b_ShiftLeftWithDNTC (D_ONE, flag_pos_reg, D_WorkFlagReg);
  b_BitwiseAndWithDNTC (flag_reg, D_WorkFlagReg, D_VOID);
  $RELEASE(D_WorkFlagReg);
  p_IfNE ()
}

#CTRL_define b_IfFlagOffPosReg	(flag_reg, flag_pos_reg)
{
  @DEBUG { 
    b_IfRangeErr (flag_pos_reg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_IfFlagOff", "Illegal flag position");}
  };
  $USE(D_WorkFlagReg);
  b_ShiftLeftWithDNTC (D_ONE, flag_pos_reg, D_WorkFlagReg);
  b_BitwiseAndWithDNTC (flag_reg, D_WorkFlagReg, D_VOID);
  $RELEASE(D_WorkFlagReg);
  p_IfEQ ()
}

#CTRL_define b_IfFlagOnImmPos	(flag_reg, imm_flag_pos)
{
  $USE(D_WorkFlagPos);
  b_SetImmValueDNTC (imm_flag_pos, D_WorkFlagPos);
  @DEBUG { 
    b_IfRangeErr (D_WorkFlagPos, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_IfFlagOn", "Illegal flag position");}
  };
  $USE(D_WorkFlagReg);
  b_ShiftLeftWithDNTC (D_ONE, D_WorkFlagPos, D_WorkFlagReg);
  $RELEASE(D_WorkFlagPos);
  b_BitwiseAndWithDNTC (flag_reg, D_WorkFlagReg, D_VOID);
  $RELEASE(D_WorkFlagReg);
  p_IfNE ()
}

#CTRL_define b_IfFlagOffImmPos(flag_reg, imm_flag_pos)
{
  $USE(D_WorkFlagPos);
  b_SetImmValueDNTC (imm_flag_pos, D_WorkFlagPos);
  @DEBUG { 
    b_IfRangeErr (D_WorkFlagPos, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_IfFlagOff", "Illegal flag position");}
  };
  $USE(D_WorkFlagReg);
  b_ShiftLeftWithDNTC (D_ONE, D_WorkFlagPos, D_WorkFlagReg);
  $RELEASE(D_WorkFlagPos);
  b_BitwiseAndWithDNTC (flag_reg, D_WorkFlagReg, D_VOID);
  $RELEASE(D_WorkFlagReg);
  p_IfEQ ()
}

/******************************************************************** PSL **
  $B>r7o$N@.8y!?<:GT$r%;%C%H!?8!::$9$k%^%/%m(B
       written by imai@icot22      on Thu Apr 18 11:51:51 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
$B=>Mh$N(B

#CTRL_define f_If.....() {
  s_If......() {
		:
		:
	 p_Compare(D_NULL, D_NULL);
  } else {
		:
		:
	 p_Compare(D_NULL, D_ALL1);
  }
  p_IfEQ()
}
$B$,1x$$$N$G!"(B

#CTRL_define f_If.....() {
  s_If......() {
		:
		:
	 b_SetSuccess();
  } else {
		:
		:
	 b_SetFail();
  }
  b_IfSuccess()
}
$B$K$9$k$?$a$N%^%/%m!#(B

<ETC>
********************************************************************* PSL **/

#CTRL_define b_IfSuccess() {
  p_IfEQ()
}

#CTRL_define b_IfFail() {
  p_IfNE()
}

#PSL_define b_SetSuccess()
{
  @REGOPE_OPT {
    CcrSetEQ();
  } else {
    p_Compare(D_NULL,D_NULL);
  };
}

#PSL_define b_SetFail()
{
  @REGOPE_OPT {
    CcrReSetEQ();
  } else {
    p_Compare(D_ALL1,D_NULL);
  };
}
