
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_exclusive_access.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun 18 15:46:15 1990
   ----- LAST SAVED: by yamamoto@icot22, on Mon Jul 13 19:20:58 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : basics
   ----- ABSTRACT  : $BGSB>%"%/%;%9$rH<$&A`:n(B

A. $B9`L\(B
  1. $BGSB>@)8fIU$-$N%S%C%HA`:n(B
  2. $BGSB>@)8fIU$-$N%o!<%IA`:n(B
  3. $B%?%0$rMQ$$$?%=%U%H%m%C%/A`:n(B

B. $BGSB>%"%/%;%9$rH<$&A`:n$K$D$$$FDj5A$9$k(B.

  $B!&(BPIM$B$N%/%i%9%?$G$O(B, $BJ#?t$N%W%m%;%C%5$,%a%b%j$r6&M-$9$k$?$a(B, $B6&M-%G!<%?9=B$(B
    $B$X$N=q$-9~$_$K$OGSB>@)8f$,I,MW$G$"$k!#(B
    $B$3$N$h$&$JGSB>@)8f$r8zN(NI$/<B9T$9$k$?$a$K(B, PIM$B$N<B5!$G$O%O!<%I%&%'%"%m%C%/(B
    $B5!9=$r@_$1$F$$$k!#(B $B$?$@$7(B, $B%O!<%I%&%'%"5!9=>e(B, $B%m%C%/Cf$NA`:n$O%G%C%I%m%C%/(B
    $B$,@8$8$J$$$?$a$N@)8B$r<i$i$J$1$l$P$J$i$J$$!#(B

  $B!&%O!<%I%&%'%"%m%C%/$r(B($B%G%C%I%m%C%/$N?4G[L5$7$K(B)$B0BA4$K;H$&$?$a$K(B, VPIM$B$G$O(B
    $B%3%s%Z%"%9%o%C%W$r4pK\$H$9$k%^%/%m$r@_$1$F$"$k!#(B
					(see bsc_compare_swap.psl.c)
    
  $B!&Aq1`%l%3!<%I$N$h$&$K(B, $B%W%m%;%C%5$+$i6&M-$5$l$k%G!<%?9=B$$NFbIt%9%F!<%?%9$r(B
    $BJQ99$9$k>l9g$bGSB>@)8f$,I,MW$G$"$k!#(B

C. $B4XO"(B
  $B!&%W%m%;%C%54V$N%7%0%J%kDL?.$K$*$1$kGSB>@)8f$O(B bsc_comm_acc.psl.c $B$r;2>H(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $BGSB>@)8fIU$-$N%S%C%HA`:n(B

       written by kawai@icot21      on Fri Mar 17 21:21:15 1989
<Arguments>
  base_reg : $BA`:nBP>]%o!<%I$KBP$9$k%Y!<%9CM$rJ];}$9$k%l%8%9%?(B
  imm_offset : $BA`:nBP>]%o!<%I$N%Y!<%9CM$+$i$N%*%U%;%C%HCM(B($BB(CM(B)
  pos_reg : $B%*%s(B/$B%*%U$9$k%S%C%H0LCV$rJ];}$9$k%l%8%9%?(B
  imm_mask : $BA`:nBP>]%o!<%I$KBP$9$k%^%9%/CM(B($BB(CM(B)
  imm_value : $BA`:nBP>]%o!<%I$N%U%#!<%k%I$K@_Dj$9$kCM(B($BB(CM(B)
<Temporally Used Variables>
  D_Work_Bit_Field_Reg : $BA`:nBP>]%o!<%I$r%m%C%/$7$FFI$_9~$`$?$a$N:n6HMQ%l%8%9%?(B
  D_Work_Mask_Reg      : $BA`:nBP>]%o!<%I$KBP$9$k%^%9%/$r@8@.$9$k$?$a$N:n6HMQ%l%8(B
                         $B%9%?(B
<Level>
  basics
<PreCondition>
<Function>
  $BGSB>@)8f$7$J$,$i!"(Bbase$B$+$i(Boffset$B$@$1N%$l$?%o!<%I$K3JG<$5$l$F$$$k%S%C%HNs$N!"(B
$B;XDj$7$?%S%C%H$"$k$$$O%U%#!<%k%I$rA`:n$9$k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_Work_Bit_Field_Reg   XXX
#DATA_define D_Work_Mask_Reg        XXX

#PSL_define b_FlagOffPosRegWithOffsetX(base_reg, imm_offset, pos_reg)
{
  @DEBUG { 
    b_IfRangeErr (pos_reg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_FlagOffPosWithOffsetX", "Illegal flag position");}
  };
  $USE(D_Work_Bit_Field_Reg); $USE(D_Work_Mask_Reg);
  p_ReadWithLockWithOffset(base_reg, imm_offset, D_Work_Bit_Field_Reg);
  b_ShiftLeftWithDNTC(D_ONE, pos_reg, D_Work_Mask_Reg);
  b_BitwiseEorWithDNTC(D_Work_Mask_Reg, D_ALL1, D_Work_Mask_Reg);
              /* $B;XDj%S%C%H$r(B 0$B$K!"$=$l0J30$N%S%C%H$r(B 1$B$K@_Dj(B */
  b_BitwiseAndWithTag
    (D_Work_Bit_Field_Reg, D_Work_Mask_Reg, D_Work_Bit_Field_Reg);
              /* $B;XDj%S%C%H$r%*%U(B */
  p_WriteAndUnlockWithOffset(D_Work_Bit_Field_Reg, base_reg, imm_offset);
  $RELEASE(D_Work_Bit_Field_Reg);
  $RELEASE(D_Work_Mask_Reg);
}

#PSL_define b_FlagOnPosRegWithOffsetX(base_reg, imm_offset, pos_reg)
{
  @DEBUG { 
    b_IfRangeErr (pos_reg, _LOWEST_FLAG_POS, _HIGHEST_FLAG_POS) {
      OUT_OF_SPEC ("b_FlagOnPosWithOffsetX", "Illegal flag position");}
  };
  $USE(D_Work_Bit_Field_Reg); $USE(D_Work_Mask_Reg);
  p_ReadWithLockWithOffset(base_reg, imm_offset, D_Work_Bit_Field_Reg);
  b_ShiftLeftWithDNTC(D_ONE, pos_reg, D_Work_Mask_Reg);
              /* $B;XDj%S%C%H$r(B 1$B$K!"$=$l0J30$N%S%C%H$r(B 0$B$K@_Dj(B */
  b_BitwiseOrWithTag
    (D_Work_Bit_Field_Reg, D_Work_Mask_Reg, D_Work_Bit_Field_Reg);
              /* $B;XDj%S%C%H$r%*%s(B */
  p_WriteAndUnlockWithOffset(D_Work_Bit_Field_Reg, base_reg, imm_offset);
  $RELEASE(D_Work_Bit_Field_Reg); $RELEASE(D_Work_Mask_Reg);
}

/******************************************************************** PSL **
2. $BGSB>@)8fIU$-$N%o!<%IA`:n(B

       written by kawai@icot21      on Wed Mar 22 21:30:57 1989
       revised by kawai@icot21      on Thu Mar 23 11:02:40 1989
       revised by kawai@icot21      on Mon Apr 24 14:17:43 1989
       revised by imai@icot22      on Wed Jan 16 17:45:57 1991

***CAUTION*** $BMW%3%a%s%H8+D>$7(B

<Arguments>
  base_reg : $BA`:nBP>]%o!<%I$N%Y!<%9%"%I%l%9$rJ];}$9$k%l%8%9%?(B
  imm_offset : $BA`:nBP>]%o!<%I$N%Y!<%9%"%I%l%9$+$i$N%*%U%;%C%H$rJ];}$9$k%l%8%9%?(B
  value_reg : $BA`:nBP>]%o!<%I$K@_Dj$9$kCM$rJ];}$9$k%l%8%9%?(B
<Temporally Used Variables>
  D_WorkValueReg : $BA`:nBP>]%o!<%I$NFbMF$r0l;~J];}$9$k%l%8%9%?(B
<Level>
  basics
<PreCondition>
<Function>
 $B!&(Bb_AddValueWithOffsetX(base_reg, imm_offset, value_reg)
     $BGSB>@)8f$7$J$,$i!"(Bbase$B$+$i(Bimm_offset$B$@$1N%$l$?%o!<%I$N(Bvalue$BIt$K(Bvalue_reg$B$N(B
   $BFbMF$r2C$($k!#(B
<Examples>
<Test>
<Explanation>
<ETC>
<Revised Memo on "Mar 23">
   $B%^%/%mL>JQ99(B
     b_XXXWordWithOffsetX  ->  b_XXXValueWithOffsetX
<Revised Memo on "Apr 24">
   $B%^%/%mDI2C(B
 $B!&(Bb_SoftLockOneWordWithOffsetX, b_SoftUnlockOneWordWithOffsetX
<Revised Memo on "Jan 16">
 $B!&(Bb_SoftLockOneWordWithOffsetX, b_SoftUnlockOneWordWithOffsetX --> $B:o=|(B
********************************************************************* PSL **/

#DATA_define D_WorkValueReg   XXX

#PSL_define b_AddValueWithOffsetX(base_reg, imm_offset, value_reg)
{
  $USE(D_WorkValueReg);
  p_ReadWithLockWithOffset(base_reg, imm_offset, D_WorkValueReg);
  b_AddWithTag(D_WorkValueReg, value_reg, D_WorkValueReg);
  p_WriteAndUnlockWithOffset(D_WorkValueReg, base_reg, imm_offset);
  $RELEASE(D_WorkValueReg);
}

/******************************************************************** PSL **
3.1  $B%?%0$rMQ$$$?%=%U%H%m%C%/!J5l%G!<%?$rJ]B8!K(B

       written by nakase@icot22      on Wed Nov 29 15:43:12 1989
<Arguments>
  ptr_to_cell: $B%=%U%H%m%C%/BP>]$H$J$k%"%I%l%9$X$N%]%$%s%?(B
  imm_offset : $B%=%U%H%m%C%/BP>]$X$N(Bptr_to_cell$B$+$i$N%*%U%;%C%H(B
  org_data_reg:$B%=%U%H%m%C%/BP>]$H$J$k%;%k$NFbMF!J%m%C%/;~=PNO!"%"%s%m%C%/;~F~NO!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkSlock	XXX

/* $B%=%U%H%m%C%/$N>WFM$,$+$J$j5/$3$C$F$$$k$N$J$i$P0J2<$NJ}$,NI$$(B */
#PSL_define b_SoftLockWithOrgData(ptr_to_cell, imm_offset, org_data_reg)
{
  $USE(D_WorkSlock);
  @PROBE{p_MoveWord(D_NULL, D_SLockFailReg);};
  @PROBE{p_MoveWord(D_NULL, D_SLockSuccReg);};

Retry_Label:

  p_ReadWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);
  b_IfSLOCK(D_WorkSlock){
    @PROBE{b_IncrementReg(D_SLockFailReg);};
    goto Retry_Label;
  }

  p_ReadWithLockWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);
  b_IfSLOCK(D_WorkSlock){
    p_UnlockWithOffset(ptr_to_cell, imm_offset); 
    @PROBE{b_IncrementReg(D_SLockFailReg);};
    goto Retry_Label;
  }

  @PROBE{b_IncrementReg(D_SLockSuccReg);};
  p_MoveWord(D_WorkSlock,org_data_reg);
  b_SetImmTypeMRBoff(SLOCK, D_WorkSlock);
  @DEBUG{
    /* $B$@$l$,%=%U%H%m%C%/$r$7$?$N$+=q$$$F$*$/(B */
    p_MoveValue(D_PE_Number,D_WorkSlock);
  };
  p_WriteAndUnlockWithOffset(D_WorkSlock, ptr_to_cell, imm_offset);
  $RELEASE(D_WorkSlock);
}

/*
#PSL_define b_SoftLockWithOrgData(ptr_to_cell, imm_offset, org_data_reg)
{
  $USE(D_WorkSlock);
  @PROBE{p_MoveWord(D_NULL, D_SLockFailReg);};
  @PROBE{p_MoveWord(D_NULL, D_SLockSuccReg);};
Retry_Label:
  p_ReadWithLockWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);
  b_IfSLOCK(D_WorkSlock){
    @PROBE{b_IncrementReg(D_SLockFailReg);};
    p_UnlockWithOffset(ptr_to_cell, imm_offset); 
    goto Retry_Label;
  }
  @PROBE{b_IncrementReg(D_SLockSuccReg);};
  p_MoveWord(D_WorkSlock,org_data_reg);
  b_SetImmTypeMRBoff(SLOCK, D_WorkSlock);
  @DEBUG{
    <* $B$@$l$,%=%U%H%m%C%/$r$7$?$N$+=q$$$F$*$/(B *>
    p_MoveValue(D_PE_Number,D_WorkSlock);
  };
  p_WriteAndUnlockWithOffset(D_WorkSlock, ptr_to_cell, imm_offset);
  $RELEASE(D_WorkSlock);
}
*/

#PSL_define b_SoftUnlockWithOrgData(ptr_to_cell, imm_offset, org_data_reg)
{
  $USE(D_WorkSlock);
  p_ReadWithLockWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);
  @DEBUG{
    b_IfNotSLOCK(D_WorkSlock){
      VPIM_ERROR("b_SoftUnlock","Tried to Unlock NON_SLOCKED_Cell");
    }
    b_IfNotEqual(D_WorkSlock,D_PE_Number) {
      VPIM_ERROR("b_SoftUnlockWithOrgData",
		 "Tried to unlock in spite of non-owner");
    }
  };
  p_WriteAndUnlockWithOffset(org_data_reg, ptr_to_cell, imm_offset);
  $RELEASE(D_WorkSlock);
}

/******************************************************************** PSL **
3.2  $B%?%0$rMQ$$$?%=%U%H%m%C%/!J5l%?%0$rJ]B8!K(B

       written by nakase@icot22      on Wed Nov 29 15:43:12 1989
<Arguments>
  ptr_to_cell: $B%=%U%H%m%C%/BP>]$H$J$k%"%I%l%9$X$N%]%$%s%?(B
  imm_offset : $B%=%U%H%m%C%/BP>]$X$N(Bptr_to_cell$B$+$i$N%*%U%;%C%H(B
  org_tag_reg: $B%=%U%H%m%C%/BP>]$H$J$k%?%0$NFbMF!J%m%C%/;~=PNO!"%"%s%m%C%/;~F~NO!K(B
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/
/* $B%=%U%H%m%C%/$N>WFM$,$+$J$j5/$3$C$F$$$k$N$J$i$P0J2<$NJ}$,NI$$(B */

#PSL_define b_SoftLockWithOrgTag(ptr_to_cell, imm_offset, org_tag_reg)
{
  $USE(D_WorkSlock);
  @PROBE{p_MoveWord(D_NULL, D_SLockFailReg);};
  @PROBE{p_MoveWord(D_NULL, D_SLockSuccReg);};

Retry_Label:

  p_ReadWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);
  b_IfSLOCK(D_WorkSlock){
    @PROBE{b_IncrementReg(D_SLockFailReg);};
    goto Retry_Label;
  }

  p_ReadWithLockWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);
  b_IfSLOCK(D_WorkSlock){
    p_UnlockWithOffset(ptr_to_cell, imm_offset); 
    @PROBE{b_IncrementReg(D_SLockFailReg);};
    goto Retry_Label;
  }

  @PROBE{b_IncrementReg(D_SLockSuccReg);};
  p_MoveWord(D_WorkSlock,org_tag_reg);
  b_SetImmTypeMRBoff(SLOCK, D_WorkSlock);
  p_WriteAndUnlockWithOffset(D_WorkSlock, ptr_to_cell, imm_offset);
  $RELEASE(D_WorkSlock);
}

/*
#PSL_define b_SoftLockWithOrgTag(ptr_to_cell, imm_offset, org_tag_reg)
{
  $USE(D_WorkSlock);
  @PROBE{p_MoveWord(D_NULL, D_SLockFailReg);};
  @PROBE{p_MoveWord(D_NULL, D_SLockSuccReg);};
Retry_Label:
  p_ReadWithLockWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);
  b_IfSLOCK(D_WorkSlock){
    p_UnlockWithOffset(ptr_to_cell, imm_offset); 
<*       $B%G%P%C%0$N$?$a(B
      p_WriteAndUnlockWithOffset(D_WorkSlock,ptr_to_cell, imm_offset);
*>
    @PROBE{b_IncrementReg(D_SLockFailReg);};
    goto Retry_Label;
  }
  @PROBE{b_IncrementReg(D_SLockSuccReg);};
  p_MoveWord(D_WorkSlock,org_tag_reg);
  b_SetImmTypeMRBoff(SLOCK, D_WorkSlock);
  p_WriteAndUnlockWithOffset(D_WorkSlock, ptr_to_cell, imm_offset);
  $RELEASE(D_WorkSlock);
}
*/

#PSL_define b_SoftUnlockWithOrgTag(ptr_to_cell, imm_offset, org_tag_reg)
{
  @DEBUG{
    b_IfSLOCK(org_tag_reg) {
      VPIM_ERROR("b_SoftUnlockWithOrgTag","Unlock Pattern is SLOCK!!");
    }};
  $USE(D_WorkSlock);
  p_ReadWithLockWithOffset(ptr_to_cell, imm_offset, D_WorkSlock);  
  @DEBUG{
    b_IfNotSLOCK(D_WorkSlock){
      VPIM_ERROR("b_SoftUnlock","Tried to Unlock NON_SLOCKED_Cell");
    }};
  p_MoveTag(org_tag_reg, D_WorkSlock);
  p_WriteAndUnlockWithOffset(D_WorkSlock, ptr_to_cell, imm_offset);
  $RELEASE(D_WorkSlock);
}

/******************************************************************** PSL **

       written by f-hataza@icot22      on Tue Jul 23 17:30:35 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_ChangeDataWithLockX (addr, old_reg, new_reg)
{
  p_ReadWithLock(addr, old_reg);
	/* $BB>?M$,(B Lock$B$9$k2DG=@-$N$"$k=j$K!"(B p_Write$B$r$7$F$O$^$:$$(B
	   ($B%^%7%s%A%'%C%/$H$J$k(B)$B%^%7%s$,$"$k$?$a(B */
  p_WriteAndUnlock(new_reg, addr);
}

#PSL_define b_SubtractValueWithLockX (ptr_reg, imm_ofst, value_reg, dst_reg)
{
  p_ReadWithLockWithOffset(ptr_reg, imm_ofst, dst_reg);
  b_SubtractWithTag(dst_reg, value_reg, dst_reg);
  p_WriteAndUnlockWithOffset(dst_reg, ptr_reg, imm_ofst);
}
