
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_compare_swap.psl.c
   ----- CREATED   : by yamamoto@icot22, on Mon Jun 18 15:23:05 1990
   ----- LAST SAVED: by ttakagi@icot22, on Wed Apr 22 17:15:59 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : basics
   ----- ABSTRACT  : $B%3%s%Z%"%9%o%C%W7O$N%^%/%m(B

A. $B9`L\(B
  1. $B%3%s%Z%"%9%o%C%W(B($B%U%k%o!<%I(B)
  2. $B%3%s%Z%"%9%o%C%W(B($B%?%$%W!"%?%$%W!u%P%j%e!<(B)

B. $BGSB>%"%/%;%9$rH<$&A`:n$K$D$$$FDj5A$9$k(B.

  $B!&(BPIM$B$N%/%i%9%?$G$O(B, $BJ#?t$N%W%m%;%C%5$,%a%b%j$r6&M-$9$k$?$a(B, $B6&M-%G!<%?9=B$(B
    $B$X$N=q$-9~$_$K$OGSB>@)8f$,I,MW$G$"$k!#(B
    $B$3$N$h$&$JGSB>@)8f$r8zN(NI$/<B9T$9$k$?$a$K(B, PIM$B$N<B5!$G$O%O!<%I%&%'%"%m%C%/(B
    $B5!9=$r@_$1$F$$$k!#(B $B$?$@$7(B, $B%O!<%I%&%'%"5!9=>e(B, $B%m%C%/Cf$NA`:n$O%G%C%I%m%C%/(B
    $B$,@8$8$J$$$?$a$N@)8B$r<i$i$J$1$l$P$J$i$J$$!#(B

  $B!&%O!<%I%&%'%"%m%C%/$r(B($B%G%C%I%m%C%/$N?4G[L5$7$K(B)$B0BA4$K;H$&$?$a$K(B, VPIM$B$G$O(B
    $B%3%s%Z%"%9%o%C%W$r4pK\$H$9$k%^%/%m$r@_$1$k!#(B
    
  $B!&%"%/%F%#%V%f%K%U%#%1!<%7%g%s$K$*$1$kL$Dj5AJQ?t$N6qBN2=$G$O(B, KL1$B$NC10lBeF~$N(B
    $B@-<A$rMxMQ$7(B, $B%?%$%WIt$N$_$rHf3S$9$k!#$3$l$O(B, 
	a. $B%?%$%WIt$N$_$K$h$C$FL$Dj5AJQ?t$r<1JL$G$-$k!#(B
	b. $B%?%$%W$,(BHOOK/MHOOK$B$N>l9g(B, $BCMIt$G%5%9%Z%s%I$7$F$$$k%4!<%k$X$N%j%s%/(B
	   $B$,JQ99$9$k2DG=@-$,$"$k$,(B, $B%m%C%/$7$FFI$_=P$7$?CM$,%j%s%/$rDO$s$G$$$k(B
           $B$?$a(B, $B@5$7$$%j%8%e!<%`A`:n$,2DG=$G$"$k(B,
    $B$?$a$G$"$k!#(B
    $B$?$@$7(B, $BHf3S$K<:GT$7$?>l9g$O(B, $B$=$NJQ?t%;%k$X$N%Q%9$,;}$D(BMRB$B>pJs$r@5$7$/J];}(B
    $B$9$k$?$a$NA`:n$,I,MW$H$J$k!#(B

  $B!&Aq1`%l%3!<%I$N$h$&$K(B, $B%W%m%;%C%5$+$i6&M-$5$l$k%G!<%?9=B$$NFbIt%9%F!<%?%9$r(B
    $BJQ99$9$k>l9g$bGSB>@)8f$,I,MW$G$"$k!#(B

C. $B4XO"(B
  $B!&%W%m%;%C%54V$N%7%0%J%kDL?.$K$*$1$kGSB>@)8f$O(B bsc_comm_acc.psl.c $B$r;2>H(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B%3%s%Z%"%9%o%C%W(B($B%U%k%o!<%I(B)

       written by goto@icot22      Wed Jan  4 14:03:11 1989

<Arguments>
  ptr_reg : $BGSB>%"%/%;%9$NBP>]$H$J$k%"%I%l%9(B
  org_reg : $BA0$b$C$FFI$_=P$7$?GSB>%"%/%;%9$NBP>]$H$J$k%o!<%I$NCf?H(B 
  new_reg : $B%9%o%C%W$9$k?7%G!<%?$N%l%8%9%?(B
  imm_type : new_reg $B$KB(CM$H$7$FM?$($k%?%$%W(B
<Temporally Used Variables> 
  D_WorkCurrentCell : $B2~$a$FFI$_=P$7$?GSB>%"%/%;%9$NBP>]$H$J$k%o!<%I$NCf?H(B 
<Level> basics
<PreCondition>
  org_reg$B$K$OA0$b$C$FFI$_=P$7$?%o!<%I$NCf?H$,F~$C$F$$$k$H$9$k(B
<Function>
  $B!&(Bb_CompareSwapWithOffsetX(ptr_reg,imm_ofst,org_reg,new_reg) 
  ptr_reg $B$N@h$r%m%C%/$7$F(B D_WorkCurrentCell $B$KFI$_$@$7(B, org_reg $B$H%o!<%IA4BN(B
  (MRB,Type) $B$rHf3S$9$k(B.
  $BEy$7$1$l$P(B, ptr_reg $B$N@h$K(B new_reg $B$r=q$-9~$s$G%"%s%m%C%/$9$k(B.
  $BEy$7$/$J$1$l$P(B, ptr_reg $B$N@h$r%"%s%m%C%/$7(B, $BFI$_=P$7$?(B D_WorkCurrentCell $B$r(B
  org_reg$B$K0\$9!#(B
  $B!&(Bb_CompareSwapWithTypeX(ptr_reg,org_reg,new_reg,imm_type) 
  $B>e5-$K2C$($F(B, $BB(CM%?%$%W$r@_Dj$9$k(B (MRB, $B$OI,$:(B _MRB_OFF $B$H$J$k(B)

<Examples>
<Test>
<Explanation>
  $BHf3S7k2L$N%3%s%G%#%7%g%s%3!<%I$O(B CCR $B$KJ]B8$5$l$F$$$k(B.
  $B0lHLE*$J%3%s%Z%"%9%o%C%WA`:n$G$"$k!#%"%/%F%#%V%f%K%U%!%$$N%^%/%m$G$O(B
  $BJL%^%/%m(B(b_TypeCompareSwapX)$B$rMQ$$$k!#(B
<ETC>
********************************************************************* PSL **/

#DATA_define D_WorkCurrentCell	XXX

#PSL_define b_CompareSwapWithOffsetX (ptr_reg, imm_ofst, org_reg, new_reg)
{
  @DEBUG{
    b_IfRangeUnderImm(ptr_reg, _HEAP_AREA_BASE) {
      VPIM_ERROR("b_CompareSwapWithOffsetX","ttakagi check point");
    }
    p_IfTypeEQImmediate(ptr_reg, _TYPE_FLC) {
      VPIM_ERROR("b_CompareSwapWithOffsetX","ptr_reg type == FLC");
    }
  };    
  $USE(D_WorkCurrentCell); 
  p_ReadWithLockWithOffset (ptr_reg, imm_ofst, D_WorkCurrentCell);
  b_IfWordEq (org_reg, D_WorkCurrentCell) {
    p_WriteAndUnlockWithOffset (new_reg, ptr_reg, imm_ofst);
    b_SetSuccess();
  } else { 
    p_UnlockWithOffset (ptr_reg, imm_ofst);
    p_MoveWord (D_WorkCurrentCell, org_reg); 
    b_SetFail();
  }
  $RELEASE(D_WorkCurrentCell);
}

/******************************************************************** PSL **
2. $B%3%s%Z%"%9%o%C%W(B($B%?%$%W!u%P%j%e!<(B)

***CAUTION*** $BMW%3%a%s%H8+D>$7(B

       written by goto@icot22      Wed Jan  4 14:03:11 1989

<Arguments>
  ptr_reg : $BGSB>%"%/%;%9$NBP>]$H$J$k%"%I%l%9(B
  org_reg : $BA0$b$C$FFI$_=P$7$?GSB>%"%/%;%9$NBP>]$H$J$k%o!<%I$NCf?H(B 
  new_reg : $B%9%o%C%W$9$k?7%G!<%?$N%l%8%9%?(B
<Temporally Used Variables> 
  D_WorkCurrentCell : $B2~$a$FFI$_=P$7$?GSB>%"%/%;%9$NBP>]$H$J$k%o!<%I$NCf?H(B 
<Level> basics
<PreCondition>
  org_reg$B$K$OA0$b$C$FFI$_=P$7$?%o!<%I$NCf?H$,F~$C$F$$$k$H$9$k(B. org_reg $B$N(B MRB$B$O(B
  $B$=$NJQ?t$X$N%Q%9(BMRB$B$rI=8=$7$F$$$k$?$a(B, $BHf3S$G<:GT$7$?>l9g$G$b(B, 
  s_ReadWithMRBor $B$GFI$_D>$7$?$b$N$r(B org_reg $B$K@_Dj$9$k!#(B
<Function>
  $B!&(Bb_TypeCompareSwapX(ptr_reg,org_reg,new_reg) :: NOT USED
  ptr_reg $B$N@h$r%m%C%/$7$F(B D_WorkCurrentCell $B$KFI$_$@$7(B, $B$=$N%?%$%W$H(Borg_reg $B$N(B
  $B%?%$%W$rHf3S$9$k(B.
  $BEy$7$1$l$P(B, ptr_reg $B$N@h$K(B new_reg $B$r=q$-9~$s$G%"%s%m%C%/$9$k(B.
  $B$3$N;~(B, D_WorkCurrentCell $B$r(B org_reg $B$K0\$9!#(B
  ( HOOK! -->GR1  ==> HOOK! -->GR2--> $B$H$J$k>l9g$KHw$($F(B...)
  $BEy$7$/$J$1$l$P(B, ptr_reg $B$N@h$r%"%s%m%C%/$7(B, $B:F$S(B, ptr_reg$B$N@h$NFbMF$r(B
  s_ReadWithMRBor $B$G(B org_reg$B$KFI$_=P$9!#(B

  $B!&(Bb_TypeValueCompareSwapX(ptr_reg,org_reg,new_reg) 
  ptr_reg $B$N@h$r%m%C%/$7$F(B D_WorkCurrentCell $B$KFI$_$@$7(B, $B$=$N(B"$B%?%$%W(B, $BCM(B"$B$r(B
  org_reg $B$N(B"$B%?%$%W(B, $BCM(B"$B$rHf3S$9$k(B.
  $BEy$7$1$l$P(B, ptr_reg $B$N@h$K(B new_reg $B$r=q$-9~$s$G%"%s%m%C%/$9$k!#(B
  $BEy$7$/$J$1$l$P(B, ptr_reg $B$N@h$r%"%s%m%C%/$7(B, $B:F$S(B, ptr_reg$B$N@h$NFbMF$r(B
  s_ReadWithMRBor $B$G(B org_reg$B$KFI$_=P$9!#(B

<Examples>
  $B!&(Bb_TypeCompareSwapX :: NOT USED
  $BDL>o$N%"%/%F%#%V%f%K%U%#%1!<%7%g%s(B($BJQ?t$N6qBN2=(B)$B$GMQ$$$k!#(B
  (see f_IfSuccessActUnifyWithPtrMRBX,  f_IfFailActUnifyWithPtrMRBX )

  $B!&(Bb_TypeValueCompareSwapX
  get_value $BL?Na$N<B9T$K$*$$$F(B, Hook$B7OF1;N$r%f%K%U%!%$$9$k;~(B, $BJQ?t$+$i$N%5%9%Z(B
  $B%s%I%4!<%k$N%j%s%/$r@\B3$7(B, $B0lJ}$NJQ?t$K%j%s%/$9$k;~$KMQ$$$k!#(B
  (see f_IfSuccessHookGoalX,  f_IfFailHookGoalX )
<Test>
<Explanation>
  $BHf3S7k2L$N%3%s%G%#%7%g%s%3!<%I$O(B CCR $B$KJ]B8$5$l$F$$$k(B.
  $B8=(BPSL$B$G$O%^%/%m$N0z?t$H$7$F(B goto$B%i%Y%k$,=q$1$J$$$?$a(B, $BHf3S7k2L$r(BCCR$B$KJ]B8$7(B,
  $B%^%/%m$N30B&$G(B goto$BJ8$r=q$$$F$$$k!#<B:]$N=hM}7O$G$O(B, b_TypeCompareSwapX$B$r(B
  $BE83+$7(B, goto$BJ8$r$=$NFbB&$K5-=R$7$?J}$,NI$$!#(B

  $B%^%/%m$N:G=i$K$"$k(B, p_ReadWithLock $B$K(BMRBor $B$N5!G=$,$"$l$P(B
  (ex. p_ReadWithLockMRBor ) $B:G8e$N(B s_ReadWithMRBor $B$O(B 
  p_MoveWord (D_WorkCurrentCell, org_reg) $B$H$9$k$3$H$,$G$-$k!#(B

<ETC>
********************************************************************* PSL **/

#PSL_define b_TypeValueCompareSwapX (ptr_reg, org_reg, new_reg)
{
  @DEBUG{
    b_IfRangeUnderImm(ptr_reg, _HEAP_AREA_BASE) {
      VPIM_ERROR("b_TypeValueCompareSwapX","ttakagi check point");
    }
  };    
  $USE(D_WorkCurrentCell);

  p_ReadWithLock (ptr_reg, D_WorkCurrentCell);
  b_IfTypeValueEq (org_reg, D_WorkCurrentCell) {
    p_WriteAndUnlock (new_reg, ptr_reg);
    b_SetSuccess();
  } else { 
    p_Unlock (ptr_reg); 
    s_ReadWithMRBor (ptr_reg, org_reg);  /* org_reg $B$,99?7$5$l$k(B */
    b_SetFail();
  }
  $RELEASE(D_WorkCurrentCell);
}

/******************************************************************** PSL **
GC$BMQ$N(B Compare & Swap

       written by f-hataza@icot22      on Tue Jul 23 19:48:45 1991
<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#DATA_define	D_WorkNewReg	XXX

#PSL_define b_CompareSwapGCOldAreaX(ptr_reg,old_reg,new_reg)
{
  $USE(D_WorkNewReg);
  p_ReadWithLock(ptr_reg,D_WorkNewReg);
  /* $B%o!<%IA4BN$rHf3S$9$kI,MW$O$J$/!"(BGC$B%^!<%/$NH=Dj$@$1$GNI$$(B */
  b_IfNotMARKED(D_WorkNewReg) {
    p_MoveValue(new_reg,D_WorkNewReg);
    b_SetImmTypeMRBoff(MARKED,D_WorkNewReg);
    p_WriteAndUnlock(D_WorkNewReg,ptr_reg);
    b_SetSuccess();
  } else {
    p_Unlock(ptr_reg);
    p_MoveWord(D_WorkNewReg,old_reg);
    b_SetFail();
  }
  $RELEASE(D_WorkNewReg);
}

#PSL_define b_CompareSwapGCBusyFlagX(addr,old)
{
  $USE(D_WorkNewReg);
  b_IfSLOCK(old) { /* old$B$O%=%U%H%m%C%/Cf$N$b$N$rFI$s$@7k2L$+$b(B
    				$B$7$l$J$$$N$G(B */
    /* CompareSwap$B<:GT$H8+$J$9(B */
    b_SetFail();
  } else {
    p_ReadWithLock(addr,D_WorkNewReg);
    b_IfTypeValueEq (D_WorkNewReg,old) {
      b_SetImmTypeMRBoff(SLOCK,D_WorkNewReg);
      p_WriteAndUnlock(D_WorkNewReg,addr);
      b_SetSuccess();
    } else {
      p_Unlock(addr);
    /* CompareSwap$B<:GT(B */
      b_SetFail();
    }
  }
  $RELEASE(D_WorkNewReg);
}
