
/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_bignum.psl.c
   ----- CREATED   : by yamamoto@icot22, on Sun Feb 23 19:01:11 1992
   ----- LAST SAVED: by yamamoto@icot22, on Sun Feb 23 19:51:34 1992
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : 
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **

       written by yamamoto@icot22      on Sun Feb 23 19:10:06 1992

$BG\@:EY@0?t!"B>G\D9@:EY@0?t$N%5%]!<%H$G?7$?$K:n@.$7$?!"(B
$B#b%l%Y%k%^%/%m(B

********************************************************************* PSL **/

#PSL_define b_Add_ExtendedInt(arg0,arg1,arg2,arg3){
  b_AddDoubleWord(D_NULL,arg0,D_NULL,arg1,arg2,arg3);
  p_MoveType(arg0,arg2);
  p_MoveType(arg0,arg3);
}

#PSL_define b_Subtract_ExtendedInt(arg0,arg1,arg2,arg3){
  b_SubtractDoubleWord(D_ONE,arg0,D_NULL,arg1,arg2,arg3);
  b_BitwiseEorWithDNTC(arg2,D_ONE,arg2);
  p_MoveType(arg0,arg2);
  p_MoveType(arg0,arg3);
}

#DATA_define D_WorkBignum1 XXX
#DATA_define D_WorkBignum2 XXX
#DATA_define D_WorkBignum3 XXX
#DATA_define D_WorkBignum4 XXX
#DATA_define D_WorkBignum5 XXX
#DATA_define D_WorkBignum6 XXX
#DATA_define D_WorkBignum7 XXX

#CONST_define _ValueLowerHalfMask     0xffff
#CONST_define _ValueUpperHalfMask 0xffff0000
#CONST_define _ValueHalfWidth             16
#CONST_define _ValueWidth                 32

#PSL_define  b_Multiply_ExtendedInt(arg0,arg1,arg2,arg3){
/*   $B4{B8$N%W%j%_%F%#%V$GAGKQ$K=q$/$3$H(B
  _Multiply_ExtendedInt(arg0,arg1,arg2,arg3);
*/
  $USE(D_WorkBignum1);
  $USE(D_WorkBignum2);
  $USE(D_WorkBignum3);
  $USE(D_WorkBignum4);
  $USE(D_WorkBignum5);

  b_BitwiseAndImmediateWithDNTC(arg0,_ValueLowerHalfMask,D_WorkBignum1);
  b_BitwiseAndImmediateWithDNTC(arg1,_ValueLowerHalfMask,D_WorkBignum2);
  b_UnsignedMultiplyWithDNTC(D_WorkBignum1,D_WorkBignum2,arg3);

  b_BitwiseAndImmediateWithDNTC(arg0,_ValueUpperHalfMask,D_WorkBignum4);
  b_ShiftRightImmediateWithDNTC(D_WorkBignum4,_ValueHalfWidth,D_WorkBignum4);
  b_BitwiseAndImmediateWithDNTC(arg1,_ValueUpperHalfMask,D_WorkBignum5);
  b_ShiftRightImmediateWithDNTC(D_WorkBignum5,_ValueHalfWidth,D_WorkBignum5);
  b_UnsignedMultiplyWithDNTC(D_WorkBignum4,D_WorkBignum5,arg2);

  b_UnsignedMultiplyWithDNTC(D_WorkBignum1,D_WorkBignum5,D_WorkBignum3);
  b_BitwiseAndImmediateWithDNTC(D_WorkBignum3,
				_ValueLowerHalfMask,D_WorkBignum1);
  b_BitwiseAndImmediateWithDNTC(D_WorkBignum3,
				_ValueUpperHalfMask,D_WorkBignum5);
  b_ShiftLeftImmediateWithDNTC(D_WorkBignum1,_ValueHalfWidth,D_WorkBignum1);
  b_ShiftRightImmediateWithDNTC(D_WorkBignum5,_ValueHalfWidth,D_WorkBignum5);
  b_AddDoubleWord(arg2,arg3,D_WorkBignum5,D_WorkBignum1,arg2,arg3);

  b_UnsignedMultiplyWithDNTC(D_WorkBignum4,D_WorkBignum2,D_WorkBignum3);
  b_BitwiseAndImmediateWithDNTC(D_WorkBignum3,
				_ValueLowerHalfMask,D_WorkBignum2);
  b_BitwiseAndImmediateWithDNTC(D_WorkBignum3,
				_ValueUpperHalfMask,D_WorkBignum4);
  b_ShiftLeftImmediateWithDNTC(D_WorkBignum2,_ValueHalfWidth,D_WorkBignum2);
  b_ShiftRightImmediateWithDNTC(D_WorkBignum4,_ValueHalfWidth,D_WorkBignum4);
  b_AddDoubleWord(arg2,arg3,D_WorkBignum4,D_WorkBignum2,arg2,arg3);
  
  $RELEASE(D_WorkBignum1);
  $RELEASE(D_WorkBignum2);
  $RELEASE(D_WorkBignum3);
  $RELEASE(D_WorkBignum4);
  $RELEASE(D_WorkBignum5);

  p_MoveType(arg0,arg2);
  p_MoveType(arg0,arg3);
}


#PSL_define b_Divide_ExtendedInt(arg0,arg1,arg2,arg3,arg4){
  /*   $B4{B8$N%W%j%_%F%#%V$GAGKQ$K=q$/$3$H(B  */

  $USE(D_WorkBignum1);
  $USE(D_WorkBignum2);
  $USE(D_WorkBignum3);
  $USE(D_WorkBignum4);
  $USE(D_WorkBignum5);
  $USE(D_WorkBignum6);
  $USE(D_WorkBignum7);

  p_MoveWord(arg0,D_WorkBignum1);
  p_MoveWord(arg1,D_WorkBignum2);
  p_MoveWord(arg2,D_WorkBignum3);
  p_MoveWord(D_NULL,D_WorkBignum4);
  b_ShiftRightDoubleWordWithDNTC(D_WorkBignum3,D_WorkBignum4);
  b_SetImmValueDNTC(_ValueWidth,D_WorkBignum7);
  p_MoveWord(D_NULL,arg3);

  LOOP(){
    b_IfZero(D_WorkBignum7)break;
    b_SubtractDoubleWord(D_WorkBignum1,D_WorkBignum2,
			 D_WorkBignum3,D_WorkBignum4,
			 D_WorkBignum5,D_WorkBignum6);
    b_ShiftLeftImmediateWithDNTC(arg3,_ONE,arg3);
    b_IfPositive(D_WorkBignum5){
      b_BitwiseOrImmediateWithDNTC(arg3,_ValueLSB,arg3);    
      p_MoveWord(D_WorkBignum5,D_WorkBignum1);
      p_MoveWord(D_WorkBignum6,D_WorkBignum2);
    }
    b_ShiftRightDoubleWordWithDNTC(D_WorkBignum3,D_WorkBignum4);
    b_DecrementReg(D_WorkBignum7);
  }

  p_MoveWord(D_WorkBignum2,arg4);
  
  $RELEASE(D_WorkBignum1);
  $RELEASE(D_WorkBignum2);
  $RELEASE(D_WorkBignum3);
  $RELEASE(D_WorkBignum4);
  $RELEASE(D_WorkBignum5);
  $RELEASE(D_WorkBignum6);
  $RELEASE(D_WorkBignum7);

  p_MoveType(arg0,arg3);
  p_MoveType(arg0,arg4);

}

#DATA_define D_WorkDWordShift XXX
#CONST_define _ValueLSB          1
#CONST_define _ValueMSB 0x80000000
/*                        01234567 */

/* unisigned double word 1 bit shift operation */

#PSL_define b_ShiftRightDoubleWordWithDNTC(high,low){
$USE(D_WorkDWordShift);
b_BitwiseAndImmediateWithDNTC(high,_ValueLSB,D_WorkDWordShift);
b_ShiftRightImmediateWithDNTC(high,_ONE,high);
b_ShiftRightImmediateWithDNTC(low,_ONE,low);
b_IfNotZero(D_WorkDWordShift){
  b_BitwiseOrImmediateWithDNTC(low,_ValueMSB,low);
}
$RELEASE(D_WorkDWordShift);
}

#PSL_define b_ShiftLeftDoubleWordWithDNTC(high,low){
$USE(D_WorkDWordShift);
b_BitwiseAndImmediateWithDNTC(low,_ValueMSB,D_WorkDWordShift);
b_ShiftLeftImmediateWithDNTC(high,_ONE,high);
b_ShiftLeftImmediateWithDNTC(low,_ONE,low);
b_IfNotZero(D_WorkDWordShift){
  b_BitwiseOrImmediateWithDNTC(high,_ValueLSB,high);
}
$RELEASE(D_WorkDWordShift);
}

#CTRL_define b_IfPositive(reg){
  b_BitwiseAndImmediateWithDNTC(reg,_ValueMSB,D_VOID);
  p_IfEQ()
}

#PSL_define b_UnsignedMultiplyWithDNTC(src1,src2,dst){
/* p_UnsignedMultiply(src1,src2,dst); ** more efficient way ****/
  b_UnsignedMultiplyWithoutOverflowCheck(src1,src2,dst);
  @DEBUG { b_SetImmTypeMRBoff(DNTC,dst); };
}

#PSL_define b_UnsignedMultiply(src1,src2,dst){
  /* p_UnsignedMultiply(src1,src2,dst); ** more efficient way ****/
  b_UnsignedMultiplyWithoutOverflowCheck(src1,src2,dst);
}

/****************** more efficient way ***
#PSL_define p_UnsignedMultiply(src1,src2,dst){
  _UnsignedMultiply(src1,src2,dst);
}
********************/

#DATA_define D_Work_UMUL_Src1 XXX
#DATA_define D_Work_UMUL_Src2 XXX

/** very naive way **/
#PSL_define b_UnsignedMultiplyWithoutOverflowCheck(src1,src2,dst){

  $USE(D_Work_UMUL_Src1);
  $USE(D_Work_UMUL_Src2);
  p_MoveWord(src1,D_Work_UMUL_Src1);
  p_MoveWord(src2,D_Work_UMUL_Src2);
  p_MoveWord(D_NULL,dst);
  LOOP(){
    b_IfZero(D_Work_UMUL_Src1){break;}
    b_IfOdd(D_Work_UMUL_Src1){
      b_AddWithDNTC(dst,D_Work_UMUL_Src2,dst);
    }
    b_ShiftRightImmediate(D_Work_UMUL_Src1,_ONE,D_Work_UMUL_Src1);
    b_ShiftLeftImmediate(D_Work_UMUL_Src2,_ONE,D_Work_UMUL_Src2);
  }
  $RELEASE(D_Work_UMUL_Src1);
  $RELEASE(D_Work_UMUL_Src2);
}


