/* == * == * == * == * == * == * == * == * == * == * == P S L = F I L E  == *
   ----- FILE NAME : /usr/pim/vpim/V20/basics/bsc_arith2word.psl.c
   ----- CREATED   : by nakagawa@icot22, on Fri Jun 30 20:37:09 1989
   ----- LAST SAVED: by imai@icot22, on Tue Oct 15 18:56:56 1991
   ----- COPYRIGHT : (C)1992 Institute for New Generation Computer Technology
   ----- LEVEL     : 
   ----- ABSTRACT  : $B#6#4%S%C%H$N;;=Q1i;;$N$?$a$N%^%/%m72(B
 * == * == * == * == * == * == * == * == * == * == * == * == * == * == * == */

/******************************************************************** PSL **
1. $B#6#4%S%C%H$NB-$7;;(B
  b_AddDoubleWord
       written by imai@icot22      on Tue Jun 19 21:10:23 1990
<Arguments>
  src1_l : source_1 lower 32 bit
  src1_u : source_1 upper 32 bit
  src2_l : source_2 lower 32 bit
  src2_u : source_2 upper 32 bit
  dst_l  : destination lower 32 bit
  dst_u  : destination upper 32 bit
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define _ADD_MASK_LO 0x3fffffff

#DATA_define D_WorkS1 	XXX
#DATA_define D_WorkS2 	XXX

#PSL_define b_AddDoubleWord(src1_u,src1_l,src2_u,src2_l,dst_u,dst_l)
{
  b_AddWithTag(src2_u,src1_u,dst_u);
  b_AddWithCarry(src2_l,src1_l,dst_l);
  p_IfOverflow() {
    b_AddWithCarry(dst_u,D_ONE,dst_u);
  }
}

/******************************************************************** PSL **
1. $B#6#4%S%C%H$N0z$-;;(B
  b_AddDoubleWord
       written by imai@icot22      on Tue Jun 19 21:10:23 1990
<Arguments>
  src1_l : source_1 lower 32 bit
  src1_u : source_1 upper 32 bit
  src2_l : source_2 lower 32 bit
  src2_u : source_2 upper 32 bit
  dst_l  : destination lower 32 bit
  dst_u  : destination upper 32 bit
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#PSL_define b_SubtractDoubleWord(src1_u,src1_l,src2_u,src2_l,dst_u,dst_l) 
{
  $USE(D_WorkS1); $USE(D_WorkS2);

  b_BitwiseComplementWithDNTC(src2_u,D_WorkS1);
  b_BitwiseComplementWithDNTC(src2_l,D_WorkS2);
  b_AddWithCarry(D_WorkS2, D_ONE, D_WorkS2);
  p_IfOverflow(){
    b_AddWithDNTC(D_WorkS1, D_ONE, D_WorkS1);
  }
  b_AddDoubleWord(src1_u, src1_l, D_WorkS1, D_WorkS2, dst_u, dst_l);
 
  $RELEASE(D_WorkS1); $RELEASE(D_WorkS2);
}


#PSL_define b_AddDoubleWordWithTag(src1_u,src1_l,src2_u,src2_l,dst_u,dst_l)
{
  b_AddWithDNTC(src2_u,src1_u,dst_u);
  b_AddWithCarry(src2_l,src1_l,dst_l);
  p_IfOverflow() {
    b_AddWithCarry(dst_u,D_ONE,dst_u);
  }
  p_MoveTag(src1_u,dst_u);
  p_MoveTag(src1_l,dst_l);
}


#PSL_define b_SubtractDoubleWordWithTag(src1_u,src1_l,src2_u,src2_l,dst_u,dst_l) 
{
  $USE(D_WorkS1); $USE(D_WorkS2);

  b_BitwiseComplementWithDNTC(src2_u,D_WorkS1);
  b_BitwiseComplementWithDNTC(src2_l,D_WorkS2);
  b_AddWithCarry(D_WorkS2, D_ONE, D_WorkS2);
  p_IfOverflow(){
    b_AddWithDNTC(D_WorkS1, D_ONE, D_WorkS1);
  }
  b_AddDoubleWord(src1_u, src1_l, D_WorkS1, D_WorkS2, dst_u, dst_l);

  p_MoveTag(src1_u,dst_u);
  p_MoveTag(src1_l,dst_l);

  $RELEASE(D_WorkS1); $RELEASE(D_WorkS2);
}


#DATA_define D_Work24 XXX

#CONST_define _SHIFT_FOR_MSB 31 /* i believe that value field has 32 bits */
/*  $B?.$8$F$$$k$J$i$P!"$$$-$J$j(BMSB$B$K#1$,N)$C$?%S%C%H%Q%?%s$r%;%C%H$7$F$b(B
  $BNI$$$N$G$O!)(B */

#PSL_define b_HalveDoubleWord(src1_u,src1_l,dst_u,dst_l)
{
  $USE(D_Work24);
  b_BitwiseAndWithDNTC(src1_u,D_ONE,D_VOID);
  p_IfNE()
    {
      b_ShiftLeftImmediateWithDNTC(D_ONE,_SHIFT_FOR_MSB,D_Work24);
    } else {
      p_MoveWord(D_NULL,D_Work24);
    }
  b_ShiftRightImmediateWithTag(src1_u,_ONE,dst_u);
  b_ShiftRightImmediateWithDNTC(src1_l,_ONE,dst_l);
  b_BitwiseOrWithTag(dst_l,D_Work24,dst_l);
  $RELEASE(D_Work24);
}

/******************************************************************** PSL **
b_AddWithCarry

       written by nakase@icot22      on Mon Nov 13 14:29:06 1989

<Arguments>
<Temporally Used Variables>
<Level>
<PreCondition>
<Function>
  $B%-%c%j!<IU$-2C;;!#(B
<Examples>
<Test>
<Explanation>
<ETC>
********************************************************************* PSL **/

#CONST_define _HALF_WORD_MASK 0x0000ffff
#CONST_define _HALF_WORD_OFFSET 16
#CONST_define _OVER_FLOW_VALUE 0x7fffffff

#DATA_define D_WorkSrcL1 XXX
#DATA_define D_WorkSrcL2 XXX
#DATA_define D_WorkSrcH1 XXX
#DATA_define D_WorkSrcH2 XXX
#DATA_define D_WorkDstL  XXX
#DATA_define D_WorkDstH  XXX
#DATA_define D_WorkOverFlow  XXX

#PSL_define b_AddWithCarry(src1, src2, dst1)
{
  $USE(D_WorkSrcL1);$USE(D_WorkSrcL2);$USE(D_WorkDstL);
  $USE(D_WorkSrcH1);$USE(D_WorkSrcH2);$USE(D_WorkDstH);
  $USE(D_WorkOverFlow);

  b_BitwiseAndImmediateWithDNTC(src1, _HALF_WORD_MASK, D_WorkSrcL1);
  b_BitwiseAndImmediateWithDNTC(src2, _HALF_WORD_MASK, D_WorkSrcL2);
  b_AddWithDNTC(D_WorkSrcL1, D_WorkSrcL2, D_WorkDstL);
       /* $B2<0L#1#6%S%C%H$N2C;;(B */
  b_ShiftRightImmediateWithDNTC(src1, _HALF_WORD_OFFSET, D_WorkSrcH1);
  b_ShiftRightImmediateWithDNTC(src2, _HALF_WORD_OFFSET, D_WorkSrcH2);
  b_AddWithDNTC(D_WorkSrcH1, D_WorkSrcH2, D_WorkDstH);
       /* $B>e0L#1#6%S%C%H$N2C;;(B */
  b_IfGreaterImm(D_WorkDstL, _HALF_WORD_MASK){
    b_AddWithDNTC(D_WorkDstH, D_ONE, D_WorkDstH);
       /* $B2<0L#1#6%S%C%H$N2C;;$G7k2L$,#1#7%S%C%H0J>e$K$J$k$H!"(B
	  $B>e0L#1#6%S%C%H$N2C;;$N7k2L$K#1$r2C$($k!#(B */
  }
  b_ShiftLeftImmediateWithDNTC(D_WorkDstH, _HALF_WORD_OFFSET, dst1);
       /* $B>e0L#1#6%S%C%H$N2C;;$N7k2L$r!"(BDestination$B$N>e0L$K;}$C$FMh$k!#(B */ 
  b_BitwiseAndImmediateWithDNTC(D_WorkDstL, _HALF_WORD_MASK, D_WorkDstL);
  b_BitwiseOrWithDNTC(D_WorkDstL, dst1, dst1);
       /* $B2<0L#1#6%S%C%H$N2C;;$N7k2L$r!"(BDestination$B$N2<0L$K;}$C$FMh$k!#(B */ 
  b_IfGreaterImm(D_WorkDstH, _HALF_WORD_MASK){
    b_SetImmValueDNTC(_OVER_FLOW_VALUE, D_WorkOverFlow);
    b_AddWithDNTC(D_WorkOverFlow, D_WorkOverFlow, D_VOID);
       /* $B>e0L#1#6%S%C%H$N2C;;$G7k2L$,#1#7%S%C%H0J>e$K$J$k$H!"(B
	  $B%*!<%P!<%U%m!<!&%U%i%0$rN)$F$k(B */
  }else{
    b_AddWithDNTC(D_ONE,D_ONE,D_VOID);
  }
  $RELEASE(D_WorkOverFlow);$RELEASE(D_WorkDstH);$RELEASE(D_WorkSrcH2);
  $RELEASE(D_WorkSrcH1);$RELEASE(D_WorkDstL);$RELEASE(D_WorkSrcL2);
  $RELEASE(D_WorkSrcL1);
}

/*********************************

$BAq1`N$?FMQ(B $B%j%=!<%90n$l%A%'%C%/%^%/%m(B

b_CheckResourceSurplus(current_u,current_l,supplied_u,supplied_l,
			 addend_u,addend_l,surplus_u,surplus_l)

$B%@%V%k%o!<%I$NB-$7;;$K@h$@$C$F!"0n$l%A%'%C%/$r9T$J$$!"(B
$BB-$79~$`$Y$-NL$H!"0n$l$N$=$l$>$l$r;;=P$9$k!#(B

$B:n@o$O0J2<$N$H$*$j!#(B

check_surplus(current, supplied , addend , surplus ){
  if( current > BIG ){
    addend = 0 ;
    surplus = supplied ;
    return;
  }
  if( supplied > BIG ){
    surplus = current ; 
    addend = supplied - current ; <* current + addend == supplied *>
    return;
  }
  addend = supplied;
  surplus = 0;
  return;
}

$B0J2<$N$h$&$K;H$&!#(B
	
check_surplus(current, supplied , addend , surplus );
if(addend != 0) current += addend;
if(surplus!= 0) return_to_somewhere(surplus);

***************************************/

#CONST_define _RESOURCE_BIG_ENOUGH 0x10000000 /* compared with upper word */
                                              /* == 2^60 */

#PSL_define b_CheckResourceSurplus(current_u,
				     current_l,
				     supplied_u,
				     supplied_l,
				     addend_u,
				     addend_l,
				     surplus_u,
				     surplus_l){

  b_IfGreaterImm(current_u , _RESOURCE_BIG_ENOUGH){
    p_MoveWord( D_NULL , addend_u );
    p_MoveWord( D_NULL , addend_l );
    p_MoveWord( supplied_u , surplus_u );
    p_MoveWord( supplied_l , surplus_l );
    goto L_END;
  }
  b_IfGreaterImm(supplied_u , _RESOURCE_BIG_ENOUGH){
    p_MoveWord( current_u , surplus_u );
    p_MoveWord( current_l , surplus_l );
    b_SubtractDoubleWord(supplied_u,
			 supplied_l,
			 current_u,
			 current_l,
			 addend_u,
			 addend_l);
    goto L_END;
  }
  p_MoveWord( supplied_u , addend_u );
  p_MoveWord( supplied_l , addend_l );
  p_MoveWord( D_NULL , surplus_u );
  p_MoveWord( D_NULL , surplus_l );
 L_END:;
}

#CTRL_define b_IfZeroDoubleWord( upper , lower){
  b_IfNotZero(lower){
    b_SetFail();
  }else{
    b_IfNotZero(upper){
      b_SetFail();
    }else{
      b_SetSuccess();
    }
  }
  b_IfSuccess()
}

#CTRL_define b_IfNotZeroDoubleWord( upper , lower){
  b_IfNotZero(lower){
    b_SetSuccess();
  }else{
    b_IfNotZero(upper){
      b_SetSuccess();
    }else{
      b_SetFail();
    }
  }
  b_IfSuccess()
}
