/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/arith.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>

extern int functors[];
extern int arities[];

void *unify_term_dcode_module();
Const struct predicate predicate_unify__term__dcode__unify__2 = { unify_term_dcode_module, 0, 2 };
Const struct predicate predicate_unify__term__dcode__unify__functor__4 = { unify_term_dcode_module, 1, 4 };
Const struct predicate predicate_unify__term__dcode__arg__4 = { unify_term_dcode_module, 2, 4 };
extern struct predicate predicate_builtin__add__3;

void *unify_term_dcode_module(glbl, qp, allocp, fg, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  struct goalrec *fg;
  q *allocp;
  Const struct predicate *toppred;
{
  q a0, a1, a2, a3;

  q *reasonp;
 module_top:
  a0 = qp->args[0];
  a1 = qp->args[1];
  switch_on_pred() {
    case_pred(0, unify_2_top);
    case_pred(1, unify_functor_4_top);
    last_case_pred(2, arg_4_top);
  }

 unify_2_top: {
   q x0, x1, x2, x3, x4, x5;
  unify_2_clear_reason:
   reasonp = reasons;
  unify_2_loop:
  unify_2_0:
kl1_trace2("unify_terms");
  again_unify_2_a0:
   switch (ptagof(a0)) {
    case CONS:
     /* a1 is known as cons */
    again_unify_2_cons:
     switch (ptagof(a1)) {
      case CONS:
       qp->pred = &predicate_unify__term__dcode__unify__2;
       qp->args[0] = cdr_of(a0);
       qp->args[1] = cdr_of(a1);
       push_goal();
       a0 = car_of(a0);
       a1 = car_of(a1);
       execute(unify_2_loop);
       goto unify_2_ext_interrupt;
      case ATOMIC:
       goto unify_2_interrupt;
      case VARREF:
       deref_and_jump(a1,again_unify_2_cons);
       unify_value(a1, a0);
       proceed();
      default:
       goto unify_2_interrupt;
     };
    case ATOMIC:
     /* a0 is known as atomic. */
    again_unify_2_atom:
     switch (ptagof(a1)) {
      case CONS:
       goto unify_2_interrupt; /* fail */
      case ATOMIC:
       /* both are already known as atomic */
       if(a0 == a1){
	 proceed();
       }else{
	 goto unify_2_interrupt;
       }
      case VARREF:
       deref_and_jump(a1,again_unify_2_atom);
       unify_value(a1, a0);
       proceed();
      default:
       goto unify_2_interrupt; /* fail */
     };
    case VARREF:
     deref_and_jump(a0,again_unify_2_a0);
    again_unify_2_varref:
     switch (ptagof(a1)) {
      case VARREF:
       deref_and_jump(a1,again_unify_2_varref);
       unify(a0, a1);
       proceed();
      default:
       unify_value(a0, a1);
       proceed();
     }
    default: /* a0 is functor */
/*     gblt_functor(a0,x0,x1,unify_2_interrupt);*/
     x0 = functor_of(a0);
     again_unify_2_default:
     switch (ptagof(a1)) {
      case CONS:
       goto unify_2_interrupt;
      case ATOMIC:
       goto unify_2_interrupt;
      case VARREF:
       deref_and_jump(a1,again_unify_2_default);
       unify_value(a1, a0);
       proceed();
      default:
       /* both are functor */
/*       gblt_functor(a1,x2,x3,unify_2_interrupt);*/
       x2 = functor_of(a1);
       if(x0==x2){
	 goto compare_functors;
       }else{
	 goto unify_2_interrupt;
       }
     }
    compare_functors:
     a2 = a0;
     a3 = a1;
     a1 = makeint(arityof(x0));
     a0 = makeint(0);
     /* unify_functor(0, Size, Func0, Func1) */
     execute(unify_functor_4_loop);
     goto unify_functor_4_ext_interrupt;
   }
   goto unify_2_ext_interrupt;
  unify_2_ext_interrupt:
   reasonp = 0;
  unify_2_interrupt:
   toppred = &predicate_unify__term__dcode__unify__2;
   goto interrupt_2;
 }
  
 unify_functor_4_top: {
   q x0, x1, x2, x3, x4, x5;
   a2 = qp->args[2];
   a3 = qp->args[3];
  unify_functor_4_clear_reason:
   reasonp = reasons;
  unify_functor_4_loop:
  unify_functor_4_0:
   /* a0 and a1 is integer ! Thus no dereference is needed. */
   if(a0!=a1)
     goto unify_functor_4_not_equal;
   proceed();
   
   /*
     unify_functor(A, Size, Func0, Func1) :-
         arg(Func0, A, Elm0, Func00),
	 arg(Func1, A, Elm1, Func01),
	 unify(Elm0, Elm1),
	 A1 := A+1,
	 unify_functor(A1, Size, Func00, Func01). */
  unify_functor_4_not_equal:
   qp->pred = &predicate_unify__term__dcode__unify__functor__4;
   x0 = makeint(intval(a0) + 1);
   qp->args[0] = x0;/* A1 */
   qp->args[1] = a1;/* Size */
/*   x1 = makeref(allocp+1);
   *(allocp+1) = x1;*/
   x1 = makeref(allocp+0);
   *(allocp+0) = x1;
   qp->args[2] = x1;/* Func00 */
/*   x2 = makeref(allocp+2);
   *(allocp+2) = x2; */
   x2 = makeref(allocp+1);
   *(allocp+1) = x2;
   qp->args[3] = x2;/* Func01 */
   push_goal();
/*
   qp->pred = &predicate_builtin__add__3;
   qp->args[0] = a0;
   qp->args[1] = makeint(1);
   qp->args[2] = x0;
*/

/*   push_goal();*/
   qp->pred = &predicate_unify__term__dcode__unify__2;
/*   x3 = makeref(allocp+3);
   *(allocp+3) = x3; */
   x3 = makeref(allocp+2);
   *(allocp+2) = x3;
   qp->args[0] = x3;/* Elm0 */
/*   x4 = makeref(allocp+4);
   *(allocp+4) = x4; */
   x4 = makeref(allocp+3);
   *(allocp+3) = x4;
   qp->args[1] = x4;/* Elm1 */
   push_goal();
   qp->pred = &predicate_unify__term__dcode__arg__4;
   qp->args[0] = a3;/* Func1*/
   qp->args[1] = a0;/* A */
   qp->args[2] = x4;/* Elm1 */
   qp->args[3] = x2;/* Func01 */
   push_goal();
   x5 = a2;/* Func0 */
   a1 = a0;/* A */
   a2 = x3;/* Elm0 */
   a3 = x1;/* Func00 */
   a0 = x5;/* Func0 */
/*   allocp += 5;*/
   allocp += 4;
   execute(arg_4_loop);
   goto arg_4_ext_interrupt;
  unify_functor_4_ext_interrupt:
   reasonp = 0;
  unify_functor_4_interrupt:
   toppred = &predicate_unify__term__dcode__unify__functor__4;
   goto interrupt_4;
 }
  /* arg(func, index, elm, ^func) */
 arg_4_top: {
   q x0, x1, x2, x3, x4, x5;
   a2 = qp->args[2];
   a3 = qp->args[3];
  arg_4_clear_reason:
   reasonp = reasons;
  arg_4_loop:
  arg_4_0:
   switch(ptagof(a0)){
    case CONS:
    case ATOMIC:
     goto arg_4_interrupt;
    case VARREF:
     deref_and_jump(a0, arg_4_0);
     *reasonp++ = a0;
     goto arg_4_interrupt;
    default:
    arg_4_a1_again:
     switch(ptagof(a1)){
      case ATOMIC:
       if(isint(a1)) goto arg_4_commit;
	 else goto arg_4_interrupt;
      case VARREF:
       deref_and_jump(a1, arg_4_a1_again);
       *reasonp++ = a1;
       goto arg_4_interrupt;
      default:
       goto arg_4_interrupt;
     }
    arg_4_commit:
     x0 = arg(a0, intval(a1));
     unify(a2, x0);
     unify(a3, a0);
     proceed();
   }
  arg_4_ext_interrupt:
   reasonp = 0;
  arg_4_interrupt:
   toppred = &predicate_unify__term__dcode__arg__4;
   goto interrupt_4;
 }


/* common routines */
 interrupt_4:
  qp->args[3] = a3;
 interrupt_3:
  qp->args[2] = a2;
 interrupt_2:
  qp->args[1] = a1;
 interrupt_1:
  qp->args[0] = a0;
 interrupt_0:
  qp->pred = toppred;
  qp = interrupt_goal(qp, reasonp);
  goto proceed_after_interrupt;
 proceed_label:
  pop_goal();
 proceed_after_interrupt:
  loop_within_module(unify_term_dcode_module);
}
