/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>

extern char *atomname[];
extern int functors[];
extern int arities[];

/*
  Optimize tail recursive code by D.Sekitq
  */


/* 
  guard

  return value:
  0 : failed
  1 : succeeded
  other : suspended
  */

#define FAILED ((q)0)
#define SUCCEEDED ((q)1)

q eq_terms_body(x,y)
  q x, y;
{
 loop_entry:

  deref_and_switch(x, susp, atomic, cons, funct);
 atomic:
  {
    deref_and_switch(y, asusp, aatomic, acons, afunct);
   aatomic:
    if(x == y)
      return(SUCCEEDED);
    else
      return(FAILED);
   acons:
   afunct:
    return(FAILED);
   asusp:
    return(y);
  }
 cons:
  {
    deref_and_switch(y, csusp, catomic, ccons, cfunct);
   catomic:
   cfunct:
    return(0);
   ccons:
    {
      q retval;
      if((retval = eq_terms_body(car_of(x), car_of(y))) == SUCCEEDED){
	x = cdr_of(x);
	y = cdr_of(y);
	goto loop_entry;
      } else {
	return(retval);
      }
    }
   csusp:
    return(y);
  }

 funct:
  {
    deref_and_switch(y, fsusp, fatomic, fcons, ffunct);
   fatomic:
   fcons:
    return(FAILED);
   ffunct:
    {
      q funcx = functor_of(x);
      q funcy = functor_of(y);
      if(funcx == funcy){
	int functatom = symval(funcx);
	switch(functatom){
	 case functor_VECT:{
	   int arityx = intval(arg(x, 0));
	   int arityy = intval(arg(y, 0));
	   
	   if(arityx == arityy){
	     int i;
	     
	     for(i=1; i<arityx; ++i){
	       q retval;
	       if((retval = eq_terms_body(arg(x, i), arg(y, i))) != SUCCEEDED)
		 return(retval);
	     }
	     
	     x = arg(x, arityx);
	     y = arg(y, arityy);
	     goto loop_entry;
	   } else {
	     return(FAILED);
	   }
	 }
	  
	 default: /* normal functor */
	  {
	    int arity = arityof(functor_of(x));
	    int i;
	    int size = arity - 1;
	    for(i=0; i<size; ++i){
	      q retval;
	      if((retval = eq_terms_body(arg(x, i), arg(y, i))) != SUCCEEDED)
		return(retval);
	    }
	    x = arg(x, size);
	    y = arg(y, size);
	    goto loop_entry;
	  }
	}
	}else{
	  return(FAILED);
	}
      }
   fsusp:
    return(y);
  }
 susp:
  return(x);
}
