/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <stdio.h>
#include <klic/gb.h>

struct goalrec *do_unify_value();
static struct goalrec *resume_goals();
extern struct predicate predicate_unify__term__dcode__unify__2;
#define enqueue_unify_terms(x, y) \
{ \
  struct global_variables *glbl = &globals; \
  qp->pred = &predicate_unify__term__dcode__unify__2; \
  qp->args[0] = x; \
  qp->args[1] = y; \
  push_goal_from_secondary_pool(); \
}

struct goalrec *
do_unify(qp, x, y, allocp)
     struct goalrec *qp;
     q x, y;
     q *allocp;
{
  struct global_variables *glbl = &globals;
  int HeapSize = calcHeapSize();
  q* HeapTop = heaptop;

#ifdef DEBUG
  printf("Unify with ");
  print(x);
  printf(",");
  print(y);
  printf("\n");
#endif
  while (isref(x)) {
    q temp = derefone(x);
    if(x == temp) {
      derefone(x) = y;
      goto finish;
    } else {
      if(!within_heap(x)){
	while(isref(y)){
	  temp = derefone(y);
	  if(y == temp){
	    /* suspension record must points through REF. */
	    derefone(y) = derefone(x);
	    goto finish;
	  }else{
	    if(!within_heap(y)){
	      goto both_queued;
	    }
	  }
	  y = temp;
	}
	/* x is hook variable and y points a real object */
	return(resume_goals(qp, x, y, allocp));
      }
      x = temp;
    }
  }

  /* x is a real object */
  while(isref(y)){
    q temp = derefone(y);
    if(temp == y){ /* y is undef cell */
      derefone(y) = x;
      goto finish;
    }else{
      if(!within_heap(y)) {
	return(resume_goals(qp, y, x, allocp));
      }
    }
    y = temp;
  }

  /* x and y points a real object */
  enqueue_unify_terms(x, y);
  goto finish;

 both_queued:
  /* When both x and y are complicated */
  /*   simply push unification goal */
  {
    struct global_variables *glbl = &globals;
    
    /* insert the goals connected y to x */
    {
      struct susprec *sx = (struct susprec *)x;
      struct susprec *sy = (struct susprec *)y;
      q *topx = (q*)getnexthook(sx);
      q *topy = (q*)getnexthook(sy);
      q *lastx = (q*)getprevhook(sx);
      q *lasty = (q*)getprevhook(sy);

#ifdef DEBUG
      void dump_suspension_structure();
#endif

#ifdef DEBUG
      printf("\nUnification between %x and %x\n", topx, topy);
      dump_suspension_structure(topx);
      dump_suspension_structure(topy);
#endif

      /* connect sx and topy */
      setnexthook(sx, (struct shook *)topy);
      if(ismhook(topy)) {
	setbackhook((struct mhook *)topy, sx);
      }
      /* connext last and topx */
      setnexthook((struct shook *)lasty, (struct shook *)topx);
      if(ismhook(topx)){
	setbackhook((struct mhook *)topx, (struct shook *)lasty);
      }
      derefone(sy->marker) = derefone(sx);
    }
  }
 finish:
  heapp = allocp;
  return qp;
}

/*
  do_unify_value(qp, x, y)
	"do_unify" for when "y" is known to be instantiated.
*/
struct goalrec *
do_unify_value(qp, x, y, allocp)
     struct goalrec *qp;
     q x, y;
     q *allocp;
{
  struct global_variables *glbl = &globals;
  int HeapSize = calcHeapSize();
  q* HeapTop = heaptop;

  while (isref(x)) {
    q temp = derefone(x);
    if (x == temp) {
      derefone(x) = y;
      goto finish;
    }else{
      if(!within_heap(x)) {
	return(resume_goals(qp, x, y, allocp));
      }
    }
    x = temp;
  }
 finish:
  heapp = allocp;
  return qp;
}

/*
  resume the goals which has been hooked to variable `x'.
  by the unification with `y'
*/

static struct goalrec *
resume_goals(qp, x, y, allocp)
     struct goalrec *qp;
     q x;
     q y;
     q *allocp;
{
  struct global_variables *glbl = &globals;
  int HeapSize = calcHeapSize();
  q* HeapTop = heaptop;

  /* Variable x with suspended goals is instantiated here */

  /* x points suspension record directly. */

  struct susprec *susprecord = suspp(x);
  q *top = getnexthook(susprecord);
  q *loopp = top;
#ifdef DEBUG
  void dump_suspension_structure();
#endif

#ifdef DEBUG
  printf("\nResume with "); print(y); putchar('\n');
  dump_suspension_structure(top);
#endif
  
  do{
    q *keepnext = (q*)getnexthook(loopp);
    switch(hooktag(loopp)){
     case SSUSP:{
       struct shook *s = shookp(loopp);
       struct goalrec *g = s->goals;
       g->next = qp->next;
       qp->next = g;
       collectshook(s);
#ifdef CSUSPS
       {
	 struct global_variables *glbl = &globals;
	 suspensions--;
       }
#endif
#ifdef TRACE
       {
	 extern int trace_flag;
	 if (trace_flag) {
	   trace_resumption(g);
	 }
       }
#endif
     }
      break;
     case MSUSP:
      {
	struct mhook *m = mhookp(loopp);
	struct goalrec *g = m->goals;
	struct mhook *n;
	struct mhook *nextrecord;
	/* cancel naighbors */
	for(n = m->pal;
	    n != m;
	    n = nextrecord){
	  q *next = getnexthook(n);
	  q *back = getprevhook(n);

	  nextrecord = n->pal;

	  if(next != back) {
	    setnexthook((struct shook *)back, (struct shook *)next);
	    if(ismhook(next)) {
	      setbackhook((struct mhook *)next, (struct shook *)back);
	    }
	  }else{
	    /* back pointer points a suspension record and
	     suspensing record is just me ! so REF must becom UNDEF. */
	    struct susprec *s = (struct susprec *)next;
	    q ref = s->marker;
	    derefone(ref) = makeref(ref);
	    collectsusprec(s);
	  }
	  collectmhook(n);
	}
	/* enqueue goal */
	g->next = qp->next;
	qp->next = g;
	collectmhook(m);
#ifdef CSUSPS
	{
	  struct global_variables *glbl = &globals;
	  suspensions--;
	}
#endif
#ifdef TRACE
	{
	  extern int trace_flag;
	  if (trace_flag) {
	    trace_resumption(g);
	  }
	}
#endif
      }
      break;
     default: /* merger */
      /* this case, y must not a variable.
	 And do ALL UNIFICATIONS for the input data. */
      {
	q v = y;
	struct merger *m = mergerp(loopp);
	struct merger_common *c = m->common;
       again:
	switch(ptagof(v)){
	 case VARREF:
	  {
	    q tmp = derefone(v);
	    if(tmp == v){
	      struct susprec *s;
	      makesusprec(s);
	      initsusprec(s, v, m);
	      derefone(v) = makeref(s);
	      break;
	    } else if(!within_heap(v)) {
	      /* merge two suspension structure */
	      struct susprec *s = suspp(v);
	      q* hook = getnexthook(s);
	      setnexthook(m, (struct shook *)hook);
	      if(ismhook(hook)) {
		setbackhook((struct mhook *)hook, (struct shook *)m);
	      }
	      setnexthook(s, m);
	      break;
	    } else {
	      v = tmp;
	      goto again;
	    }
	  }
	 case CONS:
	  {
	    q cdr = cdr_of(v);
	    q car = car_of(v);
	    q outcdr;
	    q cons;

	    outcdr = *(allocp+0) = makeref(allocp+0);
	    *(allocp+1) = car;
	    cons = makecons(allocp);
	    allocp += 2;
	    qp = do_unify(qp, c->variable, cons, allocp);
	    c->variable = outcdr;
	    v = cdr;
	    goto again;
	  }
	  break;
	 case ATOMIC:
	  if(v == NILATOM){
	    if(--(c->counter) == 0){
	      do_unify(qp, c->variable, NILATOM, allocp);
	      collectmergercommon(c);
	      collectmerger(m);
	    }
	  }else{
	    fatal("unified with merger input with atom\n");
	  }
	  break;
	 default: /* structure */
	  {
	    q f = functor_of(v);
	    if(f == makesym(functor_VECT)){
	      int size = intval(arg(v, 0));
	      int i;

	      c->counter += (size - 1);

	      for(i=1; i<=size; ++i){
		struct susprec *s;
		struct merger *m;
		q *tmp;
		makesusprec(s);
		makemerger(m, s);
		m->common = c;
		tmp = allocp++;
		initsusprec(s, tmp, m);
		qp = do_unify(qp, tmp, arg(v, i), allocp);
	      }
	    } else {
	      fatal("unified with merger input with functor\n");
	    }
	  }
	}
      }
    }
    loopp = keepnext;
  }while(loopp != (q*)susprecord);

  derefone(susprecord->marker) = y;
  collectsusprec(susprecord);

  heapp = allocp;
  return qp;
}

#ifdef DEBUG
#define dumpgoal(g) \
{ \
  if(g){ \
    printf("\tgoal:\t"); \
    printf("%x:%d/%d\n", g->pred->func, g->pred->pred, g->pred->arity); \
  } else { \
    printf("Illegal goal !: %x\n", g); \
  } \
}

void
dump_suspension_structure(x)
q *x;
{
  q *i = x;
  printf("Dump suspension structure : %x\n", x);
  do{
    switch(ptagof(*i)){
     case SSUSP:
      {
	struct shook *s = shookp(i);
	struct goalrec *g = s->goals;
	printf("Single suspension record : %x\n", s);
	dumpgoal(g);
      }
      break;
     case MSUSP:
      {
	struct mhook *m = mhookp(i);
	struct goalrec *g = m->goals;
	printf("Multiple suspension record : %x\n", m);
	dumpgoal(g);
	printf("back pointer:\t"); printf("%x\n", m->back);
	printf("related record:\t%x\n", m->next);
      }
      break;
     default:
      printf("Merger\n");
    }
    i = (q*)getnexthook(i);
  }while(getnexthook(i) != x);
}
#endif
