/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define MAIN

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/options.h>
#include <klic/timing.h>

#include <stdio.h>
#include <setjmp.h>

extern void exit();

jmp_buf topmost;

void *topsucceed();
void *top_module();

#ifdef TRACE
extern Const struct predicate trace_trigger_preds[];
#endif
extern Const struct predicate predicate_top__top__0;
Const struct predicate topsucceed_pred = { topsucceed, 0, 0 };

char *optarg;

int
parse_size(str)
     char *str;
{
  int n;
  char c[2];
  switch (sscanf(str, "%d%1s", &n, c)) {
  case 1: return n;
  case 2:
    if (c[0] == 'k' || c[0] == 'K') {
      return n*0x400;
    } else if (c[0] == 'm' || c[0] == 'M') {
      return n*0x100000;
    } else if (c[0] == 'g' || c[0] == 'G') {
      return n*0x40000000;
    }
  default:
    fprintf(stderr, "Error in option \"%s\"\n", str);
    exit(2);
  }
}

void main(argc, argv)
     int argc;
     char **argv;
{
  struct global_variables *glbl = &globals;
  q *reasonp = reasons;
#ifdef TRACE
  extern char *program_name;
  program_name = argv[0];
#endif

  heapsize = HEAPSIZE;
  incrementsize = INCREMENTSIZE;
  goalbulk = GOALALLOCBULK;

  {
    char *optarg;
    register_options(argc, argv);
    if (optarg = lookup_option("h"))
      heapsize = parse_size(optarg);
    if (optarg = lookup_option("b"))
      goalbulk = parse_size(optarg);
    if (optarg = lookup_option("g"))
      measure_gc = 1;
    if (optarg = lookup_option("i"))
      incrementsize = parse_size(optarg);
    if (optarg = lookup_option("?")) {
      fprintf(stderr,
	      "Usage: %s h=heapwords b=goalbulk g i=incrementsize\n",
	      argv[0]);
      (void) exit(2);
    }
  }

  initalloc();
  queue = freegoals;
  freegoals = freegoals->next;
  queue->next = 0;
#ifdef SSUSPS /* count suspensions */
  suspensions = 0;
#endif

  if (!setjmp(topmost)) {
    q *allocp = heapp;
    struct goalrec *qp = queue, *fg = freegoals;
    qp->pred = &topsucceed_pred;
    push_goal();
#ifdef TRACE
    initiate_trace();
    qp->pred = &trace_trigger_preds[0];
    qp->args[0] = makeatomic(&predicate_top__top__0);
#else
    qp->pred = &predicate_top__top__0;
#endif
    queue = qp;
    freegoals = fg;
    heapp = allocp+1;
    toploop();
  }
#ifdef CSUSPS
  if(suspensions)
    printf("!!! %d suspending goal(s)", suspensions);
#endif
  exit(0);
}

toploop()
{
  struct global_variables *glbl = &globals;
  struct goalrec *qp = queue;
  Const struct predicate *toppred = qp->pred;
  module func = toppred->func;
  while (1) {
    func = (module) func(glbl, qp, heapp, freegoals, toppred);
    qp = queue;
    toppred = qp->pred;
  }
}

void *topsucceed(glbl, qp, allocp, fg, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     struct goalrec *fg;
     q *allocp;
     Const struct predicate *toppred;
{
  longjmp(topmost, 0);
}
