/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/timing.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>
#include <signal.h>
#include <stdio.h>


q *newsp;

int copying_below = 1;

q *gc(qp, fg, allocp)
     struct goalrec *qp, *fg;
     q *allocp;
{
  struct global_variables *glbl = &globals;
  timerstruct before, after;
#ifdef TRACE
  extern int trace_flag;
  extern struct goalrec *trace_after();
  if (trace_flag) {
    qp = trace_after(qp, allocp);
  } else {
    heapp = allocp;
  }
  if (heapp >= heaplimit) {
#endif
#ifdef GCDEBUG
    printf("before GC\n");
    dump_queue(qp);
#endif
    if (measure_gc) measure(before);
    if (copying_below) {
      newsp = heapend;
    } else {
      newsp = newsp - (heapsize + incrementsize);
    }
    heapp = newsp;
    heaplimit = newsp+heapsize;
    heapend = heapbottom = heaplimit+incrementsize;
    collect_garbage(qp);
#ifdef GCDEBUG
    printf("heaplimit : %x\nheapp : %x\n", heaplimit, heapp);
#endif
    if (heaplimit < heapp) {
      printf("Not enough space collected\n");
      kill(0, SIGUSR1);
    }
    copying_below ^= 1;
    gctimes++;
    if (measure_gc) {
      measure(after);
#ifdef SYSV
      gcums += (int) tick2msec(diff(tms_utime));
      gcsms += (int) tick2msec(diff(tms_stime));
#else SYSV
      gcums += diff_usec(ru_utime)/1000;
      gcsms += diff_usec(ru_stime)/1000;
#endif SYSV
    }
#ifdef GCDEBUG
    printf("after GC\n");
    dump_queue(qp);
#endif
#ifdef TRACE
  }
#endif
  freegoals = fg;
  queue = qp;
  return heapp;
}

Volatile
nofunctor()
{
  fatal("functor not implemented yet");
}

collect_garbage(qp)
     struct goalrec *qp;
{
  struct global_variables *glbl = &globals;
  q *hp = heapp;
  q *copystart = hp;

  int HeapSize = calcHeapSize();
  q* HeapTop = heaptop;

  /* First, copy the contents goal stacks to the new area */
    
  while (qp != 0) {
    int k;
    int n = qp->pred->arity;
    q *argbase = qp->args;
    int start = 0;
    
    while (n > 0) {
      int end;
      int j;
      if (n <= NUMGOALARGS) {
	end = start + n;
      } else {
	end = NUMGOALARGS - 1;
      }
      for (j = start; j < end; j++) {
	q a = argbase[j];
	switch (ptagof(a)) {
	 case VARREF:
	  {
	    q v = derefone(a);
	    q marker;
	    if (v == a) {
	      *hp = argbase[j] = derefone(a) = makeref(hp);
	      hp++;
	    } else if (!within_heap(a)){
	      argbase[j] = makeref(hp);
	      *hp++ = derefone(a);
	    } else {
	      argbase[j] = makeref(hp);
	      *hp++ = a;
	    }
	  }
	  break;
	 case ATOMIC:
	  break;
	 case CONS:
	  *hp = cdr_of(a);
	  *(hp+1) = car_of(a);
	  argbase[j] = makecons(hp);
	  hp += 2;
	  break;
	  /* case FUNCTOR: */
	 default:
	  {
	    q f = functor_of(a);
	    int l, size;
	    argbase[j] = makefunctor(hp);
	    *hp++ = f;
	    switch((unsigned int)f){
	     case (makesym(functor_VECT)):
	       size = intval(*hp++ =  arg(a,0));
	       for (l=1; l <= size; l++){
		 *hp++ = arg(a,l);
	       }
	       break;
	      case (makesym(functor_STRG)):
		size = (intval(*hp++ = arg(a,0)) + 3)/4;
	       for(l=1; l<=size; l++){
		 *hp++ = arg(a,l);
	       }
	       break;
	      default:
	       size = arityof(f);
	       for (l=0; l < size; l++){
		 *hp++ = arg(a,l);
	       }
	     }
	  }
	  break;
	}
      }
      n -= (end-start);
      start = -2;
      argbase = ((struct goalrec *)argbase[end])->args;
    }
    qp = qp->next;
  }
  heapp = hp;

  if (copying_below) {
    copy_indirect_below(copystart);
  } else {
    copy_indirect_above(copystart);
  }
}

#define half_of_heap_size (heapsize + incrementsize)

#define within_new_space(x)\
((unsigned int)((char *)(x) - (char *)heapboundary) < half_heap_size)
#define within_old_space(x)\
((unsigned int)((char *)(x) - (char *)top_of_heap) < half_heap_size)
#define space_boundary	newsp

copy_indirect_below(copystart)
     q *copystart;
#include <klic/copier_body.h>

#undef within_new_space
#undef within_old_space
#undef space_boundary
#define within_new_space(x)\
((unsigned int)((char *)(x) - (char *)top_of_heap) < half_heap_size)
#define within_old_space(x)\
((unsigned int)((char *)(x) - (char *)heapboundary) < half_heap_size)
#define space_boundary (newsp+heapsize+incrementsize)

copy_indirect_above(copystart)
     q *copystart;
#include <klic/copier_body2.h>
