/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>

extern struct predicate topsucceed_pred;

fatal(message)
     char *message;
{
  fprintf(stderr, "Fatal Error: %s\n", message);
  exit(1);
}

dump_queue(qp)
     struct goalrec *qp;
{
  struct global_variables *glbl = &globals;

  while (qp->pred != &topsucceed_pred) {
    int k;
/*    fprintf(stderr, "module %x pred %d/%d\n",*/
    fprintf(stdout, "module %x pred %d/%d\n",
	    qp->pred->func, qp->pred->pred, qp->pred->arity);
    for (k=0; k<qp->pred->arity; k++) {
/*      fprintf(stderr, "  arg %d = ", k);*/
      fprintf(stdout, "  arg %d = ", k);
      print(qp->args[k]);
/*      fprintf(stderr, "\n");*/
      fprintf(stdout, "\n");
    }
    qp = qp->next;
  }
}
