/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
/* #include "arith.h" */
#include <klic/gb.h>
/* #include "bb.h" */

void *builtins_module();
Const struct predicate predicate_builtins__vector__3 = { builtins_module, 0, 3 };
Const struct predicate predicate_builtins__string__4 = { builtins_module, 1, 4 };
Const struct predicate predicate_builtins__add__3 = { builtins_module, 2, 3 };
Const struct predicate predicate_builtins__subtract__3 = { builtins_module, 3, 3 };
Const struct predicate predicate_builtins__multiply__3 = { builtins_module, 4, 3 };
Const struct predicate predicate_builtins__divide__3 = { builtins_module, 5, 3 };
Const struct predicate predicate_builtins__modulo__3 = { builtins_module, 6, 3 };
Const struct predicate predicate_builtins__and__3 = { builtins_module, 7, 3 };
Const struct predicate predicate_builtins__or__3 = { builtins_module, 8, 3 };
Const struct predicate predicate_builtins__exclusive__or__3 = { builtins_module, 9, 3 };
Const struct predicate predicate_builtins__complement__2 = { builtins_module, 10, 2 };
Const struct predicate predicate_builtins__vector__element__4 = { builtins_module, 11, 4 };
Const struct predicate predicate_builtins__string__element__4 = { builtins_module, 12, 4 };
Const struct predicate predicate_builtins__set__string__element__4 = { builtins_module, 13, 4 };
Const struct predicate predicate_builtins__set__vector__element__5 = { builtins_module, 14, 5 };
Const struct predicate predicate_builtins__new__vector__2 = { builtins_module, 15, 2 };
Const struct predicate predicate_builtins__new__string__3 = { builtins_module, 16, 3 };
Const struct predicate predicate_builtins__merge__2 = { builtins_module, 17, 2 };
Const struct predicate predicate_builtins__merge__3 = { builtins_module, 18, 3 };
Const struct predicate predicate_builtins__merge__vector__5 = { builtins_module, 19, 5 };
Const struct predicate predicate_builtins__right__shift__3 = { builtins_module, 20, 3 };
Const struct predicate predicate_builtins__left__shift__3 = { builtins_module, 21, 3 };

void *builtins_module(glbl, qp, allocp, fg, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  struct goalrec *fg;
  q *allocp;
  Const struct predicate *toppred;
{
  q a0, a1, a2, a3, a4;

  q *reasonp;
 module_top:
  a0 = qp->args[0];
  a1 = qp->args[1];
  switch_on_pred() {
    case_pred(0, vector_3_top);
    case_pred(1, string_4_top);
    case_pred(2, add_3_top);
    case_pred(3, subtract_3_top);
    case_pred(4, multiply_3_top);
    case_pred(5, divide_3_top);
    case_pred(6, modulo_3_top);
    case_pred(7, and_3_top);
    case_pred(8, or_3_top);
    case_pred(9, exclusive_or_3_top);
    case_pred(10, complement_2_top);
    case_pred(11, vector_element_4_top);
    case_pred(12, string_element_4_top);
    case_pred(13, set_string_element_4_top);
    case_pred(14, set_vector_element_5_top);
    case_pred(15, new_vector_2_top);
    case_pred(16, new_string_3_top);
    case_pred(17, merge_2_top);
    case_pred(18, merge_3_top);
    case_pred(19, merge_vector_5_top);
    case_pred(20, right_shift_3_top);
    last_case_pred(21, left_shift_3_top);
  }

 vector_3_top: {
  q x0;
  a2 = qp->args[2];
 vector_3_clear_reason:
  reasonp = reasons;
 vector_3_loop:
 vector_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto vector_3_1;
 case ATOMIC:
  goto vector_3_1;
 case VARREF:
  deref_and_jump(a0,vector_3_0);
  *reasonp++ =  a0;
  goto vector_3_2;
 default:
  goto vector_3_3;
 vector_3_3:
  gblt_vector(a0,x0,vector_3_1);
kl1_trace2("vector")
  unify(a1, x0);
  unify(a0, a2);
  proceed();
 vector_3_4:
  goto vector_3_1;
  };
 vector_3_1:
  goto vector_3_2;
 vector_3_2:
  goto vector_3_interrupt;
 vector_3_ext_interrupt:
  reasonp = 0;
 vector_3_interrupt:
  goto interrupt_3;
 }

 string_4_top: {
  q x0, x1;
  a2 = qp->args[2];
  a3 = qp->args[3];
 string_4_clear_reason:
  reasonp = reasons;
 string_4_loop:
 string_4_0:
  switch (ptagof(a0)) {
 case CONS:
  goto string_4_1;
 case ATOMIC:
  goto string_4_1;
 case VARREF:
  deref_and_jump(a0,string_4_0);
  *reasonp++ =  a0;
  goto string_4_2;
 default:
  goto string_4_3;
 string_4_3:
  gblt_string(a0,x0,x1,string_4_1);
kl1_trace3("string")
  unify(a1, x0);
  unify(a2, x1);
  unify(a0, a3);
  proceed();
 string_4_4:
  goto string_4_1;
  };
 string_4_1:
  goto string_4_2;
 string_4_2:
  goto string_4_interrupt;
 string_4_ext_interrupt:
  reasonp = 0;
 string_4_interrupt:
  goto interrupt_4;
 }

 add_3_top: {
  q x0;
  a2 = qp->args[2];
 add_3_clear_reason:
  reasonp = reasons;
 add_3_loop:
 add_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto add_3_1;
 case ATOMIC:
  goto add_3_3;
 add_3_3:
  gblt_atom(a0,add_3_1);
 add_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto add_3_6;
 case ATOMIC:
  goto add_3_8;
 add_3_8:
  gblt_atom(a1,add_3_6);
  gblt_add(a0,a1,x0,add_3_9);
kl1_trace3("add")
  unify(a2, x0);
  proceed();
 add_3_10:
  goto add_3_9;
 add_3_9:
  goto add_3_6;
 case VARREF:
  deref_and_jump(a1,add_3_5);
  *reasonp++ =  a1;
  goto add_3_7;
 default:
  goto add_3_6;
  };
 add_3_6:
  goto add_3_7;
 add_3_7:
  goto add_3_4;
 add_3_4:
  goto add_3_1;
 case VARREF:
  deref_and_jump(a0,add_3_0);
  *reasonp++ =  a0;
  goto add_3_2;
 default:
  goto add_3_1;
  };
 add_3_1:
  goto add_3_2;
 add_3_2:
  goto add_3_interrupt;
 add_3_ext_interrupt:
  reasonp = 0;
 add_3_interrupt:
  goto interrupt_3;
 }

 subtract_3_top: {
  q x0;
  a2 = qp->args[2];
 subtract_3_clear_reason:
  reasonp = reasons;
 subtract_3_loop:
 subtract_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto subtract_3_1;
 case ATOMIC:
  goto subtract_3_3;
 subtract_3_3:
  gblt_atom(a0,subtract_3_1);
 subtract_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto subtract_3_6;
 case ATOMIC:
  goto subtract_3_8;
 subtract_3_8:
  gblt_atom(a1,subtract_3_6);
  gblt_subtract(a0,a1,x0,subtract_3_9);
kl1_trace3("subtract")
  unify(a2, x0);
  proceed();
 subtract_3_10:
  goto subtract_3_9;
 subtract_3_9:
  goto subtract_3_6;
 case VARREF:
  deref_and_jump(a1,subtract_3_5);
  *reasonp++ =  a1;
  goto subtract_3_7;
 default:
  goto subtract_3_6;
  };
 subtract_3_6:
  goto subtract_3_7;
 subtract_3_7:
  goto subtract_3_4;
 subtract_3_4:
  goto subtract_3_1;
 case VARREF:
  deref_and_jump(a0,subtract_3_0);
  *reasonp++ =  a0;
  goto subtract_3_2;
 default:
  goto subtract_3_1;
  };
 subtract_3_1:
  goto subtract_3_2;
 subtract_3_2:
  goto subtract_3_interrupt;
 subtract_3_ext_interrupt:
  reasonp = 0;
 subtract_3_interrupt:
  goto interrupt_3;
 }

 multiply_3_top: {
  q x0;
  a2 = qp->args[2];
 multiply_3_clear_reason:
  reasonp = reasons;
 multiply_3_loop:
 multiply_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto multiply_3_1;
 case ATOMIC:
  goto multiply_3_3;
 multiply_3_3:
  gblt_atom(a0,multiply_3_1);
 multiply_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto multiply_3_6;
 case ATOMIC:
  goto multiply_3_8;
 multiply_3_8:
  gblt_atom(a1,multiply_3_6);
  gblt_multiply(a0,a1,x0,multiply_3_9);
kl1_trace3("multiply")
  unify(a2, x0);
  proceed();
 multiply_3_10:
  goto multiply_3_9;
 multiply_3_9:
  goto multiply_3_6;
 case VARREF:
  deref_and_jump(a1,multiply_3_5);
  *reasonp++ =  a1;
  goto multiply_3_7;
 default:
  goto multiply_3_6;
  };
 multiply_3_6:
  goto multiply_3_7;
 multiply_3_7:
  goto multiply_3_4;
 multiply_3_4:
  goto multiply_3_1;
 case VARREF:
  deref_and_jump(a0,multiply_3_0);
  *reasonp++ =  a0;
  goto multiply_3_2;
 default:
  goto multiply_3_1;
  };
 multiply_3_1:
  goto multiply_3_2;
 multiply_3_2:
  goto multiply_3_interrupt;
 multiply_3_ext_interrupt:
  reasonp = 0;
 multiply_3_interrupt:
  goto interrupt_3;
 }

 divide_3_top: {
  q x0;
  a2 = qp->args[2];
 divide_3_clear_reason:
  reasonp = reasons;
 divide_3_loop:
 divide_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto divide_3_1;
 case ATOMIC:
  goto divide_3_3;
 divide_3_3:
  gblt_atom(a0,divide_3_1);
 divide_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto divide_3_6;
 case ATOMIC:
  goto divide_3_8;
 divide_3_8:
  gblt_atom(a1,divide_3_6);
  gblt_divide(a0,a1,x0,divide_3_9);
kl1_trace3("divide")
  unify(a2, x0);
  proceed();
 divide_3_10:
  goto divide_3_9;
 divide_3_9:
  goto divide_3_6;
 case VARREF:
  deref_and_jump(a1,divide_3_5);
  *reasonp++ =  a1;
  goto divide_3_7;
 default:
  goto divide_3_6;
  };
 divide_3_6:
  goto divide_3_7;
 divide_3_7:
  goto divide_3_4;
 divide_3_4:
  goto divide_3_1;
 case VARREF:
  deref_and_jump(a0,divide_3_0);
  *reasonp++ =  a0;
  goto divide_3_2;
 default:
  goto divide_3_1;
  };
 divide_3_1:
  goto divide_3_2;
 divide_3_2:
  goto divide_3_interrupt;
 divide_3_ext_interrupt:
  reasonp = 0;
 divide_3_interrupt:
  goto interrupt_3;
 }

 modulo_3_top: {
  q x0;
  a2 = qp->args[2];
 modulo_3_clear_reason:
  reasonp = reasons;
 modulo_3_loop:
 modulo_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto modulo_3_1;
 case ATOMIC:
  goto modulo_3_3;
 modulo_3_3:
  gblt_atom(a0,modulo_3_1);
 modulo_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto modulo_3_6;
 case ATOMIC:
  goto modulo_3_8;
 modulo_3_8:
  gblt_atom(a1,modulo_3_6);
  gblt_modulo(a0,a1,x0,modulo_3_9);
kl1_trace3("modulo")
  unify(a2, x0);
  proceed();
 modulo_3_10:
  goto modulo_3_9;
 modulo_3_9:
  goto modulo_3_6;
 case VARREF:
  deref_and_jump(a1,modulo_3_5);
  *reasonp++ =  a1;
  goto modulo_3_7;
 default:
  goto modulo_3_6;
  };
 modulo_3_6:
  goto modulo_3_7;
 modulo_3_7:
  goto modulo_3_4;
 modulo_3_4:
  goto modulo_3_1;
 case VARREF:
  deref_and_jump(a0,modulo_3_0);
  *reasonp++ =  a0;
  goto modulo_3_2;
 default:
  goto modulo_3_1;
  };
 modulo_3_1:
  goto modulo_3_2;
 modulo_3_2:
  goto modulo_3_interrupt;
 modulo_3_ext_interrupt:
  reasonp = 0;
 modulo_3_interrupt:
  goto interrupt_3;
 }

 and_3_top: {
  q x0;
  a2 = qp->args[2];
 and_3_clear_reason:
  reasonp = reasons;
 and_3_loop:
 and_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto and_3_1;
 case ATOMIC:
  goto and_3_3;
 and_3_3:
  gblt_atom(a0,and_3_1);
 and_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto and_3_6;
 case ATOMIC:
  goto and_3_8;
 and_3_8:
  gblt_atom(a1,and_3_6);
  gblt_and(a0,a1,x0,and_3_9);
kl1_trace3("and")
  unify(a2, x0);
  proceed();
 and_3_10:
  goto and_3_9;
 and_3_9:
  goto and_3_6;
 case VARREF:
  deref_and_jump(a1,and_3_5);
  *reasonp++ =  a1;
  goto and_3_7;
 default:
  goto and_3_6;
  };
 and_3_6:
  goto and_3_7;
 and_3_7:
  goto and_3_4;
 and_3_4:
  goto and_3_1;
 case VARREF:
  deref_and_jump(a0,and_3_0);
  *reasonp++ =  a0;
  goto and_3_2;
 default:
  goto and_3_1;
  };
 and_3_1:
  goto and_3_2;
 and_3_2:
  goto and_3_interrupt;
 and_3_ext_interrupt:
  reasonp = 0;
 and_3_interrupt:
  goto interrupt_3;
 }

 or_3_top: {
  q x0;
  a2 = qp->args[2];
 or_3_clear_reason:
  reasonp = reasons;
 or_3_loop:
 or_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto or_3_1;
 case ATOMIC:
  goto or_3_3;
 or_3_3:
  gblt_atom(a0,or_3_1);
 or_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto or_3_6;
 case ATOMIC:
  goto or_3_8;
 or_3_8:
  gblt_atom(a1,or_3_6);
  gblt_or(a0,a1,x0,or_3_9);
kl1_trace3("or")
  unify(a2, x0);
  proceed();
 or_3_10:
  goto or_3_9;
 or_3_9:
  goto or_3_6;
 case VARREF:
  deref_and_jump(a1,or_3_5);
  *reasonp++ =  a1;
  goto or_3_7;
 default:
  goto or_3_6;
  };
 or_3_6:
  goto or_3_7;
 or_3_7:
  goto or_3_4;
 or_3_4:
  goto or_3_1;
 case VARREF:
  deref_and_jump(a0,or_3_0);
  *reasonp++ =  a0;
  goto or_3_2;
 default:
  goto or_3_1;
  };
 or_3_1:
  goto or_3_2;
 or_3_2:
  goto or_3_interrupt;
 or_3_ext_interrupt:
  reasonp = 0;
 or_3_interrupt:
  goto interrupt_3;
 }

 exclusive_or_3_top: {
  q x0;
  a2 = qp->args[2];
 exclusive_or_3_clear_reason:
  reasonp = reasons;
 exclusive_or_3_loop:
 exclusive_or_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto exclusive_or_3_1;
 case ATOMIC:
  goto exclusive_or_3_3;
 exclusive_or_3_3:
  gblt_atom(a0,exclusive_or_3_1);
 exclusive_or_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto exclusive_or_3_6;
 case ATOMIC:
  goto exclusive_or_3_8;
 exclusive_or_3_8:
  gblt_atom(a1,exclusive_or_3_6);
  gblt_exclusive_or(a0,a1,x0,exclusive_or_3_9);
kl1_trace3("exclusive_or")
  unify(a2, x0);
  proceed();
 exclusive_or_3_10:
  goto exclusive_or_3_9;
 exclusive_or_3_9:
  goto exclusive_or_3_6;
 case VARREF:
  deref_and_jump(a1,exclusive_or_3_5);
  *reasonp++ =  a1;
  goto exclusive_or_3_7;
 default:
  goto exclusive_or_3_6;
  };
 exclusive_or_3_6:
  goto exclusive_or_3_7;
 exclusive_or_3_7:
  goto exclusive_or_3_4;
 exclusive_or_3_4:
  goto exclusive_or_3_1;
 case VARREF:
  deref_and_jump(a0,exclusive_or_3_0);
  *reasonp++ =  a0;
  goto exclusive_or_3_2;
 default:
  goto exclusive_or_3_1;
  };
 exclusive_or_3_1:
  goto exclusive_or_3_2;
 exclusive_or_3_2:
  goto exclusive_or_3_interrupt;
 exclusive_or_3_ext_interrupt:
  reasonp = 0;
 exclusive_or_3_interrupt:
  goto interrupt_3;
 }

 complement_2_top: {
  q x0;
 complement_2_clear_reason:
  reasonp = reasons;
 complement_2_loop:
 complement_2_0:
  switch (ptagof(a0)) {
 case CONS:
  goto complement_2_1;
 case ATOMIC:
  goto complement_2_3;
 complement_2_3:
  gblt_atom(a0,complement_2_1);
  gblt_complement(a0,x0,complement_2_4);
kl1_trace2("complement")
  unify(a1, x0);
  proceed();
 complement_2_5:
  goto complement_2_4;
 complement_2_4:
  goto complement_2_1;
 case VARREF:
  deref_and_jump(a0,complement_2_0);
  *reasonp++ =  a0;
  goto complement_2_2;
 default:
  goto complement_2_1;
  };
 complement_2_1:
  goto complement_2_2;
 complement_2_2:
  goto complement_2_interrupt;
 complement_2_ext_interrupt:
  reasonp = 0;
 complement_2_interrupt:
  goto interrupt_2;
 }

 vector_element_4_top: {
  q x0, x1;
  a2 = qp->args[2];
  a3 = qp->args[3];
 vector_element_4_clear_reason:
  reasonp = reasons;
 vector_element_4_loop:
 vector_element_4_0:
  switch (ptagof(a0)) {
 case CONS:
  goto vector_element_4_1;
 case ATOMIC:
  goto vector_element_4_1;
 case VARREF:
  deref_and_jump(a0,vector_element_4_0);
  *reasonp++ =  a0;
  goto vector_element_4_2;
 default:
  goto vector_element_4_3;
 vector_element_4_3:
  gblt_vector(a0,x0,vector_element_4_1);
 vector_element_4_5:
  switch (ptagof(a1)) {
 case CONS:
  goto vector_element_4_6;
 case ATOMIC:
  goto vector_element_4_8;
 vector_element_4_8:
  gblt_less_or_eq(makeint(0),a1,vector_element_4_6);
  gblt_less(a1,x0,vector_element_4_9);
  gblt_vector_element(a0,a1,x1,vector_element_4_10);
kl1_trace3("vector_element")
  unify(a3, a0);
  unify(a2, x1);
  proceed();
 vector_element_4_11:
  goto vector_element_4_10;
 vector_element_4_10:
  goto vector_element_4_9;
 vector_element_4_9:
  goto vector_element_4_6;
 case VARREF:
  deref_and_jump(a1,vector_element_4_5);
  *reasonp++ =  a1;
  goto vector_element_4_7;
 default:
  goto vector_element_4_6;
  };
 vector_element_4_6:
  goto vector_element_4_7;
 vector_element_4_7:
  goto vector_element_4_4;
 vector_element_4_4:
  goto vector_element_4_1;
  };
 vector_element_4_1:
  goto vector_element_4_2;
 vector_element_4_2:
  goto vector_element_4_interrupt;
 vector_element_4_ext_interrupt:
  reasonp = 0;
 vector_element_4_interrupt:
  goto interrupt_4;
 }

 string_element_4_top: {
  q x0, x1, x2;
  a2 = qp->args[2];
  a3 = qp->args[3];
 string_element_4_clear_reason:
  reasonp = reasons;
 string_element_4_loop:
 string_element_4_0:
  switch (ptagof(a0)) {
 case CONS:
  goto string_element_4_1;
 case ATOMIC:
  goto string_element_4_1;
 case VARREF:
  deref_and_jump(a0,string_element_4_0);
  *reasonp++ =  a0;
  goto string_element_4_2;
 default:
  goto string_element_4_3;
 string_element_4_3:
  gblt_string(a0,x0,x1,string_element_4_1);
 string_element_4_5:
  switch (ptagof(a1)) {
 case CONS:
  goto string_element_4_6;
 case ATOMIC:
  goto string_element_4_8;
 string_element_4_8:
  gblt_less_or_eq(makeint(0),a1,string_element_4_6);
  gblt_less(a1,x0,string_element_4_9);
  gblt_string_element(a0,a1,x2,string_element_4_10);
kl1_trace4("string_element")
  unify(a2, x2);
  unify(a3, a0);
  proceed();
 string_element_4_11:
  goto string_element_4_10;
 string_element_4_10:
  goto string_element_4_9;
 string_element_4_9:
  goto string_element_4_6;
 case VARREF:
  deref_and_jump(a1,string_element_4_5);
  *reasonp++ =  a1;
  goto string_element_4_7;
 default:
  goto string_element_4_6;
  };
 string_element_4_6:
  goto string_element_4_7;
 string_element_4_7:
  goto string_element_4_4;
 string_element_4_4:
  goto string_element_4_1;
  };
 string_element_4_1:
  goto string_element_4_2;
 string_element_4_2:
  goto string_element_4_interrupt;
 string_element_4_ext_interrupt:
  reasonp = 0;
 string_element_4_interrupt:
  goto interrupt_4;
 }

 set_string_element_4_top: {
  q x0, x1;
  a2 = qp->args[2];
  a3 = qp->args[3];
 set_string_element_4_clear_reason:
  reasonp = reasons;
 set_string_element_4_loop:
 set_string_element_4_0:
  switch (ptagof(a0)) {
 case CONS:
  goto set_string_element_4_1;
 case ATOMIC:
  goto set_string_element_4_1;
 case VARREF:
  deref_and_jump(a0,set_string_element_4_0);
  *reasonp++ =  a0;
  goto set_string_element_4_2;
 default:
  goto set_string_element_4_3;
 set_string_element_4_3:
  gblt_string(a0,x0,x1,set_string_element_4_1);
 set_string_element_4_5:
  switch (ptagof(a1)) {
 case CONS:
  goto set_string_element_4_6;
 case ATOMIC:
  goto set_string_element_4_8;
 set_string_element_4_8:
  gblt_less_or_eq(makeint(0),a1,set_string_element_4_6);
  gblt_less(a1,x0,set_string_element_4_9);
/* */
  { int w0 = intval(a1),
        w1 = intval(x0), i;
    q   w2 = makefunctor(allocp),
        w3 = makefunctor(allocp+2);

    *allocp = makesym(functor_STRG);
    *(allocp+1) = w3;
    *(allocp+2) = makesym(functor_STRG);
    *(allocp+3) = x0;
    *(allocp+4) = x1;
    for (i = 0; i < w1 ; i++)
      *(allocp+i+5) = arg(a0,i+2);
    arg(w2, w0) = a2;
    allocp += (w1+5);
    unify(a3, w2);}
/* */
kl1_trace4("set_string_element")
  proceed();
 set_string_element_4_10:
  goto set_string_element_4_9;
 set_string_element_4_9:
  goto set_string_element_4_6;
 case VARREF:
  deref_and_jump(a1,set_string_element_4_5);
  *reasonp++ =  a1;
  goto set_string_element_4_7;
 default:
  goto set_string_element_4_6;
  };
 set_string_element_4_6:
  goto set_string_element_4_7;
 set_string_element_4_7:
  goto set_string_element_4_4;
 set_string_element_4_4:
  goto set_string_element_4_1;
  };
 set_string_element_4_1:
  goto set_string_element_4_2;
 set_string_element_4_2:
  goto set_string_element_4_interrupt;
 set_string_element_4_ext_interrupt:
  reasonp = 0;
 set_string_element_4_interrupt:
  goto interrupt_4;
 }

 set_vector_element_5_top: {
  q x0, x1;
  a2 = qp->args[2];
  a3 = qp->args[3];
  a4 = qp->args[4];
 set_vector_element_5_clear_reason:
  reasonp = reasons;
 set_vector_element_5_loop:
 set_vector_element_5_0:
  switch (ptagof(a0)) {
 case CONS:
  goto set_vector_element_5_1;
 case ATOMIC:
  goto set_vector_element_5_1;
 case VARREF:
  deref_and_jump(a0,set_vector_element_5_0);
  *reasonp++ =  a0;
  goto set_vector_element_5_2;
 default:
  goto set_vector_element_5_3;
 set_vector_element_5_3:
  gblt_vector(a0,x0,set_vector_element_5_1);
 set_vector_element_5_5:
  switch (ptagof(a1)) {
 case CONS:
  goto set_vector_element_5_6;
 case ATOMIC:
  goto set_vector_element_5_8;
 set_vector_element_5_8:
  gblt_less_or_eq(makeint(0),a1,set_vector_element_5_6);
  gblt_less(a1,x0,set_vector_element_5_9);
  gblt_vector_element(a0,a1,x1,set_vector_element_5_10);
/* */
  { int w0 = intval(a1),
        w1 = intval(x0), i;
    q   w2 = makefunctor(allocp);
    *allocp = makesym(functor_VECT);
    *(allocp+1) = x0;
    for (i = 0; i < w1; i++)
      *(allocp+i+2) = arg(a0, i+1);
    arg(w2, w0+1) = a3;
    allocp += (w1+2);
    unify(a4, w2);}
/* */
kl1_trace5("set_vector_element")
  unify(a2, x1);
  proceed();
 set_vector_element_5_11:
  goto set_vector_element_5_10;
 set_vector_element_5_10:
  goto set_vector_element_5_9;
 set_vector_element_5_9:
  goto set_vector_element_5_6;
 case VARREF:
  deref_and_jump(a1,set_vector_element_5_5);
  *reasonp++ =  a1;
  goto set_vector_element_5_7;
 default:
  goto set_vector_element_5_6;
  };
 set_vector_element_5_6:
  goto set_vector_element_5_7;
 set_vector_element_5_7:
  goto set_vector_element_5_4;
 set_vector_element_5_4:
  goto set_vector_element_5_1;
  };
 set_vector_element_5_1:
  goto set_vector_element_5_2;
 set_vector_element_5_2:
  goto set_vector_element_5_interrupt;
 set_vector_element_5_ext_interrupt:
  reasonp = 0;
 set_vector_element_5_interrupt:
  goto interrupt_5;
 }

 new_vector_2_top: {
 new_vector_2_clear_reason:
  reasonp = reasons;
 new_vector_2_loop:
 new_vector_2_0:
  switch (ptagof(a1)) {
 case CONS:
  goto new_vector_2_1;
 case ATOMIC:
  goto new_vector_2_3;
 new_vector_2_3:
  gblt_greater_or_eq(a1,makeint(0),new_vector_2_1);
  { int w0 = intval(a1),
        i;
    q   w1,
        w2 = makefunctor(allocp),
        w3 = makefunctor(allocp+2);

    *allocp = makesym(functor_VECT);
    *(allocp+1) = a1;
    for(i = 2; i <= w0+1; i++){
/*     w1 = makeref(allocp+i);
     *(allocp+i) = w1;} */
     *(allocp+i) = makeint(0);}
    unify(a0, w2);
    allocp += (w0+2);}
/* */
kl1_trace2("new_vector")
  proceed();
 new_vector_2_4:
  goto new_vector_2_1;
 case VARREF:
  deref_and_jump(a1,new_vector_2_0);
  *reasonp++ =  a1;
  goto new_vector_2_2;
 default:
  goto new_vector_2_1;
  };
 new_vector_2_1:
  goto new_vector_2_2;
 new_vector_2_2:
  goto new_vector_2_interrupt;
 new_vector_2_ext_interrupt:
  reasonp = 0;
 new_vector_2_interrupt:
  goto interrupt_2;
 }

 new_string_3_top: {
  a2 = qp->args[2];
 new_string_3_clear_reason:
  reasonp = reasons;
 new_string_3_loop:
 new_string_3_0:
  switch (ptagof(a1)) {
 case CONS:
  goto new_string_3_1;
 case ATOMIC:
  goto new_string_3_3;
 new_string_3_3:
  gblt_greater_or_eq(a1,makeint(0),new_string_3_1);
 new_string_3_5:
  switch (ptagof(a2)) {
 case CONS:
  goto new_string_3_6;
 case ATOMIC:
  goto new_string_3_8;
 new_string_3_8:
  gblt_greater(a2,makeint(0),new_string_3_6);
/* */
  { int w0 = intval(a1),
        i;
    q   w1 = makefunctor(allocp),
        w2 = makefunctor(allocp+2);
    *allocp = makesym(functor_STRG);
    *(allocp+1) = w2;
    *(allocp+2) = makesym(functor_STRG);
    *(allocp+3) = a1;
    *(allocp+4) = a2;
    for(i = 5; i <= w0+4; i++){
     *(allocp+i) = makeint(0);}
    unify(a0, w1);
    allocp += (w0+5);}
/* */
kl1_trace3("new_string")
  proceed();
 new_string_3_9:
  goto new_string_3_6;
 case VARREF:
  deref_and_jump(a2,new_string_3_5);
  *reasonp++ =  a2;
  goto new_string_3_7;
 default:
  goto new_string_3_6;
  };
 new_string_3_6:
  goto new_string_3_7;
 new_string_3_7:
  goto new_string_3_4;
 new_string_3_4:
  goto new_string_3_1;
 case VARREF:
  deref_and_jump(a1,new_string_3_0);
  *reasonp++ =  a1;
  goto new_string_3_2;
 default:
  goto new_string_3_1;
  };
 new_string_3_1:
  goto new_string_3_2;
 new_string_3_2:
  goto new_string_3_interrupt;
 new_string_3_ext_interrupt:
  reasonp = 0;
 new_string_3_interrupt:
  goto interrupt_3;
 }

 merge_2_top: {
  q x0, x1, x2;
 merge_2_clear_reason:
  reasonp = reasons;
 merge_2_loop:
 merge_2_0:
  switch (ptagof(a0)) {
 case CONS:
  x1 = makeref(allocp+0+0);
  *(allocp+0+0) = x1;
  *(allocp+0+1) = car_of(a0);
  x0 = makecons(allocp+0);
  unify(a1, x0);
  qp->pred = &predicate_builtins__merge__2;
  qp->args[0] = cdr_of(a0);
  qp->args[1] = x1;
  push_goal();
  allocp += 2;
  proceed();
 case ATOMIC:
  switch ((unsigned int)a0) {
 case NILATOM:
  unify(a1, NILATOM);
  proceed();
 default:
  goto merge_2_1;
  };
 case VARREF:
  deref_and_jump(a0,merge_2_0);
  *reasonp++ =  a0;
  goto merge_2_2;
 default:
  goto merge_2_3;
 merge_2_3:
  gblt_vector(a0,x0,merge_2_1);
  x1 = makeint(0);
  x2 = x0;
  a2 = a0;
  a3 = NILATOM;
  a4 = a1;
  a1 = x2;
  a0 = x1;
  execute(merge_vector_5_loop);
  goto merge_vector_5_ext_interrupt;
 merge_2_4:
  goto merge_2_1;
  };
 merge_2_1:
  goto merge_2_2;
 merge_2_2:
  goto merge_2_interrupt;
 merge_2_ext_interrupt:
  reasonp = 0;
 merge_2_interrupt:
  goto interrupt_2;
 }

 merge_3_top: {
  q x0, x1, x2, x3;
  a2 = qp->args[2];
 merge_3_clear_reason:
  reasonp = reasons;
 merge_3_loop:
 merge_3_0:
  switch (ptagof(a0)) {
 case CONS:
  x1 = makeref(allocp+0+0);
  *(allocp+0+0) = x1;
  *(allocp+0+1) = car_of(a0);
  x0 = makecons(allocp+0);
  unify(a2, x0);
  a0 = cdr_of(a0);
  a1 = a1;
  a2 = x1;
  allocp += 2;
  execute(merge_3_loop);
  goto merge_3_ext_interrupt;
 case ATOMIC:
  switch ((unsigned int)a0) {
 case NILATOM:
  unify(a1, a2);
  proceed();
 default:
  goto merge_3_1;
  };
 case VARREF:
  deref_and_jump(a0,merge_3_0);
  *reasonp++ =  a0;
  goto merge_3_2;
 default:
  goto merge_3_3;
 merge_3_3:
  gblt_vector(a0,x0,merge_3_1);
  x1 = makeint(0);
  x2 = x0;
  x3 = a0;
  a3 = a1;
  a4 = a2;
  a2 = x3;
  a1 = x2;
  a0 = x1;
  execute(merge_vector_5_loop);
  goto merge_vector_5_ext_interrupt;
 merge_3_4:
  goto merge_3_1;
  };
 merge_3_1:
  goto merge_3_2;
 merge_3_2:
 merge_3_5:
  switch (ptagof(a1)) {
 case CONS:
  x1 = makeref(allocp+0+0);
  *(allocp+0+0) = x1;
  *(allocp+0+1) = car_of(a1);
  x0 = makecons(allocp+0);
  unify(a2, x0);
  a0 = a0;
  a1 = cdr_of(a1);
  a2 = x1;
  allocp += 2;
  execute(merge_3_clear_reason);
  goto merge_3_ext_interrupt;
 case ATOMIC:
  switch ((unsigned int)a1) {
 case NILATOM:
  unify(a0, a2);
  proceed();
 default:
  goto merge_3_6;
  };
 case VARREF:
  deref_and_jump(a1,merge_3_5);
  *reasonp++ =  a1;
  goto merge_3_7;
 default:
  goto merge_3_8;
 merge_3_8:
  gblt_vector(a1,x0,merge_3_6);
  x1 = makeint(0);
  x2 = x0;
  x3 = a1;
  a3 = a0;
  a4 = a2;
  a2 = x3;
  a1 = x2;
  a0 = x1;
  execute(merge_vector_5_clear_reason);
  goto merge_vector_5_ext_interrupt;
 merge_3_9:
  goto merge_3_6;
  };
 merge_3_6:
  goto merge_3_7;
 merge_3_7:
  goto merge_3_interrupt;
 merge_3_ext_interrupt:
  reasonp = 0;
 merge_3_interrupt:
  toppred = &predicate_builtins__merge__3;
  goto interrupt_3;
 }

 merge_vector_5_top: {
  q x0, x1, x2;
  a2 = qp->args[2];
  a3 = qp->args[3];
  a4 = qp->args[4];
 merge_vector_5_clear_reason:
  reasonp = reasons;
 merge_vector_5_loop:
 merge_vector_5_0:
  switch (ptagof(a0)) {
 case CONS:
  goto merge_vector_5_1;
 case ATOMIC:
  goto merge_vector_5_1;
 case VARREF:
  deref_and_jump(a0,merge_vector_5_0);
  *reasonp++ =  a0;
  goto merge_vector_5_2;
 default:
  goto merge_vector_5_1;
  };
 merge_vector_5_1:
  if_equal(a0, a1, merge_vector_5_3, merge_vector_5_4, merge_vector_5_5);
 merge_vector_5_3:
  unify(a3, a4);
  proceed();
 merge_vector_5_5:
  *reasonp++ =  a1;
 merge_vector_5_4:
  goto merge_vector_5_2;
 merge_vector_5_2:
 merge_vector_5_6:
  switch (ptagof(a2)) {
 case CONS:
  goto merge_vector_5_7;
 case ATOMIC:
  goto merge_vector_5_7;
 case VARREF:
  deref_and_jump(a2,merge_vector_5_6);
  *reasonp++ =  a2;
  goto merge_vector_5_8;
 default:
  goto merge_vector_5_9;
 merge_vector_5_9:
 merge_vector_5_10:
  switch (ptagof(a0)) {
 case CONS:
  goto merge_vector_5_11;
 case ATOMIC:
  goto merge_vector_5_13;
 merge_vector_5_13:
  gblt_vector_element(a2,a0,x0,merge_vector_5_11);
  gblt_add(a0,makeint(1),x1,merge_vector_5_14);
  qp->pred = &predicate_builtins__merge__vector__5;
  qp->args[0] = x1;
  qp->args[1] = a1;
  qp->args[2] = a2;
  x2 = makeref(allocp+0);
  *(allocp+0) = x2;
  qp->args[3] = x2;
  qp->args[4] = a4;
  push_goal();
  a0 = x0;
  a1 = a3;
  a2 = x2;
  allocp += 1;
  execute(merge_3_clear_reason);
  goto merge_3_ext_interrupt;
 merge_vector_5_15:
  goto merge_vector_5_14;
 merge_vector_5_14:
  goto merge_vector_5_11;
 case VARREF:
  deref_and_jump(a0,merge_vector_5_10);
  *reasonp++ =  a0;
  goto merge_vector_5_12;
 default:
  goto merge_vector_5_11;
  };
 merge_vector_5_11:
  goto merge_vector_5_12;
 merge_vector_5_12:
  goto merge_vector_5_7;
  };
 merge_vector_5_7:
  goto merge_vector_5_8;
 merge_vector_5_8:
  goto merge_vector_5_interrupt;
 merge_vector_5_ext_interrupt:
  reasonp = 0;
 merge_vector_5_interrupt:
  toppred = &predicate_builtins__merge__vector__5;
  goto interrupt_5;
 }

 right_shift_3_top: {
  q x0;
  a2 = qp->args[2];
 right_shift_3_clear_reason:
  reasonp = reasons;
 right_shift_3_loop:
 right_shift_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto right_shift_3_1;
 case ATOMIC:
  goto right_shift_3_3;
 right_shift_3_3:
  gblt_atom(a0,right_shift_3_1);
 right_shift_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto right_shift_3_6;
 case ATOMIC:
  goto right_shift_3_8;
 right_shift_3_8:
  gblt_greater_or_eq(a1,makeint(0),right_shift_3_6);
  gblt_rshift(a0,a1,x0,right_shift_3_9);
kl1_trace3("right_shift")
  unify(a2, x0);
  proceed();
 right_shift_3_10:
  goto right_shift_3_9;
 right_shift_3_9:
  goto right_shift_3_6;
 case VARREF:
  deref_and_jump(a1,right_shift_3_5);
  *reasonp++ =  a1;
  goto right_shift_3_7;
 default:
  goto right_shift_3_6;
  };
 right_shift_3_6:
  goto right_shift_3_7;
 right_shift_3_7:
  goto right_shift_3_4;
 right_shift_3_4:
  goto right_shift_3_1;
 case VARREF:
  deref_and_jump(a0,right_shift_3_0);
  *reasonp++ =  a0;
  goto right_shift_3_2;
 default:
  goto right_shift_3_1;
  };
 right_shift_3_1:
  goto right_shift_3_2;
 right_shift_3_2:
  goto right_shift_3_interrupt;
 right_shift_3_ext_interrupt:
  reasonp = 0;
 right_shift_3_interrupt:
  goto interrupt_3;
 }

 left_shift_3_top: {
  q x0;
  a2 = qp->args[2];
 left_shift_3_clear_reason:
  reasonp = reasons;
 left_shift_3_loop:
 left_shift_3_0:
  switch (ptagof(a0)) {
 case CONS:
  goto left_shift_3_1;
 case ATOMIC:
  goto left_shift_3_3;
 left_shift_3_3:
  gblt_atom(a0,left_shift_3_1);
 left_shift_3_5:
  switch (ptagof(a1)) {
 case CONS:
  goto left_shift_3_6;
 case ATOMIC:
  goto left_shift_3_8;
 left_shift_3_8:
  gblt_greater_or_eq(a1,makeint(0),left_shift_3_6);
  gblt_lshift(a0,a1,x0,left_shift_3_9);
kl1_trace3("left_shift")
  unify(a2, x0);
  proceed();
 left_shift_3_10:
  goto left_shift_3_9;
 left_shift_3_9:
  goto left_shift_3_6;
 case VARREF:
  deref_and_jump(a1,left_shift_3_5);
  *reasonp++ =  a1;
  goto left_shift_3_7;
 default:
  goto left_shift_3_6;
  };
 left_shift_3_6:
  goto left_shift_3_7;
 left_shift_3_7:
  goto left_shift_3_4;
 left_shift_3_4:
  goto left_shift_3_1;
 case VARREF:
  deref_and_jump(a0,left_shift_3_0);
  *reasonp++ =  a0;
  goto left_shift_3_2;
 default:
  goto left_shift_3_1;
  };
 left_shift_3_1:
  goto left_shift_3_2;
 left_shift_3_2:
  goto left_shift_3_interrupt;
 left_shift_3_ext_interrupt:
  reasonp = 0;
 left_shift_3_interrupt:
  goto interrupt_3;
 }

 interrupt_5:
  qp->args[4] = a4;
 interrupt_4:
  qp->args[3] = a3;
 interrupt_3:
  qp->args[2] = a2;
 interrupt_2:
  qp->args[1] = a1;
 interrupt_1:
  qp->args[0] = a0;
 interrupt_0:
  qp->pred = toppred;
  qp = interrupt_goal(qp, reasonp);
  goto proceed_after_interrupt;
 proceed_label:
  pop_goal();
 proceed_after_interrupt:
  loop_within_module(builtins_module);
}
