/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/arith.h>

void *blt_arith();

struct predicate
  add_pred = { blt_arith, 0, 3 },
  subtract_pred = { blt_arith, 1, 3 };

#define bin_arith(func, pred, oprtr)\
q func(x, y)							\
     q x, y;							\
{								\
  struct global_variables *glbl = &globals;			\
  q *reasonp = reasons;						\
  deref(x, interrupt);						\
  deref(y, interrupt);						\
  if (isint(x) && isint(y)) {					\
    return makeint(intval(x) oprtr intval(y));			\
  }								\
  goto interrupt;						\
 interrupt:							\
  {								\
    q z;							\
    revalloc(z, 1, makeref);					\
    derefone(z) = z;						\
    queue = interrupt_goal(queue, reasonp);			\
    return z;							\
  }								\
}

bin_arith(do_add, add_pred, +)
bin_arith(do_subtract, subtract_pred, -)

void *blt_arith(glbl, qp, allocp, fg, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     struct goalrec *fg;
     q *allocp;
     Const struct predicate *toppred;
{
  /* Dummy Definition */
}
