/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>

extern char *malloc();

int initheap()
{
  struct global_variables *glbl = &globals;
  unsigned int hsize = (heapsize + incrementsize) * 2 * sizeof(q);
  heaptop = (q *)malloc(hsize);
  heapp = heaptop;
  heaplimit = heapp + heapsize;
  heapend = heapbottom = heaplimit+incrementsize;
  totalheapsize = hsize;
}

struct goalrec *
more_goal_records(glbl)
     struct global_variables *glbl;
{
  int k;
  char *block = malloc(goalbulk*sizeof(struct goalrec));
  struct goalrec *recs =
    (struct goalrec *) ((unsigned int)block);
  for (k=0; k<goalbulk; k++) {
    recs[k].next = &recs[k+1];
  }
  recs[goalbulk-1].next = 0;
  return recs;
}

int initalloc()
{
  struct global_variables *glbl = &globals;
  initheap();
  freegoals = more_goal_records(glbl);
  secondary_free = more_goal_records(glbl);
/* and the other special allocation stuffs */
  inithooks();
}

/*
  stuffs for suspension
*/

#define makelistofhooks(p, max, size) {\
  int i; \
  int rsize = size/sizeof(q); \
  q *ptr=(q*)p; \
  for(i=0; i<max-2; ++i){ \
    *ptr = (q)(ptr+rsize); \
    ptr += rsize; \
  } \
  *(int *)ptr = 0; \
}
				       
int inithooks()
{
  struct susprec *susp;
  struct shook *s;
  struct mhook *m;
  if(susp = (struct susprec *)malloc(MAXSUSPRECORD *
				     sizeof(struct susprec))){
    makelistofhooks(susp, MAXSUSPRECORD, sizeof(struct susprec));
  }else{
    fatal("Can't allocate suspension records");
    return(0);
  }

  if(s = (struct shook *)malloc(MAXSHOOKRECORD *
				sizeof(struct shook))){
    makelistofhooks(s, MAXSHOOKRECORD, sizeof(struct shook));
  }else{
    fatal("Can't allocate single hook records");
    return(0);
  }
  if(m = (struct mhook *)malloc(MAXMHOOKRECORD *
				sizeof(struct mhook))){
    makelistofhooks(m, MAXMHOOKRECORD, sizeof(struct mhook));
  }else{
    fatal("Can;t allocate multiple hook records");
    return(0);
  }
  suspreclist = susp;
  shookreclist = s;
  mhookreclist = m;
  return(1);
}

struct susprec *
more_susp_record(){
  struct susprec *s;
  if(s=(struct susprec *)malloc(MAXSUSPRECORD *
				sizeof(struct susprec))){
    makelistofhooks(s, MAXSUSPRECORD, sizeof(struct susprec));
    return(s);
  }else{
    fatal("Can't allocate suspension record");
  }
}

struct shook *
more_shook_record(){
  struct shook *s;
  if(s=(struct shook *)malloc(MAXSHOOKRECORD *
			      sizeof(struct shook))){
    makelistofhooks(s, MAXSHOOKRECORD, sizeof(struct shook));
    return(s);
  }else{
    fatal("Can't allocate single hook record");
  }
}

struct mhook *
more_mhook_record(){
  struct mhook *m;
  if(m=(struct mhook *)malloc(MAXMHOOKRECORD *
			      sizeof(struct mhook))){
    makelistofhooks(m, MAXMHOOKRECORD, sizeof(struct mhook));
    return(m);
  }else{
    fatal("Can't allocate single hook record");
  }
}

int collectsusprec(s)
struct susprec *s;
{
#ifdef MDEBUG
  printf("collected susprec : %x\n", s);
#endif
  *(q *)s = (q)suspreclist;
  suspreclist = s;
  return(0);
}

int collectshook(s)
struct shook *s;
{
#ifdef MDEBUG
  printf("collected shook : %x\n", s);
#endif
  *(q *)s = (q)shookreclist;
  shookreclist = s;
  return(0);
}

int collectmhook(m)
struct mhook *m;
{
#ifdef MDEBUG
  printf("collected mhook : %x\n", m);
#endif
  *(q *)m = (q)mhookreclist;
  mhookreclist = m;
  return(0);
}

#define freelistalloc(rec, root, morealloc) \
{ \
  if(!root){ \
    root = morealloc(); \
  } \
  rec = root; \
  (q *)root = (q *)(*(q *)root); \
}

struct susprec *
susprecalloc()
{
  struct susprec *s;
  freelistalloc(s, suspreclist, more_susp_record);
  return(s);
}

struct shook *
shookalloc()
{
  struct shook *s;
  freelistalloc(s, shookreclist, more_shook_record);
  return(s);
}

struct mhook *
mhookalloc()
{
  struct mhook *m;
  freelistalloc(m, mhookreclist, more_mhook_record);
  return(m);
}
