/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define  diff(field)	(after.field - before.field)

#ifdef SYSV
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>

#define	 tick2msec(n)	((n)*1000.0/HZ)

#define	 timerstruct	struct tms
#define	 measure(x)	times(&x)

#else SYSV

#include <sys/time.h>
#include <sys/resource.h>

#define  diff_usec(field)\
(diff(field.tv_sec) * 1000000 + diff(field.tv_usec))

#define	 timerstruct	struct rusage
#define	 measure(x)	getrusage(RUSAGE_SELF, &(x))

#endif SYSV

Extern int gctimes Init(0);
Extern int gcums Init(0);
Extern int gcsms Init(0);
Extern int measure_gc Init(0);
