/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define functor_VECT 0
#define functor_STRG 1

#define gblt_hash( x, h, fail) \
  if (isref(x))  deref_and_test(x, fail); \
  (unsigned int) h = ((unsigned int)(x) & 0xFFFFFFF0) | INT

#define gblt_wait( x, fail )  \
  if (isref(x))  deref_and_test(x, fail)
    

#define gblt_list( x, fail )

#define gblt_atom( x, fail )

#define gblt_integer( x, fail )  if(!isint(x)) goto fail

#define gblt_vector( x, n, fail )       \
   if isfunctor(x) {			\
     if (functor_of(x) == makesym(functor_VECT)) {\
      n = arg(x,0);} else goto fail;	\
   } else goto fail

#define gblt_string( x, m, n, fail ) 	\
   if isfunctor(x) {			\
     if (functor_of(x) == makesym(functor_STRG)) {\
       m = arg(arg(x,0),0);			\
       n = arg(arg(x,0),1);} else goto fail;	\
   } else goto fail

#define gblt_greater( x, y, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
     if ((int)(x) <= (int)(y)) goto fail; \
   } else goto fail;} else goto fail

#define gblt_greater_or_eq( x, y, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    if ((int)(x) < (int)(y)) goto fail;\
   } else goto fail;} else goto fail

#define gblt_less( x, y, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    if ((int)(x) >= (int)(y)) goto fail; \
   } else goto fail;} else goto fail

#define gblt_less_or_eq( x, y, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    if ((int)(x) > (int)(y)) goto fail;\
   } else goto fail;} else goto fail

#define gblt_eq( x, y,  fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    if ( (int)(x) != (int)(y)) goto fail;\
   } else goto fail;} else goto fail

#define gblt_assign( x, y, fail ) \
  if (isint(y)) {  x =  y; } else goto fail;

#define gblt_not_eq( x, y, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    if ((int)(x) == (int)(y)) goto fail;\
   } else goto fail;} else goto fail

#define gblt_diff( x, y, fail ) \
  if( x == y) goto fail

#define gblt_and( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
     (unsigned int) z = ((unsigned int)(x) & (unsigned int)(y));\
   } else goto fail;} else goto fail

#define gblt_or( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
     z = makeint(intval(x) | intval(y));\
   } else goto fail;} else goto fail

#define gblt_exclusive_or( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
     z = makeint(intval(x) ^ intval(y));\
   } else goto fail;} else goto fail

#define gblt_rshift( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
     z =  makeint(intval(x) >> intval(y));\
   } else goto fail;} else goto fail

#define gblt_lshift( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
     z =  makeint(intval(x) << intval(y));\
   } else goto fail;} else goto fail

#define gblt_add( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
   (unsigned int) z = (unsigned int)(x) + ((unsigned int)(y) - INT); \
   } else goto fail;} else goto fail

#define gblt_subtract( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
     (unsigned int) z = (unsigned int)(x) - ((unsigned int)(y) - INT); \
   } else goto fail;} else goto fail


#define gblt_multiply( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    z =  makeint(intval(x) * intval(y));\
   } else goto fail;} else goto fail

#define gblt_divide( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    z = makeint(intval(x) / intval(y));\
   } else goto fail;} else goto fail

#define gblt_modulo( x, y, z, fail ) \
  if (isint(x)) {  \
   if (isint(y)) { \
    z = makeint(intval(x) % intval(y));\
   } else goto fail;} else goto fail

#define gblt_complement( x, z, fail ) \
  if (isint(x)) {  \
    z = makeint(-1 ^ (intval(x)));\
   } else goto fail;

#define gblt_plus( x, z, fail ) \
  if (isint(x)) {  \
     z = x;\
   } else goto fail;} else goto fail

#define gblt_minus( x, z, fail ) \
  if (isint(x)) {  \
     z = makeint(-(intval(x)));\
   } else goto fail;} else goto fail

#define gblt_vector_element(v, n, e, fail)   \
  if (isfunctor(v)) {                        \
     if (functor_of(v) == makesym(functor_VECT)) {    \
       if (isint(n)) {                       \
	 int w0 = intval(n);                 \
	 if((w0 >= 0) && (w0 < intval(arg(v,0)))) { \
	   e = arg(v, w0+1);} else goto fail;} \
       else goto fail;}                      \
     else goto fail;}                        \
   else goto fail;

#define gblt_string_element(s, n, e, fail) \
   if (isfunctor(s)) {                     \
     if (functor_of(s) == makesym(functor_STRG)) { \
       if (isint(n)) {                    \
	 int w0 = intval(n);              \
         q   w1 = arg(s,0);               \
	 if ((w0 >= 0) && (w0 < intval(arg(w1,0)))) { \
	   e = arg(w1, w0+2);} else goto fail;} \
       else goto fail;} \
     else goto fail;} \
   else goto fail;

#define gblt_display_console(w,fail)  printl(w);

q eq_terms_body();

#ifdef COMPACTCODE
#define if_equal(x, y, eq, neq, susp) \
{ \
  q retval; \
  switch((int)(retval = eq_terms_body((x), (y)))){ \
   case 1:  \
    goto eq; \
   case 0: \
    goto neq; \
   default: \
    *reasonp++ = retval; \
    goto susp; \
  } \
}
#else
#define if_equal(x, y, eq, neq, susp) \
{ \
  if(isatomic(x) && isatomic(y)){ \
    if((x)==(y)) \
      goto eq; \
    else \
      goto neq; \
  } else { \
    q retval; \
    switch((int)(retval = eq_terms_body((x), (y)))){ \
     case 1: \
      goto eq; \
     case 0: \
      goto neq; \
     default: \
      *reasonp++ = retval; \
      goto susp; \
    } \
  } \
}
#endif

#define otherwise(lab) \
  if (reasonp == 0) goto proceed_after_interrupt; \
  else if (reasonp >= &reasons[1]) goto lab

#define alternatively \
  if (reasonp == 0) goto proceed_after_interrupt

#ifdef TRACE
#define kl1_trace0(f) \
  printf("~%s()\n",f); 
#define kl1_trace1(f) \
  printf("~%s(",f); print(a0); printf(")\n");
#define kl1_trace2(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(")\n");
#define kl1_trace3(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(")\n");
#define kl1_trace4(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(")\n");
#define kl1_trace5(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(")\n");
#define kl1_trace6(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(")\n");
#define kl1_trace7(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(")\n");
#define kl1_trace8(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(")\n");
#define kl1_trace9(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(")\n");
#define kl1_trace10(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(")\n");
#define kl1_trace11(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(")\n");
#define kl1_trace12(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(")\n");
#define kl1_trace13(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(","); \
  print(a12); printf(")\n");
#define kl1_trace14(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(","); \
  print(a12); printf(","); \
  print(a13); printf(")\n");
#define kl1_trace15(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(","); \
  print(a12); printf(","); \
  print(a13); printf(","); \
  print(a14); printf(")\n");
#define kl1_trace16(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(","); \
  print(a12); printf(","); \
  print(a13); printf(","); \
  print(a14); printf(","); \
  print(a15); printf(")\n");
#define kl1_trace17(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(","); \
  print(a12); printf(","); \
  print(a13); printf(","); \
  print(a14); printf(","); \
  print(a15); printf(","); \
  print(a16); printf(")\n");
#define kl1_trace18(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(","); \
  print(a12); printf(","); \
  print(a13); printf(","); \
  print(a14); printf(","); \
  print(a15); printf(","); \
  print(a16); printf(","); \
  print(a17); printf(")\n");
#define kl1_trace19(f) \
  printf("~%s(",f); print(a0); printf(","); \
  print(a1); printf(","); \
  print(a2); printf(","); \
  print(a3); printf(","); \
  print(a4); printf(","); \
  print(a5); printf(","); \
  print(a6); printf(","); \
  print(a7); printf(","); \
  print(a8); printf(","); \
  print(a9); printf(","); \
  print(a10); printf(","); \
  print(a11); printf(","); \
  print(a12); printf(","); \
  print(a13); printf(","); \
  print(a14); printf(","); \
  print(a15); printf(","); \
  print(a16); printf(","); \
  print(a17); printf(","); \
  print(a18); printf(")\n");
#else
#define kl1_trace0(f)
#define kl1_trace1(f)
#define kl1_trace2(f)
#define kl1_trace3(f)
#define kl1_trace4(f)
#define kl1_trace5(f)
#define kl1_trace6(f)
#define kl1_trace7(f)
#define kl1_trace8(f)
#define kl1_trace9(f)
#define kl1_trace10(f)
#define kl1_trace11(f)
#define kl1_trace12(f)
#define kl1_trace13(f)
#define kl1_trace14(f)
#define kl1_trace15(f)
#define kl1_trace16(f)
#define kl1_trace17(f)
#define kl1_trace18(f)
#define kl1_trace19(f)
#endif



