/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
{
  struct global_variables *glbl = &globals;
  q *hp = heapp;
  q *copyp = copystart;
  q *heapboundary = space_boundary;
  q *top_of_heap = heaptop;
  int half_heap_size = half_of_heap_size * sizeof(q);

  int HeapSize = calcHeapSize();
  q* HeapTop = heaptop;
  
  /* sweep the new area and copy objects referenced from new area */
  
  while (copyp != hp) {
    q obj;
   copy_more:
    obj =  *copyp;

   deref_loop:
    switch (ptagof(obj)) {
     case VARREF:
      if(!within_new_space(obj)){
	/* Here, obj is known not to be a ref pointer to old space
	   or out side of heap */
	q value = derefone(obj);
	if (value == obj) {
	  /* if unbound, make a new variable and redirect */
	  *hp = *copyp = derefone(obj) = makeref(hp);
	  hp++; copyp++;
	  goto copy_more; /* we know we have to copy more */
	} else if(!within_heap(obj)) {
	  /* obj points out of heap, value points `obj'. */
	  struct susprec *s;
	  q *hook;
	  q *hooktop;
	  q *newref;

	  /* obj points to refecence in old space which points susprecord */
	  s = suspp(obj);
	  if(within_old_space(s->marker)) {
	    s->marker = derefone(value) = makeref(copyp);
	    *copyp = makeref(s);
	    hook = (q*)getnexthook(s);

	    hooktop = (q*)s;
	    do{
	      struct goalrec *g;
	      switch(hooktag(hook)){
	       case SSUSP:
		g = ((struct shook *)hook)->goals;
		break;
	       case MSUSP:
		g = ((struct mhook *)hook)->goals;
		break;
	       default: /* merger */
		{
		  struct merger *m = (struct merger *)hook;
		  struct merger_common *c = m->common;
		  if(within_old_space(c->variable)){
#ifdef DEBUG
		    if(!isref(c->variable)){
		      fatal("Funny merger output cell in GC\n");
		    }
#endif
		    *hp = c->variable;
		    {
		      q tmpv = derefone(c->variable);
		      if(isref(tmpv) && !within_heap(tmpv)){
			struct susprec *s = suspp(tmpv);
			s->marker = (q)hp;
		      }
		    }
		    c->variable = makeref(hp++);
		  }
		  goto susploopnext;
		}
	      }
	      
	      {
		int k;
		int n = g->pred->arity;
		q *argbase = g->args;
		int start = 0;
		while (n > 0) {
		  int end;
		  int j;
		  if (n <= NUMGOALARGS) {
		    end = start + n;
		  } else {
		    end = NUMGOALARGS - 1;
		  }
		  for (j = start; j < end; j++) {
		    q a = argbase[j];
		   again:
		    switch (ptagof(a)) {
		     case VARREF:
		      if(!within_new_space(a)){
			/* a points old space or suspension record */
			q val = derefone(a);
			if (val == a) {
			  derefone(a) = argbase[j] = makeref(hp);
			  *hp = makeref(hp); hp++;
			  break;
			} else if (!within_heap(a)){
			  /* `a' points val */
			  if(within_old_space(val)) {
			    argbase[j] = makeref(hp);
			    *hp++ = val;
			  } else {
			    argbase[j] = val;
			  }
			  break;
			} else if(within_new_space(val)){
			  /* val is a pointer from old space to new space */
			  if(!isstruct(val)){
			    argbase[j] = val;
			  }else{
			    argbase[j] = makeref(&cdr_of(val));
			  }
			}else{
			  a = val;
			  goto again;
			}
		      }else{
			argbase[j] = a;
		      }
		      break;
		     case ATOMIC:
		      /* insert 93/1/19 */
		      argbase[j] = a;
		      break;
		     case CONS:
		      if(within_old_space(a)){
			q cdr = cdr_of(a);
			if(within_old_space(cdr) || !isstruct(cdr)){
			  /* This cons has not been copied */
			  *hp = cdr;
			  argbase[j] = cdr_of(a) = makecons(hp);
			  *(hp+1) = car_of(a);
			  car_of(a) = makeref(hp+1);
			  hp += 2;
			} else {
			  /* This cons has been copied */
			  argbase[j] = cdr;
			}
		      }else{
			argbase[j] = a;
		      }
		      break;
		     default:
		      /* fatal("Functor not implemented yet");*/
		      if(within_old_space(a)){
			int l, m;
			q f = functor_of(a);
			if(!isstruct(f)){
			  argbase[j] = functor_of(a) = makefunctor(hp);
			  *hp++ = f;
			  switch((unsigned int)f){
			   case makesym(functor_VECT):
			     m = intval(*hp++ = arg(a, 0));
			     for(l=1; l<=m; ++l){
			       *hp = arg(a, l);
			       arg(a, l) = makeref(hp++);
			     }
			     break;
			    case makesym(functor_STRG):
			      m = (intval(*hp++ = arg(a, 0)) + 3 ) / 4;
			     for(l=1; l<=m; l++){
			       /* just copy */
			       *hp++ = arg(a, l);
			     }
			     break;
			    default:
			     m = arityof(f);
			     for(l=0; l<m; l++){
			       *hp = arg(a,l);
			       arg(a,l) = makeref(hp++);
			     }
			   }
			}else{
			  argbase[j] = f;
			}
		      }else{
			argbase[j] = a;
		      }
		    }
		  }
		  n -= (end-start);
		  start = -2;
		  argbase = ((struct goalrec *)argbase[end])->args;
		}
	      }
	     susploopnext:
	      hook = getnexthook(hook);
	    }while(hook != hooktop);
	  } else {
	    /* if s->marker points the new space,
	       copying is not required */
	    if((q)copyp != makeref(s->marker))
	      *copyp = makeref(s->marker);
	  }
	} else if(isatomic(value)){
	  obj = value;
	  goto deref_loop;
	} else if (!within_new_space(value)) {
	  /* obj is a reference to old space or suspension record
	     and value is a pointer to old space */
	  obj = value;
	  goto deref_loop;
	} else {
	  /* value is a pointer to new space or suspension */
	  if(!isstruct(value)) {
	    *copyp = value;
	  }else{
	    *copyp = makeref(&cdr_of(value));
	  }
	}
      } else {
	/* obj is a pointer to new space */
	*copyp = obj;
      }
      break;
     case ATOMIC:
      *copyp = obj;
      if(obj == makesym(functor_STRG)){
	/* its a special case */
	int size = (intval((int)derefone(++copyp)) + 3) / 4;
	copyp += size ; /* copyp will be increment after break */
      }
      break;
     case CONS:
      if (within_old_space(obj)) {
	q cdr = cdr_of(obj);
	if(within_old_space(cdr) || !isstruct(cdr)){
	  /* This cons has not been copied yet */
	  *hp = cdr; *(hp+1) = car_of(obj);
	  *copyp = cdr_of(obj) = makecons(hp);
	  car_of(obj) = makeref(hp+1);
	  hp += 2;
	  copyp++;
	  goto copy_more;
	}else{
	  *copyp = cdr;
	}
      }else{
	*copyp = obj;
      }
      break;
     default:
      /*      fatal("functor not implemented yet");*/
      /*      if (!within_new_space(obj)) {*/
      if(within_old_space(obj)) {
	q f = functor_of(obj);
	if(!isstruct(f)){
	  *copyp = functor_of(obj) = makefunctor(hp);
	  *hp++ = f;
	  switch((unsigned int)f){
	    int l, m;
	   case makesym(functor_VECT):
	     m = intval(*hp++ = arg(obj,0));
	    for (l = 1; l <= m; l++) {
	      *hp = arg(obj,l);
	      arg(obj,l) = makeref(hp++);
	    }
	    break;
	   case makesym(functor_STRG):
	     m = (intval(*hp++ = arg(obj,0)) + 3) / 4;
	    for(l = 1; l <= m; l++) {
	      /* just copy */
	      *hp++ = arg(obj, l);
	    }
	    break;
	   default: /* normal functor */
	    m = arityof(f);
	    for (l = 0; l < m; l++) {
	      *hp = arg(obj,l);
	      arg(obj,l) = makeref(hp++);
	    }
	  }
	}else{
	  /* This functor has already copied */
	  *copyp = f;
	}
      }else{
	*copyp = obj;
      }
      break;
    }
    copyp++;
  }
  heapp = hp;
}

