/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
append([], Y, Y).
append([W|X], Y, [W|Z]) :- append(X, Y, Z).

reverse(L, R) :- reverse(L, R, []).

reverse([], R, R).
reverse([H|T], R, RT) :- reverse(T, R, [H|RT]).

assoc([H=T|_], H, T) :- !.
assoc([_|Rest], H, T) :- assoc(Rest, H, T).

member([X|_], X) :- !.
member([_|T], X) :- member(T, X).

max(X, Y, M) :- ( X >= Y -> M = X; M = Y ).
min(X, Y, M) :- ( X =< Y -> M = X; M = Y ).

max_list(L, M) :- max_list(L, 0, M).

max_list([], M, M).
max_list([H|T], M0, M) :- max(H, M0, M1), max_list(T, M1, M).

remove([], _, L, L).
remove([H|T], H, L0, L) :- !, remove(T, H, L0, L).
remove([H|T], X, [H|L0], L) :- !, remove(T, X, L0, L).
