/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
find_extern([], NA, NA, A, A, NF, NF, F, F, NP, NP, P, P).
find_extern([H|T], NA0, NA, A0, A, NF0, NF, F0, F, NP0, NP, P0, P) :-
	find_ext(H, NA0, NA1, A0, A1, NF0, NF1, F0, F1, NP0, NP1, P0, P1),
	find_extern(T, NA1, NA, A1, A, NF1, NF, F1, F, NP1, NP, P1, P).

find_ext(One, NA0, NA, A0, A, NF0, NF, F0, F, NP0, NP, P0, P) :-
	( ext_atom(One, NA0, NA, A0, A) -> true; NA = NA0, A = A0 ),
	( ext_funct(One, NF0, NF, F0, F) -> true; NF = NF0, F = F0 ),
	( ext_pred(One, NP0, NP, P0, P) -> true; NP = NP0, P = P0 ).

ext_atom(sw_atom(_,Cases,_), NA0, NA, A0, A) :-
	ext_cases(Cases, NA0, NA, A0, A).
ext_atom(load_atom(_,Atom), NA0, NA, A0, A) :-
	ext_one(Atom, NA0, NA, A0, A).
ext_atom(case_atom(Atom), NA0, NA, A0, A) :-
	ext_one(Atom, NA0, NA, A0, A).
ext_atom(alloc_atomic(Atom, _), NA0, NA, A0, A) :- atom(Atom),
	ext_one(Atom, NA0, NA, A0, A).
ext_atom(unify_atom(_, Atom), NA0, NA, A0, A) :-
	ext_one(Atom, NA0, NA, A0, A).
ext_atom(set_atomic(_, Atom, _), NA0, NA, A0, A) :- atom(Atom),
	ext_one(Atom, NA0, NA, A0, A).
ext_atom(gblt(F,_,Args,_),    NA0, NA, A0, A) :-
	ext_one(F, NA0, NA1, A0, A1),
	ext_atoms(Args, NA1, NA, A1, A).

ext_atoms([], NA, NA, A, A):- !.
ext_atoms([makeatom(Atom)|Args], NA0, NA, A, A0) :- atom(Atom),!,
	ext_one(Atom, NA0, NA1, A, A1),
	ext_atoms(Args, NA1, NA, A1, A0).

ext_funct(sw_funct(_,Cases,_), NF0, NF, F0, F) :-
	ext_cases(Cases, NF0, NF, F0, F).
ext_funct(case_funct(Funct/Arity), NF0, NF, F0, F) :-
	ext_one(Funct/Arity, NF0, NF, F0, F).
ext_funct(make_functor(_,Funct,Arity), NF0, NF, F0, F) :-
	ext_one(Funct/Arity, NF0, NF, F0, F).

ext_pred(push_ext(Mod,Name,Arity), NP0, NP, P0, P) :-
	ext_one(Mod/Name/Arity, NP0, NP, P0, P).

ext_one([], N, N, L, L) :- !.
ext_one(I, N, N, L, L) :- integer(I), !.
ext_one(X, N, N, L, L) :- assoc(L, X, _), !.
ext_one(X, N0, N, L, [X=N0|L]) :- N is N0+1.

ext_cases([], N, N, L, L).
ext_cases([Key=_|T], N0, N, L0, L) :-
	ext_one(Key, N0, N1, L0, L1),
	ext_cases(T, N1, N, L1, L).
