/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
is_body_builtin((:=),2).
is_body_builtin(times,1).

is_body_builtin(new_vector,2).
is_body_builtin(merge,2).
is_body_builtin(set_vector_element,5).
is_body_builtin(left_shift,3).
is_body_builtin(add,3).
is_body_builtin(subtract,3).
is_body_builtin(multiply,3).
is_body_builtin(divide,3).
is_body_builtin(modulo,3).
is_body_builtin(and,3).
is_body_builtin(or,3).
is_body_builtin(right_shift,3).
is_body_builtin(plus,2).
is_body_builtin(minus,2).

body_builtin('$VAR'(K):=Expr,AL0,AL,R0,R,L0,L) --> !,
	expression(Expr,AL0,AL1,R0,R1,L0,L,Result),
	{
	    (
		assoc(AL1,'$VAR'(K),Where) ->
		AL = AL1, R = R1
	    ;
		R is R1+1, Where = r(x(R1)),
		AL = ['$VAR'(K)=Where|AL1]
	    )
	},
	body_unify(Where,Result,R1,R).
body_builtin(times('$VAR'(K)),AL0,AL,R0,R,L0,L) --> !,
	[blt_times(r(x(R0)))],
	{
	    R1 is R0+1, L = L0,
	    (
		assoc(AL0,'$VAR'(K),Where) ->
		AL = AL0, R = R1
	    ;
		R is R1+1, Where = r(x(R1)),
		AL = ['$VAR'(K)=Where|AL0]
	    )
	},
	body_unify(Where,r(x(R0)),R1,R).

expression(N,AL,AL,R,R,L,L,a(N)) --> { integer(N) }, !.
expression('$VAR'(K),AL0,AL,R0,R,L,L,Where) --> !,
	{
	    (
		assoc(AL0,'$VAR'(K),Where) ->
		AL = AL0, R = R0
	    ;
		R is R0+1, Where = r(x(R0)),
		AL = ['$VAR'(K)=Where|AL0]
	    )
	}.
expression(X0+Y0,AL0,AL,R0,R,L0,L,Result) --> !,
	arith(add,X0,Y0,AL0,AL,R0,R,L0,L,Result).
expression(X0-Y0,AL0,AL,R0,R,L0,L,Result) --> !,
	arith(subtract,X0,Y0,AL0,AL,R0,R,L0,L,Result).
expression(X0*Y0,AL0,AL,R0,R,L0,L,Result) --> !,
	arith(multiply,X0,Y0,AL0,AL,R0,R,L0,L,Result).
expression(X0/Y0,AL0,AL,R0,R,L0,L,Result) --> !,
	arith(divide,X0,Y0,AL0,AL,R0,R,L0,L,Result).
expression(X0>>Y0,AL0,AL,R0,R,L0,L,Result) --> !,
	arith(rshift,X0,Y0,AL0,AL,R0,R,L0,L,Result).
expression(X0<<Y0,AL0,AL,R0,R,L0,L,Result) --> !,
	arith(lshift,X0,Y0,AL0,AL,R0,R,L0,L,Result).

arith(Operator,X0,Y0,AL0,AL,R0,R,L0,L,Z) -->
	{
	    R1 is R0+1, Z = r(x(R0)),
	    L1 is L0+1
	},
	expression(X0,AL0,AL2,R1,R2,L1,L2,X),
	expression(Y0,AL2,AL,R2,R,L2,L,Y),
	[arith(X,Y,Z,L0,Operator)].
