/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
kl1cmp :-
   unix(argv(List)),
   kl1cmps(List),
   halt.

kl1cmps(List) :-
    atom_functor_in,
    (kl1cmps1(List),!
    ;
     told,seen,
     (format("Compiler BUG!!~n",[]); true),
     halt),
    atom_functor_out.

kl1cmps1([]):- !.
kl1cmps1([F|Next]):-
    format("Compiling ~a...~n",F),
    klcmp(F),
    kl1cmps1(Next).

kl1cmp(Name) :-
    atom_functor_in,
    (klcmp(Name),!
    ;
     told, seen,
     (format("Compiler Error!!~n",[]); true),
     halt
    ),
    atom_functor_out.

kl1rcmp(Name) :-
    (klcmp(Name),!
    ;
     told, seen,
     (format("Compiler Error!!~n",[]);true),
     halt
    ),
    atom_functor_out.

atom_functor_in :-
    nofileerrors,
    init_atom_table('atom.db'),
    init_functor_table('funct.db'),
    fileerrors.

atom_functor_out :-
    make_atom_file('atom.h'),
    make_functor_file('funct.h'),
    make_atom_name_file('atom.c'),
    make_functor_table_file('funct.c'),
    make_atom_db_file('atom.db'),
    make_functor_db_file('funct.db').

init_atom_table(File):-
    recorda(atom,number(0),_),
    see(File),!,
    read_atoms(Atoms),
    seen,
    make_atom_table(Atoms).
init_atom_table(_):- format("no atom database.~n",[]).

init_functor_table(File):-
    recorda(functor,number(0),_),
    see(File),!,
    read_atoms(Atoms),
    seen,
    make_functor_table(Atoms).
init_functor_table(_):- format("no functor database.~n",[]).

read_atoms(Atoms):- 
   read_atom(Atom),
   read_atoms(Atom,Atoms).

read_atom(Atom):-
   get0(Char),
   read_atom(Char,Atom).

read_atoms([],[]):- !.
read_atoms(Atom,[ATOM|Atoms]):-
   name(ATOM,Atom),
   read_atoms(Atoms).

read_atom(-1,[]):- !.
read_atom(10,[]):- !.
read_atom(Char,[Char|Btm]):- !,
   get0(Char1),
   read_atom(Char1,Btm).
   

make_atom_table(Atoms):-
    recorded(atom,number(N),Ref),
    make_atom_table(Atoms,N,NewN),
    erase(Ref),
    recorda(atom,number(NewN),_).


make_atom_table([],N,N):- !.
make_atom_table([Atom|Atoms],M,N):-
    name(Atom,ATOM),
    (recorded(atom,atom(Atom,_,_),_),!,
     make_atom_table(Atoms,M,N)
    ;
     recorda(atom,atom(Atom,ATOM,M),_),
     M1 is M + 1,
     make_atom_table(Atoms,M1,N)).

make_functor_table(Atoms):-
    recorded(functor,number(N),Ref),
    make_functor_table(Atoms,N,NewN),
    erase(Ref),
    recorda(functor,number(NewN),_).

make_functor_table([],N,N):- !.
make_functor_table([Functor,Ari|Functors],M,N):-
    name(Functor,FUNCTOR),
    (recorded(functor,functor(Functor,_,Ari,_,_),_),!,
     make_functor_table(Functors,M,N)
    ;
     enter_atom(Functor,MA),
     recorda(functor,functor(Functor,FUNCTOR,Ari,MA,M),_),
     M1 is M + 1,
     make_functor_table(Functors,M1,N)).


enter_atom(Atom,M):- 
     recorded(atom,atom(Atom,_,M),_),!.
enter_atom(Atom,N1):-
     recorded(atom,number(N),Ref),
     N1 is N + 1,
     erase(Ref),
     name(Atom,ATOM),
     recorda(atom,atom(Atom,ATOM,N),_),
     recorda(atom,number(N1),_).

enter_functor(Func,A,M):-
     recorded(functor,functor(Func,_,A,_,M),_),!.
enter_functor(Func,A,N):-
     recorded(functor,number(N),Ref),
     N1 is N + 1,
     enter_atom(Func,MA),
     erase(Ref),
     name(Func,FUNC),
     recorda(functor,functor(Func,FUNC,A,MA,N),_),
     recorda(functor,number(N1),_).

make_atom_file(File):-
	tell(File),
	format("#include <klic/atomstuffs.h>~n",[]),
        atom_file_out(0),
        format("extern char *atomname[];~n",[]),
        told.

atom_file_out(N):-
   recorded(atom,atom(_,ATOM,N),_),!,
   make_atom_name_string(ATOM,Str),
   format("#define  atom_~s  ~d + ATOMNUMBERBASE~n",[Str,N]),
   N1 is N + 1,
   atom_file_out(N1).
atom_file_out(_).
   
make_functor_file(File):-
	tell(File),
	format("#include <klic/functorstuffs.h>~n",[]),
        functor_file_out(0),
        format("extern int functors[];~n",[]),
        format("extern int arities[];~n",[]),
        told.

make_functor_table_file(File):-
       tell(File),
       format("#include <klic/atomstuffs.h>~n",[]),
       format("~n~nint functors[] = {",[]),
       functor_atom_file_out0(0),
       format("};~n",[]),
       format("~n~nint arities[] = {",[]),
       functor_arity_file_out0(0),
       format("};~n",[]),
       told.

functor_file_out(N):-
   recorded(functor,functor(_,FUNCTOR,Ari,_,N),_),!,
   make_atom_name_string(FUNCTOR,Str),
   format("#define  functor_~s__~d  ~d + FUNCTORNUMBERBASE~n",[Str,Ari,N]),
   N1 is N + 1,
   functor_file_out(N1).
functor_file_out(_).
   
functor_atom_file_out0(N):-
   recorded(functor,functor(F,_,_,_,N),_),!,
   enter_atom(F,MA),
   format("~n       ~d + ATOMNUMBERBASE",[MA]),
   N1 is N + 1,
   functor_atom_file_out(N1).
functor_atom_file_out0(_).

functor_atom_file_out(N):-
   recorded(functor,functor(F,_,_,_,N),_),!,
   enter_atom(F,MA),
   format(",~n        ~d + ATOMNUMBERBASE",[MA]),
   N1 is N + 1,
   functor_atom_file_out(N1).
functor_atom_file_out(_).
   
functor_arity_file_out0(N):-
   recorded(functor,functor(_,_,Ari,_,N),_),!,
   format("~n        ~d",[Ari]),
   N1 is N + 1,
   functor_arity_file_out(N1).
functor_arity_file_out0(_).
   
functor_arity_file_out(N):-
   recorded(functor,functor(_,_,Ari,_,N),_),!,
   format(",~n        ~d",[Ari]),
   N1 is N + 1,
   functor_arity_file_out(N1).
functor_arity_file_out(_).
   

/*
make_atom_name_string([],Str) :- Str = [].
make_atom_name_string([H|T],Str) :-
	(
	    "0" =< H, H =< "9"
	;
	    "A" =< H, H =< "Z"
	;
	    "a" =< H, H =< "z"
	), !,
	Str = [H|StrT],
	make_atom_name_string(T, StrT).
make_atom_name_string([0'_|T],[0'_,0'_|StrT]) :-
	make_atom_name_string(T, StrT).
make_atom_name_string([H|T],[0'_|Str]) :-
	ascii_string(H, Str, StrT),
	make_atom_name_string(T, StrT).

ascii_string(C, [Upper, Lower|T], T) :-
	U is C>>4, hexchar(U, Upper),
	L is C/\15, hexchar(L, Lower).

hexchar(C, N) :- C < 10, !, N is "0" + C.
hexchar(C, N) :- N is "A" + C - 10.
*/

make_atom_name_file(File):-
	tell(File),
	format("char *atomname[] = {~n",[]),
        (recorded(atom,atom(_,ATOM,0),_),!,
	 format(" ""~s""~n",[ATOM]),
         atom_name_out(1); true),
	format(" }; ~n",[]),
        told.

atom_name_out(N):-
   recorded(atom,atom(_,ATOM,N),_),!,
   format(" ,""~s""~n",[ATOM]),
   N1 is N + 1,
   atom_name_out(N1).
atom_name_out(_).
   
make_atom_db_file(File):-
	tell(File),
        atom_db_out(0),
        told.

atom_db_out(N):-
   recorded(atom,atom(_,ATOM,N),_),!,
   format("~s~n",[ATOM]),
   N1 is N + 1,
   atom_db_out(N1).
atom_db_out(_).
   
make_functor_db_file(File):-
	tell(File),
        functor_db_out(0),
        told.

functor_db_out(N):-
   recorded(functor,functor(_,F,Ari,_,N),_),!,
   format("~s~n~d~n",[F,Ari]),
   N1 is N + 1,
   functor_db_out(N1).
functor_db_out(_).
   
