;; Looking for Manual of PDSS V2.5  (89.08.30)

(defun pdss-manual-builtin-predicate ()
  (interactive)
  (save-excursion
    (let (index reqex default cbuf fbuf mbuf found)
      (setq default "")
      (if (re-search-backward "[^a-z_]" nil t)
	  (let (from to)
	    (forward-char 1)
	    (setq from (point))
	    (if (re-search-forward "[^a-z_]" nil t)
		(setq default (buffer-substring from (- (point) 1))))))
      (if (string-equal default "")
	  (setq index (read-string "Predicate Name : "))
	(setq index (read-string
		     (concat "Predicate Name (default " default "): ") ""))
	(if (string-equal index "") (setq index default)))
      (if (string-equal index "")
	  nil
	(setq fbuf (find-file-noselect pdss-manual-file-name))
	(setq mbuf (get-buffer-create "PDSS=MANUAL"))
	(setq cbuf (current-buffer))
	(if (null (get-buffer-window mbuf))
	    (switch-to-buffer-other-window mbuf))
	(setq found nil)
	(set-buffer mbuf)
	(erase-buffer)
	(setq regex (regexp-quote index))
	(if (string-equal (substring regex 0 2) "\\*")
	    (setq regex (concat "[a-zA-Z_]*" (substring regex 2))))
	(if (string-equal (substring regex -2) "\\*")
	    (setq regex (concat (substring regex 0 -2) "[a-zA-Z_]*")))
	(setq regex (concat "^\\\\Builtin{" regex "}{([^}]*}{.*\\}$"))
	(set-buffer fbuf)
	(goto-char (point-max))
	(while (re-search-backward regex nil t)
	  (if (string-match "\n\n"
			    (buffer-substring (- (point) 2) (+ (point) 1)))
	      (let (from to)
		(setq from (point))
		(search-forward "\n\n")
		(setq to (- (point) 1))
		(goto-char from)
		(set-buffer mbuf)
		(insert-buffer-substring fbuf from to)
		(if found (insert "--------------------\n"))
		(goto-char (point-min))
		(set-buffer fbuf)
		(setq found t))))
	(if found nil
	  (set-buffer mbuf)
	  (erase-buffer)
	  (insert index)
	  (insert " is not found.\n"))
	(set-buffer mbuf)
	(goto-char (point-min))
	(replace-string "\\begin{verbatim}\n" "")
	(goto-char (point-min))
	(replace-string "\\end{verbatim}\n" "")
	(goto-char (point-min))
	(replace-string "\\Caution" "$BCm(B:")
	(goto-char (point-min))
	(replace-string "\\\\" "")
	(goto-char (point-min))
	(replace-regexp "\\\\\\([{}]\\)" "\\1")
	(goto-char (point-min))
	(replace-regexp
	 "\\\\Builtin{\\([^}]*\\)}{\\(.*\\)}{\\(.*\\)}$" "\\1\\2 :: \\3")
	(goto-char (point-min))
	(replace-regexp "\\\\verb|\\([^|]*\\)|" "\\1")
	(goto-char (point-min))
	(set-buffer cbuf)
	(if (get-buffer-window cbuf)
	    (select-window (get-buffer-window cbuf)))))))

(defun pdss-manual-mpimos-command ()
  (interactive)
  (save-excursion
    (let (index reqex default cbuf fbuf mbuf found)
      (setq default "")
      (if (re-search-backward "[^a-z_]" nil t)
	  (let (from to)
	    (forward-char 1)
	    (setq from (point))
	    (if (re-search-forward "[^a-z_]" nil t)
		(setq default (buffer-substring from (- (point) 1))))))
      (if (string-equal default "")
	  (setq index (read-string "Command Name : "))
	(setq index (read-string
		     (concat "Command Name (default " default "): ") ""))
	(if (string-equal index "") (setq index default)))
      (if (string-equal index "")
	  nil
	(setq fbuf (find-file-noselect pdss-manual-file-name))
	(setq mbuf (get-buffer-create "PDSS=MANUAL"))
	(setq cbuf (current-buffer))
	(if (null (get-buffer-window mbuf))
	    (switch-to-buffer-other-window mbuf))
	(setq found nil)
	(set-buffer mbuf)
	(erase-buffer)
	(setq regex (regexp-quote index))
	(if (string-equal (substring regex 0 2) "\\*")
	    (setq regex (concat "[a-zA-Z_]*" (substring regex 2))))
	(if (string-equal (substring regex -2) "\\*")
	    (setq regex (concat (substring regex 0 -2) "[a-zA-Z_]*")))
	(setq regex (concat "^\\\\MpShellCommand{" regex "}{([^}]*}$"))
	(set-buffer fbuf)
	(goto-char (point-max))
	(while (re-search-backward regex nil t)
	  (if (string-match "\n\n"
			    (buffer-substring (- (point) 2) (+ (point) 1)))
	      (let (from to)
		(setq from (point))
		(search-forward "\n\n")
		(setq to (- (point) 1))
		(goto-char from)
		(set-buffer mbuf)
		(insert-buffer-substring fbuf from to)
		(if found (insert "--------------------\n"))
		(goto-char (point-min))
		(set-buffer fbuf)
		(setq found t))))
	(if found nil
	  (set-buffer mbuf)
	  (erase-buffer)
	  (insert index)
	  (insert " is not found.\n"))
	(set-buffer mbuf)
	(goto-char (point-min))
	(replace-string "\\begin{verbatim}\n" "")
	(goto-char (point-min))
	(replace-string "\\end{verbatim}\n" "")
	(goto-char (point-min))
	(replace-string "\\Caution" "$BCm(B:")
	(goto-char (point-min))
	(replace-string "\\\\" "")
	(goto-char (point-min))
	(replace-regexp "\\\\\\([{}]\\)" "\\1")
	(goto-char (point-min))
	(replace-regexp "\\\\MpShellCommand{\\([^}]*\\)}{\\(.*\\)}$" "\\1\\2")
	(goto-char (point-min))
	(replace-regexp "\\\\verb|\\([^|]*\\)|" "\\1")
	(goto-char (point-min))
	(set-buffer cbuf)
	(if (get-buffer-window cbuf)
	    (select-window (get-buffer-window cbuf)))))))
