;;-----------------------------------------------------------------------------
;;   kl1-mode: Major mode for editing KL1 source for PDSS V2.5	(90.04.25)
;;-----------------------------------------------------------------------------


(defun kl1-mode ()
  "								    [90.02.13]
	  ˣ̣ΥɤԽ뤿Υ᥸㡼⡼
	 ====================================================


Υ⡼ɤǤɸΥޥɰʳ˼Τ褦ʥޥɤѤǤ롣


ޥ
--------------------
    ESC a	򥯥Ƭ˰ư롣(֤λ)
    ESC e	򥯥κǸ˰ư롣(֤λ)
    ESC k	Τ륯롣(֤λ)
    ESC ?       Τ륯Υ⥸塼̾,Ҹ̾,ƥĴ٤롣
                ޤ mod:pred/arity η kill-ring ˥֤롣

ޥ
------------------
    TAB		ΤԤλԤλλKL1ιʸ
		Ĵ٤(1)롣λʲ(2)򻲾Ȥ롣
		    kl1-head-indent-level   : إåλ
		    kl1-guard-indent-level  : ɥλ
		    kl1-body-indent-level   : ܥǥλ
		ޤҸ乽¤ΤǲԤƤˤϡι¤
		Ϥ ( { [ ΰ֤򸵤˻֤롣
    LFD		Τ֤˲Ԥ塢TAB ƱͤʻԤ
    ESC X indent-region
		ȥޡδ֤γƹԤФ TAB ƱͤʻԤ

ޥ
--------------------
    ESC ;	ΤԤ˥Ȥ̵СKL1ιʸŬʰ֤
		(1) Ȥꡢ˥ư롣˥
		ͭСȤΰ֤Ŭʷ֤˰ư򥳥
		ʸκǽʸ˰ư롣
    C-X ;	Τ֤򥳥ȳϰ֤ȤϿ롣ΰ
		KL1ɤα¦˽񤫤륳Ȥγϰ֤ȤƻȤ롣
		ͤ kl1-comment-column (2)ͤåȤ롣

ޥ˥奢븡ޥ
----------------------
    C-C C-F	PDSSΥޥ˥奢򸡺ꤵ줿ȹҸѤΥХ
		եɽ롣

ѥ륳ޥ
------------------
    C-C C-C	ԽΥХåեˤKL1Τե˥֤
		ѥ뤹롣ѥEMACSλҥץȤ˼¹
		졢ѥΥåѤΥХåե˽Ϥ롣
    C-C C-R	KL1ɤʬѥΤ˻ꤵ줿꡼̤ΥХ
		ե˥ԡ롣θ C-C C-D ޥɤǼºݤΥѥ
		ԤʤΥޥɤʣȤˤʣΡʬפ
		ꤹǤ롣
    C-C C-K	ʬѥΤ򤷤ΤƤ롣
    C-C C-D	KL1ɤʬѥԤ
    C-C C-Z	ѥ򥢥ܡȤ롣
    ESC X pdss-kl1cmp-switch-system-mode
		ѥ⡼(Ѥޤϥƥ)ڤؤԤ
		ѤΥ⡼ɤǤϥƥѤȹҸȤǤʤǥե
		ȤǤϰ̥桼ѥ⡼ɡ
    ESC X pdss-kl1cmp-switch-indexing-mode
		ǥ󥰵ǽȤ/ȤʤڤؤԤ
		եȤǤϥǥ󥰵ǽȤ
    ESC X pdss-kl1cmp-switch-mrbgc-mode
		MRB-GCΰ٤β̿/ʤڤؤԤǥե
		ȤǤϲ̿롣


 1:  kl1-mode ǤKL1Ƥιʸ򥵥ݡȤƤǤϤʤΤǡʲ
      Τ褦ʹʸȤäƤˤϻǽƯʤ
	 ʬΥޥȤäƤ硣
	 ߥåȥȥС `|' ̵硣
	 :-  --> ޤǤ뤬ǰϤޤƤʤȥब硣
	 ȥ˲ԥɴޤޤƤ硣
	 /* ... */ ΥȤȤäƤ硣

 2: ϳƥ桼 .emacs եǰʲΤ褦ʷ
      ˤꥫޥǽˤʤäƤ롣
	    (setq kl1-mode-hook 'my-kl1-mode-init)
	    (defun my-kl1-mode-init ()
	      (setq kl1-head-indent-level  0)  ; إåλ
	      (setq kl1-guard-indent-level 2)  ; ɥλ
	      (setq kl1-body-indent-level  4)) ; ܥǥλ"
  (interactive)
  (kill-all-local-variables)
  (setq major-mode 'kl1-mode)
  (setq mode-name "KL1")
  (use-local-map kl1-mode-map)
  (set-syntax-table kl1-syntax-table)
  (setq paragraph-start "^$\\|\f")
  (setq paragraph-separate "^$\\|\f")
  (make-local-variable 'kl1-head-indent-level)
  (make-local-variable 'kl1-guard-indent-level)
  (make-local-variable 'kl1-body-indent-level)
  (make-local-variable 'indent-line-function)
  (setq indent-line-function 'kl1-indent-line)
  (make-local-variable 'comment-column)
  (setq comment-column kl1-comment-column)
  (make-local-variable 'comment-start)
  (setq comment-start "%")
  (make-local-variable 'comment-end)
  (setq comment-end "")
  (make-local-variable 'comment-multi-line)
  (setq comment-multi-line nil)
  (make-local-variable 'comment-start-skip)
  (setq comment-start-skip "%+ *")
  (make-local-variable 'comment-indent-hook)
  (setq comment-indent-hook 'kl1-get-comment-column)
  ;; ɸΥȤλˤϵǽԴʬʸ˥ȳ
  ;; ʸ % ʤkl1-mode ǤϥȤλʬ
  ;; ؿǹԤ
  (make-local-variable 'require-final-newline)
  (setq require-final-newline t)
  (run-hooks 'kl1-mode-hook))


(defvar kl1-mode-map nil)
(if (null kl1-mode-map)
    (let ((map (make-sparse-keymap)))
      ;; ޥɡ
      (define-key map "\M-a"	 'kl1-backward-clause)
      (define-key map "\M-e"     'kl1-forward-clause)
      (define-key map "\M-k"	 'kl1-kill-clause)
      (define-key map "\M-?"	 'kl1-what-clause)
      ;; ޥɡ
      (define-key map "\t"	 'kl1-indent-line)
      (define-key map "\M-;"	 'kl1-indent-comment)
      ;; ¾Խޥɡ
      (define-key map "\177"	 'backward-delete-char-untabify)
      ;; ޥ˥奢븡ޥɡ pdss-manual.el 򻲾ȡ
      (define-key map "\C-c\C-f" 'pdss-manual-builtin-predicate)
      ;; ѥѥޥɡ pdss-kl1cmp.el 򻲾ȡ
      (define-key map "\C-c\C-c" 'pdss-kl1cmp-compile-current-buffer)
      (define-key map "\C-c\C-r" 'pdss-kl1cmp-copy-region-to-buffer)
      (define-key map "\C-c\C-k" 'pdss-kl1cmp-clear-buffer)
      (define-key map "\C-c\C-d" 'pdss-kl1cmp-compile-regions)
      (define-key map "\C-c\C-z" 'pdss-kl1cmp-abort-compiler)
      (setq kl1-mode-map map)))


(autoload 'pdss-manual-builtin-predicate
  (concat pdss-emacs-directory-name "pdss-manual")
  "ȹҸΥޥ˥奢򸡺롣" t)
(autoload 'pdss-kl1cmp-compile-current-buffer
  (concat pdss-emacs-directory-name "pdss-kl1cmp")
  "ԽΥХåեˤKL1Τ򥳥ѥ뤹롣" t)
(autoload 'pdss-kl1cmp-copy-region-to-buffer
  (concat pdss-emacs-directory-name "pdss-kl1cmp")
  "ʬѥΤ˻ꤵ줿꡼̤ΥХåե˥ԡ롣" t)
(autoload 'pdss-kl1cmp-switch-system-mode
  (concat pdss-emacs-directory-name "pdss-kl1cmp")
  "ѥ⡼(/ƥ)ڤؤԤ" t)
(autoload 'pdss-kl1cmp-switch-indexing-mode
  (concat pdss-emacs-directory-name "pdss-kl1cmp")
  "ǥ󥰵ǽȤ/ȤʤڤؤԤ" t)
(autoload 'pdss-kl1cmp-switch-mrbgc-mode
  (concat pdss-emacs-directory-name "pdss-kl1cmp")
  "MRB-GCΰ٤β̿/ʤڤؤԤ" t)


(defvar kl1-syntax-table nil)
(if (null kl1-syntax-table)
    (let ((table (make-syntax-table)))
      (setq kl1-syntax-table table)
      (modify-syntax-entry ?\n ">"    table) ;; end comment
      (modify-syntax-entry ?!  "."    table)
      (modify-syntax-entry ?\" "\""   table) ;; string
      (modify-syntax-entry ?#  "."    table)
      (modify-syntax-entry ?$  "."    table)
      (modify-syntax-entry ?%  "<"    table) ;; comment
      (modify-syntax-entry ?&  "."    table)
      (modify-syntax-entry ?\' "\""   table) ;; string
      (modify-syntax-entry ?\( "()"   table) ;; open
      (modify-syntax-entry ?\) ")("   table) ;; close
      (modify-syntax-entry ?*  ". 23" table)
      (modify-syntax-entry ?+  "."    table)
      (modify-syntax-entry ?,  "."    table)
      (modify-syntax-entry ?-  "."    table)
      (modify-syntax-entry ?.  "."    table)
      (modify-syntax-entry ?/  ". 14" table)
      (modify-syntax-entry ?:  "."    table)
      (modify-syntax-entry ?;  "."    table)
      (modify-syntax-entry ?<  "."    table)
      (modify-syntax-entry ?=  "."    table)
      (modify-syntax-entry ?>  "."    table)
      (modify-syntax-entry ??  "."    table)
      (modify-syntax-entry ?@  "."    table)
      (modify-syntax-entry ?[  "(]"   table) ;; open
      (modify-syntax-entry ?\\ "."    table)
      (modify-syntax-entry ?]  ")["   table) ;; close
      (modify-syntax-entry ?^  "."    table)
      (modify-syntax-entry ?_  "_"    table)
      (modify-syntax-entry ?`  "."    table)
      (modify-syntax-entry ?\{ "(}"   table) ;; open
      (modify-syntax-entry ?\| "."    table)
      (modify-syntax-entry ?\} "){"   table) ;; close
      (modify-syntax-entry ?~  "."    table)))


;; kl1-mode ǻȤƤ
;; ϥɤΥꤹ롣
;; οͤϥ桼 .emacs եѹǤ롣
(defconst kl1-head-indent-level   0  "*إåλ")
(defconst kl1-guard-indent-level  4  "*ɥλ")
(defconst kl1-body-indent-level   8  "*ܥǥλ")
(defconst kl1-comment-column     40  "ɤα˽񤯥Ȥη֡")


;;-----------------------------------------------------------------------------


(defun kl1-backward-clause (&optional n)
  "δؿϸ point 륯Ƭ point ư롣⤷
ꤵ줿ˤϻꤵ줿ĿΥ˰ư롣(ʤ
kl1-forward-clause ƱͤʰưԤ)"
  (interactive "p")
  (or n (setq n 1))
  (if (< n 0)
      (kl1-forward-clause (- 0 n))
    (while (>= (setq n (1- n)) 0)
      (while (and (not (bobp))
		  (kl1-is-point-out-of-clause))
	(skip-chars-backward "\0- ")
	(while (kl1-is-point-in-comment)
	  (search-backward "%" nil 'move)))
      (while (not (kl1-is-point-out-of-clause))
	(backward-char)
	(skip-chars-backward "^\0- ")
	(while (kl1-is-point-in-comment)
	  (search-backward "%" nil 'move))))))


(defun kl1-forward-clause (&optional n)
  "δؿϸ point 륯κǸ point ư롣⤷
ꤵ줿ˤϻꤵ줿ĿΥ˰ư롣(ʤ
kl1-backward-clause ƱͤʰưԤ)"
  (interactive "p")
  (or n (setq n 1))
  (if (< n 0)
      (kl1-backward-clause (- 0 n))
    (while (>= (setq n (1- n)) 0)
      (while (and (not (eobp))
		  (kl1-is-point-out-of-clause))
	(cond
	 ((looking-at "[\0- ]")
	  (skip-chars-forward "\0- "))
	 ((looking-at "%")
	  (end-of-line)
	  (skip-chars-forward "\0- "))
	 (t
	  (forward-char))))
      (while (and (< (point) (point-max))
		  (not (kl1-is-point-out-of-clause)))
	(cond
	 ((looking-at "[\0- ]")
	  (forward-char))
	 ((looking-at "%")
	  (end-of-line)
	  (skip-chars-forward "\0- "))
	 (t
	  (skip-chars-forward "^\0- ")))))))


(defun kl1-kill-clause (&optional n)
  "δؿϸ point 륯롣⤷ꤵ줿
ˤϻꤵ줿Ŀ˥롣(ʤ
롣)"
  (interactive "p")
  (or n (setq n 1))
  (save-excursion
    (let ((p0 (point)) p1 p2)
      (cond
       ((> n 0)
	(kl1-forward-clause)
	(kl1-backward-clause)
	(setq p1 (point))
	(kl1-forward-clause n)
      	(setq p2 (point))
	(if (and (<= p1 p0) (< p0 p2)) (kill-region p1 p2)))
       ((< n 0)
	(kl1-backward-clause)
	(kl1-forward-clause)
	(setq p2 (point))
	(kl1-backward-clause (- 0 n))
      	(setq p1 (point))
	(if (and (<= p1 p0) (< p0 p2)) (kill-region p1 p2)))))))


(defun kl1-what-clause ()
  "δؿϸ point 륯Υ⥸塼̾, Ҹ̾, ƥĴ١
ߥ˥Хåեɽ롣Ʊˡ mod:pred/arity η kill-
ring ˥֤롣ctrl-Y ǼФȤǤ롣"
  (interactive)
  (save-excursion
    (let ((p0 (point)) p1 p2 msg
	  (module nil) pred arity (a0 nil) (a1 nil) (a2 nil))
      (message "This predicate is ...")
      (kl1-forward-clause)
      (setq p2 (point))
      (kl1-backward-clause)
      (setq p1 (point))
      (if (or (> p1 p0) (>= p0 p2))
	  (error "Point is not on KL1 clause !!"))
      (if (looking-at ":-")
	  (error "Point is on directive clause !!"))
      (skip-chars-forward "^a-zA-Z0-9_'")
      (setq p0 (point))
      (if (= (char-after (point)) ?')
	  (while (= (char-after (point)) ?')
	    (forward-char)
	    (skip-chars-forward "^'")
	    (forward-char))
	(skip-chars-forward "a-zA-Z0-9_"))
      (setq pred (buffer-substring p0 (point)))
      (message "This predicate is ... %s" pred)
      (setq arity (if (= (char-after (point)) ?\() (kl1-count-argument) 0))
      (message "This predicate is ... %s/%d" pred arity)
      (setq a0 (looking-at "[\0- ]*-->"))
      (if a0
	  (progn
	    (message "This predicate is ... %s/%d+" pred arity)
	    (while (and (null a2) (search-backward "local_implicit" nil t))
	      (if (and (not (kl1-is-point-in-string))
		       (eq (kl1-where-is-point) 'directive))
		  (setq a2 (kl1-count-implicit-argument))))
	    (goto-char (point-min))
	    (while (and (null a1) (re-search-forward "[^_]implicit" nil t))
	      (if (and (not (kl1-is-point-in-string))
		       (eq (kl1-where-is-point) 'directive))
		  (setq a1 (kl1-count-implicit-argument))))))
      (if a1 (setq arity (+ arity a1)))
      (if a2 (setq arity (+ arity a2)))
      (message "This predicate is ... %s/%d" pred arity)
      (goto-char (point-min))
      (while (and (null module) (search-forward "module" nil t))
	(if (and (not (kl1-is-point-in-string))
		 (eq (kl1-where-is-point) 'directive))
	    (progn
	      (skip-chars-forward "^a-zA-Z0-9_'")
	      (setq p0 (point))
	      (if (= (char-after (point)) ?')
		  (while (= (char-after (point)) ?')
		    (forward-char)
		    (skip-chars-forward "^'")
		    (forward-char))
		(skip-chars-forward "a-zA-Z0-9_"))
	      (setq module (buffer-substring p0 (point))))))
      (if (null module)
	  (error "Module name is not found !!"))
      (setq msg (concat module ":" pred "/" arity))
      (setq kill-ring (cons msg kill-ring))
      (setq kill-ring-yank-pointer kill-ring)
      (message "%s" msg))))

(defun kl1-count-argument ()
  (let ((count 1) (level 0) ch)
    (forward-char)
    (while (and (not (eobp)) (>= level 0))
      (skip-chars-forward "^,(){}[]'\"")
      (setq ch (char-after (point)))
      (cond
       ((= ch ?,)  (if (= level 0) (setq count (1+ count))))
       ((= ch ?\() (setq level (1+ level)))
       ((= ch ?\)) (setq level (1- level)))
       ((= ch ?\{) (setq level (1+ level)))
       ((= ch ?\}) (setq level (1- level)))
       ((= ch ?\[) (setq level (1+ level)))
       ((= ch ?\]) (setq level (1- level)))
       ((= ch ?\') (forward-char) (skip-chars-forward "^'"))
       ((= ch ?\") (forward-char) (skip-chars-forward "^\"")))
      (forward-char))
    count))

(defun kl1-count-implicit-argument ()
  (save-excursion
    (let ((count 0) (f t) ch)
      (while (and (not (eobp)) f)
	(skip-chars-forward "^:.'\"%")
	(setq ch (char-after (point)))
	(cond
	 ((= ch ?:)
	  (cond
	   ((looking-at ":[\0- ]*shared[,.%\0- ]") (setq count (1+ count)))
	   ((looking-at ":[\0- ]*stream[,.%\0- ]") (setq count (1+ count)))
	   ((looking-at ":[\0- ]*oldnew[,.%\0- ]") (setq count (+ count 2)))))
	 ((= ch ?.)  (setq f nil))
	 ((= ch ?\') (forward-char) (skip-chars-forward "^'"))
	 ((= ch ?\") (forward-char) (skip-chars-forward "^\""))
	 ((= ch ?%) (end-of-line)))
	(forward-char))
      count)))


(defun kl1-is-point-out-of-clause ()
  "δؿ point γ(ΤˤϡΥν \". \"
μʸ point Τ륯κǽʸޤ)ˤ뤫Ĵ٤롣ơ
⤷ˤˤ t 򡢤Ǥʤˤ nil ֤"
  (save-excursion
    (let ((cp (point)))
      (skip-chars-backward "\0- ")
      (while (kl1-is-point-in-comment)
	(search-backward "%" nil 'move)
	(skip-chars-backward "\0- "))
      (or (= (point) (point-min))
	  (if (= (point) (1+ (point-min)))
	      (and (< (point) cp)
		   (string-match "\\.[\0- %]"
				 (buffer-substring (- (point) 1)
						   (+ (point) 1)))
		   t)
	    (and (< (point) cp)
		 (string-match "[^#$&*+--/:-@\\\\^`~]\\.[\0- %]"
			       (buffer-substring (- (point) 2)
						 (+ (point) 1)))
		 t))))))


(defun kl1-is-point-in-string ()
  "δؿ point (ȥ󥰤˻Ȥ \" ޤϥȥ˻Ȥ ' )˰Ϥ
줿ϰˤ뤫Ĵ٤롣ơ⤷Ϥޤ줿ϰˤˤ t 
ϰϳξˤ nil ֤ޤˤˤɬ nil ֤"
  (save-excursion
    (let ((cpoint (point)) mstr)
      (beginning-of-line)
      (catch 'comment-check-loop
	(while (re-search-forward "[\"'%]" cpoint 'move)
	  (setq mstr (buffer-substring (match-beginning 0) (match-end 0)))
	  (if (string-equal mstr "%")
	      (throw 'comment-check-loop nil))
	  (or (search-forward mstr cpoint 'move)
	      (throw 'comment-check-loop t)))
	nil))))


(defun kl1-is-point-in-comment ()
  "δؿ point  % ǻϤޤ륳ˤ뤫Ĵ٤롣ơ⤷
ˤˤ t 򡢥ȳξˤ nil ֤"
  (save-excursion
    (let ((cpoint (point)) mstr)
      (beginning-of-line)
      (catch 'string-check-loop
	(while (re-search-forward "[\"'%]" cpoint 'move)
	  (setq mstr (buffer-substring (match-beginning 0) (match-end 0)))
	  (if (string-equal mstr "%")
	      (throw 'string-check-loop t))
	  (or (search-forward mstr cpoint 'move)
	      (throw 'string-check-loop nil)))
	nil))))


(defun kl1-where-is-point ()
  "δؿ point KL1ΥץΤɤʬˤ뤫Ĵ٤롣ơ
֤ˤʲΤ褦(ȥ)֤
	إå : head		ʸ : string
	 : guard	 : comment
	ܥǥ : body		ؼ	   : directive"
  (save-excursion
    (if (kl1-is-point-in-comment) 'comment
      (if (kl1-is-point-in-string) 'string
	(let ((flag nil) (stack nil) mstr)
	  (catch 'syntax-check-loop
	    (while (re-search-backward
		    "[^#$&*+--/:-@\\\\^`~]\\.[\0- ]\\|[][(){}|'\"]\\|:-\\|-->"
		    nil 'move)
	      (setq mstr (buffer-substring (match-beginning 0) (match-end 0)))
	      (if (kl1-is-point-in-comment)
		  (search-backward "%" nil 'move)
		(cond
		 ((string-match "^[]})]$" mstr)
		  (setq stack (cons flag stack))
		  (setq flag nil))
		 ((string-match "^[[{(]$" mstr)
		  (setq flag (if stack (car stack)))
		  (setq stack (if stack (cdr stack))))
		 ((string-equal mstr "'")
		  (if (kl1-is-point-in-string)
		      (search-backward "'" nil 'move)))
		 ((string-equal mstr "\"")
		  (if (kl1-is-point-in-string)
		      (search-backward "\"" nil 'move)))
		 ((string-equal mstr "|")
		  (or flag (setq flag 'body)))
		 ((string-equal mstr ":-")
		  (or flag
		      (setq flag (if (kl1-is-point-out-of-clause)
				     'directive 'guard))))
		 ((string-equal mstr "-->")
		  (or flag (setq flag 'guard)))
		 (t
		  (throw 'syntax-check-loop (or flag 'head))))))
	    (or flag 'head)))))))


(defun kl1-get-indent-column ()
  "δؿ point ΤԤˡܤޤǻɤ
׻롣λʲ򻲾Ȥ֤׻롣
        kl1-head-indent-level  : إåλ
        kl1-guard-indent-level : ɥλ
        kl1-body-indent-level  : ܥǥλ
ޤҸ乽¤ΤǲԤƤˤϡ ( { [ ΰ֤
˻֤׻롣"
  (save-excursion
    (beginning-of-line)
    (let ((level nil) (stack nil) mstr)
      (catch 'syntax-check-loop
	(while (re-search-backward
		"[^#$&*+--/:-@\\\\^`~]\\.[\0- ]\\|[][(){}|'\"]\\|:-\\|-->"
		nil 'move)
	  (setq mstr (buffer-substring (match-beginning 0) (match-end 0)))
	  (if (kl1-is-point-in-comment)
	      (search-backward "%" nil 'move)
	    (cond
	     ((string-match "^[]})]$" mstr)
	      (setq stack (cons level stack))
	      (setq level nil))
	     ((string-match "^[[{(]$" mstr)
	      (if (null stack)
		  (progn
		    (forward-char)
		    (if (not (looking-at "[ \t]+$\\|[ \t]+%"))
			(skip-chars-forward " \t"))
		    (throw 'syntax-check-loop (current-column))))
	      (setq level (car stack))
	      (setq stack (cdr stack)))
	     ((string-equal mstr "'")
	      (if (kl1-is-point-in-string)
		  (search-backward "'" nil 'move)))
	     ((string-equal mstr "\"")
	      (if (kl1-is-point-in-string)
		  (search-backward "\"" nil 'move)))
	     ((string-equal mstr "|")
	      (or level (setq level kl1-body-indent-level)))
	     ((string-equal mstr ":-")
	      (or level
		  (setq level (if (kl1-is-point-out-of-clause)
				  (progn (forward-word 1)
					 (skip-chars-forward "A-Za-z_")
					 (skip-chars-forward " \t")
					 (current-column))
				kl1-guard-indent-level))))
	     ((string-equal mstr "-->")
	      (or level (setq level kl1-guard-indent-level)))
	     (t
	      (throw 'syntax-check-loop
		     (or level kl1-head-indent-level))))))
	(or level kl1-head-indent-level)))))


(defun kl1-indent-line ()
  "δؿ point ΤԤλԤϴؿ kl1-get-indent-
column ˤ׻줿ͤѤ롣ޤKL1ɤκ¦˥Ȥ
ˤϤΰ֤ؿ kl1-get-comment-column ˤ׻줿֤˰ư
롣"
  (interactive)
  (let ((indent (kl1-get-indent-column)) start)
    (save-excursion
      (beginning-of-line)
      (setq start (point))
      (skip-chars-forward " \t")
      (delete-region start (point))
      (indent-to-column indent))
    (if (> indent (current-column))
	(move-to-column indent))
    (save-excursion
      (end-of-line)
      (if (kl1-is-point-in-comment)
	  (kl1-indent-comment)))))


(defun kl1-get-comment-column ()
  "δؿ point ΤԤ˴ؤƥȤγϰ֤׻롣⤷ι
ԤޤϥȤιԤǤСξιԤĴ١˥Ȥ
Сϰ֤򤽤ΰ֤˹碌ʤСϰ֤ؿ kl1-get-indent-
column Ƿ׻줿(̾KL1ɤλ)ƱȤ롣ޤ
⤷ιԤ˰̤KL1ɤˤѿ comment-column ǻꤵ줿
(ͤ kl1-comment-column Ϳ졢ޥ M-X set-comment-
column ˤѹǽ)ȤιԤKL1ɤαüη+1Ȥ礭
롣"
  (save-excursion
    (beginning-of-line)
    (if (looking-at "[ \t]*$\\|[ \t]*%")
	(if (not (bobp))
	    (progn (backward-char)
		   (if (kl1-is-point-in-comment)
		       (progn (while (kl1-is-point-in-comment)
				(search-backward "%" nil 'move))
			      (current-column))
		     (forward-char)
		     (kl1-get-indent-column)))
	  (kl1-get-indent-column))
      (end-of-line)
      (while (kl1-is-point-in-comment)
	(search-backward "%" nil 'move))
      (skip-chars-backward " \t")
      (max (1+ (current-column))
	   comment-column))))


(defun kl1-indent-comment ()
  "δؿ point ΤԤ˴ؤƥդνԤ⤷ιԤ˥
Ȥʤäˤϡؿ kl1-get-comment-column ˤ׻줿֤
Ȥꡢ point ư롣ޤ⤷ιԤ˴˥Ȥ
ˤϡΥȤΰ֤ƱؿǷ׻줿֤˰ư
ΥʸλϤޤ point ư롣"
  (interactive)
  (end-of-line)
  (if (kl1-is-point-in-comment)
      (while (kl1-is-point-in-comment)
	(search-backward "%" nil 'move))
    (insert "% ")
    (backward-char 2))
  (let ((indent (kl1-get-comment-column)) end)
    (setq end (point))
    (skip-chars-backward " \t")
    (delete-region (point) end)
    (indent-to-column indent)
    (skip-chars-forward "%")
    (skip-chars-forward " \t")))


(defun kl1-encomment (start end)
  "δؿϻꤵ줿꡼γƹԤ򥳥Ȥˤ롣"
  (interactive "r")
  (save-excursion
    (save-restriction
      (goto-char end)
      (if (bolp) (setq end (1- end)))
      (narrow-to-region start end)
      (kl1-untabify (point-min) (point-max))
      (goto-char (point-min))
      (replace-regexp "^" "% ")
      (kl1-tabify (point-min) (point-max)))))


(defun kl1-decomment (start end)
  "δؿϻꤵ줿꡼γƥȹ(kl1-emcomment 줿)
᤹"
  (interactive "r")
  (save-excursion
    (save-restriction
      (goto-char end)
      (if (bolp) (setq end (1- end)))
      (narrow-to-region start end)
      (kl1-untabify (point-min) (point-max))
      (goto-char (point-min))
      (replace-regexp "^% ?\\(.*\\)$" "\\1")
      (kl1-tabify (point-min) (point-max)))))


(defun kl1-untabify (start end)
  "δؿϻη֤Ѥˡꤵ줿꡼ TAB ʣΥ
ڡŸ롣"
  (interactive "r")
  (untabify start end))


(defun kl1-tabify (start end)
  "δؿϻη֤Ѥˡꤵ줿꡼ʣΥڡ
Ǥ TAB Ѵ롣KL1Υȥ󥰤䥢ȥѴʤ"
  (interactive "r")
  (save-excursion
    (save-restriction
      (goto-char end)
      (while (kl1-is-point-in-string)
	(re-search-backward "['\"]" nil 'move))
      (setq end (point))
      (goto-char start)
      (while (kl1-is-point-in-string)
	(re-search-forward "['\"]" nil 'move))
      (setq start (point))
      (if (< start end)
	  (progn
	    (narrow-to-region start end)
	    (while (re-search-forward " +[ \t]\\|[\"']" nil t)
	      (let* ((cp (match-beginning 0))
		     (ch (char-after cp)))
		(cond
		 ((= ch ? )
		  (let ((column (current-column))
			(indent-tabs-mode t))
		    (delete-region cp (point))
		    (indent-to column)))
		 ((= ch ?\")
		  (re-search-forward "[\\\"]" nil t)
		  (while (= (char-after (match-beginning 0)) ?\\)
		    (forward-char)
		    (re-search-forward "[\\\"]" nil t)))
		 ((= ch ?\')
		  (re-search-forward "[\\']" nil t)
		  (while (= (char-after (match-beginning 0)) ?\\)
		    (forward-char)
		    (re-search-forward "[\\']" nil t)))))))))))
