/******************************************************************************
     jLaTeX $BMQ(B $BF|K\8lBP1~(B $B:w0z:n@.(B $B%3%^%s%I(B --- jmakeindex    (5/26,1989)
*******************************************************************************

                    jLaTeX$B$K$h$k:w0z$N:n@.(B: jmakeindex
                   ====================================

  jLaTeX$B$N%I%-%e%a%s%H$G:w0z$r:n$k0Y$K!"(Bjmakeindex $B$H$$$&%3%^%s%I$r:n$j$^$7$?!#(B
$B$3$l$O!"1Q8lHG$N(B makeindex $B%3%^%s%I$N;EMM$r;29M$K$7$^$7$?!#(Bmakeindex $B%3%^%s%I(B
$B$O(B ICOT $B$K$OL5$$$h$&$J$N$G!";H$$J}$N%I%-%e%a%s%H(B( .../macros/makeindex.tex )
$B$@$1$r;29M$K$7$^$7$?!"$=$N0Y!"%3%s%Q%A$K$J$C$F$$$J$$ItJ,$b$"$j$^$9!#(B


1. jLaTeX $B$N%=!<%9!&%U%!%$%k(B
----------------------------

  $B:w0z$r:n$k0Y$K$O!"(Bmakeidx $B$H$$$&%9%?%$%k%U%!%$%k$rMxMQ$7$^$9!#=>$C$F!"(BjLaTeX
$B%=!<%9$N(B documentstyle $B$r<!$N$h$&$K@k8@$7$^$9!#(B

        \documentstyle[makeidx]{jarticle}
                       ^^^^^^^
$B$^$?!"(Bdocumentstyle $B$N@k8@$H(B \begin{document} $B$N4V$K!"(B

        \makeindex

$B$H$$$&@k8@$r$9$kI,MW$,$"$j$^$9!#(B

  $B0J>e$G!":w0z$r:n$k0Y$N=`Hw$,$G$-$?$N$G!":w0z$KF~$l$k$Y$-3F%-!<%o!<%I$N=j$K!"(B
\index $B%3%^%s%I$rA^F~$7$^$9!#$3$N7A<0$O!"0J2<$N$h$&$K$7$^$9!#(B

        \index{alphabet}
        \index{index!subindex}              ... `!' $B$G6h@Z$k;v$K$h$j(B3$B%l%Y%k(B
        \index{index!subindex!subsubindex}      $B$^$G;XDj$G$-$k!#(B
	\index{$\alpha$}                    ... $B5-9f$N>l9g!#(B
        \index{alpha@$\alpha$}              ... alpha $B$N=j$K!"&A$HI=<($9$k!#(B
        \index{$B$+$s$8(B@$B4A;z(B}                 ... $B4A;z$N>l9g$OFI$_$,I,MW!#(B
        \index{$B$+$s$8(B@$B4A;z(B!$B$+$s$8(B@$B4A;z(B}
        \index{$B%$%s%G%C%/%9(B}                ... $B2>L>$N>l9g!#(B
        \index{index|(}                     ... 3-5 $B$N$h$&$J7A<0$G%Z!<%8?t$r(B
        \index{index|)}                         $BI=<($9$k>l9g!#(B

  $B:G8e$K!":w0z$r:n$k=j$K!"0J2<$N%3%^%s%I$rA^F~$7$^$9!#(B

        \printindex


2. jLaTeX $B$N<B9T<j=g(B
--------------------

foo.tex $B$,%=!<%9%U%!%$%k$N>l9g$K$O!"<!$N$h$&$J<j=g$r<B9T$9$k!#(B

(1)  jlatex foo [return] $B$r(B1$B2s0J>e<B9T$9$k!#(B
     $BJ#?t2s9T$&$N$O!"L\<!$J$I$K$h$j!"%Z!<%8?t$,$:$l$?>l9g!#(B

(2)  jlameindex foo [return] $B$r9T$&!#(B
     $B$3$l$K$h$j!"(Bfoo.idx $B$+$i!"(Bfoo.ind $B$r:n@.$9$k!#(B
     $B:w0z$N9`L\$O$3$3$G%=!<%H$5$l$k!#(B
     $B$3$3$G!"(B-d $B$N%*%W%7%g%s$rIU$1$k$H8+=P$7$H%Z!<%8$N4V$,(B ..... $B$G6h@Z$i$l$k!#(B

(3)  jlatex foo [return] $B$r(B1$B2s0J>e<B9T$9$k!#(B
     $BJ#?t2s9T$&$N$O!":w0z$r:n$C$?;v$K$h$j!"L\<!$NJQ99$,I,MW$J>l9g!#(B

(4)  $B0u:~$9$k!#(B

******************************************************************************/

#include <stdio.h>
#include <ctype.h>

#define YES 1
#define NO  0
#define ESC 27
#define BUFLEN 1024

struct entry_rec{
    struct entry_rec *next;
    short *style;
    short *page;
    short body[2];
};

#define AllocEntry(n)\
  (struct entry_rec *)malloc(sizeof(struct entry_rec)+((n)-2)*sizeof(short))

struct index_rec{
    struct index_rec *prev;
    struct index_rec *next;
    struct index_rec *entries;
    struct index_rec *subindex;
    int class;
    short *key;
    short *string;
    short body[2];
} *root;

#define AllocIndex(n)\
  (struct index_rec *)malloc(sizeof(struct index_rec)+((n)-2)*sizeof(short))

int to_kanji = 0;
int to_alpha = 0;

char *separator = ", ";

main(argc, argv)
    int argc; 
    char **argv;
{
    char *name;
    if(argc == 3 && argv[1][0] == '-' && argv[1][1] == 'd'){
	separator = " \\dotfill\\ ";
	name = argv[2];
    }else if(argc != 2){
	printf("Usage: %s [ -d ] file.idx\n", argv[0]);
	exit(-1);
    }else{
	name = argv[1];
    }
    if(strcmp(&name[strlen(name)-4], ".sav") == 0){
	name[strlen(name)-4] = '\0';
    }
    read_idx(name);
    write_ind(name);
    exit(0);
}


/*****************************************************************************
  .idx $B%U%!%$%k$NFI$_9~$_(B $B$H(B \indexentry $B$N3F0z?t$N%U%#!<%k%I$N@Z$jJ,$1!#(B
*****************************************************************************/

short line[BUFLEN];
int line_no = 0;

read_idx(name)
    char *name;
{
    FILE *fp;
    short buf[BUFLEN*2];
    short *p, *q, *r;
    short *key, *str;
    short *style, *page;
    struct index_rec *index1, *index2, *index3;
    struct entry_rec *entry;
    sprintf(buf, "%s.idx", name);
    if((fp = fopen(buf, "r")) == NULL){
	printf("Cannot oprn file: %s\n", buf);
	exit(-1);
    }
    while(read_line(fp)){
	if(line[ 0] != '\\' ||
	   line[ 1] != 'i'  ||
	   line[ 2] != 'n'  ||
	   line[ 3] != 'd'  ||
	   line[ 4] != 'e'  ||
	   line[ 5] != 'x'  ||
	   line[ 6] != 'e'  ||
	   line[ 7] != 'n'  ||
	   line[ 8] != 't'  ||
	   line[ 9] != 'r'  ||
	   line[10] != 'y'  ||
	   line[11] != '{'){
	    read_error("No \\indexentry in line %d.\n");
	}
	p = line+12;
	q = buf;
	key = r = q; cut_out(&p, &q, 00000); *q++ = 0;
	if(*p == '@'){
	    p++;
	    str = q; cut_out(&p, &q, 01000); *q++ = 0;
	    index1 = AllocIndex((q-r)+(str-r));
	    index1->class = class(key[0]);
	    index1->key = &(index1->body[0]);
	    conv(key, &(index1->body[0]));
	    index1->string = &(index1->body[(str-r)*2]);
	    copy(str, &(index1->body[(str-r)*2]));
	}else{
	    index1 = AllocIndex((q-r)*3);
	    index1->class = class(key[0]);
	    index1->key = &(index1->body[0]);
	    conv(key, &(index1->body[0]));
	    index1->string = &(index1->body[(q-r)*2]);
	    copy(key, &(index1->body[(q-r)*2]));
	}
	if(*p == '!'){
	    p++;
	    key = r = q; cut_out(&p, &q, 00000); *q++ = 0;
	    if(*p == '@'){
		p++;
		str = q; cut_out(&p, &q, 01000); *q++ = 0;
		index2 = AllocIndex((q-r)+(str-r));
		index2->key = &(index2->body[0]);
		conv(key, &(index2->body[0]));
		index2->string = &(index2->body[(str-r)*2]);
		copy(str, &(index2->body[(str-r)*2]));
	    }else{
		index2 = AllocIndex((q-r)*3);
		index2->key = &(index2->body[0]);
		conv(key, &(index2->body[0]));
		index2->string = &(index2->body[(q-r)*2]);
		copy(key, &(index2->body[(q-r)*2]));
	    }
	    if(*p == '!'){
		p++;
		key = r = q; cut_out(&p, &q, 00100); *q++ = 0;
		if(*p == '@'){
		    p++;
		    str = q; cut_out(&p, &q, 01100); *q++ = 0;
		    index3 = AllocIndex((q-r)+(str-r));
		    index3->key = &(index3->body[0]);
		    conv(key, &(index3->body[0]));
		    index3->string = &(index3->body[(str-r)*2]);
		    copy(str, &(index3->body[(str-r)*2]));
		}else{
		    index3 = AllocIndex((q-r)*3);
		    index3->key = &(index3->body[0]);
		    conv(key, &(index3->body[0]));
		    index3->string = &(index3->body[(q-r)*2]);
		    copy(key, &(index3->body[(q-r)*2]));
		}
	    }else{
		index3 = NULL;
	    }
	}else{
	    index2 = index3 = NULL;
	}
	r = q;
	if(*p == '|'){
	    p++;
	    style = q; cut_out(&p, &q, 01110); *q++ = 0;
	}else{
	    style = NULL;
	}
	if(p[0] != '}' || p[1] != '{'){
	    read_error("Unknown sequence in line %d.\n");
	}
	p += 2;
	page = q; cut_out(&p, &q, 01110); *q++ = 0;
	if(p[0] != '}' || p[1] != 0){
	    read_error("Unknown sequence in line %d.\n");
	}
	entry = AllocEntry(q-r);
	if(style){
	    entry->style = &(entry->body[style-r]);
	    copy(style, &(entry->body[style-r]));
	}else{
	    entry->style = NULL;
	}
	entry->page = &(entry->body[page-r]);
	copy(page, &(entry->body[page-r]));
	enter_index(index1, index2, index3, entry);
    }
    fclose(fp);
}

cut_out(from, to, s)
    short **from, **to;
    int s;
{
    short *p, *q;
    p = *from; q = *to;
    for(;;){
	switch(*p){
	  case '\\':
	    if(p[1] == 'v' &&
	       p[2] == 'e' &&
	       p[3] == 'r' &&
	       p[4] == 'b' &&
	       ispunct(p[5])){
		int c = p[5];
		*q++ = *p++; *q++ = *p++; *q++ = *p++;
		*q++ = *p++; *q++ = *p++; *q++ = *p++;
		while(*p != c){
		    if(*p == 0){
			read_error("Illegal \\verb format in line %d.\n");
		    }
		    *q++ = *p++;
		}
		*q++ = *p++;
	    }else if(isalnum(p[1]) || p[1] == '@'){
		*q++ = *p++;
		*q++ = *p++;
		while(isalnum(*p) || *p == '@'){
		    *q++ = *p++;
		}
	    }else{
		*q++ = *p++;
		if(*p == 0){
		    read_error("Illegal format in line %d.\n");
		}
		*q++ = *p++;
	    }
	    continue;
	  case '"':
	    *q++ = *p++;
	    if(*p == 0){
		read_error("Illegal format in line %d.\n");
	    }
	    *q++ = *p++;
	    continue;
	  case '{':
	    *q++ = *p++;
	    cut_out(&p, &q, 011110);
	    if(*p != '}'){
		read_error("Mismatch { } in line %d.\n");
	    }
	    *q++ = *p++;
	    continue;
	  case '@':
	    if(s&01000) goto next; else goto done;
	  case '!':
	    if(s&00100) goto next; else goto done;
	  case '|':
	    if(s&00010) goto next; else goto done;
	  case '}':
	    if(s&00001) goto next;
	  done:
	    if((s&010000) == 0 && *from == p) goto error;
	    *from = p; *to = q;
	    return;
	  case 0:
	  error:
	    read_error("Illegal format in line %d.\n");
	  default:
	  next:
	    *q++ = *p++;
	    continue;
	}
    }
}

read_line(fp)
    FILE *fp;
{
    register int c, cc;
    register short *p, *q;
    line_no++;
    p = line; q = p+BUFLEN;
    while(p<q){
	c = getc(fp);
	if(c >= ' ' && c <= '~'){
	    /** ALPHA **/
	    *p++ = c;
	    continue;
	}
	if(c >= 0xA1 && c <= 0xFE){
	    /** EUC **/
	    cc = getc(fp);
	    if(cc >= 0xA1 && cc <= 0xFE){
		*p++ = ((c<<8)|cc)&0x7F7F;
		continue;
	    }else{
		*p = 0;
		read_error("Illegal EUC code in line %d.\n");
	    }
	}
	if(c == '\n'){
	    *p = 0;
	    return(YES);
	}
	if(c == EOF){
	    if(p > line){
		*p = 0;
		read_error("Unexpected EOF in %d.\n");
	    }
	    return(NO);
	}
	if(c == ESC && getc(fp) == '$'){
	    c = getc(fp);
	    if(c == '@' || c == 'B'){
		/** JIS-KANJI **/
		to_kanji = c;
		for(;;){
		    if(p >= q) goto too_long;
		    c = getc(fp); cc = getc(fp);
		    if(c >= 0x21 && c <= 0x7E && cc >= 0x21 && cc <= 0x7E){
			*p++ = ((c<<8)|cc)&0x7F7F;
			continue;
		    }
		    if(c == ESC && cc == '('){
			c = getc(fp);
			if(c == 'J' || c == 'H' || c == 'B'){
			    to_alpha = c;
			    break;
			}
		    }
		    *p = 0;
		    read_error("Illegal KANJI code in line %d.\n");
		}
		continue;
	    }
	}
	*p = 0;
	read_error("Illegal control code in line %d.\n");
    }
  too_long:
    *p = 0;
    read_error("Line %d is too long.\n");
}

read_error(msgs)
    char *msgs;
{
    printf(msgs, line_no);
    putstr(line, stdout);
    putchar('\n');
    exit(-1);
}

copy(p, q)
    register short *p, *q;
{
    while(*p) *q++ = *p++;
    *q = 0;
}


/*****************************************************************************
  $BFI$_9~$^$l$?%(%s%H%j$r<-=q=g$KJB$Y49$(!"5-21$9$k!#(B
*****************************************************************************/

enter_index(index1, index2, index3, entry)
    struct index_rec *index1, *index2, *index3;
    struct entry_rec *entry;
{
    struct index_rec **p;
    p = &root;
    while(*p){
	switch(compare(index1->key, (*p)->key)){
	  case -1:
	  prev:
	    p = &((*p)->prev);
	    continue;
	  case 0:
	    switch(compare(index1->string, (*p)->string)){
	      case -1:
		goto prev;
	      case 0:
		if(index2){
		    enter_index2(&((*p)->subindex), index2, index3, entry);
		}else{
		    enter_index4(&((*p)->entries), entry);
		}
		free(index1);
		return;
	      case 1:
		goto next;
	    }
	  case 1:
	  next:
	    p = &((*p)->next);
	    continue;
	}
    }
    *p = index1;
    index1->prev = NULL;
    index1->next = NULL;
    index1->subindex = NULL;
    index1->entries = NULL;
    if(index2){
	enter_index2(&((*p)->subindex), index2, index3, entry);
    }else{
	enter_index4(&((*p)->entries), entry);
    }
}

enter_index2(p, index2, index3, entry)
    struct index_rec **p, *index2, *index3;
    struct entry_rec *entry;
{
    while(*p){
	switch(compare(index2->key, (*p)->key)){
	  case -1:
	  prev:
	    p = &((*p)->prev);
	    continue;
	  case 0:
	    switch(compare(index2->string, (*p)->string)){
	      case -1:
		goto prev;
	      case 0:
		if(index3){
		    enter_index3(&((*p)->subindex), index3, entry);
		}else{
		    enter_index4(&((*p)->entries), entry);
		}
		free(index2);
		return;
	      case 1:
		goto next;
	    }
	  case 1:
	  next:
	    p = &((*p)->next);
	    continue;
	}
    }
    *p = index2;
    index2->prev = NULL;
    index2->next = NULL;
    index2->subindex = NULL;
    index2->entries = NULL;
    if(index3){
	enter_index3(&((*p)->subindex), index3, entry);
    }else{
	enter_index4(&((*p)->entries), entry);
    }
}

enter_index3(p, index3, entry)
    struct index_rec **p, *index3;
    struct entry_rec *entry;
{
    while(*p){
	switch(compare(index3->key, (*p)->key)){
	  case -1:
	  prev:
	    p = &((*p)->prev);
	    continue;
	  case 0:
	    switch(compare(index3->string, (*p)->string)){
	      case -1:
		goto prev;
	      case 0:
		enter_index4(&((*p)->entries), entry);
		free(index3);
		return;
	      case 1:
		goto next;
	    }
	  case 1:
	  next:
	    p = &((*p)->next);
	    continue;
	}
    }
    *p = index3;
    index3->prev = NULL;
    index3->next = NULL;
    index3->subindex = NULL;
    index3->entries = NULL;
    enter_index4(&((*p)->entries), entry);
}

enter_index4(p, entry)
    struct entry_rec **p, *entry;
{
    while(*p) p = &((*p)->next);
    *p = entry;
    entry->next = NULL;
}

compare(p, q)
    register short *p, *q;
{
    while(*p == *q){
	if(*p == 0) return(0);
	p++; q++;
    }
    return(*p < *q ? -1 : 1);
}


/*****************************************************************************
  $B:w0z$N3F%(%s%H%j$r(B LaTeX $B$N%=!<%k%U%!%$%k(B .ind $B$H$7$F=PNO$9$k!#(B
*****************************************************************************/

write_ind(name)
    char *name;
{
    FILE *fp;
    char fname[1024];
    sprintf(fname, "%s.ind", name);
    if((fp = fopen(fname, "w")) == NULL){
	printf("Cannot create file: %s\n", fname);
	exit(-1);
    }
    fprintf(fp, "\\begin{theindex}\n");
    write_index(root, fp, 0);
    fprintf(fp, "\\end{theindex}\n");
    fclose(fp);
}

write_index(p, fp, last)
    struct index_rec *p;
    FILE *fp;
    int last;
{
    if(p->prev) last = write_index(p->prev, fp, last);
    if(last != p->class){
	short x[2];
	x[0] = p->class; x[1] = 0;
	if(last){ fprintf(fp, "\\indexspace\n\n"); printf("\n"); }
	printf("*** "); putstr(x, stdout); printf(" ***\n");
	last = p->class;
    }
    fprintf(fp, "\\item "); putstr(p->string, fp);
    putstr(p->string, stdout);
    if(p->entries) write_pages(p->entries, fp);
    fprintf(fp, "\n"); printf("\n");
    if(p->subindex) write_index2(p->subindex, fp);
    if(p->next) last = write_index(p->next, fp, last);
    return(last);
}

write_index2(p, fp)
    struct index_rec *p;
    FILE *fp;
{
    if(p->prev) write_index2(p->prev, fp);
    fprintf(fp, "\\subitem "); putstr(p->string, fp);
    printf("  "); putstr(p->string, stdout);
    if(p->entries) write_pages(p->entries, fp);
    fprintf(fp, "\n"); printf("\n");
    if(p->subindex) write_index3(p->subindex, fp);
    if(p->next) write_index2(p->next, fp);
}

write_index3(p, fp)
    struct index_rec *p;
    FILE *fp;
{
    if(p->prev) write_index3(p->prev, fp);
    fprintf(fp, "\\subsubitem "); putstr(p->string, fp);
    printf("    "); putstr(p->string, stdout);
    if(p->entries) write_pages(p->entries, fp);
    fprintf(fp, "\n"); printf("\n");
    if(p->next) write_index3(p->next, fp);
}

write_pages(p, fp)
    struct entry_rec *p;
    FILE *fp;
{
    int fromto = 0;
    short *last = NULL;
    fprintf(fp, "%s", separator);
    while(p){
	switch(check_style(p->style)){
	  case 0:	/** No specified **/
	    if(fromto) goto error;
	    if(last){
		if(compare(p->page, last)){
		    putstr(last, fp); fprintf(fp, ",");
		    last = p->page;
		}
	    }else{
		last = p->page;
	    }
	    break;
	  case 1:	/** ( **/
	    if(fromto) goto error;
	    if(last){
		if(compare(p->page, last)){
		    putstr(last, fp); fprintf(fp, ",");
		    last = p->page;
		}
	    }else{
		last = p->page;
	    }
	    fromto = 1;
	    break;
	  case 2:	/** (command **/
	    if(fromto) goto error;
	    if(last){
		putstr(last, fp); fprintf(fp, ",");
	    }
	    fprintf(fp, "\\"); putstr(&(p->style[1]), fp); fprintf(fp, "{");
	    last = p->page;
	    fromto = 2;
	    break;
	  case 3:	/** ) **/
	    if(!fromto) goto error;
	    if(fromto == 1){
		if(compare(p->page, last)){
		    putstr(last, fp); fprintf(fp, "-");
		    last = p->page;
		}
	    }else{
		putstr(last, fp);
		if(compare(p->page, last)){
		    fprintf(fp, "-"); putstr(p->page, fp);
		}
		fprintf(fp, "}");
		last = NULL;
	    }
	    fromto = 0;
	    break;
	  case 4:	/** command **/
	    if(fromto) goto error;
	    if(last){
		putstr(last, fp); fprintf(fp, ",");
	    }
	    fprintf(fp, "\\"); putstr(p->style, fp);
	    fprintf(fp, "{"); putstr(p->page, fp); fprintf(fp, "}");
	    last = NULL;
	    break;
	  default:
	    printf("Illegal page number style.\n");
	    exit(-1);
	  error:
	    printf("Illegal ( ) sequence.\n");
	    exit(-1);
	}
	p = p->next;
    }
    if(last) putstr(last, fp);
}

check_style(p)
    short *p;
{
    if(p == NULL) return(0);
    if(*p == '('){
	p++;
	if(*p == 0) return(1);
	while(*p){
	    if(*p < 0x100 && !isalnum(*p)) return(-1);
	    p++;
	}
	return(2);
    }
    if(*p == ')'){
	p++;
	if(*p == 0) return(3);
	return(-1);
    }
    if(*p == 0) return(1);
    while(*p && *p != '{'){
	if(*p < 0x100 && !isalnum(*p)) return(-1);
	p++;
    }
    return(4);
}

putstr(p, fp)
    register short *p;
    FILE *fp;
{
    if(*p < 0){
	static short a[] = {'S','y','m','b','o','l',0};
	static short k[] = {0x352D,0x3966,0};	/* $B5-9f(B */
	p = (*p == -1) ? a : k;
    }
    if(to_kanji){
	int f = NO;
	while(*p){
	    if(*p < 0x100){
		if(f){
		    putc(ESC, fp);
		    putc('(', fp);
		    putc(to_alpha, fp);
		    f = NO;
		}
		putc(*p, fp);
	    }else{
		if(!f){
		    putc(ESC, fp);
		    putc('$', fp);
		    putc(to_kanji, fp);
		    f = YES;
		}
		putc((*p>>8)&0x7F, fp);
		putc((*p)&0x7F, fp);
	    }
	    p++;
	}
	if(f){
	    putc(ESC, fp);
	    putc('(', fp);
	    putc(to_alpha, fp);
	}
    }else{
	while(*p){
	    if(*p < 0x100){
		putc(*p, fp);
	    }else{
		putc((*p>>8)|0x80, fp);
		putc((*p)|0x80, fp);
	    }
	    p++;
	}
    }
}


/*****************************************************************************
  $BJ8;z$N<-=q=gHV9f$H<oN`J,$1!#(B
*****************************************************************************/

unsigned char korder[86] = {
    1,  0,       5,  4,       9,  8,      13, 12,      17, 16,         /* $B$"(B */
       20, 22,      24, 26,      28, 30,      32, 34,      36, 38,     /* $B$+(B */
       40, 42,      44, 46,      48, 50,      52, 54,      56, 58,     /* $B$5(B */
       60, 62,      64, 66,  69, 68, 70,      72, 74,      76, 78,     /* $B$?(B */
       80,          84,          88,          92,          96,         /* $B$J(B */
      100,102,103, 104,106,107, 108,110,111, 112,114,115, 116,118,119, /* $B$O(B */
      120,         124,         128,         132,         136,         /* $B$^(B */
  141,140,                  149,148,                  157,156,         /* $B$d(B */
      160,         164,         168,         172,         176,         /* $B$i(B */
  181,180,         184,                      192,         196,         /* $B$o(B */
      200,                       10,          21,          33};        /* $B$s(B */

unsigned char cyo_on[86] = {
    0,  0,       4,  4,       8,  8,      12, 12,      16, 16,         /* $B$"(B */
        0,  0,       4,  4,       8,  8,      12, 12,      16, 16,     /* $B$+(B */
        0,  0,       4,  4,       8,  8,      12, 12,      16, 16,     /* $B$5(B */
        0,  0,       4,  4,   8,  8,  8,      12, 12,      16, 16,     /* $B$?(B */
        0,           4,           8,          12,          16,         /* $B$J(B */
        0,  0,  0,   4,  4,  4,   8,  8,  8,  12, 12, 12,  16, 16, 16, /* $B$O(B */
        0,           4,           8,          12,          16,         /* $B$^(B */
    0,  0,                    8,  8,                   16, 16,         /* $B$d(B */
        0,           4,           8,          12,          16,         /* $B$i(B */
    0,  0,           4,                       12,          16,         /* $B$o(B */
        0,                        8,           0,          12};        /* $B$s(B */

conv(from, to)
    short *from, *to;
{
    register short *p, *q;
    p = from; q = to;
    while(*p){
	if(*p < 0x100){
	    if(*p >= 'A' && *p <= 'Z'){
		*q++ = (*p-'A')+0x7F00;
	    }else if(*p >= 'a' && *p <= 'z'){
		*q++ = (*p-'a')+0x7F00;
	    }else if(*p >= '0' && *p <= '9'){
		*q++ = (*p-'0')+0x7F20;
	    }else if(*p == '-' && p > from){
		p++; continue;
/**	    }else if(*p == '\\'){
		p++; continue; **/
	    }else{
		*q++ = *p+0x7F80;
	    }
	}else if(*p >= 0x2421 && *p <= 0x2473){  /* $B$R$i$,$J(B */
	    *q++ = (korder[*p-0x2421]>>2)+0x80;
	}else if(*p >= 0x2521 && *p <= 0x2576){  /* $B%+%?%+%J(B */
	    *q++ = (korder[*p-0x2521]>>2)+0x80;
	}else if(*p == 0x213C && p > from){  /* $B!<(B */
	    p--;
	    if(*p >= 0x2421 && *p <= 0x2473){  /* $B$R$i$,$J(B */
		*q++ = (cyo_on[*p-0x2421]>>2)+0x80;
	    }else if(*p >= 0x2521 && *p <= 0x2576){  /* $B%+%?%+%J(B */
		*q++ = (cyo_on[*p-0x2521]>>2)+0x80;
	    }else{
		*q++ = *(p+1);
	    }
	    p++;
	}else if(*p == 0x2126 && p > from){  /* $B!&(B($BCf9u(B) */
	    p++; continue;
	}else{
	    *q++ = *p;
	}
	p++;
    }
    p = from;
    while(*p){
	if(*p < 0x100){
	    if(*p >= 'A' && *p <= 'Z'){
		*q++ = 1;
	    }else if(*p >= 'a' && *p <= 'z'){
		*q++ = 2;
	    }else if(*p >= '0' && *p <= '9'){
		*q++ = 1;
	    }else if(*p == '-' && p > from){
		p++; continue;
/**	    }else if(*p == '\\'){
		p++; continue; **/
	    }else{
		*q++ = 1;
	    }
	}else if(*p >= 0x2421 && *p <= 0x2473){  /* $B$R$i$,$J(B */
	    *q++ = (korder[*p-0x2421]&3)*2+1;
	}else if(*p >= 0x2521 && *p <= 0x2576){  /* $B%+%?%+%J(B */
	    *q++ = (korder[*p-0x2521]&3)*2+2;
	}else if(*p == 0x213C && p > from){  /* $B!<(B */
	    p--;
	    if(*p >= 0x2421 && *p <= 0x2473){  /* $B$R$i$,$J(B */
		*q++ = 1;
	    }else if(*p >= 0x2521 && *p <= 0x2576){  /* $B%+%?%+%J(B */
		*q++ = 1;
	    }else{
		*q++ = 1;
	    }
	    p++;
	}else if(*p == 0x2126 && p > from){  /* $B!&(B($BCf9u(B) */
	    p++; continue;
	}else{
	    *q++ = 1;
	}
	p++;
    }
    *q = 0;
}

class(c)
    short c;
{
    if(c < 0x100){
	if(c >= 'A' && c <= 'Z'){
	    return(c);
	}else if(c >= 'a' && c <= 'z'){
	    return(toupper(c));
	}else if(c >= '0' && c <= '9'){
	    return(c);
	}else{
	    return(-1);
	}
    }else if(c >= 0x2421 && c <= 0x2473){  /* $B$R$i$,$J(B */
	while(korder[c-0x2421]&3) c--;
	return(c);
    }else if(c >= 0x2521 && c <= 0x2573){  /* $B%+%?%+%J(B-1 */
	while(korder[c-0x2521]&3) c--;
	return(c-0x100);
    }else if(c >= 0x2574 && c <= 0x2576){  /* $B%+%?%+%J(B-2 */
	return(c);
    }else{
	return(-2);
    }
}
