/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>
#include <klic/atomstuffs.h>
#include <stdio.h>
#include <klic/gobj.h>

print_partially(x, depth, length)
     q x;
     unsigned long depth, length;
{
  return fprint_partially(stdout, x, depth, length);
}

fprint_partially(stream, x, depth, length)
     FILE *stream;
     q x;
     unsigned long depth, length;
{
  struct global_variables *glbl = &globals;
  int leng = length;
#ifdef TRACE
  extern int verbose_print;
#endif

  deref_and_switch(x, var, atomic, cons, composite);

 atomic:
  switch (atagof(x)) {
  case INT:
    fprintf(stream, "%d", intval(x));
    return;
  case SYM:
    if (x == NILATOM) {
      fprintf(stream, "[]");
    } else if (x == PERIODATOM) {
      fprintf(stream, ".");
    } else {
      fprintf(stream, "%s", namestringof(x));
    }
    return;
  }

 var:
#ifdef TRACE
  if(!verbose_print || derefone(x) == x){
#endif
    fprintf(stream, "_%X", (q*)x-heaptop);
#ifdef TRACE
  } else {
    q v = derefone(x);
    q *hook = getnexthook(v);
      
    fprintf(stream, "<");
    {
      q *loophook = hook;
      do{
	struct goalrec *g;
	g = ((struct shook *)loophook)->goals;
	verbose_print = 0;
	fprint_goal(stream, g, 0);
	verbose_print = 1;

#ifdef COMMENT
        fprintf(stream, "%x(%x):%d/%d",
		g->pred->func, g, g->pred->pred, g->pred->arity);
	  
	if (g->pred->arity > 0) {
	  unsigned int k;
	    
	  fprintf(stream, "(");
	  k = 0;
	  do{
	    q a = g->args[k];
	    while (isref(a) &&
		   derefone(a) != a &&
		   (!isref(derefone(a)) ||
		    derefone(derefone(a)) != a)) {
	      a = derefone(a);
	    }
	    if (!isref(a)){
	      fprint_partially(stream, g->args[k], depth, length);
	    } else {
	      fprintf(stream, "_%x", a);
	      if (derefone(a) != a &&
		  isref(derefone(a)) &&
		  derefone(derefone(a)) == a)
		fprintf(stream, "*");
	    }
	    if(k < g->pred->arity-1)
	      fprintf(stream, ",");
	  }while(++k<g->pred->arity);
	  fprintf(stream, ")");
	}
#endif
	loophook = getnexthook(loophook);
	fprintf(stream, "->");
      }while((q)loophook != v);
      fprintf(stream, ">");
    }
  }
#endif
  return;
  
  cons:
#ifdef GCDEBUG
    fprintf(stream, " %x", x);
#endif
    fprintf(stream, "[");
    if(depth ==0){
      fprintf(stream, "..]");
      return;
    }
    while (1) {
      fprint_partially(stream, car_of(x), depth-1, length);
      x = cdr_of(x);
      deref_and_switch(x, othercdr, atomiccdr, conscdr, othercdr);
  conscdr:
      fprintf(stream, ",");
      if(--leng) continue;
      fprintf(stream, "..");
      goto listtail;
  }
 atomiccdr:
  if (issym(x) && symval(x) == 0) goto listtail;
 othercdr:
  fprintf(stream, "|");
  fprint_partially(stream, x, depth-1, length);
 listtail:
  fprintf(stream, "]");
  return;

 composite:
  { int i,j;
    q f = functor_of(x);
#ifdef GCDEBUG
    fprintf(stream, " %x", x);
#endif
    if (isatomic(f)) {
      fprintf(stream, "%s(",functoratomname(f));
      if(depth == 0) {
	fprintf(stream, "..)");
	return;
      }
      for (i = 0; i < arityof(f)-1; i++) {
	fprint_partially(stream, arg(x,i), depth-1, length);
	fprintf(stream, ",");
	if(i>length){
	  fprintf(stream, "..");
	  goto funct_tail;
	}
      }
      fprint_partially(stream, arg(x,arityof(f)-1), depth-1, length);
    funct_tail:
      fprintf(stream, ")");
    }else if(isref(f)){
      generic_print(((struct data_object *)(functorp(x))),
		    stream, depth, length);
    } else {
      fprintf(stderr, "Invalid functor : %x\n", f);
    }
  }

  return;
}

fprint(stream, x)
     FILE *stream;
     q x;
{
  fprint_partially(stream, x, (unsigned long)-1, (unsigned long)-1);
}
     
print(x)
  q x;
{
  fprint_partially(stdout, x, (unsigned long)-1, (unsigned long)-1);
}

void printl(x)
q x;
{
  print(x);
  putc('\n',stdout);
}

void *module_print();
struct predicate predicate_print_xprint_1 = { module_print, 0, 1 };

void *module_print(glbl, qp, allocp, fg, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     struct goalrec *fg;
     q *allocp;
     Const struct predicate *toppred;
{
  q reason;
  q a0;

 module_top:
  a0 = qp->args[0];
  print(a0);
  putc('\n',stdout);
}

general_print(a, stream, depth, length)
     q *a;
     FILE *stream;
     unsigned long depth, length;
{
  fprint_partially(stream, a, depth, length);
}
