/* ----------------------------------------------------------
%   (C)1993 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/timing.h>
#include <stdio.h>
#include <klic/functorstuffs.h>
#include <klic/gcdebug.h>
#include <klic/schedule.h>
#include <klic/gobj.h>
struct goalrec *temporary_queue = 0;

extern struct goalrec goal_queue_tail;
int copying_below = 1;

extern void *malloc(), *realloc();


q *gc(qp, allocp)
     struct goalrec *qp;
     q *allocp;
{
  struct global_variables *glbl = &globals;
  timerstruct before, after;

#ifdef TRACE
  extern int trace_flag;
  extern struct goalrec *trace_after();
#endif

if (temporary_queue) {
  struct goalrec *lastgoal = temporary_queue,
                 *nextgoal = temporary_queue->next;
  while (nextgoal) {
    lastgoal = nextgoal;
    nextgoal = lastgoal->next;
  }
  lastgoal->next = qp;
  qp = temporary_queue;
  temporary_queue = 0;
  /* heaplimit = real_heaplimit; */
}

#ifdef TRACE
  if (trace_flag) {
    qp = trace_after(qp, allocp);
  } else {
    heapp = allocp;
  }
#else
  heapp = allocp;
#endif
  /* priority support */
  if (higher_priority_goal) {
    struct goalrec *tmpq;
    put_priority_queue(qp, current_prio);
    qp = get_top_priority_queue();
    heaplimit = real_heaplimit;
  }
  if (heapp >= heaplimit) {
    static struct goalrec *collect_garbage();
#ifdef GCDEBUG
    fprintf(stderr, "before GC\n");
    dump_queue(qp);
#endif
    if (measure_gc) measure(before);
    qp = collect_garbage(qp);
#ifdef GCDEBUG
    fprintf(stderr, "heaplimit : %x\nheapp : %x\n", heaplimit, heapp);
#endif
    if (heaplimit < heapp) {
      fatal("Not enough space collected");
    }
    copying_below ^= 1;
    gctimes++;
    if (measure_gc) {
      measure(after);
#ifdef SYSV
      gcums += (int) tick2msec(field_diff(tms_utime));
      gcsms += (int) tick2msec(field_diff(tms_stime));
#else SYSV
      gcums += diff_usec(ru_utime)/1000;
      gcsms += diff_usec(ru_stime)/1000;
#endif SYSV
    }
#ifdef GCDEBUG
    fprintf(stderr, "after GC\n");
    dump_queue(qp);
#endif
  }
  queue = qp;
  return heapp;
}

/*static*/ q**
make_larger_stack(sp)
     q**sp;
{
  struct global_variables *glbl = &globals;
  q **newstack;
  gcstack_size *= 2;
  newstack = (q**)realloc(gcstack, gcstack_size*sizeof(q*));
  sp = newstack+(sp-gcstack);
  gcstack = newstack;
  gcmax = newstack+gcstack_size;
  return sp;
}

#define within_new_space(x)	\
( (unsigned long)(x) - (unsigned long)ntop < hsize)

#define within_old_space(x)	\
( (unsigned long)(x) - (unsigned long)otop < hsize)

#define push_gc_stack(addr, sp, max)			\
{							\
  if ((sp) == max) {					\
    (sp) = make_larger_stack(sp);			\
    max = gcmax;					\
  }							\
  *(sp)++ = (addr);					\
}

#define reserve_copy(from, to, sp, max)			\
if (from == makeref(&from)) {				\
  to = from = makeref(&to);				\
} else {						\
  to = from;						\
  if (!isatomic(from) && within_old_space(from)) {	\
    from = makeref(&to);				\
    push_gc_stack(&to, sp, max);			\
  }							\
}

#define copy_one_goal(goal, sp, max)			\
{							\
  struct goalrec *og=(goal);				\
  if (og->pred != 0) {					\
    int n = (og)->pred->arity;				\
    struct goalrec *ng = (struct goalrec *)hp;		\
    hp += n + 2;					\
    ng->next = og->next;				\
    og->next = ng;					\
    ng->pred = og->pred;				\
    og->pred = 0;					\
    while (--n >= 0) {					\
      reserve_copy(og->args[n], ng->args[n], (sp), (max)); \
    }							\
    (goal) = ng;					\
  } else {						\
    (goal) = og->next;					\
  }							\
}

static q *
copy_terms(hp, ntop, otop, hsize, sp, max)
     q *hp;
     q *ntop, *otop;
     unsigned long hsize;
     q **sp, **max;
{
  struct global_variables *glbl = &globals;
  while (sp > gcstack) {
    q *addr = *--sp;
    q obj = *addr;
  loop:
    switch (ptagof(obj)) {
    case ATOMIC:
      *addr = obj;
      break;
    case VARREF:
      {
	q value;
      deref:
	value = derefone(obj);
	switch (ptagof(value)) {
	case VARREF:
	  if (value == obj) {
	    *addr = derefone(obj) = *hp = makeref(hp);
	    hp++;
	  } else if (derefone(value) == obj) {
	    struct susprec *s = suspp(value);
	    q *newref = hp++;
	    q *hook = (q*)getnexthook(s);
	    q *hooktop = (q*)s;
	    *newref = makeref(s);
	    *addr = s->marker = derefone(obj) = makeref(newref);
	    do {
	      switch (hooktag(hook)) {
	      case SSUSP:
	      case MSUSP:
		copy_one_goal(((struct shook *)hook)->goals, sp, max);
		break;
	      case GOBJ: {
		struct consumer_object *obj =
		  (struct consumer_object *)(((struct mhook *)hook)->goals);
		q func = *(q*)obj;
		if(isstruct(func)) {
		  /* this object has been already copied */
		  ((struct mhook *)hook)->goals =
		    (struct goalrec *)functorp(func);
		} else {
		  q *newobj = generic_gc(obj, hp, sp);
		  sp = gcsp;
		  hp = heapp;
		  *(q*)obj = makefunctor(newobj);
		  ((struct mhook *)hook)->goals = (struct goalrec *)newobj;
		}
		break;
	      }
	      default:
		fprintf(stderr, "GC doesn't know this hook tag : %x",
			hooktag(hook));
	      }
	      hook = getnexthook(hook);
	    } while (hook != hooktop);
	  } else if (within_old_space(value)) {
	    obj = value;
	    goto deref;
	  } else {
	    *addr = value;
	  }
	  break;
	case CONS:
	  if (within_new_space(value)) {
	    *addr = makeref(&cdr_of(value));
	  } else {
	    obj = value;
	    goto cons_case;
	  }
	  break;
	case ATOMIC:
	  *addr = value;
	  break;
	default: /* FUNCTOR */
	  obj = value;
	  goto functor_case;
	}
      }
      break;
    case CONS:
    cons_case:
      if (within_old_space(obj)) {
	q cdr = cdr_of(obj);
	if (!isstruct(cdr) || !within_new_space(cdr)) {
	  q newcons = makecons(hp);
	  hp += 2;
	  reserve_copy(car_of(obj), car_of(newcons), sp, max);
	  *addr = cdr_of(obj) = newcons;
	  if (isatomic(cdr)) {
	    cdr_of(newcons) = cdr;
	  } else {
	    if (cdr == makeref(&cdr_of(obj))) {
	      cdr_of(newcons) = makeref(&cdr_of(newcons));
	    } else {
	      addr = &cdr_of(newcons);
	      obj = cdr;
	      goto loop;
	    }
	  }
	} else {
	  *addr = cdr;
	}
      } else {
	*addr = obj;
      }
      break;
    default: /* FUNCTOR */
    functor_case:
      if (within_old_space(obj)) {
	q f = functor_of(obj);
	if(!isstruct(f)){
	  if(isref(f)) {
	    struct data_object *oldobj
	      = (struct data_object *)functorp(obj);
	    q *newobj;
	    newobj = generic_gc(oldobj, hp, sp);
	    sp = gcsp;
	    hp = heapp;
	    *addr = functor_of(obj) = makefunctor(newobj);
	    break;
	  }
	  {
	    q newfunct = makefunctor(hp);
	    int k = arityof(f);
	    q x;
	    hp += k+1;
	    *addr = functor_of(obj) = newfunct;
	    functor_of(newfunct) = f;
	    while (--k >= 0) {
	      reserve_copy(arg(obj,k), arg(newfunct,k), sp, max);
	    }
	  }
	} else {
	  *addr = f;
	}
      } else {
	*addr = obj;
      }
      break;
    }
  }
  gcsp = sp;
  return hp;
}

struct goalrec *copy_one_queue(qp, hp, ntop, otop, hsize)
     struct goalrec *qp;
     q *hp;
     q *ntop, *otop;
     unsigned long hsize;
{
  struct global_variables *glbl = &globals;
  struct goalrec *last, *next;

  /* Copy queue in reverse order */
  /* By this, variables will have better chance to be allocated */
  /* within the goal records or structures that'll be read after */
  /* their instantiation */

  /* First, reverse the goal queue */
  for (last=0; qp!=&goal_queue_tail; last=qp, qp=next) {
    next = qp->next;
    qp->next = last;
  }
  /* Then copy and rearrange the goal queue */
  qp = last;
  last = &goal_queue_tail;
  for (; qp != 0; qp=next) {
    next=qp->next;
    copy_one_goal(qp, gcsp, gcmax);
    hp = copy_terms(hp, ntop, otop, hsize, gcsp, gcmax);
    qp->next = last;
    last = qp;
  }
  heapp = hp;
  return last;
}

static struct goalrec *collect_garbage(qp)
     struct goalrec *qp;
{
  struct global_variables *glbl = &globals;
  struct prioqrec *pq = prioq.next;
  q *ntop, *otop;
  unsigned long hsize;

  if (gctimes==0) {
    /* allocate GC stack on first GC */
    gcstack_size = GCSTACKSIZE;
    gcstack = (q**)malloc(gcstack_size*sizeof(q*));
    gcsp = gcstack;
    gcmax = gcstack+gcstack_size;
  }
  hsize = halfheapsize;
  if (copying_below) {
    otop = heaptop;
    ntop = (q*)((long)heaptop+(long)hsize);
  } else {
    ntop = heaptop;
    otop = (q*)((long)heaptop+(long)hsize);
  }
  new_space_top = heapp = ntop;
  old_space_top = otop;
  heaplimit = real_heaplimit = heapp+heapsize;
  heapend = heapbottom = heaplimit+incrementsize;

  for(; pq->prio >= 0; pq = pq->next) {
    pq->q = copy_one_queue(pq->q, heapp, ntop, otop, hsize);
  }
  return copy_one_queue(qp, heapp, ntop, otop, hsize);
}


/*
  for generic object
*/
q
general_gc(term, allocp, sp)
     q *term;
     q *allocp;
     q **sp;
{
  struct global_variables *glbl = &globals;
  push_gc_stack(term, sp, gcmax);
  heapp = copy_terms(/*heapp*/allocp, new_space_top, old_space_top,
		     halfheapsize, sp, gcmax);
  return *term;
}
