#include <stdio.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

struct vector_object {
  struct data_object_method_table *method_table;
  unsigned long size;
  q body[1];
};

#define GD_CLASS_NAME() vector
#define GD_OBJ_TYPE struct vector_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE)+(obj->size)-1)


#include <klic/gd_macro.h>

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_GUNIFY_FAIL;
  if (GD_SELF->size != GD_OTHER->size)  GD_GUNIFY_FAIL;
  {
    long i, size = GD_SELF->size;
    q retval;

    for(i=0; i<size; i++){
      retval = GD_GUNIFY(GD_SELF->body[i],GD_OTHER->body[i]);
      switch((long)retval){
      case GD_GSUCCESS:
	break;
      case GD_GFAILURE:
	GD_GUNIFY_FAIL;
        break;
      default:
	GD_GRETURN(retval);
      }
    }
    GD_GSUCCEED;
  }
}


GDDEF_UNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table)
    GD_UNIFY_FAIL;
  if (GD_SELF->size != GD_OTHER->size)
    GD_UNIFY_FAIL;
  {
    long i, size = GD_SELF->size;
    
    for(i=0; i<size; ++i){
      GD_UNIFY(GD_SELF->body[i], GD_OTHER->body[i]);
    }
    GD_RETURN;
  }
}

GDDEF_GC()
{
  G_STD_DECL;
  long size = GD_SELF->size;
  GD_OBJ_TYPE *newself;
  int i;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->size = size;
  for (i = 0; i < size; i++) {
    GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->body[i],newself->body[i]); /**/
  }
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(element_2)
{
  G_STD_DECL;
  long position;
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->size);
  GD_UNIFY( GD_ARGV[1], GD_SELF->body[position]);
  GD_RETURN;
}

GDDEF_METHOD(set__element_3)
{
  G_STD_DECL;
  long position;
  int i;

  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->size);
  {
    GD_OBJ_TYPE *newvect;
    long size = GD_SELF->size;

    GDSET_NEWOBJ(newvect);
    newvect->size = size;
    for (i=0; i < size; i++) {
      newvect->body[i] = GD_SELF->body[i];
    }
    newvect->body[position] = GD_ARGV[1];
    GD_UNIFY(GD_ARGV[2],GD_OBJ(newvect));
  }
  GD_RETURN;
}


GDDEF_METHOD(set__element_4)
{
  G_STD_DECL;
  long position;
  int i;

  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->size);
  {
    GD_OBJ_TYPE *newvect;
    long size = GD_SELF->size;

    GDSET_NEWOBJ(newvect);
    newvect->size = size;
    for (i=0; i < size; i++) {
      newvect->body[i] = GD_SELF->body[i];
    }
    newvect->body[position] = GD_ARGV[2];
    GD_UNIFY(GD_ARGV[1],GD_SELF->body[position]);
    GD_UNIFY(GD_ARGV[3],GD_OBJ(newvect));
  }
  GD_RETURN;
}


/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_METHOD{
    GD_METHOD_CASE(element_2);
    GD_METHOD_CASE(set__element_3);
    GD_METHOD_CASE(set__element_4);
    GD_METHOD_CASE_DEFAULT;
  }
  GD_RETURN;
}

/* guard generic methods */

GDDEF_GMETHOD(element_2)
{
  G_STD_DECL;
  unsigned long position;

  GDSET_GINTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->size);
  GD_ARGV[1] = GD_SELF->body[position];
  GD_GSUCCEED;
}

GDDEF_GMETHOD(vector_1)
{
  G_STD_DECL;
  unsigned long position;
  GD_ARGV[0] = G_MAKEINT(GD_SELF->size);
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;
  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(element_2);
    GD_GMETHOD_CASE(vector_1);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  long size = GD_SELF->size;
  GD_PRINT("{");
  GD_PRINT_KL1_TERMS(GD_SELF,2,size);
  GD_PRINT("}");
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

/* define the method table structure of the vector */

#include <klic/gd_method_table.h>

/*  new_vector function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  long size;

  GDSET_INTARG_FOR_NEW(size,GD_ARGV[0]);
  if (size < 0)  GD_FAIL("2nd argument is out of range in new_vector.");
  {
    GD_OBJ_TYPE *newvect;
    GDSET_NEWOBJ_FOR_NEW(newvect,G_SIZE_IN_Q(GD_OBJ_TYPE)+(size-1));
    newvect->size = size;
    { int i;
      if (GD_ARGC == 1) {
       for(i=0; i<size; i++){
         newvect->body[i] = G_MAKEINT(0L);
       }
     } else {
       q tmp = GD_ARGV[1];
       for(i=0; i<size; i++, tmp = G_CDR_OF(tmp)){
         newvect->body[i] = G_CAR_OF(tmp);
       }
     }
    }
    GD_RETURN_FROM_NEW(newvect);
  }
}
