/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/timing.h>
#include <klic/gb.h>
#include <stdio.h>

timerstruct before, after;

void *module_builtin();
Const struct predicate predicate_builtin_xprint_1 = { module_builtin, 0, 1};
Const struct predicate predicate_builtin_xreadint_1 = { module_builtin, 1, 1};
Const struct predicate predicate_builtin_xstart__measure_0
  = {module_builtin, 2, 0};
Const struct predicate predicate_builtin_xreport__measure_1
  = {module_builtin, 3, 1};
Const struct predicate predicate_builtin_xprint_2 = {module_builtin, 4, 2};
Const struct predicate predicate_builtin_xputc_2 = {module_builtin, 5, 2};

void *module_builtin(glbl, qp, allocp, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  q *allocp;
  Const struct predicate *toppred;
{
  q a0, a1, a2;
  q *reasonp;
 module_top:
  switch_on_pred() {
    case_pred(0, print_1_top);
    case_pred(1, readint_1_top);
    case_pred(2, start_measure_0_top);
    case_pred(3, report_measure_0_top);
    case_pred(4, print_2_top);
    last_case_pred(5, putc_2_top);
  }

 print_1_top:
  {
    extern print();
    a0 = qp->args[0];
    qp = qp->next;
    print(a0);
    putc('\n', stdout);
    proceed();
  }

 print_2_top:
  {
    extern print();
    a0 = qp->args[0];
    a1 = qp->args[1];
    print(a0);
    unify_value(a1, NILATOM, qp->next);
    proceed();
  }

  putc_2_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    putc(intval(a0), stdout);
    unify_value(a1, NILATOM, qp->next);
    proceed();
  }

 readint_1_top:
  {
    int n;
    int c;
    q x0;
    a0 = qp->args[0];
    qp = qp->next;
    fprintf(stdout, "> ");
    fscanf(stdin, "%d", &n);
    do {
      c = getchar();
    } while (c != '\n' && c != -1);
    x0 = makeint(n);
    unify(a0, x0, qp);
    proceed();
  }
    
 start_measure_0_top:
  {
    qp = qp->next;
    measure(before);
    proceed();
  }
 report_measure_0_top:
  {
    q x0;
    a0 = qp->args[0];
    qp = qp->next;
    measure(after);
    printf("heap size = %d words\n", heapsize);
    {
#ifdef SYSV
      long u_msec = (int) tick2msec(field_diff(tms_utime));
      long s_msec = (int) tick2msec(field_diff(tms_stime));
      long t_msec =
	(int) (tick2msec(field_diff(tms_utime)) +
	       tick2msec(field_diff(tms_stime)));
      x0 = makeint(t_msec);
      printf("%d ms total; %d user; %d system\n",
	     t_msec, u_msec, s_msec);
#else SYSV
      long u_usec = diff_usec(ru_utime);
      long s_usec = diff_usec(ru_stime);
      long t_usec = u_usec + s_usec;
      long swaps = field_diff(ru_nswap);
      long minflt = field_diff(ru_minflt);
      long majflt = field_diff(ru_majflt);
      long inblock = field_diff(ru_inblock);
      long outblock = field_diff(ru_oublock);
      long nvcsw = field_diff(ru_nvcsw);
      long nivcsw = field_diff(ru_nivcsw);
      x0 = makeint(t_usec/1000);
      printf("%d ms total; %d user; %d system\n",
	     t_usec/1000, u_usec/1000, s_usec/1000);
      printf("  %d swaps; %d minor page faults; %d major page faults\n",
	     swaps, minflt, majflt);
      printf("  %d block input; %d block output\n",
	     inblock, outblock);
      printf("  %d context switches (%d voluntary)\n",
	     nvcsw+nivcsw, nvcsw);
#endif
      printf("  ");
      if (measure_gc) {
	printf("%d ms utime & %d ms stime in ",
	       gcums, gcsms);
      }
      printf("%d GC\n", gctimes);
#ifdef CSUSPS
      printf("  %d suspensions; %d resumptions\n",
	     suspensions, resumes);
#endif
    }
    unify(a0, x0, qp);
    proceed();
  }
 proceed_label:
 proceed_after_interrupt:
  loop_within_module(module_builtin);
}
